/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.chunkupload.utility;

import it.sogei.rcp.chunkupload.model.OpzioniChunkUploadBean;
import it.sogei.utilities.log4j.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;

public class ChunkUploadUtility {
    private Properties prop = null;
    private OpzioniChunkUploadBean opzioni = new OpzioniChunkUploadBean();
    int esito;
    private static boolean ambienteRSA = false;
    private static final String DEFAULT_BASE_URL = "/";
    private int debug = 1;
    private int debuglevel = 1;

    public boolean creaOpzioniDaProperties(Properties propertiesFile) {
        boolean ok = true;
        this.prop = propertiesFile;
        if (this.prop == null) {
            ok = false;
        }
        if (ok) {
            String[] filestype = null;
            try {
                if (!this.prop.entrySet().isEmpty()) {
                    if (this.prop.getProperty("debug") != null) {
                        this.opzioni.setDebug(Integer.parseInt(this.prop.getProperty("debug")));
                    } else {
                        this.setDebug(this.debug);
                    }
                    if ((this.prop.getProperty("url") == null || this.prop.getProperty("url").trim().equals("")) && this.prop.getProperty("servlet").toLowerCase().equals("y")) {
                        ok = false;
                    } else {
                        if (this.prop.getProperty("url") == null || this.prop.getProperty("url").trim().equals("")) {
                            this.opzioni.setUploadUrl(this.getBaseUrl());
                        } else if (this.prop.getProperty("url").indexOf("http:") == -1 && this.prop.getProperty("url").indexOf("https:") == -1) {
                            this.opzioni.setUploadUrl(this.getBaseUrl().concat(this.normalizzaUrl(this.prop.getProperty("url"))));
                        } else {
                            this.opzioni.setUploadUrl(this.prop.getProperty("url").trim());
                        }
                        if (this.prop.getProperty("max_upload") != null) {
                            this.opzioni.setMax_upload(Long.parseLong(this.prop.getProperty("max_upload").trim()));
                        }
                        if (this.prop.getProperty("max_file") != null) {
                            this.opzioni.setMax_file(Long.parseLong(this.prop.getProperty("max_file").trim()));
                        }
                        if (this.prop.getProperty("monitor_keep_visible") != null) {
                            this.opzioni.setMonitor_keep_visible(this.prop.getProperty("monitor_keep_visible").toLowerCase());
                        }
                        if (this.prop.getProperty("chunk_size") != null) {
                            this.opzioni.setChunk_size(Integer.parseInt(this.prop.getProperty("chunk_size").trim()));
                        }
                        if (this.prop.getProperty("debuglevel") != null) {
                            this.opzioni.setDebuglevel(Integer.parseInt(this.prop.getProperty("debuglevel").trim()));
                        } else {
                            this.opzioni.setDebuglevel(this.debuglevel);
                        }
                        if (this.prop.getProperty("method") != null) {
                            this.opzioni.setMethod(this.prop.getProperty("method").toUpperCase());
                        }
                        if (this.prop.getProperty("multiselection") != null) {
                            this.opzioni.setMultiselection(Integer.parseInt(this.prop.getProperty("multiselection").trim()));
                        }
                        if (this.prop.getProperty("multithread") != null) {
                            this.opzioni.setMultithread(Integer.parseInt(this.prop.getProperty("multithread").trim()));
                        } else {
                            this.opzioni.setMultithread(0);
                        }
                        if (this.prop.getProperty("num_invii") != null) {
                            this.opzioni.setNum_invii(Integer.parseInt(this.prop.getProperty("num_invii").trim()));
                        } else {
                            this.opzioni.setNum_invii(0);
                        }
                        if (this.prop.getProperty("autoredirect") != null) {
                            this.opzioni.setAutoRedirect(Integer.parseInt(this.prop.getProperty("autoredirect").trim()));
                        } else {
                            this.opzioni.setAutoRedirect(0);
                        }
                        if (this.prop.getProperty("dir") != null) {
                            this.opzioni.setDir(Integer.parseInt(this.prop.getProperty("dir").trim()));
                        }
                        if (this.prop.getProperty("includesubdir") != null) {
                            this.opzioni.setIncludesubdir(Integer.parseInt(this.prop.getProperty("includesubdir").trim()));
                        }
                        if (this.prop.getProperty("compression") != null) {
                            this.opzioni.setCompression(this.prop.getProperty("compression").trim().charAt(0));
                        }
                        if (this.prop.getProperty("encrypt") != null) {
                            this.opzioni.setEncrypt(this.prop.getProperty("encrypt").trim().charAt(0));
                        }
                        if (this.prop.getProperty("servlet") != null) {
                            this.opzioni.setServlet(this.prop.getProperty("servlet").trim().charAt(0));
                        }
                        if (this.prop.getProperty("filestype") != null) {
                            StringTokenizer strtoken = new StringTokenizer(this.prop.getProperty("filestype"), " ");
                            int cont = 0;
                            filestype = new String[strtoken.countTokens()];
                            while (strtoken.hasMoreElements()) {
                                filestype[cont] = (String)strtoken.nextElement();
                                ++cont;
                            }
                        }
                        this.opzioni.setFilestype(filestype);
                        if (this.prop.getProperty("size_exceeded") != null) {
                            this.opzioni.setSize_exceeded(this.prop.getProperty("size_exceeded"));
                        }
                    }
                    if (this.opzioni.getDebug() > 0) {
                        Enumeration<Object> key = this.prop.keys();
                        Enumeration<Object> values = this.prop.elements();
                        int cont = 0;
                        while (key.hasMoreElements()) {
                            LogUtil.log((String)"it.sogei.rcp.chunkupload ", (int)1, (String)(String.valueOf(cont++) + "-" + key.nextElement() + ":" + values.nextElement()));
                        }
                    }
                } else {
                    ok = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ok = false;
            }
        }
        return ok;
    }

    private String normalizzaUrl(String path) {
        if (path != null) {
            path = path.replace('\\', '/');
            while (path.startsWith(DEFAULT_BASE_URL)) {
                path = path.substring(1);
            }
            while (path.endsWith(DEFAULT_BASE_URL)) {
                path = path.substring(0, path.length() - 1);
            }
            path = path.replace("//", DEFAULT_BASE_URL);
        }
        return path;
    }

    public void setDebug(int mod) {
        this.opzioni.setDebug(mod);
    }

    public Properties downloadPropertiesFile(String propertiesFileUrl) throws IOException {
        Properties prop = null;
        InputStream inputStream = null;
        URL url = null;
        try {
            try {
                if (ambienteRSA) {
                    url = new URL("http://localhost:8081/ChunkUploadNewWeb/chunkupload.properties");
                    inputStream = url.openStream();
                    prop = new Properties();
                    prop.load(inputStream);
                } else if (propertiesFileUrl != null && !propertiesFileUrl.equals("")) {
                    url = new URL(propertiesFileUrl);
                    inputStream = url.openStream();
                    prop = new Properties();
                    prop.load(inputStream);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new IOException(ioe.getMessage());
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return prop;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void setProperties(Properties prop) {
        this.prop = prop;
    }

    public OpzioniChunkUploadBean getOpzioni() {
        return this.opzioni;
    }

    public void setOpzioni(OpzioniChunkUploadBean opzioni) {
        this.opzioni = opzioni;
    }

    public int getEsito() {
        return this.esito;
    }

    private String getBaseUrl() {
        String baseUrl = "";
        baseUrl = baseUrl.concat(DEFAULT_BASE_URL);
        return baseUrl;
    }

    public static String getBasicAutToken(String user, String password) {
        String author = String.valueOf(user) + ":" + password;
        String base64 = new String(Base64.encodeBase64((byte[])author.getBytes()));
        return "Basic " + base64;
    }
}

