/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.dt.patch;

import it.sogei.dt.patch.OSFinder;
import it.sogei.dt.patch.PatchUtils;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;

public class PatchLauncher {
    public static void main(String[] args) {
        try {
            new PatchLauncher().sslFix();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sslFix() throws Exception {
        System.err.println("INIZIO SSLFIX 2");
        if (!this.shouldApplySSLPatch()) {
            System.out.println("patch ssl gi\u00e0 eseguita");
            return;
        }
        String caPath = String.valueOf(PatchUtils.getJrePath()) + File.separator + "lib" + File.separator + "security";
        PatchUtils.exportResource("/it/sogei/dt/patch/cacerts.zip", caPath);
        String path = String.valueOf(PatchUtils.getBasePath()) + File.separator + "DesktopTelematico.ini";
        PatchUtils.addMissingJvmArgs(path);
        PatchUtils.replaceUpdateSiteUrl(PatchUtils.getBasePath());
        System.out.println("patch ssl eseguita con successo");
    }

    public void macFix() throws Exception {
        if (this.shouldApplyBigFixPatch()) {
            System.out.println("applicazione patch in corso");
            System.out.println("percorso Info.plist: " + System.getProperty("user.dir"));
            System.out.println("file.separator: " + File.separator);
            String filePath = String.valueOf(System.getProperty("user.dir")) + File.separator + ".." + File.separator + "Info.plist";
            System.out.println("percorso Info.plist: " + filePath);
            this.replaceFile(filePath);
        } else {
            System.out.println("il sistema operativo non necessita di patch");
        }
    }

    private boolean shouldApplySSLPatch() {
        return true;
    }

    private boolean shouldApplyBigFixPatch() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        System.out.println("OS RILEVATO: " + name + " Versione " + version);
        if (!OSFinder.isMac()) {
            return false;
        }
        ComparableVersion currentOSVersion = new ComparableVersion(version);
        ComparableVersion targetMacOsVersione = new ComparableVersion("10.16");
        return currentOSVersion.compareTo(targetMacOsVersione) >= 0;
    }

    private void replaceFile(String filePath) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder newDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = newDocumentBuilder.parse(filePath);
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList nodes = (NodeList)xpath.evaluate("//dict", doc, XPathConstants.NODESET);
        NodeList keyValueNodes = nodes.item(0).getChildNodes();
        int idx = 0;
        while (idx < keyValueNodes.getLength()) {
            if ("CFBundleIdentifier".equals(keyValueNodes.item(idx).getTextContent())) {
                int i = 1;
                while ("#text".equals(keyValueNodes.item(idx + i).getNodeName())) {
                    ++i;
                }
                keyValueNodes.item(idx + i).setTextContent("org.eclipse.eclipse");
                break;
            }
            ++idx;
        }
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMImplementation domImpl = doc.getImplementation();
        doc.setXmlStandalone(true);
        DocumentType doctype = domImpl.createDocumentType("doctype", "-//Apple Computer//DTD PLIST 1.0//EN", "http://www.apple.com/DTDs/PropertyList-1.0.dtd");
        xformer.setOutputProperty("doctype-public", doctype.getPublicId());
        xformer.setOutputProperty("doctype-system", doctype.getSystemId());
        xformer.transform(new DOMSource(doc), new StreamResult(new File(filePath)));
    }
}

