/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.DESedeCrypt;
import com.sun.crypto.provider.RC2Crypt;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SymmetricCipher;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class PKCS12PBECipherCore {
    private CipherCore cipher;
    private int blockSize;
    private int keySize;
    private String algo = null;
    private byte[] salt = null;
    private int iCount = 0;
    private static final int DEFAULT_SALT_LENGTH = 20;
    private static final int DEFAULT_COUNT = 1024;
    static final int CIPHER_KEY = 1;
    static final int CIPHER_IV = 2;
    static final int MAC_KEY = 3;

    static byte[] derive(char[] cArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = cArray.length * 2;
        if (n4 != 0) {
            n4 += 2;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < cArray.length) {
            byArray2[n6] = (byte)(cArray[n5] >>> 8 & 0xFF);
            byArray2[n6 + 1] = (byte)(cArray[n5] & 0xFF);
            ++n5;
            n6 += 2;
        }
        n5 = 64;
        n6 = 20;
        int n7 = PKCS12PBECipherCore.roundup(n2, n6) / n6;
        byte[] byArray3 = new byte[n5];
        int n8 = PKCS12PBECipherCore.roundup(byArray.length, n5);
        int n9 = PKCS12PBECipherCore.roundup(byArray2.length, n5);
        byte[] byArray4 = new byte[n8 + n9];
        byte[] byArray5 = new byte[n2];
        Arrays.fill(byArray3, (byte)n3);
        PKCS12PBECipherCore.concat(byArray, byArray4, 0, n8);
        PKCS12PBECipherCore.concat(byArray2, byArray4, n8, n9);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray6 = new byte[n5];
            byte[] byArray7 = new byte[n5];
            int n10 = 0;
            while (true) {
                messageDigest.update(byArray3);
                messageDigest.update(byArray4);
                byte[] byArray8 = messageDigest.digest();
                for (int i = 1; i < n; ++i) {
                    byArray8 = messageDigest.digest(byArray8);
                }
                System.arraycopy(byArray8, 0, byArray5, n6 * n10, Math.min(n2, n6));
                if (n10 + 1 != n7) {
                    PKCS12PBECipherCore.concat(byArray8, byArray6, 0, byArray6.length);
                    BigInteger bigInteger = new BigInteger(1, byArray6).add(BigInteger.ONE);
                    for (int i = 0; i < byArray4.length; i += n5) {
                        if (byArray7.length != n5) {
                            byArray7 = new byte[n5];
                        }
                        System.arraycopy(byArray4, i, byArray7, 0, n5);
                        BigInteger bigInteger2 = new BigInteger(1, byArray7);
                        bigInteger2 = bigInteger2.add(bigInteger);
                        byArray7 = bigInteger2.toByteArray();
                        int n11 = byArray7.length - n5;
                        if (n11 >= 0) {
                            System.arraycopy(byArray7, n11, byArray4, i, n5);
                            continue;
                        }
                        if (n11 >= 0) continue;
                        Arrays.fill(byArray4, i, i + -n11, (byte)0);
                        System.arraycopy(byArray7, 0, byArray4, i + -n11, byArray7.length);
                    }
                    ++n10;
                    n2 -= n6;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("internal error: " + exception);
        }
        return byArray5;
    }

    private static int roundup(int n, int n2) {
        return (n + (n2 - 1)) / n2 * n2;
    }

    private static void concat(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2 / byArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            System.arraycopy(byArray, 0, byArray2, n5 + n, byArray.length);
            ++n4;
            n5 += byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n5 + n, n2 - n5);
    }

    PKCS12PBECipherCore(String string, int n) throws NoSuchAlgorithmException {
        this.algo = string;
        SymmetricCipher symmetricCipher = null;
        if (this.algo.equals("DESede")) {
            symmetricCipher = new DESedeCrypt();
        } else if (this.algo.equals("RC2")) {
            symmetricCipher = new RC2Crypt();
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for PBEWithSHA1And" + this.algo);
        }
        this.blockSize = ((SymmetricCipher)symmetricCipher).getBlockSize();
        this.cipher = new CipherCore(symmetricCipher, this.blockSize);
        this.cipher.setMode("CBC");
        try {
            this.cipher.setPadding("PKCS5Padding");
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            // empty catch block
        }
        this.keySize = n;
    }

    void implSetMode(String string) throws NoSuchAlgorithmException {
        if (string != null && !string.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + string);
        }
    }

    void implSetPadding(String string) throws NoSuchPaddingException {
        if (string != null && !string.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + string);
        }
    }

    int implGetBlockSize() {
        return this.blockSize;
    }

    int implGetOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    byte[] implGetIV() {
        return this.cipher.getIV();
    }

    AlgorithmParameters implGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.salt == null) {
            this.salt = new byte[20];
            SunJCE.RANDOM.nextBytes(this.salt);
            this.iCount = 1024;
        }
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.iCount);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("PBEWithSHA1And" + (this.algo.equalsIgnoreCase("RC2") ? "RC2_40" : this.algo), "SunJCE");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("SunJCE provider is not configured properly");
        }
        try {
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return algorithmParameters;
    }

    void implInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        char[] cArray = null;
        this.salt = null;
        this.iCount = 0;
        if (key instanceof PBEKey) {
            object = (PBEKey)key;
            cArray = object.getPassword();
            this.salt = object.getSalt();
            this.iCount = object.getIterationCount();
        } else if (key instanceof SecretKey) {
            object = key.getEncoded();
            if (object == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                throw new InvalidKeyException("Missing password");
            }
            cArray = new char[((Object)object).length];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(object[i] & 0x7F);
            }
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        if (!(n != 2 && n != 4 || algorithmParameterSpec != null || this.salt != null && this.iCount != 0)) {
            throw new InvalidAlgorithmParameterException("Parameters missing");
        }
        if (algorithmParameterSpec == null) {
            if (this.salt == null) {
                this.salt = new byte[20];
                if (secureRandom != null) {
                    secureRandom.nextBytes(this.salt);
                } else {
                    SunJCE.RANDOM.nextBytes(this.salt);
                }
            }
            if (this.iCount == 0) {
                this.iCount = 1024;
            }
        } else {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
            }
            object = (PBEParameterSpec)algorithmParameterSpec;
            if (this.salt != null) {
                if (!Arrays.equals(this.salt, ((PBEParameterSpec)object).getSalt())) {
                    throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                }
            } else {
                this.salt = ((PBEParameterSpec)object).getSalt();
            }
            if (this.iCount != 0) {
                if (this.iCount != ((PBEParameterSpec)object).getIterationCount()) {
                    throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                }
            } else {
                this.iCount = ((PBEParameterSpec)object).getIterationCount();
            }
        }
        if (this.salt.length < 8) {
            throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
        }
        if (this.iCount <= 0) {
            throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
        }
        object = PKCS12PBECipherCore.derive(cArray, this.salt, this.iCount, this.keySize, 1);
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, this.algo);
        byte[] byArray = PKCS12PBECipherCore.derive(cArray, this.salt, this.iCount, 8, 2);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray, 0, 8);
        this.cipher.init(n, (Key)secretKeySpec, ivParameterSpec, secureRandom);
    }

    void implInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pBEParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                pBEParameterSpec = algorithmParameters.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("requires PBE parameters");
            }
        }
        this.implInit(n, key, pBEParameterSpec, secureRandom);
    }

    void implInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.implInit(n, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("requires PBE parameters");
        }
    }

    byte[] implUpdate(byte[] byArray, int n, int n2) {
        return this.cipher.update(byArray, n, n2);
    }

    int implUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.cipher.update(byArray, n, n2, byArray2, n3);
    }

    byte[] implDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2);
    }

    int implDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2, byArray2, n3);
    }

    int implGetKeySize(Key key) throws InvalidKeyException {
        return this.keySize;
    }

    byte[] implWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.cipher.wrap(key);
    }

    Key implUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.cipher.unwrap(byArray, string, n);
    }

    public static final class PBEWithSHA1AndRC2_40
    extends CipherSpi {
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("RC2", 5);

        @Override
        protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2);
        }

        @Override
        protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.core.implGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.core.implGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return this.core.implGetKeySize(key);
        }

        @Override
        protected int engineGetOutputSize(int n) {
            return this.core.implGetOutputSize(n);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameterSpec, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameters, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            this.core.implInit(n, key, secureRandom);
        }

        @Override
        protected void engineSetMode(String string) throws NoSuchAlgorithmException {
            this.core.implSetMode(string);
        }

        @Override
        protected void engineSetPadding(String string) throws NoSuchPaddingException {
            this.core.implSetPadding(string);
        }

        @Override
        protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.core.implUnwrap(byArray, string, n);
        }

        @Override
        protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
            return this.core.implUpdate(byArray, n, n2);
        }

        @Override
        protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
            return this.core.implUpdate(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.core.implWrap(key);
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends CipherSpi {
        private final PKCS12PBECipherCore core = new PKCS12PBECipherCore("DESede", 24);

        @Override
        protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2);
        }

        @Override
        protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
            return this.core.implDoFinal(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected int engineGetBlockSize() {
            return this.core.implGetBlockSize();
        }

        @Override
        protected byte[] engineGetIV() {
            return this.core.implGetIV();
        }

        @Override
        protected int engineGetKeySize(Key key) throws InvalidKeyException {
            return this.core.implGetKeySize(key);
        }

        @Override
        protected int engineGetOutputSize(int n) {
            return this.core.implGetOutputSize(n);
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            return this.core.implGetParameters();
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameterSpec, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.core.implInit(n, key, algorithmParameters, secureRandom);
        }

        @Override
        protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
            this.core.implInit(n, key, secureRandom);
        }

        @Override
        protected void engineSetMode(String string) throws NoSuchAlgorithmException {
            this.core.implSetMode(string);
        }

        @Override
        protected void engineSetPadding(String string) throws NoSuchPaddingException {
            this.core.implSetPadding(string);
        }

        @Override
        protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
            return this.core.implUnwrap(byArray, string, n);
        }

        @Override
        protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
            return this.core.implUpdate(byArray, n, n2);
        }

        @Override
        protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
            return this.core.implUpdate(byArray, n, n2, byArray2, n3);
        }

        @Override
        protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
            return this.core.implWrap(key);
        }
    }
}

