/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.controlli;

import finanze.IDTE.studi2002.calcolo.CalcoloAS;
import finanze.IDTE.studi2002.controlli.ControlloQuadroMultiplo;
import finanze.IDTE.studi2002.risorse.ServizioAnnotazioneSet;
import java.util.Hashtable;
import java.util.Vector;

public class ControlloUsoParametri1
extends ControlloQuadroMultiplo {
    private Hashtable codiciAttivita = null;

    protected ControlloUsoParametri1(String spec_line, Hashtable componentiModel, String nomeQuadro) {
        super(spec_line, componentiModel, nomeQuadro);
        ServizioAnnotazioneSet sas = new ServizioAnnotazioneSet();
        this.codiciAttivita = sas.getCodiciAttivita();
    }

    protected void creaMessaggioErrore() {
        this.messaggio = "-- In caso di codice attivita' con ricavi superiori al 20% dei ricavi dell'unita' operativa, utilizzare il prodotto Parametri, se applicabili.";
    }

    private int[] getIndiciCodiciAttivita() {
        Vector<Integer> v = new Vector<Integer>();
        int numeroQuadriMultipli = this.getNumeroQuadriMultipli();
        int i = 0;
        while (i < numeroQuadriMultipli) {
            String codice = this.getGericoModel(i, 2).getValue().toUpperCase();
            if (this.codiciAttivita.containsKey(codice) && !codice.equalsIgnoreCase("ricag") && (this.codiciAttivita.get(codice) == null || ((String)this.codiciAttivita.get(codice)).trim().length() <= 0)) {
                v.addElement(new Integer(i));
            }
            ++i;
        }
        int[] array = new int[v.size()];
        int i2 = 0;
        while (i2 < array.length) {
            array[i2] = (Integer)v.elementAt(i2);
            ++i2;
        }
        return array;
    }

    protected void impostaErrore() {
        this.gravitaErrore = "scarto_confermabile";
        this.errore = String.valueOf(this.codErrore);
    }

    public boolean verifica() {
        this.esito = true;
        this.getNumeroQuadriMultipli();
        double[][] marginali = CalcoloAS.getMarginali(this.getParametriMarginali());
        int[] indici = this.getIndiciCodiciAttivita();
        if (marginali == null) {
            this.esito = indici.length == 0;
        } else {
            int i = 0;
            while (i < indici.length && this.esito) {
                this.esito = false;
                double progressivo = new Double(this.getGericoModel(indici[i], 1).getValue());
                double ricavi = new Double(this.getGericoModel(indici[i], 3).getValue());
                int j = 0;
                while (j < marginali.length && !this.esito) {
                    this.esito = marginali[j][0] == progressivo && marginali[j][1] == ricavi;
                    ++j;
                }
                ++i;
            }
        }
        if (!this.esito) {
            this.impostaErrore();
            this.creaMessaggioErrore();
        }
        return this.esito;
    }
}

