/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.ecdsa;

import iaik.security.ecc.ECCException;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.ecdsa.ECPrivateKey;
import iaik.security.ecc.ecdsa.ECPublicKey;
import iaik.security.ecc.interfaces.ECDSAKeyPairGenerator;
import iaik.security.ecc.interfaces.ECDSAParams;
import iaik.security.ecc.math.ecgroup.CoordinateTypes;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.field.Constants;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class ECDSAKeyPairGeneratorImpl
extends KeyPairGenerator
implements ECDSAKeyPairGenerator {
    private SecureRandom random_;
    private ECDSAParameter parameter_;
    public static final int[] KEY_SIZES;
    public static final int DEFAULT_KEY_SIZE = 192;
    public static final String[] DEFAULT_CURVES;

    static {
        DEFAULT_CURVES = new String[]{"P-192", "P-224", "P-256", "P-384", "P-521"};
        KEY_SIZES = new int[]{192, 224, 256, 384, 521};
    }

    public void initialize(int n, SecureRandom secureRandom) {
        ECCParameterFactory eCCParameterFactory = ECCParameterFactory.getInstance();
        try {
            int n2 = 0;
            while (n2 < KEY_SIZES.length) {
                if (n <= KEY_SIZES[n2]) {
                    ECCParameterSpec eCCParameterSpec = eCCParameterFactory.getParameterByName(DEFAULT_CURVES[n2]);
                    if (eCCParameterSpec == null) {
                        throw new RuntimeException("Cannot get ecc parameters for " + DEFAULT_CURVES[n2]);
                    }
                    this.initialize(new ECDSAParameter(eCCParameterSpec, CoordinateTypes.getDefaultCoordinates(eCCParameterSpec.getA().getField().getFieldId())), secureRandom);
                    return;
                }
                ++n2;
            }
            ECCParameterSpec eCCParameterSpec = eCCParameterFactory.getParameterByName(DEFAULT_CURVES[DEFAULT_CURVES.length - 1]);
            if (eCCParameterSpec == null) {
                throw new RuntimeException("Cannot get ecc parameters for " + DEFAULT_CURVES[DEFAULT_CURVES.length - 1]);
            }
            this.initialize(new ECDSAParameter(eCCParameterSpec, CoordinateTypes.getDefaultCoordinates(eCCParameterSpec.getA().getField().getFieldId())), secureRandom);
        }
        catch (ECCException eCCException) {
            throw new RuntimeException("Keypairgenerator caused the following error" + eCCException);
        }
    }

    public synchronized void initialize(ECDSAParams eCDSAParams, SecureRandom secureRandom) {
        this.parameter_ = new ECDSAParameter(eCDSAParams);
        this.random_ = secureRandom == null ? SecRandom.getDefault() : secureRandom;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ECCParameterSpec)) {
            throw new InvalidAlgorithmParameterException("No ecc parameter spec");
        }
        try {
            ECCParameterSpec eCCParameterSpec = (ECCParameterSpec)algorithmParameterSpec;
            ECDSAParameter eCDSAParameter = new ECDSAParameter(eCCParameterSpec, CoordinateTypes.getDefaultCoordinates(eCCParameterSpec.getA().getField().getFieldId()));
            this.initialize(eCDSAParameter, null);
        }
        catch (ECCException eCCException) {
            throw new InvalidAlgorithmParameterException("invalid spec");
        }
    }

    public KeyPair generateKeyPair() {
        if (this.parameter_ == null) {
            this.initialize(192);
        }
        int n = this.parameter_.getR().bitLength();
        BigInteger bigInteger = new BigInteger(n, this.random_);
        BigInteger bigInteger2 = this.parameter_.getR().subtract(Constants.BIG_ONE);
        int n2 = bigInteger.compareTo(Constants.BIG_ONE);
        int n3 = bigInteger.compareTo(bigInteger2);
        while (n2 == -1 || n3 == 1) {
            bigInteger = new BigInteger(n, this.random_);
            n2 = bigInteger.compareTo(Constants.BIG_ONE);
            n3 = bigInteger.compareTo(bigInteger2);
        }
        ECPoint eCPoint = (ECPoint)this.parameter_.getG().clone();
        eCPoint.multiply(bigInteger);
        return new KeyPair(new ECPublicKey(this.parameter_, eCPoint), new ECPrivateKey(this.parameter_, bigInteger, eCPoint));
    }

    public ECDSAKeyPairGeneratorImpl() {
        super("ECDSA");
    }
}

