/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.CreateCert;
import demo.Demo;
import iaik.security.ecc.ECCException;
import iaik.security.ecc.ecdsa.ECDSAKeyPairGeneratorImpl;
import iaik.security.ecc.ecdsa.ECDSAParameter;
import iaik.security.ecc.parameter.ECCParameterFactory;
import iaik.security.ecc.spec.ECCParameterSpec;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;

public class RawECDSA
implements Demo {
    private static byte[] SIG_DATA;
    private static int KEY_SIZE;

    static {
        KEY_SIZE = 192;
        SIG_DATA = "Data to be signed".getBytes();
    }

    private KeyPair generateKeyPair(String string) throws ECCException, NoSuchAlgorithmException {
        ECCParameterFactory eCCParameterFactory = ECCParameterFactory.getInstance();
        ECCParameterSpec eCCParameterSpec = eCCParameterFactory.getParameterByName(string);
        ECDSAParameter eCDSAParameter = new ECDSAParameter(eCCParameterSpec);
        ECDSAKeyPairGeneratorImpl eCDSAKeyPairGeneratorImpl = (ECDSAKeyPairGeneratorImpl)KeyPairGenerator.getInstance("ECDSA");
        eCDSAKeyPairGeneratorImpl.initialize(eCDSAParameter, null);
        return eCDSAKeyPairGeneratorImpl.generateKeyPair();
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDSA");
        keyPairGenerator.initialize(KEY_SIZE);
        return keyPairGenerator.generateKeyPair();
    }

    public void signAndVerify(KeyPair keyPair) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        Signature signature = Signature.getInstance("RawECDSA");
        signature.initSign(keyPair.getPrivate());
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] byArray = messageDigest.digest(SIG_DATA);
        byArray = new byte[]{46, -9, -67, -26, 8, -50, 84, 4, -23, 125, 95, 4, 47, -107, -8, -97, 28, 35, 40, 113};
        signature.update(byArray);
        byte[] byArray2 = signature.sign();
        signature.initVerify(keyPair.getPublic());
        signature.update(byArray);
        if (!signature.verify(byArray2)) {
            System.out.println("Sig. validation failed");
            throw new RuntimeException("Sig. validation failed");
        }
        System.out.println("Sig. validation successful");
    }

    public boolean runDemo() {
        try {
            CreateCert.init();
            KeyPair keyPair = this.generateKeyPair("P-192");
            this.signAndVerify(keyPair);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static void main(String[] stringArray) {
        RawECDSA rawECDSA = new RawECDSA();
        if (rawECDSA.runDemo()) {
            System.out.println("FINISHED");
        } else {
            System.out.println("FAILED");
        }
    }
}

