/*
 * Decompiled with CFR 0.152.
 */
package iaik.iso.iso9796;

import iaik.iso.iso9796.ISO9796P2ParameterSpec;
import iaik.iso.iso9796.RawISO9796P2ParameterSpec;
import iaik.security.md.SHA;
import iaik.security.random.SecRandom;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;

public abstract class ISO9796P2Signature
extends Signature {
    protected SecureRandom secureRandom_;
    MessageDigest c;
    boolean a;
    boolean l;
    int d;
    int s;
    byte[] b;
    byte[] r;
    private BigInteger e;
    private BigInteger f;
    int g;
    int m;
    boolean k;
    byte h;
    int j;
    protected MessageDigest hashEngine_;
    static Hashtable i;
    static final byte v = 51;
    static final byte u = -52;
    static final byte t = -68;
    private static final BigInteger p;
    private static final BigInteger n;
    private static final byte q = 107;
    private static final byte o = 75;

    protected void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom_ = secureRandom;
    }

    void a(byte[] byArray, int n2, MessageDigest messageDigest) throws InvalidAlgorithmParameterException {
        if (messageDigest != null && this.l && !this.checkHashEngineName(messageDigest.getAlgorithm())) {
            throw new InvalidAlgorithmParameterException("Invalid hash engine parameter (" + messageDigest.getAlgorithm() + "). Expected " + this.hashEngine_.getAlgorithm() + ".");
        }
        this.d = n2;
        this.c = messageDigest;
        if (this.r == null) {
            this.b();
        }
        this.s = Math.min(this.r.length, byArray.length);
        System.arraycopy(byArray, 0, this.r, 0, this.s);
    }

    protected void reset(BigInteger bigInteger) {
        if (this.hashEngine_ != null) {
            this.hashEngine_.reset();
        }
        if (this.c != null) {
            this.c.reset();
        }
        this.d = 0;
        this.s = 0;
        if (bigInteger != null) {
            this.r = null;
            this.m = 0;
            this.f = bigInteger;
            this.g = bigInteger.bitLength();
            this.e = null;
            this.b = null;
            return;
        }
        if (this.r != null) {
            CryptoUtils.zeroBlock(this.r);
        }
    }

    public static void registerHashEngine(byte by, String string) {
        i.put(new Byte(by), string);
    }

    protected abstract byte[] produceSignature(byte[] var1) throws SignatureException;

    byte[] b(byte[] byArray) throws SignatureException {
        byte[] byArray2 = this.produceSignature(byArray);
        if (!this.a) {
            BigInteger bigInteger = new BigInteger(1, byArray2);
            bigInteger = bigInteger.min(this.f.subtract(bigInteger));
            byArray2 = ISO9796P2Signature.a(bigInteger.toByteArray(), (this.g + 7) / 8);
        }
        return byArray2;
    }

    protected abstract byte[] openSignature(byte[] var1) throws SignatureException;

    byte[] a(byte[] byArray) throws SignatureException {
        byte[] byArray2 = this.openSignature(byArray);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = bigInteger.mod(p);
        boolean bl = true;
        if (bigInteger2.compareTo(n) != 0) {
            bl = false;
            if (!this.a) {
                if (this.e == null) {
                    this.e = this.f.subtract(n).mod(p);
                }
                if (bigInteger2.compareTo(this.e) == 0) {
                    bigInteger2 = (bigInteger = this.f.subtract(bigInteger)).mod(p);
                    if (bigInteger2.compareTo(n) == 0) {
                        bl = true;
                    }
                    byArray2 = ISO9796P2Signature.a(bigInteger.toByteArray(), (this.g + 7) / 8);
                } else {
                    CryptoUtils.zeroBlock(byArray2);
                    bigInteger = null;
                    bigInteger2 = null;
                    throw new SignatureException("Signature out of range!");
                }
            }
            if (!bl && (byArray2[0] & 0x80) != 0) {
                CryptoUtils.zeroBlock(byArray2);
                bigInteger = null;
                bigInteger2 = null;
                throw new SignatureException("Signature out of range!");
            }
        }
        bigInteger = null;
        bigInteger2 = null;
        return byArray2;
    }

    void b() {
        if (this.g == 0) {
            throw new IllegalStateException("Engine not initialized. Missing modulus length!");
        }
        if (this.j <= 0) {
            String string = null;
            string = this.hashEngine_ != null ? this.hashEngine_.getAlgorithm() : this.c.getAlgorithm();
            this.j = Util.getDigestLength(string);
        }
        if (this.m == 0) {
            this.m = this.a();
        }
        this.r = new byte[this.m / 8];
    }

    protected SecureRandom getSecureRandom() {
        if (this.secureRandom_ == null) {
            this.setSecureRandom(SecRandom.getDefault());
        }
        return this.secureRandom_;
    }

    static String b(byte by) {
        return (String)i.get(new Byte(by));
    }

    MessageDigest a(byte by) {
        MessageDigest messageDigest;
        block4: {
            String string;
            messageDigest = null;
            if (this.l || by != 51 || this.r == null || this.s <= 0 || this.c == null || (string = ISO9796P2Signature.b(by)) == null) break block4;
            try {
                messageDigest = MessageDigest.getInstance(string, "IAIK");
            }
            catch (Exception exception) {
                try {
                    this.hashEngine_ = MessageDigest.getInstance(string);
                }
                catch (Exception exception2) {}
            }
        }
        return messageDigest;
    }

    int a() {
        return ISO9796P2Signature.calculateCapacity(this.g, this.j * 8, this.k);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean engineVerify(byte[] var1_1) throws SignatureException {
        block26: {
            this.b = null;
            if (this.g == 0) {
                throw new IllegalStateException("Length of public parameter not set");
            }
            var2_2 = this.a(var1_1);
            if (var2_2.length * 8 != this.g) {
                CryptoUtils.zeroBlock(var2_2);
                throw new SignatureException("Invalid signature. Message representative not k bits long.");
            }
            var3_3 = true;
            var4_4 = (byte)(var2_2[0] & -32);
            if (var4_4 == 96) {
                var3_3 = false;
            } else if (var4_4 != 64) {
                CryptoUtils.zeroBlock(var2_2);
                throw new SignatureException("Invalid signature. Leftmost bits are not 01.");
            }
            if ((var2_2[var2_2.length - 1] & 15) != 12) {
                CryptoUtils.zeroBlock(var2_2);
                throw new SignatureException("Invalid signature. Final trailer nibble not 1100.");
            }
            var5_5 = 1;
            var7_6 = var2_2.length - 1;
            if (var2_2[var7_6] == -52) {
                if (var2_2[--var7_6] != this.h) {
                    var8_7 = this.a(var2_2[var7_6]);
                    if (var8_7 == null) {
                        CryptoUtils.zeroBlock(var2_2);
                        throw new SignatureException("Invalid hash id. Expected " + Util.toString(this.h));
                    }
                    this.hashEngine_ = var8_7;
                    this.j = Util.getDigestLength(this.hashEngine_.getAlgorithm());
                }
            } else if (var2_2[var7_6] != -68) {
                CryptoUtils.zeroBlock(var2_2);
                throw new SignatureException("Invalid trailer byte. Expected 0xBC or 0xCC.");
            }
            if (this.hashEngine_ == null && this.c == null) {
                CryptoUtils.zeroBlock(var2_2);
                throw new NullPointerException("MessageDigest engine must not be null!");
            }
            if (this.j <= 0) {
                var8_7 = null;
                var8_7 = this.hashEngine_ != null ? this.hashEngine_.getAlgorithm() : this.c.getAlgorithm();
                this.j = Util.getDigestLength((String)var8_7);
            }
            if ((var6_8 = (byte)(var2_2[0] & 15)) == 10) break block26;
            if (var6_8 != 11) {
                CryptoUtils.zeroBlock(var2_2);
                throw new SignatureException("Invalid padding. Must only contain zero bits");
            }
            if (var3_3) ** GOTO lbl48
            CryptoUtils.zeroBlock(var2_2);
            throw new SignatureException("Too many padding bits for partial recovery.");
lbl-1000:
            // 1 sources

            {
                ++var5_5;
lbl48:
                // 2 sources

                ** while (var2_2[var5_5] == -69 && var5_5 < var7_6)
            }
lbl49:
            // 1 sources

            if (var7_6 <= var5_5) {
                CryptoUtils.zeroBlock(var2_2);
                throw new SignatureException("Invalid padding.");
            }
            if (var2_2[var5_5++] != -70) {
                CryptoUtils.zeroBlock(var2_2);
                throw new SignatureException("Invalid padding. Wrong border nibble.");
            }
        }
        if ((var7_6 -= this.j) < var5_5) {
            CryptoUtils.zeroBlock(var2_2);
            throw new SignatureException("Invalid padding.");
        }
        var9_9 = var7_6 - var5_5;
        v0 = var10_10 = this.d > 0 ? this.d - var9_9 : 0;
        if (this.r != null && !CryptoUtils.equalsBlock(var2_2, var5_5, this.r, 0, var9_9)) {
            CryptoUtils.zeroBlock(var2_2);
            throw new SignatureException("Invalid message recovery.");
        }
        this.b = new byte[var9_9];
        System.arraycopy(var2_2, var5_5, this.b, 0, var9_9);
        if (var3_3) {
            if (var10_10 != 0) {
                CryptoUtils.zeroBlock(var2_2);
                CryptoUtils.zeroBlock(this.b);
                this.b = null;
                throw new SignatureException("Invalid padding. Mn must be empty for total recovery");
            }
            if (this.hashEngine_ == null) {
                CryptoUtils.zeroBlock(var2_2);
                CryptoUtils.zeroBlock(this.b);
                throw new NullPointerException("MessageDigest engine must not be null!");
            }
            this.hashEngine_.reset();
            var8_7 = this.hashEngine_.digest(this.b);
        } else {
            if (var10_10 < 1) {
                CryptoUtils.zeroBlock(var2_2);
                CryptoUtils.zeroBlock(this.b);
                this.b = null;
                throw new SignatureException("Invalid padding. Mn cannot be empty for partial recovery");
            }
            if (this.r == null) {
                CryptoUtils.zeroBlock(var2_2);
                CryptoUtils.zeroBlock(this.b);
                this.b = null;
                throw new NullPointerException("Recovered message part not initialized!");
            }
            var8_7 = this.c != null ? this.c.digest() : this.hashEngine_.digest();
        }
        var11_11 = CryptoUtils.equalsBlock(var2_2, var7_6, (byte[])var8_7, 0, this.j);
        CryptoUtils.zeroBlock(var2_2);
        if (!var11_11) {
            CryptoUtils.zeroBlock(this.b);
            this.b = null;
        }
        this.reset(null);
        return var11_11;
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        this.b = null;
        if (this.hashEngine_ == null && this.c == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.r == null) {
            this.b();
        }
        if (this.c == null) {
            this.hashEngine_.update(byArray, n2, n3);
            if (this.s < this.r.length) {
                int n4 = Math.min(this.r.length - this.s, n3);
                System.arraycopy(byArray, n2, this.r, this.s, n4);
                this.s += n4;
            }
            this.d += n3;
            return;
        }
        this.c.update(byArray, n2, n3);
    }

    protected void engineUpdate(byte by) {
        this.b = null;
        if (this.hashEngine_ == null && this.c == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.r == null) {
            this.b();
        }
        if (this.c == null) {
            this.hashEngine_.update(by);
            if (this.s < this.r.length) {
                this.r[this.s++] = by;
            }
            ++this.d;
            return;
        }
        this.c.update(by);
    }

    protected byte[] engineSign() throws SignatureException {
        int n2;
        byte[] byArray;
        if (this.hashEngine_ == null && this.c == null) {
            throw new NullPointerException("MessageDigest engine must not be null!");
        }
        if (this.r == null) {
            this.b();
        }
        if (this.g == 0) {
            throw new IllegalStateException("Length of public parameter not set");
        }
        this.b = null;
        if (this.c != null) {
            byArray = this.c.digest();
            this.hashEngine_.reset();
        } else {
            byArray = this.hashEngine_.digest();
        }
        int n3 = (this.g + 7) / 8;
        byte[] byArray2 = new byte[n3];
        int n4 = n3 - 1;
        int n5 = 1;
        if (this.k) {
            byArray2[n4] = -52;
            byArray2[--n4] = this.h;
            n5 = 2;
        } else {
            byArray2[n4] = -68;
        }
        if ((n4 -= byArray.length) < 1) {
            throw new SignatureException("Modulus too short!");
        }
        System.arraycopy(byArray, 0, byArray2, n4, byArray.length);
        int n6 = this.d;
        int n7 = this.d * 8;
        int n8 = (this.m - n7) % 8;
        if (n8 < 0) {
            n8 += 8;
        }
        if ((n2 = this.m - n8) < n7) {
            n6 = n2 / 8;
            byArray2[0] = 107;
        } else {
            byArray2[0] = 75;
        }
        if (n6 > 0) {
            if (n6 > this.r.length) {
                CryptoUtils.zeroBlock(byArray2);
                throw new SignatureException("Partial message to short.");
            }
            if ((n4 -= n6) < 1) {
                CryptoUtils.zeroBlock(byArray2);
                throw new SignatureException("Modulus too short!");
            }
            System.arraycopy(this.r, 0, byArray2, n4, n6);
        }
        int n9 = --n4;
        while (n9 > 0) {
            byArray2[n9] = -69;
            --n9;
        }
        int n10 = n4;
        byArray2[n10] = (byte)(byArray2[n10] ^ 1);
        byte[] byArray3 = this.b(byArray2);
        this.reset(null);
        CryptoUtils.zeroBlock(byArray2);
        return byArray3;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof ISO9796P2ParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Parameters must be a ISO9796P2ParameterSpec!");
        }
        this.b = null;
        ISO9796P2ParameterSpec iSO9796P2ParameterSpec = (ISO9796P2ParameterSpec)algorithmParameterSpec;
        MessageDigest messageDigest = iSO9796P2ParameterSpec.getHashEngine();
        if (messageDigest != null) {
            if (this.l) {
                if (!this.checkHashEngineName(messageDigest.getAlgorithm())) {
                    throw new InvalidAlgorithmParameterException("Invalid hash engine parameter (" + messageDigest.getAlgorithm() + "). Expected " + this.hashEngine_.getAlgorithm() + ".");
                }
                if (this.j != iSO9796P2ParameterSpec.getHashLen()) {
                    throw new InvalidAlgorithmParameterException("Invalid hash length parameter (" + iSO9796P2ParameterSpec.getHashLen() + "). Expected " + this.j + ".");
                }
            }
            this.hashEngine_ = messageDigest;
            this.j = iSO9796P2ParameterSpec.getHashLen();
        }
        if (iSO9796P2ParameterSpec.getHashID() > -1) {
            byte by = (byte)iSO9796P2ParameterSpec.getHashID();
            if (this.l && this.h != by) {
                throw new InvalidAlgorithmParameterException("Invalid hash id parameter (" + Util.toString(by) + "). Expected " + Util.toString(this.h) + ".");
            }
            this.h = by;
        }
        this.k = iSO9796P2ParameterSpec.getUseExplicitTrailer();
        this.a = iSO9796P2ParameterSpec.getUseAlternativeSignatureFunction();
        this.setSecureRandom(iSO9796P2ParameterSpec.getSecureRandom());
        if (algorithmParameterSpec instanceof RawISO9796P2ParameterSpec) {
            RawISO9796P2ParameterSpec rawISO9796P2ParameterSpec = (RawISO9796P2ParameterSpec)algorithmParameterSpec;
            this.a(rawISO9796P2ParameterSpec.getMr(), rawISO9796P2ParameterSpec.getMsgLen(), rawISO9796P2ParameterSpec.a());
        }
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        this.b = null;
        try {
            if (object instanceof AlgorithmParameterSpec) {
                this.engineSetParameter((AlgorithmParameterSpec)object);
                return;
            }
            throw new InvalidParameterException("value must be an instance of AlgorithmParameterSpec.");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        if (this.b != null) {
            try {
                algorithmParameters = AlgorithmParameters.getInstance("ISO9796-2-RM", "IAIK");
                algorithmParameters.init(this.b);
                return algorithmParameters;
            }
            catch (Exception exception) {
            }
        }
        return algorithmParameters;
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return this.engineGetParameters();
    }

    protected boolean checkHashEngineName(String string) {
        boolean bl = true;
        if (string != null) {
            if (this.hashEngine_ != null) {
                bl = string.equalsIgnoreCase(this.hashEngine_.getAlgorithm());
            }
            if (!bl && this.c != null) {
                bl = string.equalsIgnoreCase(this.c.getAlgorithm());
            }
        }
        return bl;
    }

    public static int calculateCapacity(int n2, int n3, boolean bl) {
        int n4 = n2 - n3 - (bl ? 16 : 8) - 4;
        if (n4 < 7) {
            throw new IllegalArgumentException("Invalid capacity (" + n4 + "). Must be >= 7!");
        }
        return n4;
    }

    private static byte[] a(byte[] byArray, int n2) {
        if (byArray.length == n2) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (byArray.length > n2) {
            System.arraycopy(byArray, byArray.length - n2, byArray2, 0, n2);
        } else if (byArray.length < n2) {
            System.arraycopy(byArray, 0, byArray2, n2 - byArray.length, byArray.length);
        }
        return byArray2;
    }

    protected ISO9796P2Signature(String string, int n2, byte by) {
        super(string);
        this.h = by;
        this.j = n2;
        this.k = false;
        this.l = true;
        this.c = null;
        this.a = true;
    }

    protected ISO9796P2Signature(String string) {
        super(string);
        this.hashEngine_ = new SHA();
        this.h = (byte)51;
        this.j = 20;
        this.k = true;
        this.l = false;
        this.c = null;
        this.a = true;
    }

    static {
        n = BigInteger.valueOf(12L);
        p = BigInteger.valueOf(16L);
        i = new Hashtable(10);
        i.put(new Byte(49), "RIPEMD160");
        i.put(new Byte(50), "RIPEMD128");
        i.put(new Byte(51), "SHA1");
        i.put(new Byte(52), "SHA256");
        i.put(new Byte(54), "SHA384");
        i.put(new Byte(53), "SHA512");
    }
}

