/*
 * Decompiled with CFR 0.152.
 */
package sogei.V9TJU000.utility;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.zip.CRC32;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import sogei.V9TJU000.utility.GestioneIntestazioneXML;
import sogei.V9TJU000.utility.GestioneSpazioServizioTelematicoXML;
import sogei.V9TJU000.utility.HashCodeManagerXMLInterface;
import sogei.V9TJU000.utility.IntestazioneUtility;
import sogei.V9TJU000.utility.OriginalHashCodeManagerXML;
import sogei.V9TJU000.utility.XMLException;

public class HashCodeManagerXML
implements HashCodeManagerXMLInterface {
    public static final int XML_PARSING_RETURN_TYPE_ECCEZIONE_JDOM = -2;
    public static final int XML_PARSING_RETURN_TYPE_OK = 1;
    public static final int XML_PARSING_RETURN_TYPE_NON_CONFORME = -1;
    public static final int XML_PARSING_RETURN_TYPE_ECCEZIONE = 0;
    private static HashMap<Integer, String> infoSST = null;
    private static HashMap<String, String[]> namespaces = new HashMap();
    private static String tempFile = new String("hashfile");
    private GestioneIntestazioneXML intestazione;
    private GestioneSpazioServizioTelematicoXML spazioServizioTelematico;
    private String fileName;
    private File file;
    private File fileTemporaneo;
    private File testFile;
    private OriginalHashCodeManagerXML original = null;
    private Namespace namespaceIntestazione = null;
    private boolean enabledWriting = false;
    private int risultatoParsing;
    private String oldHash = "0000000";
    private Document document = null;
    private XMLOutputter outtputter = null;

    static {
        namespaces.put("IRA11", new String[]{"cm", "urn:www.agenziaentrate.gov.it:specificheTecniche:common:v1"});
        namespaces.put("IRA12", new String[]{"ir", "urn:www.agenziaentrate.gov.it:specificheTecniche:sco:irap:v2"});
        namespaces.put("73012", new String[]{"m730", "urn:www.agenziaentrate.gov.it:specificheTecniche:sco:730:v1"});
        namespaces.put("SCE12", new String[]{"sce", "urn:www.agenziaentrate.gov.it:specificheTecniche:sco:sce:v1"});
        namespaces.put("RLI12", new String[]{"loc", "urn:www.agenziaentrate.gov.it:specificheTecniche:sco:loc:v1"});
    }

    public HashCodeManagerXML(String fileName) {
        this.logMessage("HashCodeManagerXML(" + fileName + ")");
        System.out.println("HashCodeManagerXML - inizio");
        this.fileName = fileName;
        this.file = new File(fileName);
        try {
            this.original = new OriginalHashCodeManagerXML(fileName);
        }
        catch (Throwable e) {
            this.logMessage(e);
        }
        this.logMessage("SIZE: " + this.file.length());
    }

    public HashCodeManagerXML(File file) {
        this.logMessage("HashCodeManagerXML(" + file + ")");
        this.file = file;
        this.logMessage("SIZE: " + file.length());
    }

    @Override
    public String computeHash() {
        int result;
        if (this.document == null && (result = this.leggiIntestazione()) < 1) {
            return "00000000";
        }
        return this.computeHash(this.document);
    }

    public String computeHash(Document document) {
        CRC32 crc;
        StringBuffer log;
        String zeroChar;
        String CRCHex;
        block31: {
            this.log("computeHash");
            this.logMessage("HashCodeManagerXML.computeHash()");
            CRCHex = new String("");
            zeroChar = new String("0000000000");
            log = new StringBuffer("");
            crc = new CRC32();
            XMLOutputter outputter = this.getXMLOutputter();
            FileOutputStream fileStream = null;
            OutputStreamWriter writer2 = null;
            try {
                this.fileTemporaneo = new File(tempFile);
                this.logMessage("Creazione file temporaneo: " + this.fileTemporaneo.getAbsoluteFile());
                document = this.updateTag(document, "SpazioServizioTelematico", this.getIntestazione().getSpazioServizioTelematicoSenzaHash());
                fileStream = new FileOutputStream(this.fileTemporaneo);
                writer2 = new OutputStreamWriter((OutputStream)fileStream, "UTF-8");
                outputter.output(document, (Writer)writer2);
                this.logMessage(">>>> OUT SIZE: " + this.fileTemporaneo.length());
            }
            catch (XMLException e) {
                this.logMessage(e);
                if (writer2 != null) {
                    try {
                        writer2.close();
                    }
                    catch (IOException e2) {
                        this.logMessage(e2);
                        e2.printStackTrace();
                    }
                }
                break block31;
            }
            catch (IOException e) {
                try {
                    this.logMessage(e);
                    break block31;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (writer2 != null) {
                        try {
                            writer2.close();
                        }
                        catch (IOException e3) {
                            this.logMessage(e3);
                            e3.printStackTrace();
                        }
                    }
                }
            }
            if (writer2 == null) break block31;
            try {
                writer2.close();
            }
            catch (IOException e) {
                this.logMessage(e);
                e.printStackTrace();
            }
        }
        int size = (int)this.file.length();
        this.logMessage("size: " + size + "\n");
        FileInputStream in = null;
        try {
            try {
                crc.reset();
                in = new FileInputStream(this.fileTemporaneo);
                byte[] bytes = new byte[(int)this.fileTemporaneo.length()];
                in.read(bytes);
                this.logMessage(">>>> BYT SIZE: " + bytes.length);
                crc.update(bytes, 0, bytes.length);
            }
            catch (Exception e) {
                this.logMessage("ERROR 1: " + e.getMessage() + "\n");
                this.logMessage(log.toString());
                this.logMessage(e);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                return "";
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if ((CRCHex = Long.toHexString(crc.getValue()).toUpperCase()).length() < 8) {
            CRCHex = String.valueOf(zeroChar.substring(0, 8 - CRCHex.length())) + CRCHex;
        }
        this.logMessage("CRC: " + crc.getValue() + "\n");
        this.logMessage("CRCHex: " + CRCHex + "\n");
        return CRCHex;
    }

    @Override
    public String encryptHash(String password) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        md.update(password.getBytes());
        byte[] byteData = md.digest();
        StringBuffer hexString = new StringBuffer();
        int i = 0;
        while (i < byteData.length) {
            String hex = Integer.toHexString(0xFF & byteData[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
            ++i;
        }
        System.out.println("MD5 COMPLETO: " + hexString.toString());
        return hexString.toString().substring(0, 8).toUpperCase();
    }

    @Override
    public GestioneIntestazioneXML getIntestazione() throws XMLException {
        if (this.intestazione == null) {
            this.risultatoParsing = this.parseIntestazione();
        }
        this.log("getIntestazione", new Object[]{"" + this.risultatoParsing});
        return this.intestazione;
    }

    private Document build(String fileName) throws JDOMException, IOException {
        return this.build(new File(fileName));
    }

    private Document build(File file) throws JDOMException, IOException {
        this.log("build", new Object[]{file.getName()});
        if (this.document == null) {
            this.logMessage("**** NEW DOCUMENT PARSING *****");
            SAXBuilder builder = new SAXBuilder(false);
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            this.document = builder.build((Reader)reader);
        }
        return this.document;
    }

    private int parseIntestazione() {
        block11: {
            Element intestazione;
            Element root;
            block12: {
                this.log("parseIntestazione");
                this.intestazione = null;
                IntestazioneUtility intestazioneUtility = new IntestazioneUtility();
                try {
                    this.logDebug(1);
                    this.intestazione = intestazioneUtility.getIntestazioneFromXSD(this.file);
                    this.logDebug(2);
                    this.build(this.file);
                    this.logDebug(3);
                }
                catch (Throwable _t) {
                    this.logDebug(4);
                    _t.printStackTrace();
                    System.out.println("WARNING: documento xml non conforme allo schema telematico");
                }
                if (this.intestazione != null) {
                    this.logDebug(5);
                    if (this.intestazione.getCodiceFiscaleFornitore() == null || this.intestazione.getCodiceFornitura() == null) {
                        this.logDebug(6);
                        return -1;
                    }
                    this.logDebug(7);
                    return 1;
                }
                this.intestazione = new GestioneIntestazioneXML();
                this.logDebug(8);
                Document document = this.build(this.file);
                this.logDebug(9);
                this.logMessage(">>>>> DOCU: " + document);
                root = document.getRootElement();
                this.logDebug(10);
                this.logMessage(">>>>> ROOT: " + root);
                intestazione = this.getIntestazione(root, "Intestazione", null);
                this.logDebug(11);
                if (intestazione == null) break block11;
                if (intestazione.getNamespace() == null || intestazione.getNamespace().getPrefix() == null) break block12;
                boolean check = false;
                for (String key : namespaces.keySet()) {
                    if (!namespaces.get(key)[0].equals(intestazione.getNamespace().getPrefix())) continue;
                    check = true;
                    break;
                }
                if (check) break block12;
                this.logMessage("La struttura del XML non e' conforme, il controllo verra'\u00ef\u00bf\u00bd interrotto");
                return -1;
            }
            this.logMessage(">>>>> INTE: " + intestazione);
            String codiceFornitura = this.getCodiceFornitura(root, intestazione, null);
            this.logDebug(12);
            Element tipoFornitore = this.getChild(intestazione, "TipoFornitore", null);
            this.logDebug(13);
            Element codiceFiscaleFornitore = this.getChild(intestazione, "CodiceFiscaleFornitore", null);
            this.logDebug(14);
            Element spazioServizioTelematico = this.getChild(intestazione, "SpazioServizioTelematico", null);
            this.logDebug(15);
            Element codiceFiscaleRappresentante = this.getChild(intestazione, "CodiceFiscaleRappresentante", null);
            this.logDebug(16);
            Element codiceCarica = this.getChild(intestazione, "CodiceCarica", null);
            this.logDebug(17);
            this.intestazione.setCodiceFornitura(codiceFornitura != null ? codiceFornitura : null);
            this.intestazione.setTipoFornitore(tipoFornitore != null ? tipoFornitore.getValue() : "  ");
            this.intestazione.setCodiceFiscaleFornitore(codiceFiscaleFornitore != null ? codiceFiscaleFornitore.getValue() : null);
            this.intestazione.setSpazioServizioTelematico(spazioServizioTelematico != null ? spazioServizioTelematico.getValue() : null);
            this.intestazione.setCodiceFiscaleRappresentante(codiceFiscaleRappresentante != null ? codiceFiscaleRappresentante.getValue() : null);
            this.intestazione.setCodiceCarica(codiceCarica != null ? codiceCarica.getValue() : null);
            this.logDebug(this.intestazione.getCodiceFornitura());
            this.logDebug(this.intestazione.getTipoFornitore());
            this.logDebug(this.intestazione.getCodiceFiscaleFornitore());
            this.logDebug(this.intestazione.getSpazioServizioTelematico());
            this.logDebug(this.intestazione.getCodiceFiscaleRappresentante());
            this.logDebug(this.intestazione.getCodiceCarica());
            if (this.intestazione == null) {
                return -1;
            }
        }
        try {
            this.logMessage("La struttura del XML non e' conforme, il controllo verra'\u00ef\u00bf\u00bd interrotto");
            return -1;
        }
        catch (JDOMException e) {
            this.logMessage("ERRORE parsing JDOM: " + e.getMessage());
            return -2;
        }
        catch (IOException e) {
            this.logMessage("ERRORE parsing JDOM: " + e.getMessage());
            return 0;
        }
        this.intestazione.setEsisteSST(true);
        return 1;
    }

    @Override
    public int leggiIntestazione() {
        if (this.intestazione == null) {
            this.risultatoParsing = this.parseIntestazione();
        }
        this.log("leggiIntestazione", new Object[]{"" + this.risultatoParsing});
        return this.risultatoParsing;
    }

    @Override
    public String readHash() {
        this.log("readHash");
        String hashFile = this.getInfoSST(3);
        this.logMessage(">>>>> READ HASH: " + hashFile);
        return hashFile;
    }

    @Override
    public void setEnabledWriting(String codEnabled) {
        this.log("setEnabledWriting", new Object[]{codEnabled});
        this.enabledWriting = codEnabled.equals("AUTENTICA");
    }

    @Override
    public String startUP() {
        int type_check = this.leggiIntestazione();
        this.log("startUP", new Object[]{"type_check: " + type_check});
        if (type_check > 0) {
            GestioneIntestazioneXML gestIntXML = null;
            String sst = GestioneSpazioServizioTelematicoXML.SPAZIO_SERVIZIO_TELEMATICO;
            try {
                gestIntXML = this.getIntestazione();
                this.logMessage("SERVIZIO SPAZIO TELEMATICO < " + gestIntXML.esisteSST() + " >");
                if (gestIntXML.esisteSST()) {
                    sst = gestIntXML.getSpazioServizioTelematico();
                }
            }
            catch (XMLException e) {
                this.logMessage(e);
            }
            this.oldHash = this.readHash();
            this.logMessage("OLD HASH < " + this.oldHash + " >");
            this.logMessage("SERVIZIO SPAZIO TELEMATICO < VERIFICATO >");
            return sst;
        }
        return GestioneSpazioServizioTelematicoXML.SPAZIO_SERVIZIO_TELEMATICO;
    }

    @Override
    public boolean verificaLunghezzaSST(String sst) {
        this.log("verificaLunghezzaSST", new Object[]{sst});
        if (sst == null) {
            this.spazioServizioTelematico = new GestioneSpazioServizioTelematicoXML(GestioneSpazioServizioTelematicoXML.SPAZIO_SERVIZIO_TELEMATICO);
            return false;
        }
        if (sst.trim().length() < 23) {
            this.spazioServizioTelematico = new GestioneSpazioServizioTelematicoXML(GestioneSpazioServizioTelematicoXML.SPAZIO_SERVIZIO_TELEMATICO);
            return false;
        }
        this.spazioServizioTelematico = new GestioneSpazioServizioTelematicoXML(sst);
        return true;
    }

    private String getInfoSST(int index) {
        GestioneIntestazioneXML inte = null;
        try {
            inte = this.getIntestazione();
            this.log("getInfoSST", new Object[]{index, inte.getSpazioServizioTelematico(), this.oldHash});
        }
        catch (XMLException e) {
            this.logMessage(e);
        }
        String sst = inte.getSpazioServizioTelematico();
        if (sst != null) {
            this.logMessage("SST != null");
            boolean verifica = this.verificaLunghezzaSST(sst);
            if (!verifica) {
                sst = GestioneSpazioServizioTelematicoXML.SPAZIO_SERVIZIO_TELEMATICO;
            }
        } else {
            this.logMessage("SST == null");
            sst = GestioneSpazioServizioTelematicoXML.SPAZIO_SERVIZIO_TELEMATICO;
        }
        infoSST = this.getHMInfoSpazioServizioTelematico(sst);
        this.logMessage(String.valueOf(infoSST.size()));
        this.logMessage("getInfoSST(" + index + "): " + infoSST.get(new Integer(index)));
        return infoSST.get(new Integer(index));
    }

    private HashMap<Integer, String> getHMInfoSpazioServizioTelematico(String sst) {
        this.log("getHMInfoSpazioServizioTelematico", new Object[]{sst});
        if (sst != null) {
            HashMap<Integer, String> infoSST = new HashMap<Integer, String>();
            int start = 0;
            int end = 6;
            String subSST = sst.substring(start, end);
            infoSST.put(new Integer(0), subSST);
            start = end;
            end = 14;
            subSST = sst.substring(start, end);
            infoSST.put(new Integer(1), subSST);
            start = end;
            end = 15;
            subSST = sst.substring(start, end);
            infoSST.put(new Integer(2), subSST);
            start = end;
            end = 23;
            subSST = sst.substring(start, end);
            infoSST.put(new Integer(3), subSST);
            start = end;
            end = 33;
            subSST = sst.substring(start, end);
            infoSST.put(new Integer(4), subSST);
            start = end;
            end = 73;
            subSST = sst.substring(start, end);
            infoSST.put(new Integer(5), subSST);
            start = end;
            end = 89;
            subSST = sst.substring(start, end);
            infoSST.put(new Integer(6), subSST);
            start = end;
            end = 90;
            subSST = sst.substring(start, end);
            infoSST.put(new Integer(7), subSST);
            start = end;
            end = 91;
            subSST = sst.substring(start, end);
            infoSST.put(new Integer(8), subSST);
            return infoSST;
        }
        return null;
    }

    @Deprecated
    private void removeHash() {
        this.log("removeHash");
    }

    @Deprecated
    private int copyInto(String fileOrigine, String fileDestinazione) throws IOException {
        this.log("copyInto", new Object[]{fileOrigine, fileDestinazione});
        return 0;
    }

    private Document updateTag(String nameTag, String newValue) {
        this.log("updateTag", new Object[]{nameTag, newValue});
        Document retVal = null;
        try {
            Document document = this.build(this.file);
            retVal = this.updateTag(document, nameTag, newValue);
        }
        catch (Exception e) {
            this.logMessage(e);
        }
        return retVal;
    }

    private Document updateTag(String nameTag, String newValue, File fileDocument) {
        this.log("updateTag", new Object[]{nameTag, newValue, fileDocument});
        Document retVal = null;
        try {
            Document document = null;
            try {
                document = this.build(fileDocument);
            }
            catch (Exception e) {
                this.logMessage("ERRORE updateTag " + e.getMessage());
                document = this.build(fileDocument);
            }
            retVal = this.updateTag(document, nameTag, newValue);
        }
        catch (Exception e) {
            this.logMessage("ERRORE updateTag " + e.getMessage());
            this.logMessage(e);
        }
        return retVal;
    }

    private Document updateTag(Document document, String nameTag, String newValue) {
        this.log("updateTag", new Object[]{document, nameTag, newValue});
        Element root = document.getRootElement();
        Element wSubItem = null;
        try {
            List figli_root = root.getChildren();
            int i = 0;
            while (i < figli_root.size()) {
                Element figlio_root = (Element)figli_root.get(i);
                if (figlio_root.getName().equalsIgnoreCase("Intestazione")) {
                    List nipoti_root = figlio_root.getChildren();
                    int j = 0;
                    while (j < nipoti_root.size()) {
                        Element nipote_root = (Element)nipoti_root.get(j);
                        if (nipote_root.getName().equalsIgnoreCase(nameTag)) {
                            wSubItem = nipote_root;
                            wSubItem.setText(newValue);
                        } else {
                            wSubItem = nipote_root;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.logMessage(e);
        }
        return document;
    }

    public void creaFile(String nameTag, String newValue, String fileTMP) {
        this.log("creaFile", new Object[]{nameTag, newValue, fileTMP});
        XMLOutputter outputter = this.getXMLOutputter();
        try {
            Document document = this.build(new File(fileTMP));
            this.editFornitura(document, nameTag, newValue);
            outputter.output(document, (OutputStream)new FileOutputStream(fileTMP));
        }
        catch (Exception e) {
            this.logMessage(e);
        }
    }

    public Document updateTag(String nameTag, String newValue, String fileName) {
        this.log("updateTag", new Object[]{nameTag, newValue, fileName});
        XMLOutputter outputter = this.getXMLOutputter();
        Document document = null;
        try {
            try {
                document = this.build(fileName);
            }
            catch (Exception e) {
                this.logMessage("ERRORE updateTag " + e.getMessage());
                this.createAll();
                document = this.build(fileName);
            }
            this.updateTag(document, nameTag, newValue);
            outputter.output(document, (OutputStream)new FileOutputStream(fileName));
            this.logMessage("File Temp dopo updateTag: " + new File(fileName).length());
        }
        catch (Exception e) {
            this.logMessage("ERRORE updateTag " + e.getMessage());
            this.logMessage(e);
        }
        return document;
    }

    @Deprecated
    private synchronized boolean createAll() {
        this.log("createAll");
        return true;
    }

    private Element getIntestazione(Element root, String tag, Namespace namespace) {
        List figli_root = root.getChildren();
        int i = 0;
        while (i < figli_root.size()) {
            Element figlio_root = (Element)figli_root.get(i);
            if (figlio_root.getName().equalsIgnoreCase("Intestazione")) {
                this.namespaceIntestazione = figlio_root.getNamespace();
                return figlio_root;
            }
            ++i;
        }
        return null;
    }

    private Element getChild(Element root, String tag, Namespace namespace) {
        if (namespace == null) {
            List branches = root.getChildren(tag);
            if (branches == null || branches.size() == 0) {
                for (String key : namespaces.keySet()) {
                    Namespace n = Namespace.getNamespace((String)namespaces.get(key)[0], (String)namespaces.get(key)[1]);
                    Element ret = this.getChild(root, tag, n);
                    if (ret == null) continue;
                    return ret;
                }
                return null;
            }
        } else {
            List branches = null;
            try {
                branches = root.getChildren(tag, namespace);
            }
            catch (Throwable throwable) {
                return null;
            }
            if (branches != null && branches.size() > 0) {
                return (Element)branches.get(0);
            }
        }
        return null;
    }

    private String getCodiceFornitura(Element root, Element intestazione, Namespace namespace) {
        this.log("getCodiceFornitura 1");
        List children = intestazione.getChildren();
        for (Element item : children) {
            if (!item.getName().equalsIgnoreCase("CodiceFornitura")) continue;
            return item.getValue();
        }
        return this.getCodiceFornitura(root, namespace);
    }

    private String getCodiceFornitura(Element root, Namespace namespace) {
        this.log("getCodiceFornitura 2");
        if (namespace == null) {
            List branches = root.getChildren("Contenuto");
            if (branches == null || branches.size() == 0) {
                for (String key : namespaces.keySet()) {
                    Namespace n = Namespace.getNamespace((String)namespaces.get(key)[0], (String)namespaces.get(key)[1]);
                    Element contenuto = this.getChild(root, "Contenuto", n);
                    if (contenuto == null) continue;
                    return contenuto.getAttributeValue("CodiceFornitura");
                }
                return null;
            }
        } else {
            List branches = null;
            try {
                branches = root.getChildren("Contenuto", namespace);
            }
            catch (Throwable throwable) {
                return null;
            }
            if (branches != null && branches.size() > 0) {
                Element contenuto = (Element)branches.get(0);
                return contenuto.getAttributeValue("CodiceFornitura");
            }
        }
        return null;
    }

    @Override
    public String readFlagInternet() {
        this.log("readFlagInternet");
        return this.getInfoSST(7);
    }

    private void writeFile(File file, byte[] content) {
        block13: {
            this.log("writeFile", new Object[]{file.getName()});
            if (file.exists()) {
                file.delete();
            }
            BufferedWriter out = null;
            try {
                try {
                    FileWriter fw = new FileWriter(file);
                    out = new BufferedWriter(fw);
                    fw.write(new String(content));
                    out.close();
                }
                catch (IOException e) {
                    this.logMessage(e);
                    if (out == null) break block13;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        this.logMessage(e2);
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        this.logMessage(e);
                    }
                }
            }
        }
    }

    public void finalize() {
        this.deleteHashFile();
    }

    private void deleteHashFile() {
        this.log("finalize");
        String userDIR = System.getProperty("user.dir");
        this.logMessage("user.dir: " + userDIR);
        new File(userDIR);
        try {
            boolean deleted = false;
            int t = 0;
            while (this.fileTemporaneo != null && this.fileTemporaneo.exists()) {
                deleted = this.fileTemporaneo.delete();
                if (!deleted) {
                    Thread.sleep(1000L);
                    this.logMessage("File temporaneo " + this.fileTemporaneo.getAbsoluteFile() + " non cancellato.");
                    if (t++ >= 10) {
                        break;
                    }
                } else {
                    this.logMessage("Cancellazione file temporaneo: true");
                    break;
                }
                if (!deleted) continue;
            }
            if (this.testFile != null && this.testFile.exists()) {
                this.testFile.delete();
            }
        }
        catch (Exception e) {
            this.logMessage(e);
        }
    }

    public LinkedList getListaFrontespizio(Object document) {
        this.logMessage("ORIGINAL -> getListaFrontespizio");
        return this.original.getListaFrontespizio(document);
    }

    public Document addNewTag(Object obj, String nameTag, String newValue) {
        this.log("creaFileNewTag", new Object[]{nameTag, newValue});
        Document document = (Document)obj;
        Element root = document.getRootElement();
        try {
            Element intestazione = this.getIntestazione(root, "Intestazione", this.namespaceIntestazione);
            if (intestazione != null) {
                this.logMessage(">>>>> NEW TAG:      " + nameTag);
                this.logMessage(">>>>> INTESTAZIONE: " + nameTag);
                Element wSubItem = new Element(nameTag);
                this.logMessage(">>>>> ELEMENT:      " + wSubItem);
                wSubItem.setNamespace(this.namespaceIntestazione);
                this.logMessage(">>>>> NAMESPACE:    " + this.namespaceIntestazione);
                wSubItem.setText(newValue);
                this.logMessage(">>>>> VALUE:        " + newValue);
                Element newElement = intestazione.addContent((Content)wSubItem);
                this.logMessage(">>>>> NEW ELEMENT:  " + newElement);
            }
        }
        catch (Exception e) {
            this.logMessage(e);
        }
        return document;
    }

    public void editFornitura(Object document, String nameTag, String newValue) {
        this.logMessage("ORIGINAL -> editFornitura");
        this.original.editFornitura(document, nameTag, newValue);
    }

    public void creaFile(String nameTag, String newValue) {
        this.logMessage("ORIGINAL -> creaFile");
        this.original.creaFile(nameTag, newValue);
    }

    public Document creaFileNewTag(String nameTag, String newValue) {
        this.log("creaFileNewTag", new Object[]{nameTag, newValue});
        Document document = null;
        Document retVal = null;
        try {
            document = this.build(this.file);
            retVal = this.addNewTag(document, nameTag, newValue);
        }
        catch (Exception e) {
            this.logMessage(e);
        }
        return retVal;
    }

    public LinkedList creaTMP(LinkedList lFronte) {
        this.logMessage("ORIGINAL -> creaTMP");
        return this.original.creaTMP(lFronte);
    }

    public int leggiIntestazione(String filename) {
        this.log("leggiIntestazione", new Object[]{this.fileName});
        this.file = new File(filename);
        this.fileName = filename;
        return this.leggiIntestazione();
    }

    public LinkedList getInfoSpazioServizioTelematico(String sst) {
        this.logMessage("ORIGINAL -> getInfoSpazioServizioTelematico");
        return this.original.getInfoSpazioServizioTelematico(sst);
    }

    public boolean isXML() {
        boolean verifica = false;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(this.file);
            br = new BufferedReader(fr);
            String linee = br.readLine();
            while (linee != null) {
                verifica = linee.contains("<?xml");
                if (verifica) {
                    boolean bl = verifica;
                    return bl;
                }
                try {
                    linee = br.readLine();
                    continue;
                }
                catch (FileNotFoundException e) {
                    this.logMessage(e);
                }
                catch (IOException e) {
                    this.logMessage(e);
                }
                break;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    this.logMessage(e);
                }
            }
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    this.logMessage(e);
                }
            }
        }
        return verifica;
    }

    public int sizeDich(Object document) {
        this.logMessage("ORIGINAL -> sizeDich");
        return this.original.sizeDich(document);
    }

    public LinkedList<String> getFrontespizio(String nf) {
        this.logMessage("ORIGINAL -> getFrontespizio");
        return this.original.getFrontespizio(nf);
    }

    public void cleanXML() {
        this.logMessage("ORIGINAL -> cleanXML");
        this.original.cleanXML();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean absoluteXML() {
        boolean verifica = false;
        boolean absolute = false;
        try {
            FileReader fr = new FileReader(this.file);
            BufferedReader br = new BufferedReader(fr);
            String linee = br.readLine();
            while (true) {
                if (linee == null) {
                    return true;
                }
                verifica = linee.contains("<?xml");
                if (verifica) return true;
                String recA = "";
                if (!linee.equals("") && !linee.equals(" ")) {
                    recA = linee.substring(0, 1);
                }
                if (recA.equals("A")) {
                    return absolute;
                }
                linee = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            this.logMessage(e);
            return absolute;
        }
        catch (IOException e) {
            this.logMessage(e);
        }
        return absolute;
    }

    public String readVersioneControllo() {
        this.logMessage("ORIGINAL -> readVersioneControllo");
        return this.original.readVersioneControllo();
    }

    public String readFlagControllo() {
        this.logMessage("ORIGINAL -> readFlagControllo");
        return this.original.readFlagControllo();
    }

    public void delAll() {
        this.logMessage("ORIGINAL -> delAll");
        this.original.delAll();
    }

    public String clearSST(String sst) {
        this.logMessage("ORIGINAL -> clearSST");
        return this.original.clearSST(sst);
    }

    public GestioneSpazioServizioTelematicoXML getGSST() {
        this.logMessage("ORIGINAL -> getGSST");
        return this.original.getGSST();
    }

    public int getEsitoHash() {
        this.logMessage("ORIGINAL -> getEsitoHash");
        return this.original.getEsitoHash();
    }

    public Vector exexuteXPathQuery() {
        this.logMessage("ORIGINAL -> exexuteXPathQuery");
        return this.original.exexuteXPathQuery();
    }

    public LinkedList creaTMP2(LinkedList lFronteN) {
        this.logMessage("ORIGINAL -> creaTMP2");
        return this.original.creaTMP2(lFronteN);
    }

    public String computeHashSST() {
        this.logMessage("ORIGINAL -> computeHashSST");
        return this.original.computeHashSST();
    }

    public boolean getHashFlag() throws Throwable {
        this.log("getHashFlag", new Object[]{this.oldHash});
        boolean hashFlag = false;
        String fHash = this.getInfoSST(2);
        if (fHash.equals("1")) {
            hashFlag = true;
        }
        return hashFlag;
    }

    public String readDataVersione() {
        this.logMessage("ORIGINAL -> readDataVersione");
        return this.original.readDataVersione();
    }

    public String readFlagCompilazione() {
        this.logMessage("ORIGINAL -> readFlagCompilazione");
        return this.original.readFlagCompilazione();
    }

    public void updateTag(Object obj, String nameTag, String newValue) {
        this.logMessage("ORIGINAL -> updateTag");
        this.original.updateTag(obj, nameTag, newValue);
    }

    public Vector print() {
        this.logMessage("ORIGINAL -> print");
        return this.original.print();
    }

    public Vector getInfoXP(String nf) {
        this.logMessage("ORIGINAL -> getInfoXP");
        return this.original.getInfoXP(nf);
    }

    public String getCodiceFornitura(String nf) {
        this.logMessage("ORIGINAL -> getCodiceFornitura");
        return this.original.getCodiceFornitura(nf);
    }

    public boolean isEnabledWriting() {
        return this.enabledWriting;
    }

    public void setEnabledWriting(boolean enabledWriting) {
        this.log("setEnabledWriting", new Object[]{enabledWriting});
        this.enabledWriting = enabledWriting;
    }

    public HashCodeManagerXML(int x, String fileName) {
        this.logMessage("ORIGINAL -> HashCodeManagerXML(int x, String fileName)");
        this.fileName = fileName;
        this.original = new OriginalHashCodeManagerXML(x, fileName);
    }

    public HashCodeManagerXML(String fileName, int flagInternet, int flagCompilazione) throws Throwable {
        this.logMessage("ORIGINAL -> (String fileName, int flagInternet, int flagCompilazione) throws Throwable");
        this.fileName = fileName;
        this.original = new OriginalHashCodeManagerXML(fileName, flagInternet, flagCompilazione);
    }

    public HashCodeManagerXML(String fileName, int flagInternet, int flagCompilazione, String nVer, String dataVer, String codApp) throws Throwable {
        this.logMessage("ORIGINAL -> HashCodeManagerXML(String fileName, int flagInternet, int flagCompilazione, String nVer, String dataVer) throws Throwable");
        this.fileName = fileName;
        this.original = new OriginalHashCodeManagerXML(fileName, flagInternet, flagCompilazione, nVer, dataVer, codApp);
    }

    public HashCodeManagerXML(String fileName, int flagInternet, int flagCompilazione, String nVer, String dataVer) {
        XMLOutputter outputter = this.getXMLOutputter();
        this.file = new File(fileName);
        this.fileName = fileName;
        boolean absolute = this.absoluteXML();
        if (absolute) {
            GestioneIntestazioneXML gestIntXML = null;
            String sst = GestioneSpazioServizioTelematicoXML.SPAZIO_SERVIZIO_TELEMATICO;
            try {
                gestIntXML = this.getIntestazione();
                this.logMessage("SERVIZIO SPAZIO TELEMATICO < " + gestIntXML.esisteSST() + " >\n" + gestIntXML.getSpazioServizioTelematico());
                if (gestIntXML.esisteSST()) {
                    sst = gestIntXML.getSpazioServizioTelematico();
                }
            }
            catch (XMLException e) {
                this.logMessage(e);
            }
            if (gestIntXML != null && gestIntXML.intestazioneValida()) {
                if (!this.isEnabledWriting()) {
                    String codFornitura = gestIntXML.getCodiceFornitura();
                    this.logMessage("codFornitura: " + codFornitura);
                    sst = String.valueOf(nVer) + dataVer + "1" + GestioneSpazioServizioTelematicoXML.HASHCODE + GestioneSpazioServizioTelematicoXML.PINCODE + GestioneSpazioServizioTelematicoXML.HASH_AUTENTICA + GestioneSpazioServizioTelematicoXML.CODICE_APPLICAZIONE + flagInternet + flagCompilazione;
                    this.logMessage("INFOSST: " + sst);
                    this.document = gestIntXML.getSpazioServizioTelematico() == null ? this.creaFileNewTag("SpazioServizioTelematico", sst) : this.updateTag("SpazioServizioTelematico", sst);
                    gestIntXML.setSpazioServizioTelematico(sst);
                    String newHash = this.computeHash(this.document);
                    this.logMessage("newHash: " + newHash);
                    String hashCodeMD5 = "";
                    try {
                        hashCodeMD5 = this.encryptHash(newHash);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    this.document = this.updateTag(this.document, "SpazioServizioTelematico", gestIntXML.getSpazioServizioTelematicoConNuovoHash(hashCodeMD5));
                    try {
                        FileOutputStream fileStream = null;
                        OutputStreamWriter writer2 = null;
                        this.logMessage("BEFORE WRITE");
                        fileStream = new FileOutputStream(this.file);
                        writer2 = new OutputStreamWriter((OutputStream)fileStream, "UTF-8");
                        outputter.output(this.document, (Writer)writer2);
                        System.out.println("AFTER WRITE - writer2.getEncoding()" + writer2.getEncoding());
                        this.logMessage("AFTER WRITE");
                    }
                    catch (IOException e) {
                        this.logMessage(e);
                    }
                } else {
                    System.out.println("Non si possiedo i privileggi di scrittura, \u00c3\u00a8 possibile visualizzare l'intestazione e non modificarla: ");
                    try {
                        this.logMessage(this.getIntestazione().toString());
                    }
                    catch (XMLException e) {
                        this.logMessage(e);
                    }
                }
            } else {
                new XMLException("La struttura dell' intestazione non risulta essere valida");
            }
        } else {
            new XMLException("AAA - Il file selezionato non e' un XML puro");
        }
        this.deleteHashFile();
    }

    public XMLOutputter getXMLOutputter() {
        if (this.outtputter == null) {
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            this.outtputter = new XMLOutputter(format);
        }
        return this.outtputter;
    }

    private void log(String method) {
        this.log(method, null);
    }

    private void logMessage(Exception e) {
        this.logMessage("************** ERROR 2: " + e.getMessage());
    }

    private void logMessage(Throwable e) {
        this.logMessage("************** ERROR 3: " + e.getMessage());
    }

    private void logDebug(int debug) {
        this.logDebug("" + debug);
    }

    private void logDebug(String message) {
        this.logMessage("debug " + message);
    }

    private void logMessage(String message) {
        System.out.println(message);
    }

    private void log(String method, Object[] args) {
        StringBuffer log = new StringBuffer("TELEMATICO XML HCMX LOG" + this.getClass().getName().toUpperCase() + "TELEMATICO XML" + " - " + this.hashCode() + "\n");
        log.append("\t" + method + "\n");
        if (args != null) {
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                log.append("\t\t" + arg + "\n");
                ++n2;
            }
        }
        log.append("END LOG TELEMATICO XML HCMX\n");
        this.logMessage(log.toString());
    }
}

