/**
//@HEADER
// ************************************************************************
//
//                   Trios: Trilinos I/O Support
//                 Copyright 2011 Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//Questions? Contact Ron A. Oldfield (raoldfi@sandia.gov)
//
// *************************************************************************
//@HEADER
 */
/*-------------------------------------------------------------------------*/
/**
 *   @file rpc_trace.h
 *
 *   @author Ron Oldfield (raoldfi\@sandia.gov)
 *   $Revision: 231 $
 *   $Date: 2005-01-13 00:28:37 -0700 (Thu, 13 Jan 2005) $
 *
 */

#ifndef _RPC_TRACE_H_
#define _RPC_TRACE_H_

#include "nssi_opcodes.h"

#ifdef __cplusplus
extern "C" {
#endif

	extern int ss_trace_level;

	enum RPC_TRACE_IDS {
	    TRACE_RPC_IDLE = NSSI_OP_NULL+1,
	    TRACE_RPC_PROC,
	    TRACE_RPC_DECODE,
	    TRACE_RPC_SENDRES,
	    TRACE_RPC_PUT_JOBWAIT,
	    TRACE_RPC_ADD_JOB,
	    TRACE_RPC_JOB_IDLE,
	    TRACE_RPC_UPDATE_JOBS
	};

#define TRACE_RPC_COUNTER_GNAME "rpc-counter"
#define TRACE_RPC_INTERVAL_GNAME "rpc-interval"

#if defined(__STDC__) || defined(__cplusplus)

#else /* K&R C */

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif
