#ifndef XMLHANDLER_H
#define XMLHANDLER_H

#include <QtCore/QObject>
#include <QtXml/QXmlDefaultHandler>
#include <QtGui/QColor>
#include <QtCore/QStringList>
#include "model.h"

class XmlHandler : public QXmlDefaultHandler
{
  private:
    QStringList token;
    tokenCodeEnum tokenCode;
    Model *model;
    int voiceIndex, index1, index2, index3;
    bool parameterFlag, sourceFlag, filterFlag, filterModFlag, controlGroupFlag;

  public:
    XmlHandler(Model *p_model, int p_voiceIndex);
    ~XmlHandler();
    bool startDocument();
    bool endDocument();
    bool startElement(const QString &namespaceURI, const QString &localName, const QString &qName, const QXmlAttributes &atts);
    bool endElement(const QString &namespaceURI, const QString &localName, const QString &qName);
    bool characters(const QString &ch);
};
  
#endif
