/*
 * AuthenTec AES1660 driver for libfprint
 * Copyright (c) 2012 Vasily Khoruzhick <anarsoul@gmail.com>
 * Based on USB logs from Andreas Loos <krawatten@andreas-loos.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#pragma once

#define AES1660_FRAME_SIZE 0x244

/* *INDENT-OFF* */

/* First init sequence, 0x07 cmd returns following before INIT1:
 * { 0x07, 0x05, 0x00, 0x8f, 0x16, 0x25, 0x01, 0x00  }
 */

/* INIT1 */
static const unsigned char pkt107[] = {
  0x44, 0x02, 0x00, 0x04, 0x00,
  0x0d, 0x23,
  0x42, 0xca, 0x00,
  0x00, 0x20, 0x23,
  0xff, 0x3f, 0x1d, 0xc1, 0x2e, 0xa3, 0xbf, 0xc2,
  0x2e, 0x00, 0xdf, 0xff, 0x2d, 0x02, 0x5a, 0xbf,
  0x22, 0xc1, 0x2e, 0xa3, 0xbf, 0x02, 0xcf, 0x0f,
  0x1c, 0x10, 0x18, 0x26, 0x83, 0xc8, 0x46, 0x00,
  0x5b, 0x01, 0x0c, 0xa2, 0x32, 0xa8, 0xcf, 0xf1,
  0x1c, 0x0c, 0x18, 0xa8, 0xaf, 0xaf, 0x31, 0x0a,
  0x3a, 0x5d, 0xcf, 0x30, 0x1c, 0x05, 0x55, 0x5d,
  0x41, 0x03, 0x5b, 0x5d, 0xcf, 0xfc, 0x1c, 0x01,
  0x18, 0x5d, 0xaf, 0x02, 0x43, 0x00, 0x2e, 0x09,
  0x5a, 0x0c, 0xef, 0x56, 0xaf, 0x2e, 0x23, 0x02,
  0x2e, 0x0b, 0x87, 0x83, 0x23, 0x84, 0x23, 0x81,
  0x23, 0x82, 0x23, 0x24, 0x23, 0x0a, 0xef, 0xbf,
  0x22, 0x00, 0x2e, 0xa9, 0x8b, 0x57, 0x23, 0x3c,
  0x23, 0xf9, 0x34, 0x6b, 0x81, 0x64, 0xef, 0x64,
  0xaf, 0x09, 0x88, 0xdf, 0xef, 0x27, 0xff, 0xd6,
  0xaf, 0xd7, 0xbf, 0x46, 0xef, 0x46, 0xaf, 0x2a,
  0xef, 0x2a, 0xaf, 0x05, 0x81, 0x05, 0x27, 0x10,
  0xef, 0x99, 0xaf, 0x9b, 0xaf, 0x04, 0xaf, 0x3d,
  0x23, 0x44, 0xef, 0x20, 0xff, 0x1a, 0x27, 0x05,
  0xef, 0x27, 0xff, 0x06, 0x27, 0x05, 0x27, 0x9c,
  0xcf, 0xdf, 0x96, 0xfe, 0xef, 0x27, 0xff, 0x19,
  0x27, 0x65, 0xdf, 0xe1, 0x22, 0x1c, 0x55, 0xe0,
  0x97, 0xbf, 0x03, 0x19, 0x5e, 0xfe, 0x0c, 0x9f,
  0x22, 0x0f, 0xff, 0xe1, 0x22, 0x10, 0x55, 0x20,
  0x00, 0x0e, 0x52, 0x82, 0x03, 0x03, 0x53
};

static const unsigned char pkt112[] = {
  0x42, 0xca, 0x00,
  0x64, 0x20, 0xfe, 0x0d, 0x7f,
  0x20, 0xf6, 0x55, 0x08, 0x50, 0x5f, 0x90, 0x82,
  0x01, 0x1f, 0x90, 0xc1, 0x97, 0xa0, 0x01, 0x82,
  0x01, 0xdf, 0x21, 0x80, 0x03, 0x00, 0x5e, 0x3f,
  0x20, 0x29, 0xbf, 0x03, 0x0c, 0x05, 0x27, 0x01,
  0x0c, 0x10, 0xff, 0x29, 0xbf, 0x05, 0x27, 0x9a,
  0xcf, 0xdf, 0x96, 0xe0, 0xef, 0x27, 0xff, 0x19,
  0x27, 0xfe, 0x0c, 0x9f, 0x22, 0x00, 0xff, 0xe1,
  0x22, 0x10, 0x55, 0x20, 0x00, 0x0e, 0x52, 0x82,
  0x03, 0x03, 0x53, 0x02, 0x0d, 0x3f, 0x20, 0x0f,
  0x1f, 0xf5, 0x55, 0x5f, 0x90, 0x82, 0x01, 0x1f,
  0x90, 0xc1, 0x97, 0xa0, 0x01, 0x82, 0x01, 0xdf,
  0x21, 0x80, 0x03, 0x02, 0x5e, 0x7f, 0x20, 0x00,
  0x53, 0xbf, 0x22, 0x29, 0xcf, 0xbf, 0x03, 0x01,
  0x5e, 0x5f, 0x20, 0xdf, 0x9f, 0x28, 0xbf, 0x03,
  0x0c, 0x05, 0x27, 0x24, 0xcf, 0x10, 0xdf, 0xbf,
  0x01, 0x06, 0x1e, 0xe1, 0x2f, 0xe6, 0x5c, 0xdf,
  0x2d, 0x00, 0x5b, 0x9f, 0x22, 0xdf, 0x96, 0xc8,
  0xef, 0x20, 0xff, 0x1d, 0x00, 0x00, 0x13, 0x1a,
  0x27, 0x07, 0x27, 0x9b, 0x22, 0xdf, 0x96, 0xbb,
  0xcf, 0x1a, 0x88, 0xbb, 0xcf, 0x1b, 0x88, 0x01,
  0x0f, 0xbc, 0xcf, 0x15, 0x88, 0xbc, 0xcf, 0x16,
  0x88, 0x01, 0x0f, 0xbd, 0xcf, 0x10, 0x88, 0xbd,
  0xcf, 0x11, 0x88, 0x01, 0x0f, 0xbe, 0xcf, 0x0b,
  0x88, 0xbe, 0xcf, 0x0c, 0x88, 0x01, 0x0c, 0xdd,
  0x97, 0x25, 0xaf, 0x05, 0x27
};

static const unsigned char pkt116[] = {
  0x42, 0xca, 0x00,
  0xc8, 0x20, 0xff, 0x00, 0xab,
  0x00, 0x72, 0x00, 0x4c, 0x00, 0x33, 0x00, 0x22,
  0x00, 0x09, 0x88, 0xbf, 0x9d, 0x05, 0x27, 0x09,
  0x27, 0x05, 0x88, 0xff, 0x97, 0x09, 0x27, 0xf6,
  0x9f, 0x5f, 0x02, 0xbf, 0x9d, 0x05, 0x27, 0x0f,
  0x1c, 0xc0, 0x9f, 0x8a, 0x80, 0x80, 0x10, 0x00,
  0x13, 0x0f, 0x1d, 0xc1, 0x03, 0x00, 0x5f, 0x7f,
  0x90, 0x05, 0x27, 0x53, 0x80, 0x2b, 0x0d, 0x05,
  0x27, 0x9f, 0x22, 0x8f, 0xaf, 0x67, 0x2e, 0xe0,
  0xdf, 0x04, 0x1e, 0x00, 0x52, 0x8f, 0x30, 0x67,
  0x2e, 0xe1, 0xdf, 0xdf, 0x22, 0x00, 0x54, 0x8f,
  0x30, 0x67, 0x2e, 0xfe, 0xdf, 0x04, 0x1e, 0x00,
  0x52, 0x8f, 0x31, 0x67, 0x2e, 0xff, 0xdf, 0xdf,
  0x22, 0x00, 0x54, 0x8f, 0x31, 0x8f, 0xcf, 0x03,
  0x1c, 0x03, 0x1e, 0x00, 0x55, 0x0c, 0x27, 0x0d,
  0x27, 0x4a, 0xcf, 0xdf, 0x96, 0x10, 0xcf, 0x5f,
  0xdf, 0xbf, 0x03, 0x02, 0x5f, 0x5f, 0xcf, 0x10,
  0xaf, 0x04, 0x50, 0x5e, 0xdf, 0xbf, 0x03, 0x01,
  0x53, 0x5e, 0xcf, 0x10, 0xaf, 0x46, 0x88, 0x01,
  0x2e, 0x1e, 0x80, 0xdd, 0x97, 0x0a, 0x40, 0x1c,
  0x5a, 0x37, 0x43, 0x0b, 0x5b, 0xe2, 0xcf, 0x0f,
  0x1c, 0x06, 0x1e, 0x07, 0x52, 0x62, 0xdf, 0x18,
  0x1f, 0x07, 0x53, 0x04, 0x16, 0xe2, 0xaf, 0x04,
  0x11, 0x62, 0xbf, 0x02, 0x50, 0x62, 0xcf, 0xdf,
  0x22, 0x0e, 0x54, 0x0e, 0x88, 0x62, 0xdf, 0xbf,
  0x03, 0x04, 0x53, 0x62, 0xaf
};

static const unsigned char pkt120[] = {
  0x42, 0xca, 0x00,
  0x2c, 0x21, 0xdf, 0x01, 0xe2,
  0xcf, 0x3f, 0x00, 0xe2, 0xaf, 0x0e, 0x88, 0x4a,
  0xdf, 0x3f, 0x00, 0x4a, 0xaf, 0x00, 0x2e, 0xc4,
  0x8d, 0x05, 0x27, 0xff, 0xef, 0x4a, 0xdf, 0xbf,
  0x01, 0x0a, 0x88, 0xa1, 0x27, 0x5f, 0x21, 0x7f,
  0x20, 0xfb, 0x55, 0x05, 0x27, 0x62, 0xcf, 0x03,
  0x88, 0x1f, 0x22, 0x7f, 0x20, 0xfc, 0x55, 0x05,
  0x27, 0x10, 0xdf, 0x02, 0x1f, 0x02, 0x5e, 0x04,
  0xff, 0x00, 0x2e, 0x0a, 0x50, 0x05, 0x1f, 0x02,
  0x5e, 0x03, 0xff, 0x00, 0x2e, 0x05, 0x50, 0x06,
  0x1f, 0x02, 0x5e, 0x02, 0xff, 0x00, 0x2e, 0x00,
  0x50, 0x01, 0xff, 0x05, 0x27, 0x10, 0xcf, 0x60,
  0xff, 0x3f, 0x00, 0x21, 0xff, 0x00, 0x13, 0x1a,
  0x27, 0x07, 0x27, 0x05, 0x27, 0x01, 0x00, 0x02,
  0x57, 0x42, 0x87, 0x52, 0x80, 0x92, 0x81, 0xd2,
  0x6c, 0xe2, 0x80, 0xf2, 0x80, 0xf6, 0x7b, 0xfa,
  0x7e, 0xfe, 0x8b, 0xf9, 0x45, 0x04, 0x5a, 0x40,
  0xef, 0xf9, 0x44, 0x03, 0x5b, 0x80, 0xef, 0x01,
  0x50, 0x41, 0x2e, 0x7e, 0xdf, 0x4d, 0xaf, 0x05,
  0x27, 0x28, 0xff, 0x54, 0xef, 0x19, 0x27, 0x4d,
  0x26, 0xe0, 0x2f, 0xfb, 0x54, 0x27, 0xff, 0xe0,
  0xef, 0x1b, 0x27, 0x10, 0xef, 0x06, 0xaf, 0xfc,
  0x97, 0xfc, 0x9f, 0x1c, 0x82, 0x1c, 0x82, 0x1a,
  0x27, 0x4d, 0xdf, 0x6d, 0x80, 0x5f, 0x9f, 0x06,
  0x25, 0xf5, 0x55, 0x05, 0x27, 0x26, 0x1f, 0x00,
  0x5f, 0xbf, 0x22, 0xff, 0x96
};

static const unsigned char pkt124[] = {
  0x42, 0xac, 0x00,
  0x90, 0x21, 0x99, 0xef, 0x21,
  0xff, 0x1d, 0x00, 0x00, 0x13, 0x1a, 0x27, 0x07,
  0x27, 0x1a, 0x27, 0xd6, 0x97, 0x05, 0x27, 0xa3,
  0x01, 0xa4, 0x01, 0xa3, 0x01, 0x2e, 0x00, 0xb0,
  0x00, 0xb1, 0x00, 0xb2, 0x00, 0xb3, 0x00, 0xb4,
  0x00, 0xb5, 0x00, 0xb6, 0x00, 0xb7, 0x00, 0xb8,
  0x00, 0xb9, 0x00, 0xba, 0x00, 0x56, 0x00, 0xae,
  0x00, 0x54, 0x01, 0x44, 0x01, 0x55, 0x01, 0x44,
  0x01, 0xbb, 0x00, 0xbc, 0x00, 0xbd, 0x00, 0xbe,
  0x00, 0x83, 0x00, 0x84, 0x00, 0x81, 0x00, 0x82,
  0x00, 0x24, 0x00, 0x44, 0x01, 0xdb, 0x00, 0xdc,
  0x00, 0xdd, 0x00, 0xde, 0x00, 0x04, 0x00, 0x9b,
  0x00, 0x99, 0x00, 0x9e, 0x00, 0x10, 0xef, 0xe6,
  0x81, 0x65, 0xaf, 0x10, 0xef, 0xe6, 0x81, 0x9c,
  0xaf, 0x10, 0xef, 0xe6, 0x81, 0x9a, 0xaf, 0x05,
  0x27, 0xe5, 0x31, 0x1d, 0x81, 0xe5, 0x39, 0x05,
  0x27, 0xc8, 0x46, 0x0b, 0x5b, 0xd3, 0x45, 0xfd,
  0x5a, 0xd3, 0x45, 0xfb, 0x5a, 0xd3, 0x45, 0xf9,
  0x5a, 0x41, 0x2e, 0xa1, 0xdf, 0x9f, 0x28, 0x41,
  0x2e, 0xa1, 0xbf, 0x00, 0x88, 0x05, 0x27, 0x9f,
  0x22, 0xbf, 0x22, 0x1f, 0x20, 0xfd, 0x53, 0x3f,
  0x20, 0x14, 0x1f, 0xfa, 0x55, 0x05, 0x27
};

static const unsigned char pkt128[] = {
  0x42, 0xca, 0x00,
  0xe5, 0x21, 0x25, 0x85, 0x01,
  0x1e, 0x17, 0x55, 0xdc, 0x8a, 0x41, 0x2e, 0x53,
  0xdf, 0xc1, 0x2e, 0x79, 0xdf, 0xff, 0x96, 0xdf,
  0x96, 0x41, 0x2e, 0x55, 0xdf, 0xc1, 0x2e, 0x78,
  0xdf, 0x9d, 0x01, 0x5d, 0x01, 0xff, 0x22, 0x00,
  0x54, 0xff, 0xef, 0x2e, 0xaf, 0x05, 0x27, 0x07,
  0x80, 0x9f, 0x22, 0xff, 0xaf, 0x00, 0x2e, 0x5d,
  0x89, 0x05, 0x27, 0x03, 0x1e, 0x3c, 0x55, 0xaf,
  0x8a, 0xa1, 0xcf, 0xfe, 0x1c, 0xa1, 0xaf, 0x05,
  0x81, 0x47, 0x81, 0x76, 0x88, 0xff, 0x96, 0xdf,
  0x96, 0xa1, 0xcf, 0x01, 0x18, 0xa1, 0xaf, 0x05,
  0x81, 0x64, 0xef, 0xbf, 0x22, 0xbd, 0x80, 0x47,
  0x81, 0x6b, 0x88, 0xff, 0x96, 0xdf, 0x96, 0x9b,
  0x22, 0x14, 0x1e, 0x03, 0x53, 0xff, 0x22, 0x01,
  0x55, 0x00, 0x20, 0x0a, 0x50, 0xc3, 0x97, 0xc4,
  0x9f, 0x81, 0x01, 0x42, 0x01, 0x03, 0x52, 0xfa,
  0x1e, 0x03, 0x53, 0xff, 0x22, 0x01, 0x55, 0x00,
  0x20, 0xf2, 0x50, 0x00, 0x2e, 0xf0, 0x8b, 0x03,
  0xcf, 0x7f, 0x1c, 0xff, 0xaf, 0x05, 0xef, 0xff,
  0xaf, 0x00, 0xef, 0xff, 0xaf, 0xdd, 0x97, 0xff,
  0xaf, 0xc2, 0x97, 0xff, 0xaf, 0xc3, 0x97, 0xff,
  0xaf, 0xc0, 0x97, 0xff, 0xaf, 0xc1, 0x97, 0xff,
  0xaf, 0x04, 0x0c, 0x00, 0x2e, 0x5d, 0x89, 0x05,
  0x27, 0x06, 0x1e, 0x00, 0x55, 0x0f, 0x27, 0x0a,
  0x1e, 0x07, 0x55, 0x00, 0x88, 0x66, 0x76, 0x3b,
  0x30, 0x07, 0x35, 0xff, 0xff
};

static const unsigned char pkt133[] = {
  0x42, 0xc2, 0x00,
  0x49, 0x22, 0xc2, 0xbf, 0x0d,
  0x27, 0x0c, 0x27, 0x0d, 0x1e, 0x02, 0x55, 0x28,
  0x85, 0xf5, 0x5b, 0x7b, 0x76, 0x12, 0x1e, 0x07,
  0x55, 0xdc, 0xef, 0x05, 0xff, 0x1a, 0x27, 0x56,
  0xdf, 0x3f, 0x20, 0x6d, 0x80, 0x3c, 0xaf, 0x05,
  0x27, 0x13, 0x1e, 0x01, 0x55, 0x3c, 0x23, 0x05,
  0x27, 0x23, 0x1e, 0x0c, 0x55, 0x00, 0xef, 0x02,
  0xff, 0x19, 0x27, 0xbf, 0x22, 0x20, 0xef, 0x7f,
  0x9f, 0x5f, 0x20, 0xfc, 0x55, 0xf0, 0x81, 0x9f,
  0x22, 0x41, 0x2e, 0xa3, 0xbf, 0x05, 0x27, 0x30,
  0x1e, 0x0e, 0x55, 0x7e, 0xef, 0xff, 0xaf, 0x02,
  0xef, 0xff, 0xaf, 0x00, 0xef, 0xff, 0xaf, 0xff,
  0xef, 0x17, 0xff, 0x1a, 0x27, 0x07, 0x27, 0xff,
  0xaf, 0xff, 0xbf, 0x00, 0x2e, 0x5d, 0x89, 0x05,
  0x27, 0xcb, 0x74, 0xc9, 0xcf, 0xf3, 0x1c, 0x04,
  0x18, 0xc9, 0xaf, 0x39, 0x81, 0x10, 0xff, 0xff,
  0xef, 0xc1, 0x2e, 0x7c, 0xbf, 0x41, 0x2e, 0x7b,
  0xbf, 0x02, 0xef, 0x41, 0x2e, 0x7a, 0xbf, 0xc9,
  0x31, 0x18, 0xef, 0xc0, 0xaf, 0x04, 0x27, 0x41,
  0x2e, 0x7a, 0xdf, 0xdf, 0x2d, 0x08, 0x5b, 0x01,
  0xef, 0x41, 0x2e, 0x7a, 0xbf, 0xc0, 0x23, 0x18,
  0xef, 0xc1, 0xaf, 0xcb, 0xcf, 0xcc, 0xdf, 0x05,
  0x27, 0xc9, 0x30, 0x01, 0xef, 0x41, 0x2e, 0x7a,
  0xbf, 0xc0, 0x23, 0x18, 0xef, 0xc1, 0xaf, 0x9f,
  0x22, 0xbf, 0x22, 0x05, 0x27
};

static const unsigned char pkt136[] = {
  0x42, 0xca, 0x00,
  0xa9, 0x22, 0x25, 0x85, 0x44,
  0x1e, 0x01, 0x55, 0xe2, 0x2f, 0x7d, 0x50, 0x49,
  0x1e, 0x02, 0x55, 0xe2, 0x2f, 0x79, 0x50, 0x05,
  0x27, 0x4a, 0x1e, 0x01, 0x55, 0xe2, 0x2f, 0x74,
  0x50, 0x4e, 0x1e, 0x01, 0x55, 0x00, 0x2e, 0xbb,
  0x79, 0x4f, 0x1e, 0x00, 0x55, 0x7d, 0x78, 0x55,
  0x1e, 0x00, 0x55, 0x05, 0x27, 0x58, 0x1e, 0x0d,
  0x55, 0x02, 0x44, 0x01, 0x5a, 0x00, 0x2e, 0x07,
  0x78, 0xfe, 0xcf, 0x75, 0xaf, 0xfe, 0xdf, 0x76,
  0xbf, 0x41, 0x2e, 0xa4, 0xdf, 0xdf, 0x29, 0x41,
  0x2e, 0xa4, 0xbf, 0x05, 0x27, 0x59, 0x1e, 0x02,
  0x55, 0xfe, 0xcf, 0x10, 0xaf, 0x2b, 0x7e, 0x63,
  0x1e, 0x1a, 0x55, 0x28, 0x85, 0xe2, 0x2f, 0x50,
  0x5b, 0x0c, 0xef, 0x20, 0x80, 0xe2, 0x2f, 0x4c,
  0x5a, 0xf0, 0xef, 0x00, 0xff, 0x19, 0x27, 0x08,
  0xef, 0x06, 0xaf, 0xfe, 0xcf, 0x5f, 0x9f, 0x06,
  0x25, 0xfb, 0x55, 0xfe, 0xcf, 0xfe, 0xcf, 0x41,
  0x2e, 0x40, 0xbf, 0xfe, 0xcf, 0x41, 0x2e, 0x41,
  0xbf, 0xfe, 0xcf, 0x41, 0x2e, 0x42, 0xbf, 0x05,
  0x27, 0x64, 0x1e, 0x31, 0x55, 0xb0, 0xef, 0x00,
  0xff, 0x19, 0x27, 0x0b, 0xef, 0x06, 0xaf, 0xfe,
  0xcf, 0x5f, 0x9f, 0x06, 0x25, 0xfb, 0x55, 0xfe,
  0xcf, 0x56, 0xaf, 0xfe, 0xcf, 0xae, 0xdf, 0x1f,
  0x1c, 0xe0, 0x1d, 0x5f, 0x02, 0xae, 0xbf, 0xfe,
  0xcf, 0x41, 0x2e, 0x54, 0xbf, 0xfe, 0xcf, 0x41,
  0x2e, 0x77, 0xbf, 0xfe, 0xcf
};

static const unsigned char pkt140[] = {
  0x42, 0xca, 0x00,
  0x0d, 0x23, 0x41, 0x2e, 0x55,
  0xbf, 0xfe, 0xcf, 0x41, 0x2e, 0x78, 0xbf, 0xfe,
  0xcf, 0xbb, 0xaf, 0xfe, 0xcf, 0xbc, 0xaf, 0xfe,
  0xcf, 0xbd, 0xaf, 0xfe, 0xcf, 0xbe, 0xaf, 0xfe,
  0xcf, 0x83, 0xaf, 0xfe, 0xcf, 0x84, 0xaf, 0xfe,
  0xcf, 0x81, 0xaf, 0xfe, 0xcf, 0x82, 0xaf, 0xfe,
  0xcf, 0x24, 0xaf, 0xfe, 0xcf, 0x02, 0x33, 0x05,
  0x27, 0x66, 0x1e, 0x0b, 0x55, 0x60, 0xef, 0x21,
  0xff, 0x1a, 0x27, 0x0b, 0xef, 0x06, 0xaf, 0xfe,
  0xcf, 0xfe, 0xdf, 0x06, 0x27, 0x01, 0x0e, 0x06,
  0x25, 0xf9, 0x55, 0x05, 0x27, 0x35, 0x74, 0xff,
  0x96, 0xc6, 0x2e, 0x01, 0xdf, 0x3f, 0x2c, 0xdd,
  0x9f, 0x05, 0x27, 0x01, 0xef, 0x20, 0x80, 0xe1,
  0x2f, 0xeb, 0x5a, 0xfe, 0xcf, 0xdf, 0x22, 0xe7,
  0x2f, 0x1e, 0x54, 0x01, 0xff, 0x05, 0xef, 0xff,
  0x96, 0xdf, 0x96, 0x2d, 0xff, 0x8d, 0xef, 0x19,
  0x27, 0x03, 0xcf, 0x7f, 0x1c, 0x5f, 0x9f, 0xdd,
  0x97, 0x5f, 0x9f, 0xdd, 0x97, 0x5f, 0x9f, 0x05,
  0xef, 0x06, 0xaf, 0x9f, 0x22, 0x5f, 0x9f, 0x06,
  0x25, 0xfc, 0x55, 0x5f, 0x9f, 0x06, 0x25, 0xfc,
  0x55, 0x20, 0xef, 0x08, 0xaf, 0x09, 0x23, 0x00,
  0x2e, 0xd1, 0x8d, 0x67, 0x81, 0x03, 0xef, 0xfc,
  0xaf, 0x86, 0xef, 0xaa, 0xaf, 0x08, 0xef, 0xe3,
  0xaf, 0x9f, 0x22, 0xe2, 0xaf, 0x21, 0xef, 0x41,
  0x2e, 0x47, 0xbf, 0x27, 0xef, 0xf4, 0xaf, 0x28,
  0xff, 0xa7, 0xef, 0xe1, 0xbf
};

static const unsigned char pkt144[] = {
  0x42, 0x88, 0x00,
  0x71, 0x23, 0xe0, 0xaf, 0x08,
  0xef, 0x10, 0xaf, 0x8c, 0x8d, 0x05, 0x81, 0x01,
  0x2e, 0x54, 0x80, 0x01, 0x2e, 0x56, 0x80, 0x9b,
  0x22, 0x9b, 0x22, 0x2d, 0xff, 0x95, 0xef, 0x19,
  0x27, 0x28, 0xff, 0xa7, 0xef, 0x1a, 0x27, 0x80,
  0xef, 0x06, 0xaf, 0xdc, 0x97, 0x5f, 0x9f, 0xdf,
  0x22, 0x01, 0x54, 0x00, 0x2e, 0x66, 0x8a, 0x06,
  0x25, 0xf7, 0x55, 0x2d, 0xff, 0x91, 0xef, 0x19,
  0x27, 0xdd, 0x97, 0xdd, 0x9f, 0x5f, 0x9f, 0x7f,
  0x9f, 0xfd, 0x0d, 0xdf, 0x22, 0x01, 0x55, 0xff,
  0x22, 0x01, 0x54, 0x01, 0xef, 0x1f, 0x98, 0x2f,
  0xef, 0x41, 0x2e, 0x47, 0xbf, 0x11, 0xef, 0xf4,
  0xaf, 0x28, 0xff, 0xa7, 0xef, 0xe1, 0xbf, 0xe0,
  0xaf, 0x01, 0x2e, 0x54, 0x80, 0x01, 0x2e, 0x56,
  0x80, 0x9b, 0x22, 0x9b, 0x22, 0x2e, 0xff, 0x15,
  0xef, 0x19, 0x27, 0x28, 0xff, 0xa7, 0xef, 0x1a,
  0x27, 0x80, 0xef, 0x06, 0xaf, 0x00, 0x2e, 0x3c,
  0x8a, 0x05, 0x27
};

static const unsigned char pkt148[] = {
  0x42, 0xca, 0x00,
  0xb4, 0x23, 0x37, 0xcf, 0xdf,
  0x96, 0x08, 0xcf, 0xdf, 0x96, 0x3d, 0xcf, 0xdf,
  0x96, 0x00, 0x2e, 0xd4, 0x8d, 0xdd, 0x97, 0x3d,
  0xaf, 0xdd, 0x97, 0x08, 0xaf, 0xdd, 0x97, 0x37,
  0xaf, 0x03, 0xcf, 0x51, 0x1e, 0x00, 0x55, 0x44,
  0x8b, 0xa0, 0xcf, 0xbf, 0x1c, 0xa0, 0xaf, 0x05,
  0x81, 0xfb, 0x39, 0x08, 0x45, 0x00, 0x5a, 0xfb,
  0x31, 0x0a, 0x42, 0x00, 0x5b, 0xa2, 0x39, 0x02,
  0xcf, 0x5c, 0xaf, 0xe1, 0xef, 0x40, 0x2e, 0x95,
  0xbf, 0x9f, 0x22, 0x25, 0xaf, 0x69, 0xaf, 0x6a,
  0xaf, 0x16, 0xaf, 0x40, 0x2e, 0x96, 0xbf, 0x29,
  0xaf, 0x02, 0x47, 0x06, 0x5a, 0x0a, 0x41, 0x04,
  0x5a, 0x0a, 0xdf, 0x30, 0x1d, 0x30, 0x1f, 0x00,
  0x54, 0x01, 0xef, 0x44, 0xaf, 0x09, 0xef, 0x60,
  0xaf, 0x0a, 0x40, 0x06, 0x5a, 0x10, 0xcf, 0x27,
  0xaf, 0xe2, 0x23, 0x6e, 0x23, 0x08, 0xef, 0xe3,
  0xaf, 0x6f, 0xaf, 0x0d, 0x8d, 0x5d, 0xcf, 0x30,
  0x1c, 0x00, 0x1e, 0x07, 0x55, 0xf8, 0xcf, 0x5f,
  0x2b, 0x9f, 0x29, 0xf8, 0xaf, 0xa1, 0xcf, 0xc1,
  0x1c, 0xa1, 0xaf, 0x09, 0x50, 0x10, 0x1e, 0x07,
  0x55, 0xf8, 0xcf, 0x5f, 0x29, 0x9f, 0x2b, 0xf8,
  0xaf, 0xa1, 0xcf, 0xc1, 0x1c, 0x08, 0x18, 0xa1,
  0xaf, 0x41, 0x2e, 0xa4, 0xdf, 0xdf, 0x2d, 0x04,
  0x5b, 0x75, 0xcf, 0xf4, 0xaf, 0x76, 0xcf, 0xf5,
  0xaf, 0x00, 0x50, 0x0f, 0x88, 0xe2, 0x23, 0x08,
  0xef, 0xe3, 0xaf, 0x81, 0x82
};

static const unsigned char pkt152[] = {
  0x42, 0x24, 0x00,
  0x18, 0x24, 0x4d, 0xaf, 0xdf,
  0x96, 0x64, 0xdf, 0x93, 0x82, 0x93, 0xbf, 0xdd,
  0x97, 0x77, 0xff, 0x93, 0x82, 0x94, 0xbf, 0x9e,
  0x23, 0xe4, 0x23, 0x05, 0x27, 0x14, 0xef, 0xf4,
  0xaf, 0x00, 0xef, 0xf5, 0xaf, 0x05, 0x27
};

static const unsigned char pkt156[] = {
  0x42, 0xca, 0x00,
  0x29, 0x24, 0xfe, 0xcf, 0x58,
  0xaf, 0xfe, 0xcf, 0xfe, 0xdf, 0x00, 0x2e, 0xa9,
  0x8b, 0xfe, 0xcf, 0x3c, 0xaf, 0x07, 0x3d, 0x58,
  0x40, 0x4a, 0x5a, 0x3c, 0x26, 0x48, 0x55, 0x37,
  0x45, 0x46, 0x5a, 0xe0, 0x88, 0x44, 0x5a, 0x77,
  0x88, 0x00, 0x2e, 0xd1, 0x8b, 0xfe, 0xef, 0x16,
  0x80, 0x02, 0xcf, 0xdf, 0x96, 0x61, 0xef, 0xc0,
  0xaf, 0x04, 0x27, 0xc1, 0x46, 0x04, 0x5b, 0xc0,
  0x3e, 0x40, 0xef, 0xc1, 0xaf, 0x01, 0x2e, 0x94,
  0x84, 0xd0, 0x41, 0x06, 0x5b, 0x2d, 0x88, 0xf3,
  0x5b, 0x6c, 0x86, 0xdd, 0x97, 0x1f, 0x2d, 0x05,
  0x5b, 0x03, 0x50, 0x01, 0x0c, 0x02, 0xcf, 0xc0,
  0x1c, 0x00, 0x55, 0x05, 0x88, 0xc0, 0x23, 0x20,
  0xef, 0xc1, 0xaf, 0x00, 0x2e, 0xf0, 0x8b, 0x05,
  0x27, 0x9b, 0x22, 0x37, 0x45, 0x05, 0x5a, 0x41,
  0x2e, 0x52, 0xdf, 0xdf, 0x2d, 0x04, 0x5b, 0x00,
  0x28, 0x02, 0x50, 0x3b, 0x43, 0x00, 0x5b, 0x00,
  0x28, 0xd3, 0xdf, 0xc6, 0x2e, 0x15, 0xbf, 0xd3,
  0x3c, 0x40, 0xef, 0x09, 0x80, 0xdd, 0x97, 0xff,
  0xaf, 0x00, 0x2e, 0x5d, 0x89, 0xc6, 0x2e, 0x15,
  0xdf, 0x10, 0x1d, 0xd3, 0xcf, 0x3f, 0x02, 0xd3,
  0xaf, 0x05, 0x27, 0xc1, 0x83, 0x07, 0x45, 0x05,
  0x27, 0x3d, 0x23, 0x07, 0x3d, 0x02, 0xcf, 0xdf,
  0x96, 0x2e, 0x88, 0x26, 0x88, 0xfe, 0xef, 0x16,
  0x80, 0x05, 0xef, 0xc0, 0xaf, 0x04, 0x27, 0xd0,
  0x41, 0x02, 0x5b, 0xee, 0x8f
};

static const unsigned char pkt160[] = {
  0x42, 0xca, 0x00,
  0x8d, 0x24, 0xfa, 0x5b, 0xbf,
  0x50, 0x31, 0x82, 0x04, 0xef, 0xc1, 0xaf, 0x9b,
  0x22, 0x41, 0x88, 0xdd, 0x97, 0xdf, 0x22, 0x02,
  0x55, 0x58, 0x40, 0x02, 0x5a, 0x09, 0x50, 0x58,
  0x40, 0x07, 0x5a, 0xdd, 0x97, 0x1f, 0x2d, 0xb8,
  0x5a, 0x7a, 0x88, 0xb7, 0x5b, 0x9b, 0x22, 0xc7,
  0x8f, 0xb4, 0x50, 0x75, 0x88, 0xdc, 0x5b, 0xb7,
  0x8f, 0x58, 0x41, 0x01, 0x5b, 0x01, 0x0c, 0xad,
  0x7f, 0xd6, 0x50, 0x41, 0x2e, 0x52, 0xdf, 0xed,
  0x1c, 0x04, 0x18, 0x41, 0x2e, 0x52, 0xbf, 0x05,
  0x27, 0x00, 0x2e, 0xb9, 0x8b, 0xae, 0xdf, 0xe0,
  0x19, 0xae, 0xbf, 0x57, 0x40, 0x00, 0x5b, 0xa1,
  0x32, 0x57, 0x43, 0x00, 0x5b, 0xae, 0x3f, 0x05,
  0x81, 0x05, 0x27, 0x41, 0x2e, 0x52, 0xdf, 0x03,
  0x18, 0x41, 0x2e, 0x52, 0xbf, 0x05, 0x27, 0xd3,
  0xdf, 0xff, 0x96, 0x9b, 0x22, 0x0b, 0x88, 0xd3,
  0x3c, 0x07, 0x80, 0xdd, 0x97, 0xff, 0xaf, 0x00,
  0x2e, 0x5d, 0x89, 0xdd, 0x9f, 0x10, 0x1d, 0xd3,
  0xcf, 0x3f, 0x02, 0xd3, 0xaf, 0x05, 0x27, 0x37,
  0x45, 0x0e, 0x5a, 0x40, 0x88, 0x0c, 0x5a, 0xd7,
  0x8f, 0x00, 0x2e, 0xd7, 0x8b, 0x00, 0x2e, 0xeb,
  0x8b, 0x41, 0x2e, 0x52, 0xdf, 0xdf, 0x2d, 0x00,
  0x5b, 0x00, 0x28, 0x00, 0x2e, 0xf0, 0x8b, 0x05,
  0x27, 0xf9, 0xcf, 0xdf, 0x96, 0xf9, 0x3d, 0x00,
  0x2e, 0xd1, 0x8d, 0x28, 0xff, 0xa7, 0xef, 0xe1,
  0xbf, 0xe0, 0xaf, 0x09, 0xef
};

static const unsigned char pkt164[] = {
  0x42, 0x6c, 0x00,
  0xf1, 0x24, 0x10, 0xaf, 0x0e,
  0x8c, 0x05, 0x81, 0x01, 0x2e, 0x54, 0x80, 0x01,
  0x2e, 0x56, 0x80, 0x20, 0x82, 0x7b, 0x8c, 0x37,
  0x82, 0x26, 0x37, 0x00, 0x5a, 0x0c, 0x50, 0xff,
  0x96, 0xdf, 0x96, 0x79, 0xcf, 0x7a, 0xdf, 0xff,
  0x96, 0xdf, 0x96, 0xc2, 0x97, 0xc3, 0x9f, 0x9d,
  0x01, 0x5d, 0x01, 0x07, 0x53, 0xdd, 0x97, 0xdd,
  0x9f, 0x79, 0xaf, 0x7a, 0xbf, 0x3b, 0x3b, 0xdd,
  0x97, 0xf9, 0xaf, 0x05, 0x27, 0xff, 0x22, 0x01,
  0x55, 0x32, 0x1e, 0xf3, 0x5f, 0x02, 0x0c, 0xf6,
  0x8f, 0x3b, 0x33, 0x00, 0x28, 0x05, 0x27, 0x0d,
  0x27, 0x3c, 0x26, 0x07, 0x54, 0x3c, 0xcf, 0x3d,
  0xdf, 0x3f, 0x20, 0x3d, 0xbf, 0xdf, 0x03, 0x01,
  0x52, 0x3d, 0x23, 0x0c, 0x27, 0x0d, 0x27
};

static const unsigned char pkt168[] = {
  0x42, 0x50, 0x00,
  0x26, 0x25, 0x08, 0x44, 0x12,
  0x5a, 0x07, 0x40, 0x01, 0x5b, 0x4f, 0x80, 0x00,
  0x50, 0x53, 0x80, 0x27, 0x0d, 0x25, 0xcf, 0x1f,
  0x98, 0x29, 0xcf, 0x09, 0x27, 0x28, 0xdf, 0x3f,
  0x02, 0x5f, 0x98, 0x62, 0xcf, 0xdf, 0x98, 0xd9,
  0x0d, 0x02, 0x0d, 0x00, 0x2e, 0xd5, 0x7f, 0x05,
  0x27, 0x01, 0x0d, 0x41, 0x2e, 0x56, 0xdf, 0x5f,
  0x9f, 0x41, 0x2e, 0x57, 0xdf, 0x5f, 0x9f, 0x41,
  0x2e, 0x58, 0xdf, 0x5f, 0x9f, 0x41, 0x2e, 0x59,
  0xdf, 0x5f, 0x9f, 0x06, 0x0d, 0x3b, 0xcf, 0x5f,
  0x9f, 0x05, 0x27
};

static const unsigned char pkt172[] = {
  0x42, 0xca, 0x00,
  0x4d, 0x25, 0x9b, 0x22, 0xbb,
  0x89, 0x22, 0x88, 0x75, 0x88, 0x14, 0x86, 0x2b,
  0x86, 0x2b, 0x86, 0x2b, 0x86, 0x2b, 0x86, 0xa0,
  0x88, 0x2e, 0x89, 0x24, 0x89, 0x02, 0x33, 0x07,
  0x80, 0xdd, 0x97, 0xff, 0xaf, 0x00, 0x2e, 0x5d,
  0x89, 0x05, 0x27, 0x6c, 0xcf, 0x6d, 0xdf, 0xbf,
  0x01, 0x6c, 0xaf, 0x6d, 0x26, 0x00, 0x2e, 0x33,
  0x55, 0x00, 0x2e, 0x4e, 0x50, 0xdf, 0x96, 0xff,
  0x96, 0x32, 0xff, 0x07, 0xef, 0x91, 0x81, 0x7f,
  0x20, 0xfb, 0x55, 0xdd, 0x9f, 0xdd, 0x97, 0x05,
  0x27, 0x9f, 0x22, 0x6b, 0xaf, 0x00, 0x2e, 0x6e,
  0x8f, 0x00, 0xef, 0x41, 0x2e, 0x44, 0xbf, 0x7f,
  0xef, 0x41, 0x2e, 0x45, 0xbf, 0x80, 0xef, 0x0a,
  0xaf, 0x00, 0x2e, 0xd1, 0x8d, 0x88, 0x82, 0x8c,
  0x82, 0x6b, 0xcf, 0x10, 0xaf, 0x02, 0x2e, 0x02,
  0x81, 0x40, 0xef, 0x6d, 0xaf, 0x80, 0xef, 0x6c,
  0xaf, 0x00, 0x2e, 0xc4, 0x8d, 0x05, 0x81, 0x01,
  0x2e, 0x54, 0x80, 0x01, 0x2e, 0x56, 0x80, 0x7f,
  0x89, 0xff, 0x2f, 0xca, 0x5a, 0x6c, 0xcf, 0x6d,
  0xdf, 0x3f, 0x00, 0x6c, 0xaf, 0x6d, 0x26, 0x03,
  0x54, 0x6d, 0xdf, 0x16, 0x82, 0x6d, 0xbf, 0xeb,
  0x50, 0x6b, 0xcf, 0x08, 0x1e, 0x11, 0x5f, 0x6c,
  0x24, 0x02, 0x53, 0xff, 0xef, 0x6c, 0xaf, 0x10,
  0x50, 0x6c, 0x24, 0x02, 0x53, 0xff, 0xef, 0x6c,
  0xaf, 0x0b, 0x50, 0x6b, 0xcf, 0x0a, 0x1e, 0x08,
  0x55, 0x6c, 0x24, 0x02, 0x53
};

static const unsigned char pkt176[] = {
  0x42, 0xca, 0x00,
  0xb1, 0x25, 0xff, 0xef, 0x6c,
  0xaf, 0x03, 0x50, 0x6c, 0x24, 0x01, 0x53, 0xff,
  0xef, 0x6c, 0xaf, 0x6b, 0xcf, 0xdf, 0x96, 0xb0,
  0xef, 0x00, 0xff, 0x1d, 0x00, 0x00, 0x13, 0x1b,
  0x27, 0x6c, 0xcf, 0x9f, 0x9d, 0x6b, 0xcf, 0x1f,
  0x20, 0x6b, 0xaf, 0x0a, 0x1e, 0xbc, 0x5f, 0x05,
  0x27, 0x0c, 0xef, 0x41, 0x2e, 0x76, 0xbf, 0x10,
  0xef, 0x6d, 0xaf, 0xae, 0xcf, 0xe0, 0x1c, 0xae,
  0xaf, 0x0b, 0x78, 0xcb, 0xcf, 0xcc, 0xdf, 0x0a,
  0x1f, 0x07, 0x52, 0x01, 0x5e, 0x00, 0x1e, 0x04,
  0x5f, 0xae, 0xcf, 0x6d, 0xdf, 0xbf, 0x01, 0xae,
  0xaf, 0x03, 0x78, 0xae, 0xcf, 0x6d, 0xdf, 0x3f,
  0x00, 0xae, 0xaf, 0x16, 0x82, 0x6d, 0xbf, 0x05,
  0x81, 0x64, 0xef, 0xbf, 0x22, 0xbd, 0x80, 0x34,
  0x81, 0x53, 0x81, 0x6d, 0x26, 0xe5, 0x55, 0xcb,
  0xcf, 0xcc, 0xdf, 0x0a, 0x1f, 0x02, 0x5e, 0x04,
  0x52, 0x00, 0x1e, 0x02, 0x5f, 0xae, 0xcf, 0x5f,
  0x20, 0xae, 0xaf, 0x00, 0xef, 0x41, 0x2e, 0x76,
  0xbf, 0x05, 0x27, 0x00, 0x2e, 0x6e, 0x8f, 0x02,
  0x2e, 0x6b, 0x81, 0x00, 0x2e, 0xd1, 0x8d, 0x73,
  0x23, 0x0a, 0xef, 0x10, 0xaf, 0x02, 0x2e, 0x02,
  0x81, 0x80, 0xef, 0x00, 0x2e, 0xc4, 0x8d, 0x05,
  0x81, 0x08, 0xef, 0x06, 0xaf, 0x01, 0x2e, 0x54,
  0x80, 0x01, 0x2e, 0x56, 0x80, 0x06, 0x25, 0xf9,
  0x55, 0xb3, 0x88, 0x40, 0xcf, 0xe0, 0xaf, 0x41,
  0xdf, 0xe1, 0xbf, 0x41, 0x2e
};

static const unsigned char pkt180[] = {
  0x42, 0xca, 0x00,
  0x15, 0x26, 0x4e, 0xdf, 0xf7,
  0x1c, 0x41, 0x2e, 0x4e, 0xbf, 0x01, 0x2e, 0x54,
  0x80, 0x01, 0x2e, 0x56, 0x80, 0x4f, 0x82, 0x40,
  0x2e, 0x8f, 0xdf, 0xdf, 0x22, 0xed, 0x55, 0x30,
  0x88, 0x4e, 0x23, 0x4e, 0xcf, 0x31, 0x88, 0x37,
  0x88, 0x3f, 0x9f, 0x4e, 0xcf, 0x2d, 0x88, 0x39,
  0x88, 0x1f, 0x9f, 0x4e, 0x24, 0x4e, 0xcf, 0x04,
  0x1e, 0xf3, 0x55, 0xf8, 0x0f, 0x08, 0xef, 0x06,
  0xaf, 0xf6, 0x97, 0xbc, 0x03, 0x01, 0x5f, 0xff,
  0x0f, 0xfc, 0x97, 0x06, 0x25, 0xf9, 0x55, 0xf8,
  0x0f, 0x08, 0xff, 0x06, 0xbf, 0xf6, 0x9f, 0xdf,
  0x01, 0xa1, 0x27, 0x7f, 0x21, 0x3f, 0x9f, 0x06,
  0x25, 0xf8, 0x55, 0xf8, 0x0f, 0x04, 0xef, 0x06,
  0xaf, 0xbb, 0xef, 0x00, 0xff, 0x1a, 0x27, 0xfc,
  0x9f, 0xfc, 0x97, 0x09, 0x27, 0x5f, 0x02, 0x3f,
  0x97, 0x06, 0x25, 0xf8, 0x55, 0x81, 0xcf, 0x24,
  0xaf, 0x05, 0x27, 0x54, 0xef, 0x28, 0xff, 0x1b,
  0x27, 0x05, 0x27, 0xdf, 0x96, 0x40, 0xcf, 0x41,
  0xdf, 0x1d, 0x00, 0x00, 0x13, 0x19, 0x27, 0x05,
  0x27, 0x0f, 0xff, 0x0b, 0x88, 0x40, 0x10, 0x00,
  0x13, 0x8e, 0x81, 0x05, 0x27, 0xf0, 0xff, 0x05,
  0x88, 0x04, 0x11, 0x3f, 0x22, 0xff, 0x97, 0x09,
  0x27, 0x0f, 0x1c, 0x05, 0x27, 0xff, 0x96, 0x9b,
  0x22, 0x9b, 0x22, 0x80, 0xef, 0x06, 0xaf, 0xe0,
  0x97, 0x02, 0x03, 0xbf, 0x22, 0x00, 0x00, 0xc1,
  0x00, 0x1f, 0x90, 0x7f, 0x90
};

static const unsigned char pkt184[] = {
  0x42, 0xca, 0x00,
  0x79, 0x26, 0x04, 0x0d, 0x06,
  0x25, 0xf5, 0x55, 0x03, 0x0c, 0x05, 0x27, 0x04,
  0xef, 0x10, 0xaf, 0x02, 0x2e, 0x02, 0x81, 0x05,
  0x81, 0xf7, 0xef, 0x16, 0x80, 0x6b, 0x81, 0x05,
  0x27, 0x73, 0x23, 0x08, 0xef, 0x0b, 0xaf, 0x02,
  0x2e, 0x6b, 0x81, 0x00, 0x2e, 0x6e, 0x8f, 0x00,
  0x2e, 0xd1, 0x8d, 0x0a, 0xef, 0x10, 0xaf, 0x02,
  0x2e, 0x02, 0x81, 0x88, 0x82, 0x02, 0x2e, 0x9f,
  0x80, 0x80, 0xef, 0x00, 0x2e, 0xc4, 0x8d, 0x05,
  0x81, 0x0b, 0xcf, 0x06, 0xaf, 0x01, 0x2e, 0x54,
  0x80, 0x01, 0x2e, 0x56, 0x80, 0x06, 0x25, 0xf9,
  0x55, 0x1f, 0x88, 0x20, 0x82, 0x02, 0x2e, 0x76,
  0x81, 0xf7, 0xef, 0x16, 0x80, 0x81, 0xcf, 0x72,
  0xaf, 0x02, 0x2e, 0x6b, 0x81, 0x02, 0x2e, 0xc0,
  0x81, 0x08, 0xef, 0x02, 0x2e, 0x51, 0x80, 0x08,
  0xef, 0x02, 0x2e, 0x7a, 0x80, 0x01, 0x2e, 0x89,
  0x81, 0x2d, 0xcf, 0xdf, 0x96, 0x2c, 0xcf, 0xdf,
  0x96, 0x2a, 0xcf, 0x2b, 0xdf, 0x9d, 0x01, 0x5d,
  0x01, 0x83, 0xaf, 0x84, 0xbf, 0xc8, 0xef, 0x0b,
  0xaf, 0x05, 0x27, 0x0a, 0xef, 0x73, 0x43, 0x02,
  0x5b, 0x73, 0xcf, 0x09, 0x27, 0x0f, 0x1c, 0x81,
  0xaf, 0x73, 0xcf, 0x09, 0x27, 0x30, 0x1c, 0xfc,
  0xdf, 0xcf, 0x1d, 0x5f, 0x02, 0xfc, 0xbf, 0x81,
  0xcf, 0x10, 0xaf, 0x02, 0x2e, 0x02, 0x81, 0x88,
  0x82, 0x02, 0x2e, 0x9f, 0x80, 0x40, 0xef, 0x6b,
  0xaf, 0x80, 0xef, 0x82, 0xaf
};

static const unsigned char pkt188[] = {
  0x42, 0x9a, 0x00,
  0xdd, 0x26, 0x00, 0x2e, 0xc4,
  0x8d, 0x05, 0x81, 0x01, 0x2e, 0x54, 0x80, 0x01,
  0x2e, 0x56, 0x80, 0x20, 0x82, 0x02, 0x2e, 0xe6,
  0x80, 0x0a, 0x5b, 0x73, 0x43, 0x18, 0x5a, 0x81,
  0xcf, 0x5e, 0xdf, 0xbf, 0x03, 0x14, 0x5f, 0x5f,
  0x20, 0x81, 0xaf, 0xdf, 0x22, 0x10, 0x54, 0xde,
  0x50, 0x40, 0x2e, 0x8f, 0xdf, 0x1f, 0x2c, 0x0c,
  0x5a, 0x5f, 0x2c, 0x09, 0x5b, 0x82, 0xcf, 0x6b,
  0xdf, 0x3f, 0x00, 0x82, 0xaf, 0x6b, 0x26, 0xe8,
  0x54, 0x6b, 0xdf, 0x16, 0x82, 0x6b, 0xbf, 0xd9,
  0x50, 0x05, 0x27, 0x82, 0xcf, 0x6b, 0xdf, 0xbf,
  0x01, 0x82, 0xaf, 0x6b, 0x26, 0xf4, 0x55, 0xdc,
  0x50, 0x88, 0x82, 0x8c, 0x82, 0x9f, 0x22, 0xbb,
  0xaf, 0xbc, 0xaf, 0xbd, 0xaf, 0xbe, 0xaf, 0x05,
  0x27, 0xf9, 0x44, 0x08, 0x5a, 0xc1, 0x2e, 0x81,
  0xdf, 0x01, 0x1f, 0x0e, 0x52, 0x0c, 0x5e, 0xc1,
  0x2e, 0x80, 0xdf, 0xfe, 0x1f, 0x09, 0x52, 0xc1,
  0x2e, 0x81, 0xdf, 0x03, 0x1f, 0x05, 0x52, 0x03,
  0x5e, 0xc1, 0x2e, 0x80, 0xdf, 0xfc, 0x1f, 0x00,
  0x52, 0x0c, 0x27, 0x0d, 0x27
};

static const unsigned char pkt192[] = {
  0x42, 0x7e, 0x00,
  0x29, 0x27, 0x53, 0x80, 0x01,
  0x0d, 0xf5, 0x97, 0xff, 0x0d, 0x1f, 0x99, 0x49,
  0xcf, 0x5f, 0x99, 0x08, 0x44, 0x00, 0x2e, 0x32,
  0x5a, 0x0b, 0x0d, 0x44, 0xcf, 0x0c, 0x41, 0x00,
  0x5b, 0x1f, 0x20, 0x44, 0xaf, 0x5f, 0x9f, 0x04,
  0x0d, 0x11, 0xcf, 0x5f, 0x9f, 0x12, 0xcf, 0x5f,
  0x9f, 0x1c, 0xcf, 0x5f, 0x9f, 0x1d, 0xcf, 0x5f,
  0x9f, 0x4d, 0xcf, 0x5f, 0x9f, 0x49, 0xcf, 0x5f,
  0x9f, 0x06, 0x0d, 0xe0, 0x97, 0x0f, 0x1c, 0x5f,
  0x9f, 0x0a, 0xcf, 0x5f, 0x9f, 0x09, 0xcf, 0x5f,
  0x9f, 0x78, 0xcf, 0x5f, 0x9f, 0x9f, 0xcf, 0x5f,
  0x9f, 0x92, 0xcf, 0x5f, 0x9f, 0x19, 0xcf, 0x5f,
  0x9f, 0x02, 0x0d, 0x85, 0xcf, 0x5f, 0x9f, 0x44,
  0xdf, 0x02, 0x2e, 0x8c, 0x81, 0x5f, 0x9f, 0x4d,
  0xcf, 0x5f, 0x9f, 0x01, 0x0d, 0x6a, 0xcf, 0x09,
  0x27, 0x69, 0xdf, 0x3f, 0x02, 0x5f, 0x9f, 0x05,
  0x27
};

static const unsigned char pkt196[] = {
  0x42, 0xca, 0x00,
  0x67, 0x27, 0x00, 0x2e, 0xf5,
  0x88, 0x39, 0x81, 0x84, 0x88, 0x05, 0xcf, 0xdf,
  0x22, 0x33, 0x55, 0x04, 0xcf, 0x2a, 0x1e, 0x30,
  0x55, 0xfe, 0xdf, 0xfe, 0xcf, 0x00, 0x1f, 0x1b,
  0x55, 0x00, 0x1e, 0x0d, 0x54, 0xc6, 0x2e, 0x00,
  0xdf, 0x3f, 0x20, 0xbf, 0x03, 0x14, 0x55, 0xc6,
  0x2e, 0x01, 0xdf, 0x3f, 0x2c, 0x10, 0x5b, 0x46,
  0x2e, 0x00, 0xbf, 0x00, 0x2e, 0xdb, 0x88, 0x09,
  0x78, 0x00, 0xef, 0x46, 0x2e, 0x00, 0xbf, 0x46,
  0x2e, 0x01, 0xdf, 0x1f, 0x28, 0x46, 0x2e, 0x01,
  0xbf, 0x00, 0x2e, 0xbc, 0x88, 0x13, 0x88, 0x05,
  0x27, 0x46, 0x2e, 0x01, 0xdf, 0x1f, 0x2a, 0x46,
  0x2e, 0x01, 0xbf, 0x41, 0x2e, 0xb6, 0xdf, 0x01,
  0xff, 0xab, 0xef, 0x19, 0x27, 0x42, 0xff, 0x7f,
  0x98, 0x9f, 0x98, 0x24, 0x28, 0x2a, 0x85, 0x24,
  0x2a, 0x05, 0x27, 0x2c, 0x85, 0x05, 0x27, 0xfd,
  0x0c, 0x00, 0x2e, 0xab, 0x88, 0x14, 0xef, 0x00,
  0x2e, 0xef, 0x88, 0x32, 0x88, 0x3a, 0x88, 0x34,
  0x88, 0x38, 0x88, 0x32, 0x88, 0x36, 0x88, 0x30,
  0x88, 0x34, 0x88, 0x2e, 0x88, 0x32, 0x88, 0x46,
  0x2e, 0x00, 0xdf, 0x1f, 0x9f, 0xe2, 0xef, 0x1f,
  0x90, 0xe0, 0xff, 0x7f, 0x90, 0x0e, 0xef, 0x00,
  0x2e, 0xe7, 0x88, 0x80, 0xef, 0x1f, 0x9f, 0x9f,
  0x22, 0x1f, 0x9f, 0x1f, 0x9f, 0x1f, 0x9f, 0x1f,
  0x9f, 0x1f, 0x9f, 0x1f, 0x9f, 0x01, 0xef, 0x1f,
  0x9f, 0xb8, 0xef, 0x1f, 0x9f
};

static const unsigned char pkt200[] = {
  0x42, 0x66, 0x00,
  0xcb, 0x27, 0x00, 0x2e, 0xab,
  0x88, 0x40, 0xef, 0xfc, 0x9f, 0x5f, 0x20, 0xfc,
  0x55, 0x03, 0x0c, 0x01, 0x2e, 0x6e, 0x86, 0x01,
  0x2e, 0x05, 0x86, 0x00, 0x2e, 0xb5, 0x88, 0x00,
  0x2e, 0xb1, 0x88, 0x14, 0xef, 0x00, 0x2e, 0xb7,
  0x88, 0x05, 0x27, 0x40, 0xef, 0x28, 0xff, 0x1a,
  0x27, 0x05, 0x27, 0x16, 0x27, 0x04, 0x10, 0x00,
  0x13, 0x1a, 0x27, 0x05, 0x27, 0xd9, 0x9f, 0x3f,
  0x9f, 0xd8, 0x9f, 0x3f, 0x9f, 0xd7, 0x9f, 0x3f,
  0x9f, 0xd6, 0x9f, 0x3f, 0x9f, 0x05, 0x27, 0x7f,
  0xef, 0x28, 0xff, 0x46, 0x2e, 0x1d, 0xbf, 0xc6,
  0x2e, 0x1c, 0xbf, 0x93, 0xef, 0x28, 0xff, 0x46,
  0x2e, 0x1f, 0xbf, 0xc6, 0x2e, 0x1e, 0xbf, 0x05,
  0x27
};

static const unsigned char pkt204[] = {
  0x42, 0xca, 0x00,
  0xfd, 0x27, 0xfd, 0x0c, 0x00,
  0x2e, 0xf5, 0x88, 0x0d, 0x84, 0x05, 0xcf, 0xdf,
  0x22, 0x00, 0x2e, 0x98, 0x55, 0x04, 0xcf, 0x14,
  0x1e, 0x00, 0x2e, 0x94, 0x55, 0x00, 0x2e, 0xab,
  0x88, 0xbb, 0xef, 0x1f, 0x90, 0x91, 0xff, 0x7f,
  0x90, 0x14, 0xef, 0x00, 0x2e, 0xe7, 0x88, 0x14,
  0xef, 0x00, 0x2e, 0xef, 0x88, 0x33, 0xef, 0x1f,
  0x90, 0x71, 0xff, 0x7f, 0x90, 0x18, 0xef, 0x00,
  0x2e, 0xe7, 0x88, 0x00, 0x2e, 0xab, 0x88, 0x40,
  0xef, 0xfc, 0x9f, 0x5f, 0x20, 0xfc, 0x55, 0x01,
  0x2e, 0x6e, 0x86, 0x01, 0x2e, 0x05, 0x86, 0x00,
  0x2e, 0xab, 0x88, 0x7a, 0x88, 0x0a, 0xef, 0x00,
  0x2e, 0xb7, 0x88, 0x76, 0x88, 0x00, 0xff, 0x80,
  0xef, 0x19, 0x27, 0x0a, 0xef, 0xdc, 0x9f, 0x7f,
  0x9f, 0x5f, 0x20, 0xfb, 0x55, 0x0d, 0x84, 0x6c,
  0x88, 0x0a, 0xef, 0x00, 0x2e, 0xb7, 0x88, 0x68,
  0x88, 0x0a, 0xef, 0xdc, 0x9f, 0x7f, 0x9f, 0x5f,
  0x20, 0xfb, 0x55, 0x5e, 0x88, 0xa4, 0x8f, 0x9e,
  0x8f, 0xa2, 0x8f, 0x9c, 0x8f, 0xa0, 0x8f, 0x9a,
  0x8f, 0x9e, 0x8f, 0x98, 0x8f, 0x9c, 0x8f, 0x9d,
  0xef, 0x1f, 0x90, 0xda, 0xff, 0x7f, 0x90, 0x0f,
  0xef, 0x00, 0x2e, 0xe7, 0x88, 0x80, 0xef, 0x1f,
  0x9f, 0x9f, 0x22, 0x1f, 0x9f, 0x1f, 0x9f, 0x1f,
  0x9f, 0x1f, 0x9f, 0x1f, 0x9f, 0x1f, 0x9f, 0x03,
  0xef, 0x1f, 0x9f, 0xb8, 0xef, 0x1f, 0x9f, 0x00,
  0x2e, 0xab, 0x88, 0x40, 0xef
};

static const unsigned char pkt208[] = {
  0x42, 0xca, 0x00,
  0x61, 0x28, 0xfc, 0x9f, 0x5f,
  0x20, 0xfc, 0x55, 0x01, 0x2e, 0x05, 0x86, 0x00,
  0x2e, 0xb5, 0x88, 0x72, 0x88, 0x7c, 0x8f, 0x76,
  0x8f, 0x7a, 0x8f, 0x74, 0x8f, 0x78, 0x8f, 0x72,
  0x8f, 0x76, 0x8f, 0x70, 0x8f, 0x74, 0x8f, 0x68,
  0x88, 0x14, 0xef, 0xfc, 0x9f, 0x5f, 0x20, 0xfc,
  0x55, 0x01, 0xff, 0xab, 0xef, 0x19, 0x27, 0x60,
  0x88, 0x11, 0xff, 0xbf, 0x90, 0x51, 0xff, 0xc2,
  0x97, 0xdf, 0x01, 0x7f, 0x98, 0xfc, 0x9f, 0xbf,
  0x98, 0x24, 0x28, 0xc2, 0x9f, 0x7f, 0x20, 0xbf,
  0x90, 0xf4, 0x55, 0x24, 0x2a, 0x1d, 0x88, 0x72,
  0xef, 0xff, 0xaf, 0x14, 0xef, 0xff, 0xaf, 0x00,
  0xef, 0xff, 0xaf, 0x00, 0xff, 0x80, 0xef, 0x19,
  0x27, 0x14, 0xff, 0xfd, 0x97, 0xff, 0xaf, 0x7f,
  0x20, 0xfb, 0x55, 0x00, 0x2e, 0x5f, 0x89, 0x03,
  0x0c, 0x02, 0x2e, 0xdd, 0x81, 0x05, 0x27, 0x2c,
  0x85, 0x05, 0x27, 0x40, 0xef, 0x28, 0xff, 0x1a,
  0x27, 0x05, 0x27, 0x02, 0xef, 0x06, 0xff, 0x1a,
  0x27, 0x05, 0x27, 0x01, 0xff, 0xab, 0xef, 0x19,
  0x27, 0x08, 0xef, 0x1f, 0x98, 0xe4, 0x29, 0x00,
  0xff, 0xff, 0x96, 0x20, 0xff, 0xff, 0x96, 0x00,
  0xff, 0xff, 0x96, 0x40, 0xff, 0xff, 0x96, 0x00,
  0xff, 0xff, 0x96, 0x60, 0xff, 0xff, 0x96, 0x00,
  0xff, 0xff, 0x96, 0x00, 0xff, 0xff, 0x96, 0x01,
  0xff, 0xff, 0x96, 0x20, 0xff, 0xff, 0x96, 0x00,
  0xff, 0xff, 0x96, 0x02, 0xff
};

static const unsigned char pkt212[] = {
  0x42, 0x38, 0x00,
  0xc5, 0x28, 0xff, 0x96, 0x02,
  0xff, 0xff, 0x96, 0x82, 0xff, 0xff, 0x96, 0x02,
  0xff, 0xff, 0x96, 0x05, 0x88, 0x46, 0x2e, 0x01,
  0xdf, 0x9f, 0x28, 0x46, 0x2e, 0x01, 0xbf, 0x05,
  0x27, 0x0f, 0xef, 0x5f, 0x98, 0xdd, 0x9f, 0xbf,
  0x98, 0x24, 0x28, 0x5f, 0x20, 0xf9, 0x55, 0x24,
  0x2a, 0x05, 0x27, 0x7f, 0xef, 0x28, 0xff, 0x1b,
  0x27, 0x05, 0x27
};

static const unsigned char pkt216[] = {
  0x42, 0xca, 0x00,
  0xe0, 0x28, 0xe1, 0x97, 0xe2,
  0x9f, 0x46, 0x2e, 0x28, 0xbf, 0xc6, 0x2e, 0x29,
  0xbf, 0xad, 0x88, 0x0a, 0x5b, 0xe9, 0x97, 0xea,
  0x9f, 0x4f, 0xaf, 0x50, 0xbf, 0x46, 0x2e, 0x28,
  0xdf, 0xc6, 0x2e, 0x29, 0xdf, 0x10, 0x10, 0x00,
  0x13, 0x01, 0x78, 0x03, 0x10, 0x00, 0x13, 0xff,
  0x96, 0xdf, 0x96, 0xd6, 0xcf, 0xd7, 0xdf, 0x0f,
  0x1d, 0x01, 0x10, 0x00, 0x13, 0xff, 0x96, 0xdf,
  0x96, 0xc8, 0xdf, 0xc7, 0xcf, 0x1f, 0x1d, 0xff,
  0x96, 0xdf, 0x96, 0xc2, 0x97, 0xc3, 0x9f, 0x9d,
  0x01, 0x5d, 0x01, 0xf5, 0x52, 0xc3, 0x03, 0x02,
  0x5e, 0xf2, 0x52, 0x82, 0x03, 0xf0, 0x52, 0x02,
  0x0c, 0xf8, 0x43, 0x03, 0x5b, 0x08, 0x44, 0x01,
  0x5a, 0x00, 0x2e, 0xf3, 0x8f, 0x7f, 0x88, 0x6d,
  0x5b, 0x41, 0x2e, 0xaf, 0xdf, 0xdf, 0x29, 0x41,
  0x2e, 0xaf, 0xbf, 0x46, 0x2e, 0x28, 0xdf, 0xc6,
  0x2e, 0x29, 0xdf, 0x03, 0x16, 0x00, 0x15, 0x46,
  0x2e, 0x28, 0xbf, 0xc6, 0x2e, 0x29, 0xbf, 0x15,
  0x27, 0xff, 0x96, 0xdf, 0x96, 0x8d, 0x88, 0x94,
  0x88, 0xcd, 0x88, 0x01, 0xff, 0xab, 0xef, 0x19,
  0x27, 0x6b, 0x88, 0xbf, 0x22, 0x3f, 0x98, 0x05,
  0xff, 0x7f, 0x98, 0xdd, 0x9f, 0xbf, 0x98, 0x24,
  0x28, 0x04, 0xff, 0x7f, 0x98, 0xdd, 0x9f, 0xbf,
  0x98, 0x24, 0x28, 0x66, 0xff, 0xbf, 0x99, 0x12,
  0xff, 0x7f, 0x99, 0xdd, 0x97, 0xdd, 0x9f, 0x19,
  0x27, 0xe0, 0x97, 0xff, 0xaf
};

static const unsigned char pkt220[] = {
  0x42, 0xca, 0x00,
  0x44, 0x29, 0x46, 0x2e, 0x28,
  0xdf, 0xc6, 0x2e, 0x29, 0xdf, 0x13, 0x10, 0x00,
  0x13, 0xff, 0xaf, 0xff, 0xbf, 0xe3, 0x97, 0xff,
  0xaf, 0xe4, 0x97, 0xff, 0xaf, 0xe5, 0x97, 0xff,
  0xaf, 0xef, 0x88, 0x06, 0x0d, 0xdd, 0x97, 0xdd,
  0x9f, 0x46, 0x2e, 0x28, 0xdf, 0xc6, 0x2e, 0x29,
  0xdf, 0x06, 0xaf, 0x4e, 0xbf, 0xff, 0x22, 0x11,
  0x54, 0x15, 0x27, 0x1a, 0x27, 0x01, 0xff, 0xab,
  0xef, 0x19, 0x27, 0xdc, 0x97, 0xdf, 0x99, 0x28,
  0x28, 0x0f, 0x27, 0x68, 0x2c, 0xfd, 0x5b, 0xe9,
  0x97, 0xff, 0xaf, 0x6a, 0x28, 0x06, 0x25, 0xf4,
  0x53, 0x4e, 0x25, 0xf2, 0x55, 0xdc, 0x97, 0xdf,
  0x99, 0x28, 0x28, 0x0f, 0x27, 0x68, 0x2c, 0xfd,
  0x5b, 0xe9, 0x97, 0xff, 0xaf, 0x6a, 0x28, 0x06,
  0x25, 0xf4, 0x55, 0x41, 0x2e, 0xaf, 0xdf, 0xdf,
  0x2b, 0x41, 0x2e, 0xaf, 0xbf, 0xbf, 0x22, 0xbf,
  0x99, 0x7f, 0x99, 0x05, 0x27, 0xdd, 0x97, 0xdd,
  0x9f, 0x06, 0xaf, 0x4e, 0xbf, 0xff, 0x22, 0x05,
  0x54, 0xfd, 0x97, 0xff, 0xaf, 0x06, 0x25, 0xfb,
  0x53, 0x4e, 0x25, 0xf9, 0x55, 0xfd, 0x97, 0xff,
  0xaf, 0x06, 0x25, 0xfb, 0x55, 0x05, 0x27, 0xff,
  0x96, 0xc6, 0x2e, 0x01, 0xdf, 0xbf, 0x2c, 0xdd,
  0x9f, 0x05, 0x27, 0xc6, 0x2e, 0x28, 0xdf, 0x0f,
  0x1d, 0x04, 0x55, 0x0b, 0x88, 0xff, 0x96, 0x10,
  0xef, 0xdf, 0x96, 0x06, 0x50, 0x06, 0x88, 0x3f,
  0x20, 0xff, 0x96, 0xc6, 0x2e
};

static const unsigned char pkt224[] = {
  0x42, 0xca, 0x00,
  0xa8, 0x29, 0x28, 0xdf, 0x0f,
  0x1d, 0xff, 0x96, 0x05, 0x27, 0x46, 0x2e, 0x28,
  0xdf, 0xf0, 0x1c, 0x09, 0x27, 0xdf, 0x9f, 0x46,
  0x2e, 0x29, 0xdf, 0x0f, 0x1c, 0x09, 0x27, 0x5f,
  0x02, 0x05, 0x27, 0x78, 0x88, 0x6f, 0x88, 0x0a,
  0xef, 0xdc, 0x9f, 0x3f, 0x9f, 0x5f, 0x20, 0xfb,
  0x55, 0x05, 0x27, 0x9f, 0x22, 0x41, 0x2e, 0xab,
  0xbf, 0x50, 0xef, 0xdf, 0x96, 0x3a, 0xef, 0xdf,
  0x96, 0x29, 0x88, 0x68, 0x88, 0x0a, 0xef, 0xfc,
  0x9f, 0xc1, 0x2e, 0xad, 0xbf, 0xc1, 0x2e, 0xac,
  0xdf, 0x3f, 0x20, 0xc1, 0x2e, 0xac, 0xbf, 0x6a,
  0x88, 0x5f, 0x20, 0xf4, 0x55, 0x5b, 0xef, 0xdf,
  0x96, 0x50, 0xcf, 0xdf, 0x96, 0x17, 0x88, 0x5c,
  0xef, 0xdf, 0x96, 0x4f, 0xcf, 0xdf, 0x96, 0x12,
  0x88, 0x5d, 0xef, 0xdf, 0x96, 0x9f, 0x22, 0xdf,
  0x96, 0x0d, 0x88, 0x5e, 0xef, 0xdf, 0x96, 0x46,
  0x2e, 0x29, 0xdf, 0xdf, 0x96, 0x07, 0x88, 0x5f,
  0xef, 0xdf, 0x96, 0x46, 0x2e, 0x28, 0xdf, 0xdf,
  0x96, 0x01, 0x88, 0x0f, 0x27, 0x05, 0x27, 0xdd,
  0x97, 0x41, 0x2e, 0xad, 0xbf, 0xdd, 0x97, 0x41,
  0x2e, 0xac, 0xbf, 0x44, 0x88, 0x05, 0x27, 0x9f,
  0x22, 0x41, 0x2e, 0xab, 0xbf, 0x10, 0xef, 0xdf,
  0x96, 0x02, 0xef, 0xdf, 0x96, 0xef, 0x8f, 0x2e,
  0x88, 0x0a, 0xef, 0xfc, 0x9f, 0xc1, 0x2e, 0xad,
  0xbf, 0xc1, 0x2e, 0xac, 0xdf, 0x3f, 0x20, 0xc1,
  0x2e, 0xac, 0xbf, 0x30, 0x88
};

static const unsigned char pkt228[] = {
  0x42, 0x9a, 0x00,
  0x0c, 0x2a, 0x5f, 0x20, 0xf4,
  0x55, 0x1b, 0xef, 0xdf, 0x96, 0x50, 0xcf, 0xdf,
  0x96, 0xdd, 0x8f, 0x1c, 0xef, 0xdf, 0x96, 0x4f,
  0xcf, 0xdf, 0x96, 0xd8, 0x8f, 0x1d, 0xef, 0xdf,
  0x96, 0x9f, 0x22, 0xdf, 0x96, 0xd3, 0x8f, 0x1e,
  0xef, 0xdf, 0x96, 0x9f, 0x22, 0xdf, 0x96, 0xce,
  0x8f, 0x1f, 0xef, 0xdf, 0x96, 0x01, 0xef, 0xdf,
  0x96, 0xc9, 0x8f, 0x0f, 0x27, 0x05, 0x27, 0x02,
  0xef, 0x06, 0xff, 0x1a, 0x27, 0x05, 0x27, 0x02,
  0xef, 0x06, 0xff, 0x1a, 0x27, 0x05, 0x27, 0xdf,
  0x96, 0xff, 0x96, 0x7b, 0xef, 0x00, 0xff, 0x1b,
  0x27, 0xdd, 0x9f, 0xdd, 0x97, 0x05, 0x27, 0x01,
  0xff, 0xab, 0xef, 0x1b, 0x27, 0x05, 0x27, 0xdf,
  0x96, 0x81, 0xef, 0x41, 0x2e, 0xaf, 0xbf, 0xdd,
  0x97, 0x05, 0x27, 0x3a, 0xef, 0xff, 0xaf, 0xea,
  0x8f, 0x0a, 0xef, 0xfc, 0x9f, 0xff, 0xbf, 0x5f,
  0x20, 0xfb, 0x55, 0x50, 0xcf, 0xff, 0xaf, 0x4f,
  0xcf, 0xff, 0xaf, 0x9f, 0x22, 0xff, 0xaf, 0x46,
  0x2e, 0x29, 0xdf, 0xff, 0xaf, 0x46, 0x2e, 0x28,
  0xdf, 0xff, 0xaf, 0x05, 0x27
};

static const unsigned char pkt232[] = {
  0x42, 0x18, 0x00,
  0x58, 0x2a, 0xd3, 0x45, 0x03,
  0x5a, 0x0f, 0x27, 0xd3, 0x45, 0x00, 0x5a, 0x05,
  0x27, 0xd0, 0x41, 0xf7, 0x5b, 0xc1, 0x83, 0xf5,
  0x50, 0x05, 0x27
};

static const unsigned char pkt236[] = {
  0x42, 0x22, 0x00,
  0x63, 0x2a, 0xc8, 0x46, 0x0c,
  0x5b, 0xd3, 0x45, 0xfd, 0x5a, 0xd3, 0x45, 0xfb,
  0x5a, 0xd3, 0x45, 0xf9, 0x5a, 0x41, 0x2e, 0xa1,
  0xdf, 0x9f, 0x28, 0x41, 0x2e, 0xa1, 0xbf, 0x02,
  0x2e, 0xdd, 0x81, 0x05, 0x27
};

static const unsigned char pkt240[] = {
  0x42, 0x50, 0x00,
  0x73, 0x2a, 0x07, 0x3d, 0x02,
  0x5b, 0x6c, 0x86, 0xc2, 0x23, 0xd3, 0x3c, 0x02,
  0x44, 0xd8, 0x2f, 0x1d, 0x5a, 0x02, 0x45, 0xd8,
  0x2f, 0x7e, 0x5b, 0x58, 0x23, 0x3c, 0x26, 0x02,
  0x55, 0x02, 0x2e, 0x31, 0x84, 0x01, 0x50, 0x02,
  0x2e, 0x80, 0x84, 0x07, 0x45, 0xea, 0x5a, 0x41,
  0x2e, 0x53, 0xdf, 0xc1, 0x2e, 0x79, 0xdf, 0xff,
  0x96, 0xdf, 0x96, 0x41, 0x2e, 0x55, 0xdf, 0xc1,
  0x2e, 0x78, 0xdf, 0x9d, 0x01, 0x5d, 0x01, 0xff,
  0x22, 0x00, 0x54, 0xff, 0xef, 0x2e, 0xaf, 0xd8,
  0x2f, 0x62, 0x50
};

static const unsigned char pkt244[] = {
  0x67, 0x05, 0x00, 0x00, 0x02, 0x2e, 0x00, 0x70,
  0x67, 0x05, 0x00, 0x01, 0x02, 0x2e, 0xe5, 0x71,
  0x67, 0x05, 0x00, 0x02, 0x02, 0x2e, 0xa9, 0x72,
  0x67, 0x05, 0x00, 0x08, 0x02, 0x2e, 0xb4, 0x73,
  0x67, 0x05, 0x00, 0x07, 0x02, 0x2e, 0x29, 0x74,
  0x67, 0x05, 0x00, 0x0d, 0x02, 0x2e, 0x26, 0x75,
  0x67, 0x05, 0x00, 0x03, 0x02, 0x2e, 0x4d, 0x75,
  0x67, 0x05, 0x00, 0x0e, 0x02, 0x2e, 0x29, 0x77,
  0x5a, 0x05, 0x00, 0x00, 0xaa, 0x08, 0x67, 0x27,
  0x5a, 0x05, 0x00, 0x01, 0xf4, 0x08, 0xfd, 0x27,
  0x67, 0x05, 0x00, 0x09, 0x02, 0x2e, 0xe0, 0x78,
  0x5a, 0x05, 0x00, 0x02, 0x82, 0x09, 0x58, 0x2a,
  0x5a, 0x05, 0x00, 0x03, 0x78, 0x09, 0x63, 0x2a,
  0x5a, 0x05, 0x00, 0x04, 0xe1, 0x02, 0x73, 0x2a,
  0x0d,
  0x42, 0x04, 0x00, 0x73, 0x2a, 0x07, 0x3d
};

struct aesX660_cmd aes1660_init_1[] = {
  { .cmd = pkt107, .len = sizeof (pkt107) },
  { .cmd = pkt112, .len = sizeof (pkt112) },
  { .cmd = pkt116, .len = sizeof (pkt116) },
  { .cmd = pkt120, .len = sizeof (pkt120) },
  { .cmd = pkt124, .len = sizeof (pkt124) },
  { .cmd = pkt128, .len = sizeof (pkt128) },
  { .cmd = pkt133, .len = sizeof (pkt133) },
  { .cmd = pkt136, .len = sizeof (pkt136) },
  { .cmd = pkt140, .len = sizeof (pkt140) },
  { .cmd = pkt144, .len = sizeof (pkt144) },
  { .cmd = pkt148, .len = sizeof (pkt148) },
  { .cmd = pkt152, .len = sizeof (pkt152) },
  { .cmd = pkt156, .len = sizeof (pkt156) },
  { .cmd = pkt160, .len = sizeof (pkt160) },
  { .cmd = pkt164, .len = sizeof (pkt164) },
  { .cmd = pkt168, .len = sizeof (pkt168) },
  { .cmd = pkt172, .len = sizeof (pkt172) },
  { .cmd = pkt176, .len = sizeof (pkt176) },
  { .cmd = pkt180, .len = sizeof (pkt180) },
  { .cmd = pkt184, .len = sizeof (pkt184) },
  { .cmd = pkt188, .len = sizeof (pkt188) },
  { .cmd = pkt192, .len = sizeof (pkt192) },
  { .cmd = pkt196, .len = sizeof (pkt196) },
  { .cmd = pkt200, .len = sizeof (pkt200) },
  { .cmd = pkt204, .len = sizeof (pkt204) },
  { .cmd = pkt208, .len = sizeof (pkt208) },
  { .cmd = pkt212, .len = sizeof (pkt212) },
  { .cmd = pkt216, .len = sizeof (pkt216) },
  { .cmd = pkt220, .len = sizeof (pkt220) },
  { .cmd = pkt224, .len = sizeof (pkt224) },
  { .cmd = pkt228, .len = sizeof (pkt228) },
  { .cmd = pkt232, .len = sizeof (pkt232) },
  { .cmd = pkt236, .len = sizeof (pkt236) },
  { .cmd = pkt240, .len = sizeof (pkt240) },
  { .cmd = pkt244, .len = sizeof (pkt244) },
};

/* INIT1 is over, 0x07 cmd returns
 * { 0x07, 0x05, 0x00, 0x8f, 0x16, 0x25, 0x01, 0x23 }
 */

/* Second init sequence
 * INIT2 */
static const unsigned char pkt433[] = {
  0x0d,
  0x23,
  0x42, 0xca, 0x00,
  0x00, 0x20, 0x23,
  0xff, 0x3f, 0x1d, 0x40, 0x19, 0xc1, 0x2e, 0xa3,
  0xbf, 0xc2, 0x2e, 0x00, 0xdf, 0xff, 0x2d, 0x02,
  0x5a, 0xbf, 0x22, 0xc1, 0x2e, 0xa3, 0xbf, 0x02,
  0xcf, 0x0f, 0x1c, 0x10, 0x18, 0x26, 0x83, 0xc8,
  0x46, 0x00, 0x5b, 0x01, 0x0c, 0x57, 0x23, 0x3c,
  0x23, 0xf9, 0x34, 0x6b, 0x81, 0x64, 0xef, 0x64,
  0xaf, 0xdf, 0xef, 0x27, 0xff, 0xd6, 0xaf, 0xd7,
  0xbf, 0x46, 0xef, 0x46, 0xaf, 0x2a, 0xef, 0x2a,
  0xaf, 0x05, 0x81, 0x05, 0x27, 0x9c, 0xcf, 0xdf,
  0x96, 0xfe, 0xef, 0x27, 0xff, 0x19, 0x27, 0x65,
  0xdf, 0xe1, 0x22, 0x1c, 0x55, 0xe0, 0x97, 0xbf,
  0x03, 0x19, 0x5e, 0xfe, 0x0c, 0x9f, 0x22, 0x0f,
  0xff, 0xe1, 0x22, 0x10, 0x55, 0x20, 0x00, 0x0e,
  0x52, 0x82, 0x03, 0x03, 0x53, 0xfe, 0x0d, 0x7f,
  0x20, 0xf6, 0x55, 0x08, 0x50, 0x5f, 0x90, 0x82,
  0x01, 0x1f, 0x90, 0xc1, 0x97, 0xa0, 0x01, 0x82,
  0x01, 0xdf, 0x21, 0x80, 0x03, 0x00, 0x5e, 0x3f,
  0x20, 0x29, 0xbf, 0x03, 0x0c, 0x05, 0x27, 0x01,
  0x0c, 0x10, 0xff, 0x29, 0xbf, 0x05, 0x27, 0x9a,
  0xcf, 0xdf, 0x96, 0xe0, 0xef, 0x27, 0xff, 0x19,
  0x27, 0xfe, 0x0c, 0x9f, 0x22, 0x00, 0xff, 0xe1,
  0x22, 0x10, 0x55, 0x20, 0x00, 0x0e, 0x52, 0x82,
  0x03, 0x03, 0x53, 0x02, 0x0d, 0x3f, 0x20, 0x0f,
  0x1f, 0xf5, 0x55, 0x5f, 0x90, 0x82, 0x01, 0x1f,
  0x90, 0xc1, 0x97, 0xa0, 0x01, 0x82, 0x01
};

static const unsigned char pkt440[] = {
  0x42, 0xca, 0x00,
  0x64, 0x20, 0xdf, 0x21, 0x80,
  0x03, 0x02, 0x5e, 0x7f, 0x20, 0x00, 0x53, 0xbf,
  0x22, 0x29, 0xcf, 0xbf, 0x03, 0x01, 0x5e, 0x5f,
  0x20, 0xdf, 0x9f, 0x28, 0xbf, 0x03, 0x0c, 0x05,
  0x27, 0x24, 0xcf, 0x10, 0xdf, 0xbf, 0x01, 0x06,
  0x1e, 0xe2, 0x2f, 0x13, 0x5c, 0xdf, 0x2d, 0x00,
  0x5b, 0x9f, 0x22, 0xdf, 0x96, 0x9b, 0xef, 0x20,
  0xff, 0x1d, 0x00, 0x00, 0x13, 0x1a, 0x27, 0x07,
  0x27, 0x9b, 0x22, 0xdf, 0x96, 0xbb, 0xcf, 0x1a,
  0x88, 0xbb, 0xcf, 0x1b, 0x88, 0x01, 0x0f, 0xbc,
  0xcf, 0x15, 0x88, 0xbc, 0xcf, 0x16, 0x88, 0x01,
  0x0f, 0xbd, 0xcf, 0x10, 0x88, 0xbd, 0xcf, 0x11,
  0x88, 0x01, 0x0f, 0xbe, 0xcf, 0x0b, 0x88, 0xbe,
  0xcf, 0x0c, 0x88, 0x01, 0x0c, 0xdd, 0x97, 0x25,
  0xaf, 0x05, 0x27, 0xff, 0x00, 0xab, 0x00, 0x72,
  0x00, 0x4c, 0x00, 0x33, 0x00, 0x22, 0x00, 0x09,
  0x88, 0xbf, 0x9d, 0x05, 0x27, 0x09, 0x27, 0x05,
  0x88, 0xff, 0x97, 0x09, 0x27, 0xf6, 0x9f, 0x5f,
  0x02, 0xbf, 0x9d, 0x05, 0x27, 0x0f, 0x1c, 0xc0,
  0x9f, 0x8a, 0x80, 0x80, 0x10, 0x00, 0x13, 0x0f,
  0x1d, 0xc1, 0x03, 0x00, 0x5f, 0x7f, 0x90, 0x05,
  0x27, 0x53, 0x80, 0x2b, 0x0d, 0x05, 0x27, 0x9f,
  0x22, 0x8f, 0xaf, 0x67, 0x2e, 0xe0, 0xdf, 0x04,
  0x1e, 0x00, 0x52, 0x8f, 0x30, 0x67, 0x2e, 0xe1,
  0xdf, 0xdf, 0x22, 0x00, 0x54, 0x8f, 0x30, 0x67,
  0x2e, 0xfe, 0xdf, 0x04, 0x1e
};

static const unsigned char pkt444[] = {
  0x42, 0xca, 0x00,
  0xc8, 0x20, 0x00, 0x52, 0x8f,
  0x31, 0x67, 0x2e, 0xff, 0xdf, 0xdf, 0x22, 0x00,
  0x54, 0x8f, 0x31, 0x8f, 0xcf, 0x03, 0x1c, 0x03,
  0x1e, 0x00, 0x55, 0x0c, 0x27, 0x0d, 0x27, 0x4a,
  0xcf, 0xdf, 0x96, 0x10, 0xcf, 0x5f, 0xdf, 0xbf,
  0x03, 0x02, 0x5f, 0x5f, 0xcf, 0x10, 0xaf, 0x04,
  0x50, 0x5e, 0xdf, 0xbf, 0x03, 0x01, 0x53, 0x5e,
  0xcf, 0x10, 0xaf, 0x46, 0x88, 0x01, 0x2e, 0x1e,
  0x80, 0xdd, 0x97, 0x0a, 0x40, 0x1c, 0x5a, 0x37,
  0x43, 0x0b, 0x5b, 0xe2, 0xcf, 0x0f, 0x1c, 0x06,
  0x1e, 0x07, 0x52, 0x62, 0xdf, 0x18, 0x1f, 0x07,
  0x53, 0x04, 0x16, 0xe2, 0xaf, 0x04, 0x11, 0x62,
  0xbf, 0x02, 0x50, 0x62, 0xcf, 0xdf, 0x22, 0x0e,
  0x54, 0x0e, 0x88, 0x62, 0xdf, 0xbf, 0x03, 0x04,
  0x53, 0x62, 0xaf, 0xdf, 0x01, 0xe2, 0xcf, 0x3f,
  0x00, 0xe2, 0xaf, 0x0e, 0x88, 0x4a, 0xdf, 0x3f,
  0x00, 0x4a, 0xaf, 0x00, 0x2e, 0xc4, 0x8d, 0x05,
  0x27, 0xff, 0xef, 0x4a, 0xdf, 0xbf, 0x01, 0x0a,
  0x88, 0xa1, 0x27, 0x5f, 0x21, 0x7f, 0x20, 0xfb,
  0x55, 0x05, 0x27, 0x62, 0xcf, 0x03, 0x88, 0x1f,
  0x22, 0x7f, 0x20, 0xfc, 0x55, 0x05, 0x27, 0x10,
  0xdf, 0x02, 0x1f, 0x02, 0x5e, 0x04, 0xff, 0x00,
  0x2e, 0x0a, 0x50, 0x05, 0x1f, 0x02, 0x5e, 0x03,
  0xff, 0x00, 0x2e, 0x05, 0x50, 0x06, 0x1f, 0x02,
  0x5e, 0x02, 0xff, 0x00, 0x2e, 0x00, 0x50, 0x01,
  0xff, 0x05, 0x27, 0x10, 0xcf
};

static const unsigned char pkt448[] = {
  0x42, 0xca, 0x00,
  0x2c, 0x21, 0x33, 0xff, 0x3f,
  0x00, 0x21, 0xff, 0x00, 0x13, 0x1a, 0x27, 0x07,
  0x27, 0x05, 0x27, 0x01, 0x00, 0x02, 0x57, 0x42,
  0x87, 0x52, 0x80, 0x92, 0x81, 0xd2, 0x6c, 0xe2,
  0x80, 0xf2, 0x80, 0xf6, 0x7b, 0xfa, 0x7e, 0xfe,
  0x8b, 0xf9, 0x45, 0x04, 0x5a, 0x40, 0xef, 0xf9,
  0x44, 0x03, 0x5b, 0x80, 0xef, 0x01, 0x50, 0x41,
  0x2e, 0x7e, 0xdf, 0x4d, 0xaf, 0x05, 0x27, 0x28,
  0xff, 0x54, 0xef, 0x19, 0x27, 0x4d, 0x26, 0xe1,
  0x2f, 0x28, 0x54, 0x27, 0xff, 0xe0, 0xef, 0x1b,
  0x27, 0x10, 0xef, 0x06, 0xaf, 0xfc, 0x97, 0xfc,
  0x9f, 0x1c, 0x82, 0x1c, 0x82, 0x1a, 0x27, 0x4d,
  0xdf, 0x6d, 0x80, 0x5f, 0x9f, 0x06, 0x25, 0xf5,
  0x55, 0x05, 0x27, 0x26, 0x1f, 0x00, 0x5f, 0xbf,
  0x22, 0xff, 0x96, 0x6c, 0xef, 0x21, 0xff, 0x1d,
  0x00, 0x00, 0x13, 0x1a, 0x27, 0x07, 0x27, 0x1a,
  0x27, 0xd6, 0x97, 0x05, 0x27, 0xa3, 0x01, 0xa4,
  0x01, 0xa3, 0x01, 0x2e, 0x00, 0xb0, 0x00, 0xb1,
  0x00, 0xb2, 0x00, 0xb3, 0x00, 0xb4, 0x00, 0xb5,
  0x00, 0xb6, 0x00, 0xb7, 0x00, 0xb8, 0x00, 0xb9,
  0x00, 0xba, 0x00, 0x56, 0x00, 0xae, 0x00, 0x54,
  0x01, 0x44, 0x01, 0x55, 0x01, 0x44, 0x01, 0xbb,
  0x00, 0xbc, 0x00, 0xbd, 0x00, 0xbe, 0x00, 0x83,
  0x00, 0x84, 0x00, 0x81, 0x00, 0x82, 0x00, 0x24,
  0x00, 0x44, 0x01, 0xdb, 0x00, 0xdc, 0x00, 0xdd,
  0x00, 0xde, 0x00, 0x04, 0x00
};

static const unsigned char pkt452[] = {
  0x42, 0x52, 0x00,
  0x90, 0x21, 0x9b, 0x00, 0x99,
  0x00, 0x9e, 0x00, 0x10, 0xef, 0xe6, 0x81, 0x65,
  0xaf, 0x10, 0xef, 0xe6, 0x81, 0x9c, 0xaf, 0x10,
  0xef, 0xe6, 0x81, 0x9a, 0xaf, 0x05, 0x27, 0xe5,
  0x31, 0x1d, 0x81, 0xe5, 0x39, 0x05, 0x27, 0xc8,
  0x46, 0x0b, 0x5b, 0xd3, 0x45, 0xfd, 0x5a, 0xd3,
  0x45, 0xfb, 0x5a, 0xd3, 0x45, 0xf9, 0x5a, 0x41,
  0x2e, 0xa1, 0xdf, 0x9f, 0x28, 0x41, 0x2e, 0xa1,
  0xbf, 0x00, 0x88, 0x05, 0x27, 0x9f, 0x22, 0xbf,
  0x22, 0x1f, 0x20, 0xfd, 0x53, 0x3f, 0x20, 0x14,
  0x1f, 0xfa, 0x55, 0x05, 0x27
};

static const unsigned char pkt456[] = {
  0x42, 0xca, 0x00,
  0xb8, 0x21, 0x25, 0x85, 0x01,
  0x1e, 0x17, 0x55, 0x1b, 0x8a, 0x41, 0x2e, 0x53,
  0xdf, 0xc1, 0x2e, 0x79, 0xdf, 0xff, 0x96, 0xdf,
  0x96, 0x41, 0x2e, 0x55, 0xdf, 0xc1, 0x2e, 0x78,
  0xdf, 0x9d, 0x01, 0x5d, 0x01, 0xff, 0x22, 0x00,
  0x54, 0xff, 0xef, 0x2e, 0xaf, 0x05, 0x27, 0x07,
  0x80, 0x9f, 0x22, 0xff, 0xaf, 0x00, 0x2e, 0x5d,
  0x89, 0x05, 0x27, 0x06, 0x1e, 0x01, 0x55, 0x0f,
  0x27, 0x01, 0x70, 0x0a, 0x1e, 0x0a, 0x55, 0x00,
  0x88, 0x66, 0x76, 0x02, 0x46, 0x00, 0x5b, 0x08,
  0x3b, 0x3b, 0x30, 0x07, 0x35, 0xff, 0xff, 0xc2,
  0xbf, 0x0d, 0x27, 0x0c, 0x27, 0x0d, 0x1e, 0x02,
  0x55, 0x28, 0x85, 0xf2, 0x5b, 0x7b, 0x76, 0x12,
  0x1e, 0x07, 0x55, 0xdc, 0xef, 0x05, 0xff, 0x1a,
  0x27, 0x56, 0xdf, 0x3f, 0x20, 0x6d, 0x80, 0x3c,
  0xaf, 0x05, 0x27, 0x13, 0x1e, 0x01, 0x55, 0x3c,
  0x23, 0x05, 0x27, 0x1f, 0x1e, 0x06, 0x55, 0x37,
  0x35, 0x08, 0xef, 0x40, 0x2e, 0xf0, 0xbf, 0x40,
  0x2e, 0xf6, 0xbf, 0x05, 0x27, 0x20, 0x1e, 0x06,
  0x55, 0x37, 0x3d, 0x16, 0xef, 0x40, 0x2e, 0xf0,
  0xbf, 0x40, 0x2e, 0xf6, 0xbf, 0x05, 0x27, 0x22,
  0x1e, 0x19, 0x55, 0x21, 0xef, 0x08, 0xaf, 0x09,
  0x23, 0x01, 0xef, 0x0b, 0xaf, 0x31, 0xef, 0x0a,
  0xaf, 0x81, 0xcf, 0x10, 0xaf, 0xbf, 0x8e, 0x82,
  0xcf, 0x4a, 0xaf, 0x00, 0x2e, 0xc4, 0x8d, 0x08,
  0xef, 0x9b, 0xaf, 0x99, 0xaf
};

static const unsigned char pkt460[] = {
  0x42, 0x34, 0x00,
  0x1c, 0x22, 0x02, 0xcf, 0x0f,
  0x1c, 0x40, 0x18, 0x37, 0x31, 0x02, 0xaf, 0xe2,
  0x23, 0x08, 0xef, 0xe3, 0xaf, 0x05, 0x27, 0x23,
  0x1e, 0x0c, 0x55, 0x00, 0xef, 0x02, 0xff, 0x19,
  0x27, 0xbf, 0x22, 0x20, 0xef, 0x7f, 0x9f, 0x5f,
  0x20, 0xfc, 0x55, 0xf0, 0x81, 0x9f, 0x22, 0x41,
  0x2e, 0xa3, 0xbf, 0x05, 0x27, 0xcb, 0x74
};

static const unsigned char pkt464[] = {
  0x42, 0xca, 0x00,
  0x35, 0x22, 0x25, 0x85, 0x44,
  0x1e, 0x01, 0x55, 0xe2, 0x2f, 0xf1, 0x50, 0x49,
  0x1e, 0x0d, 0x55, 0x37, 0x39, 0x01, 0xef, 0x72,
  0x88, 0x00, 0x2e, 0x45, 0x8d, 0x6b, 0x81, 0x08,
  0x42, 0x03, 0x5b, 0x3d, 0x23, 0x9f, 0x22, 0x00,
  0x2e, 0xb2, 0x8b, 0xd3, 0x3b, 0x05, 0x27, 0x4a,
  0x1e, 0x01, 0x55, 0xe2, 0x2f, 0xdd, 0x50, 0x4e,
  0x1e, 0x01, 0x55, 0x00, 0x2e, 0xbb, 0x79, 0x55,
  0x1e, 0x16, 0x55, 0x28, 0x85, 0xe2, 0x2f, 0xd4,
  0x5b, 0x07, 0xef, 0x20, 0x80, 0xe2, 0x2f, 0xd0,
  0x5a, 0xfe, 0xcf, 0x0a, 0xaf, 0xfe, 0xcf, 0xfe,
  0xcf, 0x41, 0x2e, 0x44, 0xbf, 0xfe, 0xcf, 0x41,
  0x2e, 0x45, 0xbf, 0xfe, 0xcf, 0x52, 0xaf, 0xfe,
  0xcf, 0x53, 0xaf, 0xfe, 0xcf, 0x5a, 0xaf, 0x05,
  0x27, 0x58, 0x1e, 0x0d, 0x55, 0x02, 0x44, 0x01,
  0x5a, 0x00, 0x2e, 0x07, 0x78, 0xfe, 0xcf, 0x75,
  0xaf, 0xfe, 0xdf, 0x76, 0xbf, 0x41, 0x2e, 0xa4,
  0xdf, 0xdf, 0x29, 0x41, 0x2e, 0xa4, 0xbf, 0x05,
  0x27, 0x59, 0x1e, 0x02, 0x55, 0xfe, 0xcf, 0x10,
  0xaf, 0x54, 0x7e, 0x63, 0x1e, 0x1a, 0x55, 0x28,
  0x85, 0xe2, 0x2f, 0xa6, 0x5b, 0x0c, 0xef, 0x20,
  0x80, 0xe2, 0x2f, 0xa2, 0x5a, 0xf0, 0xef, 0x00,
  0xff, 0x19, 0x27, 0x08, 0xef, 0x06, 0xaf, 0xfe,
  0xcf, 0x5f, 0x9f, 0x06, 0x25, 0xfb, 0x55, 0xfe,
  0xcf, 0xfe, 0xcf, 0x41, 0x2e, 0x40, 0xbf, 0xfe,
  0xcf, 0x41, 0x2e, 0x41, 0xbf
};

static const unsigned char pkt468[] = {
  0x42, 0x46, 0x00,
  0x99, 0x22, 0xfe, 0xcf, 0x41,
  0x2e, 0x42, 0xbf, 0x05, 0x27, 0x66, 0x1e, 0x0b,
  0x55, 0x33, 0xef, 0x21, 0xff, 0x1a, 0x27, 0x0b,
  0xef, 0x06, 0xaf, 0xfe, 0xcf, 0xfe, 0xdf, 0x06,
  0x27, 0x01, 0x0e, 0x06, 0x25, 0xf9, 0x55, 0x05,
  0x27, 0x35, 0x74, 0xff, 0x96, 0xc6, 0x2e, 0x01,
  0xdf, 0x3f, 0x2c, 0xdd, 0x9f, 0x05, 0x27, 0xf9,
  0x35, 0xc1, 0x2e, 0x4e, 0xdf, 0x0f, 0x1d, 0x09,
  0x27, 0x5f, 0x02, 0xc1, 0x2e, 0x4e, 0xbf, 0x05,
  0x27
};

static const unsigned char pkt472[] = {
  0x42, 0xca, 0x00,
  0xbb, 0x22, 0x09, 0x46, 0x0b,
  0x5b, 0x08, 0x31, 0xf2, 0xcf, 0x0b, 0xaf, 0x15,
  0xef, 0xf4, 0xaf, 0x30, 0xef, 0x0a, 0xaf, 0x44,
  0xef, 0xfa, 0xaf, 0x10, 0xef, 0xf8, 0xaf, 0x5c,
  0x88, 0x37, 0xcf, 0xdf, 0x96, 0x08, 0xcf, 0xdf,
  0x96, 0x3d, 0xcf, 0xdf, 0x96, 0x00, 0x2e, 0xd4,
  0x8d, 0xdd, 0x97, 0x3d, 0xaf, 0xdd, 0x97, 0x08,
  0xaf, 0xdd, 0x97, 0x37, 0xaf, 0xa0, 0xcf, 0xbf,
  0x1c, 0xa0, 0xaf, 0x05, 0x81, 0xfb, 0x39, 0x08,
  0x45, 0x00, 0x5a, 0xfb, 0x31, 0x0a, 0x42, 0x00,
  0x5b, 0xa2, 0x39, 0x02, 0xcf, 0x5c, 0xaf, 0xe1,
  0xef, 0x40, 0x2e, 0x95, 0xbf, 0x9f, 0x22, 0x25,
  0xaf, 0x69, 0xaf, 0x6a, 0xaf, 0x16, 0xaf, 0x40,
  0x2e, 0x96, 0xbf, 0x29, 0xaf, 0x02, 0x47, 0x06,
  0x5a, 0x0a, 0x41, 0x04, 0x5a, 0x0a, 0xdf, 0x30,
  0x1d, 0x30, 0x1f, 0x00, 0x54, 0x01, 0xef, 0x44,
  0xaf, 0x09, 0xef, 0x60, 0xaf, 0x08, 0x45, 0x0a,
  0x40, 0x06, 0x5a, 0x10, 0xcf, 0x27, 0xaf, 0xe2,
  0x23, 0x6e, 0x23, 0x08, 0xef, 0xe3, 0xaf, 0x6f,
  0xaf, 0xce, 0x8d, 0x5d, 0xcf, 0x30, 0x1c, 0x00,
  0x1e, 0x07, 0x55, 0xf8, 0xcf, 0x5f, 0x2b, 0x9f,
  0x29, 0xf8, 0xaf, 0xa1, 0xcf, 0xc1, 0x1c, 0xa1,
  0xaf, 0x09, 0x50, 0x10, 0x1e, 0x07, 0x55, 0xf8,
  0xcf, 0x5f, 0x29, 0x9f, 0x2b, 0xf8, 0xaf, 0xa1,
  0xcf, 0xc1, 0x1c, 0x08, 0x18, 0xa1, 0xaf, 0x41,
  0x2e, 0xa4, 0xdf, 0xdf, 0x2d
};

static const unsigned char pkt476[] = {
  0x42, 0x3a, 0x00,
  0x1f, 0x23, 0x04, 0x5b, 0x75,
  0xcf, 0xf4, 0xaf, 0x76, 0xcf, 0xf5, 0xaf, 0x00,
  0x50, 0x0f, 0x88, 0xe2, 0x23, 0x08, 0xef, 0xe3,
  0xaf, 0x81, 0x82, 0x4d, 0xaf, 0xdf, 0x96, 0x64,
  0xdf, 0x93, 0x82, 0x93, 0xbf, 0xdd, 0x97, 0x77,
  0xff, 0x93, 0x82, 0x94, 0xbf, 0x9e, 0x23, 0xe4,
  0x23, 0x05, 0x27, 0x14, 0xef, 0xf4, 0xaf, 0x00,
  0xef, 0xf5, 0xaf, 0x05, 0x27
};

static const unsigned char pkt480[] = {
  0x42, 0xca, 0x00,
  0x3b, 0x23, 0xfe, 0xcf, 0x58,
  0xaf, 0xfe, 0xcf, 0xfe, 0xdf, 0x00, 0x2e, 0xa9,
  0x8b, 0xfe, 0xcf, 0x3c, 0xaf, 0x07, 0x3d, 0x58,
  0x40, 0x4a, 0x5a, 0x3c, 0x26, 0x48, 0x55, 0x37,
  0x45, 0x46, 0x5a, 0xe0, 0x88, 0x44, 0x5a, 0x77,
  0x88, 0x00, 0x2e, 0xd1, 0x8b, 0xfe, 0xef, 0x16,
  0x80, 0x02, 0xcf, 0xdf, 0x96, 0x61, 0xef, 0xc0,
  0xaf, 0x04, 0x27, 0xc1, 0x46, 0x04, 0x5b, 0xc0,
  0x3e, 0x40, 0xef, 0xc1, 0xaf, 0x01, 0x2e, 0x94,
  0x84, 0xd0, 0x41, 0x06, 0x5b, 0x2d, 0x88, 0xf3,
  0x5b, 0x6c, 0x86, 0xdd, 0x97, 0x1f, 0x2d, 0x05,
  0x5b, 0x03, 0x50, 0x01, 0x0c, 0x02, 0xcf, 0xc0,
  0x1c, 0x00, 0x55, 0x05, 0x88, 0xc0, 0x23, 0x20,
  0xef, 0xc1, 0xaf, 0x00, 0x2e, 0xf0, 0x8b, 0x05,
  0x27, 0x9b, 0x22, 0x37, 0x45, 0x05, 0x5a, 0x41,
  0x2e, 0x52, 0xdf, 0xdf, 0x2d, 0x04, 0x5b, 0x00,
  0x28, 0x02, 0x50, 0x3b, 0x43, 0x00, 0x5b, 0x00,
  0x28, 0xd3, 0xdf, 0xc6, 0x2e, 0x15, 0xbf, 0xd3,
  0x3c, 0x40, 0xef, 0x09, 0x80, 0xdd, 0x97, 0xff,
  0xaf, 0x00, 0x2e, 0x5d, 0x89, 0xc6, 0x2e, 0x15,
  0xdf, 0x10, 0x1d, 0xd3, 0xcf, 0x3f, 0x02, 0xd3,
  0xaf, 0x05, 0x27, 0xc1, 0x83, 0x07, 0x45, 0x05,
  0x27, 0x3d, 0x23, 0x07, 0x3d, 0x02, 0xcf, 0xdf,
  0x96, 0x2e, 0x88, 0x26, 0x88, 0xfe, 0xef, 0x16,
  0x80, 0x05, 0xef, 0xc0, 0xaf, 0x04, 0x27, 0xd0,
  0x41, 0x02, 0x5b, 0xee, 0x8f
};

static const unsigned char pkt484[] = {
  0x42, 0xca, 0x00,
  0x9f, 0x23, 0xfa, 0x5b, 0xbf,
  0x50, 0x31, 0x82, 0x04, 0xef, 0xc1, 0xaf, 0x9b,
  0x22, 0x41, 0x88, 0xdd, 0x97, 0xdf, 0x22, 0x02,
  0x55, 0x58, 0x40, 0x02, 0x5a, 0x09, 0x50, 0x58,
  0x40, 0x07, 0x5a, 0xdd, 0x97, 0x1f, 0x2d, 0xb8,
  0x5a, 0x7a, 0x88, 0xb7, 0x5b, 0x9b, 0x22, 0xc7,
  0x8f, 0xb4, 0x50, 0x75, 0x88, 0xdc, 0x5b, 0xb7,
  0x8f, 0x58, 0x41, 0x01, 0x5b, 0x01, 0x0c, 0xad,
  0x7f, 0xd6, 0x50, 0x41, 0x2e, 0x52, 0xdf, 0xed,
  0x1c, 0x04, 0x18, 0x41, 0x2e, 0x52, 0xbf, 0x05,
  0x27, 0x00, 0x2e, 0xb9, 0x8b, 0xae, 0xdf, 0xe0,
  0x19, 0xae, 0xbf, 0x57, 0x40, 0x00, 0x5b, 0xa1,
  0x32, 0x57, 0x43, 0x00, 0x5b, 0xae, 0x3f, 0x05,
  0x81, 0x05, 0x27, 0x41, 0x2e, 0x52, 0xdf, 0x03,
  0x18, 0x41, 0x2e, 0x52, 0xbf, 0x05, 0x27, 0xd3,
  0xdf, 0xff, 0x96, 0x9b, 0x22, 0x0b, 0x88, 0xd3,
  0x3c, 0x07, 0x80, 0xdd, 0x97, 0xff, 0xaf, 0x00,
  0x2e, 0x5d, 0x89, 0xdd, 0x9f, 0x10, 0x1d, 0xd3,
  0xcf, 0x3f, 0x02, 0xd3, 0xaf, 0x05, 0x27, 0x37,
  0x45, 0x0e, 0x5a, 0x40, 0x88, 0x0c, 0x5a, 0xd7,
  0x8f, 0x00, 0x2e, 0xd7, 0x8b, 0x00, 0x2e, 0xeb,
  0x8b, 0x41, 0x2e, 0x52, 0xdf, 0xdf, 0x2d, 0x00,
  0x5b, 0x00, 0x28, 0x00, 0x2e, 0xf0, 0x8b, 0x05,
  0x27, 0xf9, 0xcf, 0xdf, 0x96, 0xf9, 0x3d, 0x00,
  0x2e, 0xd1, 0x8d, 0x28, 0xff, 0xa7, 0xef, 0xe1,
  0xbf, 0xe0, 0xaf, 0x09, 0xef
};

static const unsigned char pkt488[] = {
  0x42, 0x6c, 0x00,
  0x03, 0x24, 0x10, 0xaf, 0xcf,
  0x8c, 0x05, 0x81, 0x01, 0x2e, 0x54, 0x80, 0x01,
  0x2e, 0x56, 0x80, 0x20, 0x82, 0x3c, 0x8d, 0x37,
  0x82, 0x26, 0x37, 0x00, 0x5a, 0x0c, 0x50, 0xff,
  0x96, 0xdf, 0x96, 0x79, 0xcf, 0x7a, 0xdf, 0xff,
  0x96, 0xdf, 0x96, 0xc2, 0x97, 0xc3, 0x9f, 0x9d,
  0x01, 0x5d, 0x01, 0x07, 0x53, 0xdd, 0x97, 0xdd,
  0x9f, 0x79, 0xaf, 0x7a, 0xbf, 0x3b, 0x3b, 0xdd,
  0x97, 0xf9, 0xaf, 0x05, 0x27, 0xff, 0x22, 0x01,
  0x55, 0x32, 0x1e, 0xf3, 0x5f, 0x02, 0x0c, 0xf6,
  0x8f, 0x3b, 0x33, 0x00, 0x28, 0x05, 0x27, 0x0d,
  0x27, 0x3c, 0x26, 0x07, 0x54, 0x3c, 0xcf, 0x3d,
  0xdf, 0x3f, 0x20, 0x3d, 0xbf, 0xdf, 0x03, 0x01,
  0x52, 0x3d, 0x23, 0x0c, 0x27, 0x0d, 0x27
};

static const unsigned char pkt492[] = {
  0x42, 0x9c, 0x00,
  0x38, 0x24, 0x08, 0x44, 0x12,
  0x5a, 0x07, 0x40, 0x01, 0x5b, 0x4f, 0x80, 0x00,
  0x50, 0x53, 0x80, 0x27, 0x0d, 0x25, 0xcf, 0x1f,
  0x98, 0x29, 0xcf, 0x09, 0x27, 0x28, 0xdf, 0x3f,
  0x02, 0x5f, 0x98, 0x62, 0xcf, 0xdf, 0x98, 0xd9,
  0x0d, 0x02, 0x0d, 0x00, 0x2e, 0xd5, 0x7f, 0x05,
  0x27, 0x08, 0x44, 0x22, 0x5a, 0x07, 0x40, 0x01,
  0x5b, 0x4f, 0x80, 0x00, 0x50, 0x53, 0x80, 0x0b,
  0x0d, 0x07, 0x40, 0x1b, 0x5a, 0x44, 0xcf, 0x1f,
  0x20, 0x44, 0xaf, 0x5f, 0x9f, 0xc1, 0x2e, 0x57,
  0xdf, 0xff, 0x96, 0x41, 0x2e, 0x56, 0xdf, 0xdf,
  0x96, 0x41, 0x2e, 0x58, 0xdf, 0xc1, 0x2e, 0x59,
  0xdf, 0x9d, 0x01, 0x5d, 0x01, 0xff, 0x96, 0xdf,
  0x96, 0x40, 0x2e, 0x59, 0xdf, 0x5f, 0x9f, 0x50,
  0xdf, 0x7f, 0x9f, 0x1d, 0x00, 0xdd, 0x00, 0x5f,
  0x9f, 0x7f, 0x9f, 0x05, 0x27, 0x01, 0x0d, 0x41,
  0x2e, 0x56, 0xdf, 0x5f, 0x9f, 0x41, 0x2e, 0x57,
  0xdf, 0x5f, 0x9f, 0x41, 0x2e, 0x58, 0xdf, 0x5f,
  0x9f, 0x41, 0x2e, 0x59, 0xdf, 0x5f, 0x9f, 0x06,
  0x0d, 0x3b, 0xcf, 0x5f, 0x9f, 0x05, 0x27
};

static const unsigned char pkt496[] = {
  0x42, 0xca, 0x00,
  0x85, 0x24, 0x02, 0x2e, 0x23,
  0x80, 0x02, 0x2e, 0x4c, 0x80, 0x99, 0x88, 0x37,
  0x41, 0xdd, 0x2f, 0xc1, 0x5a, 0x0a, 0x40, 0x11,
  0x5a, 0x1f, 0x88, 0x41, 0x88, 0x4d, 0x88, 0x37,
  0x42, 0x08, 0x5a, 0x09, 0x46, 0x0a, 0x5b, 0x23,
  0x26, 0x08, 0x55, 0x22, 0xcf, 0xc6, 0x1e, 0x09,
  0x52, 0x10, 0xcf, 0x27, 0xaf, 0x6e, 0x23, 0x08,
  0xef, 0x6f, 0xaf, 0x62, 0x23, 0x6e, 0x26, 0x00,
  0x55, 0x6e, 0x24, 0x05, 0x27, 0x67, 0x2e, 0xff,
  0xdf, 0xdf, 0x22, 0x00, 0x2e, 0x25, 0x55, 0x67,
  0x2e, 0xfe, 0xdf, 0xdf, 0x22, 0x00, 0x2e, 0x20,
  0x55, 0x05, 0x27, 0x61, 0x23, 0x67, 0x2e, 0xff,
  0xdf, 0xdf, 0x22, 0x00, 0x2e, 0x19, 0x55, 0x67,
  0x2e, 0xfe, 0xdf, 0x65, 0xdf, 0xbf, 0x03, 0x00,
  0x2e, 0x13, 0x5e, 0x3b, 0x43, 0x01, 0x5a, 0x3b,
  0x41, 0x0e, 0x5a, 0x29, 0xdf, 0xff, 0x96, 0x25,
  0xdf, 0x5d, 0x00, 0x10, 0x1f, 0x00, 0x2e, 0x08,
  0x53, 0x07, 0x1f, 0x05, 0x53, 0x61, 0x24, 0x3b,
  0x41, 0x02, 0x5a, 0x03, 0x1f, 0x00, 0x53, 0x61,
  0x24, 0x05, 0x27, 0xff, 0xef, 0x61, 0xaf, 0x05,
  0x27, 0x3b, 0x43, 0x09, 0x5b, 0x28, 0xdf, 0x6e,
  0xbf, 0x70, 0xef, 0xbf, 0x22, 0x1a, 0x27, 0x29,
  0xdf, 0x6e, 0xcf, 0xdf, 0x01, 0x6d, 0x80, 0x6f,
  0xaf, 0x05, 0x27, 0x62, 0x26, 0x01, 0x54, 0x61,
  0x47, 0x1d, 0x5b, 0x10, 0xdf, 0x27, 0xbf, 0x61,
  0xcf, 0xdf, 0x22, 0x18, 0x54
};

static const unsigned char pkt500[] = {
  0x42, 0xca, 0x00,
  0xe9, 0x24, 0x5f, 0x00, 0x00,
  0x57, 0xbf, 0x22, 0x5f, 0xcf, 0xdf, 0x03, 0x00,
  0x5f, 0x5f, 0xdf, 0x27, 0xbf, 0x61, 0xcf, 0xdf,
  0x2d, 0x00, 0x2e, 0x19, 0x5a, 0x26, 0x88, 0xdf,
  0x96, 0x6e, 0xdf, 0x09, 0x88, 0x6e, 0xbf, 0xc0,
  0x97, 0x62, 0xdf, 0x05, 0x88, 0x62, 0xbf, 0x6f,
  0xdf, 0xdd, 0x97, 0x06, 0x88, 0x6f, 0xaf, 0x05,
  0x27, 0x8a, 0x80, 0x20, 0x10, 0x00, 0x13, 0x1c,
  0x82, 0x05, 0x27, 0xdf, 0x96, 0x9f, 0x22, 0xd9,
  0x81, 0x1a, 0x27, 0xdd, 0x9f, 0x6d, 0x80, 0x05,
  0x27, 0x0c, 0x88, 0xdf, 0x96, 0x6f, 0xdf, 0xef,
  0x8f, 0x6f, 0xbf, 0x6e, 0xdf, 0xc0, 0x97, 0xf0,
  0x8f, 0x6e, 0xaf, 0x62, 0xdf, 0xdd, 0x97, 0xec,
  0x8f, 0x62, 0xaf, 0x05, 0x27, 0x27, 0xcf, 0x61,
  0x47, 0x00, 0x5b, 0x1f, 0x20, 0x09, 0x8c, 0xff,
  0x97, 0x05, 0x27, 0x28, 0xdf, 0x06, 0x88, 0x2d,
  0xbf, 0x2c, 0xaf, 0x29, 0xdf, 0x02, 0x88, 0x2b,
  0xbf, 0x2a, 0xaf, 0x05, 0x27, 0xff, 0x96, 0x72,
  0xcf, 0x01, 0x16, 0xdf, 0x96, 0x57, 0xef, 0x25,
  0xff, 0x1d, 0x00, 0x00, 0x13, 0x1a, 0x27, 0x07,
  0x27, 0xff, 0x96, 0xc1, 0x9f, 0x3f, 0x22, 0x01,
  0x11, 0x8a, 0x80, 0xff, 0x96, 0xdf, 0x96, 0xc2,
  0x97, 0xc3, 0x9f, 0x3f, 0x22, 0x01, 0x11, 0x8a,
  0x80, 0x01, 0x00, 0xdf, 0x9f, 0xc0, 0x97, 0x04,
  0x0c, 0xff, 0x96, 0xdf, 0x96, 0x72, 0xcf, 0x07,
  0x1e, 0x04, 0x53, 0x03, 0x1e
};

static const unsigned char pkt504[] = {
  0x42, 0x2a, 0x00,
  0x4d, 0x25, 0x04, 0x53, 0xdd,
  0x97, 0xdd, 0x9f, 0x05, 0x27, 0x00, 0x88, 0xd8,
  0x71, 0xdd, 0x97, 0xdd, 0x9f, 0xd8, 0x81, 0x05,
  0x27, 0x00, 0x04, 0x00, 0x02, 0x4e, 0x07, 0x8e,
  0x03, 0x19, 0x02, 0x0c, 0x01, 0x32, 0x04, 0x1c,
  0x02, 0x0e, 0x01, 0x87, 0x00
};

static const unsigned char pkt508[] = {
  0x42, 0x8c, 0x00,
  0x61, 0x25, 0x53, 0x80, 0x01,
  0x0d, 0xf5, 0x97, 0xff, 0x0d, 0x1f, 0x99, 0x49,
  0xcf, 0x5f, 0x99, 0x08, 0x44, 0x00, 0x2e, 0x39,
  0x5a, 0x0b, 0x0d, 0x44, 0xcf, 0x0c, 0x41, 0x00,
  0x5b, 0x1f, 0x20, 0x44, 0xaf, 0x5f, 0x9f, 0x04,
  0x0d, 0x47, 0xcf, 0x5f, 0x9f, 0x48, 0xcf, 0x5f,
  0x9f, 0x1c, 0xcf, 0x5f, 0x9f, 0x1d, 0xcf, 0x5f,
  0x9f, 0x1e, 0xcf, 0x5f, 0x9f, 0x49, 0xcf, 0x5f,
  0x9f, 0x06, 0x0d, 0xe0, 0x97, 0x0f, 0x1c, 0x5f,
  0x9f, 0x0a, 0xcf, 0x5f, 0x9f, 0x09, 0xcf, 0x5f,
  0x9f, 0x2a, 0xcf, 0x5f, 0x9f, 0x2b, 0xcf, 0x5f,
  0x9f, 0x2c, 0xcf, 0x5f, 0x9f, 0x2d, 0xcf, 0x5f,
  0x9f, 0x02, 0x0d, 0x16, 0xcf, 0x5f, 0x9f, 0x44,
  0xdf, 0x02, 0x2e, 0x5f, 0x81, 0x5f, 0x9f, 0x4d,
  0xcf, 0x5f, 0x9f, 0x09, 0x46, 0x04, 0x5b, 0x90,
  0xcf, 0x5f, 0x9f, 0x91, 0xcf, 0x5f, 0x9f, 0x05,
  0x50, 0x01, 0x0d, 0x6a, 0xcf, 0x09, 0x27, 0x69,
  0xdf, 0x3f, 0x02, 0x5f, 0x9f, 0x05, 0x27
};

static const unsigned char pkt512[] = {
  0x42, 0xca, 0x00,
  0xa6, 0x25, 0x5c, 0x46, 0x00,
  0x5b, 0xfb, 0x31, 0x2d, 0x8a, 0xa9, 0x89, 0xbe,
  0x89, 0x06, 0x8a, 0x18, 0x89, 0x18, 0x89, 0x40,
  0xcf, 0x41, 0xdf, 0x45, 0xaf, 0x46, 0xbf, 0x07,
  0x38, 0x01, 0x5b, 0x01, 0x2e, 0xb7, 0x80, 0x3b,
  0x40, 0x00, 0x2e, 0x42, 0x5b, 0x5c, 0x47, 0x00,
  0x5a, 0xad, 0x89, 0x09, 0x46, 0x00, 0x5b, 0x75,
  0x8d, 0xc9, 0x30, 0x41, 0x2e, 0x7a, 0xdf, 0x1f,
  0x28, 0x41, 0x2e, 0x7a, 0xbf, 0xfb, 0x39, 0xfa,
  0x33, 0xc8, 0x46, 0x10, 0x5b, 0xd0, 0x46, 0xfd,
  0x5b, 0xd3, 0x45, 0xfd, 0x5a, 0xd3, 0x45, 0xfb,
  0x5a, 0xd3, 0x45, 0xf9, 0x5a, 0xd3, 0x3c, 0x41,
  0x2e, 0xa1, 0xdf, 0x9f, 0x28, 0x41, 0x2e, 0xa1,
  0xbf, 0x02, 0x2e, 0xb0, 0x81, 0x0c, 0x78, 0x64,
  0x81, 0xd3, 0x45, 0xe9, 0x5a, 0xd3, 0x3c, 0xc8,
  0xcf, 0xdf, 0x22, 0x02, 0x55, 0xc7, 0xcf, 0xdf,
  0x22, 0x02, 0x54, 0xd3, 0x33, 0xd3, 0x31, 0x64,
  0x81, 0xf7, 0xef, 0x16, 0x80, 0xf8, 0xcf, 0x9f,
  0x1c, 0xf8, 0xaf, 0xfb, 0x39, 0xfa, 0x33, 0x5c,
  0x47, 0x03, 0x5a, 0x08, 0x43, 0xdc, 0x2f, 0xec,
  0x5a, 0x02, 0x50, 0x3d, 0x23, 0xdc, 0x2f, 0xe8,
  0x50, 0x02, 0xcf, 0x0f, 0x1c, 0x10, 0x18, 0x02,
  0xaf, 0xe1, 0x72, 0x5c, 0x46, 0x01, 0x5a, 0x01,
  0x2e, 0xcd, 0x80, 0xd0, 0x41, 0x00, 0x5b, 0xc1,
  0x83, 0x52, 0x26, 0xe6, 0x2f, 0xbd, 0x55, 0x53,
  0x26, 0xe6, 0x2f, 0xba, 0x55
};

static const unsigned char pkt516[] = {
  0x42, 0xca, 0x00,
  0x0a, 0x26, 0x07, 0x3a, 0x00,
  0x2e, 0x38, 0x7c, 0x02, 0x2e, 0x49, 0x81, 0x45,
  0xcf, 0x46, 0xdf, 0x19, 0x27, 0xef, 0x88, 0x02,
  0x89, 0x05, 0x27, 0x12, 0x82, 0x05, 0x27, 0x41,
  0x8a, 0x10, 0x5b, 0x49, 0xef, 0xff, 0xaf, 0x05,
  0xef, 0xff, 0xaf, 0x9f, 0x22, 0xff, 0xaf, 0x10,
  0xef, 0xff, 0xaf, 0x22, 0xcf, 0xff, 0xaf, 0x23,
  0xcf, 0xff, 0xaf, 0x9f, 0x22, 0xff, 0xaf, 0xff,
  0xaf, 0x02, 0x2e, 0xa1, 0x81, 0x0c, 0x40, 0x29,
  0x5b, 0x4a, 0x80, 0x0d, 0x34, 0x10, 0x5a, 0x49,
  0xcf, 0x5f, 0x9d, 0x49, 0x38, 0x53, 0x80, 0x49,
  0xcf, 0x5f, 0x9d, 0x4a, 0x80, 0x9f, 0x22, 0x1f,
  0x9c, 0x5f, 0x9c, 0x1e, 0xcf, 0x1f, 0x9d, 0x48,
  0xcf, 0x1d, 0xdf, 0xdf, 0x01, 0x9f, 0x22, 0x11,
  0x50, 0xbb, 0x88, 0xf5, 0x97, 0x49, 0xaf, 0xd4,
  0x89, 0x49, 0xcf, 0xf7, 0x1c, 0x5f, 0x9d, 0x44,
  0xdf, 0x3f, 0x20, 0x44, 0xbf, 0xff, 0x9a, 0x02,
  0x2e, 0x5f, 0x81, 0x20, 0x0d, 0x9f, 0x99, 0xe0,
  0x0d, 0x1c, 0xcf, 0x1d, 0xdf, 0x9f, 0x9c, 0xff,
  0x9c, 0x00, 0x2e, 0xe9, 0x8f, 0x0c, 0x41, 0x01,
  0x5b, 0x00, 0x2e, 0xeb, 0x8f, 0x0c, 0x42, 0x04,
  0x5b, 0xe4, 0x40, 0x01, 0x5a, 0xe4, 0x3a, 0x00,
  0x50, 0xe4, 0x32, 0x0c, 0x43, 0x04, 0x5b, 0xe4,
  0x42, 0x01, 0x5a, 0xe4, 0x30, 0x00, 0x50, 0xe4,
  0x38, 0x0c, 0x44, 0x10, 0x5b, 0x18, 0x23, 0x1a,
  0x23, 0x1b, 0x23, 0xe4, 0x42
};

static const unsigned char pkt520[] = {
  0x42, 0xca, 0x00,
  0x6e, 0x26, 0x01, 0x5a, 0xe4,
  0x38, 0x00, 0x50, 0xe4, 0x30, 0x4a, 0x80, 0x2b,
  0x0d, 0x02, 0x2e, 0x9d, 0x81, 0xe4, 0x42, 0x01,
  0x5a, 0xe4, 0x30, 0x00, 0x50, 0xe4, 0x38, 0x0c,
  0x45, 0x00, 0x5b, 0x0f, 0x88, 0x0c, 0x46, 0x01,
  0x5a, 0x01, 0x2e, 0xb7, 0x80, 0x0c, 0x43, 0x05,
  0x5b, 0x0c, 0x45, 0x03, 0x5b, 0x0d, 0x45, 0x01,
  0x5b, 0x0d, 0x37, 0x05, 0x27, 0x0c, 0x40, 0x00,
  0x5b, 0x0d, 0x3f, 0x05, 0x27, 0x60, 0xcf, 0x0f,
  0x1c, 0xdf, 0x9f, 0x0c, 0x1c, 0x12, 0x82, 0x03,
  0x1d, 0x19, 0x82, 0x5f, 0x02, 0x60, 0xcf, 0xf0,
  0x1c, 0x3f, 0x02, 0x60, 0xaf, 0x05, 0x27, 0x28,
  0xff, 0x64, 0xef, 0x19, 0x27, 0x01, 0xff, 0x5a,
  0xef, 0x1b, 0x27, 0x06, 0xef, 0x06, 0xaf, 0xfc,
  0x97, 0x5f, 0x9f, 0x06, 0x25, 0xfb, 0x55, 0x05,
  0x27, 0x10, 0xcf, 0x72, 0xaf, 0x0a, 0x40, 0x13,
  0x5a, 0x27, 0xcf, 0x10, 0xaf, 0x07, 0x43, 0x08,
  0x5b, 0x3b, 0x31, 0x02, 0x5b, 0x3b, 0x36, 0x3b,
  0x43, 0x03, 0x5b, 0x6e, 0xcf, 0xe2, 0xaf, 0x6f,
  0xcf, 0xe3, 0xaf, 0x02, 0x2e, 0xd5, 0x80, 0x07,
  0x40, 0x02, 0x5a, 0x61, 0x26, 0x00, 0x55, 0x07,
  0x33, 0x88, 0x82, 0x02, 0x43, 0xdb, 0x2f, 0xc7,
  0x5b, 0x02, 0x2e, 0x72, 0x80, 0x05, 0x27, 0x05,
  0x27, 0x05, 0x27, 0x0c, 0xcf, 0x03, 0x1c, 0x0b,
  0x55, 0x0c, 0xcf, 0x0c, 0x1c, 0x0c, 0x1e, 0x07,
  0x54, 0x08, 0x1e, 0x03, 0x55
};

static const unsigned char pkt524[] = {
  0x42, 0xca, 0x00,
  0xd2, 0x26, 0x0c, 0x45, 0x01,
  0x5b, 0x0d, 0x44, 0x01, 0x5b, 0x0e, 0x33, 0x05,
  0x27, 0x0e, 0x3b, 0x05, 0x27, 0x0d, 0xcf, 0x06,
  0x1c, 0x09, 0x55, 0x09, 0x46, 0x04, 0x5b, 0x15,
  0x88, 0x02, 0x5a, 0xf2, 0xcf, 0x0b, 0xaf, 0x10,
  0x50, 0x02, 0xef, 0x0c, 0xaf, 0x0d, 0x50, 0x0a,
  0x41, 0x0b, 0x5b, 0x0c, 0x39, 0x0c, 0x46, 0x03,
  0x5b, 0x4a, 0x80, 0x0e, 0x88, 0x29, 0x89, 0x00,
  0x50, 0x0c, 0x31, 0x0c, 0x38, 0x01, 0x5b, 0x0d,
  0x3f, 0x0d, 0x34, 0x05, 0x27, 0x23, 0x26, 0x02,
  0x55, 0x22, 0xcf, 0xc8, 0x1e, 0x00, 0x5f, 0x0c,
  0x27, 0x0d, 0x27, 0xf0, 0x97, 0x47, 0xaf, 0xf1,
  0x97, 0x48, 0xaf, 0x05, 0x27, 0x46, 0x80, 0x08,
  0x46, 0x0f, 0x5a, 0xde, 0xef, 0x5f, 0x9f, 0x10,
  0xef, 0x5f, 0x9f, 0x00, 0xef, 0x5f, 0x9f, 0x28,
  0xff, 0x54, 0xef, 0x1b, 0x27, 0x10, 0xef, 0x06,
  0xaf, 0xfc, 0x97, 0x5f, 0x9f, 0x06, 0x25, 0xfb,
  0x55, 0x62, 0x80, 0x05, 0x27, 0x46, 0x80, 0x08,
  0x47, 0xfb, 0x5a, 0xdf, 0xef, 0x5f, 0x9f, 0x06,
  0xef, 0x5f, 0x9f, 0x00, 0xef, 0x5f, 0x9f, 0x28,
  0xff, 0x64, 0xef, 0x1b, 0x27, 0x06, 0xef, 0x06,
  0xaf, 0xea, 0x50, 0x28, 0xff, 0x64, 0xef, 0x19,
  0x27, 0x0f, 0xef, 0x6b, 0xdf, 0xff, 0x96, 0xbf,
  0x22, 0xff, 0x96, 0x7b, 0x00, 0xc1, 0x03, 0x6b,
  0xbf, 0x0c, 0x53, 0xdf, 0x96, 0xc2, 0x97, 0xbf,
  0x01, 0x5f, 0x90, 0xdd, 0x97
};

static const unsigned char pkt528[] = {
  0x42, 0xca, 0x00,
  0x36, 0x27, 0x5f, 0x20, 0x02,
  0x1e, 0xf3, 0x53, 0x02, 0xef, 0x01, 0x0c, 0xdd,
  0x9f, 0x6b, 0xbf, 0x15, 0x50, 0xdf, 0x96, 0xc2,
  0x97, 0xdf, 0x01, 0xc1, 0x03, 0x05, 0x52, 0xdd,
  0x97, 0x1f, 0x20, 0x6b, 0xdf, 0xe0, 0x01, 0x6b,
  0xbf, 0x00, 0x50, 0xdd, 0x97, 0x02, 0x0c, 0x6b,
  0xdf, 0x28, 0x1f, 0x01, 0x53, 0x28, 0xff, 0x6b,
  0xbf, 0x68, 0x1f, 0x01, 0x5f, 0x68, 0xff, 0x6b,
  0xbf, 0x05, 0x27, 0x01, 0x81, 0x50, 0x8f, 0xf1,
  0x88, 0x05, 0x81, 0x00, 0x2e, 0x32, 0x8d, 0x01,
  0x2e, 0x06, 0x80, 0x00, 0x2e, 0xd8, 0x8e, 0x5c,
  0x47, 0x02, 0x5b, 0x00, 0x2e, 0x16, 0x8f, 0x01,
  0x50, 0x00, 0x2e, 0x14, 0x8f, 0x08, 0xef, 0x0f,
  0x80, 0x01, 0x2e, 0x54, 0x80, 0x05, 0x27, 0x07,
  0x40, 0x01, 0x5b, 0x54, 0x23, 0x18, 0x50, 0x9c,
  0x8e, 0x0d, 0xcf, 0x06, 0x1c, 0x08, 0x54, 0x14,
  0x88, 0x02, 0x2e, 0x9d, 0x81, 0x01, 0x2e, 0x50,
  0x82, 0x4f, 0x8f, 0x68, 0x88, 0x01, 0x2e, 0x44,
  0x84, 0x5c, 0x8f, 0x54, 0x88, 0x09, 0x46, 0x02,
  0x5b, 0x37, 0x82, 0x90, 0xaf, 0x91, 0xbf, 0x00,
  0x2e, 0xe6, 0x8f, 0x90, 0x8e, 0x0c, 0x3e, 0xed,
  0x5a, 0x05, 0x27, 0x37, 0x82, 0x4a, 0x82, 0x1c,
  0x82, 0x1c, 0x82, 0x9d, 0xbf, 0xff, 0x97, 0x08,
  0x10, 0x09, 0x27, 0x0f, 0x1c, 0x5c, 0x46, 0x03,
  0x5b, 0x02, 0x1e, 0x04, 0x53, 0x02, 0xef, 0x02,
  0x50, 0x03, 0x1e, 0x00, 0x53
};

static const unsigned char pkt532[] = {
  0x42, 0xca, 0x00,
  0x9a, 0x27, 0x03, 0xef, 0x69,
  0xaf, 0x53, 0x80, 0x1b, 0x0d, 0xe1, 0x97, 0x0f,
  0x1c, 0x69, 0xdf, 0xdf, 0x01, 0x00, 0x53, 0x00,
  0xff, 0xe0, 0x97, 0x8a, 0x80, 0x04, 0x10, 0x11,
  0x82, 0x0f, 0x1e, 0x00, 0x5f, 0x0f, 0xef, 0x6a,
  0xaf, 0xc1, 0x2e, 0x47, 0xdf, 0xf0, 0x1d, 0x5f,
  0x02, 0xc1, 0x2e, 0x47, 0xbf, 0x10, 0x0d, 0x05,
  0x27, 0x01, 0x2e, 0x56, 0x80, 0xf7, 0xef, 0x16,
  0x80, 0x66, 0x80, 0x20, 0x82, 0xdf, 0x8e, 0x02,
  0x2e, 0x3e, 0x81, 0x02, 0x2e, 0x93, 0x81, 0x00,
  0x2e, 0xb4, 0x8e, 0x5c, 0x47, 0x09, 0x5b, 0x6c,
  0x38, 0x3b, 0x43, 0x00, 0x5b, 0x6c, 0x30, 0x41,
  0x2e, 0x71, 0xdf, 0xc1, 0x2e, 0x72, 0xdf, 0xbf,
  0x03, 0x01, 0x55, 0x00, 0x2e, 0xc7, 0x8e, 0x67,
  0x8c, 0x01, 0x2e, 0xcd, 0x80, 0x05, 0x27, 0x3b,
  0x40, 0x01, 0x5b, 0x02, 0xef, 0x0c, 0xaf, 0x05,
  0x27, 0x52, 0xcf, 0xcb, 0xaf, 0x53, 0xdf, 0xcc,
  0xbf, 0xdf, 0x22, 0x01, 0x55, 0xff, 0x22, 0x01,
  0x54, 0x0e, 0xef, 0xc9, 0xaf, 0x05, 0x27, 0x0e,
  0xcf, 0x6e, 0x1c, 0x49, 0xdf, 0x10, 0x1d, 0x3f,
  0x02, 0x49, 0xaf, 0x0d, 0x44, 0x06, 0x5a, 0x0a,
  0x41, 0x03, 0x5b, 0x49, 0x43, 0x02, 0x5a, 0x48,
  0x26, 0x00, 0x55, 0x49, 0x30, 0x9f, 0x2c, 0x05,
  0x5a, 0xdf, 0x2c, 0x4c, 0x5a, 0x0e, 0x41, 0x15,
  0x5b, 0x0c, 0x46, 0x13, 0x5a, 0x9f, 0x22, 0x1c,
  0xaf, 0x21, 0xaf, 0x45, 0x88
};

static const unsigned char pkt536[] = {
  0x42, 0xca, 0x00,
  0xfe, 0x27, 0x03, 0x5a, 0x9f,
  0x2c, 0x05, 0x5a, 0x9f, 0x22, 0x04, 0x50, 0x9f,
  0x22, 0x0e, 0x3e, 0x0e, 0x3d, 0x00, 0x5b, 0x5f,
  0xef, 0x1d, 0xaf, 0x49, 0xcf, 0x87, 0x1c, 0x01,
  0x18, 0x49, 0xaf, 0x34, 0x50, 0x20, 0x26, 0x08,
  0x55, 0x1f, 0xcf, 0x48, 0xdf, 0xff, 0x2d, 0x00,
  0x5b, 0xff, 0x21, 0x3f, 0x00, 0x00, 0x53, 0xff,
  0xef, 0x1f, 0xaf, 0x47, 0xdf, 0x1c, 0xcf, 0x3f,
  0x00, 0x1c, 0xaf, 0x1d, 0xcf, 0x48, 0xdf, 0x3f,
  0x00, 0x1d, 0xaf, 0xff, 0x22, 0x1f, 0x54, 0xff,
  0x2d, 0x03, 0x5b, 0xff, 0x1e, 0x19, 0x5b, 0x60,
  0x10, 0x02, 0x50, 0x60, 0x1e, 0x0a, 0x52, 0x60,
  0x16, 0x1d, 0xaf, 0x49, 0x30, 0x49, 0x3c, 0x12,
  0x5b, 0x21, 0xcf, 0x47, 0xdf, 0x3f, 0x00, 0x1c,
  0xaf, 0x21, 0x23, 0x0c, 0x50, 0x59, 0x1e, 0x0a,
  0x52, 0x49, 0x34, 0x01, 0x5a, 0x21, 0x23, 0x06,
  0x50, 0x21, 0xcf, 0x47, 0xdf, 0x3f, 0x00, 0x21,
  0xaf, 0x01, 0x50, 0x06, 0x1e, 0xf4, 0x5f, 0x05,
  0x27, 0x0d, 0xcf, 0x06, 0x1c, 0x06, 0x1e, 0x00,
  0x54, 0x0d, 0x27, 0x0c, 0x27, 0x09, 0x46, 0x0c,
  0x5b, 0xa8, 0x8e, 0x07, 0x52, 0x0f, 0xcf, 0x01,
  0x16, 0x02, 0x53, 0x02, 0x2e, 0x36, 0x83, 0x04,
  0x50, 0xf4, 0xaf, 0x02, 0x50, 0xf2, 0xcf, 0x02,
  0x10, 0x0f, 0xaf, 0x05, 0x27, 0x5a, 0xcf, 0xdf,
  0x22, 0x10, 0x54, 0x3e, 0xdf, 0x3f, 0x20, 0x3f,
  0x1f, 0x0a, 0x52, 0xbf, 0x22
};

static const unsigned char pkt540[] = {
  0x42, 0x50, 0x00,
  0x62, 0x28, 0x3e, 0xbf, 0x3d,
  0xdf, 0x3f, 0x20, 0xdf, 0x03, 0x02, 0x52, 0xbf,
  0x22, 0x3d, 0xbf, 0x0c, 0x27, 0x3d, 0xbf, 0x0d,
  0x27, 0x3e, 0xbf, 0x0d, 0x27, 0x0d, 0x27, 0x0f,
  0x1c, 0x69, 0xdf, 0xdf, 0x01, 0x00, 0x53, 0x00,
  0xff, 0x05, 0x27, 0x37, 0x82, 0x4a, 0x82, 0x1c,
  0x82, 0x1c, 0x82, 0x9d, 0xbf, 0xff, 0x97, 0x08,
  0x10, 0x09, 0x27, 0x0f, 0x1c, 0x5c, 0x46, 0x03,
  0x5b, 0x02, 0x1e, 0x04, 0x53, 0x02, 0xef, 0x02,
  0x50, 0x03, 0x1e, 0x00, 0x53, 0x03, 0xef, 0x69,
  0xaf, 0x05, 0x27
};

static const unsigned char pkt544[] = {
  0x42, 0xca, 0x00,
  0x89, 0x28, 0x0c, 0x42, 0x00,
  0x5b, 0x18, 0x23, 0x0c, 0x23, 0x0e, 0xcf, 0xe0,
  0x1c, 0x0e, 0xaf, 0x0a, 0x40, 0x02, 0x5a, 0x3b,
  0x46, 0x00, 0x5a, 0x05, 0x27, 0x37, 0x43, 0xfc,
  0x5b, 0x08, 0xef, 0x0c, 0xaf, 0x0d, 0x40, 0x0a,
  0x5a, 0xee, 0xcf, 0x64, 0x1e, 0x01, 0x5e, 0x0c,
  0x3b, 0x05, 0x27, 0x0d, 0x30, 0x0c, 0x35, 0xbf,
  0x22, 0xc0, 0x2e, 0x96, 0xbf, 0x05, 0x27, 0x0e,
  0x45, 0x01, 0x5b, 0x07, 0x88, 0x00, 0x50, 0x0e,
  0x88, 0x0d, 0x41, 0x1f, 0x5a, 0x0d, 0x42, 0x11,
  0x5a, 0xd6, 0x78, 0x51, 0x88, 0x19, 0xcf, 0xfe,
  0x1e, 0x03, 0x5c, 0x0e, 0x3d, 0x0d, 0x39, 0x0d,
  0x3b, 0x0c, 0x27, 0x0d, 0x27, 0x64, 0x88, 0x19,
  0xcf, 0x02, 0x1e, 0xfa, 0x5a, 0x0e, 0x3e, 0x0d,
  0x3a, 0x0d, 0x33, 0x0c, 0x27, 0xe4, 0x37, 0x04,
  0x89, 0xe4, 0x3f, 0x01, 0x2e, 0xef, 0x82, 0x0d,
  0x45, 0x54, 0x5b, 0x18, 0xcf, 0xdf, 0x22, 0x67,
  0x54, 0x0d, 0x3b, 0x4f, 0x78, 0xf9, 0x88, 0x01,
  0x2e, 0xef, 0x82, 0x0d, 0x42, 0x06, 0x5a, 0x0d,
  0x45, 0x48, 0x5b, 0x18, 0xcf, 0xdf, 0x22, 0x5b,
  0x54, 0x0d, 0x33, 0x43, 0x78, 0x15, 0xcf, 0x1a,
  0xaf, 0xe4, 0x37, 0xea, 0x88, 0x15, 0xcf, 0x1b,
  0xaf, 0xe4, 0x3f, 0x0d, 0xcf, 0x60, 0x1c, 0xdf,
  0x22, 0x00, 0x55, 0x63, 0x78, 0x16, 0xcf, 0x13,
  0xdf, 0x2a, 0x1e, 0x02, 0x5f, 0x2a, 0x1f, 0x00,
  0x5f, 0x5c, 0x78, 0xbf, 0x03
};

static const unsigned char pkt548[] = {
  0x42, 0xca, 0x00,
  0xed, 0x28, 0x44, 0x54, 0x1d,
  0x52, 0x01, 0x2e, 0xef, 0x82, 0x9f, 0x22, 0x1a,
  0xaf, 0x18, 0xcf, 0x12, 0xdf, 0xbf, 0x03, 0x00,
  0x53, 0x24, 0x50, 0x09, 0x88, 0x01, 0x2e, 0xe3,
  0x82, 0x9f, 0x22, 0x1b, 0xaf, 0xb1, 0x8f, 0x1d,
  0x78, 0x0e, 0xcf, 0x9f, 0x1c, 0x0e, 0xaf, 0x05,
  0x27, 0x0e, 0xcf, 0x5f, 0x2d, 0x05, 0x5a, 0x9f,
  0x2b, 0x5f, 0x29, 0x0e, 0xaf, 0x5f, 0xff, 0x1d,
  0xbf, 0x1c, 0x23, 0x05, 0x27, 0x9f, 0x22, 0x1b,
  0xaf, 0x18, 0xcf, 0xdf, 0x22, 0x0a, 0x54, 0x18,
  0xcf, 0x12, 0xdf, 0xbf, 0x03, 0x00, 0x53, 0x05,
  0x50, 0x06, 0x88, 0x01, 0x2e, 0xe9, 0x82, 0x9f,
  0x22, 0x1a, 0xaf, 0x9b, 0x8f, 0x09, 0x88, 0x05,
  0x27, 0x0e, 0xcf, 0x9f, 0x2d, 0x04, 0x5a, 0x9f,
  0x29, 0x5f, 0x2b, 0x0e, 0xaf, 0x1d, 0x23, 0x1c,
  0x23, 0x05, 0x27, 0x0d, 0x45, 0x1e, 0x5b, 0x8e,
  0x88, 0x18, 0xcf, 0x12, 0xdf, 0xbf, 0x03, 0x57,
  0x53, 0x0d, 0x44, 0x02, 0x5b, 0x0c, 0x35, 0x0c,
  0x78, 0x85, 0x88, 0x17, 0xcf, 0xdf, 0x22, 0x08,
  0x55, 0x18, 0xcf, 0xdf, 0x22, 0x05, 0x55, 0x0a,
  0x88, 0x0e, 0x3b, 0x0c, 0xdf, 0x24, 0x19, 0x0c,
  0xbf, 0x05, 0x27, 0x11, 0xcf, 0xff, 0x1e, 0x01,
  0x54, 0x1f, 0x20, 0x11, 0xaf, 0x05, 0x27, 0x1a,
  0x23, 0x1b, 0x23, 0x05, 0x27, 0xfb, 0x8f, 0x0b,
  0x88, 0x6d, 0x88, 0xf6, 0x8e, 0x34, 0x5a, 0x0a,
  0xcf, 0xc0, 0x1c, 0xc0, 0x1e
};

static const unsigned char pkt552[] = {
  0x42, 0xca, 0x00,
  0x51, 0x29, 0x0d, 0x55, 0x9f,
  0x22, 0x1f, 0xaf, 0x20, 0xaf, 0x19, 0xaf, 0x1b,
  0x78, 0x0e, 0xcf, 0x05, 0x18, 0x0e, 0xaf, 0x9f,
  0x22, 0x47, 0xaf, 0x48, 0xaf, 0x17, 0xaf, 0x18,
  0xaf, 0x05, 0x27, 0x20, 0xcf, 0xdf, 0x22, 0x05,
  0x54, 0x05, 0x1e, 0x19, 0x55, 0x1f, 0xdf, 0x80,
  0x1f, 0x16, 0x5e, 0x02, 0x78, 0x1f, 0xdf, 0x10,
  0x1f, 0x12, 0x5e, 0x9f, 0x22, 0x20, 0xaf, 0x1f,
  0xaf, 0x0a, 0xcf, 0xc0, 0x1c, 0x80, 0x1e, 0x0a,
  0x55, 0x0d, 0x41, 0x01, 0x5a, 0x0e, 0x35, 0x00,
  0x50, 0x0e, 0x36, 0x0d, 0xcf, 0x06, 0x18, 0x0d,
  0xaf, 0x0e, 0x31, 0x9f, 0x22, 0x19, 0xaf, 0x03,
  0x78, 0x1f, 0x20, 0x06, 0x1e, 0x00, 0x5e, 0x20,
  0xaf, 0x0d, 0x47, 0x01, 0x5b, 0x01, 0x2e, 0xa2,
  0x73, 0x0d, 0x44, 0x0b, 0x5a, 0x0d, 0xcf, 0x06,
  0x1c, 0x08, 0x54, 0x0c, 0x30, 0x48, 0xcf, 0xdf,
  0x2d, 0x02, 0x5a, 0x9f, 0x22, 0x1d, 0xaf, 0x01,
  0x50, 0x5f, 0xef, 0x1d, 0xaf, 0x0c, 0x31, 0x0d,
  0x45, 0x11, 0x5b, 0x0a, 0xcf, 0x30, 0x1c, 0x0c,
  0x55, 0x0d, 0xcf, 0x06, 0x1c, 0x06, 0x1e, 0x0b,
  0x54, 0x11, 0xcf, 0x07, 0x1e, 0x02, 0x53, 0x04,
  0xef, 0x12, 0xaf, 0x04, 0x78, 0x05, 0xef, 0x12,
  0xaf, 0x01, 0x78, 0x01, 0xef, 0x12, 0xaf, 0x18,
  0x23, 0x9f, 0x22, 0x11, 0xaf, 0x0d, 0xcf, 0x1f,
  0x1c, 0x0d, 0xaf, 0x0c, 0xdf, 0x24, 0x19, 0x0c,
  0xbf, 0x0a, 0xdf, 0x30, 0x1d
};

static const unsigned char pkt556[] = {
  0x42, 0x46, 0x00,
  0xb5, 0x29, 0x20, 0x1f, 0x01,
  0x55, 0xf9, 0x1c, 0x0d, 0xaf, 0x05, 0x27, 0x17,
  0xdf, 0xff, 0x21, 0x47, 0xbf, 0x18, 0xdf, 0x84,
  0x8e, 0x02, 0x5b, 0x0e, 0x46, 0x03, 0x5a, 0x01,
  0x78, 0x0d, 0x43, 0x00, 0x5a, 0xff, 0x21, 0x48,
  0xbf, 0x05, 0x27, 0x14, 0x23, 0x15, 0x23, 0xff,
  0xef, 0x13, 0xaf, 0x01, 0x2e, 0x00, 0x83, 0x0d,
  0x3e, 0x13, 0xcf, 0x46, 0xff, 0xbf, 0x03, 0x00,
  0x53, 0x0d, 0x36, 0x05, 0x27, 0x05, 0x27, 0x05,
  0x27
};

static const unsigned char pkt560[] = {
  0x42, 0xca, 0x00,
  0xd7, 0x29, 0xe1, 0x97, 0xe2,
  0x9f, 0x46, 0x2e, 0x28, 0xbf, 0xc6, 0x2e, 0x29,
  0xbf, 0xad, 0x88, 0x0a, 0x5b, 0xe9, 0x97, 0xea,
  0x9f, 0x4f, 0xaf, 0x50, 0xbf, 0x46, 0x2e, 0x28,
  0xdf, 0xc6, 0x2e, 0x29, 0xdf, 0x10, 0x10, 0x00,
  0x13, 0x01, 0x78, 0x03, 0x10, 0x00, 0x13, 0xff,
  0x96, 0xdf, 0x96, 0xd6, 0xcf, 0xd7, 0xdf, 0x0f,
  0x1d, 0x01, 0x10, 0x00, 0x13, 0xff, 0x96, 0xdf,
  0x96, 0xc8, 0xdf, 0xc7, 0xcf, 0x1f, 0x1d, 0xff,
  0x96, 0xdf, 0x96, 0xc2, 0x97, 0xc3, 0x9f, 0x9d,
  0x01, 0x5d, 0x01, 0xf5, 0x52, 0xc3, 0x03, 0x02,
  0x5e, 0xf2, 0x52, 0x82, 0x03, 0xf0, 0x52, 0x02,
  0x0c, 0xf8, 0x43, 0x03, 0x5b, 0x08, 0x44, 0x01,
  0x5a, 0x00, 0x2e, 0xf3, 0x8f, 0x7f, 0x88, 0x6d,
  0x5b, 0x41, 0x2e, 0xaf, 0xdf, 0xdf, 0x29, 0x41,
  0x2e, 0xaf, 0xbf, 0x46, 0x2e, 0x28, 0xdf, 0xc6,
  0x2e, 0x29, 0xdf, 0x03, 0x16, 0x00, 0x15, 0x46,
  0x2e, 0x28, 0xbf, 0xc6, 0x2e, 0x29, 0xbf, 0x15,
  0x27, 0xff, 0x96, 0xdf, 0x96, 0x8d, 0x88, 0x94,
  0x88, 0xcd, 0x88, 0x01, 0xff, 0xab, 0xef, 0x19,
  0x27, 0x6b, 0x88, 0xbf, 0x22, 0x3f, 0x98, 0x05,
  0xff, 0x7f, 0x98, 0xdd, 0x9f, 0xbf, 0x98, 0x24,
  0x28, 0x04, 0xff, 0x7f, 0x98, 0xdd, 0x9f, 0xbf,
  0x98, 0x24, 0x28, 0x66, 0xff, 0xbf, 0x99, 0x12,
  0xff, 0x7f, 0x99, 0xdd, 0x97, 0xdd, 0x9f, 0x19,
  0x27, 0xe0, 0x97, 0xff, 0xaf
};

static const unsigned char pkt564[] = {
  0x42, 0xca, 0x00,
  0x3b, 0x2a, 0x46, 0x2e, 0x28,
  0xdf, 0xc6, 0x2e, 0x29, 0xdf, 0x13, 0x10, 0x00,
  0x13, 0xff, 0xaf, 0xff, 0xbf, 0xe3, 0x97, 0xff,
  0xaf, 0xe4, 0x97, 0xff, 0xaf, 0xe5, 0x97, 0xff,
  0xaf, 0xef, 0x88, 0x06, 0x0d, 0xdd, 0x97, 0xdd,
  0x9f, 0x46, 0x2e, 0x28, 0xdf, 0xc6, 0x2e, 0x29,
  0xdf, 0x06, 0xaf, 0x4e, 0xbf, 0xff, 0x22, 0x11,
  0x54, 0x15, 0x27, 0x1a, 0x27, 0x01, 0xff, 0xab,
  0xef, 0x19, 0x27, 0xdc, 0x97, 0xdf, 0x99, 0x28,
  0x28, 0x0f, 0x27, 0x68, 0x2c, 0xfd, 0x5b, 0xe9,
  0x97, 0xff, 0xaf, 0x6a, 0x28, 0x06, 0x25, 0xf4,
  0x53, 0x4e, 0x25, 0xf2, 0x55, 0xdc, 0x97, 0xdf,
  0x99, 0x28, 0x28, 0x0f, 0x27, 0x68, 0x2c, 0xfd,
  0x5b, 0xe9, 0x97, 0xff, 0xaf, 0x6a, 0x28, 0x06,
  0x25, 0xf4, 0x55, 0x41, 0x2e, 0xaf, 0xdf, 0xdf,
  0x2b, 0x41, 0x2e, 0xaf, 0xbf, 0xbf, 0x22, 0xbf,
  0x99, 0x7f, 0x99, 0x05, 0x27, 0xdd, 0x97, 0xdd,
  0x9f, 0x06, 0xaf, 0x4e, 0xbf, 0xff, 0x22, 0x05,
  0x54, 0xfd, 0x97, 0xff, 0xaf, 0x06, 0x25, 0xfb,
  0x53, 0x4e, 0x25, 0xf9, 0x55, 0xfd, 0x97, 0xff,
  0xaf, 0x06, 0x25, 0xfb, 0x55, 0x05, 0x27, 0xff,
  0x96, 0xc6, 0x2e, 0x01, 0xdf, 0xbf, 0x2c, 0xdd,
  0x9f, 0x05, 0x27, 0xc6, 0x2e, 0x28, 0xdf, 0x0f,
  0x1d, 0x04, 0x55, 0x0b, 0x88, 0xff, 0x96, 0x10,
  0xef, 0xdf, 0x96, 0x06, 0x50, 0x06, 0x88, 0x3f,
  0x20, 0xff, 0x96, 0xc6, 0x2e
};

static const unsigned char pkt568[] = {
  0x42, 0xca, 0x00,
  0x9f, 0x2a, 0x28, 0xdf, 0x0f,
  0x1d, 0xff, 0x96, 0x05, 0x27, 0x46, 0x2e, 0x28,
  0xdf, 0xf0, 0x1c, 0x09, 0x27, 0xdf, 0x9f, 0x46,
  0x2e, 0x29, 0xdf, 0x0f, 0x1c, 0x09, 0x27, 0x5f,
  0x02, 0x05, 0x27, 0x78, 0x88, 0x6f, 0x88, 0x0a,
  0xef, 0xdc, 0x9f, 0x3f, 0x9f, 0x5f, 0x20, 0xfb,
  0x55, 0x05, 0x27, 0x9f, 0x22, 0x41, 0x2e, 0xab,
  0xbf, 0x50, 0xef, 0xdf, 0x96, 0x3a, 0xef, 0xdf,
  0x96, 0x29, 0x88, 0x68, 0x88, 0x0a, 0xef, 0xfc,
  0x9f, 0xc1, 0x2e, 0xad, 0xbf, 0xc1, 0x2e, 0xac,
  0xdf, 0x3f, 0x20, 0xc1, 0x2e, 0xac, 0xbf, 0x6a,
  0x88, 0x5f, 0x20, 0xf4, 0x55, 0x5b, 0xef, 0xdf,
  0x96, 0x50, 0xcf, 0xdf, 0x96, 0x17, 0x88, 0x5c,
  0xef, 0xdf, 0x96, 0x4f, 0xcf, 0xdf, 0x96, 0x12,
  0x88, 0x5d, 0xef, 0xdf, 0x96, 0x9f, 0x22, 0xdf,
  0x96, 0x0d, 0x88, 0x5e, 0xef, 0xdf, 0x96, 0x46,
  0x2e, 0x29, 0xdf, 0xdf, 0x96, 0x07, 0x88, 0x5f,
  0xef, 0xdf, 0x96, 0x46, 0x2e, 0x28, 0xdf, 0xdf,
  0x96, 0x01, 0x88, 0x0f, 0x27, 0x05, 0x27, 0xdd,
  0x97, 0x41, 0x2e, 0xad, 0xbf, 0xdd, 0x97, 0x41,
  0x2e, 0xac, 0xbf, 0x44, 0x88, 0x05, 0x27, 0x9f,
  0x22, 0x41, 0x2e, 0xab, 0xbf, 0x10, 0xef, 0xdf,
  0x96, 0x02, 0xef, 0xdf, 0x96, 0xef, 0x8f, 0x2e,
  0x88, 0x0a, 0xef, 0xfc, 0x9f, 0xc1, 0x2e, 0xad,
  0xbf, 0xc1, 0x2e, 0xac, 0xdf, 0x3f, 0x20, 0xc1,
  0x2e, 0xac, 0xbf, 0x30, 0x88
};

static const unsigned char pkt572[] = {
  0x42, 0x9a, 0x00,
  0x03, 0x2b, 0x5f, 0x20, 0xf4,
  0x55, 0x1b, 0xef, 0xdf, 0x96, 0x50, 0xcf, 0xdf,
  0x96, 0xdd, 0x8f, 0x1c, 0xef, 0xdf, 0x96, 0x4f,
  0xcf, 0xdf, 0x96, 0xd8, 0x8f, 0x1d, 0xef, 0xdf,
  0x96, 0x9f, 0x22, 0xdf, 0x96, 0xd3, 0x8f, 0x1e,
  0xef, 0xdf, 0x96, 0x9f, 0x22, 0xdf, 0x96, 0xce,
  0x8f, 0x1f, 0xef, 0xdf, 0x96, 0x01, 0xef, 0xdf,
  0x96, 0xc9, 0x8f, 0x0f, 0x27, 0x05, 0x27, 0x02,
  0xef, 0x06, 0xff, 0x1a, 0x27, 0x05, 0x27, 0x02,
  0xef, 0x06, 0xff, 0x1a, 0x27, 0x05, 0x27, 0xdf,
  0x96, 0xff, 0x96, 0x7b, 0xef, 0x00, 0xff, 0x1b,
  0x27, 0xdd, 0x9f, 0xdd, 0x97, 0x05, 0x27, 0x01,
  0xff, 0xab, 0xef, 0x1b, 0x27, 0x05, 0x27, 0xdf,
  0x96, 0x81, 0xef, 0x41, 0x2e, 0xaf, 0xbf, 0xdd,
  0x97, 0x05, 0x27, 0x3a, 0xef, 0xff, 0xaf, 0xea,
  0x8f, 0x0a, 0xef, 0xfc, 0x9f, 0xff, 0xbf, 0x5f,
  0x20, 0xfb, 0x55, 0x50, 0xcf, 0xff, 0xaf, 0x4f,
  0xcf, 0xff, 0xaf, 0x9f, 0x22, 0xff, 0xaf, 0x46,
  0x2e, 0x29, 0xdf, 0xff, 0xaf, 0x46, 0x2e, 0x28,
  0xdf, 0xff, 0xaf, 0x05, 0x27
};

static const unsigned char pkt576[] = {
  0x42, 0x1a, 0x00,
  0x4f, 0x2b, 0x09, 0x43, 0x04,
  0x5b, 0x00, 0xef, 0xf8, 0xaf, 0x32, 0xef, 0xfa,
  0xaf, 0x03, 0x50, 0x01, 0xef, 0xf8, 0xaf, 0x42,
  0xef, 0xfa, 0xaf, 0x05, 0x27
};

static const unsigned char pkt580[] = {
  0x42, 0x18, 0x00,
  0x5b, 0x2b, 0xd3, 0x45, 0x03,
  0x5a, 0x0f, 0x27, 0xd3, 0x45, 0x00, 0x5a, 0x05,
  0x27, 0xd0, 0x41, 0xf7, 0x5b, 0xc1, 0x83, 0xf5,
  0x50, 0x05, 0x27
};

static const unsigned char pkt584[] = {
  0x42, 0x22, 0x00,
  0x66, 0x2b, 0xc8, 0x46, 0x0c,
  0x5b, 0xd3, 0x45, 0xfd, 0x5a, 0xd3, 0x45, 0xfb,
  0x5a, 0xd3, 0x45, 0xf9, 0x5a, 0x41, 0x2e, 0xa1,
  0xdf, 0x9f, 0x28, 0x41, 0x2e, 0xa1, 0xbf, 0x02,
  0x2e, 0xb0, 0x81, 0x05, 0x27
};

static const unsigned char pkt588[] = {
  0x42, 0x0e, 0x00,
  0x76, 0x2b, 0x00, 0x19, 0xe9,
  0x2f, 0xe3, 0x55, 0xdf, 0x2d, 0xe9, 0x2f, 0xd0,
  0x50
};

static const unsigned char pkt592[] = {
  0x42, 0x0e, 0x00,
  0x7c, 0x2b, 0x00, 0x19, 0xe9,
  0x2f, 0xb5, 0x55, 0xdf, 0x2d, 0xe9, 0x2f, 0xa2,
  0x50
};

static const unsigned char pkt596[] = {
  0x42, 0x0e, 0x00,
  0x82, 0x2b, 0xbf, 0x03, 0xe7,
  0x2f, 0xb2, 0x53, 0xec, 0xcf, 0x01, 0x2e, 0x2d,
  0x73
};

static const unsigned char pkt600[] = {
  0x42, 0x50, 0x00,
  0x88, 0x2b, 0x07, 0x3d, 0x02,
  0x5b, 0x6c, 0x86, 0xc2, 0x23, 0xd3, 0x3c, 0x02,
  0x44, 0xd7, 0x2f, 0x08, 0x5a, 0x02, 0x45, 0xd7,
  0x2f, 0x69, 0x5b, 0x58, 0x23, 0x3c, 0x26, 0x02,
  0x55, 0x02, 0x2e, 0x43, 0x83, 0x01, 0x50, 0x02,
  0x2e, 0x92, 0x83, 0x07, 0x45, 0xea, 0x5a, 0x41,
  0x2e, 0x53, 0xdf, 0xc1, 0x2e, 0x79, 0xdf, 0xff,
  0x96, 0xdf, 0x96, 0x41, 0x2e, 0x55, 0xdf, 0xc1,
  0x2e, 0x78, 0xdf, 0x9d, 0x01, 0x5d, 0x01, 0xff,
  0x22, 0x00, 0x54, 0xff, 0xef, 0x2e, 0xaf, 0xd7,
  0x2f, 0x4d, 0x50
};

static const unsigned char pkt604[] = {
  0x67, 0x05, 0x00, 0x00, 0x02, 0x2e, 0x00, 0x70,
  0x67, 0x05, 0x00, 0x01, 0x02, 0x2e, 0xb8, 0x71,
  0x67, 0x05, 0x00, 0x02, 0x02, 0x2e, 0x35, 0x72,
  0x67, 0x05, 0x00, 0x08, 0x02, 0x2e, 0xbb, 0x72,
  0x67, 0x05, 0x00, 0x07, 0x02, 0x2e, 0x3b, 0x73,
  0x67, 0x05, 0x00, 0x0d, 0x02, 0x2e, 0x38, 0x74,
  0x67, 0x05, 0x00, 0x0b, 0x02, 0x2e, 0x85, 0x74,
  0x67, 0x05, 0x00, 0x0e, 0x02, 0x2e, 0x61, 0x75,
  0x67, 0x05, 0x00, 0x05, 0x02, 0x2e, 0xa6, 0x75,
  0x67, 0x05, 0x00, 0x0c, 0x02, 0x2e, 0x89, 0x78,
  0x67, 0x05, 0x00, 0x09, 0x02, 0x2e, 0xd7, 0x79,
  0x5a, 0x05, 0x00, 0x00, 0x6b, 0x01, 0x4f, 0x2b,
  0x5a, 0x05, 0x00, 0x01, 0x82, 0x09, 0x5b, 0x2b,
  0x5a, 0x05, 0x00, 0x02, 0x78, 0x09, 0x66, 0x2b,
  0x5a, 0x05, 0x00, 0x03, 0x4c, 0x15, 0x76, 0x2b,
  0x5a, 0x05, 0x00, 0x04, 0x24, 0x15, 0x7c, 0x2b,
  0x5a, 0x05, 0x00, 0x05, 0x50, 0x13, 0x82, 0x2b,
  0x5a, 0x05, 0x00, 0x06, 0xe1, 0x02, 0x88, 0x2b,
  0x0d,
  0x42, 0x04, 0x00, 0x88, 0x2b, 0x07, 0x3d
};

struct aesX660_cmd aes1660_init_2[] = {
  { .cmd = pkt433, .len = sizeof (pkt433) },
  { .cmd = pkt440, .len = sizeof (pkt440) },
  { .cmd = pkt444, .len = sizeof (pkt444) },
  { .cmd = pkt448, .len = sizeof (pkt448) },
  { .cmd = pkt452, .len = sizeof (pkt452) },
  { .cmd = pkt456, .len = sizeof (pkt456) },
  { .cmd = pkt460, .len = sizeof (pkt460) },
  { .cmd = pkt464, .len = sizeof (pkt464) },
  { .cmd = pkt468, .len = sizeof (pkt468) },
  { .cmd = pkt472, .len = sizeof (pkt472) },
  { .cmd = pkt476, .len = sizeof (pkt476) },
  { .cmd = pkt480, .len = sizeof (pkt480) },
  { .cmd = pkt484, .len = sizeof (pkt484) },
  { .cmd = pkt488, .len = sizeof (pkt488) },
  { .cmd = pkt492, .len = sizeof (pkt492) },
  { .cmd = pkt496, .len = sizeof (pkt496) },
  { .cmd = pkt500, .len = sizeof (pkt500) },
  { .cmd = pkt504, .len = sizeof (pkt504) },
  { .cmd = pkt508, .len = sizeof (pkt508) },
  { .cmd = pkt512, .len = sizeof (pkt512) },
  { .cmd = pkt516, .len = sizeof (pkt516) },
  { .cmd = pkt520, .len = sizeof (pkt520) },
  { .cmd = pkt524, .len = sizeof (pkt524) },
  { .cmd = pkt528, .len = sizeof (pkt528) },
  { .cmd = pkt532, .len = sizeof (pkt532) },
  { .cmd = pkt536, .len = sizeof (pkt536) },
  { .cmd = pkt540, .len = sizeof (pkt540) },
  { .cmd = pkt544, .len = sizeof (pkt544) },
  { .cmd = pkt548, .len = sizeof (pkt548) },
  { .cmd = pkt552, .len = sizeof (pkt552) },
  { .cmd = pkt556, .len = sizeof (pkt556) },
  { .cmd = pkt560, .len = sizeof (pkt560) },
  { .cmd = pkt564, .len = sizeof (pkt564) },
  { .cmd = pkt568, .len = sizeof (pkt568) },
  { .cmd = pkt572, .len = sizeof (pkt572) },
  { .cmd = pkt576, .len = sizeof (pkt576) },
  { .cmd = pkt580, .len = sizeof (pkt580) },
  { .cmd = pkt584, .len = sizeof (pkt584) },
  { .cmd = pkt588, .len = sizeof (pkt588) },
  { .cmd = pkt592, .len = sizeof (pkt592) },
  { .cmd = pkt596, .len = sizeof (pkt596) },
  { .cmd = pkt600, .len = sizeof (pkt600) },
  { .cmd = pkt604, .len = sizeof (pkt604) },
};
/* INIT2 is over, 0x07 cmd returns
 * { 0x07, 0x05, 0x00, 0x8f, 0x16, 0x25, 0x01, 0x63 }
 */

/* This command sequence starts imaging */
static const unsigned char aes1660_start_imaging_cmd[] = {
  0x13,
  0x20,
  0x4c, 0x01, 0x00, 0x00,
  0x4b, 0x04, 0x00, 0x78, 0x56, 0x34, 0x12,
  0x55, 0x07, 0x00, 0x80, 0x42, 0x00, 0x7f, 0x00, 0x00, 0x14,
  0x49, 0x03, 0x00, 0x20, 0x00, 0xc8
};
