; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 | FileCheck %s --check-prefixes=CHECK,GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=atom -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,ATOM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=slm -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,SLM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,SANDY-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,SANDY-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,HASWELL-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,BROADWELL-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,BROADWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,SKYLAKE-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,SKYLAKE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,SKX-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,SKX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,BTVER2-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 -mattr=-sse3 | FileCheck %s --check-prefixes=CHECK,ZNVER1-SSE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 -mattr=-avx2 | FileCheck %s --check-prefixes=CHECK,ZNVER1

; FIXME: we should really use -mattr=-sse2 here but some of the comparison tests don't work without access to legal <4 x i32> types.

define <4 x float> @test_addps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_addps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    addps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_addps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    addps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_addps:
; SLM:       # %bb.0:
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_addps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    addps (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_addps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_addps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    addps (%rdi), %xmm0 # sched: [9:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_addps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_addps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    addps (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_addps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_addps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    addps (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_addps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_addps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    addps (%rdi), %xmm0 # sched: [10:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_addps:
; SKX:       # %bb.0:
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_addps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    addps (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_addps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_addps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    addps (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_addps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fadd <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fadd <4 x float> %1, %2
  ret <4 x float> %3
}

define float @test_addss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_addss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    addss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_addss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    addss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    addss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_addss:
; SLM:       # %bb.0:
; SLM-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_addss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    addss (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_addss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_addss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    addss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_addss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_addss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    addss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_addss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_addss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    addss (%rdi), %xmm0 # sched: [9:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_addss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_addss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    addss (%rdi), %xmm0 # sched: [9:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_addss:
; SKX:       # %bb.0:
; SKX-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_addss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    addss (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_addss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_addss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    addss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_addss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vaddss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fadd float %a0, %a1
  %2 = load float, float *%a2, align 4
  %3 = fadd float %1, %2
  ret float %3
}

define <4 x float> @test_andps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_andps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    andps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    andps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_andps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    andps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    andps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_andps:
; SLM:       # %bb.0:
; SLM-NEXT:    andps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    andps (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_andps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    andps %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    andps (%rdi), %xmm0 # sched: [7:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_andps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_andps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    andps %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    andps (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_andps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_andps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    andps %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    andps (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_andps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_andps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    andps %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    andps (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_andps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_andps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    andps %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    andps (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_andps:
; SKX:       # %bb.0:
; SKX-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_andps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    andps %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    andps (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_andps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_andps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    andps %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    andps (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_andps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vandps %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vandps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <4 x float> %a0 to <4 x i32>
  %2 = bitcast <4 x float> %a1 to <4 x i32>
  %3 = and <4 x i32> %1, %2
  %4 = load <4 x float>, <4 x float> *%a2, align 16
  %5 = bitcast <4 x float> %4 to <4 x i32>
  %6 = and <4 x i32> %3, %5
  %7 = bitcast <4 x i32> %6 to <4 x float>
  ret <4 x float> %7
}

define <4 x float> @test_andnotps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_andnotps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    andnps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    andnps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_andnotps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    andnps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    andnps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_andnotps:
; SLM:       # %bb.0:
; SLM-NEXT:    andnps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    andnps (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_andnotps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    andnps %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    andnps (%rdi), %xmm0 # sched: [7:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_andnotps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_andnotps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    andnps %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    andnps (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_andnotps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_andnotps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    andnps %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    andnps (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_andnotps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_andnotps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    andnps %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    andnps (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_andnotps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_andnotps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    andnps %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    andnps (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_andnotps:
; SKX:       # %bb.0:
; SKX-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_andnotps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    andnps %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    andnps (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_andnotps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_andnotps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    andnps %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    andnps (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_andnotps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vandnps %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vandnps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <4 x float> %a0 to <4 x i32>
  %2 = bitcast <4 x float> %a1 to <4 x i32>
  %3 = xor <4 x i32> %1, <i32 -1, i32 -1, i32 -1, i32 -1>
  %4 = and <4 x i32> %3, %2
  %5 = load <4 x float>, <4 x float> *%a2, align 16
  %6 = bitcast <4 x float> %5 to <4 x i32>
  %7 = xor <4 x i32> %4, <i32 -1, i32 -1, i32 -1, i32 -1>
  %8 = and <4 x i32> %6, %7
  %9 = bitcast <4 x i32> %8 to <4 x float>
  ret <4 x float> %9
}

define <4 x float> @test_cmpps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_cmpps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [3:1.00]
; GENERIC-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cmpps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cmpps:
; SLM:       # %bb.0:
; SLM-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_cmpps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-SSE-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cmpps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_cmpps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [9:1.00]
; HASWELL-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_cmpps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; HASWELL-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; HASWELL-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_cmpps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cmpps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; BROADWELL-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_cmpps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cmpps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [4:0.50]
; SKYLAKE-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKYLAKE-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_cmpps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [4:0.50]
; SKX-SSE-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [10:0.50]
; SKX-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cmpps:
; SKX:       # %bb.0:
; SKX-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [4:0.50]
; SKX-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKX-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_cmpps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_cmpps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_cmpps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    cmpeqps %xmm0, %xmm1 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    cmpeqps (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_cmpps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcmpeqps %xmm1, %xmm0, %xmm1 # sched: [3:1.00]
; ZNVER1-NEXT:    vcmpeqps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    vorps %xmm0, %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fcmp oeq <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fcmp oeq <4 x float> %a0, %2
  %4 = sext <4 x i1> %1 to <4 x i32>
  %5 = sext <4 x i1> %3 to <4 x i32>
  %6 = or <4 x i32> %4, %5
  %7 = bitcast <4 x i32> %6 to <4 x float>
  ret <4 x float> %7
}

define float @test_cmpss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_cmpss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cmpss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cmpss:
; SLM:       # %bb.0:
; SLM-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_cmpss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cmpss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_cmpss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_cmpss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_cmpss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cmpss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_cmpss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [9:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cmpss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_cmpss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [9:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cmpss:
; SKX:       # %bb.0:
; SKX-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_cmpss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_cmpss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_cmpss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    cmpeqss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    cmpeqss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_cmpss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcmpeqss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vcmpeqss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = insertelement <4 x float> undef, float %a1, i32 0
  %3 = call <4 x float> @llvm.x86.sse.cmp.ss(<4 x float> %1, <4 x float> %2, i8 0)
  %4 = load float, float *%a2, align 4
  %5 = insertelement <4 x float> undef, float %4, i32 0
  %6 = call <4 x float> @llvm.x86.sse.cmp.ss(<4 x float> %3, <4 x float> %5, i8 0)
  %7 = extractelement <4 x float> %6, i32 0
  ret float %7
}
declare <4 x float> @llvm.x86.sse.cmp.ss(<4 x float>, <4 x float>, i8) nounwind readnone

define i32 @test_comiss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_comiss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    comiss %xmm1, %xmm0 # sched: [2:1.00]
; GENERIC-NEXT:    setnp %al # sched: [1:0.50]
; GENERIC-NEXT:    sete %cl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %cl # sched: [1:0.33]
; GENERIC-NEXT:    comiss (%rdi), %xmm0 # sched: [8:1.00]
; GENERIC-NEXT:    setnp %al # sched: [1:0.50]
; GENERIC-NEXT:    sete %dl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %dl # sched: [1:0.33]
; GENERIC-NEXT:    orb %cl, %dl # sched: [1:0.33]
; GENERIC-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_comiss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    comiss %xmm1, %xmm0 # sched: [9:4.50]
; ATOM-NEXT:    setnp %al # sched: [1:0.50]
; ATOM-NEXT:    sete %cl # sched: [1:0.50]
; ATOM-NEXT:    andb %al, %cl # sched: [1:0.50]
; ATOM-NEXT:    comiss (%rdi), %xmm0 # sched: [10:5.00]
; ATOM-NEXT:    setnp %al # sched: [1:0.50]
; ATOM-NEXT:    sete %dl # sched: [1:0.50]
; ATOM-NEXT:    andb %al, %dl # sched: [1:0.50]
; ATOM-NEXT:    orb %cl, %dl # sched: [1:0.50]
; ATOM-NEXT:    movzbl %dl, %eax # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_comiss:
; SLM:       # %bb.0:
; SLM-NEXT:    comiss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    setnp %al # sched: [1:0.50]
; SLM-NEXT:    sete %cl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %cl # sched: [1:0.50]
; SLM-NEXT:    comiss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    setnp %al # sched: [1:0.50]
; SLM-NEXT:    sete %dl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %dl # sched: [1:0.50]
; SLM-NEXT:    orb %cl, %dl # sched: [1:0.50]
; SLM-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_comiss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    comiss %xmm1, %xmm0 # sched: [2:1.00]
; SANDY-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-SSE-NEXT:    sete %cl # sched: [1:0.50]
; SANDY-SSE-NEXT:    andb %al, %cl # sched: [1:0.33]
; SANDY-SSE-NEXT:    comiss (%rdi), %xmm0 # sched: [8:1.00]
; SANDY-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-SSE-NEXT:    sete %dl # sched: [1:0.50]
; SANDY-SSE-NEXT:    andb %al, %dl # sched: [1:0.33]
; SANDY-SSE-NEXT:    orb %cl, %dl # sched: [1:0.33]
; SANDY-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_comiss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcomiss %xmm1, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-NEXT:    sete %cl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %cl # sched: [1:0.33]
; SANDY-NEXT:    vcomiss (%rdi), %xmm0 # sched: [8:1.00]
; SANDY-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-NEXT:    sete %dl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %dl # sched: [1:0.33]
; SANDY-NEXT:    orb %cl, %dl # sched: [1:0.33]
; SANDY-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_comiss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    comiss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-SSE-NEXT:    sete %cl # sched: [1:0.50]
; HASWELL-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; HASWELL-SSE-NEXT:    comiss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-SSE-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-SSE-NEXT:    sete %dl # sched: [1:0.50]
; HASWELL-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; HASWELL-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; HASWELL-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_comiss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcomiss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-NEXT:    sete %cl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %cl # sched: [1:0.25]
; HASWELL-NEXT:    vcomiss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-NEXT:    sete %dl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %dl # sched: [1:0.25]
; HASWELL-NEXT:    orb %cl, %dl # sched: [1:0.25]
; HASWELL-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_comiss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    comiss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    setnp %al # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    sete %cl # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    comiss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    setnp %al # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    sete %dl # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_comiss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcomiss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    setnp %al # sched: [1:0.50]
; BROADWELL-NEXT:    sete %cl # sched: [1:0.50]
; BROADWELL-NEXT:    andb %al, %cl # sched: [1:0.25]
; BROADWELL-NEXT:    vcomiss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    setnp %al # sched: [1:0.50]
; BROADWELL-NEXT:    sete %dl # sched: [1:0.50]
; BROADWELL-NEXT:    andb %al, %dl # sched: [1:0.25]
; BROADWELL-NEXT:    orb %cl, %dl # sched: [1:0.25]
; BROADWELL-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_comiss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    comiss %xmm1, %xmm0 # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    sete %cl # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    comiss (%rdi), %xmm0 # sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    sete %dl # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_comiss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcomiss %xmm1, %xmm0 # sched: [2:1.00]
; SKYLAKE-NEXT:    setnp %al # sched: [1:0.50]
; SKYLAKE-NEXT:    sete %cl # sched: [1:0.50]
; SKYLAKE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKYLAKE-NEXT:    vcomiss (%rdi), %xmm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    setnp %al # sched: [1:0.50]
; SKYLAKE-NEXT:    sete %dl # sched: [1:0.50]
; SKYLAKE-NEXT:    andb %al, %dl # sched: [1:0.25]
; SKYLAKE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; SKYLAKE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_comiss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    comiss %xmm1, %xmm0 # sched: [2:1.00]
; SKX-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SKX-SSE-NEXT:    sete %cl # sched: [1:0.50]
; SKX-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKX-SSE-NEXT:    comiss (%rdi), %xmm0 # sched: [7:1.00]
; SKX-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SKX-SSE-NEXT:    sete %dl # sched: [1:0.50]
; SKX-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; SKX-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; SKX-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_comiss:
; SKX:       # %bb.0:
; SKX-NEXT:    vcomiss %xmm1, %xmm0 # sched: [2:1.00]
; SKX-NEXT:    setnp %al # sched: [1:0.50]
; SKX-NEXT:    sete %cl # sched: [1:0.50]
; SKX-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKX-NEXT:    vcomiss (%rdi), %xmm0 # sched: [7:1.00]
; SKX-NEXT:    setnp %al # sched: [1:0.50]
; SKX-NEXT:    sete %dl # sched: [1:0.50]
; SKX-NEXT:    andb %al, %dl # sched: [1:0.25]
; SKX-NEXT:    orb %cl, %dl # sched: [1:0.25]
; SKX-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_comiss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    comiss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-SSE-NEXT:    sete %cl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    andb %al, %cl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    comiss (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-SSE-NEXT:    sete %dl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    andb %al, %dl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    orb %cl, %dl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_comiss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcomiss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-NEXT:    sete %cl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %cl # sched: [1:0.50]
; BTVER2-NEXT:    vcomiss (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-NEXT:    sete %dl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %dl # sched: [1:0.50]
; BTVER2-NEXT:    orb %cl, %dl # sched: [1:0.50]
; BTVER2-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_comiss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    comiss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    sete %cl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    comiss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    sete %dl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_comiss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcomiss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-NEXT:    sete %cl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %cl # sched: [1:0.25]
; ZNVER1-NEXT:    vcomiss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-NEXT:    sete %dl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %dl # sched: [1:0.25]
; ZNVER1-NEXT:    orb %cl, %dl # sched: [1:0.25]
; ZNVER1-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse.comieq.ss(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 4
  %3 = call i32 @llvm.x86.sse.comieq.ss(<4 x float> %a0, <4 x float> %2)
  %4 = or i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.sse.comieq.ss(<4 x float>, <4 x float>) nounwind readnone

define float @test_cvtsi2ss(i32 %a0, i32 *%a1) {
; GENERIC-LABEL: test_cvtsi2ss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [5:2.00]
; GENERIC-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [10:1.00]
; GENERIC-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtsi2ss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [7:3.50]
; ATOM-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [6:3.00]
; ATOM-NEXT:    addss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtsi2ss:
; SLM:       # %bb.0:
; SLM-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [7:1.00]
; SLM-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [4:0.50]
; SLM-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_cvtsi2ss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [5:2.00]
; SANDY-SSE-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [10:1.00]
; SANDY-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtsi2ss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [5:2.00]
; SANDY-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [10:1.00]
; SANDY-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_cvtsi2ss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [4:1.00]
; HASWELL-SSE-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [9:1.00]
; HASWELL-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_cvtsi2ss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [4:1.00]
; HASWELL-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [9:1.00]
; HASWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_cvtsi2ss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [4:1.00]
; BROADWELL-SSE-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [9:1.00]
; BROADWELL-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtsi2ss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [4:1.00]
; BROADWELL-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [9:1.00]
; BROADWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_cvtsi2ss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [5:1.00]
; SKYLAKE-SSE-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [9:1.00]
; SKYLAKE-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtsi2ss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [5:1.00]
; SKYLAKE-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [9:1.00]
; SKYLAKE-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_cvtsi2ss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [5:1.00]
; SKX-SSE-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [9:1.00]
; SKX-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtsi2ss:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [5:1.00]
; SKX-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [9:1.00]
; SKX-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_cvtsi2ss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [14:1.00]
; BTVER2-SSE-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [9:1.00]
; BTVER2-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_cvtsi2ss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [9:1.00]
; BTVER2-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [14:1.00]
; BTVER2-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_cvtsi2ss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    cvtsi2ssl (%rsi), %xmm0 # sched: [12:1.00]
; ZNVER1-SSE-NEXT:    cvtsi2ssl %edi, %xmm1 # sched: [5:1.00]
; ZNVER1-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_cvtsi2ss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtsi2ssl %edi, %xmm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vcvtsi2ssl (%rsi), %xmm1, %xmm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = sitofp i32 %a0 to float
  %2 = load i32, i32 *%a1, align 4
  %3 = sitofp i32 %2 to float
  %4 = fadd float %1, %3
  ret float %4
}

define float @test_cvtsi2ssq(i64 %a0, i64 *%a1) {
; GENERIC-LABEL: test_cvtsi2ssq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [5:2.00]
; GENERIC-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [10:1.00]
; GENERIC-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtsi2ssq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [7:3.50]
; ATOM-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [6:3.00]
; ATOM-NEXT:    addss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtsi2ssq:
; SLM:       # %bb.0:
; SLM-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [7:1.00]
; SLM-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [4:0.50]
; SLM-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_cvtsi2ssq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [5:2.00]
; SANDY-SSE-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [10:1.00]
; SANDY-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtsi2ssq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [5:2.00]
; SANDY-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [10:1.00]
; SANDY-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_cvtsi2ssq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [5:2.00]
; HASWELL-SSE-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [9:1.00]
; HASWELL-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_cvtsi2ssq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [5:2.00]
; HASWELL-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [9:1.00]
; HASWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_cvtsi2ssq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [5:2.00]
; BROADWELL-SSE-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [9:1.00]
; BROADWELL-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtsi2ssq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [5:2.00]
; BROADWELL-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [9:1.00]
; BROADWELL-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_cvtsi2ssq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [6:2.00]
; SKYLAKE-SSE-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [9:1.00]
; SKYLAKE-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtsi2ssq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [6:2.00]
; SKYLAKE-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [9:1.00]
; SKYLAKE-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_cvtsi2ssq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [6:2.00]
; SKX-SSE-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [9:1.00]
; SKX-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtsi2ssq:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [6:2.00]
; SKX-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [9:1.00]
; SKX-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_cvtsi2ssq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [14:1.00]
; BTVER2-SSE-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [9:1.00]
; BTVER2-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_cvtsi2ssq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [9:1.00]
; BTVER2-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [14:1.00]
; BTVER2-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_cvtsi2ssq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    cvtsi2ssq (%rsi), %xmm0 # sched: [12:1.00]
; ZNVER1-SSE-NEXT:    cvtsi2ssq %rdi, %xmm1 # sched: [5:1.00]
; ZNVER1-SSE-NEXT:    addss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_cvtsi2ssq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtsi2ssq %rdi, %xmm0, %xmm0 # sched: [5:1.00]
; ZNVER1-NEXT:    vcvtsi2ssq (%rsi), %xmm1, %xmm1 # sched: [12:1.00]
; ZNVER1-NEXT:    vaddss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = sitofp i64 %a0 to float
  %2 = load i64, i64 *%a1, align 8
  %3 = sitofp i64 %2 to float
  %4 = fadd float %1, %3
  ret float %4
}

define i32 @test_cvtss2si(float %a0, float *%a1) {
; GENERIC-LABEL: test_cvtss2si:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvtss2si %xmm0, %ecx # sched: [5:1.00]
; GENERIC-NEXT:    cvtss2si (%rdi), %eax # sched: [9:1.00]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtss2si:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvtss2si (%rdi), %eax # sched: [9:4.50]
; ATOM-NEXT:    cvtss2si %xmm0, %ecx # sched: [8:4.00]
; ATOM-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtss2si:
; SLM:       # %bb.0:
; SLM-NEXT:    cvtss2si (%rdi), %eax # sched: [7:1.00]
; SLM-NEXT:    cvtss2si %xmm0, %ecx # sched: [4:0.50]
; SLM-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_cvtss2si:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    cvtss2si %xmm0, %ecx # sched: [5:1.00]
; SANDY-SSE-NEXT:    cvtss2si (%rdi), %eax # sched: [9:1.00]
; SANDY-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtss2si:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtss2si %xmm0, %ecx # sched: [5:1.00]
; SANDY-NEXT:    vcvtss2si (%rdi), %eax # sched: [10:1.00]
; SANDY-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_cvtss2si:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    cvtss2si %xmm0, %ecx # sched: [4:1.00]
; HASWELL-SSE-NEXT:    cvtss2si (%rdi), %eax # sched: [9:1.00]
; HASWELL-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_cvtss2si:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtss2si %xmm0, %ecx # sched: [4:1.00]
; HASWELL-NEXT:    vcvtss2si (%rdi), %eax # sched: [9:1.00]
; HASWELL-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_cvtss2si:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    cvtss2si (%rdi), %eax # sched: [9:1.00]
; BROADWELL-SSE-NEXT:    cvtss2si %xmm0, %ecx # sched: [4:1.00]
; BROADWELL-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtss2si:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtss2si (%rdi), %eax # sched: [9:1.00]
; BROADWELL-NEXT:    vcvtss2si %xmm0, %ecx # sched: [4:1.00]
; BROADWELL-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_cvtss2si:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    cvtss2si %xmm0, %ecx # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    cvtss2si (%rdi), %eax # sched: [11:1.00]
; SKYLAKE-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtss2si:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtss2si %xmm0, %ecx # sched: [6:1.00]
; SKYLAKE-NEXT:    vcvtss2si (%rdi), %eax # sched: [11:1.00]
; SKYLAKE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_cvtss2si:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    cvtss2si %xmm0, %ecx # sched: [6:1.00]
; SKX-SSE-NEXT:    cvtss2si (%rdi), %eax # sched: [11:1.00]
; SKX-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtss2si:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtss2si %xmm0, %ecx # sched: [6:1.00]
; SKX-NEXT:    vcvtss2si (%rdi), %eax # sched: [11:1.00]
; SKX-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_cvtss2si:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    cvtss2si (%rdi), %eax # sched: [12:1.00]
; BTVER2-SSE-NEXT:    cvtss2si %xmm0, %ecx # sched: [7:1.00]
; BTVER2-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_cvtss2si:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtss2si (%rdi), %eax # sched: [12:1.00]
; BTVER2-NEXT:    vcvtss2si %xmm0, %ecx # sched: [7:1.00]
; BTVER2-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_cvtss2si:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    cvtss2si (%rdi), %eax # sched: [12:1.00]
; ZNVER1-SSE-NEXT:    cvtss2si %xmm0, %ecx # sched: [5:1.00]
; ZNVER1-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_cvtss2si:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtss2si (%rdi), %eax # sched: [12:1.00]
; ZNVER1-NEXT:    vcvtss2si %xmm0, %ecx # sched: [5:1.00]
; ZNVER1-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = call i32 @llvm.x86.sse.cvtss2si(<4 x float> %1)
  %3 = load float, float *%a1, align 4
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = call i32 @llvm.x86.sse.cvtss2si(<4 x float> %4)
  %6 = add i32 %2, %5
  ret i32 %6
}
declare i32 @llvm.x86.sse.cvtss2si(<4 x float>) nounwind readnone

define i64 @test_cvtss2siq(float %a0, float *%a1) {
; GENERIC-LABEL: test_cvtss2siq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvtss2si %xmm0, %rcx # sched: [5:1.00]
; GENERIC-NEXT:    cvtss2si (%rdi), %rax # sched: [9:1.00]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvtss2siq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvtss2si (%rdi), %rax # sched: [10:5.00]
; ATOM-NEXT:    cvtss2si %xmm0, %rcx # sched: [9:4.50]
; ATOM-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvtss2siq:
; SLM:       # %bb.0:
; SLM-NEXT:    cvtss2si (%rdi), %rax # sched: [7:1.00]
; SLM-NEXT:    cvtss2si %xmm0, %rcx # sched: [4:0.50]
; SLM-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_cvtss2siq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    cvtss2si %xmm0, %rcx # sched: [5:1.00]
; SANDY-SSE-NEXT:    cvtss2si (%rdi), %rax # sched: [9:1.00]
; SANDY-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvtss2siq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvtss2si %xmm0, %rcx # sched: [5:1.00]
; SANDY-NEXT:    vcvtss2si (%rdi), %rax # sched: [10:1.00]
; SANDY-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_cvtss2siq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    cvtss2si %xmm0, %rcx # sched: [4:1.00]
; HASWELL-SSE-NEXT:    cvtss2si (%rdi), %rax # sched: [9:1.00]
; HASWELL-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_cvtss2siq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvtss2si %xmm0, %rcx # sched: [4:1.00]
; HASWELL-NEXT:    vcvtss2si (%rdi), %rax # sched: [9:1.00]
; HASWELL-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_cvtss2siq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    cvtss2si (%rdi), %rax # sched: [9:1.00]
; BROADWELL-SSE-NEXT:    cvtss2si %xmm0, %rcx # sched: [4:1.00]
; BROADWELL-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvtss2siq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvtss2si (%rdi), %rax # sched: [9:1.00]
; BROADWELL-NEXT:    vcvtss2si %xmm0, %rcx # sched: [4:1.00]
; BROADWELL-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_cvtss2siq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    cvtss2si %xmm0, %rcx # sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    cvtss2si (%rdi), %rax # sched: [11:1.00]
; SKYLAKE-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvtss2siq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvtss2si %xmm0, %rcx # sched: [6:1.00]
; SKYLAKE-NEXT:    vcvtss2si (%rdi), %rax # sched: [11:1.00]
; SKYLAKE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_cvtss2siq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    cvtss2si %xmm0, %rcx # sched: [7:1.00]
; SKX-SSE-NEXT:    cvtss2si (%rdi), %rax # sched: [11:1.00]
; SKX-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvtss2siq:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvtss2si %xmm0, %rcx # sched: [7:1.00]
; SKX-NEXT:    vcvtss2si (%rdi), %rax # sched: [11:1.00]
; SKX-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_cvtss2siq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    cvtss2si (%rdi), %rax # sched: [12:1.00]
; BTVER2-SSE-NEXT:    cvtss2si %xmm0, %rcx # sched: [7:1.00]
; BTVER2-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_cvtss2siq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvtss2si (%rdi), %rax # sched: [12:1.00]
; BTVER2-NEXT:    vcvtss2si %xmm0, %rcx # sched: [7:1.00]
; BTVER2-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_cvtss2siq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    cvtss2si (%rdi), %rax # sched: [12:1.00]
; ZNVER1-SSE-NEXT:    cvtss2si %xmm0, %rcx # sched: [5:1.00]
; ZNVER1-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_cvtss2siq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvtss2si (%rdi), %rax # sched: [12:1.00]
; ZNVER1-NEXT:    vcvtss2si %xmm0, %rcx # sched: [5:1.00]
; ZNVER1-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = call i64 @llvm.x86.sse.cvtss2si64(<4 x float> %1)
  %3 = load float, float *%a1, align 4
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = call i64 @llvm.x86.sse.cvtss2si64(<4 x float> %4)
  %6 = add i64 %2, %5
  ret i64 %6
}
declare i64 @llvm.x86.sse.cvtss2si64(<4 x float>) nounwind readnone

define i32 @test_cvttss2si(float %a0, float *%a1) {
; GENERIC-LABEL: test_cvttss2si:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvttss2si %xmm0, %ecx # sched: [5:1.00]
; GENERIC-NEXT:    cvttss2si (%rdi), %eax # sched: [9:1.00]
; GENERIC-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvttss2si:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvttss2si (%rdi), %eax # sched: [9:4.50]
; ATOM-NEXT:    cvttss2si %xmm0, %ecx # sched: [8:4.00]
; ATOM-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvttss2si:
; SLM:       # %bb.0:
; SLM-NEXT:    cvttss2si (%rdi), %eax # sched: [7:1.00]
; SLM-NEXT:    cvttss2si %xmm0, %ecx # sched: [4:0.50]
; SLM-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_cvttss2si:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    cvttss2si %xmm0, %ecx # sched: [5:1.00]
; SANDY-SSE-NEXT:    cvttss2si (%rdi), %eax # sched: [9:1.00]
; SANDY-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvttss2si:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvttss2si %xmm0, %ecx # sched: [5:1.00]
; SANDY-NEXT:    vcvttss2si (%rdi), %eax # sched: [10:1.00]
; SANDY-NEXT:    addl %ecx, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_cvttss2si:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    cvttss2si %xmm0, %ecx # sched: [4:1.00]
; HASWELL-SSE-NEXT:    cvttss2si (%rdi), %eax # sched: [9:1.00]
; HASWELL-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_cvttss2si:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvttss2si %xmm0, %ecx # sched: [4:1.00]
; HASWELL-NEXT:    vcvttss2si (%rdi), %eax # sched: [9:1.00]
; HASWELL-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_cvttss2si:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    cvttss2si (%rdi), %eax # sched: [9:1.00]
; BROADWELL-SSE-NEXT:    cvttss2si %xmm0, %ecx # sched: [4:1.00]
; BROADWELL-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvttss2si:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvttss2si (%rdi), %eax # sched: [9:1.00]
; BROADWELL-NEXT:    vcvttss2si %xmm0, %ecx # sched: [4:1.00]
; BROADWELL-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_cvttss2si:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    cvttss2si %xmm0, %ecx # sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    cvttss2si (%rdi), %eax # sched: [11:1.00]
; SKYLAKE-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvttss2si:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvttss2si %xmm0, %ecx # sched: [7:1.00]
; SKYLAKE-NEXT:    vcvttss2si (%rdi), %eax # sched: [11:1.00]
; SKYLAKE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_cvttss2si:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    cvttss2si %xmm0, %ecx # sched: [6:1.00]
; SKX-SSE-NEXT:    cvttss2si (%rdi), %eax # sched: [11:1.00]
; SKX-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvttss2si:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvttss2si %xmm0, %ecx # sched: [6:1.00]
; SKX-NEXT:    vcvttss2si (%rdi), %eax # sched: [11:1.00]
; SKX-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_cvttss2si:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    cvttss2si (%rdi), %eax # sched: [12:1.00]
; BTVER2-SSE-NEXT:    cvttss2si %xmm0, %ecx # sched: [7:1.00]
; BTVER2-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_cvttss2si:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvttss2si (%rdi), %eax # sched: [12:1.00]
; BTVER2-NEXT:    vcvttss2si %xmm0, %ecx # sched: [7:1.00]
; BTVER2-NEXT:    addl %ecx, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_cvttss2si:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    cvttss2si (%rdi), %eax # sched: [12:1.00]
; ZNVER1-SSE-NEXT:    cvttss2si %xmm0, %ecx # sched: [5:1.00]
; ZNVER1-SSE-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_cvttss2si:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvttss2si (%rdi), %eax # sched: [12:1.00]
; ZNVER1-NEXT:    vcvttss2si %xmm0, %ecx # sched: [5:1.00]
; ZNVER1-NEXT:    addl %ecx, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fptosi float %a0 to i32
  %2 = load float, float *%a1, align 4
  %3 = fptosi float %2 to i32
  %4 = add i32 %1, %3
  ret i32 %4
}

define i64 @test_cvttss2siq(float %a0, float *%a1) {
; GENERIC-LABEL: test_cvttss2siq:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    cvttss2si %xmm0, %rcx # sched: [5:1.00]
; GENERIC-NEXT:    cvttss2si (%rdi), %rax # sched: [9:1.00]
; GENERIC-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cvttss2siq:
; ATOM:       # %bb.0:
; ATOM-NEXT:    cvttss2si (%rdi), %rax # sched: [10:5.00]
; ATOM-NEXT:    cvttss2si %xmm0, %rcx # sched: [9:4.50]
; ATOM-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cvttss2siq:
; SLM:       # %bb.0:
; SLM-NEXT:    cvttss2si (%rdi), %rax # sched: [7:1.00]
; SLM-NEXT:    cvttss2si %xmm0, %rcx # sched: [4:0.50]
; SLM-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_cvttss2siq:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    cvttss2si %xmm0, %rcx # sched: [5:1.00]
; SANDY-SSE-NEXT:    cvttss2si (%rdi), %rax # sched: [9:1.00]
; SANDY-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_cvttss2siq:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vcvttss2si %xmm0, %rcx # sched: [5:1.00]
; SANDY-NEXT:    vcvttss2si (%rdi), %rax # sched: [10:1.00]
; SANDY-NEXT:    addq %rcx, %rax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_cvttss2siq:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    cvttss2si (%rdi), %rax # sched: [10:1.00]
; HASWELL-SSE-NEXT:    cvttss2si %xmm0, %rcx # sched: [4:1.00]
; HASWELL-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_cvttss2siq:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vcvttss2si %xmm0, %rcx # sched: [4:1.00]
; HASWELL-NEXT:    vcvttss2si (%rdi), %rax # sched: [9:1.00]
; HASWELL-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_cvttss2siq:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    cvttss2si (%rdi), %rax # sched: [10:1.00]
; BROADWELL-SSE-NEXT:    cvttss2si %xmm0, %rcx # sched: [4:1.00]
; BROADWELL-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cvttss2siq:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vcvttss2si (%rdi), %rax # sched: [9:1.00]
; BROADWELL-NEXT:    vcvttss2si %xmm0, %rcx # sched: [4:1.00]
; BROADWELL-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_cvttss2siq:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    cvttss2si %xmm0, %rcx # sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    cvttss2si (%rdi), %rax # sched: [12:1.00]
; SKYLAKE-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cvttss2siq:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vcvttss2si %xmm0, %rcx # sched: [7:1.00]
; SKYLAKE-NEXT:    vcvttss2si (%rdi), %rax # sched: [11:1.00]
; SKYLAKE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_cvttss2siq:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    cvttss2si %xmm0, %rcx # sched: [7:1.00]
; SKX-SSE-NEXT:    cvttss2si (%rdi), %rax # sched: [12:1.00]
; SKX-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cvttss2siq:
; SKX:       # %bb.0:
; SKX-NEXT:    vcvttss2si %xmm0, %rcx # sched: [7:1.00]
; SKX-NEXT:    vcvttss2si (%rdi), %rax # sched: [11:1.00]
; SKX-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_cvttss2siq:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    cvttss2si (%rdi), %rax # sched: [12:1.00]
; BTVER2-SSE-NEXT:    cvttss2si %xmm0, %rcx # sched: [7:1.00]
; BTVER2-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_cvttss2siq:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vcvttss2si (%rdi), %rax # sched: [12:1.00]
; BTVER2-NEXT:    vcvttss2si %xmm0, %rcx # sched: [7:1.00]
; BTVER2-NEXT:    addq %rcx, %rax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_cvttss2siq:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    cvttss2si (%rdi), %rax # sched: [12:1.00]
; ZNVER1-SSE-NEXT:    cvttss2si %xmm0, %rcx # sched: [5:1.00]
; ZNVER1-SSE-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_cvttss2siq:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vcvttss2si (%rdi), %rax # sched: [12:1.00]
; ZNVER1-NEXT:    vcvttss2si %xmm0, %rcx # sched: [5:1.00]
; ZNVER1-NEXT:    addq %rcx, %rax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fptosi float %a0 to i64
  %2 = load float, float *%a1, align 4
  %3 = fptosi float %2 to i64
  %4 = add i64 %1, %3
  ret i64 %4
}

define <4 x float> @test_divps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_divps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    divps %xmm1, %xmm0 # sched: [14:14.00]
; GENERIC-NEXT:    divps (%rdi), %xmm0 # sched: [20:14.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_divps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    divps %xmm1, %xmm0 # sched: [70:35.00]
; ATOM-NEXT:    divps (%rdi), %xmm0 # sched: [70:35.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_divps:
; SLM:       # %bb.0:
; SLM-NEXT:    divps %xmm1, %xmm0 # sched: [39:39.00]
; SLM-NEXT:    divps (%rdi), %xmm0 # sched: [42:39.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_divps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    divps %xmm1, %xmm0 # sched: [14:14.00]
; SANDY-SSE-NEXT:    divps (%rdi), %xmm0 # sched: [20:14.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_divps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [14:14.00]
; SANDY-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [20:14.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_divps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    divps %xmm1, %xmm0 # sched: [13:7.00]
; HASWELL-SSE-NEXT:    divps (%rdi), %xmm0 # sched: [19:7.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_divps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [13:7.00]
; HASWELL-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [19:7.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_divps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    divps %xmm1, %xmm0 # sched: [11:5.00]
; BROADWELL-SSE-NEXT:    divps (%rdi), %xmm0 # sched: [16:5.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_divps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [11:5.00]
; BROADWELL-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [16:5.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_divps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    divps %xmm1, %xmm0 # sched: [11:3.00]
; SKYLAKE-SSE-NEXT:    divps (%rdi), %xmm0 # sched: [17:5.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_divps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [11:3.00]
; SKYLAKE-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [17:5.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_divps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    divps %xmm1, %xmm0 # sched: [11:3.00]
; SKX-SSE-NEXT:    divps (%rdi), %xmm0 # sched: [17:5.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_divps:
; SKX:       # %bb.0:
; SKX-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [11:3.00]
; SKX-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [17:5.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_divps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    divps %xmm1, %xmm0 # sched: [19:19.00]
; BTVER2-SSE-NEXT:    divps (%rdi), %xmm0 # sched: [24:19.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_divps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [19:19.00]
; BTVER2-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [24:19.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_divps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    divps %xmm1, %xmm0 # sched: [15:1.00]
; ZNVER1-SSE-NEXT:    divps (%rdi), %xmm0 # sched: [22:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_divps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vdivps %xmm1, %xmm0, %xmm0 # sched: [15:1.00]
; ZNVER1-NEXT:    vdivps (%rdi), %xmm0, %xmm0 # sched: [22:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fdiv <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fdiv <4 x float> %1, %2
  ret <4 x float> %3
}

define float @test_divss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_divss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    divss %xmm1, %xmm0 # sched: [14:14.00]
; GENERIC-NEXT:    divss (%rdi), %xmm0 # sched: [20:14.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_divss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    divss %xmm1, %xmm0 # sched: [34:17.00]
; ATOM-NEXT:    divss (%rdi), %xmm0 # sched: [34:17.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_divss:
; SLM:       # %bb.0:
; SLM-NEXT:    divss %xmm1, %xmm0 # sched: [19:17.00]
; SLM-NEXT:    divss (%rdi), %xmm0 # sched: [22:17.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_divss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    divss %xmm1, %xmm0 # sched: [14:14.00]
; SANDY-SSE-NEXT:    divss (%rdi), %xmm0 # sched: [20:14.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_divss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [14:14.00]
; SANDY-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [20:14.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_divss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    divss %xmm1, %xmm0 # sched: [13:7.00]
; HASWELL-SSE-NEXT:    divss (%rdi), %xmm0 # sched: [18:7.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_divss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [13:7.00]
; HASWELL-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [18:7.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_divss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    divss %xmm1, %xmm0 # sched: [11:3.00]
; BROADWELL-SSE-NEXT:    divss (%rdi), %xmm0 # sched: [16:5.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_divss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [11:3.00]
; BROADWELL-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [16:5.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_divss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    divss %xmm1, %xmm0 # sched: [11:3.00]
; SKYLAKE-SSE-NEXT:    divss (%rdi), %xmm0 # sched: [16:3.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_divss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [11:3.00]
; SKYLAKE-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [16:3.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_divss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    divss %xmm1, %xmm0 # sched: [11:3.00]
; SKX-SSE-NEXT:    divss (%rdi), %xmm0 # sched: [16:3.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_divss:
; SKX:       # %bb.0:
; SKX-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [11:3.00]
; SKX-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [16:3.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_divss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    divss %xmm1, %xmm0 # sched: [19:19.00]
; BTVER2-SSE-NEXT:    divss (%rdi), %xmm0 # sched: [24:19.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_divss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [19:19.00]
; BTVER2-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [24:19.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_divss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    divss %xmm1, %xmm0 # sched: [15:1.00]
; ZNVER1-SSE-NEXT:    divss (%rdi), %xmm0 # sched: [22:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_divss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vdivss %xmm1, %xmm0, %xmm0 # sched: [15:1.00]
; ZNVER1-NEXT:    vdivss (%rdi), %xmm0, %xmm0 # sched: [22:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fdiv float %a0, %a1
  %2 = load float, float *%a2, align 4
  %3 = fdiv float %1, %2
  ret float %3
}

define void @test_ldmxcsr(i32 %a0) {
; GENERIC-LABEL: test_ldmxcsr:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; GENERIC-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_ldmxcsr:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; ATOM-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:2.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_ldmxcsr:
; SLM:       # %bb.0:
; SLM-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SLM-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_ldmxcsr:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SANDY-SSE-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_ldmxcsr:
; SANDY:       # %bb.0:
; SANDY-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SANDY-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_ldmxcsr:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; HASWELL-SSE-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_ldmxcsr:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; HASWELL-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_ldmxcsr:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_ldmxcsr:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BROADWELL-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_ldmxcsr:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_ldmxcsr:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SKYLAKE-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_ldmxcsr:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SKX-SSE-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_ldmxcsr:
; SKX:       # %bb.0:
; SKX-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SKX-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [7:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_ldmxcsr:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BTVER2-SSE-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_ldmxcsr:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BTVER2-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_ldmxcsr:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    ldmxcsr -{{[0-9]+}}(%rsp) # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_ldmxcsr:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    movl %edi, -{{[0-9]+}}(%rsp) # sched: [1:0.50]
; ZNVER1-NEXT:    vldmxcsr -{{[0-9]+}}(%rsp) # sched: [100:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = alloca i32, align 4
  %2 = bitcast i32* %1 to i8*
  store i32 %a0, i32* %1
  call void @llvm.x86.sse.ldmxcsr(i8* %2)
  ret void
}
declare void @llvm.x86.sse.ldmxcsr(i8*) nounwind readnone

define <4 x float> @test_maxps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_maxps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    maxps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    maxps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_maxps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    maxps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    maxps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_maxps:
; SLM:       # %bb.0:
; SLM-NEXT:    maxps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    maxps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_maxps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    maxps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    maxps (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_maxps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_maxps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    maxps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    maxps (%rdi), %xmm0 # sched: [9:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_maxps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_maxps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    maxps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    maxps (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maxps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_maxps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    maxps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    maxps (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maxps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_maxps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    maxps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    maxps (%rdi), %xmm0 # sched: [10:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maxps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_maxps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    maxps %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    maxps (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_maxps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_maxps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    maxps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    maxps (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_maxps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmaxps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmaxps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse.max.ps(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse.max.ps(<4 x float>, <4 x float>) nounwind readnone

define <4 x float> @test_maxss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_maxss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    maxss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    maxss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_maxss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    maxss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    maxss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_maxss:
; SLM:       # %bb.0:
; SLM-NEXT:    maxss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    maxss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_maxss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    maxss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    maxss (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_maxss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_maxss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    maxss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    maxss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_maxss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_maxss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    maxss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    maxss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_maxss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_maxss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    maxss %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    maxss (%rdi), %xmm0 # sched: [9:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_maxss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_maxss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    maxss %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    maxss (%rdi), %xmm0 # sched: [9:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_maxss:
; SKX:       # %bb.0:
; SKX-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_maxss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    maxss %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    maxss (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_maxss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_maxss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    maxss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    maxss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_maxss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmaxss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmaxss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.max.ss(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse.max.ss(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse.max.ss(<4 x float>, <4 x float>) nounwind readnone

define <4 x float> @test_minps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_minps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    minps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    minps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_minps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    minps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    minps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_minps:
; SLM:       # %bb.0:
; SLM-NEXT:    minps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    minps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_minps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    minps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    minps (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_minps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_minps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    minps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    minps (%rdi), %xmm0 # sched: [9:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_minps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_minps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    minps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    minps (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_minps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_minps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    minps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    minps (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_minps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_minps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    minps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    minps (%rdi), %xmm0 # sched: [10:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_minps:
; SKX:       # %bb.0:
; SKX-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_minps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    minps %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    minps (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_minps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_minps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    minps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    minps (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_minps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vminps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vminps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse.min.ps(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse.min.ps(<4 x float>, <4 x float>) nounwind readnone

define <4 x float> @test_minss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_minss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    minss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    minss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_minss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    minss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    minss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_minss:
; SLM:       # %bb.0:
; SLM-NEXT:    minss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    minss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_minss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    minss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    minss (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_minss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_minss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    minss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    minss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_minss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_minss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    minss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    minss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_minss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_minss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    minss %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    minss (%rdi), %xmm0 # sched: [9:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_minss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_minss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    minss %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    minss (%rdi), %xmm0 # sched: [9:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_minss:
; SKX:       # %bb.0:
; SKX-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_minss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    minss %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    minss (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_minss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_minss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    minss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    minss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_minss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vminss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vminss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.min.ss(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = call <4 x float> @llvm.x86.sse.min.ss(<4 x float> %1, <4 x float> %2)
  ret <4 x float> %3
}
declare <4 x float> @llvm.x86.sse.min.ss(<4 x float>, <4 x float>) nounwind readnone

define void @test_movaps(<4 x float> *%a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_movaps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movaps (%rdi), %xmm0 # sched: [6:0.50]
; GENERIC-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movaps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movaps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    addps %xmm0, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movaps:
; SLM:       # %bb.0:
; SLM-NEXT:    movaps (%rdi), %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movaps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movaps (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movaps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovaps (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movaps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movaps (%rdi), %xmm0 # sched: [6:0.50]
; HASWELL-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movaps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovaps (%rdi), %xmm0 # sched: [6:0.50]
; HASWELL-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movaps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movaps (%rdi), %xmm0 # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movaps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovaps (%rdi), %xmm0 # sched: [5:0.50]
; BROADWELL-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movaps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movaps (%rdi), %xmm0 # sched: [6:0.50]
; SKYLAKE-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movaps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovaps (%rdi), %xmm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movaps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movaps (%rdi), %xmm0 # sched: [6:0.50]
; SKX-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movaps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovaps (%rdi), %xmm0 # sched: [6:0.50]
; SKX-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movaps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movaps (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    movaps %xmm0, (%rsi) # sched: [1:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movaps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovaps (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movaps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movaps (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    movaps %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movaps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovaps (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovaps %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <4 x float>, <4 x float> *%a0, align 16
  %2 = fadd <4 x float> %1, %1
  store <4 x float> %2, <4 x float> *%a1, align 16
  ret void
}

; TODO (v)movhlps

define <4 x float> @test_movhlps(<4 x float> %a0, <4 x float> %a1) {
; GENERIC-LABEL: test_movhlps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movhlps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movhlps:
; SLM:       # %bb.0:
; SLM-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movhlps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movhlps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movhlps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movhlps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movhlps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movhlps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movhlps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movhlps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movhlps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movhlps:
; SKX:       # %bb.0:
; SKX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movhlps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movhlps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movhlps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movhlps {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movhlps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm1[1],xmm0[1] sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 6, i32 7, i32 2, i32 3>
  ret <4 x float> %1
}

; TODO (v)movhps

define void @test_movhps(<4 x float> %a0, <4 x float> %a1, x86_mmx *%a2) {
; GENERIC-LABEL: test_movhps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [7:1.00]
; GENERIC-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; GENERIC-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; GENERIC-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movhps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; ATOM-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movhps:
; SLM:       # %bb.0:
; SLM-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [4:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; SLM-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movhps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [7:1.00]
; SANDY-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-SSE-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; SANDY-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movhps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [7:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movhps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; HASWELL-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; HASWELL-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movhps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movhps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movhps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movhps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movhps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movhps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; SKX-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [4:0.50]
; SKX-SSE-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:1.00]
; SKX-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movhps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [2:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movhps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; BTVER2-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:0.50]
; BTVER2-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [2:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movhps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [6:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movhps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    movhlps {{.*#+}} xmm1 = xmm1[1,1] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movhps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vpextrq $1, %xmm0, (%rdi) # sched: [5:3.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast x86_mmx* %a2 to <2 x float>*
  %2 = load <2 x float>, <2 x float> *%1, align 8
  %3 = shufflevector <2 x float> %2, <2 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x float> %a1, <4 x float> %3, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  %5 = fadd <4 x float> %a0, %4
  %6 = shufflevector <4 x float> %5, <4 x float> undef, <2 x i32> <i32 2, i32 3>
  store <2 x float> %6, <2 x float>* %1
  ret void
}

; TODO (v)movlhps

define <4 x float> @test_movlhps(<4 x float> %a0, <4 x float> %a1) {
; GENERIC-LABEL: test_movlhps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movlhps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movlhps:
; SLM:       # %bb.0:
; SLM-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movlhps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movlhps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SANDY-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movlhps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movlhps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; HASWELL-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movlhps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movlhps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; BROADWELL-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movlhps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movlhps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SKYLAKE-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movlhps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movlhps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:1.00]
; SKX-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movlhps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:0.50]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movlhps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:0.50]
; BTVER2-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movlhps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movlhps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0] sched: [1:0.50]
; ZNVER1-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 1, i32 4, i32 5>
  %2 = fadd <4 x float> %a1, %1
  ret <4 x float> %2
}

define void @test_movlps(<4 x float> %a0, <4 x float> %a1, x86_mmx *%a2) {
; GENERIC-LABEL: test_movlps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [7:1.00]
; GENERIC-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; GENERIC-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movlps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movlps:
; SLM:       # %bb.0:
; SLM-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [4:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movlps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [7:1.00]
; SANDY-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SANDY-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movlps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [7:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movlps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; HASWELL-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movlps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movlps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movlps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movlps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movlps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movlps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; SKX-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [4:0.50]
; SKX-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movlps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movlps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; BTVER2-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [2:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movlps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [6:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmovlps %xmm0, (%rdi) # sched: [2:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movlps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    movlps %xmm1, (%rdi) # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movlps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovlpd {{.*#+}} xmm1 = mem[0],xmm1[1] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovlps %xmm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast x86_mmx* %a2 to <2 x float>*
  %2 = load <2 x float>, <2 x float> *%1, align 8
  %3 = shufflevector <2 x float> %2, <2 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x float> %a1, <4 x float> %3, <4 x i32> <i32 4, i32 5, i32 2, i32 3>
  %5 = fadd <4 x float> %a0, %4
  %6 = shufflevector <4 x float> %5, <4 x float> undef, <2 x i32> <i32 0, i32 1>
  store <2 x float> %6, <2 x float>* %1
  ret void
}

define i32 @test_movmskps(<4 x float> %a0) {
; GENERIC-LABEL: test_movmskps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movmskps %xmm0, %eax # sched: [2:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movmskps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movmskps %xmm0, %eax # sched: [3:3.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movmskps:
; SLM:       # %bb.0:
; SLM-NEXT:    movmskps %xmm0, %eax # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movmskps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movmskps %xmm0, %eax # sched: [2:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movmskps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovmskps %xmm0, %eax # sched: [2:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movmskps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movmskps %xmm0, %eax # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movmskps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovmskps %xmm0, %eax # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movmskps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movmskps %xmm0, %eax # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movmskps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovmskps %xmm0, %eax # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movmskps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movmskps %xmm0, %eax # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movmskps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovmskps %xmm0, %eax # sched: [2:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movmskps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movmskps %xmm0, %eax # sched: [2:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movmskps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovmskps %xmm0, %eax # sched: [2:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movmskps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movmskps %xmm0, %eax # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movmskps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovmskps %xmm0, %eax # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movmskps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movmskps %xmm0, %eax # sched: [1:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movmskps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovmskps %xmm0, %eax # sched: [1:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse.movmsk.ps(<4 x float> %a0)
  ret i32 %1
}
declare i32 @llvm.x86.sse.movmsk.ps(<4 x float>) nounwind readnone

define void @test_movntps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_movntps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movntps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movntps:
; SLM:       # %bb.0:
; SLM-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movntps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movntps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movntps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movntps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movntps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movntps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movntps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movntps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movntps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movntps %xmm0, (%rdi) # sched: [1:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movntps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movntps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movntps %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movntps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovntps %xmm0, (%rdi) # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movntps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movntps %xmm0, (%rdi) # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movntps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovntps %xmm0, (%rdi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  store <4 x float> %a0, <4 x float> *%a1, align 16, !nontemporal !0
  ret void
}

define void @test_movss_mem(float* %a0, float* %a1) {
; GENERIC-LABEL: test_movss_mem:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [6:0.50]
; GENERIC-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movss_mem:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [1:1.00]
; ATOM-NEXT:    addss %xmm0, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movss_mem:
; SLM:       # %bb.0:
; SLM-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [3:1.00]
; SLM-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movss_mem:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-SSE-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movss_mem:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movss_mem:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; HASWELL-SSE-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movss_mem:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; HASWELL-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movss_mem:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; BROADWELL-SSE-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movss_mem:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; BROADWELL-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movss_mem:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; SKYLAKE-SSE-NEXT:    addss %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movss_mem:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; SKYLAKE-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movss_mem:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; SKX-SSE-NEXT:    addss %xmm0, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    movss %xmm0, (%rsi) # sched: [1:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movss_mem:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:0.50]
; SKX-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movss_mem:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-SSE-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    movss %xmm0, (%rsi) # sched: [2:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movss_mem:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmovss %xmm0, (%rsi) # sched: [2:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movss_mem:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addss %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    movss %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movss_mem:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vaddss %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovss %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load float, float* %a0, align 1
  %2 = fadd float %1, %1
  store float %2, float *%a1, align 1
  ret void
}

define <4 x float> @test_movss_reg(<4 x float> %a0, <4 x float> %a1) {
; GENERIC-LABEL: test_movss_reg:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movss_reg:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movss_reg:
; SLM:       # %bb.0:
; SLM-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movss_reg:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movss_reg:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movss_reg:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movss_reg:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.33]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movss_reg:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movss_reg:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.33]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movss_reg:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movss_reg:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movss_reg:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movss_reg:
; SKX:       # %bb.0:
; SKX-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movss_reg:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movss_reg:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movss_reg:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movss_reg:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3] sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  ret <4 x float> %1
}

define void @test_movups(<4 x float> *%a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_movups:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    movups (%rdi), %xmm0 # sched: [6:0.50]
; GENERIC-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_movups:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movups (%rdi), %xmm0 # sched: [3:1.50]
; ATOM-NEXT:    addps %xmm0, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    movups %xmm0, (%rsi) # sched: [2:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_movups:
; SLM:       # %bb.0:
; SLM-NEXT:    movups (%rdi), %xmm0 # sched: [3:1.00]
; SLM-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_movups:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    movups (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_movups:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmovups (%rdi), %xmm0 # sched: [6:0.50]
; SANDY-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_movups:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    movups (%rdi), %xmm0 # sched: [6:0.50]
; HASWELL-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_movups:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmovups (%rdi), %xmm0 # sched: [6:0.50]
; HASWELL-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_movups:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    movups (%rdi), %xmm0 # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_movups:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmovups (%rdi), %xmm0 # sched: [5:0.50]
; BROADWELL-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_movups:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    movups (%rdi), %xmm0 # sched: [6:0.50]
; SKYLAKE-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_movups:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmovups (%rdi), %xmm0 # sched: [6:0.50]
; SKYLAKE-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_movups:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    movups (%rdi), %xmm0 # sched: [6:0.50]
; SKX-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_movups:
; SKX:       # %bb.0:
; SKX-NEXT:    vmovups (%rdi), %xmm0 # sched: [6:0.50]
; SKX-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_movups:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movups (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    movups %xmm0, (%rsi) # sched: [1:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_movups:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovups (%rdi), %xmm0 # sched: [5:1.00]
; BTVER2-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_movups:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movups (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    movups %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_movups:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovups (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm0, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vmovups %xmm0, (%rsi) # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = load <4 x float>, <4 x float> *%a0, align 1
  %2 = fadd <4 x float> %1, %1
  store <4 x float> %2, <4 x float> *%a1, align 1
  ret void
}

define <4 x float> @test_mulps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_mulps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    mulps %xmm1, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    mulps (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_mulps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    mulps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    mulps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_mulps:
; SLM:       # %bb.0:
; SLM-NEXT:    mulps %xmm1, %xmm0 # sched: [5:2.00]
; SLM-NEXT:    mulps (%rdi), %xmm0 # sched: [8:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_mulps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    mulps %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-SSE-NEXT:    mulps (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_mulps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_mulps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    mulps %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-SSE-NEXT:    mulps (%rdi), %xmm0 # sched: [11:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_mulps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [11:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_mulps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    mulps %xmm1, %xmm0 # sched: [3:0.50]
; BROADWELL-SSE-NEXT:    mulps (%rdi), %xmm0 # sched: [8:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_mulps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BROADWELL-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_mulps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    mulps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    mulps (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_mulps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_mulps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    mulps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    mulps (%rdi), %xmm0 # sched: [10:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_mulps:
; SKX:       # %bb.0:
; SKX-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_mulps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    mulps %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    mulps (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_mulps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_mulps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    mulps %xmm1, %xmm0 # sched: [3:0.50]
; ZNVER1-SSE-NEXT:    mulps (%rdi), %xmm0 # sched: [10:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_mulps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; ZNVER1-NEXT:    vmulps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fmul <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fmul <4 x float> %1, %2
  ret <4 x float> %3
}

define float @test_mulss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_mulss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    mulss %xmm1, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    mulss (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_mulss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    mulss %xmm1, %xmm0 # sched: [4:4.00]
; ATOM-NEXT:    mulss (%rdi), %xmm0 # sched: [4:4.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_mulss:
; SLM:       # %bb.0:
; SLM-NEXT:    mulss %xmm1, %xmm0 # sched: [5:2.00]
; SLM-NEXT:    mulss (%rdi), %xmm0 # sched: [8:2.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_mulss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    mulss %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-SSE-NEXT:    mulss (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_mulss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_mulss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    mulss %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-SSE-NEXT:    mulss (%rdi), %xmm0 # sched: [10:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_mulss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_mulss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    mulss %xmm1, %xmm0 # sched: [3:0.50]
; BROADWELL-SSE-NEXT:    mulss (%rdi), %xmm0 # sched: [8:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_mulss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; BROADWELL-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_mulss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    mulss %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    mulss (%rdi), %xmm0 # sched: [9:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_mulss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_mulss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    mulss %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    mulss (%rdi), %xmm0 # sched: [9:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_mulss:
; SKX:       # %bb.0:
; SKX-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_mulss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    mulss %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    mulss (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_mulss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_mulss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    mulss %xmm1, %xmm0 # sched: [3:0.50]
; ZNVER1-SSE-NEXT:    mulss (%rdi), %xmm0 # sched: [10:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_mulss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [3:0.50]
; ZNVER1-NEXT:    vmulss (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fmul float %a0, %a1
  %2 = load float, float *%a2, align 4
  %3 = fmul float %1, %2
  ret float %3
}

define <4 x float> @test_orps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_orps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    orps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_orps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    orps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_orps:
; SLM:       # %bb.0:
; SLM-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    orps (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_orps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    orps (%rdi), %xmm0 # sched: [7:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_orps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_orps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    orps (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_orps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_orps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    orps (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_orps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_orps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    orps (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_orps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_orps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    orps (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_orps:
; SKX:       # %bb.0:
; SKX-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_orps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    orps (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_orps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_orps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    orps %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    orps (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_orps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vorps %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vorps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <4 x float> %a0 to <4 x i32>
  %2 = bitcast <4 x float> %a1 to <4 x i32>
  %3 = or <4 x i32> %1, %2
  %4 = load <4 x float>, <4 x float> *%a2, align 16
  %5 = bitcast <4 x float> %4 to <4 x i32>
  %6 = or <4 x i32> %3, %5
  %7 = bitcast <4 x i32> %6 to <4 x float>
  ret <4 x float> %7
}

define void @test_prefetch(i8* %a0) optsize {
; GENERIC-LABEL: test_prefetch:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; GENERIC-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; GENERIC-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; GENERIC-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_prefetch:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    prefetchnta (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    prefetcht0 (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    prefetcht1 (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    prefetcht2 (%rdi) # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_prefetch:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    prefetchnta (%rdi) # sched: [3:1.00]
; SLM-NEXT:    prefetcht0 (%rdi) # sched: [3:1.00]
; SLM-NEXT:    prefetcht1 (%rdi) # sched: [3:1.00]
; SLM-NEXT:    prefetcht2 (%rdi) # sched: [3:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_prefetch:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    #APP
; SANDY-SSE-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; SANDY-SSE-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; SANDY-SSE-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; SANDY-SSE-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; SANDY-SSE-NEXT:    #NO_APP
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_prefetch:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; SANDY-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; SANDY-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; SANDY-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_prefetch:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    #APP
; HASWELL-SSE-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; HASWELL-SSE-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; HASWELL-SSE-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; HASWELL-SSE-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; HASWELL-SSE-NEXT:    #NO_APP
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_prefetch:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; HASWELL-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; HASWELL-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; HASWELL-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_prefetch:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    #APP
; BROADWELL-SSE-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    #NO_APP
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_prefetch:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; BROADWELL-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; BROADWELL-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; BROADWELL-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_prefetch:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    #APP
; SKYLAKE-SSE-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; SKYLAKE-SSE-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; SKYLAKE-SSE-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; SKYLAKE-SSE-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; SKYLAKE-SSE-NEXT:    #NO_APP
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_prefetch:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; SKYLAKE-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; SKYLAKE-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; SKYLAKE-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_prefetch:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    #APP
; SKX-SSE-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; SKX-SSE-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; SKX-SSE-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; SKX-SSE-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; SKX-SSE-NEXT:    #NO_APP
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_prefetch:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    prefetchnta (%rdi) # sched: [5:0.50]
; SKX-NEXT:    prefetcht0 (%rdi) # sched: [5:0.50]
; SKX-NEXT:    prefetcht1 (%rdi) # sched: [5:0.50]
; SKX-NEXT:    prefetcht2 (%rdi) # sched: [5:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_prefetch:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    #APP
; BTVER2-SSE-NEXT:    prefetchnta (%rdi) # sched: [5:1.00]
; BTVER2-SSE-NEXT:    prefetcht0 (%rdi) # sched: [5:1.00]
; BTVER2-SSE-NEXT:    prefetcht1 (%rdi) # sched: [5:1.00]
; BTVER2-SSE-NEXT:    prefetcht2 (%rdi) # sched: [5:1.00]
; BTVER2-SSE-NEXT:    #NO_APP
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_prefetch:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    prefetchnta (%rdi) # sched: [5:1.00]
; BTVER2-NEXT:    prefetcht0 (%rdi) # sched: [5:1.00]
; BTVER2-NEXT:    prefetcht1 (%rdi) # sched: [5:1.00]
; BTVER2-NEXT:    prefetcht2 (%rdi) # sched: [5:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_prefetch:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    #APP
; ZNVER1-SSE-NEXT:    prefetchnta (%rdi) # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    prefetcht0 (%rdi) # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    prefetcht1 (%rdi) # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    prefetcht2 (%rdi) # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    #NO_APP
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_prefetch:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    prefetchnta (%rdi) # sched: [8:0.50]
; ZNVER1-NEXT:    prefetcht0 (%rdi) # sched: [8:0.50]
; ZNVER1-NEXT:    prefetcht1 (%rdi) # sched: [8:0.50]
; ZNVER1-NEXT:    prefetcht2 (%rdi) # sched: [8:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void asm sideeffect "prefetchnta $0 \0A\09 prefetcht0 $0 \0A\09 prefetcht1 $0 \0A\09 prefetcht2 $0", "*m"(i8 *%a0)
  ret void
}

define <4 x float> @test_rcpps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_rcpps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    rcpps %xmm0, %xmm1 # sched: [5:1.00]
; GENERIC-NEXT:    rcpps (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_rcpps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    rcpps (%rdi), %xmm1 # sched: [10:5.00]
; ATOM-NEXT:    rcpps %xmm0, %xmm0 # sched: [9:4.50]
; ATOM-NEXT:    addps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_rcpps:
; SLM:       # %bb.0:
; SLM-NEXT:    rcpps (%rdi), %xmm1 # sched: [8:1.00]
; SLM-NEXT:    rcpps %xmm0, %xmm0 # sched: [5:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_rcpps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    rcpps %xmm0, %xmm1 # sched: [5:1.00]
; SANDY-SSE-NEXT:    rcpps (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_rcpps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vrcpps %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vrcpps (%rdi), %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_rcpps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    rcpps %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    rcpps (%rdi), %xmm0 # sched: [11:1.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_rcpps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vrcpps %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vrcpps (%rdi), %xmm1 # sched: [11:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_rcpps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    rcpps %xmm0, %xmm1 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    rcpps (%rdi), %xmm0 # sched: [10:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_rcpps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vrcpps %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-NEXT:    vrcpps (%rdi), %xmm1 # sched: [10:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_rcpps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    rcpps %xmm0, %xmm1 # sched: [4:1.00]
; SKYLAKE-SSE-NEXT:    rcpps (%rdi), %xmm0 # sched: [10:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_rcpps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vrcpps %xmm0, %xmm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    vrcpps (%rdi), %xmm1 # sched: [10:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_rcpps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    rcpps %xmm0, %xmm1 # sched: [4:1.00]
; SKX-SSE-NEXT:    rcpps (%rdi), %xmm0 # sched: [10:1.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_rcpps:
; SKX:       # %bb.0:
; SKX-NEXT:    vrcpps %xmm0, %xmm0 # sched: [4:1.00]
; SKX-NEXT:    vrcpps (%rdi), %xmm1 # sched: [10:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_rcpps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    rcpps %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    rcpps (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_rcpps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vrcpps (%rdi), %xmm1 # sched: [7:1.00]
; BTVER2-NEXT:    vrcpps %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_rcpps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    rcpps %xmm0, %xmm1 # sched: [5:0.50]
; ZNVER1-SSE-NEXT:    rcpps (%rdi), %xmm0 # sched: [12:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_rcpps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vrcpps (%rdi), %xmm1 # sched: [12:0.50]
; ZNVER1-NEXT:    vrcpps %xmm0, %xmm0 # sched: [5:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.rcp.ps(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse.rcp.ps(<4 x float> %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.rcp.ps(<4 x float>) nounwind readnone

; TODO - rcpss_m

define <4 x float> @test_rcpss(float %a0, float *%a1) {
; GENERIC-LABEL: test_rcpss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    rcpss %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; GENERIC-NEXT:    rcpss %xmm1, %xmm1 # sched: [5:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_rcpss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [1:1.00]
; ATOM-NEXT:    rcpss %xmm0, %xmm0 # sched: [4:4.00]
; ATOM-NEXT:    rcpss %xmm1, %xmm1 # sched: [4:4.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_rcpss:
; SLM:       # %bb.0:
; SLM-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [3:1.00]
; SLM-NEXT:    rcpss %xmm0, %xmm0 # sched: [5:1.00]
; SLM-NEXT:    rcpss %xmm1, %xmm1 # sched: [5:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_rcpss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    rcpss %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-SSE-NEXT:    rcpss %xmm1, %xmm1 # sched: [5:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_rcpss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_rcpss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    rcpss %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; HASWELL-SSE-NEXT:    rcpss %xmm1, %xmm1 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_rcpss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; HASWELL-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_rcpss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    rcpss %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; BROADWELL-SSE-NEXT:    rcpss %xmm1, %xmm1 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_rcpss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; BROADWELL-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_rcpss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    rcpss %xmm0, %xmm0 # sched: [4:1.00]
; SKYLAKE-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; SKYLAKE-SSE-NEXT:    rcpss %xmm1, %xmm1 # sched: [4:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_rcpss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; SKYLAKE-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [4:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_rcpss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    rcpss %xmm0, %xmm0 # sched: [4:1.00]
; SKX-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; SKX-SSE-NEXT:    rcpss %xmm1, %xmm1 # sched: [4:1.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_rcpss:
; SKX:       # %bb.0:
; SKX-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [4:1.00]
; SKX-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; SKX-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [4:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_rcpss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-SSE-NEXT:    rcpss %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    rcpss %xmm1, %xmm1 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_rcpss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_rcpss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    rcpss %xmm0, %xmm0 # sched: [5:0.50]
; ZNVER1-SSE-NEXT:    rcpss %xmm1, %xmm1 # sched: [5:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_rcpss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [5:0.50]
; ZNVER1-NEXT:    vrcpss %xmm1, %xmm1, %xmm1 # sched: [5:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = call <4 x float> @llvm.x86.sse.rcp.ss(<4 x float> %1)
  %3 = load float, float *%a1, align 4
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = call <4 x float> @llvm.x86.sse.rcp.ss(<4 x float> %4)
  %6 = fadd <4 x float> %2, %5
  ret <4 x float> %6
}
declare <4 x float> @llvm.x86.sse.rcp.ss(<4 x float>) nounwind readnone

define <4 x float> @test_rsqrtps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_rsqrtps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [5:1.00]
; GENERIC-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [11:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_rsqrtps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    rsqrtps (%rdi), %xmm1 # sched: [10:5.00]
; ATOM-NEXT:    rsqrtps %xmm0, %xmm0 # sched: [9:4.50]
; ATOM-NEXT:    addps %xmm0, %xmm1 # sched: [5:5.00]
; ATOM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_rsqrtps:
; SLM:       # %bb.0:
; SLM-NEXT:    rsqrtps (%rdi), %xmm1 # sched: [8:1.00]
; SLM-NEXT:    rsqrtps %xmm0, %xmm0 # sched: [5:1.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_rsqrtps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [5:1.00]
; SANDY-SSE-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [11:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_rsqrtps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_rsqrtps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [11:1.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_rsqrtps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [11:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_rsqrtps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [10:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_rsqrtps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [10:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_rsqrtps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [4:1.00]
; SKYLAKE-SSE-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [10:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_rsqrtps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [10:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_rsqrtps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [4:1.00]
; SKX-SSE-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [10:1.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_rsqrtps:
; SKX:       # %bb.0:
; SKX-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [4:1.00]
; SKX-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [10:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_rsqrtps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [7:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_rsqrtps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [7:1.00]
; BTVER2-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_rsqrtps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    rsqrtps %xmm0, %xmm1 # sched: [5:0.50]
; ZNVER1-SSE-NEXT:    rsqrtps (%rdi), %xmm0 # sched: [12:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_rsqrtps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vrsqrtps (%rdi), %xmm1 # sched: [12:0.50]
; ZNVER1-NEXT:    vrsqrtps %xmm0, %xmm0 # sched: [5:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.rsqrt.ps(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse.rsqrt.ps(<4 x float> %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.rsqrt.ps(<4 x float>) nounwind readnone

; TODO - rsqrtss_m

define <4 x float> @test_rsqrtss(float %a0, float *%a1) {
; GENERIC-LABEL: test_rsqrtss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [5:1.00]
; GENERIC-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; GENERIC-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [5:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_rsqrtss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [1:1.00]
; ATOM-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [4:4.00]
; ATOM-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [4:4.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_rsqrtss:
; SLM:       # %bb.0:
; SLM-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [3:1.00]
; SLM-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [5:1.00]
; SLM-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [5:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_rsqrtss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-SSE-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [5:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_rsqrtss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_rsqrtss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; HASWELL-SSE-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [5:1.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_rsqrtss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; HASWELL-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_rsqrtss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; BROADWELL-SSE-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [5:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_rsqrtss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; BROADWELL-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; BROADWELL-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [5:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_rsqrtss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [4:1.00]
; SKYLAKE-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; SKYLAKE-SSE-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [4:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_rsqrtss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [4:1.00]
; SKYLAKE-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; SKYLAKE-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [4:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_rsqrtss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [4:1.00]
; SKX-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; SKX-SSE-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [4:1.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_rsqrtss:
; SKX:       # %bb.0:
; SKX-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [4:1.00]
; SKX-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:0.50]
; SKX-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [4:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_rsqrtss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-SSE-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [2:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_rsqrtss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_rsqrtss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-SSE-NEXT:    rsqrtss %xmm0, %xmm0 # sched: [5:0.50]
; ZNVER1-SSE-NEXT:    rsqrtss %xmm1, %xmm1 # sched: [5:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_rsqrtss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero sched: [8:0.50]
; ZNVER1-NEXT:    vrsqrtss %xmm0, %xmm0, %xmm0 # sched: [5:0.50]
; ZNVER1-NEXT:    vrsqrtss %xmm1, %xmm1, %xmm1 # sched: [5:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = insertelement <4 x float> undef, float %a0, i32 0
  %2 = call <4 x float> @llvm.x86.sse.rsqrt.ss(<4 x float> %1)
  %3 = load float, float *%a1, align 4
  %4 = insertelement <4 x float> undef, float %3, i32 0
  %5 = call <4 x float> @llvm.x86.sse.rsqrt.ss(<4 x float> %4)
  %6 = fadd <4 x float> %2, %5
  ret <4 x float> %6
}
declare <4 x float> @llvm.x86.sse.rsqrt.ss(<4 x float>) nounwind readnone

define void @test_sfence() {
; GENERIC-LABEL: test_sfence:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    sfence # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_sfence:
; ATOM:       # %bb.0:
; ATOM-NEXT:    sfence # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_sfence:
; SLM:       # %bb.0:
; SLM-NEXT:    sfence # sched: [1:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_sfence:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    sfence # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_sfence:
; SANDY:       # %bb.0:
; SANDY-NEXT:    sfence # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_sfence:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    sfence # sched: [2:0.33]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_sfence:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    sfence # sched: [2:0.33]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_sfence:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    sfence # sched: [2:0.33]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_sfence:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    sfence # sched: [2:0.33]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_sfence:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    sfence # sched: [2:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_sfence:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    sfence # sched: [2:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_sfence:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    sfence # sched: [2:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_sfence:
; SKX:       # %bb.0:
; SKX-NEXT:    sfence # sched: [2:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_sfence:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    sfence # sched: [1:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_sfence:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    sfence # sched: [1:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_sfence:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    sfence # sched: [1:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_sfence:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    sfence # sched: [1:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void @llvm.x86.sse.sfence()
  ret void
}
declare void @llvm.x86.sse.sfence() nounwind readnone

define <4 x float> @test_shufps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) nounwind {
; GENERIC-LABEL: test_shufps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; GENERIC-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_shufps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; ATOM-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_shufps:
; SLM:       # %bb.0:
; SLM-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SLM-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [4:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_shufps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SANDY-SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_shufps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SANDY-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_shufps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; HASWELL-SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_shufps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; HASWELL-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_shufps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [6:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_shufps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; BROADWELL-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [6:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_shufps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_shufps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SKYLAKE-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_shufps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SKX-SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_shufps:
; SKX:       # %bb.0:
; SKX-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:1.00]
; SKX-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [7:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_shufps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:0.50]
; BTVER2-SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [6:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_shufps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:0.50]
; BTVER2-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [6:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_shufps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_shufps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vshufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0] sched: [1:0.50]
; ZNVER1-NEXT:    vshufps {{.*#+}} xmm1 = xmm1[0,3],mem[0,0] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 0, i32 4, i32 4>
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = shufflevector <4 x float> %a1, <4 x float> %2, <4 x i32> <i32 0, i32 3, i32 4, i32 4>
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}

define <4 x float> @test_sqrtps(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_sqrtps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    sqrtps %xmm0, %xmm1 # sched: [14:14.00]
; GENERIC-NEXT:    sqrtps (%rdi), %xmm0 # sched: [20:14.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_sqrtps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    sqrtps %xmm0, %xmm1 # sched: [70:35.00]
; ATOM-NEXT:    sqrtps (%rdi), %xmm0 # sched: [70:35.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_sqrtps:
; SLM:       # %bb.0:
; SLM-NEXT:    sqrtps (%rdi), %xmm1 # sched: [44:40.00]
; SLM-NEXT:    sqrtps %xmm0, %xmm0 # sched: [41:40.00]
; SLM-NEXT:    addps %xmm0, %xmm1 # sched: [3:1.00]
; SLM-NEXT:    movaps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_sqrtps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    sqrtps %xmm0, %xmm1 # sched: [14:14.00]
; SANDY-SSE-NEXT:    sqrtps (%rdi), %xmm0 # sched: [20:14.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_sqrtps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [14:14.00]
; SANDY-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [20:14.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_sqrtps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    sqrtps %xmm0, %xmm1 # sched: [11:7.00]
; HASWELL-SSE-NEXT:    sqrtps (%rdi), %xmm0 # sched: [17:7.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_sqrtps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [11:7.00]
; HASWELL-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [17:7.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_sqrtps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    sqrtps %xmm0, %xmm1 # sched: [11:7.00]
; BROADWELL-SSE-NEXT:    sqrtps (%rdi), %xmm0 # sched: [16:7.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_sqrtps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [11:7.00]
; BROADWELL-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [16:7.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_sqrtps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    sqrtps %xmm0, %xmm1 # sched: [12:3.00]
; SKYLAKE-SSE-NEXT:    sqrtps (%rdi), %xmm0 # sched: [18:3.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_sqrtps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [12:3.00]
; SKYLAKE-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [18:3.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_sqrtps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    sqrtps %xmm0, %xmm1 # sched: [12:3.00]
; SKX-SSE-NEXT:    sqrtps (%rdi), %xmm0 # sched: [18:3.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_sqrtps:
; SKX:       # %bb.0:
; SKX-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [12:3.00]
; SKX-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [18:3.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_sqrtps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    sqrtps %xmm0, %xmm1 # sched: [21:21.00]
; BTVER2-SSE-NEXT:    sqrtps (%rdi), %xmm0 # sched: [26:21.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_sqrtps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [26:21.00]
; BTVER2-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [21:21.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_sqrtps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    sqrtps %xmm0, %xmm1 # sched: [20:20.00]
; ZNVER1-SSE-NEXT:    sqrtps (%rdi), %xmm0 # sched: [27:20.00]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_sqrtps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vsqrtps (%rdi), %xmm1 # sched: [27:20.00]
; ZNVER1-NEXT:    vsqrtps %xmm0, %xmm0 # sched: [20:20.00]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.sqrt.ps(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse.sqrt.ps(<4 x float> %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.sqrt.ps(<4 x float>) nounwind readnone

; TODO - sqrtss_m

define <4 x float> @test_sqrtss(<4 x float> %a0, <4 x float> *%a1) {
; GENERIC-LABEL: test_sqrtss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    sqrtss %xmm0, %xmm0 # sched: [14:14.00]
; GENERIC-NEXT:    movaps (%rdi), %xmm1 # sched: [6:0.50]
; GENERIC-NEXT:    sqrtss %xmm1, %xmm1 # sched: [14:14.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_sqrtss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    movaps (%rdi), %xmm1 # sched: [1:1.00]
; ATOM-NEXT:    sqrtss %xmm0, %xmm0 # sched: [34:17.00]
; ATOM-NEXT:    sqrtss %xmm1, %xmm1 # sched: [34:17.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_sqrtss:
; SLM:       # %bb.0:
; SLM-NEXT:    movaps (%rdi), %xmm1 # sched: [3:1.00]
; SLM-NEXT:    sqrtss %xmm0, %xmm0 # sched: [20:20.00]
; SLM-NEXT:    sqrtss %xmm1, %xmm1 # sched: [20:20.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_sqrtss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    sqrtss %xmm0, %xmm0 # sched: [14:14.00]
; SANDY-SSE-NEXT:    movaps (%rdi), %xmm1 # sched: [6:0.50]
; SANDY-SSE-NEXT:    sqrtss %xmm1, %xmm1 # sched: [14:14.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_sqrtss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [14:14.00]
; SANDY-NEXT:    vmovaps (%rdi), %xmm1 # sched: [6:0.50]
; SANDY-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [14:14.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_sqrtss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    sqrtss %xmm0, %xmm0 # sched: [11:7.00]
; HASWELL-SSE-NEXT:    movaps (%rdi), %xmm1 # sched: [6:0.50]
; HASWELL-SSE-NEXT:    sqrtss %xmm1, %xmm1 # sched: [11:7.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_sqrtss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [11:7.00]
; HASWELL-NEXT:    vmovaps (%rdi), %xmm1 # sched: [6:0.50]
; HASWELL-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [11:7.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_sqrtss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    sqrtss %xmm0, %xmm0 # sched: [11:4.00]
; BROADWELL-SSE-NEXT:    movaps (%rdi), %xmm1 # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    sqrtss %xmm1, %xmm1 # sched: [11:4.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_sqrtss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [11:4.00]
; BROADWELL-NEXT:    vmovaps (%rdi), %xmm1 # sched: [5:0.50]
; BROADWELL-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [11:4.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_sqrtss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    sqrtss %xmm0, %xmm0 # sched: [12:3.00]
; SKYLAKE-SSE-NEXT:    movaps (%rdi), %xmm1 # sched: [6:0.50]
; SKYLAKE-SSE-NEXT:    sqrtss %xmm1, %xmm1 # sched: [12:3.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_sqrtss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [12:3.00]
; SKYLAKE-NEXT:    vmovaps (%rdi), %xmm1 # sched: [6:0.50]
; SKYLAKE-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [12:3.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_sqrtss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    sqrtss %xmm0, %xmm0 # sched: [12:3.00]
; SKX-SSE-NEXT:    movaps (%rdi), %xmm1 # sched: [6:0.50]
; SKX-SSE-NEXT:    sqrtss %xmm1, %xmm1 # sched: [12:3.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_sqrtss:
; SKX:       # %bb.0:
; SKX-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [12:3.00]
; SKX-NEXT:    vmovaps (%rdi), %xmm1 # sched: [6:0.50]
; SKX-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [12:3.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_sqrtss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    movaps (%rdi), %xmm1 # sched: [5:1.00]
; BTVER2-SSE-NEXT:    sqrtss %xmm0, %xmm0 # sched: [21:21.00]
; BTVER2-SSE-NEXT:    sqrtss %xmm1, %xmm1 # sched: [21:21.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_sqrtss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vmovaps (%rdi), %xmm1 # sched: [5:1.00]
; BTVER2-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [21:21.00]
; BTVER2-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [21:21.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_sqrtss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    movaps (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    sqrtss %xmm0, %xmm0 # sched: [20:20.00]
; ZNVER1-SSE-NEXT:    sqrtss %xmm1, %xmm1 # sched: [20:20.00]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_sqrtss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vmovaps (%rdi), %xmm1 # sched: [8:0.50]
; ZNVER1-NEXT:    vsqrtss %xmm0, %xmm0, %xmm0 # sched: [20:20.00]
; ZNVER1-NEXT:    vsqrtss %xmm1, %xmm1, %xmm1 # sched: [20:20.00]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call <4 x float> @llvm.x86.sse.sqrt.ss(<4 x float> %a0)
  %2 = load <4 x float>, <4 x float> *%a1, align 16
  %3 = call <4 x float> @llvm.x86.sse.sqrt.ss(<4 x float> %2)
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}
declare <4 x float> @llvm.x86.sse.sqrt.ss(<4 x float>) nounwind readnone

define i32 @test_stmxcsr() {
; GENERIC-LABEL: test_stmxcsr:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; GENERIC-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_stmxcsr:
; ATOM:       # %bb.0:
; ATOM-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [15:7.50]
; ATOM-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_stmxcsr:
; SLM:       # %bb.0:
; SLM-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; SLM-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_stmxcsr:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-SSE-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_stmxcsr:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [5:1.00]
; SANDY-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_stmxcsr:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [2:1.00]
; HASWELL-SSE-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_stmxcsr:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [2:1.00]
; HASWELL-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_stmxcsr:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [2:1.00]
; BROADWELL-SSE-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_stmxcsr:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [2:1.00]
; BROADWELL-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_stmxcsr:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_stmxcsr:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [2:1.00]
; SKYLAKE-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_stmxcsr:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [2:1.00]
; SKX-SSE-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_stmxcsr:
; SKX:       # %bb.0:
; SKX-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [2:1.00]
; SKX-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_stmxcsr:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BTVER2-SSE-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_stmxcsr:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [1:1.00]
; BTVER2-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [5:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_stmxcsr:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    stmxcsr -{{[0-9]+}}(%rsp) # sched: [100:0.25]
; ZNVER1-SSE-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_stmxcsr:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vstmxcsr -{{[0-9]+}}(%rsp) # sched: [100:0.25]
; ZNVER1-NEXT:    movl -{{[0-9]+}}(%rsp), %eax # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = alloca i32, align 4
  %2 = bitcast i32* %1 to i8*
  call void @llvm.x86.sse.stmxcsr(i8* %2)
  %3 = load i32, i32* %1, align 4
  ret i32 %3
}
declare void @llvm.x86.sse.stmxcsr(i8*) nounwind readnone

define <4 x float> @test_subps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_subps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    subps (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_subps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    subps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    subps (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_subps:
; SLM:       # %bb.0:
; SLM-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    subps (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_subps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    subps (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_subps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_subps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    subps (%rdi), %xmm0 # sched: [9:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_subps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_subps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    subps (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_subps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_subps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    subps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    subps (%rdi), %xmm0 # sched: [10:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_subps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_subps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    subps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    subps (%rdi), %xmm0 # sched: [10:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_subps:
; SKX:       # %bb.0:
; SKX-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [10:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_subps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    subps (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_subps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_subps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    subps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    subps (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_subps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vsubps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vsubps (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fsub <4 x float> %a0, %a1
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = fsub <4 x float> %1, %2
  ret <4 x float> %3
}

define float @test_subss(float %a0, float %a1, float *%a2) {
; GENERIC-LABEL: test_subss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    subss (%rdi), %xmm0 # sched: [9:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_subss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    subss %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    subss (%rdi), %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_subss:
; SLM:       # %bb.0:
; SLM-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    subss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_subss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    subss (%rdi), %xmm0 # sched: [9:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_subss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [9:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_subss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    subss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_subss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_subss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    subss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_subss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_subss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    subss %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    subss (%rdi), %xmm0 # sched: [9:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_subss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_subss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    subss %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    subss (%rdi), %xmm0 # sched: [9:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_subss:
; SKX:       # %bb.0:
; SKX-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [9:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_subss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    subss (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_subss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_subss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    subss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    subss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_subss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vsubss %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    vsubss (%rdi), %xmm0, %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = fsub float %a0, %a1
  %2 = load float, float *%a2, align 4
  %3 = fsub float %1, %2
  ret float %3
}

define i32 @test_ucomiss(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_ucomiss:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    ucomiss %xmm1, %xmm0 # sched: [2:1.00]
; GENERIC-NEXT:    setnp %al # sched: [1:0.50]
; GENERIC-NEXT:    sete %cl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %cl # sched: [1:0.33]
; GENERIC-NEXT:    ucomiss (%rdi), %xmm0 # sched: [8:1.00]
; GENERIC-NEXT:    setnp %al # sched: [1:0.50]
; GENERIC-NEXT:    sete %dl # sched: [1:0.50]
; GENERIC-NEXT:    andb %al, %dl # sched: [1:0.33]
; GENERIC-NEXT:    orb %cl, %dl # sched: [1:0.33]
; GENERIC-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_ucomiss:
; ATOM:       # %bb.0:
; ATOM-NEXT:    ucomiss %xmm1, %xmm0 # sched: [9:4.50]
; ATOM-NEXT:    setnp %al # sched: [1:0.50]
; ATOM-NEXT:    sete %cl # sched: [1:0.50]
; ATOM-NEXT:    andb %al, %cl # sched: [1:0.50]
; ATOM-NEXT:    ucomiss (%rdi), %xmm0 # sched: [10:5.00]
; ATOM-NEXT:    setnp %al # sched: [1:0.50]
; ATOM-NEXT:    sete %dl # sched: [1:0.50]
; ATOM-NEXT:    andb %al, %dl # sched: [1:0.50]
; ATOM-NEXT:    orb %cl, %dl # sched: [1:0.50]
; ATOM-NEXT:    movzbl %dl, %eax # sched: [1:1.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_ucomiss:
; SLM:       # %bb.0:
; SLM-NEXT:    ucomiss %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    setnp %al # sched: [1:0.50]
; SLM-NEXT:    sete %cl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %cl # sched: [1:0.50]
; SLM-NEXT:    ucomiss (%rdi), %xmm0 # sched: [6:1.00]
; SLM-NEXT:    setnp %al # sched: [1:0.50]
; SLM-NEXT:    sete %dl # sched: [1:0.50]
; SLM-NEXT:    andb %al, %dl # sched: [1:0.50]
; SLM-NEXT:    orb %cl, %dl # sched: [1:0.50]
; SLM-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_ucomiss:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    ucomiss %xmm1, %xmm0 # sched: [2:1.00]
; SANDY-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-SSE-NEXT:    sete %cl # sched: [1:0.50]
; SANDY-SSE-NEXT:    andb %al, %cl # sched: [1:0.33]
; SANDY-SSE-NEXT:    ucomiss (%rdi), %xmm0 # sched: [8:1.00]
; SANDY-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-SSE-NEXT:    sete %dl # sched: [1:0.50]
; SANDY-SSE-NEXT:    andb %al, %dl # sched: [1:0.33]
; SANDY-SSE-NEXT:    orb %cl, %dl # sched: [1:0.33]
; SANDY-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_ucomiss:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vucomiss %xmm1, %xmm0 # sched: [2:1.00]
; SANDY-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-NEXT:    sete %cl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %cl # sched: [1:0.33]
; SANDY-NEXT:    vucomiss (%rdi), %xmm0 # sched: [8:1.00]
; SANDY-NEXT:    setnp %al # sched: [1:0.50]
; SANDY-NEXT:    sete %dl # sched: [1:0.50]
; SANDY-NEXT:    andb %al, %dl # sched: [1:0.33]
; SANDY-NEXT:    orb %cl, %dl # sched: [1:0.33]
; SANDY-NEXT:    movzbl %dl, %eax # sched: [1:0.33]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_ucomiss:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    ucomiss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-SSE-NEXT:    sete %cl # sched: [1:0.50]
; HASWELL-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; HASWELL-SSE-NEXT:    ucomiss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-SSE-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-SSE-NEXT:    sete %dl # sched: [1:0.50]
; HASWELL-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; HASWELL-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; HASWELL-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_ucomiss:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vucomiss %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-NEXT:    sete %cl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %cl # sched: [1:0.25]
; HASWELL-NEXT:    vucomiss (%rdi), %xmm0 # sched: [8:1.00]
; HASWELL-NEXT:    setnp %al # sched: [1:0.50]
; HASWELL-NEXT:    sete %dl # sched: [1:0.50]
; HASWELL-NEXT:    andb %al, %dl # sched: [1:0.25]
; HASWELL-NEXT:    orb %cl, %dl # sched: [1:0.25]
; HASWELL-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_ucomiss:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    ucomiss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    setnp %al # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    sete %cl # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    ucomiss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-SSE-NEXT:    setnp %al # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    sete %dl # sched: [1:0.50]
; BROADWELL-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_ucomiss:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vucomiss %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    setnp %al # sched: [1:0.50]
; BROADWELL-NEXT:    sete %cl # sched: [1:0.50]
; BROADWELL-NEXT:    andb %al, %cl # sched: [1:0.25]
; BROADWELL-NEXT:    vucomiss (%rdi), %xmm0 # sched: [8:1.00]
; BROADWELL-NEXT:    setnp %al # sched: [1:0.50]
; BROADWELL-NEXT:    sete %dl # sched: [1:0.50]
; BROADWELL-NEXT:    andb %al, %dl # sched: [1:0.25]
; BROADWELL-NEXT:    orb %cl, %dl # sched: [1:0.25]
; BROADWELL-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_ucomiss:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    ucomiss %xmm1, %xmm0 # sched: [2:1.00]
; SKYLAKE-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    sete %cl # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    ucomiss (%rdi), %xmm0 # sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    sete %dl # sched: [1:0.50]
; SKYLAKE-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_ucomiss:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vucomiss %xmm1, %xmm0 # sched: [2:1.00]
; SKYLAKE-NEXT:    setnp %al # sched: [1:0.50]
; SKYLAKE-NEXT:    sete %cl # sched: [1:0.50]
; SKYLAKE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKYLAKE-NEXT:    vucomiss (%rdi), %xmm0 # sched: [7:1.00]
; SKYLAKE-NEXT:    setnp %al # sched: [1:0.50]
; SKYLAKE-NEXT:    sete %dl # sched: [1:0.50]
; SKYLAKE-NEXT:    andb %al, %dl # sched: [1:0.25]
; SKYLAKE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; SKYLAKE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_ucomiss:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    ucomiss %xmm1, %xmm0 # sched: [2:1.00]
; SKX-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SKX-SSE-NEXT:    sete %cl # sched: [1:0.50]
; SKX-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKX-SSE-NEXT:    ucomiss (%rdi), %xmm0 # sched: [7:1.00]
; SKX-SSE-NEXT:    setnp %al # sched: [1:0.50]
; SKX-SSE-NEXT:    sete %dl # sched: [1:0.50]
; SKX-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; SKX-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; SKX-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_ucomiss:
; SKX:       # %bb.0:
; SKX-NEXT:    vucomiss %xmm1, %xmm0 # sched: [2:1.00]
; SKX-NEXT:    setnp %al # sched: [1:0.50]
; SKX-NEXT:    sete %cl # sched: [1:0.50]
; SKX-NEXT:    andb %al, %cl # sched: [1:0.25]
; SKX-NEXT:    vucomiss (%rdi), %xmm0 # sched: [7:1.00]
; SKX-NEXT:    setnp %al # sched: [1:0.50]
; SKX-NEXT:    sete %dl # sched: [1:0.50]
; SKX-NEXT:    andb %al, %dl # sched: [1:0.25]
; SKX-NEXT:    orb %cl, %dl # sched: [1:0.25]
; SKX-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_ucomiss:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    ucomiss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-SSE-NEXT:    sete %cl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    andb %al, %cl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    ucomiss (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-SSE-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-SSE-NEXT:    sete %dl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    andb %al, %dl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    orb %cl, %dl # sched: [1:0.50]
; BTVER2-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_ucomiss:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vucomiss %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-NEXT:    sete %cl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %cl # sched: [1:0.50]
; BTVER2-NEXT:    vucomiss (%rdi), %xmm0 # sched: [8:1.00]
; BTVER2-NEXT:    setnp %al # sched: [1:0.50]
; BTVER2-NEXT:    sete %dl # sched: [1:0.50]
; BTVER2-NEXT:    andb %al, %dl # sched: [1:0.50]
; BTVER2-NEXT:    orb %cl, %dl # sched: [1:0.50]
; BTVER2-NEXT:    movzbl %dl, %eax # sched: [1:0.50]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_ucomiss:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    ucomiss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    sete %cl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    andb %al, %cl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    ucomiss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-SSE-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    sete %dl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    andb %al, %dl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    orb %cl, %dl # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_ucomiss:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vucomiss %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-NEXT:    sete %cl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %cl # sched: [1:0.25]
; ZNVER1-NEXT:    vucomiss (%rdi), %xmm0 # sched: [10:1.00]
; ZNVER1-NEXT:    setnp %al # sched: [1:0.25]
; ZNVER1-NEXT:    sete %dl # sched: [1:0.25]
; ZNVER1-NEXT:    andb %al, %dl # sched: [1:0.25]
; ZNVER1-NEXT:    orb %cl, %dl # sched: [1:0.25]
; ZNVER1-NEXT:    movzbl %dl, %eax # sched: [1:0.25]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = call i32 @llvm.x86.sse.ucomieq.ss(<4 x float> %a0, <4 x float> %a1)
  %2 = load <4 x float>, <4 x float> *%a2, align 4
  %3 = call i32 @llvm.x86.sse.ucomieq.ss(<4 x float> %a0, <4 x float> %2)
  %4 = or i32 %1, %3
  ret i32 %4
}
declare i32 @llvm.x86.sse.ucomieq.ss(<4 x float>, <4 x float>) nounwind readnone

define <4 x float> @test_unpckhps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_unpckhps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; GENERIC-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_unpckhps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; ATOM-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_unpckhps:
; SLM:       # %bb.0:
; SLM-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SLM-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [4:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_unpckhps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SANDY-SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_unpckhps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SANDY-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_unpckhps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; HASWELL-SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_unpckhps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; HASWELL-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_unpckhps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [6:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_unpckhps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; BROADWELL-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [6:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_unpckhps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_unpckhps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SKYLAKE-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_unpckhps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SKX-SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_unpckhps:
; SKX:       # %bb.0:
; SKX-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:1.00]
; SKX-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [7:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_unpckhps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:0.50]
; BTVER2-SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [6:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_unpckhps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:0.50]
; BTVER2-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [6:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_unpckhps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    unpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    unpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_unpckhps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vunpckhps {{.*#+}} xmm0 = xmm0[2],xmm1[2],xmm0[3],xmm1[3] sched: [1:0.50]
; ZNVER1-NEXT:    vunpckhps {{.*#+}} xmm1 = xmm1[2],mem[2],xmm1[3],mem[3] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = shufflevector <4 x float> %a1, <4 x float> %2, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}

define <4 x float> @test_unpcklps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_unpcklps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; GENERIC-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; GENERIC-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_unpcklps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; ATOM-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [1:1.00]
; ATOM-NEXT:    addps %xmm1, %xmm0 # sched: [5:5.00]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_unpcklps:
; SLM:       # %bb.0:
; SLM-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SLM-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [4:1.00]
; SLM-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_unpcklps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SANDY-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; SANDY-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_unpcklps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SANDY-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; SANDY-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_unpcklps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; HASWELL-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; HASWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_unpcklps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; HASWELL-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; HASWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_unpcklps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; BROADWELL-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [6:1.00]
; BROADWELL-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_unpcklps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; BROADWELL-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [6:1.00]
; BROADWELL-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_unpcklps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SKYLAKE-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; SKYLAKE-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_unpcklps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SKYLAKE-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; SKYLAKE-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_unpcklps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SKX-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; SKX-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [4:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_unpcklps:
; SKX:       # %bb.0:
; SKX-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:1.00]
; SKX-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [7:1.00]
; SKX-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [4:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_unpcklps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:0.50]
; BTVER2-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [6:1.00]
; BTVER2-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_unpcklps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:0.50]
; BTVER2-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [6:1.00]
; BTVER2-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_unpcklps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    unpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:0.50]
; ZNVER1-SSE-NEXT:    unpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [8:0.50]
; ZNVER1-SSE-NEXT:    addps %xmm1, %xmm0 # sched: [3:1.00]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_unpcklps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vunpcklps {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1] sched: [1:0.50]
; ZNVER1-NEXT:    vunpcklps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[1],mem[1] sched: [8:0.50]
; ZNVER1-NEXT:    vaddps %xmm1, %xmm0, %xmm0 # sched: [3:1.00]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = shufflevector <4 x float> %a0, <4 x float> %a1, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %2 = load <4 x float>, <4 x float> *%a2, align 16
  %3 = shufflevector <4 x float> %a1, <4 x float> %2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %4 = fadd <4 x float> %1, %3
  ret <4 x float> %4
}

define <4 x float> @test_xorps(<4 x float> %a0, <4 x float> %a1, <4 x float> *%a2) {
; GENERIC-LABEL: test_xorps:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    xorps %xmm1, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    xorps (%rdi), %xmm0 # sched: [7:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_xorps:
; ATOM:       # %bb.0:
; ATOM-NEXT:    xorps %xmm1, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    xorps (%rdi), %xmm0 # sched: [1:1.00]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_xorps:
; SLM:       # %bb.0:
; SLM-NEXT:    xorps %xmm1, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    xorps (%rdi), %xmm0 # sched: [4:1.00]
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_xorps:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    xorps %xmm1, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    xorps (%rdi), %xmm0 # sched: [7:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_xorps:
; SANDY:       # %bb.0:
; SANDY-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_xorps:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    xorps %xmm1, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    xorps (%rdi), %xmm0 # sched: [7:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_xorps:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [7:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_xorps:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    xorps %xmm1, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    xorps (%rdi), %xmm0 # sched: [6:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_xorps:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_xorps:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    xorps %xmm1, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    xorps (%rdi), %xmm0 # sched: [7:0.50]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_xorps:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_xorps:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    xorps %xmm1, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    xorps (%rdi), %xmm0 # sched: [7:0.50]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_xorps:
; SKX:       # %bb.0:
; SKX-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [7:0.50]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_xorps:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    xorps %xmm1, %xmm0 # sched: [1:0.50]
; BTVER2-SSE-NEXT:    xorps (%rdi), %xmm0 # sched: [6:1.00]
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_xorps:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:0.50]
; BTVER2-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [6:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_xorps:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    xorps %xmm1, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    xorps (%rdi), %xmm0 # sched: [8:0.50]
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_xorps:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vxorps %xmm1, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    vxorps (%rdi), %xmm0, %xmm0 # sched: [8:0.50]
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  %1 = bitcast <4 x float> %a0 to <4 x i32>
  %2 = bitcast <4 x float> %a1 to <4 x i32>
  %3 = xor <4 x i32> %1, %2
  %4 = load <4 x float>, <4 x float> *%a2, align 16
  %5 = bitcast <4 x float> %4 to <4 x i32>
  %6 = xor <4 x i32> %3, %5
  %7 = bitcast <4 x i32> %6 to <4 x float>
  ret <4 x float> %7
}

; 'WriteZero' and 'WriteNop' class instructions.

define <4 x float> @test_fnop() nounwind {
; GENERIC-LABEL: test_fnop:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    nop # sched: [1:0.25]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    xorps %xmm0, %xmm0 # sched: [1:1.00]
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_fnop:
; ATOM:       # %bb.0:
; ATOM-NEXT:    xorps %xmm0, %xmm0 # sched: [1:0.50]
; ATOM-NEXT:    #APP
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    nop # sched: [1:0.50]
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_fnop:
; SLM:       # %bb.0:
; SLM-NEXT:    xorps %xmm0, %xmm0 # sched: [1:0.50]
; SLM-NEXT:    #APP
; SLM-NEXT:    nop # sched: [1:0.50]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-SSE-LABEL: test_fnop:
; SANDY-SSE:       # %bb.0:
; SANDY-SSE-NEXT:    #APP
; SANDY-SSE-NEXT:    nop # sched: [1:0.25]
; SANDY-SSE-NEXT:    #NO_APP
; SANDY-SSE-NEXT:    xorps %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-SSE-NEXT:    retq # sched: [1:1.00]
;
; SANDY-LABEL: test_fnop:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    nop # sched: [1:0.25]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # sched: [1:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-SSE-LABEL: test_fnop:
; HASWELL-SSE:       # %bb.0:
; HASWELL-SSE-NEXT:    #APP
; HASWELL-SSE-NEXT:    nop # sched: [1:0.25]
; HASWELL-SSE-NEXT:    #NO_APP
; HASWELL-SSE-NEXT:    xorps %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; HASWELL-LABEL: test_fnop:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    nop # sched: [1:0.25]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # sched: [1:1.00]
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-SSE-LABEL: test_fnop:
; BROADWELL-SSE:       # %bb.0:
; BROADWELL-SSE-NEXT:    #APP
; BROADWELL-SSE-NEXT:    nop # sched: [1:0.25]
; BROADWELL-SSE-NEXT:    #NO_APP
; BROADWELL-SSE-NEXT:    xorps %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-SSE-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_fnop:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    nop # sched: [1:0.25]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # sched: [1:1.00]
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-SSE-LABEL: test_fnop:
; SKYLAKE-SSE:       # %bb.0:
; SKYLAKE-SSE-NEXT:    #APP
; SKYLAKE-SSE-NEXT:    nop # sched: [1:0.17]
; SKYLAKE-SSE-NEXT:    #NO_APP
; SKYLAKE-SSE-NEXT:    xorps %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_fnop:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    nop # sched: [1:0.17]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # sched: [1:0.33]
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-SSE-LABEL: test_fnop:
; SKX-SSE:       # %bb.0:
; SKX-SSE-NEXT:    #APP
; SKX-SSE-NEXT:    nop # sched: [1:0.17]
; SKX-SSE-NEXT:    #NO_APP
; SKX-SSE-NEXT:    xorps %xmm0, %xmm0 # sched: [1:0.33]
; SKX-SSE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_fnop:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    nop # sched: [1:0.17]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # sched: [1:0.33]
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-SSE-LABEL: test_fnop:
; BTVER2-SSE:       # %bb.0:
; BTVER2-SSE-NEXT:    xorps %xmm0, %xmm0 # sched: [0:0.50]
; BTVER2-SSE-NEXT:    #APP
; BTVER2-SSE-NEXT:    nop # sched: [1:0.50]
; BTVER2-SSE-NEXT:    #NO_APP
; BTVER2-SSE-NEXT:    retq # sched: [4:1.00]
;
; BTVER2-LABEL: test_fnop:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # sched: [0:0.50]
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    nop # sched: [1:0.50]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-SSE-LABEL: test_fnop:
; ZNVER1-SSE:       # %bb.0:
; ZNVER1-SSE-NEXT:    xorps %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    #APP
; ZNVER1-SSE-NEXT:    nop # sched: [1:0.25]
; ZNVER1-SSE-NEXT:    #NO_APP
; ZNVER1-SSE-NEXT:    retq # sched: [1:0.50]
;
; ZNVER1-LABEL: test_fnop:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    vxorps %xmm0, %xmm0, %xmm0 # sched: [1:0.25]
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    nop # sched: [1:0.25]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  tail call void asm sideeffect "nop", ""() nounwind
  ret <4 x float> zeroinitializer
}

!0 = !{i32 1}
