<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Les drapeaux de rcriture - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Les drapeaux de rcriture</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/flags.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/flags.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>

<p>Ce document dcrit les drapeaux disponibles dans la directive
<code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>, en fournissant
des explications dtailles et des exemples.</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#introduction">Introduction</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_b">B (chappement dans les rfrences arrires)</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_c">C|chain</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_co">CO|cookie</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_dpi">DPI|discardpath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_e">E|env</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_end">END</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_f">F|forbidden</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_g">G|gone</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_h">H|handler</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_l">L|last</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_n">N|next</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_nc">NC|nocase</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_ne">NE|noescape</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_ns">NS|nosubreq</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_p">P|proxy</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_pt">PT|passthrough</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_qsa">QSA|qsappend</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_qsd">QSD|qsdiscard</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_qsl">QSL|qslast</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_r">R|redirect</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_s">S|skip</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#flag_t">T|type</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du module</a></li><li><a href="intro.html">Introduction  mod_rewrite</a></li><li><a href="remapping.html">Redirection and remise en
correspondance</a></li><li><a href="access.html">Contrle d'accs</a></li><li><a href="vhosts.html">Serveurs virtuels</a></li><li><a href="proxy.html">Mise en cache</a></li><li><a href="rewritemap.html">Utilisation de RewriteMap</a></li><li><a href="advanced.html">Techniques avances</a></li><li><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></li><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="introduction" id="introduction">Introduction</a></h2>
<p>Le comportement d'une directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> peut tre modifi par un ou
plusieurs drapeaux. Les drapeaux sont situs en fin de rgle, entours
de crochets, et spars le cas chant par des virgules.</p>
<pre class="prettyprint lang-config">RewriteRule pattern target [Flag1,Flag2,Flag3]</pre>


<p>Chaque drapeau ( quelques exceptions prs)
possde une forme courte, comme <code>CO</code>, ainsi qu'une forme longue,
comme <code>cookie</code>. Bien que
la forme courte soit la plus couramment utilise, nous vous recommandons
de vous familiariser avec les drapeaux sous leur forme longue, afin de
bien mmoriser ce que chaque drapeau est suppos faire.
Certains drapeaux acceptent un ou plusieurs arguments. Les drapeaux ne
sont pas sensibles  la casse.</p>

<p>Les drapeaux qui modifient les mtadonnes associes  la requte
(T=, H=, E=) n'ont aucun effet dans un contexte de rpertoire ou de
fichier htaccess, lorsqu'une substitution (autre que '-') est effectue
au cours de la mme passe du processus de rcriture.
</p>

<p>Chaque drapeau disponible est prsent ici, avec un exemple
d'utilisation.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_b" id="flag_b">B (chappement dans les rfrences arrires)</a></h2>
<p>Avec le drapeau [B], la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> chappe les caractres
non-alphanumriques avant d'appliquer la transformation.</p>

<p><code>mod_rewrite</code> doit supprimer les squences d'chappement
des URLs avant leur
mise en correspondance avec le systme de fichiers ; les squences
d'chappement sont donc supprimes des rfrences arrires au moment o
ces dernires sont appliques. Avec le drapeau B, les caractres
non-alphanumriques des rfrences arrires seront chapps. Considrons
par exemple cette rgle :</p>

<pre class="prettyprint lang-config">RewriteRule "^search/(.*)$" "/search.php?term=$1"</pre>


<p>Soit le terme de recherche 'x &amp; y/z' ; un navigateur va le coder
en 'x%20%26%20y%2Fz', transformant la requte en
'search/x%20%26%20y%2Fz'. Sans le drapeau B, cette rgle de rcriture
va rcrire la requte en 'search.php?term=x &amp; y/z', ce qui ne
correspond pas  une URL valide et cette dernire sera encode en
<code>search.php?term=x%20&amp;y%2Fz=</code>, ce qui ne correspond pas 
ce que l'on souhaitait.</p>

<p>Avec le drapeau B, les paramtres sont rencods avant d'tre passs
 l'URL rsultante, ce qui fournit une rcriture correcte en
<code>/search.php?term=x%20%26%20y%2Fz</code>.</p>

<p>Notez que vous devrez peut-tre aussi dfinir la
directive <code class="directive"><a href="../mod/core.html#allowencodedslashes">AllowEncodedSlashes</a></code>
 <code>On</code> pour
que cet exemple particulier fonctionne, car httpd ne permet pas les
slashes encods dans les URLs, et renvoie une erreur 404 s'il en
rencontre un.</p>

<p>Ce processus d'chappement est en particulier ncessaire dans le
contexte d'un mandataire, o l'accs au serveur d'arrire-plan chouera
si on prsente  ce dernier une URL non chappe.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_c" id="flag_c">C|chain</a></h2>
<p>Le drapeau [C] ou [chain] indique que la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est chane avec la
suivante. Autrement dit, si la rgle s'applique, elle est traite
normalement et passe le contrle  la rgle suivante. Par contre, si
elle ne s'applique pas, la rgle suivante, ainsi que toutes les rgles
chanes qui suivent, seront sautes.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_co" id="flag_co">CO|cookie</a></h2>
<p>Le drapeau [CO], ou [cookie], vous permet de dfinir un cookie
lorsqu'une rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>
s'applique. Il possde trois arguments obligatoires et
quatre arguments optionnels.</p>

<p>La syntaxe complte de ce drapeau, avec tous ses attributs, est la
suivante :</p>

<div class="example"><p><code>
[CO=NAME:VALUE:DOMAIN:lifetime:path:secure:httponly]
</code></p></div>

<p>Si un caractre littral ':' doit tre insrer dans un des champs du
cookie, une autre syntaxe est disponible. Pour utiliser cette syntaxe
alternative, le contenu du champ "Name" doit tre prcd du caractre
';', et les spateurs de champs deviendront des ';'.</p>

<div class="example"><p><code>
[CO=;NAME;VALUE:MOREVALUE;DOMAIN;lifetime;path;secure;httponly]
</code></p></div>

<p>Vous devez dclarer un nom, une valeur et un domaine pour que
le cookie puisse tre dfini.</p>


<dl>
<dt>Domain</dt>
<dd>Le domaine pour lequel vous souhaitez que le cookie soit valide. Ce
peut tre un nom de serveur, comme <code>www.example.com</code>, ou un
domaine, comme <code>.example.com</code>. Il doit comporter au moins
deux parties spares par un point. C'est  dire que vous ne pouvez pas
utiliser les valeurs <code>.com</code> ou <code>.net</code>. En effet,
ce style de cookie est interdit par le modle de scurit des cookies.</dd>
</dl>

<p>Vous pouvez aussi dfinir les valeurs suivantes :</p>

<dl>
<dt>Lifetime</dt>
<dd>La dure de vie du cookie, en minutes.</dd>
<dd>Une valeur de 0 indique une dure de vie correspondant  la session
courante du navigateur. Il s'agit de la valeur par dfaut.</dd>

<dt>Path</dt>
<dd>Le chemin, sur le site web concern, pour lequel le cookie est
valide, du style <code>/clients/</code> or
<code>/fichiers/telechargement/</code>.</dd>
<dd>La valeur par dfaut est <code>/</code> - c'est  dire l'ensemble du
site web.</dd>

<dt>Secure</dt>
<dd>Si cet argument a pour valeur <code>secure</code>,
<code>true</code>, ou <code>1</code>, le cookie ne pourra tre transmis
que dans le cadre d'une connexion scurise (https).</dd>

<dt>httponly</dt>
<dd>Si cet argument a pour valeur <code>HttpOnly</code>,
<code>true</code>, ou <code>1</code>, le cookie aura son drapeau
<code>HttpOnly</code> activ, ce qui signifie qu'il sera inaccessible au
code JavaScript pour les navigateurs qui supportent cette
fonctionnalit.</dd>
</dl>

<p>Voici un exemple :</p>

<pre class="prettyprint lang-config">RewriteEngine On
RewriteRule "^/index\.html" "-" [CO=frontdoor:yes:.example.org:1440:/]</pre>


<p>Dans l'exemple ci-dessus, la rgle ne rcrit
pas la requte. La cible de rcriture "-"
indique  mod_rewrite de transmettre la requte sans
modification. Par contre, il
dfinit un cookie nomm 'frontdoor' avec une valeur 'yes'. Le cookie est
valide pour tout hte situ dans le domaine <code>.example.org</code>. Sa
dure de vie est limite  1440 minutes (24 heures), et il sera renvoy
pour tous les URIs.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_dpi" id="flag_dpi">DPI|discardpath</a></h2>
<p>Avec le drapeau DPI, la partie PATH_INFO de l'URI
rcrit est supprime.</p>
<p>Ce drapeau est disponible dans les versions 2.2.12 et suprieures.</p>
<p>Dans un contexte de rpertoire, l'URI mis en comparaison par chaque
rgle <code class="directive">RewriteRule</code> est la concatnation des
valeurs courantes de l'URI et de PATH_INFO.</p>

<p>L'URI courant peut tre l'URI initial tel qu'il a t fourni par le
client, le rsultat d'une passe prcdente du processus de rcriture,
ou le rsultat de la rgle prcdente dans le processus courant de
rcriture.</p>

<p>Par contre, la partie PATH_INFO ajoute  l'URI avant chaque rgle ne
reflte que la valeur de PATH_INFO avant la passe courante du processus
de rcriture. En consquence, si de larges portions de l'URI
correspondent et sont traduites via plusieurs directives
<code class="directive">RewriteRule</code>, sans prendre en compte
quelles parties de l'URI provenaient du PATH_INFO courant, l'URI final
pourra se voir ajouter plusieurs copies de PATH_INFO.</p>

<p>Utilisez ce drapeau pour toute substitution o la prsence du PATH_INFO qui
rsultait de la mise en correspondance prcdente de cette requte avec
le systme de fichier n'est pas ncessaire. Avec ce drapeau, le
PATH_INFO tabli avant que cette passe du processus de rcriture ne
dbute est oubli. PATH_INFO ne sera pas recalcul tant que la passe
courante du processus de rcriture ne sera pas acheve. Les rgles
suivantes de cette passe ne verront que le rsultat direct des
substitutions, sans aucun PATH_INFO ajout.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_e" id="flag_e">E|env</a></h2>
<p>Avec le drapeau [E], ou [env], vous pouvez dfinir la valeur d'une
variable d'environnement. Notez que certaines variables d'environnement
peuvent tre dfinies aprs le traitement de la rgle, annulant par
la-mme ce que vous avez dfini. Voir le <a href="../env.html">document
sur les variables d'environnement</a> pour plus de dtails sur le
fonctionnement des variables d'environnement.</p>

<p>La syntaxe complte pour ce drapeau est :</p>

<pre class="prettyprint lang-config">[E=!VAR]</pre>


<p><code>VAL</code> peut comporter des rfrences arrires
(<code>$N</code> ou <code>%N</code>) qui seront dveloppes.</p>

<p>En utilisant la version courte</p>

<div class="example"><p><code>
[E=VAR]
</code></p></div>

<p>vous pouvez dfinir la variable d'environnement nomme
<code>VAR</code> avec une valeur vide.</p>

<p>La forme</p>

<div class="example"><p><code>
[E=!VAR]
</code></p></div>

<p>permet d'annuler la dfinition de la variable <code>VAR</code>.</p>

<p>Les variables d'environnement s'emploient dans diffrents contextes,
comme les programmes CGI, d'autres directives RewriteRule, ou des
directives CustomLog.</p>

<p>L'exemple suivant dfinit une variable d'environnement nomme 'image'
avec une valeur de '1' si l'URI de la requte correspond  un fichier
image. Cette variable d'environnement est ensuite utilise pour exclure
une telle requte du journal des accs.</p>

<div class="example"><p><code>
RewriteRule "\.(png|gif|jpg)" "-" [E=image:1]<br />
CustomLog "logs/access_log" combined env=!image
</code></p></div>

<p>Notez que le mme effet peut tre obtenu  l'aide de la directive
<code class="directive"><a href="../mod/mod_setenvif.html#setenvif">SetEnvIf</a></code>. Cette technique
est prsente  titre d'exemple et non de recommandation.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_end" id="flag_end">END</a></h2>
<p>L'utilisation du drapeau [END] permet non seulement de terminer le
processus de rcriture en cours (comme [L]), mais aussi d'empcher tout
processus de rcriture ultrieur dans un contexte de rpertoire
(htaccess).</p>

<p>Ceci ne s'applique pas aux nouvelles requtes rsultant d'une
redirection externe.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_f" id="flag_f">F|forbidden</a></h2>
<p>L'utilisation du drapeau [F] permet de faire envoyer par le serveur au
client un code de statut "403 Forbidden". Le mme effet peut tre obtenu 
l'aide de la directive <code class="directive"><a href="../mod/mod_access_compat.html#deny">Deny</a></code>,
mais ce drapeau offre plus de souplesse dans l'attribution d'un statut
Forbidden.</p>

<p>La rgle suivante va interdire la tlchargement de fichiers
<code>.exe</code> depuis votre serveur.</p>

<pre class="prettyprint lang-config">RewriteRule "\.exe" "-" [F]</pre>


<p>Cet exemple utilise la syntaxe "-" pour la cible de rcriture, ce
qui signifie que l'URI de la requte n'est pas modifi. Il n'y a aucune
raison de rcrire un URI, si vous avez l'intention d'interdire la
requte.</p>

<p>Lorsqu'on utilise [F], [L] est implicite - c'est  dire que la
rponse est renvoye immdiatement, et aucune autre rgle n'est value.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_g" id="flag_g">G|gone</a></h2>
<p>Le drapeau [G] permet de faire envoyer par le serveur un code de statut
"410 Gone" avec la rponse. Ce code indique qu'une ressource qui tait
disponible auparavant ne l'est plus actuellement.</p>

<p>Comme dans le cas du drapeau [F], on utilise en gnral la syntaxe
"-" pour la cible de rcriture lorsqu'on utilise le drapeau [G] :</p>

<pre class="prettyprint lang-config">RewriteRule "oldproduct" "-" [G,NC]</pre>


<p>Lorsqu'on utilise [G], [L] est implicite - c'est  dire que la
rponse est renvoye immdiatement, et aucune autre rgle n'est value.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_h" id="flag_h">H|handler</a></h2>
<p>Force le traitement de la requte rsultante par le gestionnaire
spcifi. Par exemple, on peut utiliser ce drapeau pour forcer
l'interprtation de tous les fichiers sans extension par le gestionnaire
php :</p>

<pre class="prettyprint lang-config">RewriteRule "!\." "-" [H=application/x-httpd-php]</pre>


<p>
L'expression rationnelle ci-dessus - <code>!\.</code> - correspond 
toute requte qui ne contient pas le caractre <code>.</code>.
</p>
<p>On peut aussi utiliser ce drapeau pour forcer l'utilisation d'un
certain gestionnaire en fonction de certaines conditions. Par exemple,
l'extrait suivant utilis dans un contexte de niveau serveur permet de
faire en sorte que les fichiers <code>.php</code> soient
<em>affichs</em> par <code>mod_php</code> dans le cas o ils font
l'objet d'une requte avec l'extension <code>.phps</code> :</p>

<pre class="prettyprint lang-config">RewriteRule "^(/source/.+\.php)s$" "$1" [H=application/x-httpd-php-source]</pre>



<p>L'expression rationnelle ci-dessus -
<code>^(/source/.+\.php)s$</code> - va correspondre  toute requte qui
dbutera par <code>/source/</code>, continuera par 1 ou n caractres
puis par <code>.phps</code>. La rfrence arrire $1 fait rfrence  la
correspondance capture entre parenthses de l'expression
rationnelle.</p>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_l" id="flag_l">L|last</a></h2>
<p>Lorsque le drapeau [L] est prsent, <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>
arrte le traitement du jeu de rgles. Cela signifie dans la plupart des
situations que si la rgle s'applique, aucune autre rgle ne sera
traite. Ce drapeau correspond  la commande Perl <code>last</code>, ou
 la commande <code>break</code> en C. Utilisez ce drapeau pour indiquer
que la rgle courante doit tre applique immdiatement, sans tenir
compte des rgles ultrieures.</p>

<p>Si vous utilisez des rgles <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> dans des fichiers
<code>.htaccess</code> ou des sections <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code>, il est important d'avoir quelques
notions sur la manire dont les rgles sont traites. Pour simplifier,
une fois les rgles traites, la requte rcrite est passe  nouveau
au moteur d'interprtation des URLs afin que ce dernier puisse la
traiter. Il est possible qu'au cours du traitement de la requte
rcrite, le fichier <code>.htaccess</code> ou la section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> soient  nouveau
rencontrs, entranant un nouveau traitement du jeu de rgles depuis le
dbut. Cette situation se prsente le plus souvent lorsqu'une des rgles
provoque une redirection - interne ou externe - ce qui rinitialise le
traitement de la requte.</p>

<p>Si vous utilisez des directives <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> dans un de ces contextes,
il importe par consquent de prvoir explicitement des tapes permettant
d'viter un bouclage infini sur les rgles,
et de ne pas compter seulement sur
le drapeau [L] pour terminer l'excution d'une srie de rgles, comme
dcrit ci-dessous.</p>

<p>Un autre drapeau, [END], permet non seulement d'interrompre le cycle
courant du processus de rcriture, mais aussi d'empcher toute
rcriture ultrieure dans le contexte de rpertoire (htaccess). Ceci ne
s'applique pas aux nouvelles requtes rsultant de redirections
externes.</p>

<p>Dans l'exemple donn ici, toute requte est rcrite en
<code>index.php</code>, la requte originale tant ajoute comme chane
de requte en argument  <code>index.php</code> ; cependant, la
directive <code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> permet de s'assurer que si
la requte concerne dj <code>index.php</code>, la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> sera saute.</p>

<pre class="prettyprint lang-config">RewriteBase "/"
RewriteCond "%{REQUEST_URI}" "!=/index.php"
RewriteRule "^(.*)" "/index.php?req=$1" [L,PT]</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_n" id="flag_n">N|next</a></h2>
<p>Le drapeau [N] provoque un redmarrage du traitement des rgles
depuis le dbut, en utilisant le rsultat du jeu de rgles, sous
rserve qu'il existe un point de dmarrage ;  utiliser avec prcautions
car il peut provoquer un bouclage infini.
</p>
<p>
Le drapeau [Next] peut servir, par exemple,
 remplacer de manire rptitive
une chane de caractre ou une lettre dans une requte. Dans l'exemple
suivant, chaque occurence de A sera remplace par B dans la requte, et
ceci jusqu'il n'y ait plus de A  remplacer.
</p>

<pre class="prettyprint lang-config">RewriteRule "(.*)A(.*)" "$1B$2" [N]</pre>


<p>Vous pouvez vous reprsenter ce traitement comme une boucle
<code>while</code> : tant que le modle de la rgle correspond (c'est 
dire, tant que l'URI contient un <code>A</code>),
effectuer la substitution (c'est  dire, remplacer le <code>A</code> par
un <code>B</code>).</p>

<p>A partir de la version 2.4.8, ce module renvoie une erreur aprs
32000 itrations afin d'viter les boucles infinies. Ce nombre maximum
d'itration peut tre modifi via le drapeau N.</p>
<pre class="prettyprint lang-config"># On veut remplacer 1 caractre  chaque itration de la boucle
RewriteRule "(.+)[&gt;&lt;;]$" "$1" [N=64000]
# ... ou s'arrter aprs 10 itrations
RewriteRule "(.+)[&gt;&lt;;]$" "$1" [N=10]</pre>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_nc" id="flag_nc">NC|nocase</a></h2>
<p>Avec le drapeau [NC], le modle de la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est compar  la requte de
manire insensible  la casse. C'est  dire que cette comparaison
s'effectue sans tenir compte des majuscules/minuscules dans l'URI
compar.</p>

<p>Dans l'exemple suivant, toute requte pour un fichier image sera
transmise par Apache  votre serveur d'images ddi. La correspondance est
insensible  la casse, si bien que par exemple, <code>.jpg</code> aussi
bien que <code>.JPG</code> seront accepts.</p>

<pre class="prettyprint lang-config">RewriteRule "(.*\.(jpg|gif|png))$" "http://images.example.com$1" [P,NC]</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_ne" id="flag_ne">NE|noescape</a></h2>
<p>Par dfaut, les caractres spciaux, comme <code>&amp;</code> et
<code>?</code>, sont convertis en leur quivalent
hexadcimal. Le drapeau [NE] permet d'viter cette conversion.
</p>

<pre class="prettyprint lang-config">RewriteRule "^/anchor/(.+)" "/bigpage.html#$1" [NE,R]</pre>


<p>
Dans l'exemple ci-dessus, <code>/anchor/xyz</code> est rcrit en
<code>/bigpage.html#xyz</code>. En l'absence du drapeau [NE], le #
aurait t converti en son quivalent hexadcimal, <code>%23</code>, ce
qui aurait provoqu un code d'erreur "404 Not Found".
</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_ns" id="flag_ns">NS|nosubreq</a></h2>
<p>Le drapeau [NS] empche la rgle de s'appliquer aux sous-requtes.
Par exemple, une page incluse au moyen d'une SSI (Server
Side Include) est une sous-requte, et vous ne voudrez probablement pas que
la rcriture s'applique  ces sous-requtes. Ainsi, lorsque
<code class="module"><a href="../mod/mod_dir.html">mod_dir</a></code> recherche des informations  propos des
fichiers par dfaut du rpertoire (comme les fichiers
<code>index.html</code>), il s'agit d'une sous-requte interne, et vous
ne dsirez en gnral pas que ces sous-requtes soient rcrites. Cette
rcriture
n'est pas toujours utile pour les sous-requtes, et peut mme causer des
erreurs si l'ensemble du jeu de rgles est appliqu. L'utilisation de
ce drapeau permet d'exclure les rgles qui peuvent poser problme.</p>

<p>Comment dterminer si vous devez utiliser cette rgle ou non : si
vous prfixez les URLs avec des scripts CGI, afin de forcer leur
traitement par le script CGI, vous vous exposez  des problmes (ou du
moins  une surcharge significative) avec les sous-requtes. Dans ces
cas, vous devez utiliser ce drapeau.</p>

<p>
Les images, scripts java, ou fichiers css, chargs en tant que partie
d'une page html, ne sont pas des sous-requtes - le navigateur les
appelle sous forme de requtes HTTP  part entire.
</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_p" id="flag_p">P|proxy</a></h2>
<p>L'utilisation du drapeau [P] entrane le traitement de la requte par
le module <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, et ceci via une requte de
mandataire. Par exemple, si vous voulez que toutes les requtes d'images
soient traites par un serveur d'images annexe, vous pouvez utiliser
une rgle de ce style :</p>

<pre class="prettyprint lang-config">RewriteRule "/(.*)\.(jpg|gif|png)$" "http://images.example.com/$1.$2" [P]</pre>


<p>L'utilisation du drapeau [P] provoque aussi l'effet du drapeau [L] -
autrement dit, la requte est immdiatement envoye au mandataire, et
toute rgle ultrieure sera ignore.</p>

<p>
Vous devez vous assurer que la chane de substitution soit un URI valide
(commenant typiquement par <code>http://</code><em>nom-serveur</em>)
qui puisse tre traite par le module <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>. Dans
le cas contraire, le module mandataire vous renverra une erreur.
L'utilisation de ce drapeau implmente de manire plus puissante la
directive <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code>, pour
faire correspondre le contenu distant  l'espace de nommage du serveur
local.</p>

<div class="warning">
      <h3>Avertissement  propos de la scurit</h3>
      <p>Lors de la construction de l'URL cible de la rgle, il convient
      de prendre en compte l'impact en matire de scurit qu'aura le
      fait de permettre au client d'influencer le jeu d'URLs pour
      lesquelles votre serveur agira en tant que mandataire.
      Assurez-vous que la partie protocole://nom-serveur de l'URL soit
      fixe, ou ne permette pas au client de l'influencer induement.</p>
</div>

<div class="warning">
      <h3>Avertissement au sujet des performances</h3>
      <p>Utiliser ce drapeau fait intervenir <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> sans la gestion des connexions
      persistantes, ce qui signifie que vous obtiendrez des performances meilleurs si vous utilisez
      <code class="directive"><a href="../mod/mod_proxy.html#proxypass">ProxyPass</a></code> ou <code class="directive"><a href="../mod/mod_proxy.html#proxypassmatch">ProxyPassMatch</a></code>.</p>
      <p>Ceci est du au fait que ce drapeau induit l'utilisation du worker par dfaut, qui
      ne gre pas la mise en commun des connexions.</p>
      <p>Partout o cela est possible, prfrez l'utilisation de ces directives.</p>
</div>

<p>Note: <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> doit tre activ pour pouvoir
utiliser ce drapeau.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_pt" id="flag_pt">PT|passthrough</a></h2>

<p>
Par dfaut, la cible (ou chane de substitution) d'une rgle
RewriteRule est sense tre un chemin de fichier. Avec le drapeau [PT],
par contre, elle est traite comme un URI. Autrement dit, avec le
drapeau [PT], le rsultat de la rgle  <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est pass  nouveau au
systme de mise en correspondance des URLs avec le systme de fichiers,
de faon  ce que les systmes de mise en correspondance bass sur les
chemins de fichiers, comme la directive <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code>, <code class="directive"><a href="../mod/mod_alias.html#redirect">Redirect</a></code>, ou <code class="directive"><a href="../mod/mod_alias.html#scriptalias">ScriptAlias</a></code>, par exemple, puissent avoir une
chance d'accomplir leur tche.
</p>

<p>
Si par exemple, vous avez un <code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code> pour /icons, et une rgle  <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> qui renvoie vers /icons,
vous devez utiliser le drapeau [PT] pour tre sr que l'<code class="directive"><a href="../mod/mod_alias.html#alias">Alias</a></code> sera bien valu.
</p>

<pre class="prettyprint lang-config">Alias "/icons" "/usr/local/apache/icons"
RewriteRule "/pics/(.+)\.jpg$" "/icons/$1.gif" [PT]</pre>


<p>
Dans l'exemple prcdent, en l'absence du drapeau [PT], l'Alias aurait
t ignor, ce qui aurait provoqu une erreur 'File not found'.
</p>

<p>Avec le drapeau <code>PT</code>, le drapeau <code>L</code> est
implicite : la rcriture s'arrtera afin de transmettre la requte  la
phase suivante du traitement.</p>

<p>Notez que le drapeau <code>PT</code> est implicite dans des contextes
de rpertoire comme les sections <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> ou les fichiers
<code>.htaccess</code>. Le seul moyen de contourner ceci consiste 
rcrire vers <code>-</code>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_qsa" id="flag_qsa">QSA|qsappend</a></h2>
<p>
Quand l'URI de remplacement contient une chane de requte, le
comportement par dfaut de la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> est de supprimer la <code>
query string</code> (il s'agit des paramtres ventuellement passs dans l'URL aprs le
caractre <code>?</code>, usuellement pour les formulaires traits par la
mthode HTTP <code>GET</code>) existante, et de la remplacer par celle nouvellement cre.
Avec le drapeau [QSA], les chanes de requte peuvent tre combines.
</p>

<p>Considrons la rgle suivante :</p>

<pre class="prettyprint lang-config">RewriteRule "/pages/(.+)" "/page.php?page=$1" [QSA]</pre>


<p>Avec le drapeau [QSA], une requte pour
<code>/pages/123?one=two</code> sera rcrite en
<code>/page.php?page=123&amp;one=two</code>. Sans le drapeau [QSA], la
mme requte sera rcrite en <code>/page.php?page=123</code> -
autrement dit, la chane de requte (<code>query string</code>) existante sera supprime.
</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_qsd" id="flag_qsd">QSD|qsdiscard</a></h2>
<p>
Lorsque l'URI de la requte contient une chane de paramtres, et si
l'URI cible n'en contient pas, le comportement par dfaut de la
directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> consiste  copier cette
chane de paramtres dans l'URI cible. Avec le drapeau [QSD], la chane
de paramtres est supprime.
</p>

<p>Ce drapeau est disponible dans les versions 2.4.0 et suprieures.</p>

<p>
Lorsque les drapeaux [QSD] et [QSA] sont utiliss ensemble, c'est le
drapeau [QSD] qui l'emporte.
</p>

<p>
Si l'URI cible possde une chane de paramtres, le comportement par
dfaut sera respect - c'est  dire que la chane de paramtres
originale sera supprime et remplace par la chane de paramtres de
l'URI cible.
</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_qsl" id="flag_qsl">QSL|qslast</a></h2>
<p>
Par dfaut, le premier (le plus  gauche) point d'interrogation de la
substitution spare le chemin de la requte de sa chane de paramtres. Avec le
drapeau [QSL] au contraire, les deux composants seront spars en utilisant le
dernier (le plus  droite) point d'interrogation.</p>

<p>
Cela peut s'avrer utile lorsqu'on recherche un fichier dont le nom contient des
points d'interrogation. Si aucune chane de paramtre n'est prsente dans la
substitution, il est alors possible d'ajouter un point d'interrogation  la fin
et d'utiliser ce drapeau.</p>

<p>Ce drapeau est disponible  partir de la version 2.4.19 du serveur HTTP
Apache.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_r" id="flag_r">R|redirect</a></h2>
<p>
L'utilisation du drapeau [R] provoque l'envoi d'une redirection au
navigateur. Si une URL pleinement qualifie (FQDN - fully qualified domain name)
 est spcifie (c'est  dire incluant <code>http://nom-du-serveur/</code>),
 une redirection sera effectue vers cette adresse. Dans le cas contraire,
 le protocole courant, le nom du serveur et le numro de port seront
 utiliss pour gnrer l'URL envoye avec la redirection.
</p>

<p><em>Tout</em> code de statut de rponse HTTP valide peut tre
spcifi, en utilisant la syntaxe [R=305], le code de statut 302 tant
utilis par dfaut si aucun code n'est spcifi. Le code de statut
spcifi n'est pas ncessairement un code de statut
de redirection (3xx). Cependant, si le code de statut est en dehors de la plage des codes de
redirection (300-399), la chane de substitution est entirement
supprime, et la rcriture s'arrte comme si le drapeau <code>L</code>
tait utilis.</p>

<p>En plus des codes de statut de rponse, vous pouvez spcifier les
codes de redirection en utilisant leurs noms symboliques :
<code>temp</code> (dfaut), <code>permanent</code>, ou
<code>seeother</code>.</p>

<p>
Vous utiliserez presque toujours [R] en conjonction avec [L] (c'est 
dire [R,L]), car employ seul, le drapeau [R] prfixe l'URI avec
<code>http://cet-hte[:ce-port]</code>, mais passe ensuite cette adresse
 la rgle suivante, ce qui provoquera le plus souvent des
avertissements 'Invalid URI in request'.
</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_s" id="flag_s">S|skip</a></h2>
<p>Le drapeau [S] sert  sauter des rgles que vous ne voulez pas voir
excuter. La syntaxe du drapeau [S] est [S=<em>N</em>], o
<em>N</em> correspond au nombre de rgles  sauter (sous
rserve que la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> corresponde).
Ceci peut s'interprter comme une instruction
<code>goto</code>  dans votre jeu de rgles de rcriture. Dans
l'exemple suivant, nous ne voulons excuter la rgle <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> que si l'URI demand ne
correspond pas  un fichier existant.</p>
<pre class="prettyprint lang-config"># La requte concerne-t-elle un fichier qui n'existe pas ?
RewriteCond "%{REQUEST_FILENAME}" "!-f"
RewriteCond "%{REQUEST_FILENAME}" "!-d"
# Si c'est la cas, on saute les deux rgles de rcriture suivantes
RewriteRule ".?" "-" [S=2]

RewriteRule "(.*\.gif)" "images.php?$1"
RewriteRule "(.*\.html)" "docs.php?$1"</pre>




<p>Cette technique trouve son utilit dans le fait qu'une directive
<code class="directive"><a href="../mod/mod_rewrite.html#rewritecond">RewriteCond</a></code> ne s'applique
qu' la rgle qui la suit immdiatement. Ainsi, si vous voulez
qu'une directive <code>RewriteCond</code> s'applique  plusieurs rgles
<code>RewriteRule</code>, une technique possible consiste  inverser ces
conditions et ajouter une <code>RewriteRule</code> avec le drapeau [Skip]. Cette technique permet
d'laborer des pseudo-constructions if-then-else : la dernire rgle du
bloc then contiendra <code>skip=N</code>, o N est le nombre de rgles
contenues dans le bloc else :</p>
<pre class="prettyprint lang-config"># Est-ce que le fichier existe ?
RewriteCond "%{REQUEST_FILENAME}" "!-f"
RewriteCond "%{REQUEST_FILENAME}" "!-d"
# Create an if-then-else construct by skipping 3 lines if we meant to go to the "else" stanza.
RewriteRule ".?" "-" [S=3]

# Si le fichier existe, alors :
RewriteRule "(.*\.gif)" "images.php?$1"
    RewriteRule "(.*\.html)" "docs.php?$1"
    # Skip past the "else" stanza.
    RewriteRule ".?" "-" [S=1]
# ELSE...
RewriteRule "(.*)" "404.php?file=$1
# END</pre>


<p>Il est probablement plus ais de dfinir ce genre de configuration
via les directives <code class="directive">&lt;If&gt;</code>, <code class="directive">&lt;ElseIf&gt;</code>, et <code class="directive">&lt;Else&gt;</code>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="flag_t" id="flag_t">T|type</a></h2>
<p>Dfinit le type MIME de la rponse rsultante renvoye. L'effet est
identique  celui de la directive <code class="directive"><a href="../mod/mod_mime.html#addtype">AddType</a></code>.</p>

<p>Par exemple, vous pouvez utiliser la technique suivante pour servir
du code source Perl en tant que plein texte, s'il est requis d'une
certaine manire :</p>

<pre class="prettyprint lang-config"># Sert les fichier .pl en tant que plein texte
RewriteRule "\.pl$" "-" [T=text/plain]</pre>


<p>Ou encore, si vous possdez une camra qui produit des fichiers
images jpeg sans extension, vous pouvez forcer le renvoi de ces images
avec le type MIME correct en se basant sur le nom du fichier :</p>

<pre class="prettyprint lang-config"># Les fichiers dont le nom contient 'IMG' sont des images jpg.
RewriteRule "IMG" "-" [T=image/jpg]</pre>


<p>Notez cependant qu'il s'agit d'un exemple trivial, et que le problme
aurait pu tre rsolu en utilisant  la place la directive <code class="directive"><a href="../mod/core.html#filesmatch">&lt;FilesMatch&gt;</a></code>. Il faut toujours
envisager la possibilit d'une solution alternative  un problme avant
d'avoir recours  la rcriture, qui sera toujours moins efficace qu'une
solution alternative.</p>

<p>
Dans un contexte de niveau rpertoire, n'utilisez que <code>-</code>
(tiret) comme substitution, <em>dans toute la squence de rcriture de
mod_rewrite</em>, sinon le type MIME dfini avec ce drapeau
sera perdu suite  un retraitement interne (y compris les squences de
rcriture suivantes de mod_rewrite). Dans ce contexte, vous pouvez
utiliser le drapeau <code>L</code> pour terminer la squence
<em>courante</em> de rcriture de mod_rewrite.</p>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/flags.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/flags.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/rewrite/flags.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>