// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================


#ifndef _FPGA_REG_REG_H_
#define _FPGA_REG_REG_H_

#define FPGA_REG1_ADDRESS                        0x00000000
#define FPGA_REG1_OFFSET                         0x00000000
#define FPGA_REG1_FPGA_SRIF_DELAY_MSB            31
#define FPGA_REG1_FPGA_SRIF_DELAY_LSB            31
#define FPGA_REG1_FPGA_SRIF_DELAY_MASK           0x80000000
#define FPGA_REG1_FPGA_SRIF_DELAY_GET(x)         (((x) & FPGA_REG1_FPGA_SRIF_DELAY_MASK) >> FPGA_REG1_FPGA_SRIF_DELAY_LSB)
#define FPGA_REG1_FPGA_SRIF_DELAY_SET(x)         (((x) << FPGA_REG1_FPGA_SRIF_DELAY_LSB) & FPGA_REG1_FPGA_SRIF_DELAY_MASK)
#define FPGA_REG1_SPARE_FPGA_REG1_MSB            30
#define FPGA_REG1_SPARE_FPGA_REG1_LSB            21
#define FPGA_REG1_SPARE_FPGA_REG1_MASK           0x7fe00000
#define FPGA_REG1_SPARE_FPGA_REG1_GET(x)         (((x) & FPGA_REG1_SPARE_FPGA_REG1_MASK) >> FPGA_REG1_SPARE_FPGA_REG1_LSB)
#define FPGA_REG1_SPARE_FPGA_REG1_SET(x)         (((x) << FPGA_REG1_SPARE_FPGA_REG1_LSB) & FPGA_REG1_SPARE_FPGA_REG1_MASK)
#define FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_MSB    20
#define FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_LSB    16
#define FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_MASK   0x001f0000
#define FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_GET(x) (((x) & FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_MASK) >> FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_LSB)
#define FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_SET(x) (((x) << FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_LSB) & FPGA_REG1_LONG_SHIFT_SAMPLE_PHASE_MASK)
#define FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_MSB     15
#define FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_LSB     11
#define FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_MASK    0x0000f800
#define FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_GET(x)  (((x) & FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_MASK) >> FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_LSB)
#define FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_SET(x)  (((x) << FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_LSB) & FPGA_REG1_LONG_SHIFT_DRIVE_PHASE_MASK)
#define FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_MSB 10
#define FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_LSB 10
#define FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_MASK 0x00000400
#define FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_GET(x) (((x) & FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_MASK) >> FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_LSB)
#define FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_SET(x) (((x) << FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_LSB) & FPGA_REG1_ENABLE_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_MASK)
#define FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_MSB 9
#define FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_LSB 8
#define FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_MASK 0x00000300
#define FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_GET(x) (((x) & FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_MASK) >> FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_LSB)
#define FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_SET(x) (((x) << FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_LSB) & FPGA_REG1_LONG_SHIFT_CHAIN_OVERRIDE_INDEX_MASK)
#define FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_MSB     7
#define FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_LSB     4
#define FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_MASK    0x000000f0
#define FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_GET(x)  (((x) & FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_MASK) >> FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_LSB)
#define FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_SET(x)  (((x) << FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_LSB) & FPGA_REG1_EMUL_RADIO_CLOCK_RATIO_MASK)
#define FPGA_REG1_DCM_RELEASE_MSB                2
#define FPGA_REG1_DCM_RELEASE_LSB                2
#define FPGA_REG1_DCM_RELEASE_MASK               0x00000004
#define FPGA_REG1_DCM_RELEASE_GET(x)             (((x) & FPGA_REG1_DCM_RELEASE_MASK) >> FPGA_REG1_DCM_RELEASE_LSB)
#define FPGA_REG1_DCM_RELEASE_SET(x)             (((x) << FPGA_REG1_DCM_RELEASE_LSB) & FPGA_REG1_DCM_RELEASE_MASK)

#define FPGA_REG2_ADDRESS                        0x00000004
#define FPGA_REG2_OFFSET                         0x00000004
#define FPGA_REG2_FPGA_SPARE_MSB                 31
#define FPGA_REG2_FPGA_SPARE_LSB                 14
#define FPGA_REG2_FPGA_SPARE_MASK                0xffffc000
#define FPGA_REG2_FPGA_SPARE_GET(x)              (((x) & FPGA_REG2_FPGA_SPARE_MASK) >> FPGA_REG2_FPGA_SPARE_LSB)
#define FPGA_REG2_FPGA_SPARE_SET(x)              (((x) << FPGA_REG2_FPGA_SPARE_LSB) & FPGA_REG2_FPGA_SPARE_MASK)
#define FPGA_REG2_FPGA_LOOPBACK_I2C_MSB          13
#define FPGA_REG2_FPGA_LOOPBACK_I2C_LSB          13
#define FPGA_REG2_FPGA_LOOPBACK_I2C_MASK         0x00002000
#define FPGA_REG2_FPGA_LOOPBACK_I2C_GET(x)       (((x) & FPGA_REG2_FPGA_LOOPBACK_I2C_MASK) >> FPGA_REG2_FPGA_LOOPBACK_I2C_LSB)
#define FPGA_REG2_FPGA_LOOPBACK_I2C_SET(x)       (((x) << FPGA_REG2_FPGA_LOOPBACK_I2C_LSB) & FPGA_REG2_FPGA_LOOPBACK_I2C_MASK)
#define FPGA_REG2_FPGA_OWL_PLL_ENABLED_MSB       12
#define FPGA_REG2_FPGA_OWL_PLL_ENABLED_LSB       12
#define FPGA_REG2_FPGA_OWL_PLL_ENABLED_MASK      0x00001000
#define FPGA_REG2_FPGA_OWL_PLL_ENABLED_GET(x)    (((x) & FPGA_REG2_FPGA_OWL_PLL_ENABLED_MASK) >> FPGA_REG2_FPGA_OWL_PLL_ENABLED_LSB)
#define FPGA_REG2_FPGA_OWL_PLL_ENABLED_SET(x)    (((x) << FPGA_REG2_FPGA_OWL_PLL_ENABLED_LSB) & FPGA_REG2_FPGA_OWL_PLL_ENABLED_MASK)
#define FPGA_REG2_FPGA_IP_REVISION_MSB           11
#define FPGA_REG2_FPGA_IP_REVISION_LSB           8
#define FPGA_REG2_FPGA_IP_REVISION_MASK          0x00000f00
#define FPGA_REG2_FPGA_IP_REVISION_GET(x)        (((x) & FPGA_REG2_FPGA_IP_REVISION_MASK) >> FPGA_REG2_FPGA_IP_REVISION_LSB)
#define FPGA_REG2_FPGA_IP_REVISION_SET(x)        (((x) << FPGA_REG2_FPGA_IP_REVISION_LSB) & FPGA_REG2_FPGA_IP_REVISION_MASK)
#define FPGA_REG2_FPGA_IP_RELEASE_VERSION_MSB    7
#define FPGA_REG2_FPGA_IP_RELEASE_VERSION_LSB    4
#define FPGA_REG2_FPGA_IP_RELEASE_VERSION_MASK   0x000000f0
#define FPGA_REG2_FPGA_IP_RELEASE_VERSION_GET(x) (((x) & FPGA_REG2_FPGA_IP_RELEASE_VERSION_MASK) >> FPGA_REG2_FPGA_IP_RELEASE_VERSION_LSB)
#define FPGA_REG2_FPGA_IP_RELEASE_VERSION_SET(x) (((x) << FPGA_REG2_FPGA_IP_RELEASE_VERSION_LSB) & FPGA_REG2_FPGA_IP_RELEASE_VERSION_MASK)
#define FPGA_REG2_FPGA_PLATFORM_TYPE_MSB         3
#define FPGA_REG2_FPGA_PLATFORM_TYPE_LSB         0
#define FPGA_REG2_FPGA_PLATFORM_TYPE_MASK        0x0000000f
#define FPGA_REG2_FPGA_PLATFORM_TYPE_GET(x)      (((x) & FPGA_REG2_FPGA_PLATFORM_TYPE_MASK) >> FPGA_REG2_FPGA_PLATFORM_TYPE_LSB)
#define FPGA_REG2_FPGA_PLATFORM_TYPE_SET(x)      (((x) << FPGA_REG2_FPGA_PLATFORM_TYPE_LSB) & FPGA_REG2_FPGA_PLATFORM_TYPE_MASK)

#define FPGA_REG4_ADDRESS                        0x00000008
#define FPGA_REG4_OFFSET                         0x00000008
#define FPGA_REG4_RADIO_0_TDO_MSB                3
#define FPGA_REG4_RADIO_0_TDO_LSB                3
#define FPGA_REG4_RADIO_0_TDO_MASK               0x00000008
#define FPGA_REG4_RADIO_0_TDO_GET(x)             (((x) & FPGA_REG4_RADIO_0_TDO_MASK) >> FPGA_REG4_RADIO_0_TDO_LSB)
#define FPGA_REG4_RADIO_0_TDO_SET(x)             (((x) << FPGA_REG4_RADIO_0_TDO_LSB) & FPGA_REG4_RADIO_0_TDO_MASK)
#define FPGA_REG4_RADIO_0_TMS_MSB                2
#define FPGA_REG4_RADIO_0_TMS_LSB                2
#define FPGA_REG4_RADIO_0_TMS_MASK               0x00000004
#define FPGA_REG4_RADIO_0_TMS_GET(x)             (((x) & FPGA_REG4_RADIO_0_TMS_MASK) >> FPGA_REG4_RADIO_0_TMS_LSB)
#define FPGA_REG4_RADIO_0_TMS_SET(x)             (((x) << FPGA_REG4_RADIO_0_TMS_LSB) & FPGA_REG4_RADIO_0_TMS_MASK)
#define FPGA_REG4_RADIO_0_TDI_MSB                1
#define FPGA_REG4_RADIO_0_TDI_LSB                1
#define FPGA_REG4_RADIO_0_TDI_MASK               0x00000002
#define FPGA_REG4_RADIO_0_TDI_GET(x)             (((x) & FPGA_REG4_RADIO_0_TDI_MASK) >> FPGA_REG4_RADIO_0_TDI_LSB)
#define FPGA_REG4_RADIO_0_TDI_SET(x)             (((x) << FPGA_REG4_RADIO_0_TDI_LSB) & FPGA_REG4_RADIO_0_TDI_MASK)
#define FPGA_REG4_RADIO_0_TCK_MSB                0
#define FPGA_REG4_RADIO_0_TCK_LSB                0
#define FPGA_REG4_RADIO_0_TCK_MASK               0x00000001
#define FPGA_REG4_RADIO_0_TCK_GET(x)             (((x) & FPGA_REG4_RADIO_0_TCK_MASK) >> FPGA_REG4_RADIO_0_TCK_LSB)
#define FPGA_REG4_RADIO_0_TCK_SET(x)             (((x) << FPGA_REG4_RADIO_0_TCK_LSB) & FPGA_REG4_RADIO_0_TCK_MASK)


#ifndef __ASSEMBLER__

typedef struct fpga_reg_reg_s {
  volatile unsigned int fpga_reg1;
  volatile unsigned int fpga_reg2;
  volatile unsigned int fpga_reg4;
} fpga_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _FPGA_REG_H_ */
