import QtQuick 2.8
import QtQuick.Studio.Components 1.0

Item {
    id: aDAS_Bar

    Image {
        id: base
        y: 66 * eosADAS.scaleFactor
        scale: eosADAS.scaleFactor
        source: "assets/base_5.png"
    }

    Item {
        id: arrowRight
        anchors.right: aDAS_Bar.right
        anchors.rightMargin: 30 * eosADAS.scaleFactor
        anchors.verticalCenter: parent.verticalCenter
        width: 28 * eosADAS.scaleFactor
        height: 28 * eosADAS.scaleFactor
        rotation: 90
        clip: true
        SvgPathItem {
            id: arrowFwd
            anchors.centerIn: parent
            width: 11 * eosADAS.scaleFactor
            height: 11 * eosADAS.scaleFactor
            strokeColor: "transparent"
            fillColor: "#6d737a"
            path: "M 5.013309393131436 0.32660168681320845 C 5.062357757411661 0.2284649892724146 5.137768992241718 0.1459279236388396 5.231090217439543 0.08824171765644398 C 5.324411442637368 0.030555511674048352 5.431954261654664 1.3115559188709708e-16 5.5416654675749655 0 C 5.651376673495267 2.6231118377419417e-16 5.758920055821386 0.030555511674048352 5.852241281019212 0.08824171765644398 C 5.945562506217037 0.1459279236388396 6.020973741047094 0.2284649892724146 6.070022105327318 0.32660168681320845 L 11.021035738961045 10.228630890125405 C 11.066046574045268 10.318706319331971 11.087282873585957 10.41879393189709 11.082727068090987 10.519386198892732 C 11.078171262596017 10.619978465888375 11.04797409988783 10.717735968470054 10.995005238220564 10.80337391360026 C 10.942036376553299 10.889011858730465 10.86805446744963 10.959686310620937 10.78008489611891 11.008685389990465 C 10.692115324788189 11.057684469359993 10.593079269962615 11.083380902971433 10.492383927385104 11.083333969116211 L 0.5903568713584587 11.083333969116211 C 0.48971155764584634 11.083280236005761 0.39074914664726423 11.057510873376087 0.3028600316596205 11.00847020596093 C 0.21497091667197674 10.959429538545772 0.1410703968916244 10.88874454221537 0.08817065497735979 10.803122677796141 C 0.03527091306309518 10.717500813376912 0.0051266820618468 10.619782038287463 0.0005982779104460179 10.519238611940539 C -0.003930126240954765 10.418695185593615 0.0173075051757837 10.318661571475044 0.06229597954021803 10.228630890125405 L 5.013309393131436 0.32660168681320845 Z"
            layer.samples: 4
            strokeWidth: 1
            antialiasing: true
            layer.enabled: true
            scale: eosADAS.scaleFactor
        }
    }

    MyArrowLbtn {
        id: arrowLbtn
        width: 28 * eosADAS.scaleFactor
        height: 28 * eosADAS.scaleFactor
        anchors.left: aDAS_Bar.left
        anchors.leftMargin: 30 * eosADAS.scaleFactor
        anchors.verticalCenter: parent.verticalCenter

        Connections {
            target: arrowLbtn
            onReleased: {
                auroraADAS.state = "Home"
                console.log("Home Screen")
            }
        }
    }

    MySteeringWheelBtn {
        id: steeringWheelBtn
        anchors.centerIn: parent
        height: 68
        width: 100 * eosADAS.scaleFactor
        scale: eosADAS.scaleFactor
        checked: true
        autoExclusive: true
    }

    MyOffRoadBtn {
        id: offRoadBtn
        anchors.left: steeringWheelBtn.right
        anchors.verticalCenter: parent.verticalCenter
        height: 68
        width: 100 * eosADAS.scaleFactor
        scale: eosADAS.scaleFactor
        autoExclusive: true
    }

    MyCarFrontButton {
        id: carFrontButton
        anchors.right: steeringWheelBtn.left
        anchors.verticalCenter: parent.verticalCenter
        height: 68
        width: 100 * eosADAS.scaleFactor
        scale: eosADAS.scaleFactor
        autoExclusive: true
    }
}

/*##^##
Designer {
    D{i:0;formeditorZoom:1.66;height:68;uuid:"a9a66a29-b881-5cdc-bd4a-49b514763640";width:700}
D{i:1;uuid:"7b0f8d1f-38fe-549a-a075-1fc54af7808d"}D{i:3;uuid:"10f2305a-a7db-5428-97ef-5fcd6a178a89"}
D{i:2;uuid:"12de83ce-af23-56a9-bbcb-c190f61fc838"}D{i:4;uuid:"4488b140-d476-564b-b88d-43eea1d3a847"}
}
##^##*/

