/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact:  Qt Software Information (qt-info@nokia.com)
**
** Commercial Usage
**
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
**
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
**************************************************************************/

#ifndef IOPTIONSPAGE_H
#define IOPTIONSPAGE_H

#include <coreplugin/core_global.h>

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtGui/QWidget>

namespace Core {

/*!
  \class Core::IOptionsPage
  \brief The IOptionsPage is an interface for providing options pages.

  Guidelines for implementing:
  \list
  \o id() is an id used for filtering when calling ICore:: showOptionsDialog()
  \o trName() is the (translated) name for display.
  \o category() is the category used for filtering when calling ICore:: showOptionsDialog()
  \o trCategory() is the translated category
  \o apply() is called to store the settings. It should detect if any changes have been
         made and store those.
  \endlist
*/

class CORE_EXPORT IOptionsPage : public QObject
{
    Q_OBJECT
public:
    IOptionsPage(QObject *parent = 0) : QObject(parent) {}
    virtual ~IOptionsPage() {}

    virtual QString id() const = 0;
    virtual QString trName() const = 0;
    virtual QString category() const = 0;
    virtual QString trCategory() const = 0;

    virtual QWidget *createPage(QWidget *parent) = 0;
    virtual void apply() = 0;
    virtual void finish() = 0;
};

} // namespace Core

#endif // IOPTIONSPAGE_H
