#line 2 "pgc.c"
#line 2 "pgc.l"
/*-------------------------------------------------------------------------
 *
 * pgc.l
 *	  lexical scanner for ecpg
 *
 * This is a modified version of src/backend/parser/scan.l
 *
 *
 * Portions Copyright (c) 1996-2016, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *	  src/interfaces/ecpg/preproc/pgc.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include <ctype.h>
#include <sys/types.h>
#include <limits.h>

#include "extern.h"
#include "preproc.h"

/*
 * Change symbol names as expected by preproc.y.  It'd be better to do this
 * with %option prefix="base_yy", but that affects some other names that
 * various files expect *not* to be prefixed with "base_".  Cleaning it up
 * is not worth the trouble right now.
 */
#define yylex           base_yylex
#define yylval          base_yylval



#line 41 "pgc.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 39
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 151
#define YY_END_OF_BUFFER 152
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[823] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   15,   15,    0,    0,    0,    0,
        0,    0,    0,    0,   14,   14,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  152,  150,  120,   98,   98,  120,
       56,  120,   80,   92,  120,   22,   96,   97,   91,   94,
       90,   95,  120,   93,   70,   70,   88,   89,  120,  103,
      120,   86,   86,  101,  102,   99,  120,  100,   78,    1,
        1,   68,   49,   68,   66,   67,   68,   23,   67,   67,
       67,   67,   70,   67,   67,   67,   67,   77,   77,   77,

       77,   77,   77,  149,  149,  149,  149,  145,  145,  144,
      143,  142,  126,  126,   15,   12,    8,    8,    9,    9,
        9,    9,   55,   51,   57,   52,   57,   14,   19,   36,
       36,   28,   42,   35,   30,   26,   26,   35,   46,   46,
       48,  141,  141,  139,   98,   98,  139,  139,   53,   32,
        0,    0,  112,    0,    0,    0,    0,    0,    0,    0,
      117,  108,    0,   87,  115,  109,  113,  110,  114,  104,
      119,   72,    2,    0,  116,   72,   70,    0,   82,  106,
      111,  105,   86,   86,  107,    1,    0,   68,   65,   68,
        0,    0,   44,   69,   43,    1,   59,   72,    3,   72,

       70,   74,   58,   60,   76,   62,   64,   61,   63,   77,
       11,   24,   21,    0,   18,    0,  148,    0,    0,    0,
      144,  142,    0,    0,  125,   15,   12,   12,   13,    8,
       10,    7,    4,   10,    6,    5,   55,   54,   57,   14,
       19,   19,   20,   36,   28,   28,   33,   29,   38,   39,
       38,   38,   38,   35,   30,   30,   31,   26,   26,   27,
       34,   46,   45,   47,    0,    0,  140,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   85,   85,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  118,    2,    0,   81,   72,    0,   73,

       82,   86,   68,   68,   43,    1,    1,    3,   72,   70,
       75,   76,    0,    0,    0,   50,   25,  147,  146,   12,
       17,   13,   12,    4,    5,   19,   16,   20,   19,   28,
       41,   29,   28,   39,    0,    0,   40,   30,   31,   30,
       26,   27,   26,   47,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,   86,   68,
        0,   72,   70,   76,    0,    0,    0,   76,  147,  147,
      146,  146,   12,   12,   12,   12,   19,   19,   19,   19,
       28,   28,   28,   28,   39,    0,    0,   40,   30,   30,

       30,   30,   26,   26,   26,   26,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   85,
       85,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  134,    0,    0,    0,    0,    0,    0,    0,   86,
       68,   68,    0,   72,   72,   76,    0,    0,    0,    0,
       12,   12,   12,   12,   12,   19,   19,   16,   19,   19,
       28,   28,   28,   28,   28,    0,    0,   30,   30,   30,
       30,   30,   26,   26,   26,   26,   26,    0,    0,    0,
        0,    0,    0,    0,   41,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  134,    0,  136,    0,  130,    0,    0,  124,
        0,   86,   68,    0,    0,   72,    0,    0,    0,    0,
       76,   76,   12,   19,   28,    0,   37,   30,   26,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  122,
        0,  138,  130,  132,    0,  124,    0,   79,   71,    0,
        0,    0,    0,    0,   76,    0,    0,    0,    0,    0,
        0,    0,   83,   83,  122,  132,  128,   79,   79,   86,
       86,   86,   86,   71,   76,    0,    0,    0,    0,    0,
        0,    0,    0,    0,   83,   83,   83,    0,   83,    0,
      128,    0,    0,    0,   86,   86,   86,   86,   86,   86,

       71,   76,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       86,   86,   86,   86,   86,   86,   86,   86,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   86,   86,   86,   86,   86,
       86,   86,   86,  133,    0,    0,    0,    0,    0,    0,
        0,    0,   53,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   32,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   86,  133,    0,  135,   86,   86,   86,   86,
       86,    0,  129,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,   41,    0,
       41,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,   84,   84,    0,    0,  123,   86,    0,
      137,  129,   86,   86,  123,  131,    0,   53,    0,    0,
        0,    0,    0,   53,   53,    0,    0,    0,    0,    0,
        0,    0,   32,   32,    0,    0,    0,    0,    0,   32,
       32,   84,   84,   84,   84,  121,    0,  121,  131,   86,
        0,    0,    0,    0,    0,    0,    0,    0,   32,    0,
        0,   41,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  127,  127,   53,    0,    0,    0,    0,

        0,    0,    0,    0,   32,   32,    0,    0,   32,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,   28,   28,   29,   30,   31,   32,   33,   34,
       35,   35,   36,   35,   35,   37,   38,   39,   40,   41,
       42,   43,   44,   45,   46,   35,   35,   47,   35,   35,
       48,   49,   50,   51,   52,   28,   29,   30,   31,   32,

       33,   34,   35,   35,   53,   35,   35,   37,   38,   39,
       40,   41,   42,   43,   44,   45,   54,   35,   35,   55,
       35,   35,   56,   57,   58,   28,    1,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,

       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59
    } ;

static yyconst flex_int32_t yy_meta[60] =
    {   0,
        1,    2,    3,    3,    4,    5,    4,    6,    7,    4,
        8,    9,    9,   10,    7,    1,   11,   12,   13,   14,
       14,   14,   15,   16,   17,   18,   19,    4,   20,   20,
       20,   20,   20,   20,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,    9,
        4,   21,   21,   21,   21,    1,    4,    1,   21
    } ;

static yyconst flex_int16_t yy_base[914] =
    {   0,
        0,    0,    0,    0,   59,    0,  113,  117,  122,  125,
      149,    0,  208,    0, 1813, 1807,  263,  316,  116,  117,
     1811, 1802,  263,  268, 1792, 1791,  273,  283, 1787, 1786,
     1782, 1777,  260,  264,  131,  140,  373,    0,  294,  303,
     1777, 1772, 1766, 1763, 1771, 5129, 5129,  297,  343, 1744,
     5129,  257,  316, 1742, 1745, 5129, 5129, 5129,  289,  106,
     5129,  302,  337,  342,  415,  420, 5129, 5129, 1725, 1723,
     1718,    0,  232, 5129, 5129, 5129, 1687, 5129, 5129,  442,
      448, 1716, 5129,  466,  439,    0,    0, 5129, 5129, 1723,
      436, 1725,  445,  269,  311, 1710, 1710,    0, 1720, 1718,

     1717, 1716, 1713, 1699,    0, 5129,    0, 5129,  484, 5129,
     5129,    0, 5129,  494,    0,  497,    0,    0,  320, 1707,
      341, 1704,    0, 1710, 5129, 5129,  275,    0,  503,    0,
        0,  522,  483,    0,  532,  542,  538, 1704,    0,    0,
     1704, 5129,  507, 5129, 5129, 5129,  436,  316,  548,  558,
      564,  459, 5129,  612,  538,  540, 1677,   83,  400, 1668,
     5129, 5129,  460, 5129, 5129, 5129, 5129, 5129, 5129, 1688,
     5129,  560,    0, 1694, 5129,  563,  568,  588,    0, 5129,
     5129, 5129,    0, 1654, 5129,  670,  477,    0,    0,  673,
      430,  494, 5129,  344, 1678,  726, 5129,  578,    0,  664,

      673,  687, 5129, 5129,  539,    0,    0,    0,    0,    0,
     5129, 5129, 5129,  471, 5129, 1657, 5129, 1664, 1638,  708,
     5129,    0,  713,  718, 5129,    0,  744,  753, 1637,    0,
      502, 5129,    0,  508, 5129,    0,    0, 5129, 5129,    0,
      756,  763, 1632,    0,  782,  785, 5129, 1621, 5129,  333,
        0,    0,    0,    0,  788,  804, 1611,  807,  814, 1600,
     5129,    0, 5129, 1604,  725,  810, 5129, 1567, 1558,  824,
     1570, 1552,  833,  836, 1567, 1542,  862, 5129,    0, 1554,
        0,  531, 1515, 1523,  657, 1492, 1500, 1487,  807, 1484,
      686, 1472, 1469, 5129,    0, 1497, 5129,  824,  773,  834,

        0, 1460,  913, 1476, 1477,    0,  966,    0,  841,  847,
      851,  696, 1453,    0,  908, 5129, 5129,  931,  941,  945,
     5129, 1453,  949,    0,    0,  957, 5129, 1446,  984,  993,
     5129, 1440,  996,  527,    0,    0,    0, 1003, 1430, 1022,
     1025, 1428, 1028, 1435, 1410, 1031, 1381, 1047, 1407, 1050,
     1378,  910, 1388, 1383, 1374, 1372, 1366, 1357, 1348, 1349,
      726, 1351, 1347,  745, 1346, 1341, 1325, 1323,  882, 1102,
      855, 1039, 1048,  721, 1072, 1096, 1121, 1130, 1084, 5129,
     1133, 5129, 1080, 1137, 1141, 1147, 1158, 1164, 1170, 1180,
     1187, 1190, 1197, 1206, 5129,    0,    0, 5129, 1209, 1213,

     1225, 1229, 1232, 1235, 1251, 1254,  975, 1257, 1260, 1263,
     1279, 1324, 1282, 1285, 1288, 1318, 1341, 1310, 1059, 1326,
     1076,  578, 1304, 1304, 1289,  680, 1296, 1296, 1284,  717,
     1287, 1344, 1347, 1290, 1289, 1286,  722, 1284, 1350, 1271,
        0, 1391, 1339, 1345, 1348,  871, 1448, 1380, 1505, 1373,
     1409, 1429, 1458, 1475, 1464, 1485, 1559, 1563, 1575, 1579,
     1586, 1591, 1596, 1607, 1602,    0,    0, 1612, 1623, 1628,
     1633, 1639, 1644, 1649, 1660, 1665, 1655, 1400, 1268, 1671,
     1676, 1279, 1681, 1692, 1697, 1702, 1730, 1750, 1755, 1278,
     1290,  662, 1286,    0, 1264, 1252, 1263,    0, 1260, 1234,

     1246, 1243, 1389, 1432, 5129, 1491, 1425, 1241, 1241, 1435,
     1230, 1233,  917, 1462, 1551, 1600, 1809,    0,    0, 1252,
      998, 1866, 1758, 1762, 1778,    0, 5129, 1783, 1819, 1214,
     1840, 1207, 1836, 1885, 1846, 1204, 1207,    0, 1189, 1508,
     1687, 5129, 1526, 1788, 1188, 1803, 1169, 1938, 1807, 1185,
     1185,  755, 1964,    0, 2022,    0, 1870, 1905, 1162, 1915,
     1908, 1153, 1852, 1895, 1941, 1946, 1953, 2071,    0, 1144,
      108,  903, 1126, 1943, 2125,    0, 1979,  246, 1129, 2025,
     2041, 2051, 2044, 2084, 1964, 1973, 1976, 1117, 1983, 1116,
     1986, 1119,  933, 1103, 1097,  910, 1094,  765, 1087, 1083,

     5129,    0,    0, 1152, 1078,  790, 2183, 2089,    0, 1086,
     2186, 2189, 2206,    0, 1085, 1061, 1059, 1022, 1013, 1009,
      767, 1006,  989,  796,  976,  957,  947,  936,  923,  917,
      828,  888,  851, 2209,  841, 2242, 2245, 2262,  822, 2265,
      811,  935,  985,  793,  790,  780, 2018, 2248,  767,  766,
      745,  957,  741, 2061, 2281,  716,  689,  686, 2284, 2300,
     2310, 2290, 5129, 2320, 2330, 2346, 2349, 2365, 2368, 2384,
     2387, 2390, 5129, 2406, 2423, 2443, 2446,  660,  658,  640,
     1001,  641,  562, 2074, 2294, 5129, 2449, 2079,  557,  541,
     2106, 2462, 2109,  481,  426, 2465, 2468, 2485, 2488, 2504,

     2521, 2524, 2542, 2545, 2561, 2566, 2577, 2582, 2587, 2598,
        0,  355, 2603, 2608, 2636, 2656, 2661, 2666, 2682, 2694,
     2714, 2719, 2724, 2112, 2116,  307,  286, 2119, 2192, 2593,
     5129, 2371, 2491,  283, 2514, 2672, 2735, 2730, 2740, 2751,
     2756, 2761, 2789, 2809,    0, 2814, 2825, 2830, 2835, 2847,
     2852, 2871, 2883, 5129, 2888, 2892, 2909, 2919, 2937, 2941,
        0, 2677, 2685, 2746, 2767, 2863,  100, 2912, 2929, 2947,
     2957, 2973, 2976, 2993, 2996, 3012, 3029, 3032, 3050, 3053,
     3070, 3086, 3089, 3106, 3109, 3125, 3142, 3145, 3163, 3166,
     3183, 3202, 3219, 3022, 3199, 3222, 3238, 3241, 3268, 3279,

     3295, 3298, 3315, 3326, 3336,    0, 3354, 3364, 3375, 3385,
     3395, 3411, 3431, 3434, 3451, 3470, 3487, 3490, 3506, 3510,
     3526, 5129, 3580, 3602, 3624, 3646, 3668, 3690, 3712, 3734,
     3756, 3778, 3800, 3822, 3844, 3861, 3879, 3893, 3900, 3916,
     3937, 3959, 3981, 3998, 4018, 4039, 4061, 4083, 4105, 4127,
     4148, 4170, 4192, 1295, 4213, 4231, 4250,  470, 4267, 4288,
     4307, 4321, 4339, 4355,  544,  828,  988, 4369,  586, 4389,
     4410, 4432, 4454,  998, 1023, 1051, 4476, 4498, 4520, 4542,
     4564, 4581, 4602, 4624, 4646, 1100, 1156, 4668, 4690, 4712,
     4734, 4756, 1165, 1204, 4777, 1205, 1227, 1230, 4798, 4820,

     4842, 4864, 4886, 4908, 4930, 4952, 4974, 4996, 5018, 5040,
     5062, 5084, 5106
    } ;

static yyconst flex_int16_t yy_def[914] =
    {   0,
      823,  823,  822,    3,  822,    5,  824,  824,  825,  825,
      822,   11,  822,   13,  826,  826,  827,  827,   18,   18,
      828,  828,  829,  829,  830,  830,  831,  831,  832,  832,
      832,  832,  832,  832,  833,  833,  822,   37,  834,  834,
      828,  828,  832,  832,  822,  822,  822,  822,  822,  822,
      822,  835,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  836,  836,  822,  822,  822,  822,  822,  822,  822,
      822,  837,  822,  835,  838,  837,  837,  822,  822,  837,
      822,  837,  822,  839,  837,  837,  837,  840,  840,  840,

      840,  840,  840,  841,  842,  822,  843,  822,  822,  822,
      822,  844,  822,  845,  846,  822,  847,  847,  822,  822,
      822,  822,  848,  822,  822,  822,  822,  849,  822,  850,
      850,  822,  851,  852,  822,  822,  822,  852,  853,  853,
      854,  822,  855,  822,  822,  822,  822,  822,  822,  822,
      822,  835,  822,  822,  154,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  856,  857,  822,  822,  822,  822,  858,  822,
      822,  822,  836,  836,  822,  822,  835,  837,  837,  154,
      154,  822,  822,  822,  859,  860,  822,  822,  861,  822,

      822,  822,  822,  822,  862,  837,  837,  837,  837,  840,
      822,  822,  822,  822,  822,  841,  822,  842,  843,  822,
      822,  844,  822,  845,  822,  846,  822,  822,  822,  847,
      822,  822,  863,  822,  822,  864,  848,  822,  822,  849,
      822,  822,  822,  850,  822,  822,  822,  822,  822,  822,
      865,  866,  867,  852,  822,  822,  822,  822,  822,  822,
      822,  853,  822,  868,  822,  855,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  154,  822,  277,  277,
      154,  154,  154,  154,  277,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  856,  857,  822,  822,  822,  822,

      858,  836,  277,  303,  859,  860,  860,  861,  822,  822,
      822,  862,  822,  869,  870,  822,  822,  822,  822,  822,
      822,  822,  871,  863,  864,  822,  822,  822,  872,  822,
      822,  822,  873,  822,  874,  875,  876,  822,  822,  877,
      822,  822,  878,  868,  822,  879,  822,  822,  822,  880,
      822,  881,  154,  154,  154,  154,  277,  277,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  836,  881,
      822,  822,  822,  882,  870,  870,  870,  870,  822,  822,
      822,  822,  883,  871,  871,  871,  884,  872,  872,  872,
      885,  873,  873,  873,  822,  886,  887,  822,  888,  877,

      877,  877,  889,  878,  878,  878,  822,  879,  879,  879,
      879,  822,  890,  880,  880,  880,  880,  822,  881,  891,
      881,  277,  154,  154,  154,  154,  277,  277,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  836,
      370,  277,  822,  822,  822,  882,  892,  870,  822,  870,
      883,  883,  883,  883,  871,  884,  884,  884,  884,  872,
      885,  885,  885,  885,  873,  893,  894,  888,  888,  888,
      888,  877,  889,  889,  889,  889,  878,  822,  822,  879,
      879,  822,  890,  890,  890,  890,  890,  880,  880,  822,
      891,  822,  277,  154,  154,  154,  154,  277,  277,  822,

      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  836,  442,  822,  822,  822,  892,  517,  517,  517,
      517,  895,  883,  884,  885,  896,  822,  888,  889,  822,
      879,  822,  890,  890,  880,  822,  154,  277,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  836,  822,  822,
      517,  517,  517,  517,  895,  897,  822,  879,  822,  890,
      880,  822,  154,  822,  822,  822,  822,  822,  568,  836,
      836,  836,  836,  822,  822,  898,  822,  822,  822,  879,
      822,  890,  880,  822,  277,  822,  277,  277,  822,  822,
      822,  822,  822,  822,  836,  836,  836,  836,  836,  836,

      822,  575,  894,  822,  822,  822,  879,  822,  899,  822,
      890,  880,  822,  900,  822,  277,  822,  822,  822,  822,
      836,  836,  836,  836,  836,  836,  836,  836,  822,  822,
      822,  822,  822,  879,  822,  901,  890,  880,  822,  902,
      277,  822,  822,  822,  822,  836,  836,  836,  836,  836,
      836,  836,  836,  822,  822,  822,  822,  822,  879,  822,
      903,  879,  822,  901,  901,  904,  901,  890,  880,  822,
      905,  880,  822,  902,  902,  906,  902,  277,  822,  822,
      822,  822,  836,  822,  822,  822,  836,  836,  836,  836,
      836,  822,  822,  822,  822,  879,  879,  822,  879,  879,

      907,  901,  901,  822,  901,  901,  890,  822,  908,  890,
      900,  822,  880,  880,  822,  880,  880,  909,  902,  902,
      822,  902,  902,  277,  822,  822,  822,  822,  836,  822,
      822,  822,  836,  836,  822,  822,  907,  879,  907,  907,
      910,  907,  907,  904,  899,  890,  890,  822,  890,  890,
      911,  911,  880,  822,  909,  909,  912,  909,  909,  906,
      900,  277,  822,  277,  822,  822,  822,  822,  822,  836,
      907,  907,  907,  822,  907,  907,  907,  907,  890,  911,
      911,  913,  911,  911,  911,  909,  909,  909,  822,  909,
      909,  909,  909,  822,  822,  910,  907,  911,  911,  822,

      911,  911,  911,  911,  912,  900,  909,  907,  913,  911,
      909,  907,  911,  909,  907,  911,  909,  907,  911,  909,
      911,    0,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,

      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822
    } ;

static yyconst flex_int16_t yy_nxt[5189] =
    {   0,
       47,   48,   49,   48,   50,   51,   52,   53,   54,   55,
       56,   57,   58,   59,   60,   61,   62,   63,   64,   65,
       66,   66,   67,   68,   69,   70,   71,   47,   72,   72,
       72,   72,   73,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   74,   47,   75,
       47,   72,   72,   72,   72,   76,   77,   78,   72,   79,
       80,   81,   80,   82,   83,   84,   85,   86,   87,   88,
       89,   89,   86,   86,   89,   90,   91,   92,   93,   93,
       93,   94,   89,   95,   96,   97,   87,   98,   99,   98,
       98,  100,   98,   98,   98,   98,   98,  101,   98,   98,

       98,   98,   98,   98,  102,  103,   89,   79,   89,   86,
       98,   98,  102,  103,   79,   87,   79,   98,  105,  289,
      166,  290,  105,  109,  109,  109,  109,  109,  109,  121,
      121,  167,  794,  140,  122,  122,  106,  107,  141,  106,
      106,  107,  140,  106,  596,  110,  597,  141,  110,  111,
      111,  111,  111,  111,  111,  111,  111,  111,  111,  111,
      111,  111,  111,  111,  111,  111,  111,  111,  111,  111,
      111,  111,  111,  111,  111,  111,  111,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  112,  112,  112,  111,  111,  111,  111,

      112,  112,  112,  112,  111,  111,  111,  112,  113,  113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  113,  113,  113,  113,  113,  113,
      113,  113,  113,  113,  113,  113,  114,  114,  114,  114,
      114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
      114,  114,  114,  114,  114,  113,  113,  113,  113,  114,
      114,  114,  114,  113,  113,  113,  114,  118,  126,  118,
      137,  118,  118,  126,  137,  131,  119,  118,  184,  118,
      239,  120,  604,  132,  605,  131,  184,  118,  118,  118,
      118,  203,  155,  132,  204,  145,  146,  145,  151,  151,

      151,  147,  163,  152,  145,  146,  145,  164,  138,  156,
      147,  127,  138,  118,  165,  770,  127,  767,  168,  118,
      118,  133,  118,  239,  118,  118,  148,  169,  170,  119,
      118,  133,  118,  231,  120,  148,  206,  207,  232,  766,
      118,  118,  118,  118,  151,  151,  151,  157,  158,  152,
      171,  159,  334,  334,  234,  173,  172,  172,  172,  235,
      174,  160,  269,  194,  194,  194,  118,  175,  159,  160,
      269,  752,  118,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,
      142,  142,  142,  142,  142,  142,  142,  142,  142,  142,

      142,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      143,  143,  143,  143,  143,  143,  143,  143,  143,  143,
      142,  142,  142,  142,  143,  143,  143,  143,  142,  142,
      142,  143,  176,  291,  177,  177,  177,  176,  292,  177,
      177,  177,  737,  186,  186,  186,  193,  178,  187,  186,
      186,  186,  178,  197,  187,  198,  198,  198,  194,  194,
      194,  179,  200,  282,  201,  201,  201,  283,  158,  179,
      190,  268,  190,  163,  190,  190,  316,  202,  164,  190,
      190,  317,  190,  301,  190,  220,  220,  220,  268,  301,
      190,  190,  190,  190,  155,  223,  223,  223,  227,  228,

      228,  191,  250,  250,  241,  242,  242,  221,  265,  265,
      265,  156,  191,  229,  736,  231,  190,  225,  192,  243,
      232,  234,  190,  245,  246,  246,  235,  285,  251,  192,
      267,  286,  247,  255,  256,  256,  252,  253,  248,  258,
      259,  259,  247,  258,  259,  259,  395,  395,  257,  270,
      270,  270,  247,  238,  260,  313,  314,  335,  260,  273,
      274,  274,  353,  335,  271,  151,  151,  151,  247,  354,
      152,  282,  734,  285,  275,  283,  284,  286,  287,  172,
      172,  172,  298,  298,  298,  176,  315,  177,  177,  177,
      733,  422,  178,  272,  729,  178,  493,  198,  198,  198,

      178,  272,  299,  276,  299,  374,  374,  300,  300,  300,
      202,  276,  277,  277,  278,  279,  277,  277,  277,  277,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
      280,  277,  277,  277,  277,  277,  277,  277,  277,  277,
      281,  281,  281,  281,  281,  281,  281,  281,  281,  281,
      281,  281,  281,  281,  281,  281,  281,  281,  281,  277,
      277,  277,  277,  277,  281,  281,  281,  277,  277,  277,
      277,  186,  186,  186,  728,  492,  187,  303,  726,  303,
      277,  303,  303,  309,  309,  309,  303,  303,  357,  303,
      200,  304,  310,  310,  310,  358,  202,  303,  303,  303,

      303,  311,  725,  311,  724,  202,  300,  300,  300,  220,
      220,  220,  313,  314,  223,  223,  223,  365,  694,  223,
      223,  223,  693,  303,  366,  497,  265,  265,  265,  303,
      307,  221,  307,  497,  307,  307,  225,  313,  314,  307,
      307,  225,  307,  315,  307,  227,  228,  228,  267,  692,
      307,  307,  307,  307,  320,  320,  320,  241,  242,  242,
      229,  431,  501,  321,  326,  326,  326,  509,  315,  322,
      501,  520,  243,  327,  691,  509,  307,  689,  431,  328,
      434,  553,  307,  245,  246,  246,  330,  330,  330,  255,
      256,  256,  300,  300,  300,  331,  625,  434,  248,  688,

      687,  332,  646,  626,  257,  338,  338,  338,  258,  259,
      259,  265,  265,  265,  331,  341,  341,  341,  683,  646,
      339,  632,  682,  260,  331,  270,  270,  270,  633,  681,
      342,  649,  673,  267,  273,  274,  274,  348,  348,  348,
      271,  336,  362,  298,  298,  298,  331,  336,  649,  275,
      363,  663,  349,  300,  300,  300,  178,  678,  371,  362,
      372,  372,  372,  656,  200,  678,  373,  373,  373,  272,
      300,  300,  300,  202,  443,  443,  443,  272,  276,  202,
      656,  276,  658,  439,  439,  439,  276,  313,  314,  276,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,

      277,  277,  277,  277,  277,  277,  277,  277,  277,  375,
      375,  375,  420,  421,  277,  277,  277,  303,  315,  303,
      657,  303,  303,  422,  377,  440,  303,  303,  280,  303,
      370,  304,  379,  379,  379,  304,  598,  303,  303,  303,
      303,  599,  381,  381,  381,  622,  320,  320,  320,  655,
      385,  228,  228,  623,  380,  321,  654,  378,  326,  326,
      326,  322,  622,  303,  382,  386,  606,  327,  653,  303,
      307,  619,  307,  328,  307,  307,  478,  478,  478,  307,
      307,  679,  307,  652,  307,  389,  242,  242,  651,  679,
      307,  307,  307,  307,  330,  330,  330,  393,  246,  246,

      390,  337,  690,  331,  338,  338,  338,  337,  650,  332,
      690,  396,  394,  331,  552,  553,  307,  396,  479,  339,
      680,  648,  307,  401,  256,  256,  341,  341,  341,  405,
      259,  259,  409,  270,  270,  331,  397,  680,  402,  647,
      645,  342,  397,  644,  406,  554,  727,  410,  348,  348,
      348,  415,  274,  274,  727,  643,  371,  331,  444,  444,
      444,  420,  421,  349,  398,  445,  416,  373,  373,  373,
      398,  202,  422,  375,  375,  375,  411,  280,  420,  421,
      202,  452,  320,  320,  411,  379,  379,  379,  377,  422,
      453,  642,  276,  641,  280,  417,  454,  375,  375,  375,

      276,  640,  636,  417,  420,  421,  441,  380,  441,  631,
      441,  441,  377,  466,  628,  442,  441,  627,  441,  466,
      304,  378,  375,  375,  375,  624,  441,  441,  441,  441,
      621,  375,  375,  375,  381,  381,  381,  447,  385,  228,
      228,  620,  385,  228,  228,  378,  448,  449,  385,  228,
      228,  618,  441,  386,  617,  616,  382,  386,  441,  457,
      326,  326,  606,  455,  600,  389,  242,  242,  458,  467,
      378,  389,  242,  242,  459,  467,  595,  450,  526,  378,
      390,  389,  242,  242,  526,  584,  390,  629,  462,  330,
      330,  393,  246,  246,  581,  630,  460,  463,  393,  246,

      246,  520,  514,  464,  629,  568,  394,  393,  246,  246,
      469,  338,  338,  394,  401,  256,  256,  527,  556,  470,
      567,  564,  465,  527,  556,  471,  401,  256,  256,  402,
      401,  256,  256,  474,  341,  341,  405,  259,  259,  563,
      576,  402,  475,  603,  562,  472,  576,  559,  476,  603,
      557,  406,  405,  259,  259,  405,  259,  259,  409,  270,
      270,  409,  270,  270,  409,  270,  270,  406,  520,  548,
      477,  547,  545,  410,  544,  540,  410,  539,  538,  480,
      409,  270,  270,  484,  348,  348,  415,  274,  274,  415,
      274,  274,  485,  498,  537,  410,  494,  494,  486,  352,

      264,  416,  411,  492,  416,  411,  536,  532,  411,  530,
      411,  481,  512,  411,  264,  264,  411,  510,  508,  415,
      274,  274,  507,  506,  411,  502,  500,  487,  499,  498,
      417,  496,  411,  417,  488,  487,  495,  494,  417,  492,
      490,  417,  415,  274,  274,  503,  503,  503,  504,  504,
      504,  439,  439,  439,  482,  438,  514,  416,  515,  515,
      515,  437,  371,  417,  516,  516,  516,  516,  516,  516,
      505,  417,  436,  489,  375,  375,  375,  202,  435,  433,
      202,  375,  375,  375,  432,  430,  417,  429,  428,  377,
      503,  503,  503,  511,  417,  303,  447,  303,  427,  303,

      303,  478,  478,  478,  442,  303,  449,  303,  426,  513,
      452,  320,  320,  425,  424,  303,  303,  303,  303,  453,
      423,  418,  378,  413,  412,  454,  543,  543,  543,  378,
      452,  320,  320,  504,  504,  504,  546,  546,  546,  453,
      407,  303,  263,  479,  403,  454,  399,  303,  517,  518,
      375,  375,  517,  517,  517,  505,  391,  517,  517,  452,
      320,  320,  387,  517,  520,  385,  228,  228,  453,  383,
      517,  517,  517,  517,  454,  517,  452,  320,  320,  314,
      455,  549,  549,  549,  193,  453,  457,  326,  326,  370,
      369,  523,  541,  541,  541,  458,  517,  521,  517,  297,

      368,  459,  367,  517,  517,  517,  375,  375,  375,  565,
      565,  565,  376,  376,  542,  364,  376,  376,  376,  376,
      361,  377,  376,  376,  376,  376,  376,  543,  543,  543,
      360,  376,  359,  522,  522,  522,  522,  522,  522,  522,
      522,  522,  522,  522,  522,  522,  522,  522,  522,  522,
      522,  522,  376,  356,  378,  355,  522,  522,  522,  522,
      457,  326,  326,  522,  457,  326,  326,  352,  514,  458,
      550,  550,  550,  458,  351,  459,  457,  326,  326,  459,
      389,  242,  242,  350,  347,  458,  346,  462,  330,  330,
      345,  524,  462,  330,  330,  460,  463,  462,  330,  330,

      291,  463,  464,  393,  246,  246,  463,  464,  462,  330,
      330,  263,  464,  469,  338,  338,  343,  463,  465,  516,
      516,  516,  470,  525,  469,  338,  338,  340,  471,  469,
      338,  338,  202,  470,  469,  338,  338,  333,  470,  471,
      401,  256,  256,  470,  471,  474,  341,  341,  329,  528,
      474,  341,  341,  323,  475,  472,  405,  259,  259,  475,
      476,  474,  341,  341,  319,  476,  474,  341,  341,  318,
      475,  477,  409,  270,  270,  475,  476,  409,  270,  270,
      217,  529,  484,  348,  348,  193,  302,  480,  541,  541,
      541,  485,  410,  484,  348,  348,  297,  486,  484,  348,

      348,  294,  485,  484,  348,  348,  293,  485,  486,  288,
      542,  263,  485,  486,  261,  238,  411,  236,  533,  531,
      233,  411,  217,  215,  411,  214,  487,  213,  212,  411,
      211,  484,  348,  348,  487,  209,  208,  487,  199,  196,
      485,  189,  487,  185,  182,  487,  486,  487,  181,  180,
      487,  415,  274,  274,  162,  487,  415,  274,  274,  452,
      320,  320,  534,  457,  326,  326,  488,  161,  453,  153,
      822,  416,  458,  150,  523,  487,  150,  149,  524,  462,
      330,  330,  149,  487,  469,  338,  338,  136,  463,  566,
      566,  566,  136,  470,  525,  417,  135,  135,  535,  528,

      417,  129,  129,  417,  546,  546,  546,  124,  417,  517,
      518,  375,  375,  517,  517,  517,  124,  116,  517,  517,
      474,  341,  341,  116,  517,  551,  574,  574,  574,  475,
      822,  517,  517,  517,  517,  529,  517,  484,  348,  348,
      822,  409,  270,  270,  822,  822,  485,  415,  274,  274,
      822,  822,  533,  585,  586,  587,  410,  517,  521,  517,
      822,  822,  416,  822,  517,  517,  517,  375,  375,  375,
      558,  577,  577,  577,  376,  822,  561,  376,  376,  376,
      376,  487,  448,  449,  376,  411,  484,  348,  348,  487,
      822,  417,  376,  411,  822,  485,  589,  589,  589,  417,

      822,  486,  578,  588,  822,  579,  409,  270,  270,  415,
      274,  274,  822,  450,  822,  378,  484,  348,  348,  822,
      822,  410,  579,  822,  416,  485,  822,  822,  560,  822,
      487,  486,  822,  580,  822,  822,  583,  822,  487,  569,
      569,  569,  565,  565,  565,  582,  590,  566,  566,  566,
      411,  822,  822,  417,  591,  591,  591,  822,  411,  822,
      487,  417,  601,  601,  601,  585,  586,  587,  487,  570,
      571,  822,  822,  572,  589,  589,  589,  585,  586,  587,
      577,  577,  577,  573,  589,  589,  589,  591,  591,  591,
      572,  573,  575,  575,  575,  575,  575,  575,  575,  575,

      575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
      575,  578,  822,  822,  579,  575,  575,  575,  575,  684,
      684,  684,  575,  375,  375,  375,  409,  270,  270,  822,
      376,  579,  822,  376,  376,  376,  376,  822,  448,  449,
      376,  410,  608,  608,  608,  415,  274,  274,  376,  822,
      822,  609,  484,  348,  348,  822,  822,  610,  822,  822,
      416,  485,  684,  684,  684,  607,  822,  486,  822,  450,
      411,  378,  569,  569,  569,  684,  684,  684,  411,  611,
      732,  732,  732,  822,  612,  613,  613,  613,  822,  417,
      608,  608,  608,  822,  614,  822,  487,  417,  822,  609,

      615,  822,  592,  578,  487,  610,  593,  735,  735,  735,
      732,  732,  732,  762,  763,  764,  594,  765,  765,  765,
      735,  735,  735,  593,  594,  517,  518,  375,  375,  517,
      517,  517,  602,  519,  517,  517,  519,  519,  519,  519,
      517,  552,  553,  519,  602,  602,  602,  517,  517,  517,
      517,  519,  517,  602,  602,  602,  602,  602,  602,  602,
      602,  602,  602,  602,  602,  602,  602,  602,  602,  602,
      602,  602,  554,  517,  521,  517,  602,  602,  602,  602,
      517,  517,  517,  602,  409,  270,  270,  484,  348,  348,
      415,  274,  274,  768,  768,  768,  485,  822,  822,  410,

      822,  822,  486,  822,  822,  416,  822,  613,  613,  613,
      659,  660,  660,  822,  822,  634,  614,  822,  822,  661,
      822,  638,  615,  822,  822,  662,  637,  822,  411,  822,
      822,  487,  822,  822,  417,  822,  411,  822,  822,  487,
      822,  822,  417,  665,  608,  608,  484,  348,  348,  685,
      685,  685,  666,  822,  411,  485,  822,  822,  667,  822,
      822,  486,  411,  669,  670,  670,  675,  613,  613,  822,
      822,  686,  671,  822,  822,  676,  822,  668,  672,  822,
      822,  677,  685,  685,  685,  659,  660,  660,  822,  822,
      487,  409,  270,  270,  661,  685,  685,  685,  487,  822,

      662,  660,  660,  660,  686,  822,  701,  417,  822,  822,
      609,  697,  698,  698,  822,  417,  695,  686,  822,  822,
      408,  665,  608,  608,  822,  822,  699,  822,  822,  411,
      666,  665,  608,  608,  822,  411,  667,  411,  822,  822,
      666,  822,  822,  411,  822,  272,  667,  703,  704,  704,
      665,  608,  608,  272,  822,  700,  666,  822,  822,  666,
      822,  822,  705,  700,  822,  706,  707,  708,  708,  669,
      670,  670,  732,  732,  732,  709,  822,  822,  671,  822,
      822,  710,  822,  822,  672,  708,  708,  708,  714,  715,
      715,  415,  274,  274,  711,  822,  822,  414,  822,  822,

      712,  822,  822,  716,  822,  822,  718,  675,  613,  613,
      487,  822,  822,  417,  822,  822,  676,  822,  487,  822,
      822,  417,  677,  822,  675,  613,  613,  822,  822,  276,
      822,  822,  717,  676,  822,  417,  822,  276,  822,  677,
      717,  822,  822,  417,  720,  721,  721,  675,  613,  613,
      730,  730,  730,  676,  822,  822,  676,  822,  822,  722,
      822,  822,  723,  730,  730,  730,  409,  270,  270,  409,
      270,  270,  731,  822,  822,  738,  822,  822,  738,  822,
      822,  410,  822,  822,  410,  731,  270,  270,  270,  409,
      270,  270,  769,  769,  769,  663,  822,  822,  738,  822,

      822,  271,  822,  822,  480,  409,  270,  270,  822,  822,
      411,  822,  822,  411,  738,  735,  735,  735,  411,  822,
      410,  411,  740,  660,  660,  665,  608,  608,  822,  822,
      272,  741,  822,  411,  744,  822,  481,  742,  272,  822,
      667,  411,  822,  665,  608,  608,  608,  608,  608,  411,
      822,  822,  744,  822,  822,  745,  822,  411,  667,  822,
      822,  610,  665,  608,  608,  822,  743,  665,  608,  608,
      822,  744,  822,  822,  743,  822,  666,  706,  707,  708,
      708,  822,  706,  708,  708,  708,  822,  709,  747,  748,
      748,  822,  711,  710,  730,  730,  730,  485,  712,  484,

      348,  348,  822,  749,  415,  274,  274,  822,  485,  415,
      274,  274,  822,  753,  751,  822,  731,  822,  753,  416,
      822,  822,  487,  822,  416,  822,  822,  276,  822,  822,
      487,  822,  750,  822,  822,  276,  822,  348,  348,  348,
      750,  822,  822,  487,  822,  822,  754,  822,  417,  822,
      822,  487,  349,  417,  822,  822,  417,  415,  274,  274,
      822,  417,  415,  274,  274,  822,  753,  756,  670,  670,
      822,  753,  488,  769,  769,  769,  757,  416,  762,  763,
      764,  276,  758,  675,  613,  613,  765,  765,  765,  276,
      822,  822,  760,  489,  822,  675,  613,  613,  677,  822,

      822,  417,  822,  822,  760,  822,  417,  822,  822,  417,
      677,  759,  822,  822,  417,  613,  613,  613,  822,  759,
      675,  613,  613,  822,  761,  675,  613,  613,  822,  760,
      615,  409,  270,  270,  676,  723,  740,  660,  660,  822,
      723,  740,  660,  660,  822,  741,  410,  762,  763,  764,
      741,  771,  740,  660,  660,  822,  771,  773,  774,  774,
      822,  741,  740,  660,  660,  822,  741,  771,  765,  765,
      765,  741,  775,  822,  822,  411,  822,  777,  822,  822,
      743,  822,  822,  411,  822,  743,  822,  822,  743,  822,
      740,  660,  660,  743,  822,  822,  743,  822,  822,  741,

      822,  776,  822,  822,  743,  771,  743,  822,  822,  776,
      703,  704,  704,  822,  743,  484,  348,  348,  822,  666,
      822,  778,  822,  822,  779,  705,  484,  348,  348,  822,
      486,  348,  348,  348,  743,  779,  484,  348,  348,  822,
      754,  486,  743,  822,  822,  779,  349,  822,  484,  348,
      348,  533,  822,  781,  708,  708,  822,  779,  822,  487,
      822,  822,  782,  486,  768,  768,  768,  487,  783,  822,
      487,  822,  781,  708,  708,  276,  822,  822,  487,  534,
      487,  782,  822,  276,  415,  274,  274,  785,  487,  756,
      670,  670,  487,  756,  670,  670,  822,  784,  757,  416,

      487,  822,  757,  822,  786,  784,  822,  822,  786,  822,
      788,  789,  789,  768,  768,  768,  784,  822,  822,  757,
      756,  670,  670,  822,  784,  790,  822,  822,  417,  757,
      769,  769,  769,  759,  822,  792,  417,  759,  756,  670,
      670,  759,  720,  721,  721,  759,  822,  757,  795,  795,
      795,  676,  822,  786,  791,  822,  822,  722,  740,  660,
      660,  822,  791,  822,  759,  822,  822,  741,  822,  793,
      822,  822,  759,  777,  740,  660,  660,  740,  660,  660,
      822,  822,  759,  796,  822,  822,  796,  822,  822,  771,
      759,  822,  771,  822,  660,  660,  660,  740,  660,  660,

      822,  822,  743,  745,  822,  822,  796,  822,  822,  695,
      743,  822,  777,  740,  660,  660,  822,  822,  743,  822,
      822,  743,  796,  795,  795,  795,  743,  822,  771,  743,
      740,  660,  660,  740,  660,  660,  822,  822,  272,  741,
      822,  743,  741,  822,  778,  777,  272,  822,  771,  743,
      822,  484,  348,  348,  781,  708,  708,  743,  822,  822,
      485,  822,  822,  782,  822,  743,  486,  822,  822,  785,
      822,  781,  708,  708,  743,  797,  822,  743,  822,  822,
      782,  822,  743,  822,  822,  743,  785,  799,  800,  800,
      781,  708,  708,  822,  822,  487,  782,  822,  784,  782,

      822,  822,  801,  487,  822,  803,  784,  781,  708,  708,
      781,  708,  708,  822,  822,  784,  782,  822,  822,  782,
      822,  822,  785,  784,  822,  803,  756,  670,  670,  822,
      822,  802,  822,  822,  784,  757,  822,  822,  804,  802,
      822,  792,  784,  756,  670,  670,  756,  670,  670,  822,
      822,  784,  805,  822,  784,  805,  822,  822,  786,  784,
      822,  786,  784,  822,  708,  708,  708,  756,  670,  670,
      759,  822,  822,  806,  822,  822,  805,  822,  759,  712,
      822,  822,  792,  822,  756,  670,  670,  759,  822,  822,
      759,  822,  822,  805,  822,  759,  822,  822,  759,  786,

      795,  795,  795,  756,  670,  670,  822,  822,  276,  822,
      822,  759,  757,  822,  822,  793,  276,  822,  792,  759,
      756,  670,  670,  773,  774,  774,  822,  822,  759,  757,
      822,  822,  741,  822,  822,  786,  759,  822,  775,  740,
      660,  660,  781,  708,  708,  822,  822,  759,  741,  822,
      822,  809,  822,  822,  771,  759,  822,  785,  822,  822,
      822,  822,  807,  822,  759,  822,  822,  776,  808,  781,
      708,  708,  759,  822,  822,  776,  822,  822,  809,  822,
      708,  708,  708,  743,  785,  822,  784,  822,  822,  806,
      822,  743,  822,  822,  784,  712,  781,  708,  708,  781,

      708,  708,  822,  822,  822,  809,  822,  822,  809,  822,
      822,  803,  822,  784,  785,  822,  781,  708,  708,  822,
      822,  784,  822,  822,  276,  782,  822,  781,  708,  708,
      804,  803,  276,  822,  822,  822,  782,  788,  789,  789,
      784,  822,  785,  784,  822,  822,  757,  822,  784,  822,
      822,  784,  790,  822,  822,  756,  670,  670,  822,  822,
      784,  822,  822,  822,  757,  740,  660,  660,  784,  810,
      786,  784,  822,  822,  741,  822,  799,  800,  800,  784,
      771,  791,  822,  822,  811,  782,  781,  708,  708,  791,
      822,  801,  812,  822,  822,  782,  756,  670,  670,  759,

      822,  785,  822,  822,  822,  757,  822,  759,  822,  743,
      822,  786,  740,  660,  660,  813,  822,  743,  822,  822,
      802,  741,  822,  814,  822,  822,  822,  771,  802,  822,
      784,  822,  781,  708,  708,  756,  670,  670,  784,  822,
      759,  782,  822,  822,  757,  822,  822,  785,  759,  822,
      786,  815,  740,  660,  660,  822,  743,  822,  822,  816,
      822,  741,  822,  822,  743,  822,  822,  771,  822,  822,
      822,  781,  708,  708,  817,  822,  784,  822,  822,  759,
      782,  822,  822,  818,  784,  822,  785,  759,  756,  670,
      670,  740,  660,  660,  822,  822,  743,  757,  822,  822,

      741,  822,  822,  786,  743,  822,  771,  781,  708,  708,
      819,  756,  670,  670,  822,  784,  782,  822,  822,  820,
      757,  822,  785,  784,  822,  822,  786,  781,  708,  708,
      822,  822,  759,  822,  822,  743,  782,  822,  821,  822,
      759,  822,  785,  743,  822,  822,  822,  822,  822,  822,
      822,  784,  822,  822,  822,  759,  822,  822,  822,  784,
      822,  822,  822,  759,  822,  822,  822,  822,  822,  822,
      822,  784,  822,  822,  822,  822,  822,  822,  822,  784,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,

       46,   46,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  104,  104,  104,  104,  104,  104,
      104,  104,  104,  104,  108,  108,  108,  108,  108,  108,
      108,  108,  108,  108,  108,  108,  108,  108,  108,  108,
      108,  108,  108,  108,  108,  108,  115,  115,  115,  115,
      115,  115,  115,  115,  115,  115,  115,  115,  115,  115,
      115,  115,  115,  115,  115,  115,  115,  115,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      117,  117,  117,  117,  117,  117,  117,  117,  117,  117,
      123,  123,  123,  123,  123,  123,  123,  123,  123,  123,

      123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
      123,  123,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  128,  128,  128,  128,  128,  128,
      128,  128,  128,  128,  128,  128,  128,  128,  128,  128,
      128,  128,  128,  128,  128,  128,  130,  130,  130,  130,
      130,  130,  130,  130,  130,  130,  130,  130,  130,  130,
      130,  130,  130,  130,  130,  130,  130,  130,  134,  134,
      134,  134,  134,  134,  134,  134,  134,  134,  134,  134,
      134,  134,  134,  134,  134,  134,  134,  134,  134,  134,

      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  139,  139,  139,  139,  139,  139,  139,  139,
      139,  139,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  183,  822,  822,  822,
      822,  822,  822,  822,  183,  822,  822,  822,  822,  822,
      183,  183,  188,  822,  822,  188,  822,  822,  188,  188,
      822,  188,  822,  822,  822,  188,  188,  188,  195,  822,

      822,  822,  822,  822,  822,  822,  195,  822,  822,  822,
      822,  822,  195,  195,  205,  822,  822,  205,  822,  205,
      205,  210,  822,  822,  822,  822,  822,  822,  822,  210,
      822,  822,  822,  822,  822,  210,  210,  216,  216,  216,
      216,  822,  216,  216,  216,  216,  216,  216,  216,  216,
      216,  216,  216,  822,  216,  822,  216,  216,  216,  218,
      218,  218,  218,  822,  218,  218,  218,  218,  218,  218,
      218,  218,  218,  218,  218,  218,  218,  218,  218,  218,
      218,  219,  219,  219,  219,  219,  219,  219,  219,  219,
      219,  219,  219,  219,  219,  219,  219,  219,  219,  822,

      219,  219,  219,  222,  822,  822,  822,  822,  822,  822,
      822,  222,  822,  822,  822,  822,  822,  222,  222,  224,
      224,  822,  822,  224,  822,  822,  822,  822,  822,  822,
      822,  224,  822,  224,  822,  822,  822,  224,  224,  226,
      226,  226,  226,  226,  226,  226,  822,  226,  226,  226,
      226,  226,  226,  226,  226,  226,  226,  226,  226,  226,
      226,  230,  230,  230,  230,  230,  230,  230,  230,  230,
      822,  230,  230,  822,  230,  230,  230,  230,  230,  230,
      230,  230,  230,  237,  237,  237,  237,  822,  237,  237,
      237,  237,  237,  237,  237,  237,  237,  237,  237,  237,

      237,  237,  237,  237,  237,  240,  240,  240,  240,  240,
      240,  240,  822,  240,  240,  240,  240,  240,  240,  240,
      240,  240,  240,  240,  240,  240,  240,  244,  244,  244,
      244,  244,  244,  244,  822,  244,  244,  244,  244,  244,
      244,  244,  244,  244,  244,  244,  244,  244,  249,  249,
      249,  249,  249,  249,  249,  249,  249,  249,  249,  249,
      249,  249,  249,  249,  249,  249,  249,  249,  249,  249,
      254,  254,  254,  254,  254,  254,  254,  822,  254,  254,
      254,  254,  254,  254,  254,  254,  254,  254,  254,  254,
      254,  254,  262,  262,  262,  262,  262,  822,  262,  262,

      262,  262,  262,  262,  262,  262,  262,  262,  262,  262,
      262,  262,  262,  262,  266,  266,  822,  822,  266,  822,
      822,  822,  822,  822,  822,  822,  266,  822,  266,  822,
      822,  822,  266,  266,  295,  822,  822,  295,  822,  822,
      295,  295,  822,  295,  822,  822,  822,  295,  295,  295,
      296,  296,  296,  296,  296,  296,  296,  296,  296,  296,
      296,  296,  296,  296,  296,  296,  296,  296,  296,  296,
      296,  296,  305,  822,  822,  822,  822,  822,  822,  822,
      305,  822,  822,  822,  822,  822,  305,  305,  306,  306,
      822,  306,  306,  306,  306,  306,  306,  306,  306,  306,

      306,  306,  306,  306,  306,  306,  306,  306,  306,  306,
      308,  822,  822,  308,  822,  822,  308,  308,  822,  308,
      822,  822,  822,  308,  308,  308,  312,  822,  822,  822,
      822,  312,  312,  822,  312,  822,  822,  822,  822,  822,
      312,  312,  324,  822,  822,  324,  822,  822,  324,  324,
      822,  324,  822,  822,  822,  324,  324,  324,  325,  822,
      822,  325,  822,  822,  325,  325,  822,  325,  822,  822,
      822,  325,  325,  325,  344,  822,  822,  822,  822,  822,
      822,  822,  344,  822,  822,  822,  822,  822,  344,  344,
      376,  376,  822,  822,  376,  376,  822,  376,  376,  376,

      376,  376,  376,  822,  822,  822,  822,  376,  376,  376,
      384,  384,  384,  384,  384,  384,  384,  384,  384,  384,
      384,  384,  384,  384,  384,  384,  384,  384,  384,  384,
      384,  384,  388,  388,  388,  388,  388,  388,  388,  388,
      388,  388,  388,  388,  388,  388,  388,  388,  388,  388,
      388,  388,  388,  388,  392,  392,  392,  392,  392,  392,
      392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
      392,  392,  392,  392,  392,  392,  400,  400,  400,  400,
      400,  400,  400,  400,  400,  400,  400,  400,  400,  400,
      400,  400,  400,  400,  400,  400,  400,  400,  404,  404,

      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  408,  408,  408,
      408,  408,  414,  414,  414,  414,  414,  414,  414,  414,
      414,  414,  414,  414,  414,  414,  414,  414,  414,  414,
      414,  414,  414,  414,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  419,  419,  419,  419,
      419,  419,  419,  419,  419,  419,  446,  822,  822,  822,
      822,  446,  446,  822,  446,  822,  822,  822,  822,  822,

      446,  446,  451,  451,  451,  451,  451,  451,  451,  451,
      451,  451,  451,  451,  451,  451,  451,  451,  451,  451,
      451,  451,  451,  451,  456,  456,  456,  456,  456,  456,
      456,  456,  456,  456,  456,  456,  456,  456,  456,  456,
      456,  456,  456,  456,  456,  456,  461,  461,  461,  461,
      461,  461,  461,  461,  461,  461,  461,  461,  461,  461,
      461,  461,  461,  461,  461,  461,  461,  461,  468,  468,
      468,  468,  468,  468,  468,  468,  468,  468,  468,  468,
      468,  468,  468,  468,  468,  468,  468,  468,  468,  468,
      473,  473,  473,  473,  473,  473,  473,  473,  473,  473,

      473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
      473,  473,  483,  483,  483,  483,  483,  483,  483,  483,
      483,  483,  483,  483,  483,  483,  483,  483,  483,  483,
      483,  483,  483,  483,  491,  491,  491,  491,  491,  491,
      491,  491,  491,  491,  491,  491,  822,  491,  491,  491,
      491,  491,  491,  491,  491,  491,  519,  519,  519,  519,
      519,  519,  519,  519,  519,  519,  519,  519,  519,  519,
      519,  519,  519,  519,  519,  519,  519,  519,  555,  555,
      822,  822,  555,  555,  822,  555,  555,  555,  555,  555,
      555,  822,  822,  822,  822,  555,  555,  555,  635,  635,

      635,  635,  635,  635,  635,  822,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      639,  639,  639,  639,  639,  639,  639,  822,  639,  639,
      639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
      639,  639,  664,  664,  664,  664,  664,  664,  664,  664,
      664,  664,  664,  664,  664,  664,  664,  664,  664,  664,
      664,  664,  664,  664,  674,  674,  674,  674,  674,  674,
      674,  674,  674,  674,  674,  674,  674,  674,  674,  674,
      674,  674,  674,  674,  674,  674,  696,  696,  696,  696,
      696,  696,  696,  696,  696,  696,  696,  696,  696,  696,

      696,  696,  696,  696,  696,  696,  696,  696,  702,  702,
      702,  702,  702,  702,  702,  702,  702,  702,  702,  702,
      702,  702,  702,  702,  702,  702,  702,  702,  702,  702,
      713,  713,  713,  713,  713,  713,  713,  713,  713,  713,
      713,  713,  713,  713,  713,  713,  713,  713,  713,  713,
      713,  713,  719,  719,  719,  719,  719,  719,  719,  719,
      719,  719,  719,  719,  719,  719,  719,  719,  719,  719,
      719,  719,  719,  719,  739,  739,  739,  739,  739,  739,
      739,  739,  739,  739,  739,  739,  739,  739,  739,  739,
      739,  739,  739,  739,  739,  739,  746,  746,  746,  746,

      746,  746,  746,  746,  746,  746,  746,  746,  746,  746,
      746,  746,  746,  746,  746,  746,  746,  746,  755,  755,
      755,  755,  755,  755,  755,  755,  755,  755,  755,  755,
      755,  755,  755,  755,  755,  755,  755,  755,  755,  755,
      772,  772,  772,  772,  772,  772,  772,  772,  772,  772,
      772,  772,  772,  772,  772,  772,  772,  772,  772,  772,
      772,  772,  780,  780,  780,  780,  780,  780,  780,  780,
      780,  780,  780,  780,  780,  780,  780,  780,  780,  780,
      780,  780,  780,  780,  787,  787,  787,  787,  787,  787,
      787,  787,  787,  787,  787,  787,  787,  787,  787,  787,

      787,  787,  787,  787,  787,  787,  798,  798,  798,  798,
      798,  798,  798,  798,  798,  798,  798,  798,  798,  798,
      798,  798,  798,  798,  798,  798,  798,  798,   45,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822
    } ;

static yyconst flex_int16_t yy_chk[5189] =
    {   0,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,

        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    7,  158,
       60,  158,    8,    9,    9,    9,   10,   10,   10,   19,
       20,   60,  767,   35,   19,   20,    7,    7,   35,    7,
        8,    8,   36,    8,  571,    9,  571,   36,   10,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,   11,   11,   11,

       11,   11,   11,   11,   11,   11,   11,   11,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,   17,   23,   17,
       33,   17,   17,   24,   34,   27,   17,   17,   73,   17,
      127,   17,  578,   27,  578,   28,   73,   17,   17,   17,
       17,   94,   52,   28,   94,   39,   39,   39,   48,   48,

       48,   39,   59,   48,   40,   40,   40,   59,   33,   52,
       40,   23,   34,   17,   59,  734,   24,  727,   62,   17,
       18,   27,   18,  127,   18,   18,   39,   62,   62,   18,
       18,   28,   18,  119,   18,   40,   95,   95,  119,  726,
       18,   18,   18,   18,   49,   49,   49,   53,   53,   49,
       63,   53,  250,  250,  121,   64,   63,   63,   63,  121,
       64,   53,  148,  194,  194,  194,   18,   64,   53,   53,
      148,  712,   18,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,

       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   37,   37,   37,   37,   37,   37,   37,   37,
       37,   37,   65,  159,   65,   65,   65,   66,  159,   66,
       66,   66,  695,   80,   80,   80,   85,   65,   80,   81,
       81,   81,   66,   91,   81,   91,   91,   91,   85,   85,
       85,   65,   93,  191,   93,   93,   93,  191,  147,   65,
       84,  147,   84,  163,   84,   84,  214,   93,  163,   84,
       84,  214,   84,  858,   84,  109,  109,  109,  147,  858,
       84,   84,   84,   84,  152,  114,  114,  114,  116,  116,

      116,   84,  133,  133,  129,  129,  129,  109,  143,  143,
      143,  152,  187,  116,  694,  231,   84,  114,   84,  129,
      231,  234,   84,  132,  132,  132,  234,  192,  133,  187,
      143,  192,  132,  135,  135,  135,  133,  133,  132,  137,
      137,  137,  135,  136,  136,  136,  334,  334,  135,  149,
      149,  149,  136,  149,  137,  205,  205,  865,  136,  150,
      150,  150,  282,  865,  149,  151,  151,  151,  150,  282,
      151,  155,  690,  156,  150,  155,  155,  156,  156,  172,
      172,  172,  176,  176,  176,  177,  205,  177,  177,  177,
      689,  422,  172,  149,  683,  176,  422,  198,  198,  198,

      177,  149,  178,  150,  178,  869,  869,  178,  178,  178,
      198,  150,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
      154,  186,  186,  186,  682,  492,  186,  190,  680,  190,
      492,  190,  190,  200,  200,  200,  190,  190,  285,  190,
      201,  190,  201,  201,  201,  285,  200,  190,  190,  190,

      190,  202,  679,  202,  678,  201,  202,  202,  202,  220,
      220,  220,  312,  312,  223,  223,  223,  291,  658,  224,
      224,  224,  657,  190,  291,  426,  265,  265,  265,  190,
      196,  220,  196,  426,  196,  196,  223,  374,  374,  196,
      196,  224,  196,  312,  196,  227,  227,  227,  265,  656,
      196,  196,  196,  196,  228,  228,  228,  241,  241,  241,
      227,  361,  430,  228,  242,  242,  242,  437,  374,  228,
      430,  552,  241,  242,  653,  437,  196,  651,  361,  242,
      364,  552,  196,  245,  245,  245,  246,  246,  246,  255,
      255,  255,  299,  299,  299,  246,  598,  364,  245,  650,

      649,  246,  621,  598,  255,  256,  256,  256,  258,  258,
      258,  266,  266,  266,  256,  259,  259,  259,  646,  621,
      256,  606,  645,  258,  259,  270,  270,  270,  606,  644,
      259,  624,  639,  266,  273,  273,  273,  274,  274,  274,
      270,  866,  289,  298,  298,  298,  274,  866,  624,  273,
      289,  635,  274,  300,  300,  300,  298,  641,  309,  289,
      309,  309,  309,  631,  310,  641,  310,  310,  310,  270,
      311,  311,  311,  309,  371,  371,  371,  270,  273,  310,
      631,  274,  633,  369,  369,  369,  273,  446,  446,  274,
      277,  277,  277,  277,  277,  277,  277,  277,  277,  277,

      277,  277,  277,  277,  277,  277,  277,  277,  277,  315,
      315,  315,  352,  352,  277,  277,  277,  303,  446,  303,
      632,  303,  303,  352,  315,  369,  303,  303,  352,  303,
      513,  303,  318,  318,  318,  513,  572,  303,  303,  303,
      303,  572,  319,  319,  319,  596,  320,  320,  320,  630,
      323,  323,  323,  596,  318,  320,  629,  315,  326,  326,
      326,  320,  596,  303,  319,  323,  593,  326,  628,  303,
      307,  593,  307,  326,  307,  307,  407,  407,  407,  307,
      307,  642,  307,  627,  307,  329,  329,  329,  626,  642,
      307,  307,  307,  307,  330,  330,  330,  333,  333,  333,

      329,  867,  652,  330,  338,  338,  338,  867,  625,  330,
      652,  874,  333,  338,  521,  521,  307,  874,  407,  338,
      643,  623,  307,  340,  340,  340,  341,  341,  341,  343,
      343,  343,  346,  346,  346,  341,  875,  643,  340,  622,
      620,  341,  875,  619,  343,  521,  681,  346,  348,  348,
      348,  350,  350,  350,  681,  618,  372,  348,  372,  372,
      372,  419,  419,  348,  876,  373,  350,  373,  373,  373,
      876,  372,  419,  375,  375,  375,  346,  419,  421,  421,
      373,  383,  383,  383,  346,  379,  379,  379,  375,  421,
      383,  617,  348,  616,  421,  350,  383,  376,  376,  376,

      348,  615,  610,  350,  370,  370,  370,  379,  370,  605,
      370,  370,  376,  886,  600,  370,  370,  599,  370,  886,
      370,  375,  377,  377,  377,  597,  370,  370,  370,  370,
      595,  378,  378,  378,  381,  381,  381,  377,  384,  384,
      384,  594,  385,  385,  385,  376,  378,  378,  386,  386,
      386,  592,  370,  384,  590,  588,  381,  385,  370,  387,
      387,  387,  579,  386,  573,  388,  388,  388,  387,  887,
      377,  389,  389,  389,  387,  887,  570,  378,  893,  378,
      388,  390,  390,  390,  893,  562,  389,  604,  391,  391,
      391,  392,  392,  392,  559,  604,  390,  391,  393,  393,

      393,  551,  550,  391,  604,  547,  392,  394,  394,  394,
      399,  399,  399,  393,  400,  400,  400,  894,  896,  399,
      545,  539,  394,  894,  896,  399,  401,  401,  401,  400,
      402,  402,  402,  403,  403,  403,  404,  404,  404,  537,
      897,  401,  403,  898,  536,  402,  897,  532,  403,  898,
      530,  404,  405,  405,  405,  406,  406,  406,  408,  408,
      408,  409,  409,  409,  410,  410,  410,  405,  520,  512,
      406,  511,  509,  408,  508,  502,  409,  501,  500,  410,
      411,  411,  411,  413,  413,  413,  414,  414,  414,  415,
      415,  415,  413,  499,  497,  411,  496,  495,  413,  493,

      854,  414,  408,  491,  415,  409,  490,  482,  410,  479,
      408,  411,  440,  409,  854,  854,  410,  438,  436,  416,
      416,  416,  435,  434,  411,  431,  429,  413,  428,  427,
      414,  425,  411,  415,  416,  413,  424,  423,  414,  420,
      418,  415,  417,  417,  417,  432,  432,  432,  433,  433,
      433,  439,  439,  439,  412,  368,  443,  417,  443,  443,
      443,  367,  444,  416,  444,  444,  444,  445,  445,  445,
      433,  416,  366,  417,  450,  450,  450,  444,  365,  363,
      445,  448,  448,  448,  362,  360,  417,  359,  358,  450,
      503,  503,  503,  439,  417,  442,  448,  442,  357,  442,

      442,  478,  478,  478,  442,  442,  448,  442,  356,  442,
      451,  451,  451,  355,  354,  442,  442,  442,  442,  451,
      353,  351,  450,  349,  347,  451,  507,  507,  507,  448,
      452,  452,  452,  504,  504,  504,  510,  510,  510,  452,
      345,  442,  344,  478,  342,  452,  339,  442,  447,  447,
      447,  447,  447,  447,  447,  504,  332,  447,  447,  453,
      453,  453,  328,  447,  447,  455,  455,  455,  453,  322,
      447,  447,  447,  447,  453,  447,  454,  454,  454,  313,
      455,  514,  514,  514,  305,  454,  456,  456,  456,  304,
      302,  454,  506,  506,  506,  456,  447,  447,  447,  296,

      293,  456,  292,  447,  447,  447,  449,  449,  449,  540,
      540,  540,  449,  449,  506,  290,  449,  449,  449,  449,
      288,  449,  449,  449,  449,  449,  449,  543,  543,  543,
      287,  449,  286,  449,  449,  449,  449,  449,  449,  449,
      449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
      449,  449,  449,  284,  449,  283,  449,  449,  449,  449,
      457,  457,  457,  449,  458,  458,  458,  280,  515,  457,
      515,  515,  515,  458,  276,  457,  459,  459,  459,  458,
      460,  460,  460,  275,  272,  459,  271,  461,  461,  461,
      269,  459,  462,  462,  462,  460,  461,  463,  463,  463,

      268,  462,  461,  465,  465,  465,  463,  462,  464,  464,
      464,  264,  463,  468,  468,  468,  260,  464,  465,  516,
      516,  516,  468,  464,  469,  469,  469,  257,  468,  470,
      470,  470,  516,  469,  471,  471,  471,  248,  470,  469,
      472,  472,  472,  471,  470,  473,  473,  473,  243,  471,
      474,  474,  474,  229,  473,  472,  477,  477,  477,  474,
      473,  475,  475,  475,  219,  474,  476,  476,  476,  218,
      475,  477,  480,  480,  480,  476,  475,  481,  481,  481,
      216,  476,  483,  483,  483,  195,  184,  480,  541,  541,
      541,  483,  481,  484,  484,  484,  174,  483,  485,  485,

      485,  170,  484,  486,  486,  486,  160,  485,  484,  157,
      541,  141,  486,  485,  138,  124,  480,  122,  486,  481,
      120,  481,  104,  103,  480,  102,  483,  101,  100,  481,
       99,  487,  487,  487,  483,   97,   96,  484,   92,   90,
      487,   82,  485,   77,   71,  484,  487,  486,   70,   69,
      485,  488,  488,  488,   55,  486,  489,  489,  489,  523,
      523,  523,  487,  524,  524,  524,  488,   54,  523,   50,
       45,  489,  524,   44,  523,  487,   43,   42,  524,  525,
      525,  525,   41,  487,  528,  528,  528,   32,  525,  544,
      544,  544,   31,  528,  525,  488,   30,   29,  489,  528,

      489,   26,   25,  488,  546,  546,  546,   22,  489,  517,
      517,  517,  517,  517,  517,  517,   21,   16,  517,  517,
      529,  529,  529,   15,  517,  517,  549,  549,  549,  529,
        0,  517,  517,  517,  517,  529,  517,  533,  533,  533,
        0,  531,  531,  531,    0,    0,  533,  535,  535,  535,
        0,    0,  533,  563,  563,  563,  531,  517,  517,  517,
        0,    0,  535,    0,  517,  517,  517,  522,  522,  522,
      531,  557,  557,  557,  522,    0,  535,  522,  522,  522,
      522,  533,  522,  522,  522,  531,  534,  534,  534,  533,
        0,  535,  522,  531,    0,  534,  564,  564,  564,  535,

        0,  534,  557,  563,    0,  557,  558,  558,  558,  561,
      561,  561,    0,  522,    0,  522,  560,  560,  560,    0,
        0,  558,  557,    0,  561,  560,    0,    0,  534,    0,
      534,  560,    0,  558,    0,    0,  561,    0,  534,  548,
      548,  548,  565,  565,  565,  560,  564,  566,  566,  566,
      558,    0,    0,  561,  567,  567,  567,    0,  558,    0,
      560,  561,  574,  574,  574,  585,  585,  585,  560,  548,
      548,    0,    0,  548,  586,  586,  586,  587,  587,  587,
      577,  577,  577,  548,  589,  589,  589,  591,  591,  591,
      548,  548,  553,  553,  553,  553,  553,  553,  553,  553,

      553,  553,  553,  553,  553,  553,  553,  553,  553,  553,
      553,  577,    0,    0,  577,  553,  553,  553,  553,  647,
      647,  647,  553,  555,  555,  555,  580,  580,  580,    0,
      555,  577,    0,  555,  555,  555,  555,    0,  555,  555,
      555,  580,  581,  581,  581,  583,  583,  583,  555,    0,
        0,  581,  582,  582,  582,    0,    0,  581,    0,    0,
      583,  582,  654,  654,  654,  580,    0,  582,    0,  555,
      580,  555,  568,  568,  568,  684,  684,  684,  580,  582,
      688,  688,  688,    0,  583,  584,  584,  584,    0,  583,
      608,  608,  608,    0,  584,    0,  582,  583,    0,  608,

      584,    0,  568,  568,  582,  608,  568,  691,  691,  691,
      693,  693,  693,  724,  724,  724,  568,  725,  725,  725,
      728,  728,  728,  568,  568,  575,  575,  575,  575,  575,
      575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
      575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
      575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
      575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
      575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
      575,  575,  575,  575,  607,  607,  607,  611,  611,  611,
      612,  612,  612,  729,  729,  729,  611,    0,    0,  607,

        0,    0,  611,    0,    0,  612,    0,  613,  613,  613,
      634,  634,  634,    0,    0,  607,  613,    0,    0,  634,
        0,  612,  613,    0,    0,  634,  611,    0,  607,    0,
        0,  611,    0,    0,  612,    0,  607,    0,    0,  611,
        0,    0,  612,  636,  636,  636,  637,  637,  637,  648,
      648,  648,  636,    0,  634,  637,    0,    0,  636,    0,
        0,  637,  634,  638,  638,  638,  640,  640,  640,    0,
        0,  648,  638,    0,    0,  640,    0,  637,  638,    0,
        0,  640,  655,  655,  655,  659,  659,  659,    0,    0,
      637,  662,  662,  662,  659,  685,  685,  685,  637,    0,

      659,  660,  660,  660,  655,    0,  662,  638,    0,    0,
      660,  661,  661,  661,    0,  638,  660,  685,    0,    0,
      661,  664,  664,  664,    0,    0,  661,    0,    0,  659,
      664,  665,  665,  665,    0,  662,  664,  659,    0,    0,
      665,    0,    0,  662,    0,  660,  665,  666,  666,  666,
      667,  667,  667,  660,    0,  661,  666,    0,    0,  667,
        0,    0,  666,  661,    0,  667,  668,  668,  668,  669,
      669,  669,  732,  732,  732,  668,    0,    0,  669,    0,
        0,  668,    0,    0,  669,  670,  670,  670,  671,  671,
      671,  672,  672,  672,  670,    0,    0,  671,    0,    0,

      670,    0,    0,  671,    0,    0,  672,  674,  674,  674,
      668,    0,    0,  669,    0,    0,  674,    0,  668,    0,
        0,  669,  674,    0,  675,  675,  675,    0,    0,  670,
        0,    0,  671,  675,    0,  672,    0,  670,    0,  675,
      671,    0,    0,  672,  676,  676,  676,  677,  677,  677,
      687,  687,  687,  676,    0,    0,  677,    0,    0,  676,
        0,    0,  677,  692,  692,  692,  696,  696,  696,  697,
      697,  697,  687,    0,    0,  696,    0,    0,  697,    0,
        0,  696,    0,    0,  697,  692,  698,  698,  698,  699,
      699,  699,  733,  733,  733,  698,    0,    0,  699,    0,

        0,  698,    0,    0,  699,  700,  700,  700,    0,    0,
      696,    0,    0,  697,  700,  735,  735,  735,  696,    0,
      700,  697,  701,  701,  701,  702,  702,  702,    0,    0,
      698,  701,    0,  699,  702,    0,  700,  701,  698,    0,
      702,  699,    0,  703,  703,  703,  704,  704,  704,  700,
        0,    0,  703,    0,    0,  704,    0,  700,  703,    0,
        0,  704,  705,  705,  705,    0,  701,  706,  706,  706,
        0,  705,    0,    0,  701,    0,  706,  705,  707,  707,
      707,    0,  706,  708,  708,  708,    0,  707,  709,  709,
      709,    0,  708,  707,  730,  730,  730,  709,  708,  710,

      710,  710,    0,  709,  713,  713,  713,    0,  710,  714,
      714,  714,    0,  713,  710,    0,  730,    0,  714,  713,
        0,    0,  707,    0,  714,    0,    0,  708,    0,    0,
      707,    0,  709,    0,    0,  708,    0,  715,  715,  715,
      709,    0,    0,  710,    0,    0,  715,    0,  713,    0,
        0,  710,  715,  714,    0,    0,  713,  716,  716,  716,
        0,  714,  717,  717,  717,    0,  716,  718,  718,  718,
        0,  717,  716,  736,  736,  736,  718,  717,  762,  762,
      762,  715,  718,  719,  719,  719,  763,  763,  763,  715,
        0,    0,  719,  717,    0,  720,  720,  720,  719,    0,

        0,  716,    0,    0,  720,    0,  717,    0,    0,  716,
      720,  718,    0,    0,  717,  721,  721,  721,    0,  718,
      722,  722,  722,    0,  721,  723,  723,  723,    0,  722,
      721,  738,  738,  738,  723,  722,  737,  737,  737,    0,
      723,  739,  739,  739,    0,  737,  738,  764,  764,  764,
      739,  737,  740,  740,  740,    0,  739,  741,  741,  741,
        0,  740,  742,  742,  742,    0,  741,  740,  765,  765,
      765,  742,  741,    0,    0,  738,    0,  742,    0,    0,
      737,    0,    0,  738,    0,  739,    0,    0,  737,    0,
      743,  743,  743,  739,    0,    0,  740,    0,    0,  743,

        0,  741,    0,    0,  740,  743,  742,    0,    0,  741,
      744,  744,  744,    0,  742,  746,  746,  746,    0,  744,
        0,  743,    0,    0,  746,  744,  747,  747,  747,    0,
      746,  748,  748,  748,  743,  747,  749,  749,  749,    0,
      748,  747,  743,    0,    0,  749,  748,    0,  750,  750,
      750,  749,    0,  751,  751,  751,    0,  750,    0,  746,
        0,    0,  751,  750,  766,  766,  766,  746,  751,    0,
      747,    0,  752,  752,  752,  748,    0,    0,  747,  750,
      749,  752,    0,  748,  753,  753,  753,  752,  749,  755,
      755,  755,  750,  756,  756,  756,    0,  751,  755,  753,

      750,    0,  756,    0,  755,  751,    0,    0,  756,    0,
      757,  757,  757,  768,  768,  768,  752,    0,    0,  757,
      758,  758,  758,    0,  752,  757,    0,    0,  753,  758,
      769,  769,  769,  755,    0,  758,  753,  756,  759,  759,
      759,  755,  760,  760,  760,  756,    0,  759,  770,  770,
      770,  760,    0,  759,  757,    0,    0,  760,  771,  771,
      771,    0,  757,    0,  758,    0,    0,  771,    0,  759,
        0,    0,  758,  771,  772,  772,  772,  773,  773,  773,
        0,    0,  759,  772,    0,    0,  773,    0,    0,  772,
      759,    0,  773,    0,  774,  774,  774,  775,  775,  775,

        0,    0,  771,  774,    0,    0,  775,    0,    0,  774,
      771,    0,  775,  776,  776,  776,    0,    0,  772,    0,
        0,  773,  776,  794,  794,  794,  772,    0,  776,  773,
      777,  777,  777,  778,  778,  778,    0,    0,  774,  777,
        0,  775,  778,    0,  776,  777,  774,    0,  778,  775,
        0,  779,  779,  779,  780,  780,  780,  776,    0,    0,
      779,    0,    0,  780,    0,  776,  779,    0,    0,  780,
        0,  781,  781,  781,  777,  778,    0,  778,    0,    0,
      781,    0,  777,    0,    0,  778,  781,  782,  782,  782,
      783,  783,  783,    0,    0,  779,  782,    0,  780,  783,

        0,    0,  782,  779,    0,  783,  780,  784,  784,  784,
      785,  785,  785,    0,    0,  781,  784,    0,    0,  785,
        0,    0,  784,  781,    0,  785,  786,  786,  786,    0,
        0,  782,    0,    0,  783,  786,    0,    0,  784,  782,
        0,  786,  783,  787,  787,  787,  788,  788,  788,    0,
        0,  784,  787,    0,  785,  788,    0,    0,  787,  784,
        0,  788,  785,    0,  789,  789,  789,  790,  790,  790,
      786,    0,    0,  789,    0,    0,  790,    0,  786,  789,
        0,    0,  790,    0,  791,  791,  791,  787,    0,    0,
      788,    0,    0,  791,    0,  787,    0,    0,  788,  791,

      795,  795,  795,  792,  792,  792,    0,    0,  789,    0,
        0,  790,  792,    0,    0,  791,  789,    0,  792,  790,
      793,  793,  793,  796,  796,  796,    0,    0,  791,  793,
        0,    0,  796,    0,    0,  793,  791,    0,  796,  797,
      797,  797,  798,  798,  798,    0,    0,  792,  797,    0,
        0,  798,    0,    0,  797,  792,    0,  798,    0,    0,
        0,    0,  793,    0,  793,    0,    0,  796,  797,  799,
      799,  799,  793,    0,    0,  796,    0,    0,  799,    0,
      800,  800,  800,  797,  799,    0,  798,    0,    0,  800,
        0,  797,    0,    0,  798,  800,  801,  801,  801,  802,

      802,  802,    0,    0,    0,  801,    0,    0,  802,    0,
        0,  801,    0,  799,  802,    0,  803,  803,  803,    0,
        0,  799,    0,    0,  800,  803,    0,  804,  804,  804,
      802,  803,  800,    0,    0,    0,  804,  805,  805,  805,
      801,    0,  804,  802,    0,    0,  805,    0,  801,    0,
        0,  802,  805,    0,    0,  807,  807,  807,    0,    0,
      803,    0,    0,    0,  807,  808,  808,  808,  803,  804,
      807,  804,    0,    0,  808,    0,  809,  809,  809,  804,
      808,  805,    0,    0,  807,  809,  810,  810,  810,  805,
        0,  809,  808,    0,    0,  810,  811,  811,  811,  807,

        0,  810,    0,    0,    0,  811,    0,  807,    0,  808,
        0,  811,  812,  812,  812,  810,    0,  808,    0,    0,
      809,  812,    0,  811,    0,    0,    0,  812,  809,    0,
      810,    0,  813,  813,  813,  814,  814,  814,  810,    0,
      811,  813,    0,    0,  814,    0,    0,  813,  811,    0,
      814,  812,  815,  815,  815,    0,  812,    0,    0,  813,
        0,  815,    0,    0,  812,    0,    0,  815,    0,    0,
        0,  816,  816,  816,  814,    0,  813,    0,    0,  814,
      816,    0,    0,  815,  813,    0,  816,  814,  817,  817,
      817,  818,  818,  818,    0,    0,  815,  817,    0,    0,

      818,    0,    0,  817,  815,    0,  818,  819,  819,  819,
      816,  820,  820,  820,    0,  816,  819,    0,    0,  817,
      820,    0,  819,  816,    0,    0,  820,  821,  821,  821,
        0,    0,  817,    0,    0,  818,  821,    0,  819,    0,
      817,    0,  821,  818,    0,    0,    0,    0,    0,    0,
        0,  819,    0,    0,    0,  820,    0,    0,    0,  819,
        0,    0,    0,  820,    0,    0,    0,    0,    0,    0,
        0,  821,    0,    0,    0,    0,    0,    0,    0,  821,
      823,  823,  823,  823,  823,  823,  823,  823,  823,  823,
      823,  823,  823,  823,  823,  823,  823,  823,  823,  823,

      823,  823,  824,  824,  824,  824,  824,  824,  824,  824,
      824,  824,  824,  824,  824,  824,  824,  824,  824,  824,
      824,  824,  824,  824,  825,  825,  825,  825,  825,  825,
      825,  825,  825,  825,  825,  825,  825,  825,  825,  825,
      825,  825,  825,  825,  825,  825,  826,  826,  826,  826,
      826,  826,  826,  826,  826,  826,  826,  826,  826,  826,
      826,  826,  826,  826,  826,  826,  826,  826,  827,  827,
      827,  827,  827,  827,  827,  827,  827,  827,  827,  827,
      827,  827,  827,  827,  827,  827,  827,  827,  827,  827,
      828,  828,  828,  828,  828,  828,  828,  828,  828,  828,

      828,  828,  828,  828,  828,  828,  828,  828,  828,  828,
      828,  828,  829,  829,  829,  829,  829,  829,  829,  829,
      829,  829,  829,  829,  829,  829,  829,  829,  829,  829,
      829,  829,  829,  829,  830,  830,  830,  830,  830,  830,
      830,  830,  830,  830,  830,  830,  830,  830,  830,  830,
      830,  830,  830,  830,  830,  830,  831,  831,  831,  831,
      831,  831,  831,  831,  831,  831,  831,  831,  831,  831,
      831,  831,  831,  831,  831,  831,  831,  831,  832,  832,
      832,  832,  832,  832,  832,  832,  832,  832,  832,  832,
      832,  832,  832,  832,  832,  832,  832,  832,  832,  832,

      833,  833,  833,  833,  833,  833,  833,  833,  833,  833,
      833,  833,  833,  833,  833,  833,  833,  833,  833,  833,
      833,  833,  834,  834,  834,  834,  834,  834,  834,  834,
      834,  834,  834,  834,  834,  834,  834,  834,  834,  834,
      834,  834,  834,  834,  835,  835,  835,  835,  835,  835,
      835,  835,  835,  835,  835,  835,  835,  835,  835,  835,
      835,  835,  835,  835,  835,  835,  836,    0,    0,    0,
        0,    0,    0,    0,  836,    0,    0,    0,    0,    0,
      836,  836,  837,    0,    0,  837,    0,    0,  837,  837,
        0,  837,    0,    0,    0,  837,  837,  837,  838,    0,

        0,    0,    0,    0,    0,    0,  838,    0,    0,    0,
        0,    0,  838,  838,  839,    0,    0,  839,    0,  839,
      839,  840,    0,    0,    0,    0,    0,    0,    0,  840,
        0,    0,    0,    0,    0,  840,  840,  841,  841,  841,
      841,    0,  841,  841,  841,  841,  841,  841,  841,  841,
      841,  841,  841,    0,  841,    0,  841,  841,  841,  842,
      842,  842,  842,    0,  842,  842,  842,  842,  842,  842,
      842,  842,  842,  842,  842,  842,  842,  842,  842,  842,
      842,  843,  843,  843,  843,  843,  843,  843,  843,  843,
      843,  843,  843,  843,  843,  843,  843,  843,  843,    0,

      843,  843,  843,  844,    0,    0,    0,    0,    0,    0,
        0,  844,    0,    0,    0,    0,    0,  844,  844,  845,
      845,    0,    0,  845,    0,    0,    0,    0,    0,    0,
        0,  845,    0,  845,    0,    0,    0,  845,  845,  846,
      846,  846,  846,  846,  846,  846,    0,  846,  846,  846,
      846,  846,  846,  846,  846,  846,  846,  846,  846,  846,
      846,  847,  847,  847,  847,  847,  847,  847,  847,  847,
        0,  847,  847,    0,  847,  847,  847,  847,  847,  847,
      847,  847,  847,  848,  848,  848,  848,    0,  848,  848,
      848,  848,  848,  848,  848,  848,  848,  848,  848,  848,

      848,  848,  848,  848,  848,  849,  849,  849,  849,  849,
      849,  849,    0,  849,  849,  849,  849,  849,  849,  849,
      849,  849,  849,  849,  849,  849,  849,  850,  850,  850,
      850,  850,  850,  850,    0,  850,  850,  850,  850,  850,
      850,  850,  850,  850,  850,  850,  850,  850,  851,  851,
      851,  851,  851,  851,  851,  851,  851,  851,  851,  851,
      851,  851,  851,  851,  851,  851,  851,  851,  851,  851,
      852,  852,  852,  852,  852,  852,  852,    0,  852,  852,
      852,  852,  852,  852,  852,  852,  852,  852,  852,  852,
      852,  852,  853,  853,  853,  853,  853,    0,  853,  853,

      853,  853,  853,  853,  853,  853,  853,  853,  853,  853,
      853,  853,  853,  853,  855,  855,    0,    0,  855,    0,
        0,    0,    0,    0,    0,    0,  855,    0,  855,    0,
        0,    0,  855,  855,  856,    0,    0,  856,    0,    0,
      856,  856,    0,  856,    0,    0,    0,  856,  856,  856,
      857,  857,  857,  857,  857,  857,  857,  857,  857,  857,
      857,  857,  857,  857,  857,  857,  857,  857,  857,  857,
      857,  857,  859,    0,    0,    0,    0,    0,    0,    0,
      859,    0,    0,    0,    0,    0,  859,  859,  860,  860,
        0,  860,  860,  860,  860,  860,  860,  860,  860,  860,

      860,  860,  860,  860,  860,  860,  860,  860,  860,  860,
      861,    0,    0,  861,    0,    0,  861,  861,    0,  861,
        0,    0,    0,  861,  861,  861,  862,    0,    0,    0,
        0,  862,  862,    0,  862,    0,    0,    0,    0,    0,
      862,  862,  863,    0,    0,  863,    0,    0,  863,  863,
        0,  863,    0,    0,    0,  863,  863,  863,  864,    0,
        0,  864,    0,    0,  864,  864,    0,  864,    0,    0,
        0,  864,  864,  864,  868,    0,    0,    0,    0,    0,
        0,    0,  868,    0,    0,    0,    0,    0,  868,  868,
      870,  870,    0,    0,  870,  870,    0,  870,  870,  870,

      870,  870,  870,    0,    0,    0,    0,  870,  870,  870,
      871,  871,  871,  871,  871,  871,  871,  871,  871,  871,
      871,  871,  871,  871,  871,  871,  871,  871,  871,  871,
      871,  871,  872,  872,  872,  872,  872,  872,  872,  872,
      872,  872,  872,  872,  872,  872,  872,  872,  872,  872,
      872,  872,  872,  872,  873,  873,  873,  873,  873,  873,
      873,  873,  873,  873,  873,  873,  873,  873,  873,  873,
      873,  873,  873,  873,  873,  873,  877,  877,  877,  877,
      877,  877,  877,  877,  877,  877,  877,  877,  877,  877,
      877,  877,  877,  877,  877,  877,  877,  877,  878,  878,

      878,  878,  878,  878,  878,  878,  878,  878,  878,  878,
      878,  878,  878,  878,  878,  878,  878,  878,  878,  878,
      879,  879,  879,  879,  879,  879,  879,  879,  879,  879,
      879,  879,  879,  879,  879,  879,  879,  879,  879,  879,
      879,  879,  880,  880,  880,  880,  880,  880,  880,  880,
      880,  880,  880,  880,  880,  880,  880,  880,  880,  880,
      880,  880,  880,  880,  881,  881,  881,  881,  881,  881,
      881,  881,  881,  881,  881,  881,  881,  881,  881,  881,
      881,  881,  881,  881,  881,  881,  882,    0,    0,    0,
        0,  882,  882,    0,  882,    0,    0,    0,    0,    0,

      882,  882,  883,  883,  883,  883,  883,  883,  883,  883,
      883,  883,  883,  883,  883,  883,  883,  883,  883,  883,
      883,  883,  883,  883,  884,  884,  884,  884,  884,  884,
      884,  884,  884,  884,  884,  884,  884,  884,  884,  884,
      884,  884,  884,  884,  884,  884,  885,  885,  885,  885,
      885,  885,  885,  885,  885,  885,  885,  885,  885,  885,
      885,  885,  885,  885,  885,  885,  885,  885,  888,  888,
      888,  888,  888,  888,  888,  888,  888,  888,  888,  888,
      888,  888,  888,  888,  888,  888,  888,  888,  888,  888,
      889,  889,  889,  889,  889,  889,  889,  889,  889,  889,

      889,  889,  889,  889,  889,  889,  889,  889,  889,  889,
      889,  889,  890,  890,  890,  890,  890,  890,  890,  890,
      890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
      890,  890,  890,  890,  891,  891,  891,  891,  891,  891,
      891,  891,  891,  891,  891,  891,    0,  891,  891,  891,
      891,  891,  891,  891,  891,  891,  892,  892,  892,  892,
      892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
      892,  892,  892,  892,  892,  892,  892,  892,  895,  895,
        0,    0,  895,  895,    0,  895,  895,  895,  895,  895,
      895,    0,    0,    0,    0,  895,  895,  895,  899,  899,

      899,  899,  899,  899,  899,    0,  899,  899,  899,  899,
      899,  899,  899,  899,  899,  899,  899,  899,  899,  899,
      900,  900,  900,  900,  900,  900,  900,    0,  900,  900,
      900,  900,  900,  900,  900,  900,  900,  900,  900,  900,
      900,  900,  901,  901,  901,  901,  901,  901,  901,  901,
      901,  901,  901,  901,  901,  901,  901,  901,  901,  901,
      901,  901,  901,  901,  902,  902,  902,  902,  902,  902,
      902,  902,  902,  902,  902,  902,  902,  902,  902,  902,
      902,  902,  902,  902,  902,  902,  903,  903,  903,  903,
      903,  903,  903,  903,  903,  903,  903,  903,  903,  903,

      903,  903,  903,  903,  903,  903,  903,  903,  904,  904,
      904,  904,  904,  904,  904,  904,  904,  904,  904,  904,
      904,  904,  904,  904,  904,  904,  904,  904,  904,  904,
      905,  905,  905,  905,  905,  905,  905,  905,  905,  905,
      905,  905,  905,  905,  905,  905,  905,  905,  905,  905,
      905,  905,  906,  906,  906,  906,  906,  906,  906,  906,
      906,  906,  906,  906,  906,  906,  906,  906,  906,  906,
      906,  906,  906,  906,  907,  907,  907,  907,  907,  907,
      907,  907,  907,  907,  907,  907,  907,  907,  907,  907,
      907,  907,  907,  907,  907,  907,  908,  908,  908,  908,

      908,  908,  908,  908,  908,  908,  908,  908,  908,  908,
      908,  908,  908,  908,  908,  908,  908,  908,  909,  909,
      909,  909,  909,  909,  909,  909,  909,  909,  909,  909,
      909,  909,  909,  909,  909,  909,  909,  909,  909,  909,
      910,  910,  910,  910,  910,  910,  910,  910,  910,  910,
      910,  910,  910,  910,  910,  910,  910,  910,  910,  910,
      910,  910,  911,  911,  911,  911,  911,  911,  911,  911,
      911,  911,  911,  911,  911,  911,  911,  911,  911,  911,
      911,  911,  911,  911,  912,  912,  912,  912,  912,  912,
      912,  912,  912,  912,  912,  912,  912,  912,  912,  912,

      912,  912,  912,  912,  912,  912,  913,  913,  913,  913,
      913,  913,  913,  913,  913,  913,  913,  913,  913,  913,
      913,  913,  913,  913,  913,  913,  913,  913,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822,  822,  822,
      822,  822,  822,  822,  822,  822,  822,  822
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[152] =
    {   0,
1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 
    1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 
    0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 
    0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
    1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "pgc.l"

#line 39 "pgc.l"
extern YYSTYPE yylval;

static int		xcdepth = 0;	/* depth of nesting in slash-star comments */
static char	   *dolqstart = NULL;	/* current $foo$ quote start string */
static YY_BUFFER_STATE scanbufhandle;
static char *scanbuf;

/*
 * literalbuf is used to accumulate literal values when multiple rules
 * are needed to parse a single literal.  Call startlit to reset buffer
 * to empty, addlit to add text.  Note that the buffer is permanently
 * malloc'd to the largest size needed so far in the current run.
 */
static char	   *literalbuf = NULL;		/* expandable buffer */
static int		literallen;				/* actual current length */
static int		literalalloc;			/* current allocated buffer size */

/* Used for detecting global state together with braces_open */
static int		parenths_open;

/* Used to tell parse_include() whether the command was #include or #include_next */
static bool		include_next;

#define startlit()	(literalbuf[0] = '\0', literallen = 0)
static void addlit(char *ytext, int yleng);
static void addlitchar (unsigned char);
static void parse_include (void);
static bool ecpg_isspace(char ch);
static bool isdefine(void);
static bool isinformixdefine(void);

char *token_start;
static int state_before;

struct _yy_buffer
{
	YY_BUFFER_STATE		buffer;
	long				lineno;
	char			   *filename;
	struct _yy_buffer  *next;
} *yy_buffer = NULL;

static char *old;

#define MAX_NESTED_IF 128
static short preproc_tos;
static short ifcond;
static struct _if_value
{
	short condition;
	short else_branch;
} stacked_if_value[MAX_NESTED_IF];

#define YY_NO_INPUT 1

/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *	<xb> bit string literal
 *	<xcc> extended C-style comments in C
 *	<xcsql> extended C-style comments in SQL
 *	<xd> delimited identifiers (double-quoted identifiers) - thomas 1997-10-27
 *	<xh> hexadecimal numeric string - thomas 1997-11-16
 *	<xq> standard quoted strings - thomas 1997-07-30
 *	<xqc> standard quoted strings in C - michael
 *	<xe> extended quoted strings (support backslash escape sequences)
 *	<xn> national character quoted strings
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 */















/* Bit string
 */
/* Hexadecimal number */
/* National character */
/* Quoted string that allows backslash escapes */
/* C version of hex number */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Unicode escapes */
/* (The ecpg scanner is not backup-free, so the fail rules in scan.l are not needed here, but could be added if desired.) */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* special stuff for C strings */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!	Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *	  {operator} would. Then the tie-breaker (first matching rule of same
 *	  length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *	  in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *	  if found throw it back with yyless().  This handles the plus-slash-star
 *	  problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.	"op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/* we no longer allow unary minus in numbers.
 * instead we pass it separately to parser. there it gets
 * coerced via doNegate() -- Leon aug 20 1999
 *
 * {realfail1} and {realfail2} are added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  SQL-style comments, which start with -- and extend to the
 * next newline, are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix ecpg_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* special characters for other dbms */
/* we have to react differently in compat mode */
/* some stuff needed for ecpg */
/* we might want to parse all cpp include files */
/* take care of cpp lines, they may also be continuated */
/* first a general line for all commands not starting with "i" */
/* and then the other commands starting with "i", we have to add these
 * separately because the cppline production would match on "include" too */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *	and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *	style of two adjacent single quotes "''" and in the Postgres/Java style
 *	of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *	backslash is dropped from the string. - thomas 1997-09-24
 * Note that xcstart must appear before operator, as explained above!
 *	Also whitespace (comment) must appear before operator.
 */
#line 2165 "pgc.c"

#define INITIAL 0
#define C 1
#define SQL 2
#define incl 3
#define def 4
#define def_ident 5
#define undef 6
#define xb 7
#define xcc 8
#define xcsql 9
#define xd 10
#define xdc 11
#define xh 12
#define xe 13
#define xn 14
#define xq 15
#define xqc 16
#define xdolq 17
#define xcond 18
#define xskip 19
#define xui 20
#define xus 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * out_str  );

yy_size_t yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
#line 384 "pgc.l"



		/* code to execute during start of each call of yylex() */
		token_start = NULL;


#line 2408 "pgc.c"

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 823 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 822 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			yy_size_t yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					   
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 391 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 393 "pgc.l"
{
					token_start = yytext;
					state_before = YYSTATE;
					xcdepth = 0;
					BEGIN(xcc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", yyout);
				}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 402 "pgc.l"
{
					token_start = yytext;
					state_before = YYSTATE;
					xcdepth = 0;
					BEGIN(xcsql);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", yyout);
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 411 "pgc.l"
{ ECHO; }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 412 "pgc.l"
{
					xcdepth++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/_*", yyout);
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 418 "pgc.l"
{
					if (xcdepth <= 0)
					{
						ECHO;
						BEGIN(state_before);
						token_start = NULL;
					}
					else
					{
						xcdepth--;
						fputs("*_/", yyout);
					}
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 431 "pgc.l"
{
					ECHO;
					BEGIN(state_before);
					token_start = NULL;
				}
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 436 "pgc.l"
{ ECHO; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 437 "pgc.l"
{ ECHO; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 438 "pgc.l"
{ ECHO; }
	YY_BREAK
case YY_STATE_EOF(xcc):
case YY_STATE_EOF(xcsql):
#line 440 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated /* comment"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 442 "pgc.l"
{
					token_start = yytext;
					BEGIN(xb);
					startlit();
					addlitchar('b');
				}
	YY_BREAK
case 12:
/* rule 12 can match eol */
#line 449 "pgc.l"
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 449 "pgc.l"
{
					yyless(1);
					BEGIN(SQL);
					if (literalbuf[strspn(literalbuf, "01") + 1] != '\0')
						mmerror(PARSE_ERROR, ET_ERROR, "invalid bit string literal");
					yylval.str = mm_strdup(literalbuf);
					return BCONST;
				}
	YY_BREAK
case 14:
/* rule 14 can match eol */
#line 459 "pgc.l"
case 15:
/* rule 15 can match eol */
YY_RULE_SETUP
#line 459 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 16:
/* rule 16 can match eol */
#line 461 "pgc.l"
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 461 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case YY_STATE_EOF(xb):
#line 462 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated bit string literal"); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 464 "pgc.l"
{
					token_start = yytext;
					BEGIN(xh);
					startlit();
					addlitchar('x');
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 471 "pgc.l"
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 471 "pgc.l"
{
				yyless(1);
				BEGIN(SQL);
				yylval.str = mm_strdup(literalbuf);
				return XCONST;
			}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 478 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated hexadecimal string literal"); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 479 "pgc.l"
{
				/* National character.
				 * Transfer it as-is to the backend.
				 */
				token_start = yytext;
				state_before = YYSTATE;
				BEGIN(xn);
				startlit();
			}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 488 "pgc.l"
{
				token_start = yytext;
				state_before = YYSTATE;
				BEGIN(xqc);
				startlit();
			}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 494 "pgc.l"
{
				token_start = yytext;
				state_before = YYSTATE;
				BEGIN(xq);
				startlit();
			}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 500 "pgc.l"
{
				token_start = yytext;
				state_before = YYSTATE;
				BEGIN(xe);
				startlit();
			}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 506 "pgc.l"
{
				token_start = yytext;
				state_before = YYSTATE;
				BEGIN(xus);
				startlit();
				addlit(yytext, yyleng);
			}
	YY_BREAK
case 26:
/* rule 26 can match eol */
#line 514 "pgc.l"
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 514 "pgc.l"
{
				yyless(1);
				BEGIN(state_before);
				yylval.str = mm_strdup(literalbuf);
				return SCONST;
			}
	YY_BREAK
case 28:
/* rule 28 can match eol */
#line 521 "pgc.l"
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 521 "pgc.l"
{
				yyless(1);
				BEGIN(state_before);
				yylval.str = mm_strdup(literalbuf);
				return ECONST;
			}
	YY_BREAK
case 30:
/* rule 30 can match eol */
#line 528 "pgc.l"
case 31:
/* rule 31 can match eol */
YY_RULE_SETUP
#line 528 "pgc.l"
{
				yyless(1);
				BEGIN(state_before);
				yylval.str = mm_strdup(literalbuf);
				return NCONST;
			}
	YY_BREAK
case 32:
/* rule 32 can match eol */
YY_RULE_SETUP
#line 534 "pgc.l"
{
				addlit(yytext, yyleng);
				BEGIN(state_before);
				yylval.str = mm_strdup(literalbuf);
				return UCONST;
			}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 540 "pgc.l"
{ addlitchar('\''); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 541 "pgc.l"
{
				addlitchar('\\');
				addlitchar('\'');
			}
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 545 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 546 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 547 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 38:
/* rule 38 can match eol */
YY_RULE_SETUP
#line 548 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 549 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 550 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 41:
/* rule 41 can match eol */
YY_RULE_SETUP
#line 551 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 552 "pgc.l"
{
			   /* This is only needed for \ just before EOF */
			   addlitchar(yytext[0]);
			}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xqc):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xn):
case YY_STATE_EOF(xus):
#line 556 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 557 "pgc.l"
{
				/* throw back all but the initial "$" */
				yyless(1);
				/* and treat it as {other} */
				return yytext[0];
			}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 563 "pgc.l"
{
				token_start = yytext;
				if (dolqstart)
					free(dolqstart);
				dolqstart = mm_strdup(yytext);
				BEGIN(xdolq);
				startlit();
				addlit(yytext, yyleng);
			}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 572 "pgc.l"
{
				if (strcmp(yytext, dolqstart) == 0)
				{
					addlit(yytext, yyleng);
					free(dolqstart);
					BEGIN(SQL);
					yylval.str = mm_strdup(literalbuf);
					return DOLCONST;
				}
				else
				{
					/*
					 * When we fail to match $...$ to dolqstart, transfer
					 * the $... part to the output, but put back the final
					 * $ for rescanning.  Consider $delim$...$junk$delim$
					 */
					addlit(yytext, yyleng-1);
					yyless(yyleng-1);
				}
			}
	YY_BREAK
case 46:
/* rule 46 can match eol */
YY_RULE_SETUP
#line 592 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 593 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 594 "pgc.l"
{
				/* single quote or dollar sign */
				addlitchar(yytext[0]);
			}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 598 "pgc.l"
{ base_yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 599 "pgc.l"
{
						state_before = YYSTATE;
						BEGIN(xd);
						startlit();
					}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 604 "pgc.l"
{
						state_before = YYSTATE;
						BEGIN(xui);
						startlit();
						addlit(yytext, yyleng);
					}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 610 "pgc.l"
{
						BEGIN(state_before);
						if (literallen == 0)
							mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
						/* The backend will truncate the identifier here. We do not as it does not change the result. */
						yylval.str = mm_strdup(literalbuf);
						return CSTRING;
					}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 618 "pgc.l"
{
						BEGIN(state_before);
						yylval.str = mm_strdup(literalbuf);
						return CSTRING;
					}
	YY_BREAK
case 53:
/* rule 53 can match eol */
YY_RULE_SETUP
#line 623 "pgc.l"
{
						BEGIN(state_before);
						if (literallen == 2) /* "U&" */
							mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
						/* The backend will truncate the identifier here. We do not as it does not change the result. */
						addlit(yytext, yyleng);
						yylval.str = mm_strdup(literalbuf);
						return UIDENT;
					}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 632 "pgc.l"
{ addlitchar('"'); }
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 633 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xdc):
case YY_STATE_EOF(xui):
#line 634 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted identifier"); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 635 "pgc.l"
{
						state_before = YYSTATE;
						BEGIN(xdc);
						startlit();
					}
	YY_BREAK
case 57:
/* rule 57 can match eol */
YY_RULE_SETUP
#line 640 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 641 "pgc.l"
{ return TYPECAST; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 642 "pgc.l"
{ return DOT_DOT; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 643 "pgc.l"
{ return COLON_EQUALS; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 644 "pgc.l"
{ return EQUALS_GREATER; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 645 "pgc.l"
{ return LESS_EQUALS; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 646 "pgc.l"
{ return GREATER_EQUALS; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 647 "pgc.l"
{ return NOT_EQUALS; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 648 "pgc.l"
{ return NOT_EQUALS; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 649 "pgc.l"
{
			  /* are we simulating Informix? */
				if (INFORMIX_MODE)
				{
					unput(':');
				}
				else
					return yytext[0];
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 658 "pgc.l"
{ /*
					   * We may find a ';' inside a structure
					   * definition in a TYPE or VAR statement.
					   * This is not an EOL marker.
					   */
					  if (yytext[0] == ';' && struct_level == 0)
						 BEGIN(C);
					  return yytext[0];
					}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 667 "pgc.l"
{
						/*
						 * Check for embedded slash-star or dash-dash; those
						 * are comment starts, so operator must stop there.
						 * Note that slash-star or dash-dash at the first
						 * character will match a prior rule, not this one.
						 */
						int		nchars = yyleng;
						char   *slashstar = strstr(yytext, "/*");
						char   *dashdash = strstr(yytext, "--");

						if (slashstar && dashdash)
						{
							/* if both appear, take the first one */
							if (slashstar > dashdash)
								slashstar = dashdash;
						}
						else if (!slashstar)
							slashstar = dashdash;
						if (slashstar)
							nchars = slashstar - yytext;

						/*
						 * For SQL compatibility, '+' and '-' cannot be the
						 * last char of a multi-char operator unless the operator
						 * contains chars that are not in SQL operators.
						 * The idea is to lex '=-' as two operators, but not
						 * to forbid operator names like '?-' that could not be
						 * sequences of SQL operators.
						 */
						while (nchars > 1 &&
							   (yytext[nchars-1] == '+' ||
								yytext[nchars-1] == '-'))
						{
							int		ic;

							for (ic = nchars-2; ic >= 0; ic--)
							{
								if (strchr("~!@#^&|`?%", yytext[ic]))
									break;
							}
							if (ic >= 0)
								break; /* found a char that makes it OK */
							nchars--; /* else remove the +/-, and check again */
						}

						if (nchars < yyleng)
						{
							/* Strip the unwanted chars from the token */
							yyless(nchars);
							/*
							 * If what we have left is only one char, and it's
							 * one of the characters matching "self", then
							 * return it as a character token the same way
							 * that the "self" rule would have.
							 */
							if (nchars == 1 &&
								strchr(",()[].;:+-*/%^<>=", yytext[0]))
								return yytext[0];
						}

						yylval.str = mm_strdup(yytext);
						return Op;
					}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 731 "pgc.l"
{
						yylval.ival = atol(yytext+1);
						return PARAM;
					}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 735 "pgc.l"
{
						long val;
						char* endptr;

						errno = 0;
						val = strtol((char *)yytext, &endptr,10);
						if (*endptr != '\0' || errno == ERANGE
#ifdef HAVE_LONG_INT_64
							/* if long > 32 bits, check for overflow of int4 */
							|| val != (long) ((int32) val)
#endif
							)
						{
							errno = 0;
							yylval.str = mm_strdup(yytext);
							return FCONST;
						}
						yylval.ival = val;
						return ICONST;
					}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 755 "pgc.l"
{
						yylval.str = mm_strdup(yytext);
						return IP;
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 759 "pgc.l"
{
						yylval.str = mm_strdup(yytext);
						return FCONST;
			}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 763 "pgc.l"
{
						yylval.str = mm_strdup(yytext);
						return FCONST;
			}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 767 "pgc.l"
{
						yyless(yyleng-1);
						yylval.str = mm_strdup(yytext);
						return FCONST;
					}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 772 "pgc.l"
{
						yyless(yyleng-2);
						yylval.str = mm_strdup(yytext);
						return FCONST;
					}
	YY_BREAK
case 76:
/* rule 76 can match eol */
YY_RULE_SETUP
#line 777 "pgc.l"
{
						yylval.str = mm_strdup(yytext+1);
						return(CVARIABLE);
					}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 781 "pgc.l"
{
						const ScanKeyword  *keyword;

						if (!isdefine())
						{
							/* Is it an SQL/ECPG keyword? */
							keyword = ScanECPGKeywordLookup(yytext);
							if (keyword != NULL)
								return keyword->value;

							/* Is it a C keyword? */
							keyword = ScanCKeywordLookup(yytext);
							if (keyword != NULL)
								return keyword->value;

							/*
							 * None of the above.  Return it as an identifier.
							 *
							 * The backend will attempt to truncate and case-fold
							 * the identifier, but I see no good reason for ecpg
							 * to do so; that's just another way that ecpg could get
							 * out of step with the backend.
							 */
							yylval.str = mm_strdup(yytext);
							return IDENT;
						}
					}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 808 "pgc.l"
{ return yytext[0]; }
	YY_BREAK
case 79:
/* rule 79 can match eol */
YY_RULE_SETUP
#line 809 "pgc.l"
{ BEGIN(SQL); return SQL_START; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 810 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(SQL);
							return SQL_START;
						}
						else
							return S_ANYTHING;
					 }
	YY_BREAK
case 81:
/* rule 81 can match eol */
YY_RULE_SETUP
#line 820 "pgc.l"
{ ECHO; }
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 821 "pgc.l"
{
						char* endptr;

						errno = 0;
						yylval.ival = strtoul((char *)yytext,&endptr,16);
						if (*endptr != '\0' || errno == ERANGE)
						{
							errno = 0;
							yylval.str = mm_strdup(yytext);
							return SCONST;
						}
						return ICONST;
					}
	YY_BREAK
case 83:
/* rule 83 can match eol */
YY_RULE_SETUP
#line 834 "pgc.l"
{
						if (system_includes)
						{
							include_next = false;
							BEGIN(incl);
						}
						else
						{
							yylval.str = mm_strdup(yytext);
							return(CPP_LINE);
						}
					}
	YY_BREAK
case 84:
/* rule 84 can match eol */
YY_RULE_SETUP
#line 846 "pgc.l"
{
						if (system_includes)
						{
							include_next = true;
							BEGIN(incl);
						}
						else
						{
							yylval.str = mm_strdup(yytext);
							return(CPP_LINE);
						}
					}
	YY_BREAK
case 85:
/* rule 85 can match eol */
YY_RULE_SETUP
#line 858 "pgc.l"
{
						yylval.str = mm_strdup(yytext);
						return(CPP_LINE);
					}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 862 "pgc.l"
{
						const ScanKeyword		*keyword;

						/*
						 * Try to detect a function name:
						 * look for identifiers at the global scope
						 * keep the last identifier before the first '(' and '{' */
						if (braces_open == 0 && parenths_open == 0)
						{
							if (current_function)
								free(current_function);
							current_function = mm_strdup(yytext);
						}
						/* Informix uses SQL defines only in SQL space */
						/* however, some defines have to be taken care of for compatibility */
						if ((!INFORMIX_MODE || !isinformixdefine()) && !isdefine())
						{
							keyword = ScanCKeywordLookup(yytext);
							if (keyword != NULL)
								return keyword->value;
							else
							{
								yylval.str = mm_strdup(yytext);
								return IDENT;
							}
						}
					}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 889 "pgc.l"
{ mmerror(PARSE_ERROR, ET_ERROR, "nested /* ... */ comments"); }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 890 "pgc.l"
{ return(':'); }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 891 "pgc.l"
{ return(';'); }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 892 "pgc.l"
{ return(','); }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 893 "pgc.l"
{ return('*'); }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 894 "pgc.l"
{ return('%'); }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 895 "pgc.l"
{ return('/'); }
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 896 "pgc.l"
{ return('+'); }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 897 "pgc.l"
{ return('-'); }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 898 "pgc.l"
{ parenths_open++; return('('); }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 899 "pgc.l"
{ parenths_open--; return(')'); }
	YY_BREAK
case 98:
/* rule 98 can match eol */
YY_RULE_SETUP
#line 900 "pgc.l"
{ ECHO; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 901 "pgc.l"
{ return('{'); }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 902 "pgc.l"
{ return('}'); }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 903 "pgc.l"
{ return('['); }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 904 "pgc.l"
{ return(']'); }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 905 "pgc.l"
{ return('='); }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 906 "pgc.l"
{ return(S_MEMBER); }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 907 "pgc.l"
{ return(S_RSHIFT); }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 908 "pgc.l"
{ return(S_LSHIFT); }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 909 "pgc.l"
{ return(S_OR); }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 910 "pgc.l"
{ return(S_AND); }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 911 "pgc.l"
{ return(S_INC); }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 912 "pgc.l"
{ return(S_DEC); }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 913 "pgc.l"
{ return(S_EQUAL); }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 914 "pgc.l"
{ return(S_NEQUAL); }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 915 "pgc.l"
{ return(S_ADD); }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 916 "pgc.l"
{ return(S_SUB); }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 917 "pgc.l"
{ return(S_MUL); }
	YY_BREAK
case 116:
YY_RULE_SETUP
#line 918 "pgc.l"
{ return(S_DIV); }
	YY_BREAK
case 117:
YY_RULE_SETUP
#line 919 "pgc.l"
{ return(S_MOD); }
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 920 "pgc.l"
{ return(S_MEMPOINT); }
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 921 "pgc.l"
{ return(S_DOTPOINT); }
	YY_BREAK
case 120:
YY_RULE_SETUP
#line 922 "pgc.l"
{ return S_ANYTHING; }
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 923 "pgc.l"
{ BEGIN(def_ident); }
	YY_BREAK
case 122:
/* rule 122 can match eol */
YY_RULE_SETUP
#line 924 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(def_ident);
						}
						else
						{
							yyless(1);
							return (S_ANYTHING);
						}
					}
	YY_BREAK
case 123:
/* rule 123 can match eol */
YY_RULE_SETUP
#line 936 "pgc.l"
{ BEGIN(undef); }
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 937 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(undef);
						}
						else
						{
							yyless(1);
							return (S_ANYTHING);
						}
					}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 949 "pgc.l"
{
					struct _defines *ptr, *ptr2 = NULL;
					int i;

					/*
					 *	Skip the ";" and trailing whitespace. Note that yytext
					 *	contains at least one non-space character plus the ";"
					 */
					for (i = strlen(yytext)-2;
						 i > 0 && ecpg_isspace(yytext[i]);
						 i-- )
						;
					yytext[i+1] = '\0';


					for (ptr = defines; ptr != NULL; ptr2 = ptr, ptr = ptr->next)
					{
						if (strcmp(yytext, ptr->old) == 0)
						{
							if (ptr2 == NULL)
								defines = ptr->next;
							else
								ptr2->next = ptr->next;
							free(ptr->new);
							free(ptr->old);
							free(ptr);
							break;
						}
					}

					BEGIN(C);
				}
	YY_BREAK
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 981 "pgc.l"
{
						mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL UNDEF command");
						yyterminate();
				}
	YY_BREAK
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 985 "pgc.l"
{ BEGIN(incl); }
	YY_BREAK
case 128:
/* rule 128 can match eol */
YY_RULE_SETUP
#line 986 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  BEGIN(incl);
					  }
					  else
					  {
						  yyless(1);
						  return (S_ANYTHING);
					  }
					}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 998 "pgc.l"
{ ifcond = TRUE; BEGIN(xcond); }
	YY_BREAK
case 130:
/* rule 130 can match eol */
YY_RULE_SETUP
#line 999 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  ifcond = TRUE;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return (S_ANYTHING);
					  }
					}
	YY_BREAK
case 131:
/* rule 131 can match eol */
YY_RULE_SETUP
#line 1012 "pgc.l"
{ ifcond = FALSE; BEGIN(xcond); }
	YY_BREAK
case 132:
/* rule 132 can match eol */
YY_RULE_SETUP
#line 1013 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  ifcond = FALSE;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return (S_ANYTHING);
					  }
					}
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 1026 "pgc.l"
{	/* pop stack */
						if ( preproc_tos == 0 ) {
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						}
						else if ( stacked_if_value[preproc_tos].else_branch )
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						else
							preproc_tos--;

						ifcond = TRUE; BEGIN(xcond);
					}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1037 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						else if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						else
							preproc_tos--;

						ifcond = TRUE;
						BEGIN(xcond);
					}
					else
					{
						yyless(1);
						return (S_ANYTHING);
					}
				}
	YY_BREAK
case 135:
/* rule 135 can match eol */
YY_RULE_SETUP
#line 1058 "pgc.l"
{	/* only exec sql endif pops the stack, so take care of duplicated 'else' */
					if (stacked_if_value[preproc_tos].else_branch)
						mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
					else
					{
						stacked_if_value[preproc_tos].else_branch = TRUE;
						stacked_if_value[preproc_tos].condition =
							(stacked_if_value[preproc_tos-1].condition &&
							 !stacked_if_value[preproc_tos].condition);

						if (stacked_if_value[preproc_tos].condition)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
				}
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 1074 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
						else
						{
							stacked_if_value[preproc_tos].else_branch = TRUE;
							stacked_if_value[preproc_tos].condition =
							(stacked_if_value[preproc_tos-1].condition &&
							 !stacked_if_value[preproc_tos].condition);

							if (stacked_if_value[preproc_tos].condition)
								BEGIN(C);
							else
								BEGIN(xskip);
						}
					}
					else
					{
						yyless(1);
						return (S_ANYTHING);
					}
				}
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 1099 "pgc.l"
{
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
					else
						preproc_tos--;

					if (stacked_if_value[preproc_tos].condition)
					   BEGIN(C);
					else
					   BEGIN(xskip);
				}
	YY_BREAK
case 138:
/* rule 138 can match eol */
YY_RULE_SETUP
#line 1110 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
						else
							preproc_tos--;

						if (stacked_if_value[preproc_tos].condition)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
					else
					{
						yyless(1);
						return (S_ANYTHING);
					}
				}
	YY_BREAK
case 139:
YY_RULE_SETUP
#line 1131 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 140:
/* rule 140 can match eol */
YY_RULE_SETUP
#line 1133 "pgc.l"
{
					if (preproc_tos >= MAX_NESTED_IF-1)
						mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					else
					{
						struct _defines *defptr;
						unsigned int i;

						/*
						 *	Skip the ";" and trailing whitespace. Note that yytext
						 *	contains at least one non-space character plus the ";"
						 */
						for (i = strlen(yytext)-2;
							 i > 0 && ecpg_isspace(yytext[i]);
							 i-- )
							;
						yytext[i+1] = '\0';

						for (defptr = defines;
							 defptr != NULL && strcmp(yytext, defptr->old) != 0;
							 defptr = defptr->next);

						preproc_tos++;
						stacked_if_value[preproc_tos].else_branch = FALSE;
						stacked_if_value[preproc_tos].condition =
						(defptr ? ifcond : !ifcond) && stacked_if_value[preproc_tos-1].condition;
					}

					if (stacked_if_value[preproc_tos].condition)
						BEGIN(C);
					else
						BEGIN(xskip);
				}
	YY_BREAK
case 141:
/* rule 141 can match eol */
YY_RULE_SETUP
#line 1167 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL IFDEF command");
				yyterminate();
			}
	YY_BREAK
case 142:
YY_RULE_SETUP
#line 1171 "pgc.l"
{
				old = mm_strdup(yytext);
				BEGIN(def);
				startlit();
			}
	YY_BREAK
case 143:
/* rule 143 can match eol */
YY_RULE_SETUP
#line 1176 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL DEFINE command");
				yyterminate();
			}
	YY_BREAK
case 144:
/* rule 144 can match eol */
YY_RULE_SETUP
#line 1180 "pgc.l"
{
						struct _defines *ptr, *this;

						for (ptr = defines; ptr != NULL; ptr = ptr->next)
						{
							 if (strcmp(old, ptr->old) == 0)
							 {
								free(ptr->new);
								ptr->new = mm_strdup(literalbuf);
							 }
						}
						if (ptr == NULL)
						{
							this = (struct _defines *) mm_alloc(sizeof(struct _defines));

							/* initial definition */
							this->old = old;
							this->new = mm_strdup(literalbuf);
							this->next = defines;
							this->used = NULL;
							defines = this;
						}

						BEGIN(C);
					}
	YY_BREAK
case 145:
/* rule 145 can match eol */
YY_RULE_SETUP
#line 1205 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 146:
/* rule 146 can match eol */
YY_RULE_SETUP
#line 1206 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 147:
/* rule 147 can match eol */
YY_RULE_SETUP
#line 1207 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 148:
/* rule 148 can match eol */
YY_RULE_SETUP
#line 1208 "pgc.l"
{ parse_include(); }
	YY_BREAK
case 149:
/* rule 149 can match eol */
YY_RULE_SETUP
#line 1209 "pgc.l"
{
					mmfatal(PARSE_ERROR, "syntax error in EXEC SQL INCLUDE command");
					yyterminate();
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(C):
case YY_STATE_EOF(SQL):
case YY_STATE_EOF(incl):
case YY_STATE_EOF(def):
case YY_STATE_EOF(def_ident):
case YY_STATE_EOF(undef):
case YY_STATE_EOF(xcond):
case YY_STATE_EOF(xskip):
#line 1214 "pgc.l"
{
					if (yy_buffer == NULL)
					{
						if ( preproc_tos > 0 )
						{
							preproc_tos = 0;
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						}
						yyterminate();
					}
					else
					{
						struct _yy_buffer *yb = yy_buffer;
						int i;
						struct _defines *ptr;

						for (ptr = defines; ptr; ptr = ptr->next)
							if (ptr->used == yy_buffer)
							{
								ptr->used = NULL;
								break;
							}

						if (yyin != NULL)
							fclose(yyin);

						yy_delete_buffer(YY_CURRENT_BUFFER );
						yy_switch_to_buffer(yy_buffer->buffer);

						yylineno = yy_buffer->lineno;

						/* We have to output the filename only if we change files here */
						i = strcmp(input_filename, yy_buffer->filename);

						free(input_filename);
						input_filename = yy_buffer->filename;

						yy_buffer = yy_buffer->next;
						free(yb);

						if (i != 0)
							output_line_number();

					}
				}
	YY_BREAK
case 150:
/* rule 150 can match eol */
YY_RULE_SETUP
#line 1259 "pgc.l"
{ mmfatal(PARSE_ERROR, "internal error: unreachable state; please report this to <pgsql-bugs@postgresql.org>"); }
	YY_BREAK
case 151:
YY_RULE_SETUP
#line 1260 "pgc.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 4009 "pgc.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 823 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 823 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 822);

		return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register yy_size_t number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		   
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	yy_size_t i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1259 "pgc.l"


void
lex_init(void)
{
	braces_open = 0;
	parenths_open = 0;
	current_function = NULL;

	preproc_tos = 0;
	yylineno = 1;
	ifcond = TRUE;
	stacked_if_value[preproc_tos].condition = ifcond;
	stacked_if_value[preproc_tos].else_branch = FALSE;

	/* initialize literal buffer to a reasonable but expansible size */
	if (literalbuf == NULL)
	{
		literalalloc = 1024;
		literalbuf = (char *) malloc(literalalloc);
	}
	startlit();

	BEGIN(C);
}

static void
addlit(char *ytext, int yleng)
{
	/* enlarge buffer if needed */
	if ((literallen+yleng) >= literalalloc)
	{
		do
			literalalloc *= 2;
		while ((literallen+yleng) >= literalalloc);
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	memcpy(literalbuf+literallen, ytext, yleng);
	literallen += yleng;
	literalbuf[literallen] = '\0';
}

static void
addlitchar(unsigned char ychar)
{
	/* enlarge buffer if needed */
	if ((literallen+1) >= literalalloc)
	{
		literalalloc *= 2;
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	literalbuf[literallen] = ychar;
	literallen += 1;
	literalbuf[literallen] = '\0';
}

static void
parse_include(void)
{
	/* got the include file name */
	struct _yy_buffer *yb;
	struct _include_path *ip;
	char inc_file[MAXPGPATH];
	unsigned int i;

	yb = mm_alloc(sizeof(struct _yy_buffer));

	yb->buffer =	YY_CURRENT_BUFFER;
	yb->lineno = yylineno;
	yb->filename = input_filename;
	yb->next = yy_buffer;

	yy_buffer = yb;

	/*
	 * skip the ";" if there is one and trailing whitespace. Note that
	 * yytext contains at least one non-space character plus the ";"
	 */
	for (i = strlen(yytext)-2;
		 i > 0 && ecpg_isspace(yytext[i]);
		 i--)
		;

	if (yytext[i] == ';')
		i--;

	yytext[i+1] = '\0';

	yyin = NULL;

	/* If file name is enclosed in '"' remove these and look only in '.' */
	/* Informix does look into all include paths though, except filename starts with '/' */
	if (yytext[0] == '"' && yytext[i] == '"' &&
		((compat != ECPG_COMPAT_INFORMIX && compat != ECPG_COMPAT_INFORMIX_SE) || yytext[1] == '/'))
	{
		yytext[i] = '\0';
		memmove(yytext, yytext+1, strlen(yytext));

		strlcpy(inc_file, yytext, sizeof(inc_file));
		yyin = fopen(inc_file, "r");
		if (!yyin)
		{
			if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
			{
				strcat(inc_file, ".h");
				yyin = fopen(inc_file, "r");
			}
		}

	}
	else
	{
		if ((yytext[0] == '"' && yytext[i] == '"') || (yytext[0] == '<' && yytext[i] == '>'))
		{
			yytext[i] = '\0';
			memmove(yytext, yytext+1, strlen(yytext));
		}

		for (ip = include_paths; yyin == NULL && ip != NULL; ip = ip->next)
		{
			if (strlen(ip->path) + strlen(yytext) + 3 > MAXPGPATH)
			{
				fprintf(stderr, _("Error: include path \"%s/%s\" is too long on line %d, skipping\n"), ip->path, yytext, yylineno);
				continue;
			}
			snprintf (inc_file, sizeof(inc_file), "%s/%s", ip->path, yytext);
			yyin = fopen(inc_file, "r");
			if (!yyin)
			{
				if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
				{
					strcat(inc_file, ".h");
					yyin = fopen( inc_file, "r" );
				}
			}
			/* if the command was "include_next" we have to disregard the first hit */
			if (yyin && include_next)
			{
				fclose (yyin);
				yyin = NULL;
				include_next = false;
			}
		}
	}
	if (!yyin)
		mmfatal(NO_INCLUDE_FILE, "could not open include file \"%s\" on line %d", yytext, yylineno);

	input_filename = mm_strdup(inc_file);
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE ));
	yylineno = 1;
	output_line_number();

	BEGIN(C);
}

/*
 * ecpg_isspace() --- return TRUE if flex scanner considers char whitespace
 */
static bool
ecpg_isspace(char ch)
{
	if (ch == ' ' ||
		ch == '\t' ||
		ch == '\n' ||
		ch == '\r' ||
		ch == '\f')
		return true;
	return false;
}

static bool isdefine(void)
{
	struct _defines *ptr;

	/* is it a define? */
	for (ptr = defines; ptr; ptr = ptr->next)
	{
		if (strcmp(yytext, ptr->old) == 0 && ptr->used == NULL)
		{
			struct _yy_buffer *yb;

			yb = mm_alloc(sizeof(struct _yy_buffer));

			yb->buffer =  YY_CURRENT_BUFFER;
			yb->lineno = yylineno;
			yb->filename = mm_strdup(input_filename);
			yb->next = yy_buffer;

			ptr->used = yy_buffer = yb;

			yy_scan_string(ptr->new);
			return true;
		}
	}

	return false;
}

static bool isinformixdefine(void)
{
	const char *new = NULL;

	if (strcmp(yytext, "dec_t") == 0)
		new = "decimal";
	else if (strcmp(yytext, "intrvl_t") == 0)
		new = "interval";
	else if (strcmp(yytext, "dtime_t") == 0)
		new = "timestamp";

	if (new)
	{
		struct _yy_buffer *yb;

		yb = mm_alloc(sizeof(struct _yy_buffer));

		yb->buffer =  YY_CURRENT_BUFFER;
		yb->lineno = yylineno;
		yb->filename = mm_strdup(input_filename);
		yb->next = yy_buffer;
		yy_buffer = yb;

		yy_scan_string(new);
		return true;
	}

	return false;
}

/*
 * Called before any actual parsing is done
 */
void
scanner_init(const char *str)
{
	Size	slen = strlen(str);

	/*
	 * Might be left over after ereport()
	 */
	if (YY_CURRENT_BUFFER)
		yy_delete_buffer(YY_CURRENT_BUFFER);

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	scanbuf = mm_alloc(slen + 2);
	memcpy(scanbuf, str, slen);
	scanbuf[slen] = scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	scanbufhandle = yy_scan_buffer(scanbuf,slen + 2);

	/* initialize literal buffer to a reasonable but expansible size */
	literalalloc = 128;
	literalbuf = (char *) mm_alloc(literalalloc);
	startlit();

	BEGIN(INITIAL);
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(void)
{
	yy_delete_buffer(scanbufhandle);
	free(scanbuf);
}

