/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs

#define yylval          base_yylval
#define yychar          base_yychar
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */
#line 5 "preproc.y" /* yacc.c:339  */

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, base_yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (base_yyin)
				fclose(base_yyin);
			if (base_yyout)
				fclose(base_yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
				fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(base_yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essentially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}

#line 630 "preproc.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "preproc.h".  */
#ifndef YY_BASE_YY_PREPROC_H_INCLUDED
# define YY_BASE_YY_PREPROC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int base_yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    SQL_ALLOCATE = 258,
    SQL_AUTOCOMMIT = 259,
    SQL_BOOL = 260,
    SQL_BREAK = 261,
    SQL_CALL = 262,
    SQL_CARDINALITY = 263,
    SQL_CONNECT = 264,
    SQL_COUNT = 265,
    SQL_DATETIME_INTERVAL_CODE = 266,
    SQL_DATETIME_INTERVAL_PRECISION = 267,
    SQL_DESCRIBE = 268,
    SQL_DESCRIPTOR = 269,
    SQL_DISCONNECT = 270,
    SQL_FOUND = 271,
    SQL_FREE = 272,
    SQL_GET = 273,
    SQL_GO = 274,
    SQL_GOTO = 275,
    SQL_IDENTIFIED = 276,
    SQL_INDICATOR = 277,
    SQL_KEY_MEMBER = 278,
    SQL_LENGTH = 279,
    SQL_LONG = 280,
    SQL_NULLABLE = 281,
    SQL_OCTET_LENGTH = 282,
    SQL_OPEN = 283,
    SQL_OUTPUT = 284,
    SQL_REFERENCE = 285,
    SQL_RETURNED_LENGTH = 286,
    SQL_RETURNED_OCTET_LENGTH = 287,
    SQL_SCALE = 288,
    SQL_SECTION = 289,
    SQL_SHORT = 290,
    SQL_SIGNED = 291,
    SQL_SQL = 292,
    SQL_SQLERROR = 293,
    SQL_SQLPRINT = 294,
    SQL_SQLWARNING = 295,
    SQL_START = 296,
    SQL_STOP = 297,
    SQL_STRUCT = 298,
    SQL_UNSIGNED = 299,
    SQL_VAR = 300,
    SQL_WHENEVER = 301,
    S_ADD = 302,
    S_AND = 303,
    S_ANYTHING = 304,
    S_AUTO = 305,
    S_CONST = 306,
    S_DEC = 307,
    S_DIV = 308,
    S_DOTPOINT = 309,
    S_EQUAL = 310,
    S_EXTERN = 311,
    S_INC = 312,
    S_LSHIFT = 313,
    S_MEMPOINT = 314,
    S_MEMBER = 315,
    S_MOD = 316,
    S_MUL = 317,
    S_NEQUAL = 318,
    S_OR = 319,
    S_REGISTER = 320,
    S_RSHIFT = 321,
    S_STATIC = 322,
    S_SUB = 323,
    S_VOLATILE = 324,
    S_TYPEDEF = 325,
    CSTRING = 326,
    CVARIABLE = 327,
    CPP_LINE = 328,
    IP = 329,
    DOLCONST = 330,
    ECONST = 331,
    NCONST = 332,
    UCONST = 333,
    UIDENT = 334,
    IDENT = 335,
    FCONST = 336,
    SCONST = 337,
    BCONST = 338,
    XCONST = 339,
    Op = 340,
    ICONST = 341,
    PARAM = 342,
    TYPECAST = 343,
    DOT_DOT = 344,
    COLON_EQUALS = 345,
    ABORT_P = 346,
    ABSOLUTE_P = 347,
    ACCESS = 348,
    ACTION = 349,
    ADD_P = 350,
    ADMIN = 351,
    AFTER = 352,
    AGGREGATE = 353,
    ALL = 354,
    ALSO = 355,
    ALTER = 356,
    ALWAYS = 357,
    ANALYSE = 358,
    ANALYZE = 359,
    AND = 360,
    ANY = 361,
    ARRAY = 362,
    AS = 363,
    ASC = 364,
    ASSERTION = 365,
    ASSIGNMENT = 366,
    ASYMMETRIC = 367,
    AT = 368,
    ATTRIBUTE = 369,
    AUTHORIZATION = 370,
    BACKWARD = 371,
    BEFORE = 372,
    BEGIN_P = 373,
    BETWEEN = 374,
    BIGINT = 375,
    BINARY = 376,
    BIT = 377,
    BOOLEAN_P = 378,
    BOTH = 379,
    BY = 380,
    CACHE = 381,
    CALLED = 382,
    CASCADE = 383,
    CASCADED = 384,
    CASE = 385,
    CAST = 386,
    CATALOG_P = 387,
    CHAIN = 388,
    CHAR_P = 389,
    CHARACTER = 390,
    CHARACTERISTICS = 391,
    CHECK = 392,
    CHECKPOINT = 393,
    CLASS = 394,
    CLOSE = 395,
    CLUSTER = 396,
    COALESCE = 397,
    COLLATE = 398,
    COLLATION = 399,
    COLUMN = 400,
    COMMENT = 401,
    COMMENTS = 402,
    COMMIT = 403,
    COMMITTED = 404,
    CONCURRENTLY = 405,
    CONFIGURATION = 406,
    CONNECTION = 407,
    CONSTRAINT = 408,
    CONSTRAINTS = 409,
    CONTENT_P = 410,
    CONTINUE_P = 411,
    CONVERSION_P = 412,
    COPY = 413,
    COST = 414,
    CREATE = 415,
    CROSS = 416,
    CSV = 417,
    CURRENT_P = 418,
    CURRENT_CATALOG = 419,
    CURRENT_DATE = 420,
    CURRENT_ROLE = 421,
    CURRENT_SCHEMA = 422,
    CURRENT_TIME = 423,
    CURRENT_TIMESTAMP = 424,
    CURRENT_USER = 425,
    CURSOR = 426,
    CYCLE = 427,
    DATA_P = 428,
    DATABASE = 429,
    DAY_P = 430,
    DEALLOCATE = 431,
    DEC = 432,
    DECIMAL_P = 433,
    DECLARE = 434,
    DEFAULT = 435,
    DEFAULTS = 436,
    DEFERRABLE = 437,
    DEFERRED = 438,
    DEFINER = 439,
    DELETE_P = 440,
    DELIMITER = 441,
    DELIMITERS = 442,
    DESC = 443,
    DICTIONARY = 444,
    DISABLE_P = 445,
    DISCARD = 446,
    DISTINCT = 447,
    DO = 448,
    DOCUMENT_P = 449,
    DOMAIN_P = 450,
    DOUBLE_P = 451,
    DROP = 452,
    EACH = 453,
    ELSE = 454,
    ENABLE_P = 455,
    ENCODING = 456,
    ENCRYPTED = 457,
    END_P = 458,
    ENUM_P = 459,
    ESCAPE = 460,
    EVENT = 461,
    EXCEPT = 462,
    EXCLUDE = 463,
    EXCLUDING = 464,
    EXCLUSIVE = 465,
    EXECUTE = 466,
    EXISTS = 467,
    EXPLAIN = 468,
    EXTENSION = 469,
    EXTERNAL = 470,
    EXTRACT = 471,
    FALSE_P = 472,
    FAMILY = 473,
    FETCH = 474,
    FIRST_P = 475,
    FLOAT_P = 476,
    FOLLOWING = 477,
    FOR = 478,
    FORCE = 479,
    FOREIGN = 480,
    FORWARD = 481,
    FREEZE = 482,
    FROM = 483,
    FULL = 484,
    FUNCTION = 485,
    FUNCTIONS = 486,
    GLOBAL = 487,
    GRANT = 488,
    GRANTED = 489,
    GREATEST = 490,
    GROUP_P = 491,
    HANDLER = 492,
    HAVING = 493,
    HEADER_P = 494,
    HOLD = 495,
    HOUR_P = 496,
    IDENTITY_P = 497,
    IF_P = 498,
    ILIKE = 499,
    IMMEDIATE = 500,
    IMMUTABLE = 501,
    IMPLICIT_P = 502,
    IN_P = 503,
    INCLUDING = 504,
    INCREMENT = 505,
    INDEX = 506,
    INDEXES = 507,
    INHERIT = 508,
    INHERITS = 509,
    INITIALLY = 510,
    INLINE_P = 511,
    INNER_P = 512,
    INOUT = 513,
    INPUT_P = 514,
    INSENSITIVE = 515,
    INSERT = 516,
    INSTEAD = 517,
    INT_P = 518,
    INTEGER = 519,
    INTERSECT = 520,
    INTERVAL = 521,
    INTO = 522,
    INVOKER = 523,
    IS = 524,
    ISNULL = 525,
    ISOLATION = 526,
    JOIN = 527,
    KEY = 528,
    LABEL = 529,
    LANGUAGE = 530,
    LARGE_P = 531,
    LAST_P = 532,
    LATERAL_P = 533,
    LC_COLLATE_P = 534,
    LC_CTYPE_P = 535,
    LEADING = 536,
    LEAKPROOF = 537,
    LEAST = 538,
    LEFT = 539,
    LEVEL = 540,
    LIKE = 541,
    LIMIT = 542,
    LISTEN = 543,
    LOAD = 544,
    LOCAL = 545,
    LOCALTIME = 546,
    LOCALTIMESTAMP = 547,
    LOCATION = 548,
    LOCK_P = 549,
    MAPPING = 550,
    MATCH = 551,
    MATERIALIZED = 552,
    MAXVALUE = 553,
    MINUTE_P = 554,
    MINVALUE = 555,
    MODE = 556,
    MONTH_P = 557,
    MOVE = 558,
    NAME_P = 559,
    NAMES = 560,
    NATIONAL = 561,
    NATURAL = 562,
    NCHAR = 563,
    NEXT = 564,
    NO = 565,
    NONE = 566,
    NOT = 567,
    NOTHING = 568,
    NOTIFY = 569,
    NOTNULL = 570,
    NOWAIT = 571,
    NULL_P = 572,
    NULLIF = 573,
    NULLS_P = 574,
    NUMERIC = 575,
    OBJECT_P = 576,
    OF = 577,
    OFF = 578,
    OFFSET = 579,
    OIDS = 580,
    ON = 581,
    ONLY = 582,
    OPERATOR = 583,
    OPTION = 584,
    OPTIONS = 585,
    OR = 586,
    ORDER = 587,
    OUT_P = 588,
    OUTER_P = 589,
    OVER = 590,
    OVERLAPS = 591,
    OVERLAY = 592,
    OWNED = 593,
    OWNER = 594,
    PARSER = 595,
    PARTIAL = 596,
    PARTITION = 597,
    PASSING = 598,
    PASSWORD = 599,
    PLACING = 600,
    PLANS = 601,
    POSITION = 602,
    PRECEDING = 603,
    PRECISION = 604,
    PRESERVE = 605,
    PREPARE = 606,
    PREPARED = 607,
    PRIMARY = 608,
    PRIOR = 609,
    PRIVILEGES = 610,
    PROCEDURAL = 611,
    PROCEDURE = 612,
    PROGRAM = 613,
    QUOTE = 614,
    RANGE = 615,
    READ = 616,
    REAL = 617,
    REASSIGN = 618,
    RECHECK = 619,
    RECURSIVE = 620,
    REF = 621,
    REFERENCES = 622,
    REFRESH = 623,
    REINDEX = 624,
    RELATIVE_P = 625,
    RELEASE = 626,
    RENAME = 627,
    REPEATABLE = 628,
    REPLACE = 629,
    REPLICA = 630,
    RESET = 631,
    RESTART = 632,
    RESTRICT = 633,
    RETURNING = 634,
    RETURNS = 635,
    REVOKE = 636,
    RIGHT = 637,
    ROLE = 638,
    ROLLBACK = 639,
    ROW = 640,
    ROWS = 641,
    RULE = 642,
    SAVEPOINT = 643,
    SCHEMA = 644,
    SCROLL = 645,
    SEARCH = 646,
    SECOND_P = 647,
    SECURITY = 648,
    SELECT = 649,
    SEQUENCE = 650,
    SEQUENCES = 651,
    SERIALIZABLE = 652,
    SERVER = 653,
    SESSION = 654,
    SESSION_USER = 655,
    SET = 656,
    SETOF = 657,
    SHARE = 658,
    SHOW = 659,
    SIMILAR = 660,
    SIMPLE = 661,
    SMALLINT = 662,
    SNAPSHOT = 663,
    SOME = 664,
    STABLE = 665,
    STANDALONE_P = 666,
    START = 667,
    STATEMENT = 668,
    STATISTICS = 669,
    STDIN = 670,
    STDOUT = 671,
    STORAGE = 672,
    STRICT_P = 673,
    STRIP_P = 674,
    SUBSTRING = 675,
    SYMMETRIC = 676,
    SYSID = 677,
    SYSTEM_P = 678,
    TABLE = 679,
    TABLES = 680,
    TABLESPACE = 681,
    TEMP = 682,
    TEMPLATE = 683,
    TEMPORARY = 684,
    TEXT_P = 685,
    THEN = 686,
    TIME = 687,
    TIMESTAMP = 688,
    TO = 689,
    TRAILING = 690,
    TRANSACTION = 691,
    TREAT = 692,
    TRIGGER = 693,
    TRIM = 694,
    TRUE_P = 695,
    TRUNCATE = 696,
    TRUSTED = 697,
    TYPE_P = 698,
    TYPES_P = 699,
    UNBOUNDED = 700,
    UNCOMMITTED = 701,
    UNENCRYPTED = 702,
    UNION = 703,
    UNIQUE = 704,
    UNKNOWN = 705,
    UNLISTEN = 706,
    UNLOGGED = 707,
    UNTIL = 708,
    UPDATE = 709,
    USER = 710,
    USING = 711,
    VACUUM = 712,
    VALID = 713,
    VALIDATE = 714,
    VALIDATOR = 715,
    VALUE_P = 716,
    VALUES = 717,
    VARCHAR = 718,
    VARIADIC = 719,
    VARYING = 720,
    VERBOSE = 721,
    VERSION_P = 722,
    VIEW = 723,
    VOLATILE = 724,
    WHEN = 725,
    WHERE = 726,
    WHITESPACE_P = 727,
    WINDOW = 728,
    WITH = 729,
    WITHOUT = 730,
    WORK = 731,
    WRAPPER = 732,
    WRITE = 733,
    XML_P = 734,
    XMLATTRIBUTES = 735,
    XMLCONCAT = 736,
    XMLELEMENT = 737,
    XMLEXISTS = 738,
    XMLFOREST = 739,
    XMLPARSE = 740,
    XMLPI = 741,
    XMLROOT = 742,
    XMLSERIALIZE = 743,
    YEAR_P = 744,
    YES_P = 745,
    ZONE = 746,
    NULLS_FIRST = 747,
    NULLS_LAST = 748,
    WITH_TIME = 749,
    POSTFIXOP = 750,
    UMINUS = 751
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 564 "preproc.y" /* yacc.c:355  */

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;

#line 1182 "preproc.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE base_yylval;
extern YYLTYPE base_yylloc;
int base_yyparse (void);

#endif /* !YY_BASE_YY_PREPROC_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1211 "preproc.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   109094

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  516
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  700
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2795
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  5113

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   751

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   503,     2,     2,
     508,   509,   501,   499,   511,   500,   510,   502,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   513,   512,
     496,   495,   497,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   506,     2,   507,   504,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   514,     2,   515,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     498,   505
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1478,  1478,  1481,  1483,  1485,  1487,  1489,  1491,  1493,
    1495,  1497,  1499,  1501,  1503,  1505,  1507,  1509,  1511,  1513,
    1515,  1517,  1519,  1521,  1523,  1525,  1527,  1529,  1531,  1533,
    1535,  1553,  1555,  1557,  1559,  1561,  1563,  1565,  1567,  1569,
    1571,  1573,  1575,  1577,  1579,  1581,  1583,  1585,  1587,  1589,
    1591,  1593,  1595,  1597,  1599,  1601,  1603,  1605,  1607,  1609,
    1611,  1613,  1617,  1619,  1621,  1623,  1625,  1627,  1629,  1631,
    1633,  1635,  1637,  1639,  1641,  1643,  1645,  1647,  1649,  1651,
    1653,  1655,  1657,  1659,  1661,  1663,  1665,  1667,  1669,  1671,
    1673,  1675,  1677,  1679,  1681,  1683,  1685,  1692,  1694,  1696,
    1698,  1700,  1702,  1704,  1706,  1708,  1710,  1712,  1714,  1720,
    1722,  1724,  1726,  1728,  1730,  1732,  1734,  1736,  1742,  1752,
    1756,  1762,  1766,  1776,  1786,  1787,  1801,  1808,  1814,  1825,
    1831,  1840,  1847,  1853,  1862,  1869,  1877,  1882,  1890,  1895,
    1901,  1906,  1912,  1917,  1923,  1927,  1931,  1935,  1939,  1943,
    1947,  1951,  1955,  1963,  1967,  1971,  1975,  1979,  1983,  1991,
    1999,  2008,  2010,  2018,  2022,  2030,  2038,  2042,  2050,  2054,
    2062,  2066,  2074,  2082,  2090,  2094,  2102,  2106,  2114,  2118,
    2122,  2127,  2136,  2141,  2147,  2152,  2158,  2162,  2166,  2170,
    2174,  2178,  2186,  2190,  2194,  2202,  2206,  2210,  2218,  2222,
    2226,  2230,  2234,  2238,  2242,  2247,  2251,  2255,  2259,  2263,
    2267,  2271,  2279,  2283,  2291,  2295,  2303,  2307,  2321,  2325,
    2329,  2333,  2341,  2345,  2349,  2353,  2361,  2365,  2369,  2373,
    2377,  2381,  2385,  2393,  2397,  2402,  2408,  2412,  2420,  2424,
    2428,  2432,  2436,  2444,  2448,  2456,  2460,  2468,  2472,  2476,
    2480,  2484,  2493,  2501,  2505,  2513,  2517,  2525,  2533,  2537,
    2541,  2545,  2553,  2557,  2561,  2565,  2569,  2573,  2577,  2581,
    2585,  2589,  2597,  2601,  2609,  2613,  2617,  2621,  2625,  2629,
    2633,  2637,  2641,  2645,  2649,  2653,  2657,  2661,  2665,  2669,
    2673,  2677,  2681,  2685,  2689,  2693,  2697,  2701,  2705,  2709,
    2713,  2717,  2721,  2725,  2729,  2733,  2737,  2741,  2745,  2749,
    2753,  2757,  2761,  2765,  2769,  2773,  2781,  2785,  2793,  2797,
    2802,  2808,  2813,  2819,  2824,  2830,  2838,  2843,  2849,  2853,
    2861,  2865,  2869,  2873,  2881,  2889,  2893,  2901,  2905,  2909,
    2913,  2921,  2926,  2934,  2942,  2950,  2954,  2962,  2967,  2973,
    2977,  2981,  2989,  2993,  3001,  3006,  3012,  3016,  3020,  3024,
    3028,  3032,  3036,  3040,  3044,  3048,  3052,  3056,  3060,  3068,
    3073,  3079,  3084,  3090,  3095,  3101,  3106,  3112,  3116,  3124,
    3132,  3136,  3140,  3144,  3149,  3155,  3159,  3167,  3175,  3179,
    3183,  3187,  3195,  3199,  3203,  3207,  3211,  3215,  3219,  3224,
    3230,  3235,  3241,  3246,  3252,  3256,  3264,  3268,  3276,  3280,
    3284,  3292,  3296,  3304,  3312,  3320,  3325,  3331,  3335,  3339,
    3343,  3351,  3355,  3359,  3363,  3367,  3371,  3375,  3383,  3387,
    3391,  3395,  3403,  3411,  3415,  3420,  3426,  3430,  3434,  3438,
    3442,  3446,  3454,  3458,  3466,  3470,  3474,  3478,  3482,  3486,
    3490,  3498,  3503,  3509,  3514,  3520,  3524,  3532,  3540,  3544,
    3549,  3554,  3560,  3564,  3572,  3576,  3584,  3589,  3595,  3599,
    3603,  3607,  3612,  3618,  3626,  3634,  3638,  3642,  3646,  3650,
    3658,  3663,  3669,  3673,  3677,  3682,  3688,  3692,  3696,  3701,
    3707,  3712,  3718,  3723,  3729,  3737,  3745,  3749,  3754,  3760,
    3768,  3776,  3781,  3787,  3795,  3803,  3807,  3815,  3820,  3826,
    3830,  3838,  3842,  3846,  3850,  3854,  3858,  3862,  3866,  3870,
    3874,  3878,  3882,  3890,  3895,  3901,  3905,  3909,  3913,  3921,
    3925,  3933,  3937,  3945,  3950,  3956,  3960,  3968,  3973,  3979,
    3983,  3991,  3996,  4002,  4006,  4014,  4019,  4025,  4033,  4038,
    4044,  4048,  4056,  4060,  4068,  4073,  4079,  4083,  4087,  4095,
    4103,  4108,  4114,  4122,  4126,  4130,  4134,  4138,  4142,  4146,
    4150,  4154,  4158,  4162,  4166,  4170,  4174,  4178,  4182,  4186,
    4190,  4194,  4198,  4202,  4206,  4210,  4214,  4222,  4230,  4234,
    4238,  4242,  4250,  4254,  4262,  4267,  4273,  4277,  4285,  4289,
    4297,  4302,  4308,  4312,  4320,  4328,  4332,  4340,  4344,  4348,
    4352,  4360,  4368,  4376,  4384,  4392,  4397,  4403,  4407,  4415,
    4420,  4426,  4430,  4438,  4442,  4446,  4454,  4458,  4466,  4470,
    4478,  4486,  4490,  4494,  4502,  4506,  4514,  4522,  4526,  4534,
    4538,  4542,  4550,  4554,  4562,  4566,  4570,  4574,  4578,  4586,
    4591,  4597,  4602,  4608,  4612,  4620,  4625,  4631,  4635,  4640,
    4646,  4650,  4654,  4658,  4666,  4671,  4678,  4680,  4688,  4692,
    4696,  4700,  4704,  4708,  4716,  4720,  4728,  4732,  4740,  4744,
    4752,  4760,  4764,  4772,  4780,  4784,  4788,  4792,  4800,  4809,
    4818,  4822,  4826,  4830,  4834,  4838,  4842,  4846,  4850,  4854,
    4858,  4862,  4866,  4870,  4878,  4886,  4890,  4898,  4902,  4910,
    4914,  4918,  4922,  4926,  4934,  4938,  4946,  4954,  4958,  4966,
    4974,  4979,  4985,  4989,  4997,  5001,  5005,  5013,  5018,  5024,
    5032,  5036,  5044,  5048,  5052,  5056,  5060,  5068,  5073,  5079,
    5084,  5090,  5094,  5099,  5105,  5111,  5117,  5125,  5129,  5137,
    5141,  5149,  5153,  5161,  5165,  5173,  5177,  5185,  5193,  5201,
    5205,  5209,  5213,  5221,  5225,  5229,  5233,  5237,  5241,  5245,
    5249,  5253,  5257,  5261,  5265,  5269,  5273,  5277,  5281,  5285,
    5293,  5297,  5305,  5309,  5317,  5321,  5329,  5337,  5341,  5346,
    5352,  5356,  5360,  5364,  5368,  5372,  5376,  5380,  5384,  5388,
    5392,  5396,  5400,  5408,  5412,  5416,  5420,  5424,  5428,  5432,
    5436,  5440,  5444,  5448,  5452,  5456,  5460,  5464,  5468,  5472,
    5476,  5480,  5484,  5488,  5492,  5496,  5504,  5508,  5516,  5520,
    5524,  5528,  5532,  5540,  5545,  5551,  5555,  5559,  5563,  5567,
    5571,  5575,  5579,  5583,  5587,  5591,  5595,  5599,  5607,  5611,
    5619,  5623,  5627,  5631,  5637,  5643,  5649,  5655,  5661,  5667,
    5673,  5683,  5694,  5705,  5716,  5727,  5738,  5749,  5765,  5781,
    5797,  5808,  5824,  5835,  5851,  5866,  5870,  5878,  5883,  5889,
    5897,  5901,  5909,  5913,  5917,  5921,  5925,  5933,  5937,  5945,
    5949,  5953,  5957,  5965,  5969,  5973,  5977,  5981,  5985,  5989,
    5993,  5997,  6001,  6005,  6009,  6013,  6017,  6021,  6025,  6033,
    6037,  6045,  6049,  6057,  6062,  6068,  6072,  6080,  6088,  6096,
    6100,  6108,  6113,  6119,  6124,  6130,  6138,  6143,  6149,  6153,
    6157,  6165,  6169,  6173,  6181,  6185,  6189,  6193,  6201,  6209,
    6214,  6220,  6225,  6231,  6236,  6242,  6247,  6253,  6257,  6265,
    6269,  6273,  6281,  6286,  6292,  6296,  6301,  6307,  6311,  6316,
    6322,  6326,  6331,  6337,  6341,  6345,  6353,  6358,  6364,  6368,
    6376,  6380,  6388,  6392,  6400,  6404,  6412,  6416,  6420,  6424,
    6428,  6436,  6440,  6444,  6448,  6452,  6460,  6468,  6476,  6480,
    6484,  6492,  6496,  6500,  6508,  6512,  6520,  6524,  6528,  6532,
    6536,  6540,  6544,  6548,  6552,  6556,  6560,  6564,  6568,  6572,
    6576,  6584,  6588,  6592,  6596,  6604,  6608,  6616,  6621,  6627,
    6635,  6639,  6647,  6655,  6659,  6667,  6672,  6678,  6682,  6690,
    6694,  6702,  6706,  6714,  6718,  6722,  6726,  6734,  6738,  6746,
    6754,  6758,  6766,  6770,  6778,  6782,  6786,  6794,  6798,  6803,
    6809,  6817,  6822,  6828,  6832,  6836,  6844,  6848,  6856,  6861,
    6867,  6871,  6875,  6879,  6883,  6887,  6891,  6895,  6899,  6903,
    6907,  6911,  6915,  6919,  6923,  6927,  6931,  6935,  6939,  6943,
    6947,  6951,  6955,  6959,  6963,  6967,  6971,  6975,  6979,  6983,
    6987,  6991,  6995,  6999,  7003,  7007,  7011,  7015,  7019,  7023,
    7027,  7031,  7035,  7039,  7043,  7047,  7051,  7059,  7064,  7070,
    7075,  7081,  7085,  7089,  7093,  7097,  7101,  7105,  7109,  7113,
    7117,  7121,  7125,  7129,  7133,  7137,  7141,  7145,  7149,  7153,
    7157,  7161,  7165,  7169,  7173,  7181,  7185,  7189,  7193,  7197,
    7201,  7205,  7209,  7213,  7217,  7221,  7225,  7229,  7233,  7237,
    7241,  7245,  7249,  7253,  7261,  7269,  7273,  7277,  7285,  7289,
    7297,  7301,  7305,  7309,  7313,  7321,  7326,  7332,  7336,  7340,
    7344,  7352,  7356,  7361,  7367,  7371,  7379,  7387,  7392,  7398,
    7406,  7410,  7418,  7422,  7426,  7430,  7434,  7438,  7442,  7446,
    7450,  7454,  7458,  7462,  7466,  7470,  7478,  7482,  7487,  7493,
    7497,  7501,  7505,  7509,  7517,  7521,  7525,  7533,  7538,  7544,
    7548,  7552,  7556,  7564,  7569,  7574,  7580,  7586,  7594,  7602,
    7607,  7613,  7617,  7621,  7625,  7629,  7633,  7637,  7641,  7645,
    7649,  7653,  7657,  7661,  7665,  7669,  7673,  7681,  7686,  7692,
    7696,  7704,  7712,  7717,  7723,  7731,  7735,  7743,  7751,  7755,
    7759,  7763,  7767,  7771,  7775,  7783,  7788,  7794,  7802,  7806,
    7810,  7814,  7818,  7822,  7830,  7838,  7842,  7846,  7854,  7859,
    7865,  7869,  7873,  7877,  7881,  7889,  7893,  7901,  7905,  7909,
    7913,  7921,  7925,  7933,  7937,  7945,  7950,  7956,  7961,  7967,
    7972,  7978,  7983,  7989,  7993,  7997,  8001,  8009,  8013,  8017,
    8021,  8025,  8029,  8033,  8037,  8041,  8049,  8053,  8061,  8069,
    8073,  8081,  8085,  8090,  8096,  8102,  8112,  8117,  8123,  8127,
    8131,  8135,  8143,  8145,  8153,  8158,  8164,  8172,  8176,  8180,
    8188,  8192,  8200,  8208,  8213,  8219,  8227,  8232,  8238,  8246,
    8251,  8257,  8261,  8265,  8269,  8273,  8277,  8281,  8285,  8293,
    8298,  8304,  8312,  8316,  8324,  8328,  8336,  8344,  8352,  8360,
    8364,  8372,  8425,  8429,  8442,  8444,  8448,  8452,  8456,  8465,
    8471,  8475,  8483,  8487,  8495,  8499,  8507,  8511,  8515,  8519,
    8523,  8527,  8531,  8535,  8543,  8547,  8555,  8559,  8563,  8567,
    8571,  8575,  8583,  8587,  8595,  8599,  8607,  8615,  8620,  8626,
    8631,  8633,  8639,  8643,  8647,  8651,  8655,  8659,  8663,  8667,
    8671,  8679,  8684,  8690,  8694,  8699,  8705,  8709,  8713,  8718,
    8724,  8729,  8735,  8743,  8747,  8755,  8759,  8767,  8771,  8775,
    8779,  8787,  8792,  8798,  8802,  8807,  8815,  8819,  8827,  8831,
    8839,  8847,  8851,  8856,  8862,  8870,  8874,  8882,  8886,  8894,
    8899,  8905,  8910,  8916,  8920,  8928,  8933,  8939,  8943,  8951,
    8959,  8963,  8967,  8971,  8979,  8984,  8990,  8994,  9002,  9007,
    9013,  9017,  9025,  9029,  9033,  9037,  9044,  9051,  9055,  9063,
    9067,  9071,  9075,  9079,  9083,  9091,  9095,  9099,  9103,  9111,
    9116,  9122,  9126,  9130,  9134,  9139,  9145,  9149,  9153,  9157,
    9165,  9170,  9176,  9180,  9188,  9192,  9196,  9200,  9208,  9212,
    9220,  9224,  9228,  9236,  9244,  9249,  9255,  9259,  9265,  9271,
    9276,  9282,  9286,  9294,  9302,  9304,  9306,  9310,  9314,  9318,
    9326,  9336,  9347,  9356,  9360,  9364,  9368,  9372,  9376,  9380,
    9388,  9392,  9396,  9400,  9408,  9412,  9420,  9425,  9431,  9435,
    9439,  9443,  9447,  9451,  9455,  9459,  9463,  9467,  9471,  9479,
    9484,  9490,  9494,  9502,  9506,  9514,  9522,  9530,  9534,  9542,
    9546,  9554,  9562,  9570,  9574,  9578,  9582,  9586,  9590,  9598,
    9603,  9609,  9614,  9620,  9624,  9628,  9632,  9640,  9648,  9652,
    9657,  9663,  9667,  9671,  9675,  9679,  9683,  9687,  9691,  9695,
    9699,  9703,  9707,  9711,  9716,  9722,  9726,  9734,  9738,  9742,
    9746,  9750,  9754,  9758,  9762,  9766,  9770,  9774,  9778,  9782,
    9786,  9790,  9794,  9798,  9802,  9806,  9810,  9814,  9818,  9822,
    9826,  9830,  9834,  9838,  9842,  9846,  9850,  9854,  9858,  9862,
    9866,  9870,  9874,  9878,  9882,  9886,  9890,  9894,  9898,  9902,
    9906,  9910,  9914,  9918,  9922,  9926,  9930,  9934,  9938,  9942,
    9946,  9950,  9954,  9958,  9963,  9967,  9975,  9979,  9983,  9987,
    9991,  9995,  9999, 10003, 10007, 10011, 10015, 10019, 10023, 10027,
   10031, 10035, 10039, 10043, 10047, 10051, 10055, 10059, 10067, 10071,
   10075, 10079, 10083, 10087, 10091, 10095, 10099, 10103, 10107, 10111,
   10119, 10123, 10127, 10131, 10135, 10139, 10143, 10147, 10151, 10155,
   10159, 10163, 10167, 10171, 10175, 10179, 10183, 10187, 10191, 10195,
   10199, 10203, 10207, 10211, 10215, 10219, 10223, 10227, 10231, 10235,
   10239, 10243, 10247, 10251, 10255, 10259, 10263, 10267, 10271, 10275,
   10279, 10283, 10287, 10291, 10295, 10299, 10303, 10307, 10311, 10315,
   10323, 10327, 10335, 10339, 10343, 10348, 10354, 10362, 10366, 10374,
   10378, 10386, 10390, 10398, 10402, 10407, 10413, 10417, 10421, 10425,
   10433, 10438, 10444, 10448, 10456, 10464, 10468, 10473, 10479, 10487,
   10491, 10498, 10503, 10509, 10514, 10519, 10525, 10529, 10537, 10541,
   10545, 10549, 10553, 10561, 10565, 10569, 10577, 10581, 10585, 10593,
   10597, 10605, 10609, 10613, 10617, 10621, 10625, 10629, 10633, 10637,
   10645, 10649, 10657, 10661, 10669, 10673, 10677, 10681, 10685, 10689,
   10697, 10701, 10709, 10713, 10721, 10725, 10733, 10737, 10745, 10749,
   10753, 10761, 10765, 10773, 10778, 10784, 10788, 10792, 10796, 10800,
   10804, 10808, 10812, 10820, 10824, 10832, 10840, 10845, 10851, 10855,
   10859, 10863, 10867, 10872, 10878, 10886, 10894, 10898, 10902, 10910,
   10914, 10922, 10930, 10934, 10942, 10950, 10955, 10961, 10966, 10972,
   10976, 10984, 10988, 10992, 10996, 11004, 11008, 11017, 11019, 11027,
   11032, 11038, 11042, 11050, 11054, 11062, 11070, 11074, 11082, 11086,
   11090, 11094, 11102, 11106, 11114, 11118, 11126, 11130, 11138, 11146,
   11154, 11162, 11170, 11178, 11186, 11190, 11198, 11202, 11206, 11210,
   11214, 11218, 11222, 11226, 11230, 11234, 11238, 11242, 11246, 11250,
   11251, 11256, 11262, 11270, 11274, 11282, 11286, 11287, 11291, 11299,
   11303, 11307, 11311, 11319, 11323, 11327, 11331, 11335, 11339, 11343,
   11347, 11351, 11355, 11359, 11363, 11367, 11371, 11375, 11379, 11383,
   11387, 11391, 11395, 11399, 11403, 11407, 11411, 11415, 11419, 11423,
   11427, 11431, 11435, 11439, 11443, 11447, 11451, 11455, 11459, 11463,
   11467, 11471, 11475, 11479, 11483, 11487, 11491, 11495, 11499, 11503,
   11507, 11511, 11515, 11519, 11523, 11527, 11531, 11535, 11539, 11543,
   11547, 11551, 11555, 11559, 11563, 11567, 11571, 11575, 11579, 11583,
   11587, 11591, 11595, 11599, 11603, 11607, 11611, 11615, 11619, 11623,
   11627, 11631, 11635, 11639, 11643, 11647, 11651, 11655, 11659, 11663,
   11667, 11671, 11675, 11679, 11683, 11687, 11691, 11695, 11699, 11703,
   11707, 11711, 11715, 11719, 11723, 11727, 11731, 11735, 11739, 11743,
   11747, 11751, 11755, 11759, 11763, 11767, 11771, 11775, 11779, 11783,
   11787, 11791, 11795, 11799, 11803, 11807, 11811, 11815, 11819, 11823,
   11827, 11831, 11835, 11839, 11843, 11847, 11851, 11855, 11859, 11863,
   11867, 11871, 11875, 11879, 11883, 11887, 11891, 11895, 11899, 11903,
   11907, 11911, 11915, 11919, 11923, 11927, 11931, 11935, 11939, 11943,
   11947, 11951, 11955, 11959, 11963, 11967, 11971, 11975, 11979, 11983,
   11987, 11991, 11995, 11999, 12003, 12007, 12011, 12015, 12019, 12023,
   12027, 12031, 12035, 12039, 12043, 12047, 12051, 12055, 12059, 12063,
   12067, 12071, 12075, 12079, 12083, 12087, 12091, 12095, 12099, 12103,
   12107, 12111, 12115, 12119, 12123, 12127, 12131, 12135, 12139, 12143,
   12147, 12151, 12155, 12159, 12163, 12167, 12171, 12175, 12179, 12183,
   12187, 12191, 12195, 12199, 12203, 12207, 12211, 12215, 12219, 12223,
   12227, 12231, 12235, 12239, 12243, 12247, 12251, 12255, 12259, 12263,
   12267, 12271, 12275, 12279, 12283, 12287, 12291, 12295, 12303, 12307,
   12311, 12315, 12319, 12323, 12327, 12331, 12335, 12339, 12343, 12347,
   12351, 12355, 12359, 12363, 12367, 12371, 12375, 12379, 12383, 12387,
   12391, 12395, 12399, 12403, 12407, 12411, 12415, 12419, 12423, 12427,
   12431, 12435, 12439, 12443, 12447, 12451, 12455, 12459, 12463, 12467,
   12471, 12475, 12483, 12487, 12491, 12495, 12499, 12503, 12507, 12511,
   12515, 12519, 12523, 12527, 12531, 12535, 12539, 12543, 12547, 12551,
   12555, 12559, 12563, 12567, 12571, 12579, 12583, 12587, 12591, 12595,
   12599, 12603, 12607, 12611, 12615, 12619, 12623, 12627, 12631, 12635,
   12639, 12643, 12647, 12651, 12655, 12659, 12663, 12667, 12671, 12675,
   12679, 12683, 12687, 12691, 12695, 12699, 12703, 12707, 12711, 12715,
   12719, 12723, 12727, 12731, 12735, 12739, 12743, 12747, 12751, 12755,
   12759, 12763, 12767, 12771, 12775, 12779, 12783, 12787, 12791, 12795,
   12799, 12803, 12807, 12811, 12815, 12819, 12823, 12827, 12831, 12835,
   12839, 12843, 12847, 12851, 12855, 12859, 12863, 12867, 12871, 12875,
   12885, 12886, 12889, 12890, 12891, 12897, 12898, 12899, 12900, 12901,
   12914, 12914, 12923, 12938, 12940, 12943, 12945, 12949, 12961, 12977,
   12981, 12992, 12993, 12996, 13008, 13017, 13018, 13021, 13022, 13023,
   13026, 13027, 13030, 13031, 13034, 13035, 13038, 13040, 13042, 13044,
   13048, 13055, 13062, 13078, 13112, 13122, 13125, 13129, 13142, 13143,
   13145, 13147, 13151, 13165, 13172, 13233, 13242, 13244, 13245, 13248,
   13250, 13251, 13254, 13255, 13256, 13257, 13258, 13265, 13264, 13274,
   13276, 13278, 13279, 13282, 13283, 13284, 13285, 13288, 13289, 13293,
   13292, 13309, 13307, 13323, 13322, 13336, 13342, 13343, 13346, 13348,
   13349, 13352, 13353, 13354, 13355, 13358, 13359, 13362, 13370, 13387,
   13395, 13418, 13524, 13558, 13560, 13562, 13566, 13570, 13569, 13620,
   13622, 13621, 13636, 13642, 13649, 13654, 13660, 13661, 13664, 13665,
   13666, 13667, 13668, 13669, 13670, 13678, 13686, 13689, 13690, 13691,
   13692, 13693, 13694, 13702, 13710, 13711, 13712, 13715, 13716, 13719,
   13721, 13730, 13818, 13819, 13826, 13827, 13828, 13834, 13843, 13846,
   13847, 13848, 13849, 13852, 13853, 13854, 13857, 13859, 13867, 13868,
   13874, 13882, 13883, 13886, 13887, 13890, 13895, 13902, 13907, 13914,
   13921, 13921, 13923, 13930, 13931, 13934, 13935, 13936, 13937, 13938,
   13939, 13940, 13941, 13942, 13948, 13955, 13967, 13973, 13980, 13988,
   13989, 14001, 14012, 14023, 14027, 14028, 14031, 14036, 14040, 14041,
   14044, 14050, 14058, 14064, 14071, 14075, 14076, 14079, 14082, 14086,
   14087, 14090, 14096, 14105, 14110, 14120, 14130, 14142, 14143, 14144,
   14145, 14146, 14147, 14148, 14149, 14150, 14151, 14152, 14153, 14154,
   14155, 14156, 14163, 14164, 14167, 14168, 14175, 14176, 14177, 14184,
   14183, 14200, 14201, 14208, 14207, 14277, 14283, 14289, 14297, 14303,
   14309, 14315, 14321, 14327, 14333, 14339, 14345, 14356, 14357, 14360,
   14361, 14362, 14363, 14364, 14365, 14366, 14367, 14368, 14369, 14370,
   14371, 14372, 14373, 14374, 14375, 14376, 14377, 14378, 14379, 14380,
   14381, 14382, 14383, 14386, 14387, 14388, 14389, 14390, 14391, 14395,
   14396, 14397, 14398, 14399, 14400, 14401, 14404, 14407, 14408, 14409,
   14410, 14411, 14412, 14413, 14414, 14427, 14428, 14429, 14430, 14431,
   14432, 14433, 14438, 14439, 14440, 14441, 14442, 14443, 14449, 14450,
   14451, 14452, 14453, 14454, 14455, 14456, 14457, 14458, 14459, 14462,
   14463, 14464, 14465, 14466, 14469, 14470, 14471, 14472, 14475, 14476,
   14477, 14478, 14479, 14480, 14481, 14498, 14499, 14500, 14503, 14504,
   14505, 14506, 14507, 14508, 14512, 14512, 14515, 14521, 14522, 14525,
   14527, 14532, 14542, 14553, 14560, 14561, 14562, 14565, 14598, 14600,
   14602, 14605, 14615, 14625, 14635, 14636, 14639, 14641, 14642, 14643,
   14646, 14648, 14656, 14657, 14658, 14662, 14663, 14667, 14668, 14671,
   14672, 14675, 14676, 14677, 14678, 14679, 14682, 14683, 14684, 14685,
   14686, 14687, 14688, 14689, 14690, 14691, 14692, 14693, 14694, 14695,
   14696, 14697, 14698, 14699, 14700, 14701, 14702, 14703, 14704, 14705,
   14706, 14707, 14708, 14709, 14710, 14711, 14712, 14713, 14714, 14715,
   14716, 14717, 14718, 14719, 14720, 14721, 14722, 14723, 14724, 14725,
   14726, 14727, 14728, 14729, 14730, 14731, 14732, 14733, 14734, 14735,
   14736, 14737, 14740, 14741, 14742, 14743, 14746, 14747, 14748, 14749,
   14750, 14751, 14752, 14753, 14754, 14757, 14758, 14759, 14760, 14761,
   14764, 14765, 14768, 14769, 14780, 14781
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EVENT", "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE",
  "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE",
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS",
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LATERAL_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAKPROOF",
  "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL",
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH",
  "MATERIALIZED", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P",
  "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO",
  "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P",
  "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET",
  "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER",
  "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER",
  "PARSER", "PARTIAL", "PARTITION", "PASSING", "PASSWORD", "PLACING",
  "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PREPARE",
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE",
  "PROGRAM", "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK",
  "RECURSIVE", "REF", "REFERENCES", "REFRESH", "REINDEX", "RELATIVE_P",
  "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", "RESET",
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE",
  "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL",
  "SEARCH", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES",
  "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", "SETOF",
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SNAPSHOT", "SOME",
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN",
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC",
  "SYSID", "SYSTEM_P", "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE",
  "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING",
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE",
  "TRUSTED", "TYPE_P", "TYPES_P", "UNBOUNDED", "UNCOMMITTED",
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNLOGGED",
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATE",
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING",
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE",
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE",
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS",
  "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P",
  "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'",
  "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS",
  "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'",
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList",
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem",
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", "AlterRoleSetStmt",
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt",
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt",
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt",
  "VariableSetStmt", "set_rest", "set_rest_more", "var_name", "var_list",
  "var_value", "iso_level", "opt_boolean_or_string", "zone_value",
  "opt_encoding", "NonReservedWord_or_Sconst", "VariableResetStmt",
  "SetResetClause", "FunctionSetResetClause", "VariableShowStmt",
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode",
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds",
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior",
  "opt_collate_clause", "alter_using", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "opt_program", "copy_file_name", "copy_options",
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids",
  "copy_delimiter", "opt_using", "copy_generic_opt_list",
  "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateMatViewStmt",
  "create_mv_target", "OptNoLog", "RefreshMatViewStmt", "CreateSeqStmt",
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by",
  "NumericOnly", "NumericOnly_list", "CreatePLangStmt", "opt_trusted",
  "handler_name", "opt_inline_handler", "validator_clause",
  "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen",
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable",
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt",
  "CreateEventTrigStmt", "event_trigger_when_list",
  "event_trigger_when_item", "event_trigger_value_list",
  "AlterEventTrigStmt", "enable_trigger", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "opt_if_not_exists", "CreateOpClassStmt", "opclass_item_list",
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label",
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt",
  "RevokeStmt", "privileges", "privilege_list", "privilege",
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption",
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique",
  "opt_concurrently", "opt_index_name", "access_method_clause",
  "index_params", "index_elem", "opt_collate", "opt_class", "opt_asc_desc",
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args",
  "func_args_list", "func_args_with_defaults",
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name",
  "func_return", "func_type", "func_arg_with_default",
  "createfunc_opt_list", "common_func_opt_item", "createfunc_opt_item",
  "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "for_locking_strength", "locked_rels_list", "values_clause",
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause",
  "opt_alias_clause", "func_alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone",
  "xml_attributes", "xml_attribute_list", "xml_attribute_el",
  "document_or_content", "xml_whitespace_option", "xmlexists_argument",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "role_list", "SignedIconst", "NonReservedWord",
  "unreserved_keyword", "col_name_keyword", "type_func_name_keyword",
  "reserved_keyword", "statements", "statement", "CreateAsStmt", "$@1",
  "at", "ECPGConnect", "connection_target", "opt_database_name",
  "db_prefix", "server", "opt_server", "server_name", "opt_port",
  "opt_connection_name", "opt_user", "ora_user", "user_name",
  "char_variable", "opt_options", "connect_options", "opt_opt_value",
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt",
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale",
  "ecpg_interval", "ECPGDeclaration", "$@2", "sql_startdeclare",
  "sql_enddeclare", "var_type_declarations", "vt_declarations",
  "variable_declarations", "type_declaration", "$@3", "var_declaration",
  "$@4", "$@5", "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,    61,    60,    62,   750,    43,
      45,    42,    47,    37,    94,   751,    91,    93,    40,    41,
      46,    44,    59,    58,   123,   125
};
# endif

#define YYPACT_NINF -4436

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4436)))

#define YYTABLE_NINF -2637

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-2637)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   -4436,   342, 20163, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, 25815, -4436,
   -4436, -4436, -4436, -4436, 97860,   694, -4436, -4436, -4436,102748,
   -4436, -4436, -4436,   510, 66270, -4436, 69186,   904, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, 72588, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, 55566,  1138, -4436,
     430, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  1264, 10235,
   -4436, -4436, 69672, -4436,   358, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, 70158,   538, -4436, -4436,   971,  1363, -4436,   103,
   13721, -4436, -4436, 62868, 67242, -4436, -4436, 73074,   166,  1884,
   12529,  1264, 25326, 73560, -4436,  1448, -4436, 52122, -4436, -4436,
   -4436, 66756, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, 80364,  2472,   629, 52617, -4436, -4436,
   -4436, -4436, 80364, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, 74046, -4436,   873,  1080,   757, 80850, 81336,
   64326, -4436,  1618, -4436, 80364,  1206,   720, 54592, -4436, 81822,
   -4436, -4436,  1054, -4436, 74532, -4436, -4436, -4436, -4436,   629,
   -4436, 55566, 51148,    61,  1036, -4436, -4436, 82308, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436,  1696,  1082, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436,   538, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436,   736, -4436,   804,   783,  1133,   619,  1237, -4436,
   -4436, -4436,  9021, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   99309,  1961, -4436, -4436, -4436,  1301, -4436,  1371, -4436, -4436,
   -4436,  1541, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  1560,
   -4436, -4436, -4436, -4436,  1926, 98343, 72588, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, 62382, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
     168, -4436, -4436, -4436, -4436, -4436, 72588, 72588, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, 72588,  1517, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436,   796,  1742, -4436, -4436,
   55566,  2266,  2266,  2005, 99309, -4436, -4436, -4436, 56540, 80364,
   80364, 80364,  1692, 80364,  1633, 80364,   322, 56540,106931, 82794,
    1760,  1649, 46680, -4436,105677, 80364, 80364, 83280, 80364, 75018,
   80364,  1756, 80364, 80364,106095, 83766,  1858, -4436,  2236,   918,
   -4436, -4436, -4436, 80364,  9698,  2472, -4436, -4436, 80364,  1862,
   56540, 80364,  1817, 80364,  1898, 80364, -4436, 80364,  1907, 84252,
     343,  1885,106931,  1912, 47179,  1987,106931, 84738, 80364, 80364,
   -4436, -4436,  1960, 80364, 80364, -4436,  2075,107349,    12,  2080,
    2224,  2134,   758, -4436, -4436,  2309,  1904, -4436, -4436,  2364,
   72588, -4436, 70644, -4436, -4436, -4436,  2278, -4436, -4436, -4436,
   -4436, -4436,104005,  1884, -4436, -4436, 57027, 80364,  2189, -4436,
   -4436, 85224, -4436,  2007, -4436,   347, 57514,107767,  2304,  1993,
   47678,  2344,108185, 85710, -4436, -4436, 86196, -4436, 86682,  2085,
   87168, -4436,108603, -4436,  2207, 87654, -4436, 21261, -4436,  1978,
    2116,  1991,  1482, 72588, 72588,  1322,100628, -4436, -4436,   538,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,   153,  1429,
   53112,   822, 53607, -4436, -4436,   969,   977,  1070,   153,  2429,
    2429,   821, 72588, -4436, -4436,  1429, -4436,   639,   -29,  2010,
    2010,  2010,  2212,   988, -4436,  2010, -4436, -4436, -4436, -4436,
   74532, 53112, 53607, -4436,  2019,  2472,    82,  2419,  2097, 80364,
   -4436, 80364, -4436, 80364, 80364, -4436, -4436, -4436,  2455,  2071,
    2311, -4436,  2079, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
    2263,  2274,  2282,   106,  2472,  2178, -4436,  2394, -4436,  2295,
   30780,  1153, 72588,  2472, 54102, 75504, 95430,   186,104005,  2472,
   88140,  2141,   949,  2297, -4436, -4436,   528, -4436,  2529,  2166,
    2398,    15,   918, 44221, -4436,  2176,  1183, 74532, 99792, -4436,
   -4436, -4436, -4436,   190,  2460, 31284, -4436, 80364,  2171, -4436,
    2184,  2196,  2203,  1133, -4436, 80364,  1117,  1117,  2574,  1117,
    1595,  1829, -4436,  1850, -4436,  2492,  2463, 74532,  1036,  1264,
    2234, -4436, -4436, -4436,  2252, -4436,  2243,  2247, -4436,   824,
    2502, -4436, -4436, -4436, -4436,  2336,  2363,  2367,  2376,  2298,
    2382,   235, -4436, -4436, -4436, -4436,  2568, -4436, -4436, -4436,
   -4436, -4436, -4436,  2701,  2697,103169,103169,   830,   865,   133,
     195, -4436, -4436, -4436,  2556, -4436, -4436,  2554, 80364,  2392,
   80364, -4436, -4436, -4436, 88626, -4436, -4436,  2266,  2252,  2319,
   -4436,   273, -4436,  1183, -4436,   348,   384,   433,  1381,  2324,
    1549,  1644, -4436,   126, 80364,  2434,   159,   -43,  2365, 75990,
    7760,  2347,   360,  2633,  4878,   235, 89112, -4436, 80364, 80364,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  2377,
   -4436, -4436,  2358,  2625,  1382,  2572,  1719,  2668,  8489,  1515,
    2681,  5165,  2008,   920,  2575,  1612,  2625,  2686,  1416,  2715,
    5487, 80364,  2418, -4436,  2656,  2761,   475, -4436,   157, -4436,
    2503,  2636,   658, 56540,  2458, -4436, -4436, 80364, -4436, -4436,
   -4436,  2536, -4436,   379, 56540, -4436,  2654,  2508, 48177, -4436,
   80364, -4436, -4436, -4436, -4436, -4436,  2592, 80364, -4436, -4436,
    2721, 80364, -4436,  2010,  2647,  2511,  2887, 59949,   118, 80364,
    2561,  2922, 80364,  2738,  2561,  2577, 89598, -4436, -4436,  2561,
   -4436, -4436, 80364, 80364,  2557,  1963,  2561,  2745,  2957,  2962,
    2635,  2751,  1165,  1158,   111,  2873,  2561,  2629, 80364, 90084,
   80364,  2643, 80364,  2954, 56540, 80364, -4436,  2763, 76476, -4436,
    2603,  2309, -4436, -4436, -4436, -4436, -4436,   644, -4436, -4436,
   -4436, -4436,  2905,  2319,   396,  2914,  2621,  2918, -4436, -4436,
    2662, -4436,  2921,  2347,  2930, -4436,  2638, 90570, -4436, 91056,
   91542,  2931,  2377,106931,  2941,  2638,  2951,  2841,  2956,   396,
    2959, -4436,  1235,  2965,  2858,  2973,  1501,  2638,104423,  2980,
      99, -4436, 14268, 21261, -4436, 26767,  1694, -4436, -4436, -4436,
   -4436, -4436, -4436, 34812,   885,  2775, -4436, -4436, -4436,  -111,
   -4436,101901, -4436,  1322,  1429, -4436, 72588,  1429, 72588,   821,
    1429, 72588,  1429, 72588,   821,  1429, 72588, 72588, 72588,  1429,
   -4436, -4436,  1713,  2051, -4436, -4436, -4436, -4436, -4436, 72588,
    2698, 80364, 80364, -4436, -4436, -4436, 67728,106931, 68214, -4436,
   -4436,   282, 72588, -4436, 72588, -4436,  2472, -4436, -4436,  2116,
   59949,  3105,106931, 80364,  2993,  2993,  2993, -4436, -4436, -4436,
    2942, 80364,  3003,  3010, 67728,106931, -4436, 92028,104005,  2916,
    2749, -4436, -4436, -4436, -4436,  1848,  2666,   409,  2998, 34812,
    2757,   297,   297,  2762,  3050, -4436, -4436, -4436,   456,  2768,
    2769, -4436,   368,   368,  2929,  2772,  2773, -4436,   478,  2774,
   -4436,  3006,   490,  2777,  2779,  2781,  2117,   297, 34812, -4436,
    2782,   368,  2783,  2784,  2785,  3070,  2787, -4436,  3083,  2789,
     312,   376,  2790,  2791, -4436,  2772, -4436,   210,  2797,  2799,
    2802,  2804,  2805,  2806,  2807,  2808, 34812, 34812, -4436, 29772,
    1183,  2472, -4436, -4436, -4436, -4436, -4436, -4436, -4436,    83,
   -4436,   502,  5491, -4436, -4436,  2947, 34812, -4436, -4436,    39,
   -4436,   527, -4436, -4436,  1183, -4436, -4436,  1452, -4436, -4436,
   -4436, -4436,  1782,  1782,   187, -4436, 69672, 69672, -4436, -4436,
    1387,  2809, -4436,  2049, -4436, -4436, -4436, -4436, -4436, -4436,
  103587,  3209, -4436,  1048,  2472,   157,  1625,  3155,101049,101475,
    3052,  3052,  3036, -4436, -4436, 80364, -4436, -4436, 34812, 50174,
   -4436,  1183,    96,  3053, -4436, -4436, -4436,  1880, -4436, -4436,
   -4436,   538, -4436, 11817, -4436,  1902,  2171, 80364, 80364,  3215,
   -4436, -4436,  2184, -4436, -4436,  1133,  1133, 34812,  1133,  1018,
    2060, 31788, 34812,  3101,  3001,  1049,  1536,  3103, -4436,  3005,
    1595,  1829, 74532, 80364, 92514,  2932, -4436, -4436,  2252,  2827,
    1886, -4436, 61896, 98826, 98826,  3069, -4436, -4436,  1659,  1013,
    2944,  3032,  2429,  1347,  1936,  1936, -4436, -4436,  2826, -4436,
    3160, 69672,  2886,103169, -4436, -4436, 80364, -4436, -4436, 76962,
   -4436, -4436, -4436,  1181,  2833, -4436,  2850, 80364,  3332, -4436,
    1936,  1936, -4436, -4436,  2836, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, 99309,  2842, 80364, -4436,  2843,  2844, -4436,
   99792, 50661,  1747,  1183,  2915,  2919,  2969, 55566,  2855,  2920,
    2926,  2977,  2936,  2938, 95916, -4436, -4436, -4436, -4436,  1604,
     730,  1375,  2945,    85,   910,  3223, -4436,  1651,  2989, -4436,
   -4436, -4436,  4962, 80364,  3168,  5517,  3057,   235,  2991, -4436,
   -4436,  3107,  2963,  2964,  3079,   235,  1081, 96402, -4436, -4436,
   -4436, -4436, -4436, -4436,  6425, 28286, -4436,  2970,  2950, 80364,
   63354,  3261,  3082,   -11,  2094,   154, 80364,  3156,  3088, 80364,
    2903,  2978,  2981,  2906,  1653,  3263,  2908, -4436, -4436,  3081,
    3213,  6174,  2974,  2975, 58975,  1327, 48676,  3252,  1553,  2995,
   -4436,  1553, 80364,  2999,  3004, 80364,   235, -4436,  3307,   235,
     235,  1814,  3310,  3009,   172,  1842,  2561,  2908,  2143, -4436,
    3011,  3013,  1916, -4436,  3109, 74532,   130,  1900,  2908,  3014,
    3015,  2906,  2906, 80364, 80364, 80364, 80364, 80364,   122,  3323,
    3330,  3016,   155,  3062,  2943, -4436,  1553,104841,  3019, -4436,
    1553, 80364,  3021,  2102,  2908,  1801, -4436,  1663, -4436, -4436,
   -4436,   918, -4436, 80364, -4436, 80364,  2319, 59949,  3130, -4436,
    2982, -4436,  2347,   235, -4436, 80364, 80364,  2377,  1276,  1294,
    3131, 80364,  3189,  2986, -4436,   917, 50661,  2557, -4436,  2953,
   -4436,  2997, -4436,  2997,  2997,  2955,  2955,  2960, -4436, -4436,
    2117,  2997,  2955, -4436, 60923, -4436,  1773,  1836, -4436,  3356,
    3358, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
    1637, -4436,  1977, -4436, -4436, -4436, 80364, 55566, -4436,  3370,
   -4436, -4436, 59949,  3144,  3259, -4436, 80364,  3161,  2966, -4436,
    3292,  3022, -4436, -4436,  1043, -4436,  3265,106931,   176,  2472,
    3008, 80364,  3186, 80364, 80364, 80364, 80364, -4436, -4436,  3159,
     681,   143, -4436,104841, -4436, 80364,  2143,  3170,  3380,     9,
    2010, 80364,  3267, -4436, 80364,  2983,  3384,  3218, -4436, -4436,
    2984,  2429, -4436,  2603, -4436,  1952, -4436,  3106, -4436, 56540,
     396, -4436, -4436, -4436, -4436, 59949, 80364, 93000, 56540,   396,
  106931,106931,  3283,    99,  3286,  3043,  3288,  3047, 48676,   396,
     180,106931, 80364, 80364, 80364, -4436, 80364, -4436, -4436, -4436,
   -4436, 80364, 80364,106931,104841,  3294,  3295,   396, 80364, 80364,
   -4436, -4436, 22390,  1779, -4436, 21261, -4436, 11817,  2012,  3052,
   -4436,  1517, 80364,  1530,  1322,105259, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, 72588, -4436, 72588,   821, -4436, -4436,
   72588, -4436, 72588,   821, -4436, 72588, -4436, -4436, -4436, 72588,
   80364,  3495,  3000, -4436,  1452, -4436, 80364,  2022, -4436, -4436,
    2062,   812, 80364, 80364,   709, 56540, 80364,  3191, 80364, 80364,
   80364, 80364, 80364,  3076,  2809,  1324, -4436,   318, 74532,  3197,
   -4436, -4436, -4436, -4436, -4436,  2098,  1696,  1068,  3040, -4436,
   -4436, -4436, -4436, -4436, -4436, 68214, 66756,  3289,   222, 80364,
   -4436, -4436,  4101, 34812, 30276, -4436, -4436, -4436,  3017, 11817,
    3046, 34812, -4436, -4436, 34812,  3035,  2429,  2429, 34812, -4436,
   -4436, -4436, -4436,  2426,  2429, -4436, 34812, 34812,  2429,  2429,
    2997,  2997, -4436,  6920, 34812, -4436, 48676, 34812, 36324, 27781,
   34812,  3087,  3031,  2429, -4436,  2429, -4436, 34812, 29268, -4436,
   34812,  3220, 37332, 34812,  1625,  3240, 34812,  1625,  3459,  3459,
    1036,  2136,  5764,  3037,  1183, -4436,  3148,  2429, -4436,  2429,
     750,   197, 59949, 34812, 55566,  3119,   128, 80364, 34812,  3044,
    2135, -4436, 34812,  1221, -4436,  3048, 34812,  3120, 34812, 34812,
   34812, 34812, 34812, 34812, 34812, 34812, 34812, -4436, 38312,   206,
   -4436,   -45,  2708, 68700, 30780,  3329, -4436, 27276, -4436,   242,
   72588, -4436, -4436,  1183, -4436, -4436, -4436, -4436, -4436,  1181,
    3049, -4436,  3066, -4436, -4436, -4436, -4436, -4436, 80364,  3209,
   -4436, -4436,  3132, -4436, -4436, -4436, -4436,   811, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436,  3056, -4436, -4436, -4436,
   -4436,  3056, -4436, -4436,  3052,  3060,  4151, -4436, -4436, -4436,
   -4436,  3328,  3331,   396, 99309, 80364,   190, 71130, -4436, 31284,
   -4436,  2111, -4436,  3063, -4436,  3309, -4436,  3061, -4436,  2694,
    3309, -4436, -4436,   136,  3172,  3305,  3253, -4436, -4436, -4436,
    3071, 11817, -4436,  2063, 11817,  2110, -4436, -4436, -4436, -4436,
   -4436, -4436,   519, -4436, 80364,  3197,  3101,  1536,  3127,   505,
   80364, -4436, 44711,  2084, -4436,  2252, -4436, -4436, 24455, -4436,
   26298, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
    3075, -4436, -4436, -4436, -4436, -4436,   235,  3077,  3551, -4436,
  103169, -4436, -4436, -4436,  3495, -4436,  2364, -4436,  2364,  3578,
   -4436, 72588, -4436, -4436, -4436, -4436,   979, -4436, 21261, -4436,
   21261, -4436,  3084,  2124,  3163,  3164,  3205,106931, 80364, 80364,
   -4436, 55566,106931, 80364, 80364,106931, 80364, 80364, -4436,  3443,
    1103, 66756,  3211, 64812, -4436, -4436,  3093, 80364,  3146,  3333,
    3334,  1256, -4436, -4436, 93486, -4436,  3291,106931, 80364, 80364,
   34812,  3296, 80364, 80364, -4436,   374,  3169,  3171, -4436, 80364,
    3177, 56540,  3104, 80364, 80364, 80364,  3176,   515, 56540,  3147,
   49175, 80364, 80364, 80364, 80364,  3225, 80364, 80364,  3342,   855,
   74532,   208,  2190,  2908,  3301, -4436,  1179, -4436,106931, 80364,
    3293, -4436, -4436, -4436, 65298,  3506,  3217, -4436, -4436, 96888,
   -4436, -4436,  3290, -4436, -4436, 60923, -4436, -4436,  2139, -4436,
   60436, 58001, -4436, -4436,   856,106931,106931,  6759, 80364,  1418,
   -4436, -4436, 59949, -4436, 80364, 80364, 80364, 71616, 93972, 94458,
     533,   831, 80364, 72102, -4436, 80364, -4436, -4436, 56053,106931,
   80364, 55566, -4436, 80364,  3302,   774, -4436, 80364,  3792,  3192,
   80364,   265,  2300,  2908, 80364, 80364,  3118,  2159,  3198,  3245,
   -4436, 80364, 95430, -4436,106931,  1521, -4436,  3264,106931, 80364,
   11816, -4436, -4436,   235, -4436, -4436, -4436, -4436, -4436, 80364,
   80364,   235, 80364,   235,  1370, -4436,106931, 80364, -4436, -4436,
   -4436,  7525, 80364, 80364, 80364, 80364,106931, 80364, -4436, -4436,
    1661,  1159,  1456,  1705,  3266, 80364,  3397, 80364, 94944,106931,
   80364, 80364, 80364,  1720, -4436, -4436, -4436,  3243, -4436,106931,
    1521, -4436,  7661, 80364, 80364,  3208,  3212,   117,  3282, -4436,
   -4436, -4436, -4436, -4436, -4436,  3376,  3540, 80364, -4436,  3382,
    3383,  3193,  3199,  3385,  2121, 80364, -4436, -4436, -4436, -4436,
   80364,  3388,  2121,  3336,   102, -4436, -4436,  2561, -4436,  2193,
   -4436,  3158, -4436, 34812,  3555, 59949,  3152,  3162,  3231, -4436,
    3232,  2429, -4436,  2103, -4436, -4436,  2204, -4436,  3174,   681,
    2039, -4436, 55566, 80364,   707,   766,  3455, 63840,  2676,  3448,
   80364,  3206, 80364,  2676, 80364, -4436,  3195, 66756, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436,  3450, -4436,  2472,
    2557,  2557,  2557,  2557, -4436, -4436, -4436, -4436,  3354,  1910,
   -4436,  3175,  2557, 80364,  3279,  2676,  3178, -4436,  2143,  3466,
    3471, 80364, 63840,  2179,  3210,  3579,  2010,  2472,  3364, -4436,
   28777,  3747,  3365,104005, 76476, -4436,  3190,  3453,  3454,  3472,
   -4436,  2319, -4436,  3588, -4436,  3485,   396,  2347, -4436,  2638,
   -4436, 80364, -4436, 80364, 80364, 80364, 80364,  2377, -4436, -4436,
    2638,  3372,   396,   396, -4436,  3373,   396,  2638,  3303,  3480,
  104005, -4436,    99, -4436, -4436, -4436, -4436, -4436, 34812, -4436,
   -4436,  2010,  1952, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, 72588,  2364, -4436,  2222, -4436, 80364,
   -4436,  3456,  3457,  3458,  3200,  3203,  3238, 80364,  3216, -4436,
    3200,   235,  3200,  2809,  2809,  3200,  3203,106513,  3623,  3486,
     104, -4436,   698,   431,  3420, -4436, -4436, -4436, -4436, 59949,
   -4436, -4436, -4436, -4436, -4436, 80364,  1074, -4436,   272,  3396,
    3219,106513,  3599,   396, -4436, 56540, -4436, -4436, -4436,  3297,
    3304, 56540,  3405,  3268, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436,  3462, 80364,  2225, -4436,  1792, -4436,  1824, 34812, 34812,
     243, -4436, 10282,  2241, 34812,  3222,  3224,  2253, -4436, -4436,
   -4436, -4436, -4436, -4436,  3230,  3501, -4436, -4436,  3233,  2329,
    2337,  3234,  3239, -4436, -4436,  5371,  3241, 10581,  3242, 36324,
   36324,  1600, -4436, -4436, 36324,  3244, -4436,  2341,  9521,  3221,
    3247,  3256, -4436,  3248,  3249, 11302, 32292, 34812, 32292, 32292,
   10987,  3221,  3250,  2356, 55566,  3406, 11355,  2360, -4436, 34812,
   55566,  5653, 34812, -4436, 34812, 80364,  3251,  3254, -4436, -4436,
    6920, -4436,  3270, -4436, 36324, 36324, -4436,  3868, 29772, -4436,
   -4436,  3524, -4436, -4436,  1616, -4436,  3246, -4436, -4436,  4722,
     213, 34812,  3044, 34812,  3335, 48676,  6623, 34812,  8006,  6271,
    6271,   602,   602,   225,   225,   225,  1803,  2708, -4436, -4436,
   -4436,  3257,  2787, 34812, -4436,  2432,  2447, 80364,  8508,  8987,
   10064, -4436, -4436, -4436, 39810,  3299, 34812, 34812, 34812,  3258,
    3427,  3676, 11817,   927, -4436,  3678, -4436, -4436, -4436,   925,
    3578,  1181, -4436,   918,  2429,   750,101901, -4436, -4436, -4436,
   34812, -4436, -4436, -4436, -4436,  2184, -4436, -4436, -4436, -4436,
   -4436, 80364,  1696, 34812, -4436, -4436,   893,  2170, 34812,  2063,
   -4436, -4436,  3317, -4436, 34812, -4436, -4436, -4436,  2809, -4436,
   -4436, -4436, 39810,  3306,  3311, 43731,  3393, -4436, -4436, 80364,
     286, -4436, -4436, -4436,  3281, -4436, -4436, -4436,  1770, -4436,
   -4436, -4436, -4436, -4436, -4436,  3262, -4436,  3271, -4436,  3284,
   -4436, -4436, -4436, -4436,   169,  3269,  3272,  3278,  1291, -4436,
   -4436,106931, 80364, 80364, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436,  3494, -4436,106931,106931,  3463, 80364,
    3461,  3465, 34812,   764, 80364,  3280,  3287,  1441,  3541, 80364,
   -4436,  3582,   396, -4436, -4436,  3362, -4436, 11817, -4436, -4436,
   -4436, -4436, -4436,106931, 80364, -4436,104005, -4436,  2319, 59949,
   -4436, -4436, -4436, 80364,  3321, 80364, -4436, 80364, 80364, 80364,
    2377, -4436, -4436, -4436, -4436,  1298, -4436, -4436, 80364, 80364,
      62,  3366,  3367, 80364, -4436,   972,  3109,  8204, 80364, 80364,
   80364,  3544, -4436, -4436, -4436, -4436,  3488, -4436, -4436,  1977,
   -4436, 58001, 60436, -4436, 60436, -4436,  1977,  1863, -4436,  2638,
    3374,  2908, -4436,  3476,  1279, -4436, -4436, -4436, -4436, -4436,
    3595,   396,  3597,   396, 80364, 80364, 80364, 80364, -4436, -4436,
   -4436, -4436, -4436, 55566, 55566, 55566,  2368, -4436, -4436,  2472,
   -4436, -4436, -4436,  2372, -4436,  1639, -4436, -4436, -4436, -4436,
   -4436, -4436,106931,  8936, 80364, 80364, 80364,  1941, -4436,   924,
   59949, -4436, 59462,106931, 80364, -4436, -4436,  3523,  3468, -4436,
    2167,  3469,106931,  3368, -4436, -4436,  3381, -4436, -4436,  3386,
    2306,  2908,  2143, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436,   271,  2350,  2908,  3389, -4436,  3390, -4436, -4436, -4436,
    3527,  3531,  3532,  3398,  3399,  3429,  3402,  3404,  3430, -4436,
    3408,  3440,  3409,  3441,  3410,   396, 59949,  3519,  2472,  3439,
    3636,   396, -4436,  3415, -4436, -4436,  3736, -4436, 80364, -4436,
    3417,  2389,  2908, -4436, -4436,106931, 80364, -4436, -4436, -4436,
    2121, 59949,  3583,  2121,  2121, 80364, 80364,  2121, -4436, -4436,
   -4436,  3584,  3585,  2121, -4436, -4436, -4436, -4436,  2647,  3348,
   -4436,  2278, 46181,  5972,  3351,  3162,  3349,  2429, 42261,  1300,
    3558,  3355, -4436, -4436, 55566, 46181,  1940,  3576,  3371,  3371,
    3371,  3371,  3371,  3371,  3371, -4436,  1970,   331,  2561,104005,
   80364,104005, -4436,   766,  3476, 80364, 80364,  3361,  3360, -4436,
   -4436, -4436, -4436,106931,   849,106931,  2429, -4436, -4436,  3422,
   -4436, 80364,  2010,  3757,  2962,   176,  3499,  1550,  3703, -4436,
   -4436, -4436, -4436, -4436, 80364, 80364,   681,  2472, -4436,  3375,
    3369, -4436, 80364, 80364, 80364, 80364,  1696,  3400,  3379, 59949,
     636,  3556,  3564,  2906,  3774,  1696,  3210,  3470, 80364, -4436,
    2375,    75, -4436,  2472,104005, 58488, -4436,  3529, -4436, -4436,
     899,  3666, -4436, 80364, -4436, -4436, 43241,   396, 59949, 80364,
   -4436,   396,    99,  3451,   396,  3460,   396,   396, 80364, -4436,
   -4436, 80364, -4436, 80364,104841,   396, -4436, 11817,  3687, -4436,
   -4436, -4436, -4436,  3522,  3525,  3530, 80364,  3200, 56540, -4436,
    3401,106931,  1419, -4436, -4436,  3589, -4436, -4436, -4436, -4436,
   -4436,  3710,  3711, -4436, -4436, -4436, -4436,  3740,106931, 67728,
     181,106931, -4436,  2319, -4436, -4436,  2347,   235, -4436, 80364,
    3654, -4436, -4436, -4436,  3418,  2385, 11597, 34812, -4436,  3724,
   59949, -4436,  6109, -4436, -4436, -4436, -4436, 34812, -4436, -4436,
   -4436, -4436, -4436, 34812, -4436, 34812,  3707, -4436,  3843,  3843,
   59949, 36324,  1583,  2783, 36324, 36324, 36324, 36324, 36324, 36324,
   36324, 36324, 36324, 38816,   871, -4436, -4436, 34812, 34812,  3713,
    3707, -4436, -4436,  1650,  1650, 59949,  3431,  3221,  3432,  3435,
   34812, -4436, -4436,  2391, 37822,  3436, 55566, -4436, 34812,  9822,
    2399,  3479, 11892,  1183,  6476, -4436,  3803,  2472, 34812,  1759,
    2542, 34812,  2402, 34812,  3720, -4436, -4436, -4436,  3442, -4436,
   -4436, 59949, 34812, 36324, 36324,  4811, -4436,  5283, 34812,  3445,
    8136, 29772, -4436,   629,   629,   629,   629, -4436, 80364, 80364,
   80364, 40300, 39320, 77448,  3438,  1596, -4436, 77448, 77934, -4436,
    3444,  1183, 34812,  3719,   568,   568,  3449,  3427, 45201, -4436,
   34812,  1508, 32796,  3464, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  3446,
   -4436,  3473, -4436, -4436,   157,  3467, -4436, -4436,  9256,   169,
   -4436, -4436,  3474, -4436,  3452, -4436,  2170, -4436, -4436, -4436,
    6961,  3632, -4436, -4436,  3438, 33300,  3393, -4436,  2405, -4436,
   -4436, 30780, -4436, -4436,  2410, 44711,  3306, 31284,  1183,  2429,
    3475, -4436,  2364,   925, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436,  3371,  2638,  2638,  1173,  3200,  3741,  1173,  7114,
   -4436, -4436, 40790, 80364, 80364, -4436, 80364,  2417,  1725, 80364,
   -4436, 80364, -4436, -4436, -4436, -4436,  3855, -4436, 80364, -4436,
   -4436,  3513,  3515, -4436, 80364, 80364, 80364, 80364, -4436, -4436,
    2324, -4436, -4436,106931, 80364, -4436, -4436, -4436,   289,  2415,
    2908, -4436,  3538, -4436, -4436,  3718,  1927, -4436, -4436, -4436,
    3535, 80364,  3477, -4436,  1332,  2906,   894, -4436, -4436,  3548,
   80364, -4436, 80364, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, 56053, -4436, -4436, -4436, 55566, 46181, 55566, -4436,
     294,  2465,  2908, -4436,  3560, -4436,  3561,  3562,  3611,   511,
      92,  3570,  3571,  3617,  3503,  3504,  3507, -4436, -4436,   153,
    2472, -4436, -4436,  2472,  2638,  2472, 80364, 80364, 80364, 80364,
   80364, 80364, 80364, 80364,  3785,   603,  1588,106931, 80364, 80364,
  106931, 80364, 80364, 80364, 80364, 80364, 80364, 80364, -4436,  3874,
    3806,  1769,  3848,  3580, 80364, -4436, 80364,  3109, 80364, 80364,
   -4436, -4436, -4436,  3516,  2121, -4436, -4436,  3755,  3761, -4436,
    2121,  2121, -4436,   917, 55566, -4436,  2927, -4436,  3158,  3452,
    1936,  1936, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  2429,
    2249,  3526, -4436, 42751, -4436, -4436, -4436,  2500,   750, -4436,
   -4436, 80364,  3371, -4436,  2459,  2481,  2608,  2632, 78420, 78906,
   79392,  3518, 80364, 80364, 36324, -4436,  1577,   204, -4436,  3758,
   80364,  3563, -4436, -4436, -4436,  3675, 80364, -4436, -4436, -4436,
   -4436, -4436,  3533, -4436,  3637, 63840,  2638,106931,106931,  2638,
   -4436, 59949,  3534,  3210,106931,   176,  1041, 90084,  3557,  3536,
    3815, -4436,  3537,  3539, -4436, -4436, 80364,  3476,  2435,   474,
    1991,  3040, 65784,  2179,  3789, -4436, -4436, -4436,  3896,  3622,
   -4436,  1696,  3040,  3622,  2472,  3146, -4436, 58001, 34812, 34812,
   -4436,  3542, -4436,  3543,  7099, -4436,  2557, -4436, -4436, -4436,
   -4436, -4436, -4436,  3615, 80364,  3969, -4436, -4436, -4436,  3547,
     396, -4436, -4436, 80364, -4436, 80364, -4436, -4436,   396,   396,
   -4436,  3659, -4436,  1696, 80364, 80364, 80364,  3200, -4436,   235,
   -4436,  3825,106513, -4436, -4436, -4436, -4436, -4436,   222,  3832,
   -4436, -4436,  3794,  3797,  3798,  3799,  2287, -4436, -4436, 34812,
   11817, -4436,  3552, -4436, 11817,  7236, 11817,  3713, -4436,  2759,
    3841, -4436,   160,  3568,  2759,  3395,  3395,   308,   308,   110,
     110,   110,  3843,   871, 11817, 11817, -4436, -4436, -4436, -4436,
    3577, -4436, -4436, -4436,  3221, -4436, 35316,  3704,  3946, -4436,
   -4436, -4436,  3600,  3607,  3581, -4436, 34812, 35820,  3574, 60923,
   -4436, -4436,   750,  1490, 36324, 36324,  2291, -4436,   803, 34812,
   59949,  2445,  2291,  2567,  2606, 34812, 34812,  8148,   258, 34812,
    7251, 80364, 80364, 80364, 80364, -4436, -4436, -4436, 77448, 77934,
   41770,  1596,  3586, 80364, -4436, -4436,  3590, 39810,  3819,  3762,
   -4436, 39810,  3762,  1479,  3762,  3820, -4436, 45691, -4436, -4436,
    3591, 27276,  1785, 11817,  3975,  3863, 34812,  3594, -4436,  3596,
    3427, -4436, 97374, -4436, -4436, 11817, -4436, -4436, 34812, -4436,
    3427,   925,  1110,  2472, -4436, -4436, -4436, 48676, -4436, -4436,
   -4436,  3784, 11817, -4436,  1696, 80364,  1183,   628,  3612, 80364,
   -4436,  3393, -4436, -4436, 21261, -4436, -4436, -4436,   153, -4436,
   -4436, -4436, -4436,  3674, 66756,  3881, -4436, 34812,  2449, -4436,
    3639,  3967,   131,  2456,  2461,  1725, -4436,  3563, -4436,  1593,
    3858,   203, -4436,   396, -4436, 59949, -4436, 80364, 80364, -4436,
   -4436, -4436, -4436,  2855, -4436, -4436, 80364, 80364, 80364, 80364,
   -4436,  3677, -4436, -4436, 55566,  1970,  3800, -4436, -4436,  3804,
     153, 80364, -4436, 59949,   396,   396, -4436, -4436, -4436,  3629,
   80364, 80364, 80364, 80364,106931, 80364, 80364,  2429,  2429, 59949,
    3614, -4436,  2429,  2429,  3619, -4436,106931, 80364, 80364, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
    3692, -4436, -4436, -4436, 80364, 80364, 80364, 80364,  3916, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   80364, -4436, -4436,  2472,  2472, 59949,   396,   396, -4436, -4436,
   -4436,  3866, -4436,  2121,  2121, -4436, -4436,   140,  2470, -4436,
  100210, -4436, -4436,  2922,  2472,  2922,    59, -4436, -4436,  2922,
   -4436,  2922, -4436,  1725,  3625,   150,  3906, -4436,  2489, 42751,
   42751, 42751, 42751, 42751, -4436, -4436,  3911,   153, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, 34812, -4436,   727,  2759, -4436, -4436, -4436,
   -4436,  3563,  2010,  3686, 56540,   708, -4436,  3895,   707, 63840,
    1675, 80364, -4436,  2638,  2638,  3694, 80364,  4043, -4436,   537,
   80364,  3954,  3683, -4436,  2472, -4436, -4436,  3210, 80364, 63840,
    3040, -4436,  2486, -4436, -4436, -4436,  3681,  3564,  3648,  2179,
    1261, 80364, -4436,  3684, -4436, -4436,  3931,  3652, -4436, 11817,
   11817,  2472, 61410,  3529, -4436, 80364,  3907, 80364, -4436,   396,
   -4436,   396,   396, -4436, -4436, 80364,  3200,  3200,  3200, -4436,
    3833, -4436,   396,106513,  2287,  2287,  2287,  2287, -4436, -4436,
   -4436, 11817, -4436, -4436, -4436, 36324,  3938, -4436,  3661, 59949,
   -4436,  3662,  2501,  2504, 37332,  3801, -4436, -4436, -4436,  7564,
    3712, 11817,  3760,  3665,  3668, -4436,  1195,  1195,   803,  2507,
   -4436, 36324, 36324,  2291,  2291, 34812,  2291, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, 77448,  3667, 80364,  1596, 39810, -4436,
   -4436,  1296, -4436, 39810,  3908, -4436, 39810, 80364,  3673, 80364,
     985, 34812, 34812,  3721,  3427,  3427, -4436,  3842, -4436,  3682,
   -4436, -4436,  1936, -4436, -4436, -4436, -4436,   750,  3688, 72588,
   -4436, -4436, -4436,  1036, -4436, -4436, -4436, -4436,106513,  3860,
  106513,  1725,  7995,  3563, 40790, 49674, 80364, 79878, 79878,  3828,
    3563,  3686, -4436, -4436, -4436, -4436, -4436, -4436,  3689, -4436,
   -4436, -4436,  3766, -4436, -4436, -4436,  2518, -4436, -4436, -4436,
   -4436, -4436,  3874, -4436, -4436, 46181, -4436,  3767, -4436, -4436,
   -4436, -4436, -4436, 41280, 48676, -4436,   511,  3697,  3698,    92,
   -4436, -4436, -4436, 80364,  1491,  1066,  3728,  3200,  3984, -4436,
   -4436, -4436,  3874, -4436, -4436,  2121, -4436, -4436, -4436,  2561,
    4005, -4436, 55566, -4436,102327, -4436, -4436, -4436,  2472, -4436,
    2472,  3891, 51635,  2472,  2472, -4436, 56540,  4102,  4102, -4436,
    2009,  2009, -4436, -4436, -4436, 80364, -4436, -4436,  8060,  3892,
   -4436,  3686,  3917,  3961, -4436,  3706, 80364,  3861,  3709,  3714,
    1012,  1012,  3476, 80364,  2522,  1696,   176, 63840,  3476, -4436,
    1556,  3716,  4004, -4436,  4111,  3400,  3717, -4436, -4436, 65784,
    3898,  3622, 80364,  3564,  3835, -4436,  3839, -4436,  1038, -4436,
   80364, 40790, -4436, 60436, -4436,  2544, -4436, -4436,  3299, 80364,
     827, -4436,  3738, -4436, -4436, -4436, -4436, -4436, -4436,   181,
   -4436, -4436, -4436, -4436,  1267, 36324, 59949,  2549, 34812, -4436,
   34812, -4436,  4109, -4436, -4436, -4436,   601, -4436, -4436, -4436,
    1195,  1195,  2291, -4436, 80364,  2582, -4436, 34812,  3729, -4436,
   -4436, 39810,  1296,  2611, 80364,  2627, 59949,  3427,  3221, 11817,
   80364, -4436, -4436, -4436,  4113,  3912,  3427, -4436, -4436, -4436,
   -4436, -4436, -4436,  1419,  1173,   181,  3967,  3686, -4436,  3735,
   -4436, -4436, 80364, -4436,   253,   253, 80364,  3686, -4436, -4436,
   80364, -4436, 55566,  3793, -4436, 80364, 59949,  2347,   161, -4436,
   59949, 59949, -4436, -4436, 80364, 80364, 80364, 80364, 80364,   396,
   -4436,  3348,  2472, -4436, -4436,  2653, -4436, -4436, -4436, 80364,
   -4436,  3536, -4436, -4436,  4102,   909, -4436, -4436, -4436,  1749,
    3935, -4436,   772,  3924,  3826,  3744, -4436, 56540,  4173,  3859,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  4040,
    3210,  3684, -4436, -4436, -4436, -4436, 34812,  3902,  1696,  2179,
    3789, -4436, -4436, -4436,  2665,  3622, -4436, -4436,  4123,  3932,
    4125, -4436,  2669, -4436, -4436,  7099, 61410,  4070, -4436,  3805,
   80364, -4436, -4436,  2400,  4182, -4436,  1267,  2672, -4436,  2710,
    2713,  3905,  3807, -4436,  2714, -4436, 11817, 80364, -4436, -4436,
   -4436,  2723, -4436,  3763, -4436,  4168, 34812,  1051, -4436, -4436,
    4049, -4436, 79878,  3808, 48676, -4436,  2170,  2170,  2010, -4436,
    1725, -4436, -4436, 34812, -4436, -4436,  2727, -4436,   823,  3914,
    4057,  2730,  2734,  3203,  3810,  3203, -4436,  3200, -4436, -4436,
   -4436, -4436,102327,  3536, -4436, -4436, -4436,  4083,  4029, -4436,
   -4436, -4436, -4436,   316, -4436,  3959,  3960, 80364, -4436,  3779,
   -4436,  2737, 80364, 80364,  4180,  4183, -4436,  8590, 56540, -4436,
    3564,  2179,  1970, -4436, -4436,  3963, -4436,  3966,  3210, 40790,
    3529, -4436,  1077, -4436, -4436, -4436, -4436, -4436, 80364, -4436,
   -4436, -4436, -4436, -4436, -4436,  2740, -4436, 80364,  3782,  3221,
   33804, 33804,  3788,106513,   253,  3790, -4436,  3791, -4436, -4436,
    3917,  1725, 11817, 56540,  4174, -4436, -4436, -4436,  3914, -4436,
   -4436, 80364, -4436,  3918, -4436,   329,   329,  4116, -4436,  3850,
   -4436, -4436,  3796, -4436,  4220,  3476, -4436,   511,  1696, -4436,
    3802,  3622,  3564, -4436, -4436,  3622, -4436, -4436, -4436, -4436,
    2255, -4436, -4436, -4436, -4436, 36828,  3921,  1308,  9862, -4436,
   -4436, -4436, -4436,   181,  2170, 34812,  1725, -4436,  3924,  2347,
   80364, -4436, -4436,  3683, -4436,  4217, -4436,   179, -4436, -4436,
   -4436, -4436, -4436,  3614, -4436, 55079, -4436,  3622,  3299, -4436,
    2128, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  4207, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436,  8605, -4436, -4436, -4436,
    4103, -4436, -4436, -4436,  2755, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436,  1364, -4436, -4436,  1660,  2203, 34308, -4436,  1725,
    3956, -4436, 55079, -4436,  2128, -4436, 56540, -4436, -4436,  3809,
   55079,  2760, -4436
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2320,     0,     2,     1,  2750,  2754,  2758,  2759,  2676,  2760,
    2761,  2726,  2727,  2728,  2729,  2730,  2731,  2732,  2733,  2734,
    2735,  2736,  2737,  2739,  2738,  2740,  2741,  2742,  2743,  2744,
    2745,  2746,  2747,  2749,  2748,  2698,  2327,  2695,  2692,  2693,
    2694,  2699,  2697,  2690,  2691,  1921,  2763,  2751,  2764,  2752,
    2753,  2755,  2756,  2725,  2757,  2765,  2766,  2767,  2762,  2770,
    2721,  2722,  2720,  2723,  2724,  2768,  2769,  2712,  2713,  2714,
    2715,  2771,  2328,  2329,  2717,  2321,  2325,  2387,  2458,  2718,
    2719,  2716,  2326,  2711,  2458,     0,  2579,  2580,  2581,     0,
    2582,  2583,  2584,  2510,  2472,  2585,     0,     0,  2586,  2587,
    2588,  2589,  2590,  2591,  2592,  2593,     0,  2594,  2595,  2596,
    2597,  2457,  2598,  2599,  2600,  2601,  2602,  2434,  2440,  2563,
       0,  2414,  2415,  2411,  2413,  2412,  2416,  2399,  1198,   546,
    1284,  1283,     0,  2222,  1198,  2178,  2179,  2223,  2180,  2181,
    2182,   257,     0,  1286,  2183,  2224,     0,  1198,  2225,   370,
     967,  2226,  2227,  2342,     0,  2184,  2185,     0,     0,     0,
     546,  1198,     0,     0,  2186,  1398,  2187,     0,  2188,  2228,
    2229,     0,  2189,  2230,  2231,  2190,  2191,  2192,  2232,  2233,
    2234,  2193,  2235,  2236,     0,     0,  1412,     0,  2194,  2237,
    2195,  2196,     0,  2238,  2197,  2198,  2199,  2239,  2240,  2241,
    2200,  2201,  2202,     0,  2203,     0,     0,     0,     0,     0,
       0,  2242,  1198,  2204,     0,     0,  1419,     0,  2205,     0,
    2243,  2206,     0,  2207,     0,  2208,  2209,  2210,  2211,  1412,
    2559,  2435,     0,  1288,     0,  2212,  2244,     0,  2213,  2214,
    2215,  2216,  2217,  2218,  2219,  2220,  2221,     0,     0,    57,
      58,    22,    21,    27,    26,    80,    81,    45,    15,    71,
      51,   114,   113,   115,    33,    29,    65,    19,    20,    30,
      34,    53,    46,    92,    52,    18,    50,    75,    54,    78,
      40,     9,    10,    41,    69,    11,    42,    70,    12,    43,
      13,    59,    82,    25,    55,    79,    56,     3,    36,    67,
      63,     8,    47,    48,    49,    72,    73,    74,    97,    77,
     109,    32,   106,    86,    87,   103,    88,   104,     6,    89,
      44,    14,   100,    99,   101,    66,    37,    68,    98,   102,
      16,    17,   105,    76,    95,    91,   110,   108,   116,    93,
      60,     4,     5,    83,    39,     7,    24,    23,    38,    31,
     112,    28,  1286,    85,    96,    84,    90,    64,    94,   111,
      62,   107,  1385,  1372,  1421,  1384,  1397,     0,  1387,  2655,
    2656,    35,  1398,   118,   119,   124,  2324,  2376,  2377,  2378,
    2458,  2409,  2410,  2403,  2419,  2429,  2418,  2422,  2430,  2417,
    2436,     0,   121,   123,   125,   128,   122,   117,   120,   127,
     132,   126,   131,   129,   130,   133,   134,   135,  2657,  1604,
    2654,    61,  2394,  2393,     0,  2458,     0,  2687,  1933,  1934,
    1935,  1936,  1937,  1938,  1939,  1940,  1941,  1942,  1943,  1944,
    1945,  1946,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,
    1955,  1956,  1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,
    1965,  1966,  1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,
    1975,  1976,  1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,
    1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,
    2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,
    2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,
    2035,  2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,
    2045,  2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,
    2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,
    2065,  2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,
    2075,  2076,  2077,  2078,  2079,  2080,  2081,  2084,  2082,  2083,
    2085,  2086,  2087,  2088,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  2096,  2097,  2098,  2099,  2100,  2101,  2102,  2103,  2104,
    2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,  2114,
    2115,  2116,  2117,  2118,  2119,  2120,  2121,  2122,  2123,  2124,
    2125,  2126,  2127,  2128,  2129,  2130,  2131,  2132,  2133,  2134,
    2135,  2136,  2137,  2138,  2139,  2140,  2141,  2142,  2143,  2144,
    2145,  2146,  2342,  2147,  2148,  2149,  2150,  2151,  2152,  2153,
    2154,  2155,  2156,  2157,  2158,  2159,  2160,  2161,  2162,  2163,
    2164,  2165,  2166,  2167,  2168,  2169,  2170,  2171,  2172,  2173,
    2174,  2175,  2176,  2177,  2360,  1922,  1930,  1931,  1932,  2335,
    2356,  2362,  2683,  2361,  1929,  2509,     0,     0,  2603,  2604,
    2605,  2606,  2607,  2608,  2658,  2659,  2660,  2661,  2662,  2664,
    2663,  2471,  2630,  2667,  2470,  2668,  2474,  2669,  2670,  2671,
    2672,  2631,  2673,  2473,  2665,  2627,  2475,  2468,  2469,  2628,
    2577,  2578,  1899,  2629,  2626,  2666,  2363,  2625,  2479,  2478,
    1362,  2682,  1898,  1363,     0,  2481,  2609,  2610,  2611,  2612,
    2614,  2613,  2615,  2245,  2246,  2247,  2248,  2249,  2250,  2251,
    2252,  2253,  2254,  2255,  2256,  2640,  2257,  2258,  2259,  2653,
    2260,  2261,  2641,  2262,  2263,  2264,  2265,  2266,  2267,  2268,
    2269,  2270,  2271,  2272,  2273,  2274,  2275,  2276,  2277,  2278,
    2279,  2280,  2281,  2282,  2283,  2284,  2285,  2642,  2643,  2286,
    2287,  2288,  2289,  2290,  2291,  2292,  2293,  2294,  2295,  2296,
    2297,  2298,  2299,  2300,  2301,  2302,  2303,  2304,  2305,  2306,
    2307,  2308,  2309,  2644,  2310,  2311,  2645,  2312,  2313,  2314,
    2646,  2315,  2316,  2317,  2318,  2319,  2650,  2651,  2652,  2639,
    2432,  2616,  2638,  2649,  2647,  2648,  2442,  2438,  2446,  2441,
       0,     0,     0,     0,  2458,  1197,  1196,  1182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   545,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2332,     0,  1208,
     342,   341,  1285,  1266,   546,     0,  1185,   369,     0,     0,
       0,     0,     0,     0,     0,     0,   737,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   183,     0,     0,
     393,   392,     0,     0,     0,   939,   398,     0,     0,     0,
       0,     0,   534,  2341,  2336,  2346,     0,  2339,  2340,  2625,
       0,  2774,  2082,  2372,  2373,  2772,  2132,  1364,   258,   261,
     259,   260,     0,  1039,  1040,  1042,     0,     0,  1052,   772,
     773,     0,   771,     0,   775,     0,     0,     0,   767,     0,
       0,     0,     0,     0,   774,   764,     0,   763,     0,     0,
       0,   770,     0,   765,     0,     0,  1186,     0,  2424,  2425,
    2022,  1325,   399,     0,     0,  1398,     0,  1303,  1304,  1286,
    1293,  1305,  1298,  1300,  1299,  1301,  1297,  1302,  1934,   878,
    1948,   878,  2012,   875,   876,   878,   878,   878,  2099,     0,
       0,   850,     0,   861,  1925,   878,  1926,  2683,   883,   454,
     454,   454,     0,   882,   887,   454,  1179,  1217,  1903,  1411,
       0,  1948,  2012,   851,  1178,  2147,  1317,     0,     0,     0,
    1056,     0,  1057,     0,  2114,  1190,   242,  2623,  2123,  2208,
    2147,  2624,   238,  2618,  2619,  2621,   212,  2622,  2620,  2617,
    1938,     0,     0,   882,     0,  1187,  1188,   834,  1418,  1416,
       0,     0,     0,  1956,     0,  1968,  2048,   235,  2110,  2115,
    2123,  2208,  2147,  2175,   192,   197,     0,   251,  2123,  2208,
    2147,     0,  1208,     0,  1388,  1504,  1894,     0,     0,  2433,
    1181,  1180,  1287,     0,  1290,     0,  1466,  2095,  1392,  1394,
    1292,  1385,     0,     0,  2323,  1281,  1415,  1415,     0,  1415,
       0,  1377,  1385,  1380,  1384,     0,     0,     0,     0,  1198,
       0,  2401,  2429,  2408,  2464,  2405,     0,     0,  2454,  2450,
    2447,  2455,  2456,  2449,  2437,  1593,  1594,  1595,  1592,  1605,
    1591,     0,  2382,  1596,  2421,  2388,     0,  2396,  2395,  2700,
    2701,  2511,  2334,  2353,     0,     0,     0,     0,     0,     0,
       0,  2480,  2482,  2484,  2444,  2443,  2439,     0,     0,     0,
       0,  2569,  2570,  2568,     0,  2565,  2567,     0,  2464,     0,
    2634,  2628,  2637,     0,  1904,  2629,  2626,  2625,     0,   782,
       0,   139,   927,     0,     0,     0,     0,  1898,     0,     0,
       0,     0,     0,  2021,     0,     0,     0,  1799,  1960,  2008,
    1809,  1807,  1808,  1801,  1802,  1803,  1804,  1805,  1806,     0,
    1037,  1800,     0,   161,   139,     0,     0,  2021,     0,     0,
    2021,     0,     0,     0,     0,     0,   161,  2051,   139,  2021,
       0,     0,     0,  1202,     0,     0,     0,  1204,  1207,  1183,
    1269,     0,  1894,     0,     0,   813,   803,     0,   814,   804,
     809,     0,   816,     0,     0,   806,     0,     0,     0,   817,
       0,   805,   807,   819,   808,   815,     0,     0,   810,   811,
       0,     0,  1194,   454,   348,     0,     0,     0,     0,     0,
     139,  1256,     0,  2021,   139,     0,     0,   397,   396,   139,
     395,   394,  1960,  2008,     0,   966,   139,  2021,     0,   185,
     616,   549,     0,     0,   694,  2051,   139,     0,     0,     0,
       0,     0,     0,   942,     0,     0,   533,   546,     0,  2345,
    2351,     0,  2343,  2512,  2775,  2773,  2467,     0,  1043,   236,
     237,  1041,  2021,     0,   320,     0,     0,  2021,  1245,   769,
       0,   768,  2021,     0,  2021,  1923,   176,     0,   766,  1960,
    2008,  2021,     0,     0,  2021,   168,  2021,     0,  2021,   320,
    2021,   550,     0,  2021,     0,  2021,  2051,   170,     0,  2021,
     320,   780,     0,     0,  2705,  2709,     0,  2707,  2702,  2423,
    2477,  2476,  2375,     0,  2785,     0,  1364,  1295,  1310,     0,
    1306,  1313,  1309,  1398,   878,   877,     0,   878,     0,  2794,
     878,     0,   878,     0,  2794,   878,     0,     0,     0,   878,
    1927,  1928,     0,     0,  2793,  2791,  2792,   852,   862,     0,
     884,     0,     0,   891,   890,   889,     0,     0,     0,   892,
    1508,  1340,     0,   859,     0,   857,     0,  1176,  1193,     0,
       0,     0,     0,     0,  1059,  1059,  1059,  1189,   241,   239,
       0,     0,     0,     0,     0,     0,  1195,     0,     0,     0,
       0,  2689,  1910,  1810,  2688,     0,  2179,  2180,  2181,  1868,
       0,  2630,  2182,  2183,  2224,  1722,  1709,  1718,  1723,  1710,
    1712,  1719,  2184,  2185,  1992,  2186,  2187,  1917,  2188,  2189,
    1548,  2191,  2192,  2193,  1714,  1716,  2194,  2195,     0,  1918,
    2197,  2198,  2070,  2200,  2201,  2203,  2204,  1720,  2206,  2207,
    2208,  2209,  2210,  2211,  1916,     0,  1721,  2212,  2214,  2215,
    2216,  2217,  2218,  2219,  2220,  2221,     0,     0,  1891,     0,
    1694,     0,  1540,  1541,  1563,  1564,  1542,  1569,  1570,  1582,
    1543,     0,  1890,  1607,  1693,  1699,     0,  1692,  1688,  1401,
    1886,     0,  1689,  1906,  1869,  1920,  1919,  2683,  1877,  1909,
    1907,  1908,     0,     0,     0,   204,     0,     0,  2558,   253,
       0,   254,  1892,  2123,   193,   234,   206,   233,   207,   205,
       0,  1958,   194,     0,     0,   195,     0,     0,     0,     0,
       0,     0,     0,   247,  1184,     0,  1506,  1505,     0,     0,
    1875,  1895,   789,     0,  1279,  1280,  1278,     0,  1275,  1277,
    1289,  1286,  1882,  1881,  1883,     0,  1393,     0,     0,     0,
    1375,  1374,  1292,  1413,  1414,     0,     0,     0,     0,     0,
       0,     0,     0,  1456,  1429,  1430,  1432,  1453,  1457,  1465,
       0,  1381,     0,     0,  1510,     0,  1467,  2322,  2464,  2465,
       0,  2459,     0,  2458,  2458,  2452,  2451,  2448,     0,     0,
       0,     0,     0,     0,     0,     0,  2379,   528,  2381,   525,
       0,     0,  2355,     0,  2359,  2357,     0,  2504,  2507,     0,
    2505,  2506,  2508,     0,  2513,  2514,     0,     0,     0,  2696,
       0,     0,  2495,  2483,  2490,  2492,  2494,  2493,  2502,  2498,
    2501,  2503,  2445,  2458,  2576,     0,  2571,  2574,     0,  2566,
       0,     0,     0,  1905,     0,     0,     0,     0,   783,     0,
       0,     0,     0,     0,     0,   138,  1243,   244,  1241,     0,
       0,     0,     0,     0,     0,     0,  1248,     0,     0,   174,
     175,   561,   546,     0,  2021,     0,     0,     0,     0,   999,
    1006,     0,     0,     0,     0,     0,     0,     0,  1000,   998,
    1001,   246,  1010,  1023,  1026,     0,   917,     0,     0,     0,
       0,  1108,     0,     0,  1108,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   264,   272,   315,     0,
    2021,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     143,     0,     0,     0,     0,     0,     0,   512,   524,     0,
       0,     0,     0,     0,   521,     0,   139,   266,   505,   509,
       0,     0,     0,   625,   624,     0,  1108,     0,   262,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   334,   335,     0,     0,     0,   143,
       0,     0,     0,     0,   268,     0,  2389,     0,  1203,  1200,
    1201,     0,  1206,     0,  1265,     0,     0,     0,     0,   821,
       0,   818,     0,     0,   812,  1960,  2008,     0,     0,     0,
       0,     0,     0,   372,   347,     0,     0,     0,   691,     0,
    1551,  1580,  1558,  1580,  1580,  1547,  1547,  1560,  1549,  1587,
       0,  1580,  1547,  1552,     0,  1550,  1590,  1590,  1575,     0,
    1532,  1533,  1534,  1535,  1561,  1562,  1536,  1567,  1568,  1537,
    1604,  2635,  1547,  2636,  2633,  2632,     0,     0,   702,     0,
    1220,  1255,     0,     0,     0,   555,     0,  2021,     0,   141,
     738,     0,   692,   398,     0,   141,     0,     0,   179,     0,
     620,     0,     0,     0,     0,     0,     0,   640,   639,     0,
       0,     0,   693,     0,   141,     0,   508,  2021,     0,   454,
     454,     0,     0,   941,   944,     0,     0,     0,  2349,  2344,
    2347,     0,  2337,  2351,  1367,  1369,  1368,     0,  1366,     0,
     320,   318,   319,   689,  1051,     0,     0,     0,     0,   320,
       0,     0,  2021,   320,  2021,     0,  2021,     0,     0,   320,
     320,     0,     0,     0,     0,   621,     0,   779,   777,   776,
     778,     0,     0,     0,     0,     0,  2021,   320,     0,     0,
     760,  2703,     0,     0,  2706,     0,  2426,  1820,     0,  2788,
    1322,  2789,     0,     0,  1398,     0,   223,   224,   222,  1311,
     225,  1312,  1308,  1294,     0,   870,     0,  2794,  2795,   855,
       0,   865,     0,  2794,   853,     0,   866,   863,   864,     0,
       0,     0,  2790,  2674,  2680,   869,     0,     0,   455,   457,
       0,     0,  1978,  1991,     0,  2013,  2039,  2040,  2115,  2119,
       0,  2142,  2151,     0,   893,   922,   888,     0,     0,  1350,
     860,   858,  1177,  1315,  1826,     0,  1398,     0,   498,  1058,
    1055,  1054,  1053,   240,   213,     0,     0,     0,   924,  2114,
    1192,   833,   546,     0,     0,  1697,  1698,  1579,  1566,  1867,
       0,     0,  1574,  1573,     0,     0,     0,     0,     0,  1556,
    1555,  1554,  1696,  1834,     0,  1553,     0,     0,     0,     0,
    1580,  1580,  1578,  1627,     0,  1557,     0,     0,  1847,     0,
    1853,     0,     0,     0,  1586,     0,  1584,     0,     0,  1663,
       0,     0,     0,     0,     0,     0,     0,     0,  1611,  1612,
    2631,  1694,  1820,     0,  1695,  1913,     0,     0,  1572,     0,
    1604,  1810,     0,     0,     0,     0,  1880,     0,  1818,     0,
       0,  1641,  1816,     0,  1643,     0,     0,     0,  1809,  1807,
    1808,  1801,  1802,  1803,  1804,  1805,  1806,  1814,  1624,     0,
    1889,     0,  1623,     0,     0,  1469,  1400,     0,  1911,  1870,
       0,  2681,  2684,  1690,  2555,  2554,  2553,  2552,  2523,     0,
    2517,  2518,     0,  2556,  2557,   255,   256,   252,     0,     0,
     209,   208,     0,   231,   232,   203,   230,     0,   226,   227,
     211,  1762,  1761,   210,   202,   200,   198,   214,   216,   217,
     201,   199,   250,   248,     0,     0,     0,  1872,  1871,  1901,
    1876,     0,     0,   320,  2458,  1273,     0,  1270,  1885,     0,
    1395,     0,  1896,     0,  1282,  1391,  1390,  1422,  1423,   959,
    1389,  1447,  1448,  1443,     0,     0,     0,  1462,  1460,  1439,
    1433,  1438,  1436,     0,  1440,  1607,  1455,  1379,  1427,  1428,
    1431,  1378,     0,  1458,     0,  1350,  1456,  1432,  1337,     0,
       0,  1511,     0,     0,  2466,  2464,  2404,  1532,  2458,  2397,
    2458,  2453,  2385,  1598,  1599,  1600,  1601,  1602,  1603,  2386,
       0,  2383,  1597,  2384,   526,   527,     0,     0,     0,  2352,
       0,  2333,  2358,  2489,  2598,  2521,     0,  2522,     0,     0,
    2486,     0,  2496,  2499,  2497,  2500,     0,  1532,  2677,  2572,
    2677,  1532,     0,     0,     0,     0,     0,     0,     0,     0,
     784,     0,     0,     0,     0,     0,     0,  2142,   243,  1239,
       0,     0,     0,     0,   926,   925,     0,     0,   946,     0,
       0,     0,  1251,   443,     0,   317,     0,     0,     0,     0,
       0,     0,     0,     0,   687,   684,     0,     0,   683,     0,
     559,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   595,
       0,  1108,     0,   628,     0,  1008,     0,  1007,     0,     0,
       0,  1009,  1004,  1005,  2115,  2123,  2147,   245,  1025,     0,
    1024,  1022,   981,   983,   982,     0,   985,   969,     0,   970,
       0,     0,   980,   988,   986,     0,     0,     0,     0,  2001,
     274,   287,     0,  1107,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   307,     0,   310,   309,     0,     0,
       0,     0,   314,     0,     0,     0,   313,     0,     0,     0,
       0,  1108,     0,   270,     0,     0,     0,     0,     0,     0,
    1038,     0,     0,   164,     0,   160,   163,     0,     0,     0,
       0,   511,   523,     0,   515,   516,   513,   517,   518,     0,
       0,     0,     0,     0,     0,   510,     0,     0,   618,   617,
     623,     0,     0,     0,     0,     0,     0,     0,  1100,  1099,
       0,     0,     0,     0,     0,     0,   728,     0,     0,     0,
       0,     0,     0,     0,   167,   631,   632,     0,   633,     0,
     165,   166,     0,     0,     0,     0,     0,     0,     0,   221,
    1199,  1205,  1268,  1902,  1267,     0,     0,     0,   820,     0,
       0,     0,     0,     0,     0,     0,   822,   823,   824,   825,
       0,     0,     0,     0,     0,   350,   351,   139,   349,     0,
     717,  2632,   690,     0,  1532,     0,  1528,  1524,  1593,  1592,
    1591,     0,  1538,  1547,  1544,   703,     0,   705,   708,     0,
    1218,   416,     0,     0,   552,   595,     0,   401,   172,     0,
       0,     0,     0,   137,   183,   185,   399,     0,   184,   186,
     188,   189,   190,   187,   191,   615,   619,     0,   548,     0,
       0,     0,     0,     0,   641,   645,   644,   648,   646,     0,
     642,     0,     0,  1520,     0,   159,     0,   504,   507,     0,
    2330,     0,   401,   485,   327,     0,   454,     0,     0,   943,
       0,     0,     0,     0,     0,  2350,     0,     0,     0,     0,
    1365,     0,  1029,     0,  1246,  2021,   320,     0,  1027,   177,
    1924,     0,   761,     0,     0,     0,     0,     0,  1031,   757,
     169,     0,   320,   320,   551,     0,   320,   171,     0,     0,
       0,   543,   320,   781,  2704,  2710,  2708,  1324,     0,  2786,
    2787,   454,  1369,  1296,  1307,   867,   874,   856,   873,   872,
     854,   871,   868,  2488,     0,     0,  2679,     0,   885,     0,
     453,     0,     0,     0,   899,   900,     0,     0,   898,   915,
     901,     0,   903,   895,   894,   904,   905,     0,     0,   924,
       0,  1347,     0,  1345,     0,  1509,  1349,  1338,  1316,     0,
    1314,  1319,  1321,  1320,  1318,     0,     0,   503,     0,     0,
     882,     0,     0,   320,  1191,     0,   835,   836,   842,     0,
       0,     0,     0,     0,   843,   839,   840,   841,   844,   845,
     846,     0,     0,     0,  1830,     0,  1831,     0,     0,     0,
    1866,  1862,     0,     0,     0,     0,     0,     0,  1838,  1839,
    1840,  1837,  1841,  1836,     0,     0,  1842,  1835,     0,     0,
       0,     0,     0,  1577,  1576,     0,     0,     0,     0,     0,
       0,     0,  1666,  1699,     0,     0,  1794,     0,  1820,  1852,
       0,     0,  1588,     0,     0,     0,     0,     0,     0,     0,
    1820,  1858,     0,     0,     0,     0,  1760,     0,  1757,     0,
       0,     0,     0,  1877,     0,     0,     0,     0,  1914,  1608,
    1625,  1888,     0,  1879,     0,     0,  1609,  1632,     0,  1859,
    1659,     0,  1664,  1647,     0,  1640,     0,  1645,  1649,  1628,
    1880,  1819,     0,  1817,     0,     0,  1626,     0,  1621,  1619,
    1620,  1613,  1614,  1615,  1616,  1617,  1618,  1622,  1798,  1796,
    1797,     0,     0,     0,  1644,  2015,  2048,     0,  1412,  1412,
    1412,  1399,  1410,  1887,     0,  1515,     0,     0,     0,     0,
    1777,     0,  1824,     0,  1822,  1904,  2686,  2685,  1878,     0,
       0,     0,  1893,     0,     0,  1604,     0,   249,  1507,  1873,
       0,   787,   788,   786,  1532,  1292,  1276,  1272,  1271,  1884,
    1291,     0,  1398,     0,   957,   958,     0,   962,     0,     0,
    1441,  1463,     0,  1454,     0,  1445,  1446,  1437,  1464,  1459,
    1383,  1382,     0,  1518,     0,     0,  1334,  1327,  1512,     0,
    1469,  1352,  1354,  1355,     0,  1877,  2402,  2460,  2407,  2428,
    2398,  2431,  1606,  2380,  2420,     0,  2354,  2524,  2525,     0,
    2515,  2516,  2485,  2491,  2562,     0,  2678,     0,     0,   715,
     714,     0,     0,     0,  1136,  1061,  1112,   785,  1137,  1062,
    1113,  1138,  1063,  1240,     0,  1242,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     666,  2021,   320,  1249,  1139,     0,  1064,   316,  1250,  1114,
    1254,   686,   685,     0,     0,  1115,     0,   560,     0,     0,
     565,   566,   567,     0,     0,     0,   568,     0,  1960,  2008,
       0,   573,   580,   585,   575,     0,   586,   581,     0,     0,
       0,     0,     0,     0,   592,   594,     0,     0,     0,     0,
       0,     0,  1002,  1003,  1140,  1067,     0,  1116,   984,  1547,
     968,     0,     0,   979,     0,   978,  1547,  1547,  1068,   173,
       0,   265,   275,   601,  1110,   293,   306,   301,   302,   300,
    2021,   320,  2021,   320,     0,     0,     0,     0,   303,   298,
     299,   295,   308,  1937,  1993,  2124,     0,   605,   607,     0,
     612,   311,  1082,     0,   328,   331,   312,   291,   294,   292,
     288,   273,     0,     0,     0,     0,     0,     0,  1900,     0,
       0,  1033,     0,     0,     0,   162,  1096,     0,     0,   148,
       0,     0,     0,     0,   142,   152,     0,  1146,  1072,     0,
       0,   267,   506,   514,   519,  1076,   522,  1126,   520,  1152,
    1073,  1108,     0,   263,     0,  1074,     0,  1120,  1148,  1098,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1257,
       0,     0,     0,     0,     0,   320,     0,     0,     0,  1110,
    2021,   320,  1147,     0,  1105,  1134,     0,   336,     0,  1097,
       0,     0,   269,  1078,  1128,     0,     0,   219,   218,   220,
       0,     0,     0,     0,     0,     0,     0,     0,   827,   796,
     826,     0,     0,     0,   790,   371,   345,   346,   348,   355,
     716,     0,     0,     0,  1529,  1525,     0,     0,     0,     0,
       0,     0,  1545,   704,     0,     0,     0,     0,  1238,  1238,
    1238,  1238,  1238,  1238,  1238,  1219,  1247,     0,   139,     0,
       0,     0,   554,   594,   601,     0,     0,     0,   400,   404,
     408,   409,   410,     0,     0,     0,     0,   153,   140,     0,
     746,     0,   454,     0,   185,   178,     0,     0,     0,   547,
     701,   699,   698,   700,     0,     0,     0,   721,   697,     0,
    1519,  1521,     0,     0,     0,     0,     0,   403,     0,   457,
       0,     0,   489,     0,     0,     0,   327,     0,     0,   973,
       0,   991,   974,     0,     0,     0,  1013,  1018,  1014,   994,
       0,   531,  2348,  2342,  1370,  1371,     0,   320,     0,     0,
     596,   320,   320,     0,   320,     0,   320,   320,     0,  1174,
     622,     0,   674,     0,     0,   320,   759,  1821,     0,  2487,
    2675,   886,   456,     0,     0,     0,     0,   897,     0,   529,
     902,     0,   914,   909,   911,     0,   918,  1348,  1341,  1343,
    1342,     0,     0,  1339,  1827,   758,   496,     0,     0,     0,
     320,     0,   919,     0,   837,   838,     0,     0,   847,     0,
       0,  1417,  1828,  1829,     0,     0,     0,     0,  1863,     0,
       0,  1735,     0,  1711,  1713,  1546,  1725,     0,  1559,  1736,
    1737,  1715,  1717,     0,  1811,     0,     0,  1726,  1668,  1669,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1681,  1680,  1727,  1793,     0,     0,  1850,
    1851,  1728,  1589,  1590,  1590,     0,     0,  1857,     0,     0,
       0,  1733,  1738,     0,     0,     0,     0,  1744,     0,  1765,
       0,     0,     0,  1691,  1821,  1581,  1582,     0,     0,     0,
       0,     0,     0,     0,     0,  1665,  1648,  1642,     0,  1646,
    1650,     0,     0,     0,     0,  1634,  1660,  1630,     0,     0,
    1636,     0,  1661,  1412,  1412,  1412,  1412,  1409,     0,     0,
       0,     0,     0,  1490,  1468,  1470,  1477,  1490,  1495,  1513,
       0,  1894,     0,  1450,  1421,  1421,     0,  1777,     0,  1700,
       0,  1777,     0,     0,  2537,  2539,  2540,  2541,  2542,  2543,
    2545,  2546,  2548,  2549,  2550,  2538,  2544,  2547,  2551,  2528,
    2529,     0,  2519,  2520,   196,     0,   228,   215,     0,  2562,
    1274,  1897,     0,  1424,     0,  1812,   962,   960,   961,  1426,
       0,     0,  1461,  1434,  1336,     0,  1334,  1329,     0,  1330,
    1877,     0,  1326,  1359,     0,     0,  1518,     0,  1358,     0,
    2462,  2390,     0,     0,  2561,  2564,  2575,  2573,  2400,  1135,
    1060,  1111,  1238,   929,   930,     0,   928,     0,     0,     0,
     442,   945,     0,     0,     0,   666,     0,     0,   446,     0,
    1252,     0,  1153,  1095,   562,   563,     0,   574,     0,   583,
     582,     0,     0,   570,     0,     0,     0,     0,   569,   588,
     535,   589,   591,     0,     0,   590,   593,   598,  1108,     0,
     629,  1084,     0,  1132,   996,     0,  1547,   971,   976,   977,
       0,     0,     0,   416,     0,     0,     0,   276,   286,     0,
       0,   290,     0,   284,   304,   296,   305,   297,   609,   610,
     608,   604,     0,   611,   613,   325,     0,     0,     0,  1142,
    1108,     0,   271,  1080,     0,  1130,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1143,  1117,     0,
       0,   145,   144,     0,   151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   337,   322,
       0,   724,     0,     0,     0,   339,     0,     0,     0,     0,
    1141,  1069,   791,     0,     0,   792,   800,     0,     0,   793,
       0,     0,   802,     0,     0,   344,   352,   718,     0,  2070,
    1801,  1802,   712,   719,   709,   711,   710,   713,   666,     0,
       0,     0,  1530,     0,  2776,  2784,  2783,     0,  1604,   706,
     707,     0,  1238,  1237,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   428,     0,     0,   422,     0,
       0,  1018,   415,   418,   419,     0,     0,   555,   558,   556,
     557,   587,     0,   435,     0,     0,   155,     0,     0,   156,
     154,     0,     0,   327,     0,   181,   399,     0,     0,   647,
     650,   643,     0,   720,   722,   695,     0,   601,     0,     0,
    1325,   498,     0,   485,   481,   483,   482,   484,     0,   491,
     326,     0,   498,   491,     0,   946,   972,     0,     0,     0,
    1011,  1015,  1012,     0,     0,   987,     0,   995,   965,  1169,
    1170,  1167,  1168,     0,     0,  2365,  1361,  2374,  1030,     0,
     320,  1028,   762,     0,   753,     0,   755,  1032,   320,   320,
     634,     0,   544,     0,     0,     0,     0,   896,   916,     0,
     912,     0,     0,   879,   921,  1346,  1344,   497,   924,     0,
     880,   923,     0,     0,     0,     0,     0,  1832,  1565,     0,
    1865,  1861,     0,  1708,  1833,     0,  1845,  1844,  1667,  1846,
       0,  1686,     0,     0,  1678,  1676,  1677,  1670,  1671,  1672,
    1673,  1674,  1675,  1679,  1855,  1854,  1848,  1849,  1585,  1583,
       0,  1730,  1731,  1732,  1856,  1739,     0,  1951,  1766,  1743,
    1759,  1758,     0,     0,     0,  1746,     0,     0,  1755,     0,
    1795,  1571,  1604,  1610,     0,     0,  1633,  1860,  1651,     0,
       0,     0,  1629,     0,     0,     0,     0,  1638,  1811,     0,
       0,     0,     0,     0,     0,  1403,  1402,  1408,  1490,  1495,
    1385,     0,  1477,     0,  1489,  1475,  1488,     0,     0,  1501,
    1499,     0,  1501,     0,  1501,     0,  1472,     0,  1491,  1473,
    1488,     0,  1895,  1514,     0,  1452,     0,     0,  1420,     0,
    1777,  1707,  1780,  1775,  1776,  1825,  1701,  1912,     0,  1823,
    1777,     0,     0,     0,  1874,  2560,  1396,     0,  1425,  1442,
    1435,     0,  1516,  1335,     0,     0,  1332,     0,     0,     0,
    1353,  1334,  1356,  2406,     0,  2461,  2526,  2527,     0,   935,
     936,   934,   937,     0,     0,     0,   666,     0,     0,   462,
       0,   953,   953,     0,     0,   448,   494,  1018,   669,     0,
       0,     0,   667,   320,  1065,     0,   584,     0,     0,   579,
     577,   576,   578,   536,  1151,  1066,     0,     0,     0,     0,
     997,     0,   989,  1083,     0,   413,     0,   281,  1109,     0,
       0,     0,   280,     0,   320,   320,   606,   329,   330,   333,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     747,   730,     0,     0,   748,   749,     0,     0,     0,  1035,
    1036,  1034,   149,   146,   147,   150,  1093,  1077,  1127,  1075,
       0,  1121,  1090,  1086,     0,     0,     0,     0,     0,  1150,
    1104,  1125,  1149,  1102,  1123,  1101,  1122,  1103,  1124,  1094,
       0,  1523,   727,     0,     0,     0,   320,   320,   636,  1079,
    1129,     0,   794,     0,     0,   795,   797,   374,     0,   377,
     384,   356,   361,  1256,     0,  1256,     0,   358,   362,  1256,
     357,  1256,   354,   688,     0,     0,     0,  1526,     0,     0,
       0,     0,     0,     0,  1531,  1539,   665,     0,  1229,  1228,
    1227,  1231,  1230,  1233,  1232,  1224,  1223,  1236,  1235,  1222,
    1221,  1226,  1225,     0,   420,     0,   426,   430,   431,   429,
     421,  1018,   454,   493,     0,     0,   678,     0,   553,   401,
     432,     0,   405,   158,   157,     0,     0,     0,   185,     0,
       0,   652,   656,   696,     0,  1522,   630,   327,     0,   401,
     498,  2331,     0,   406,   411,   412,     0,   489,     0,   485,
       0,     0,   495,  1216,   499,   500,     0,     0,   975,   992,
     993,     0,     0,  1018,  1017,     0,   538,     0,  2338,   320,
     597,   320,   320,  1175,   675,     0,   908,   907,   906,   530,
       0,   910,   320,     0,     0,     0,     0,     0,   849,   828,
     848,  1864,  1724,  1734,  1843,     0,     0,  1687,     0,     0,
    1729,  2213,     0,     0,     0,     0,  1763,  1764,  1745,     0,
    2061,  1750,     0,     0,     0,  1915,  1657,  1655,  1652,     0,
    1653,     0,     0,  1635,  1631,     0,  1637,  1662,  1407,  1406,
    1405,  1404,  1476,  1474,  1479,  1486,     0,  1471,     0,  1500,
    1496,     0,  1497,     0,     0,  1498,     0,     0,  1486,     0,
       0,     0,     0,  1771,  1777,  1777,  1702,  1782,  1779,     0,
    1704,  2530,     0,  2533,  2531,  2532,  2536,  1604,     0,     0,
    1328,  1331,  1333,     0,  1360,  1351,  2463,  1244,     0,     0,
       0,   444,     0,  1018,     0,     0,     0,   956,   956,     0,
    1018,   493,   671,   670,   673,   668,   672,  1253,     0,   571,
     572,  1085,     0,  1133,  1091,   990,     0,   602,   277,   278,
     279,   282,   322,   289,   283,     0,  1081,     0,  1131,  1088,
    1144,  1070,  1118,     0,     0,   736,     0,     0,     0,     0,
    1145,  1071,  1119,     0,     0,     0,     0,  1262,     0,   321,
     726,   725,   322,   338,  1106,     0,   798,   799,   375,   139,
       0,   353,     0,   382,     0,   380,   379,   381,     0,   368,
       0,     0,     0,     0,     0,  1527,     0,  1049,  1049,  2777,
    2778,  2779,  2780,  2781,  2782,     0,   666,  1234,     0,     0,
     417,   493,   461,     0,   423,     0,     0,     0,     0,     0,
       0,     0,   601,     0,     0,     0,   180,   401,   601,   651,
       0,     0,     0,   723,     0,   403,     0,  1323,   402,     0,
       0,   491,     0,   489,     0,   486,     0,   490,     0,  1209,
       0,     0,  1016,     0,  1020,     0,   986,   963,  1515,     0,
     542,  2364,  2368,  1050,   754,   756,   635,   913,   920,   320,
     829,   830,   831,   832,  1682,     0,     0,     0,     0,  1740,
       0,  1741,  1768,  1767,  1747,  1751,     0,  1748,  1749,  1654,
    1658,  1656,  1639,  1478,     0,     0,  1480,     0,     0,  1482,
    1484,     0,     0,     0,     0,     0,  1898,  1777,  1449,  1451,
       0,  1386,  1705,  1706,     0,  1421,  1777,  2535,  2534,   229,
    1813,  1517,  1357,   914,     0,   320,   953,   493,   463,  2070,
     464,   952,     0,   954,   959,   959,     0,   493,   666,   564,
       0,   600,     0,   324,   332,     0,     0,     0,   743,   731,
       0,     0,   750,  1087,     0,     0,     0,     0,     0,   320,
     801,   355,     0,   378,   387,     0,   385,   359,   364,     0,
     366,   365,   360,   363,  1049,     0,  1046,  1045,   664,     0,
     452,   424,     0,   472,     0,     0,   679,     0,     0,     0,
     441,   440,   437,   436,   438,   439,   434,   433,   626,   740,
     327,  1216,   614,   653,   654,   649,     0,     0,     0,   485,
     481,   407,   416,   390,     0,   491,   487,   488,     0,     0,
       0,  1264,     0,   947,  1019,     0,     0,     0,   537,     0,
       0,   541,   532,     0,  2366,   881,  1683,     0,  1684,     0,
       0,     0,  1753,  1752,     0,  1487,  1503,     0,  1483,  1481,
    1492,     0,  1494,  1770,  1772,     0,     0,  1785,  1703,   931,
       0,   932,   956,   467,     0,   955,   962,   962,   454,   666,
     445,  1092,   603,     0,   285,  1089,     0,   734,     0,   745,
     743,     0,     0,  1258,     0,  1259,  1260,  1263,   340,   343,
     373,   383,     0,   367,  1044,  1048,  1047,     0,     0,   425,
     458,   459,   460,     0,   427,   468,   469,     0,   676,     0,
     681,     0,     0,     0,     0,     0,  1210,     0,     0,  1211,
     489,   485,   414,   480,   388,     0,  1213,     0,   327,     0,
    1018,  1021,  1173,   540,   539,  2369,  2371,  2370,     0,  1685,
    1756,  1742,  1769,  1754,  1485,     0,  1493,     0,     0,  1781,
       0,     0,     0,     0,   959,     0,   666,     0,   950,   949,
     461,   447,   323,     0,     0,   741,   744,   732,   745,   752,
     751,     0,   386,     0,   451,     0,     0,     0,   470,     0,
     471,   492,     0,   680,     0,   601,   739,     0,     0,   655,
       0,   491,   489,  1214,  1215,   491,   948,   964,  1172,  1171,
    1398,  2367,  1502,  1773,  1774,  2178,     0,  2153,     0,  1783,
    1786,  1784,  1778,   320,   962,     0,   449,   465,   472,     0,
       0,   733,  1261,   656,   477,     0,   476,     0,   474,   473,
     677,   682,   627,   729,  1212,   659,   391,   491,  1515,  1155,
    1398,  1154,  1156,  1164,  1161,  1163,  1162,  1160,     0,  1790,
    1789,  1788,  1792,  1791,   933,   951,     0,   666,   735,   742,
       0,   475,   479,   478,     0,   657,   660,   663,   661,   662,
     389,   938,     0,  1165,  1159,  1385,  1372,     0,   466,   450,
       0,   637,     0,  1157,  1398,  1787,     0,   658,  1158,     0,
     659,     0,   638
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4436, -4436,  3944, -4436, -1181,   205,  2464, -1222, -4436, -4436,
   -4436,  1220, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  3116,
   -4436, -4436,  1645, -2584, -4436, -4436,   -61, -1604,   182,  2725,
    1314, -4436, -1357, -4436, -4436,  -852,    21,   330, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436, -1168,  1794,  1141,   -56,
   -4180, -4436, -1739, -3312, -4436,   541, -4436, -4436,  1735, -4436,
   -4436, -4436,  1001,   467,  -449, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436,  -269, -4436, -4436,  -578,   202,  -125, -2583,  -320,
   -4436, -4436,   411,  -322, -1621, -4436, -3617, -4436,   -17, -4436,
   -4436, -4436,  -302, -1702,  1238, -4436,  -999, -1407,  1554,  -638,
   -4436,  -190, -4436,  -693,  -580,  -577,  -649,  -481, -3800, -4223,
   -3808, -3427,  1243, -4436, -3728,   255, -4436, -4436,   257,   259,
   -4436, -4436, -1799, -1723, -4436, -1110, -4436, -4436, -4436, -3061,
   -4436, -4436, -4436, -4436,   -94, -4436, -4436, -4436, -4436,   435,
   -4436, -4436, -4436, -4436, -4436, -4436, -2680,  1688,  1689, -4436,
   -4436, -3263, -4436, -1209, -4436,   573, -3086,  1152, -4436, -4436,
   -4436,  2397, -4436, -4436, -4436, -4436, -4436, -4436, -1880, -4436,
   -4436,   287, -4436,  1699,   963, -4436, -4436, -4436,  -683,  -749,
    -738, -4436, -3589, -4436, -4436, -4436, -4436,  -263, -4436, -4436,
   -4436, -4436, -4436, -4436, -1231, -4436,  1030, -3206, -1236, -4436,
   -4436,  1044, -4436, -4436, -4436, -4436, -4436,  -629,  -197,  2430,
   -4436,  -519,  -606, -4436, -4436, -4436,  -195, -4436, -4436, -4436,
   -4436, -4436, -4436, -1334, 11954, -1834, -4436, -4436, -4436, -4436,
   -2570, -4436, -4436, -4436, -1651, -4436,  4198,    25,   152,   291,
   -4436,  -183,  -110,  2952, -1411, -2781,   377,  -355, -4436, -2049,
   -4436, -4436, -4436, -2673, -4436, -4436, -4436, -4436, -3560,   314,
   -4436, -4436, -4436,   426, -4436, -4238, -4026, -4307, -3779, -3543,
   -4436, -4436, -1339, -4436, -4436, -4436, -1667,  1901, -1754, -4436,
   -2435,   427, -3824, -1019, -3331, -4436, -3749,  -453, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -1347,  -885, -4436, -4436,  3478,
   -4436, -3448, -4436, -4436, -4436, -4436,  1282, -4436, -1698,  1107,
   -4436, -4436, -4436, -4436, -4436,  -623,  -704, -4436, -4436, -4436,
     317, -4436, -4436, -4436, -4436,  1982, -1214, -1002,  3319,   325,
    -419, -4436, -4436, -4436, -4436, -3104, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -1690, -4436, -4436, -4436, -4436, -4436, -4436,
   -4436,  2107,  2108,  -113,  -215, -4436, -4436, -1512, -4436,  -830,
   -4436,  2349, -4436, -4436, -4436, -4436,  1384,   326,   458,   -74,
   -4436, -4436,   244, -3489,   -72, -4436, -4436, -4436, -4436,  2078,
     -70, -4436,   729, -4436, -4436, -2915, -4436,   328,    10,  3020,
    1646,   -75,   266,  -245,  -194,  -163,   -77,  3320,  2792, -4436,
   -4436, -4436,  -211,  1680, -4436, -1100,  -359, -4436,  1400,  -928,
    2087,  2780,  2788, -4436,  1392, -4436, -4436,  1398, -4436, -4436,
   -4436,  -924,  2092, -4436,  2794, -4436, -4436, -4436,  1379,  1393,
   -3463,   826, -3460, -3421,   327,   311, -1187,  -280,  -185,  3363,
    2796,   838, -4435,   765, -4436, -4005, -2461,  2113, -2154, -1867,
   -4436, -4436, -1434,  7917, -4436, -4436, -4436,  8732, 10662, -4436,
   -4436, 12691, 14102, -4436, -1303,   878, 14393,  6868, -1470, -1889,
   -1558, 20105,  1255,  1085, -2851, -4436, -4436, -4436,  -243,   888,
     137, -4436, -4436, -4436, -4436,  -509, -2900,  -508, -4436, -4436,
   -4436,  -512, -3476, -2021, -4436,  -819, -4436, 20339,  1435, -4436,
   -1326, -2843, -2847, -1402, -2012, -4436, -4436, -4436, -4436, -4436,
   -4436, -4436, -1937, -3361,  -328,  1510, -4436, -4436,  1605, -4436,
   -4436, -4436, -1566, -1143, -2754,  1514, -2178, -4436, -1099,   786,
    2237, -1058,  4525, -1599, 17287,  -127, -2309, -1551, -1784, -4436,
     -81, -4436,  2847,   254,  -787,  -150,  -897,  6420,  4355,  4743,
   -3205, -4436, -4436,   344, -4436, -4436, -4436,  3836,  1042, -4436,
    3143, -4436,  1752,  2484, -4436, -4436,  2115,  -971,    48, -4436,
    -480, -4436,  -132, -4436, -4436, -4436,   173, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436, -4436, -4436,  2816, -4436, -4436, -1469,
   -4436, -4436, -4436, -4436, -4436,  4100,  -299, -4436,  3514,  -283,
   -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436, -4436,  2829,
    2148, -4436,  3324, -4436, -4436, -4436,   -38,  3039, -4436, -4436,
   -4436, -1226,  -596,  3337,  3339,  2118, -4436, -4436, -4436, -4436,
   -4436, -4436, -4436, -4436,  2123, -4436, -4436,  1503, -2164,  2127,
   -4436, -4436,   816, -4436, -4436,   361, -4436,   818, -4436,  2940,
   -4436, -4436, -4436,   857, -4436, -4436, -4436,  -591, 14518,   -48,
      97,   198,  1040, -4436,  8837,  5207,    73,  2852,   -10, 12062,
   19250,    11, -4436,  4104,  2125,  1738, -1030, -4436,  4122,  2436,
   18576, -4436, -1028,    30,  2119, -4436,    -2,  -660, -1215,  3142,
    -761, -2003, -4436,  4528, -4436, -3554, -4436, -1053,  3545, -1250
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   248,   249,  1736,  2668,  2545,  3377,  3378,   250,
     251,  1808,   252,   253,   254,   255,   256,   257,   258,  1752,
     259,   260,  1308,  1958,  2678,   261,  2408,  1075,  1076,  2276,
    2277,  2610,  2278,  2265,  1586,  2060,  1771,  1738,  1772,   263,
     264,  1580,  2257,   265,   266,   267,  1796,  1797,  1746,  2003,
    4291,  4894,  2526,  3414,  3213,  3214,   268,  1854,  1855,   269,
     270,  3328,  1895,  2637,  3865,  3866,  4322,   878,  2634,  4599,
    4600,  4308,  4309,  4606,  4785,  4786,  2679,  1954,  3408,  3953,
    3368,  4392,  3369,  4393,  3370,  4394,  3356,  3912,  3913,  3914,
    3371,  4370,  4816,  3372,  2423,  4919,  2713,  2090,  2088,  4803,
    4188,  4189,  4976,  4924,  4925,  4926,  5048,  4399,  3412,  3959,
    4402,  4634,  3110,  1978,  2827,   977,  2715,   909,   978,  2680,
     275,  2707,  1828,  1829,  2553,  3872,  3470,   276,  1327,  3739,
    4680,  4851,  4852,   277,   866,   278,  1962,   279,   280,  2664,
    3362,   281,  2440,  3127,   282,   283,  3154,  3155,  3156,   284,
     285,  3763,  4556,  1798,  3206,  3207,  3208,  3209,  3783,   286,
    1960,  1834,  2687,   287,   288,   289,   290,   291,  2597,   292,
     293,  2681,  1970,  2699,  2700,  4382,  4650,  4825,  4652,  5084,
    5085,  4626,  3718,  4202,   295,   296,  4365,  4366,  4931,   297,
    2438,   298,   299,   300,  1938,  2656,  2657,  3873,  1722,  1898,
    2639,  2640,  3942,  3943,   301,  3288,   302,  4250,  4251,   910,
    4934,  4899,  4987,   303,   304,  4254,  4255,   305,   306,   307,
     308,   309,   965,  1380,  1381,  1728,   310,  2293,   311,  1281,
    3319,   312,  1469,  2852,  4439,   313,  1001,  1405,  1406,  2682,
     315,  1012,  2830,  1014,  2103,  3472,  3473,  4013,  2798,  1200,
     316,   317,  2809,  2833,   318,  1739,  2414,  2415,  4183,  2683,
     911,  1984,  2718,  3105,  4842,  4190,  4537,  4754,  3027,  3669,
     320,   912,  1776,  2488,  2721,  3420,  3421,  2490,  2991,  3974,
    2492,  3422,  3427,  3428,  3429,  3970,  3978,  4674,  4675,   321,
    1774,  2481,   322,   323,   324,  1805,  1219,   325,   933,   934,
     326,  4796,   327,  1346,   328,  1033,  2120,   329,  2504,  3769,
     330,   331,   332,  5061,  5092,  5093,  5094,  3983,  5020,   333,
    5063,  1447,   335,   336,   337,   869,  1247,  1248,  1249,  2684,
    4669,   339,   340,  2660,  3355,  3894,   341,   342,  2409,  3095,
     343,   344,   345,  1942,   346,   347,   348,   349,  1874,   350,
    1617,  1618,   351,   352,   873,  1094,  1621,  1629,   353,   980,
    1399,  1400,  1401,  2062,   354,  1451,  2820,   981,  1394,   982,
    3046,  3678,  3679,  3682,   983,  3043,   358,  2109,  2814,  2817,
     984,  3050,  3051,  3052,  3053,  3054,  3684,   985,  1003,  1337,
    2729,   986,  1540,   363,   364,   365,  1103,  1098,  1099,   367,
    2235,  2981,  1020,  1635,  1060,  1110,  4138,  2307,  2308,  2330,
    2331,  1644,  1645,  2320,  2322,  3029,  2323,  3037,  2313,  4135,
    4503,  2326,  2327,  1647,  1648,  1649,  2335,   368,  2985,  3614,
    3615,  3616,  4114,  4115,  4129,  4125,  4490,  4719,  3617,  1441,
    1655,  3618,  3623,  3676,  3399,  3400,  3401,  2493,  2647,  1920,
    1541,  1921,  2654,  1542,  2155,  1923,  1543,  1544,  1545,  1926,
    1546,  1547,  1548,  1549,  2138,  2198,  1550,  1551,  2174,  1142,
    1143,  2047,  2891,  1553,  1554,  4078,  4463,  4452,  2917,  2918,
    2273,  4074,  3565,  4731,  4873,  4874,  4146,  4143,  4507,  4735,
    4972,  5029,  5030,  1555,  2971,  2227,  1221,  1556,  3875,  2229,
    2911,  2993,  2994,  2393,  2136,  2857,  2874,  2875,  2888,  3526,
    2895,  2900,  3549,  3550,  2912,  2940,  1557,  2860,  2861,  3509,
    2140,  1558,  1610,  1611,  2243,  2935,  1624,  1625,  1096,  1559,
    1560,  2104,  1085,  4715,   720,   703,  3227,  2288,  1251,  1017,
    1561,  1562,  1563,  1355,  1356,  1677,   665,   704,   705,  1180,
     817,     2,    75,   987,  3406,   372,   373,   914,   915,   916,
    1329,  1330,  1989,  1992,  1682,  2371,   669,   670,   721,  4418,
    4681,  4854,   971,   374,   375,   376,   377,  1678,  2367,  1144,
      76,    84,    77,  1145,   414,   415,  2348,   378,   834,   379,
    1658,  1124,  3690,   380,   381,   382,   383,   384,   968,   385,
    1126,   386,  1127,   387,   388,   389,   390,  1134,   391,  1660,
    1661,  4175,  1662,   392,   393,   707,   708,  1392,   394,   395,
    1161,  1162,  1424,  1425,  1688,  1703,  1704,  1705,   396,   677,
     397,   398,   399,  1694,  1695,   400,  2250,  2251,  2376,  2252,
     401,  3067,  3068,   402,  3649,  3650,  4514,  3651,   403,  2246,
     404,   405,  1088,  3695,   406,   830,   407,  1175,   709,   710,
     711,  1182,   820,  1046,   722,  1184,  3210,   822,   823,   713,
     714,   715,  2082,    78,  3075,  2083,  1565,   723,  1566,  2241,
    1567,  1568,  1569,  1570,  1571,  1711,   717,  1151,  1384,  1385,
    3076,  1387,    82,  1388,   411,  3887,  2050,  1426,  2068,  2069
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,   366,  1102,   361,   356,  1111,   357,  1581,   359,  1304,
    1433,  1434,  1435,  1650,  2009,  2019,  1439,  1005,  1087,  1656,
    1833,  2491,   925,  2013,  2087,   908,   913,  1052,  1603,  2301,
     408,  1676,    79,  1220,  1872,  1339,   408,  1005,  2422,  1084,
    1723,  2652,  2766,  1810,  2059,  2290,  2799,  2644,  2115,  1897,
    3490,  2176,   979,  2127,  2522,  3173,  3175,  1859,  2149,  2150,
    1827,  1013,  3324,  1838,  1159,  1362,   964,  2048,   409,   408,
    1595,  1026,  1864,  1952,   409,  1220,   410,  2165,  2501,  1402,
    1338,  1121,   410,  1972,  3367,  2999,  2509,   674,   366,  2612,
    3629,  3385,  3745,  2704,   867,  1799,  3977,  1122,  2653,   262,
    1053,  3921,  2578,  2579,  3963,  2565,   719,  2000,  2489,  1940,
    2355,  2357,  2358,  1945,   408,   410,   725,  3778,  1949,  3780,
    2304,  3019,  2856,  4158,  3285,  1955,  4195,  3876,   825,  1163,
    1706,  1220,  1708,  3619,  3683,  1974,  3476,  1105,  2574,  3890,
    3876,  3626,   706,  3624,  3625,  1397,  4225,  2893,  4185,  4111,
    4413,   919,   871,  4397,  2758,  4405,  1074,  2290,  4128,  2500,
     410,  2893,  4363,  2477,  2074,  1365,  4538,   927,  2049,  3573,
    2044,  1339,  1113,   825,  4661,  1377,  2400,  2708,  2142,  2143,
     706,  1773,  1643,   408,  1684,  1685,  1646,  4163,  4056,  1154,
     821,  3619,  1002,  3058,  2349,  2349,  4126,  2248,  3530,  3694,
    2719,   917,   924,  1114,  2162,   417,  1386,  1049,   417,  1697,
    2974,   924,  1002,  2193,   818,  1049,  1588,  1049,  2196,  1971,
    1048,  1740,    45,  4391,   877,   417,  3229,  2001,  1048,   410,
    1048,  4755,  1698,  3074,  4404,   821,  2585,  3078,  2428,    45,
    2933,  1176,   825,  4847,  -139,  3895,  3896,  3897,  3898,  3899,
    3900,   924,  2291,  -139,  1749,  3968,  2510,   413,  -139,   818,
    1333,    37,    38,    39,    40,   928,  3307,   417,    44,  2590,
      37,    38,    39,    40,  4536,  2503,    43,    44,  1471,  1699,
     271,    45,  1422,  2572,  1893, -1575, -1575, -1575, -1575,  4323,
    1092,  2061, -1575,   130,   131,   366, -1799,   361,   356,  3741,
     357,  3688,   359, -1799,   821,  2968,  2233,   417,  2001,  2001,
    1449,  2928,  2969,  2202,  3477,   819,    43, -1905, -1905, -1905,
   -1905,    45,  4252,  1741, -1905,  2933,  1430,  -376,   818,  4328,
    3326,  2711,   408,   272,  1465,   273,  2676,   274,  2205,  1243,
    2972,  2051,     3,   664,   362, -1575,  1936,  2701, -2635, -2635,
   -2635, -2635,  4446,  2503,  4447, -2635,  1750, -1815,  -782,  5082,
     819,  3380,  3024, -2635, -1815,   294,  1585,   408,  2207,   314,
     409,  4611, -1580, -1580, -1580, -1580,  2506,  1317,   410, -1580,
    4616,  1872,  4763,  1887,  4898,  4545,  4359, -1590, -1590, -1590,
   -1590,  1042,   319,   262, -1590,   334,  3530,  2194,  2054,  3136,
    2055,  1081,  1574,   338,   355,   409,   360,  1318,  4617,  2677,
    2503,  2810,  4779,   410, -2059,   879,  2503,  1614,  4612,  1615,
    4253,  2239,   371, -2636, -2636, -2636, -2636,  2507,  1244,   819,
   -2636,   362, -1580,  4843,  2503,  3444,  1319,  3446, -2636,  2503,
    4835,  3025,  3507, -1547, -1547, -1547, -1547,  2176,  4541,  1220,
   -1547, -1590, -1590, -1590, -1590,  1749,  2832,  5044, -1590, -2633,
   -2633, -2633, -2633,  2973,  1150,  1742, -2633,  1727,   831,  1245,
     832,  2149,  2150,  2292, -2633,  3746,  3121,  2002,  2165,  1431,
    1320,  1339,  4448,  2266, -1580, -1580, -1580, -1580,  2279,  2279,
    3335, -1580,  4723,  2794,  4725,  1198,  5083,  2800,  1743,  2802,
    3488,  4995,  2805,  2702,  1339,   913,  2236,  3478, -2632, -2632,
   -2632, -2632,   929,  1101,  2984, -2632,  1295,  2712,  1246,  2429,
    1350,  4360,  3742, -2632,  2001,  1461,  2037,  1744,  2811,  2511,
    2107, -2227, -2227, -2227, -2227,  1178,  3327,   868, -2227,   675,
    2623,  2512,  3915,  2619,  1157,  1158, -2227,  2282,  2283,  2934,
    2234,  1122,  1880, -1560, -1560, -1560, -1560,  1750,  2002,  2002,
   -1560,  1687,  1690,  3308,  2573, -1587, -1587, -1587, -1587,  1093,
    3969,  1339, -1587,  2063,   271,  4974,  2020,    37,    38,    39,
      40,  4238,  3876,  2586,    44,  1745,  1719,  2463,  1148,  2591,
    1450,  2197,  2513,   930,  1693,   931,  4598,  4531,  4178,  4663,
    2142,  2143,    37,    38,    39,    40, -1799,  2108,  2162,    44,
    2039,   247,  4631,  1751,  3542,  2970,  2131,  1438,  2644,  1937,
   -2059,  4377,  2043,  5091,  1155,  2570,  1937,   272,  2290,   273,
     919,   274,  1112,  2533,  3593,   999,  1000,  1608,   362,  5045,
    2615,  1609,  3158,  2561,  3028,  2563,  1735,  2465,  2249,  4128,
    2105,  2703,   999,  1000,  4487,  2471,  1616,  2611,  4491,   294,
    3177,  4546,  4657,   314,  4677,  2117,  2642, -1815,  1871,  1804,
    1156,  -139,  -139,  2290,  1231,  3338,  4444,  2998,  2128,  2787,
     917, -2059,  4525,  3746,  4386,  3044,   319,  4482,  3134,   334,
    2202,  2011,  4012,  1339,  1700,  1701, -2059,   338,   355,  3224,
     360,  1339,  1339,  2812,  2762,  3819,  2551,  5046,   416,  2554,
    2555,  5016,  2372,  2859,  1191,  2205,   371,  5011, -1575,  4871,
    4882,  2813,  2336,  4216,   924,   924,  2337,  4141,  4240,  2226,
    5047,  1102,  1777,  2011,  1674,  1675,  3172,  3758,  2261,  3759,
    3852,  4247,   833,  3855,  3856,  2207,  1199,  3859,  1608,  3122,
   -1905,  3252,  1609,  3862,  1651,  2480,  1597,  1179,  1290,  2795,
    3619,  3619,  2137,  3159,  1403,  1994,  1201,  1296,  2806,   676,
    4996,  1351,  1150,  2620,  2002,  4620,  4621,  4622,  4623,  4624,
    1280, -2635,   408,  1438,  4747,  4149,   408,  2171,  4337,  5057,
    1335,  4757,  2314,  2108,   835,  3711,  4388,  3685,  1163,  1285,
    3935,  3916,  1869,  1881,  1115, -1580,  2172,  2853,  2855,  3539,
    3540,  3541,  3542,  4636,  1348,  1995,  3481,  2777,  2863,  1058,
    2173,  1164,  2867,  2780,   409,  2770,  4275,  2044,   410,  2315,
    2879,  2880,   410,  3225,   836,  1440,  1187,  3653,  1404,  4248,
    1410,   825,  1415,  2897,  2899,  1187,   674,  1395,  1419,  1665,
    3087,  2171,   674,  4833,  2913,  1343, -2636,  2883,  2884,  2711,
    3659,  4191,   674,  1398,  3901,  1353,  2695,  2416,  2893,  2893,
    2172,  1410,  1415,  2893,  2137,  2477,  2148,  3182,  1187,  3060,
    1116,  3060,  2796,  2417,  2175,  3482,    37,    38,    39,    40,
     674,  2202, -2633,    44,   674,  1422, -1373,  3874,   366,   216,
    1108,  2416,  1440,  1167,  1996,   674, -2363,  3904,  3479,  1113,
    3874,  4862,  1059,  2893,  2893,  3218,  2205, -1580,   724,  4637,
    3194,  2540,  2317,  4416,  1336,  2648,  4166,   818,  4249,   224,
     674,  1029,  1654,  3634,  1187,  3359,  3635,  3636,  2418,  3135,
    1114, -2632,  2696, -1376,  1187,   674,  2207,  3637,  3638,  3639,
     674,  3640,  3641,  1870,  1997,  2419,  3642,  3643,  3644,  3530,
     674,  3955,  1598, -1547, -2227,    81,  2491,   234,  1150, -1373,
     924,  3195,  2418,  2318,   674,  4886,  4887,  4276,  1207,   237,
    1619,  2714,  4389,  1396, -1902,  2565,  2154,  1220,  1324,  2419,
    3975,  1136,    37,    38,    39,    40,  2769,    79, -1587,    44,
    1409,  4920,  1414,  3149,   872,  1584,  3857,  3858,  1030,  1592,
    2199,  1106,  1428,  3045,  1755,  1408, -1376,  1413,  1391,  3799,
    4915,  4950,   924,  1599,  4713,  4716,  1578,  4944,   819,  4940,
    4720,  1443,  1445,  4722,  1998,  2237, -1547,  4799,  1461,  4629,
     408,  2803,  2804,  2791,  3908,  4647,  1442,  1444,  2194,  1137,
     993,   417,  2649,  1019,    37,    38,    39,    40,  1187,  1165,
      43,    44,  1471,  1699,  1049,    45,   674,  4228,  1049,  1107,
     994,  1843, -2637,  1117,  2430,  4654,  3150,  1048,  1613,  4136,
    3909,  1048,  3977,  2420,  3979,  3927,   410,  1666,  1422, -2009,
    2430,  4863,  3149,  1187,  3910, -2363,  3360,  1686,  3645,  3219,
    1243,  3480,  1202,  2223,  2224,  2225,  2226,  2797,  1224,  1844,
    1150,  4810,   706,  4921,  4758, -1373,  3656,  2420,  1238,    35,
     417,  3800,  2697,    37,    38,    39,    40,    41,    42,    43,
      44,  1243,  1689,  2747,    45,  2698,  1108,  4849,  4557,  2234,
    3532,  5012,  1139,  1411,  2521,  1325,  1299,  1416,  1417,  1418,
    1306, -2363,  1422,   674,   674,  4984,  4916,  1429,  1402,  4811,
    3980,  1316, -1376,   826,  1608,  3150,  4812,  4838,  1609,  4890,
    4797,  1679,  1876,   827,  3361,  4839,  3911,  5018,  4922,  2421,
    1031,  1032,   417,  1882,  4880,    37,    38,    39,    40,  1244,
    1709,    43,    44,  4813,  3151,  5034,    45,   993,  3467,  1220,
    1326,  5017,   969,  5056,  4801,   993,  4229,  5058,  2792,  3149,
   -1373,  1027,  1737,  2421,  4985,  4942,  1633,   994,  3196,  3342,
    1244,  3664,  2431,  2739,  2773,   994,  3153,  3152,  2263,  3646,
    1245,  3007,  3928,  1987,  2750,  1679, -2041,  2793,  2311,  2650,
    4506,   362,  1101,  1985, -2060, -1373,  2757,  3486, -1373,  5090,
    4510,  1187,  1109,   417,  4524,  1967,  3063, -1376,  4868,  1108,
    1845,  1245,  1187,  3801,  4814,  2472,  3619,    45,  1639,  3197,
    3619,  1089,   828,   891,  3647,  1968,  3038,  1423, -2009,  1246,
    1473,  2886,  3150,  3530,  4302,  1935,  1423,  4850,  4500,  4149,
    4305,  4306, -1376,  3981,  1102, -1376,  3802,   874,   993,  2432,
    4981,  4509,  2221,  2222,  2223,  2224,  2225,  2226,  4230,  1634,
    1246,  4231,  2356,  2025,  1909,  3153,  1963,  1108,   994,  3004,
    4883,  1423,  1187,  3244,  2040,  3803,   366,  2312,  4840,  3181,
    4889,   893,  2635,  2636, -2009,  3756,  1641, -2085,  2264,  5019,
    2950,  1160,  3177,  4978,  4979,  4432,  4914,  1220,  1846,  2473,
    3279, -1547,  3874,  3982,  1964,  3530,  1706,  1594,  1708,  4764,
    3876,   674, -1547,  3162,  2148, -1547,  1727, -1547,  3648,  1112,
    3537,  3538,  3539,  3540,  3541,  3542,   674,  1028,  3244,  4818,
      81,    81,  3251,    81,  3487,  4822,  2027,  5036,  1210,  1211,
    1212,  1187,  1213,  1214,  1215,  1216,  1217,  1218,  3441,   674,
    3447,   829,  2521,  3263,  4179,  1139,  2297,  3442,  2671,   664,
     664,  4970,    79,    79,  2387,    79,  2065,  2491,  2067,  4008,
    1969,  2071,  1437,  2073,  2028, -2041,  2076,  2077,  2078,  4815,
    1122,  1679,  3153, -2060,  3302,   674,  3631,  4971,  3632,  2085,
    4775,  2305,  2306,  3253,  2310,  2626,  4664,  3163,  1935,  3734,
     674,  3256,  2110,  3258,  2111,  1163,  3329,  4118,  4665,  3390,
    3391,  3392,  3393,   674,  3532,  2951,   674,  1654,   900,  2952,
     901,  3398,  1114,  1114,  2240,  1114,  3764,  1187,  1700,  1701,
    1057, -2041,   972,  2627,  -599,  4385,  3096,  3735,  5099, -2060,
    1082,  5075,  4027,  1953,  4727,  3437,  3632,  1391,  3276,  1438,
    3706,   973,  2825,  3660,  3757,  1965,  1187,  2953,  4935,  4172,
    2893,  2672,  2425,  2893,  2893,  2893,  2893,  2893,  2893,  2893,
    2893,  2893,  2893,  3533,   417,  4119, -2085,   216,  2424,  2565,
    5070,  3277,  3505,   974,  1187,  1187, -2637,  1187,  2253,  2254,
    4776,  2353,  2556,  2893,  1095,  2624,  1128,  1674,  1675,  5068,
    2230,   130,   131,  4120,  1187,  2425,  2064,   224,  3097,  2066,
    3278,   408,  2070,  3820,  2072,  3140,  1129,  2075,  4121,  4180,
    2255,  2079,  2893,  2893,  4001,  2029,  1130,  3021,  2202,  2011,
    4122,  3557, -2085,    37,    38,    39,    40,  1572,   674,  4037,
      44,  2269,    35,  1966,  1104,   234,   674,   674,  4181,  2354,
      41,    42,  2625,  4123,  4732,  4733,  1187,   410,   972,  1790,
    4512,  4666,  3582,  4057,   408,   408,   408,  4182,  4848,  3977,
     825,  5105,  4717,  1679,   706,   706,  2954,   973,  1679,  1679,
    1807,  1220,  2256,  2207,  2628,  1187,  5015,  3619,  3736,  1187,
    1187,   247,  3619,  2369,  4226,  3619,  2361,  2193,  1573,  2362,
    2571,  1994,  4689,   409,   409,  3765,  5071,   993,  2458,   974,
     410,   410,   410,  2030,  1807,   408,  2538,  1937,  2557,   362,
    2558,  3956,   408,  3237,  3960,  1131,  4892,   994,  4124,   408,
    3766,   674,  2289,  4191,  4421,  1473,  4422,  2426,  3530,  1608,
     206,  3469,  1139,  1609,  3537,  3538,  3539,  3540,  3541,  3542,
     835,  2772,  3717,   409,  2364,  2365,   818,  1848,  4119,  3179,
    2391,   410,  3108,  1849,   891,   875,   216,  3416,   410,  1935,
    1724,  3072,  2629,  3238,  2034,   410,  3737,  2080,  2539,   706,
    2383,  2385,  1049,  4596,  4597,  1135,  4120,  1132,   825,  2363,
     836,  2135,  5052,  3342,  2035,  1048,   224,  4743,  1118,  4745,
    2081,  4493,  4718,  1725,  1809,  1639,  3270,  4118,  -161,   818,
    4357,  2152,  3271,  4122,  3109,  1049,  3537,  3538,  3539,  3540,
    3541,  3542,   893,  1935,  3239,  4040,  4542,  4041,  1048,  -502,
    2271,  2355,  1726,  -161,   234,   417,  4639,  1679,  1858,  4954,
    1996,  2179,  -161,  3733,  4646,  1679,   237,  3338,  2808,   835,
    2289,  1136,  1935,  3698,  1133,  2191,  4656,   819,  3584,  1850,
    3585,  4277,  2648,  1125,  1639,  3296,   206,  -161,  1640,  2272,
    4191,  1849,  4358,  1641,   818,  4119,  1339,  2410,  3280,  1737,
     247,  4278,  1737,  3586,  2352,  2011,  4878,  2411,  4543,   836,
    1997,  2434,   216,  3628,  1473,  1790,  1679,  3530,  3531,  1679,
    1679,  2435,  2412,  4120,  1830,   674,  1735,  3281,  3272,  1137,
    1642,  4124,  1138,  1339,  4084,  3240,  4293,  4007,  4121,  3532,
    3619,  3431,   224,  5103,  3104,  1935,  5104,  1737,  1136,  2734,
    4122,  1737,  1641,  2893,  4640, -2427,  4294,  1831,  1729,   408,
    1735,  2202,  3725,  4011,  2641,  4042,  2279,  3108,  4549,  4550,
    2353,  1112,  1112,  4123,  1112,  4043,  4213,  4198,  3455,   900,
     234,   901,  1935,  1679,   975,  1317,  2205,  1850,  2731,  1642,
    1998,  1730,   237,  2815,  4641,   819,  -946,  2737,  3533,   209,
    4012,  4198,  4196,  3587,   906,   410,  1137,   664,  3588,  2649,
    1935,  4823,  1398,  2829,  2732,  1318,  2207,  3747,   825,  3714,
    1731,  1851,  1139,  2738,  2542,   674,   976,  2742,  2354,    37,
      38,    39,    40,  2748,  2749,  4774,    44,     8,  3241,  4824,
    1054,   674,  4917,  1160,  3937,  3768,  3242,   366,  4124,  3243,
    4199,  2761,  1832,  1732,  1852,  2413,  2556,  3939,  4513,  3750,
    2436,    37,    38,    39,    40,  3014,  3948,  1187,    44,  4335,
    3273,  3654,  3021,  1935,  4199,  1166,  1187,  2998,   674,   674,
    2658,  1122,   122,  1853,  1201,  2828,  1733,    43,  1320,   674,
     209,  1177,    45,  2437,  2607,  4780,  4227,  4232,  3532,  1139,
     126,   674,   674,  3274,   818,  4200,  2608,  4201,  2851,   366,
      81,  2824,  2821,    81,  2822,  1734,  2823,  1192, -1420,  1140,
    4217,  1139, -1420,   674,   835,  3792,  3589,  1106,  1813,  4200,
    2609,  4201,  3275,  2893,  2893,  1697,  3590,  2515,  1141, -1421,
    3599,  1194,    79, -1421,  2775,    79,  2776,  3282,  4019,  2523,
    2778,  1205,  2779,  4058,  4059,  2781,  2394,  3533,  1698,  2782,
     216,  1814,  4241,  1187,   836,  3534,  3535,  3536,  4191,  3537,
    3538,  3539,  3540,  3541,  3542,  2244,  3283,  3901,  2245,  1339,
     837,  2598,  2557,  3902,  2558,  1107, -1420,  1206,  1735,  2395,
     224,    80,  2998,  3903,  3459,  2171,  2650,  2524,  2525,   876,
    3874,  1187,  1187,  1241,  3787,   819,  1220, -1421,  2543,  1187,
    2605,  2546,  1187,   966,  2172,  2651,  1187,  1233,  2396,  3788,
    3904,  2877,  3905, -1420,  1187,  1187,   408,  4023,   234,   932,
    2673,  2521,  1187,  3030,  1590,  1187,  1187,  1187,  1187,  1630,
     237,  4526, -1373,  2606, -1421,  1187,  1187,  3917,  1187,  2705,
    1187,  1187,  1108,  1619,  1187,  2259,  2594,  1390,   417,  4091,
    2601,  3347,  5033,  4465,  1055,   891,    37,    38,    39,    40,
    1935,  1187,   410,    44,   247,  2045,  1187,  3665,   673,  2046,
    1187,  2675,  4464,  2491,  1187,   825,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  1187,  3906,  1187,  2598,  3098,  1339,
    3101,  2562,  1187,  2568,  4064,  1187,  3395,  3013,  4844,  2503,
    3348,  3396,    37,    38,    39,    40,   408,  2508,  2171,    44,
    4395,  2160,  2161,   893,  3534,  3535,  3536,  4022,  3537,  3538,
    3539,  3540,  3541,  3542,  3047,  2740,  3891,  2172,  2523,  1816,
    1242,  3396,   918,  1168,  3724,  3157,  3338,  2931,   935,  3092,
    3796,  2173,  3907,  3689,   409,  1169,  1170,  3908,  2598,  2575,
    2045,  1608,   410, -1905,  2765,  1609,  1284,  1187,  1109,  3502,
     408,   818,   408,  2768,  1018,  1171,  4193,  4194,  1172,  3703,
    3704,  2171,  1297,  3797,  1298,  1817,  2524,  2525,  3349,  3350,
     362,  2919,  3342,  3909,  2922,  1287,  2523,  2941,  -399,  2942,
    2172,  3503,  3351,  2314,  4819,  3504,  1289,  3910,   409,  1300,
     409,  1301,  3798, -1385,  2175,  1292,   410,  1839,   410,    35,
    2521,  1312,  2943,   408,  2134, -1385,   247,    41,    42, -1385,
    3128,  1305,    37,    38,    39,    40,  3760,  1201,   674,    44,
    2315,  2148,  -501,  2401,  2524,  2525,  2201,  1321,  3352,  2202,
    1840,  1322,   362,  3933,  1841,  1323,    81,  4024,    81,  2295,
     900,  2296,   901,  1818,  1328,   674,  1679,  2345,  2346,   410,
     674, -1385,   819,   674,  2205,  4426,  4427,  4428,  2521,  1842,
    2206,  2298,   825,  2299,  3235,  1953,  1709,  1331,    79,  3911,
      79,  2316,  1173, -1385,  2893,   674,  2727,  2728,  1187,  1150,
    4221,  -399,  1345,  2893,  2207,  2148,   417,  2401,  3318,  1187,
    1872,  1819,   192,  1820,  1811,  1349,  1187,  2944,  3035,  3036,
    2893,  2893,  2945,  2564,  1357,  3814,  1856,  2946,  1860,  1174,
   -1385,  1358,  1339,  2317,  1339,  3353,   674,  3354, -1385,  1363,
     408,    35,   417,   408,  2289,  2939,  1372,  1049,  4132,    41,
      42,  1822,  1378,  1935,  3811,  2148,    45,  1727,  1935,  1935,
    1048,  2604,   967,   674,   674, -1444, -1444,    35,   818,  1393,
    1935,    37,    38,    39,    40,    41,    42,  3918,    44,  3920,
    4331,  4332,  4333,  3665,  2318,    45,   410,   674,  1432,   410,
    1824,  2767,   216,  2768,  4137,  4139,  3665,  1339,  2523,   825,
    1446,  2788,   825,  2789,    37,    38,    39,    40,  1436,  2209,
    1049,    44,   674,  3245,  1452,    45,   674,    37,    38,    39,
      40,  3387,   224,  1048,    44,  1826,    37,    38,    39,    40,
    2210,  2211,  1459,    44,   674,  1453,  2290,  4794,  5059,   192,
    1458,  2790,  3972,  2789,   674,  2947,  2524,  2525,  3556,  3160,
    3558,  3559,  1460,  1679, -1385,  2948,  3926,   674,  3929,  1461,
     234,  1679,  1462,  1679,  3215,  2345,  3056,   674,  3245,   819,
    2998,  2868,   237,  1463,  4438,   362,  2214,  2818,  1464,  2819,
    2521,  2148,  1467,  2401,   408,   818,  2523,  1468,   818,  2215,
    3020,  1470,  3021,  4608,   664,  4610,  1596,  1473,  4739,  4613,
    3530,  4614,  1593,  3080,  3633,  2819,   247, -1166,  4298,  4338,
   -1166,  1187,  1608,  1935,  1600,  1630,  1609,  4085,  3170,   216,
    3171,  3084,  1473,  3410,  3411,  3530,  3088,  1601,  4673,  3091,
     410,  4341,  3667,  3668,  2524,  2525,  3245,  2869,  3231,  1602,
    3232,  3245,  4471,   825,  2893,  4584,  4585,  1607,  4587,   224,
    3440,  3114,  1627,    37,    38,    39,    40,  1620,  4469,  3226,
      44,  1473,  1628,  1102,  3530,  3818,  3449,  3450,  2521,  1637,
    3452,  4018,  3330,  3245,  3331,  1630,  3456,    37,    38,    39,
      40,  4472,  1631,  3343,    44,  3344,   819,   234,  1935,   819,
    1652,   674,  3164,  4325,  4326,  2870,  2523,  2325,  2871,   237,
    1653,  3461,  2523,  2789,  3501,  3357,  2768,  2121,  2122,  3821,
    4453, -1551, -1551, -1551, -1551,  4414,  1657,    35, -1551,  3178,
    3511,   918,  2768,  1659,  3493,    41,    42,  1663,   674,   818,
    3496,  1664,  3515,  5060,  2768,  1667,  1187,  3608,  3609,  3610,
    1668,  1680,  3373,  3211,  2524,  2525,  2523,  3492,  3849,  2201,
    2524,  2525,  2202,  4690,  4691,  4692,  4693,  1636,  4343,  1638,
    2221,  2222,  2223,  2224,  2225,  2226,  2202,  1669,  3236,  2203,
    1102,  1670,  3247,  3024,  4218,   674,  1672,  2205,  2521,  1681,
    1671,  3532,  4345,  2206,  2521,  2523,  1673,  1935,  2872,  1712,
    3259,  2205,  1683,  1713,  2524,  2525,  1715,  1721,  3237,   674,
    3268,  1679,  1150,  1187,  1727,  1748,  3532,  2207,  3519,  1187,
    2768,  2523,  1753,  3292,  1473,  1779,  3520,  3530,  2768,    74,
    3546,  2207,  2768,  3299,  4242,  1775,  1187,  1187,  2521,  3603,
     819,  3604,  1187,  2524,  2525,  3562,   408,  2768,  1806,  3567,
    3533,  3568,   408,  1807,  3605,  3532,  3606,  3781,  3238,  3782,
    1815,  3785,  3025,  3786,  3966,  1804,  3967,  1187,  1187,  2524,
    2525,  2523,  1187,  1835,  4028,  3533,  2768,  2521,  1812,  4429,
    4065,  1847,  4066,  3620,  1187,  1187,  1187,  1187,  4075,  1857,
    4076,  4087,   410,  2768,  4164,  2873,  4165,  1187,   410,  4168,
    1187,  4169,  1187,  2521,  3374,   825,  4197,  1861,  2789,  3239,
    1866,   825,  1187,  1187,  3533,  4492,  1187,  4495,  2208,  2524,
    2525,  1867,  2209,  1868,  4387,   366,  2789,  2824,  2821,  1187,
    2822,  1187,  2823,  4605,  4470,  1187,  2819,  4395,  4533,  1873,
    4534,  3620,  1875,  2210,  2211,  4539,  1877,  2789,  3665,  4644,
    4540,  1187,  2789,  2521,  1879,  1883,  1884,  2210,  2211,  4601,
    2212,  4602,  1187,  1889,  1187,  1187,  1187,  3563,  4329,  4330,
    4331,  4332,  4333,  3570,  1282,  4658,  1891,  4659,  4619,  4329,
    4330,  4331,  4332,  4333,   674,  1894,  2213,  4334,  1187,  2214,
    4699,   818,  4700,  4701,  1004,  2768,  4709,   818,  2819,  1896,
    3240,  1187,  2215,  2214,  1899,  2216,  1187,  4761,  3532,  4762,
    1941,  4820,  1187,  2789,  1004,  1735,  1679,  3534,  3535,  3536,
    1187,  3537,  3538,  3539,  3540,  3541,  3542,  4697,  4311,  1723,
    1944,  1340,   935,  4845,  1946,  4846,  3720,  1956,  4858,  3375,
    2819,  3474,  3534,  3535,  3536,  1937,  3537,  3538,  3539,  3540,
    3541,  3542,  1957, -1558, -1558, -1558, -1558,  -182,  1959,   674,
   -1558, -1549, -1549, -1549, -1549,  3474,    80,  3533, -1549,  4312,
    1961,  4865,  4673,  3021,   674,   674,  1973,  1975,  3376,  2217,
    1187,  3534,  3535,  3536,  1983,  3537,  3538,  3539,  3540,  3541,
    3542,  1981,   819,  4313,  4522,  4864,  1991,  1999,   819,   853,
    4870,   674,  3946,  3241,   674,  4864,  2004,  1935,  4314,  2005,
    2006,  3242,  4315,  2008,  3243,  3771,  4872,  3773,  3946,  2007,
    4373,  4374,  2010,  2018,  1448, -1552, -1552, -1552, -1552,  2011,
    3026,  4316, -1552,  2021,  4317,   408,   408,   408, -1550, -1550,
   -1550, -1550,  4911,  2022,  4912, -1550,  4318,  2023,  2024,  1935,
    1935,  2026,  1935,  1466,  4943,  4728,  2258,  2031,  4948,  4907,
    4949,  4959,  1575,  2819,  2032,  2033,  1587,  1340,  1589,  2218,
    2219,  2220,  2038,  2221,  2222,  2223,  2224,  2225,  2226,  2052,
    4607,   410,   410,   410,  2191,  4791,  2086,  2221,  2222,  2223,
    2224,  2225,  2226,  2116,   825,   825,   825,  2119,  2939,  4960,
     674,  3568,  4961,  4964,  2768,  3021,  2125,  2123,  1935,  3838,
    1935,   674,  4966,  2126,  3946,  3845,  4983,  3602,  2819,  4989,
     674,  2819,  2132,  4990,  4319,  2819,  5003,  4784,  5004,  5022,
    3613,  3021,  4320,  2892,  3534,  3535,  3536,  2133,  3537,  3538,
    3539,  3540,  3541,  3542,  5101,  2141,  5102,  2915,  4965,  5112,
    2144,  5102,  4518,  2145,   673,   673,  2146,  2147,  2151,  1710,
     247,  2153,  2156,  2231,  1935,  2157,  4321,  2158,   362,  2159,
    2164,  2166,  2167,  2168,  4857,  2169,   408,  2170,  2177,  2178,
     818,   818,   818,   674,  3987,  2180,   913,  2181,  3613,  1935,
    2182,  1101,  2183,  2184,  2185,  2186,  2187,  2262,  2274,  1422,
    2258,  2284,  2294,  2303,  1640,  1642,  2332,  2334,  2344,  3868,
    1935,  3951,  2351,  2342,  2359,  3699,  1139,  2366,  1220,  2368,
    3962,  2370,   410,  1935,  2378,  2379,  2381,  2386,   884,  2397,
    2388, -2579,  2390,  2398,  2402,   825,  1102,   674,  2399,   674,
    2403,  3986,  1679,  4632,  4896,  2401,  2404,  1102,  4901,  4902,
    2405,   674,  2406,   674,  4860,  1679,  2433,  3722,  2439,  2427,
    2460,  3988,  4913,  2464,  2466,  3991,  3992,  1201,  3994,  2467,
    3996,  3997,  4101,  4102,  4103,  4104,  2470,  2468,  2469,  4002,
    1919,   819,   819,   819,  2495,  2496,  2503,  1935,  2505,  2515,
    2516,  2518,  2519,  1339,  2521,  2520,  2527,  2658,  4781,  2528,
    2529,  4900,   674,  1935,  4742,  2530,  2541,   891,  4897,  2544,
    2534,  2535,  2552,  2548,  4020,  2559,  1935,  2587,  2549,  1790,
    4903,   818,  4905,  2560,  2588,  2566,  -940,  2567,  2576,  2577,
    2589,  2592,   674,  2599,  2593,  2603,  2617,  2630,  2632,  2618,
    2633,  2643,  2137,  2148,  2645,  2646,  1187,  2659,  2154,   674,
    2662,  2663,   886,  2666,  2667,  1832,  3789,  2674,  2670,  2689,
    1473,  2694,  2709,  3530,   924,   893,   674,  3807,  2710,   674,
    2717,  2720,  2722,  2723,  2724,  2741,  2730,  1340,  2743,  2744,
    2745,    80,    80,  2746,    80,  1187,  2759,  2760,  1935,  2784,
    2807,  2785,  2801,  2816,  2826,  1187,  2859,  2831,   408,  2901,
    1340,  1187,  2902,  1187,  2914,  2858,  3386,  1679,  1935,  1187,
    3620,  3620,  1187,  1187,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,   819,  2864,  2920,  1187,  1187,  2202,  2924,  2925,
    4969,  2932,  2938,  1935,  2957,  4784,  2955,  2984,  1187,  3850,
    3000,  3001,  1187,  2114,   410,  2112,  1187,  3006,  3003,  3008,
    3011,  3022,  3023,  3012,  1107,  3031,  1187,   825,  3032,  1187,
    3033,  1187,  3034,  3042,  3062,  3065,  3064,  1340,  2248,  1935,
    1187,  1187,  1187,  3079,  3083,  3094,  1187,  3081,  3082,  1187,
    3099,  3102,  3104,  3123,  4834,  3124,  3106,  3107,  3113,  1187,
    1187,  3126,  3129,  3118,  3133,  3137,  3145,  3148,  3161,  3166,
    1187,  1590,   900,  3168,   901,  1594,  3222,  3217,  1187,  3230,
    1187,  3620,  3233,   903,  3234,  4877,  3246,  3423,  3284,  4070,
    3287,  3298,  3305,  3309,   905,  3310,  3306,  1953,  3311,  3315,
    4750,  3313,  3314,  3332,  3317,  3316,  1756,  3323,  3337,  4262,
    2195,  3325,  3334,   818,  3532,  3339,  3340,  3365,  3338,  3345,
    2200,  3379,   362,  1187,  3381,  3388,  3394,  3402,  3404,  1187,
    2238,   362,  3405,  3397,  3413,  1187,  3403,  3415,  1757,  4768,
    3418,  3430,  3433,  3434,  3435,  3436,  3438,  3439,  3448,  3451,
    5078,  3453,   362,  3454,  3463,  3464,  3465,  1339,  2598,  1340,
    1187,  3021,  2268,  2270,  2039,  3466,  1220,  1340,  1340,  3475,
    2832,  3483,  3489,  3533,  3491,  4010,  3497,  3468,  3495,  3517,
    1438,  3513,  2768,  3514,   408,  3494,  3498,  3499,   408,  3516,
     408,   674,  3518,  3521,  1758,  4021,  3665,  3552,  3522,  3564,
    3524,  3527,  3583,  3545,  3591,  1220,  3551,  3553,  3554,  3561,
    3576,  3578,  3628,  3577,   819,  3601,  3630,  3627,  -986,  3598,
    3622,  3672,  3681,  3677,  3691,  1759,  3687,  3675,  3696,  3693,
     410,  3702,  3692,  2045,   410,  1935,   410,  3697,  3712,  3705,
    3707,  3708,  3716,   825,  3719,  3713,  3721,   825,  3728,   825,
    3743,  3744,   673,  3754,  3424,  3755,  3762,  3770,  3761,  3772,
    3809,  1760,  3810,  3813,    74,  3816,   408,  1679,  3829,  3832,
    3817,  3815,  3824,  3822,  3823,   674,  3825,  3826,   674,  3834,
    3836,  3840,  3827,  3828,  2114,  1004,  3830,  1004,  3831,  1004,
    3842,  1761,  3833,  3835,  3837,  1004,  1420,  1421,  3844,  3846,
    2585,  3848,  3854,  3860,  3861,  3423,  3864,  3879,  3880,  3215,
    2362,  4239,   410,  3892,  3888,  3931,  3893,  2191,  1004,  1004,
    3924,  3925,  3934,  3936,  1756,   825,  3938,  4108,  4110,   818,
    3946,  3957,  3961,   818,  3945,   818,  4403,  1780,  3954,  4980,
    3958, -2637, -2637,  1781,  3537,  3538,  3539,  3540,  3541,  3542,
    2364,  2365,  1187,  3984,  3964,   209,  1757,  3993,  3952,  1764,
    4003,  4004,  4009,  4017,  4005,  1765,  3995,  2537,  4014,  4006,
    4015,  4016,  1766,  4026,  2134,   674,   674,  4031,  3986,  1935,
    2479,  3530,   674,  1782,  4420,  3548,  3547,  4310,  2196,  1768,
    4061,  4062,  4423,  4424,  4063,  4069,  4077,  1769,  4089,  4117,
    4090,  2569,  4131,  2201,  4098,  4134,  2202,  4151,  4140,  4160,
    4157,   818,  1758,  4205,  4184,  1935,  1187,  1187,  4152,  4207,
    4174,  4208,  4219,  4150,  2892,  2892,  4153,  4220,  4222,  2892,
     819,  2205,  1783,  4156,   819,  4224,   819,  2206,  1004,  1784,
    2616,  4233,  1785,  1759,  4243,  4244,  4245,  4214,  1770,  4977,
    4246,  4529,  3426,  3976,  4256,  4257,  4258,  1702,  4274,  2114,
     674,  2207,  4259,  4260,  2638,  1339,  4261,  4290,  4292,  2892,
    2892,  4228,  3424,  4295,  4303,  4301,  4353,  1187,  4527,  1760,
    4304,  4361,  4364,  4327,  4380,  4371,  3620,  3976,  4381,  1679,
    3620,  4369,  4376,  4398,  4400,  1786,  4383,  2789,  4401,  4415,
    4384,  4412,  1004,  4411,  4417,  2661,  4419,  4425,  4430,  1761,
    4433,  4442,   819,  4434,  1187,  1220,  4435,  4436,  4437,  4445,
    4454,  4455,  4456,  3581,  1187,  1187,  4449,  1935,  2685,  4457,
    4560,  4279,  1187,  1187,  4282,  4462,  4450,  1187,  1935,  4520,
    4458,  4488,  4496,  1187,  1187,  4484,  4489,  1187,  4486,  4499,
    4501,  4502,  1787,  4504,  1788,  4505,  4519,  4523,  4528,  4530,
    4536,  4544, -2637,  4535,  1789,  1187,  2209,  4558,  2733,  1187,
    4555,  4559,  1790,   209,  4565,  4576,  4583,  3425,  4588,  1187,
    4579,  1791,  4615,  1765,  1187,  4595,  4618,  2210,  2211,  4625,
    1766,  3633,  4633,  4638,  3528,  3529,  1187,  4547,  2479,  3544,
    4643,  4645,  4649,  4651, -2637,  4660,  4662,  1768,  4668,  4670,
    4671,    80,  4687,  4679,    80,  1769,  4695,  4703,  1793,  4696,
    4698,  4706,    81,  4705,  4707,  4714,   408,  4708,  4563,  4564,
    4721,  4724,  4515,  2214,  4734,  1187,  4744,  4627,  4378,  3579,
    3580,  4736,  4782,  1794,  4730,  4756,  2215,  4740,  4759,  2835,
    4760,  4765,  4777,  1935,    79,  4770,  4771,  4778,  4789,  4360,
    4795,   671,  4804,  4802,  4805,  4827,  1770,  4808,  4807,  4828,
    3426,  4836,   410,  4809,  4826,  4837,  4830,   362,  4832,    74,
      74,  1935,    74,  4853,  4861,   825,  2201,  4867,  4876,  2202,
    4593,  4594,   674,  4884,  1108,  4918,  2836,  1935,  1004,  4893,
    4923,  1795,  4927,  4928,   674,  4930,  2203,  4932,  4933,  4938,
    4945,  4946,  4947,  4952,  2205,  4953,  3474,  4958,  4963,   362,
    2206,  4962,  2876, -2637,  4967,  2837,  4968,  4973,  4986,  4975,
    4898,  4993,  4994,  4635,  4991,  4997,  4999,  5002,  5007,  1006,
    4142,  5008,  5013,  1935,  2207,  5014,  2838,  5032,  5035,  5040,
    5037,  4995,  5051,  5043,  4996,  5050,  5069,  2839,   674,  1006,
    5055,  5081,  5097,  5106,  5100,  2929,  1120,  5110,  1778,  3383,
    3657,   818,  3221,  2600,  2281,  3767,  2840,  4237,  3297,  3863,
    4307,  2841,  4909,  4783,  4992,  4829,  4372,  4831,  4630,  4817,
    1679,  3710,  5038,  3462,  4748,  5077,  5000,  5049,  4998,  4941,
    3715,  1187,  4368,  3363,  3364,  4236,  3779,  2686,  3346,  3941,
    5080,  5111,  1187,  4683,  5107,  4684,  4685,  2221,  2222,  2223,
    2224,  2225,  2226,  4806,  3889,  3867,  4688,  2842,  5053,  4769,
    2669,  4988,  5041,  3613,  4772,  1023,  3005,  3613,  4879,  4431,
    2106,  4407,  3174,  4951,  4408,  2208,  3843,  5062,  2843,  2209,
    5108,  1604,  4936,  3016,  2774,  3017,  3662,  3620,  4390,  4521,
    1935,  1341,  3620,  3039,  4170,  3620,  2053,  1626,  3458,  2300,
    2210,  2211,   819,  3663,  3041,  2329,  3673,  3671,  3040,  3686,
     362,   674,  2328,   369,  4494,  3674,  4483,  2212,  4112,   369,
    1004,  2333,  4869,  1187,   667,  1004,  1004,  1935,  2338,  4109,
    1612,  4171,  1187,  3620,  4081,  4859,  4071,   853,  5023,  5031,
    5024,  3666,  3596,  2213,  3594,  3508,  2214,  4167,  1153,  1187,
    1187,  2983,   369,  1187,  1993,  3985,  3432,  2726,  5021,  2215,
    2350,  1123,  2216,  1389,  2844,  3066,  1187,  2343,  2113,   673,
    2845,  1187,  4767,  3057,  1187,  1691,  2846,  1692,  4570,  1187,
    1187,  3070,  1720,  3652,  3073,  1710,  3071,    80,  4176,    80,
    4580,  4177,  4511,  2247,  2347,  3077,  4155,   369,  1146,  2360,
    2786,  1420,  1421,  3460,  2042,  2847,   674,  2848,   674,  4741,
      83,     0,  1187,     0,     0,  1201,     0,     0,     0,     0,
    2375,     0,  4738,     0,  2849,     0,  1427,  2382,  2384,     0,
       0,     0,     0,     0,   408,     0,  2217,     0,     0,     0,
       0,     0,     0,  1935,  1044,     0,     0,     0,     0,  2850,
    4821,  1187,  1044,     0,  1044,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   369,     0,     0,     0,
    3620,     0,     0,  1589,     0,  1679,     0,     0,     0,     0,
     410,     0,   674,     0,  1004,     0,     0,     0,     0,     0,
       0,     0,  1004,   825,  1187,  3183,  2892,     0,     0,  2892,
    2892,  2892,  2892,  2892,  2892,  2892,  2892,  2892,  2892,     0,
       0,     0,     0,  4855,     0,     0,     0,     0,     0,     0,
    3620,     0,     0,     0,     0,     0,  2218,  2219,  2220,  4068,
    2221,  2222,  2223,  2224,  2225,  2226,     0,     0,  3009,     0,
       0,     0,     0,  1004,  3010,     0,  1004,  1004,     0,  1187,
       0,  1935,     0,     0,     0,  4310,     0,     0,  2892,  2892,
       0,     0,     0,     0,     0,     0,     0,  3474,     0,  4881,
       0,     0,     0,  1187,  1935,     0,  1187,     0,  1187,   818,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   408,  1187,     0,     0,     0,  1187,
       0,     0,     0,  4908,  1935,     0,  4929,     0,     0,     0,
    1004,     0,     0,     0,     0,   369,     0,     0,     0,     0,
       0,     0,     0,  3320,     0,     0,     0,     0,     0,     0,
       0,  3320,     0,  4939,  3613,     0,     0,     0,  3336,  3613,
     410,     0,  3613,     0,  1935,     0,     0,     0,  1935,  1935,
     369,     0,     0,   825,     0,     0,     0,     0,     0,     0,
       0,     0,  3474,     0,  3474,     0,  4039,     0,     0,  4044,
    4045,  4046,  4047,  4048,  4049,  4050,  4051,  4052,  4053,     0,
     819,     0,     0,     0,     0,  1187,     0,  2201,  3389,     0,
    2202,     0,     0,     0,     0,  5096,     0,     0,     0,     0,
       0,   370,     0,     0,  1187,     0,     0,   370,     0,     0,
       0,     0,   668,     0,     0,  2205,  3417,     0,  2725,     0,
       0,  2206,  1340,     0,  1935,     0,     0,     0,  4093,  4094,
       0,  4957,     0,     0,     0,     0,     0,  5010,     0,   818,
     370,     0,     0,     0,     0,  2207,     0,     0,  3620,     0,
       0,     0,     0,     0,  1187,     0,     0,     0,     0,  1340,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    74,
       0,  1187,    74,     0,     0,     0,  2201,     0,     0,  2202,
       0,     0,  5039,     0,     0,   370,     0,     0,     0,     0,
     674,   362,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2205,     0,     0,  3592,     0,     0,
    2206,     0,  3484,  5054,     0,     0,  1187,     0,     0,     0,
       0,     0,     0,   366,     0,  5067,  5064,  1187,  5065,     0,
    5066,     0,     0,     0,  2207,     0,     0,     0,     0,     0,
     819,     0,     0,     0,     0,     0, -2637,     0,  1187,  1187,
    2209,   674,     0,  1780,   370,     0,     0,  5074,     0,  1781,
       0,  1187,     0,   366,     0,  5067,  5064,  3613,  5065,  2892,
    5066,  2210,  2211,  2865,  2866,     0,     0,     0,     0,     0,
       0,  2878,     0,     0,     0,  2881,  2882,   408, -2637,     0,
       0,     0,     0,     0,     0,     0,  4095,     0,     0,  1782,
    2903,     0,  2904,  1187,     0,  5109,     0,   366,     0,  5067,
    5064,     0,  5065,  1187,  5066,     0,     0,  2214,     0,     0,
       0,     0,     0,     0,  2926,     0,  2927,     0,     0,     0,
    2215,     0,     0,   410,   408, -2637,     0,     0,     0,  2209,
    2441,     0,   408,     0,     0,     0,   825,     0,  1783,     0,
       0,     0,     0,     0,     0,  1784,     0,     0,  1785,     0,
    2210,  2211,     0,     0,     0,  5088,     0,     0,     0,     0,
       0,     0,     0,  2442,   362,  1187,  2375, -2637,     0,     0,
     410,     0,     0,     0,  1187,     0,  2443,     0,   410,     0,
    1006,     0,  1006,   825,  1006,     0,     0,     0,     0,  2444,
    1006,   825,     0,   370,     0,  1340,  2214, -2637,  5087,     0,
       0,  1786,  5088,     0,     0,     0,     0,     0,     0,  2215,
    5088,     0,     0,  1006,  1006,     0,     0,     0,     0,     0,
       0,     0,   818,     0,     0,     0,     0,  2445,   370,  4356,
    1004,     0,     0,     0,     0,     0,     0,     0,  2446,  2892,
    2892,     0,     0,     0,     0,  5087,     0,     0,     0,     0,
       0,     0,     0,  5087,     0,   369,     0,  2447,  1787,   369,
    1788,     0,  2448,     0,     0,     0,     0,     0,     0,   818,
    1789,     0,     0,   667,     0,     0,     0,   818,  1790,   667,
       0,     0,     0,  1004,     0,     0, -2637,  1791,     0,   667,
       0,  2221,  2222,  2223,  2224,  2225,  2226,  3474,     0,     0,
       0,     0,     0,  1702,     0,    74,     0,    74,     0,     0,
       0,     0,  3726,     0,     0,  1340,     0,   667,     0,     0,
    1792,   667,     0,   819,  1793,     0,     0,     0,     0,  2449,
    1780,     0,   667,  1006,     0,     0,  1781,     0,     0,     0,
       0,     0,     0,     0,   362,     0,     0,   671,   671,  1794,
       0,     0,  1707,     0,     0,     0,   362,   667,     0,     0,
    2450,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     819,     0,   667,     0,     0,     0,  1782,   667,   819,     0,
    2221,  2222,  2223,  2224,  2225,  2226,     0,   667,   853,     0,
       0,     0,     0,     0,     0,     0,  5095,  1006,  3784,     0,
       0,   667,     0,     0,     0,     0,     0,  1795,     0,  4466,
    4467,     0,     0,  3804,     0,  3806,     0,     0,     0,     0,
       0,  2451,     0,     0,     0,  1783,     0,  2452,     0,  3812,
    2453,     0,  1784,     0,     0,  1785,     0,     0,  2201,     0,
     362,  2202,     0,     0,  1204,     0,     0,     0,     0,     0,
       0,     0,  1228,     0,     0,     0,  2454,     0,     0,     0,
    1240,     0,  2455,     0,     0,     0,  2205,     0,  1250,  3839,
    1004,     0,  2206,  1283,     0,  2456,     0,  3841,  1004,     0,
    1004,     0,     0,     0,     0,     0,     0,     0,  1786,     0,
       0,  1044,     0,   667,  3853,  1044,  2207,     0,     0,  3320,
    2457,     0,  3320,  3320,     0,     0,  3320,     0,     0,     0,
       0,     0,  3320,   369,     0,     0,     0,     0,     0,     0,
       0,  3877,     0,     0,     0,     0,  2201,  3886,     0,  2202,
       0,     0,     0,     0,  3877,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1787,  2203,  1788,  1340,     0,
    1340,     0,     0,     0,  2205,     0,     0,  1789,  4096,     0,
    2206,     0,     0,     0,     0,  1790,     0,     0,  3341,     0,
       0,     0,     0,     0,  1791,     0,     0,     0,     0,     0,
     667,   667,     0,     0,  2207,     0,  3944,     0,     0,     0,
       0,     0,  3183,  1006,     0,     0,     0, -2637,     0,     0,
    2892,  2209,     0,     0,     0,     0,     0,  1836,     0,  4702,
       0,  1793,  3971,  1340,     0,     0,     0,     0,     0,     0,
       0,  3989,  2210,  2211,     0,     0,  2892,  2892,  1456,     0,
       0,     0,    35,     0,     0,     0,  1837,     0,     0, -2637,
      41,    42,     0,   370,     0,     0,  2201,   370,     0,  2202,
       0,     0,  1780,     0,     0,     0,     0,     0,  1781,     0,
    1582,   668,     0,     0,     0,     0,  2203,   668,  2214,  2204,
       0,     0,     0,     0,  2205,     0,     0,   668,  1606,     0,
    2206,  2215,  1780,     0,     0,  2208,     0,     0,  1781,  2209,
       0,     0,     0,  4032,  1795,     0,     0,     0,  1782,     0,
    1632,     0,     0,     0,  2207,   668,     0,     0,     0,   668,
    2210,  2211,     0,  4038,     0,     0,     0,     0,  1004,     0,
     668,     0,     0,     0,     0,     0,     0,  2212,  1782,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4060,     0,
       0,     0,     0,     0,     0,   668,     0,  1783,     0,     0,
       0,     0,     0,  2213,  1784,     0,  2214,  1785, -2637,     0,
     668,     0,     0,     0,     0,   668,  4082,     0,     0,  2215,
    4694,     0,  2216,     0,  2114,   668,     0,  1783,     0,     0,
       0,     0,     0,     0,  1784,  1006,     0,  1785,   667,   668,
    1006,  1006,     0,     0,     0,     0,  4710,  4711,     0,     0,
       0,  1801,     0,   667,     0,  2208,     0,     0,  2201,  2209,
    1786,  2202,     0,     0,     0,     0,     0,     0,     0,     0,
    4147,     0,     0,     0,     0,     0,   667,     0,  2203,     0,
    2210,  2211,     0,     0,     0,     0,  2205,     0,     0,     0,
    1786,     0,  2206,     0,     0,     0,  2217,  2212,     0,     0,
    2892,     0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,
       0,     0,   667,     0,     0,     0,  2207,  1787,     0,  1788,
       0,     0,     0,  2213,     0,   671,  2214,   667,     0,  1789,
       0,   668,     0,     0,     0,     0,     0,  1790,     0,  2215,
     667,  1948,  2216,   667,     0,     0,  1791,  1787,     0,  1788,
       0,   370,     0,     0,     0,     0,     0,     0,     0,  1789,
       0,     0,     0,  1976,  1979,  1980,     0,  1790,  2375,  2201,
       0,  3655,  2202,  1004,     0,     0,  1791,     0,     0,  1862,
       0,     0,     0,  1793,     0,     0,  2218,  2219,  2220,  2203,
    2221,  2222,  2223,  2224,  2225,  2226,     0,  2205,     0,  1006,
       0,     0,  3523,  2206,     0,     0,     0,  1006,  1863,  2461,
       0,     0,     0,  1793,     0,     0,  2217,  2208,   668,   668,
       0,  2209,     0,     0,     0,     0,  3877,  2207,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2462,     0,
       0,     0,  2210,  2211,     0,     0,     0,     0,     0,  4263,
       0,     0,  4264,     0,  4265,     0,     0,     0,  1006,  2212,
       0,  1006,  1006,     0,     0,   667,  1795,     0,     0,     0,
    4856,     0,     0,   667,   667,     0,     0,     0,     0,     0,
       0,  1582,     0,     0,   369,  2213,     0,     0,  2214,     0,
       0,     0,     0,  3320,     0,     0,  1795,     0,  2118,  3320,
    3320,  2215,  2638,     0,  2216,     0,  2218,  2219,  2220,  1582,
    2221,  2222,  2223,  2224,  2225,  2226,     0,     0,     0,     0,
       0,     0,  3886,     0,     0,  1006,     0,     0,  2208,     0,
       0,     0,  2209,  4340,  4342,  4344,  4346,   369,   369,   369,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2210,  2211,     0,     0,     0,   667,     0,
       0,     0,     0,     0,  4375,     0,     0,     0,     0,     0,
    2212,     0,     0,     0,     0,     0,     0,  2201,  2217,     0,
    2202,     0,     0,     0,     0,     0,     0,     0,   369,     0,
       0,     0,     0,     0,     0,   369,  2213,  2203,     0,  2214,
       0,     0,   369,  4406,     0,  2205,     0,     0,     0,  1044,
       0,  2206,  2215,     0,     0,  2216,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   668,     0,     0,     0,
       0,     0,     0,     0,     0,  2207,     0,     0,     0,     0,
       0,   668,  1044,     0,     0,     0,     0,     0,     0,     0,
    2285,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   668,  4440,     0,     0,  2218,  2219,
    2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,
       0,     0,     0,     0,  3571,     0,     0,     0,     0,  2217,
       0,     0,     0,     0,     0,     0,     0,     0,  2339,  1004,
     668,     0,     0,     0,  3881,  3884,     0,     0,     0,     0,
       0,     0,  1004,     0,  2201,   668,     0,  2202,     0,     0,
       0,     0,     0,  2114,     0,     0,     0,     0,   668,     0,
       0,   668,   667,     0,  2203,     0,  2208,     0,     0,     0,
    2209,     0,  2205,  3930,     0,     0,     0,     0,  2206,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2210,  2211,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2207,     0,     0,     0,     0,     0,  2212,  2218,
    2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,  1780,
       0,  4516,  4517,  2923,     0,  1781,     0,     0,     0,     0,
       0,     0,     0,     0,  2213,     0,     0,  2214,     0,     0,
       0,     0,   369,    80,     0,     0,     0,     0,     0,     0,
    2215,     0,     0,  2216,  2497,     0,     0,     0,     0,     0,
       0,  2514,   667,     0,     0,  1782,     0,     0,  4548,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   667,     0,
       0,     0,     0,   668,     0,     0,     0,  2547,     0,     0,
    2550,   668,   668,     0,  1004,     0,  4562,     0,     0,     0,
       0,     0,   370,  2208,     0,     0,  2201,  2209,     0,  2202,
       0,     0,  4575,     0,  1783,   667,   667,     0,     0,     0,
       0,  1784,  2584,     0,  1785,     0,   667,  2217,  2210,  2211,
       0,     0,     0,     0,  2205,     0,  2602,     0,   667,   667,
    2206,     0,     0,     0,     0,  2212,     0,     0,     0,     0,
    2614,     0,     0,     0,     0,   370,   370,   370,  4592,     0,
     667,     0,  4590,  4591,  2207,     0,     0,     0,     0,     0,
       0,  2213,  3320,  3320,  2214,     0,   668,  1786,     0,  1340,
       0,     0,     0,  4609,     0,  1006,     0,  2215,     0,     0,
    2216,     0,     0,     0,     0,     0,     0,     0,  3886,  3886,
    3886,  3886,  3886,     0,     0,     0,   370,     0,     0,     0,
       0,     0,     0,   370,     0,     0,     0,  2218,  2219,  2220,
     370,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,     0,
       0,  3878,     0,     0,  1787,     0,  1788,     0,  1006,     0,
       0,     0,   671,     0,  1932,     0,  1789,     0,     0,     0,
    2706,     0,     0,  4653,  1790,     0,  2716,     0,  1707,   666,
       0,     0,     0,  1791,  2217,  2208,     0,     0,     0,  2209,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4672,     0,     0,     0,     0,     0,  4173,   816,     0,     0,
    2210,  2211,     0,     0,     0,     0,  2531,     0,     0,     0,
    1793,     0,  1756,  4440,  4440,  4440,  4440,  2212,     0,   369,
       0,  2201,  2114,     0,  2202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2532,     0,  2771,     0,     0,
       0,  2203,   816,     0,  1757,     0,  2214,     0,     0,  2205,
       0,     0,     0,     0,     0,  2206,     0,     0,     0,  2215,
     668,     0,     0,     0,  2218,  2219,  2220,     0,  2221,  2222,
    2223,  2224,  2225,  2226,     0,     0,     0,     0,  4033,  2207,
       0,     0,     0,     0,  1582,  1582,     0,     0,     0,  1043,
       0,     0,     0,  1795,  1004,     0,     0,  1043,     0,  1043,
    1758,     0,     0,     0,     0,     0,     0,     0,     0,   369,
       0,   816,     0,     0,     0,     0,  1004,  1932,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1759,     0,     0,     0,  1006,  2217,     0,     0,     0,
     370,     0,     0,  1006,  3877,  1006,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     668,     0,     0,   369,     0,   369,     0,  1760,  2201,     0,
       0,  2202,     0,     0,  3320,     0,   668,  1420,  1421,     0,
    2208,     0,     0,  1340,  2209,   667,  4324,  4787,  2203,  4788,
    3884,     0,  4792,  4793,     0,     0,  2205,  1761,     0,     0,
       0,  4339,  2206,     0,     0,  2210,  2211,     0,     0,     0,
       0,     0,   667,   668,   668,     0,   369,   667,  2982,     0,
     667,     0,  2212,     0,   668,     0,  2207, -2637, -2637,     0,
    2221,  2222,  2223,  2224,  2225,  2226,   668,   668,     0,     0,
       0,     0,   667,  3002,     0,     0,     0,     0,  2213,     0,
       0,  2214,     0,     0,     0,     0,     0,     0,   668,     0,
       0,   209,     0,  2478,  2215,  1764,     0,  2216,     0,  2114,
       0,  1765,     0,     0,     0,     0,     0,     0,  1766,     0,
    3015,     0,  3018,   667,     0,     0,  2479,     0,     0,     0,
       0,     0,     0,     0,  1044,  1768,     0,     0,     0,  3839,
       0,     0,     0,  1769,     0,     0,     0,     0,     0,     0,
     667,   667,     0,     0,  1780,     0,  1004,     0,     0,  1582,
    1781,     0,     0,     0,     0,     0,     0,  2208,     0,     0,
       0,  2209,     0,   369,   667,     0,   369,     0,     0,  2114,
       0,  2217,     0,  2114,  2114,     0,     0,     0,     0,     0,
       0,     0,  2210,  2211,  1770,     0,     0,  1044,     0,   667,
    1782,  4910,     0,   667,     0,     0,     0,     0,     0,  2212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   667,     0,  1006,     0,     0,     0,     0,  1932,     0,
       0,   667,     0,     0,     0,  2213,     0,     0,  2214,     0,
       0,     0,     0,     0,   667,     0,     0,   370,     0,  1783,
       0,  2215,     0,     0,   667,     0,  1784,     0,     0,  1785,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,     0,  2494,     0,     0,  4080,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2375,
       0,     0,     0,     0,     0,  2201,     0,     0,  2202,     0,
       0,  1932,  1786,     0,     0,     0,     0,   369,     0,     0,
       0,    74,     0,     0,     0,  1004,     0,     0,  2217,     0,
       0,  1340,     0,  2205,     0,     0,     0,   370,     0,  2206,
    3202,     0,     0,     0,     0,     0,  2201,     0,     0,  2202,
       0,     0,     0,     0,     0,  3223,     0,     0,     0,     0,
       0,     0,     0,  2207,     0,     0,  2203,     0,     0,  1787,
       0,  1788,     0,     0,  2205,     0,     0,  1004,   667,     0,
    2206,  1789,     0,     0,  1932,     0,     0,     0,     0,  1790,
       0,   370,     0,   370,  4573,  4574,     0,     0,  1791,  4577,
    4578,     0,     0,  1932,  2207,     0,     0,     0,     0,     0,
       0,     0,     0,   668,     0,   667,     0,     0,  2218,  2219,
    2220,  1932,  2221,  2222,  2223,  2224,  2225,  2226,  1006,     0,
       0,  3180,     0,     0,     0,  1793,     0,     0,     0,     0,
     668,     0,     0,     0,   370,   668,     0,     0,   668,  1932,
       0,     0,     0,     0,     0,     0,     0,  1004,     0,     0,
    1794,     0,   667,     0,  2208,     0,     0,     0,  2209,     0,
     668,     0,     0,     0,  5089,     0,  3884,  3884,  3884,  3884,
    3884,     0,     0,     0,  1004,     0,   667,     0,     0,  2210,
    2211,     0,     0,     0,     0,     0,     0,  3382,     0,  2201,
       0,     0,  2202,     0,     0,  2208,  2212,  3423,     0,  2209,
       0,   668,  1932,     0,     0,     0,     0,     0,  1795,  2203,
       0,  5089,     0,     0,     0,     0,  1756,  2205,     0,  5089,
    2210,  2211,  2213,  2206,     0,  2214,     0,     0,   668,   668,
       0,     0,     0,     0,     0,     0,     0,  2212,  2215,     0,
     816,     0,     0,     0,     0,     0,     0,  2207,  1757,     0,
       0,   370,   668,     0,   370,     0,     0,     0,   666,   369,
       0,     0,     0,  2213,   666,   369,  2214,     0,     0,     0,
       0,     0,     0,     0,   666,     0,     0,   668,     0,  2215,
       0,   668,  2216,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   668,
       0,     0,   666,     0,  1758,     0,   666,     0,     0,   668,
       0,  2201,     0,     0,  2202,  2217,     0,   666,     0,     0,
       0,     0,   668,     0,     0,     0,  2201,     0,     0,  2202,
       0,  2203,   668,     0,     0,  1759,     0,     0,     0,  2205,
       0,     0,   666,     0,     0,  2206,  2203,     0,  2208,  4737,
       0,   667,  2209,     0,  2205,     0,  2217,   666,     0,     0,
    2206,     0,   666,     0,  3424,     0,     0,     0,     0,  2207,
       0,  1760,   666,  2210,  2211,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2207,     0,   666,     0,     0,     0,
    2212,     0,     0,     0,     0,   370,     0,     0,     0,  1932,
       0,  1761,  1004,     0,     0,  2218,  2219,  2220,     0,  2221,
    2222,  2223,  2224,  2225,  2226,     0,  2213,     0,     0,  2214,
       0,     0,     0,     0,     0,     0,   667,     0,     0,     0,
       0,     0,  2215,     0,  2995,  2216,     0,     0,     0,     0,
       0,   667,   667,     0,  1006,     0,  2218,  2219,  2220,     0,
    2221,  2222,  2223,  2224,  2225,  2226,   668,  1006,     0,     0,
    4159,     0,     0,     0,     0,   209,     0,     0,   667,  1764,
    2208,   667,     0,     0,  2209,  1765,  1043,     0,   666,     0,
    1043,     0,  1766,     0,     0,  2208,     0,     0,     0,  2209,
    2479,     0,  3607,   668,     0,  2210,  2211,     0,     0,  1768,
       0,     0,     0,     0,     0,     0,     0,  1769,     0,  2217,
    2210,  2211,  2212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2213,     0,
     668,  2214,     0,     0,     0,     0,     0,     0,   369,   369,
     369,     0,     0,  2213,  2215,     0,  2214,  2216,  1770,     0,
       0,     0,  3426,     0,   668,   666,   666,   667,     0,  2215,
       0,     0,  2216,     0,     0,     0,     0,     0,   667,     0,
       0,     0,     0,     0,     0,     0,     0,   667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2218,
    2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,  1006,
    1780,     0,     0,  4186,     0,     0,  1781,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2217,     0,     0,     0,     0,     0,     0,     0,  2201,
       0,     0,  2202,     0,     0,     0,  2217,   370,     0,     0,
     667,     0,     0,   370,     0,     0,  1782,     0,     0,  2203,
       0,     0,     0,     0,     0,     0,     0,  2205,     0,     0,
       0,     0,     0,  2206,     0,     0,     0,     0,     0,     0,
       0,     0,  3169,     0,     0,     0,     0,  2494,  3176,   369,
    4955,     0,     0,     0,     0,     0,     0,  2207,     0,  1932,
       0,     0,     0,     0,   667,  1783,   667,     0,     0,     0,
       0,     0,  1784,     0,     0,  1785,     0,     0,   667,     0,
     667,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,     0,     0,     0,     0,  4443,  2218,  2219,  2220,   668,
    2221,  2222,  2223,  2224,  2225,  2226,  1780,     0,     0,     0,
    4477,     0,  1781,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1786,   667,
       0,     0,     0,   666,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   666,     0,
       0,     0,  1782,     0,     0,     0,     0,     0,  2208,   667,
       0,     0,  2209,     0,     0,     0,     0,     0,     0,     0,
       0,   666,     0,     0,   668,     0,   667,     0,     0,     0,
       0,     0,     0,  2210,  2211,  1787,     0,  1788,     0,   668,
     668,     0,     0,   667,     0,     0,   667,  1789,     0,     0,
    2212,  1783,  1932,     0,     0,  1790,     0,   666,  1784,     0,
       0,  1785,     0,     0,  1791,     0,   668,     0,     0,   668,
       0,     0,   666,     0,     0,     0,  2213,     0,     0,  2214,
       0,     0,     0,     0,     0,   666,     0,  1756,   666,     0,
    3922,  3923,  2215,     0,     0,  2216,     0,  3261,     0,     0,
       0,  1793,  5086,     0,     0,     0,  3932,     0,     0,  1006,
       0,     0,     0,     0,  1786,     0,     0,     0,     0,  1757,
    3940,   369,     0,     0,     0,     0,  3262,  2494,     0,  3949,
       0,  1006,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3965,     0,     0,   370,   370,   370,  5086,
       0,     0,     0,     0,     0,     0,     0,  5086,     0,     0,
       0,     0,     0,     0,     0,   668,     0,     0,     0,  2217,
       0,  1787,     0,  1788,     0,  1758,   668,     0,     0,     0,
       0,     0,     0,  1789,  1795,   668,     0,     0,     0,     0,
       0,  1790,     0,     0,     0,     0,     0,     0,     0,     0,
    1791,     0,     0,     0,     0,     0,  1759,     0,     0,     0,
     666,     0,     0,     0,  1582,     0,     0,     0,   666,   666,
       0,     0,     0,     0,     0,     0,  1932,     0,     0,   816,
       0,     0,     0,  3300,     0,     0,     0,  1793,     0,     0,
       0,     0,  1760,     0,     0,     0,     0,     0,   668,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2218,
    2219,  2220,  3301,  2221,  2222,  2223,  2224,  2225,  2226,     0,
       0,     0,  1761,  4704,     0,     0,     0,     0,     0,     0,
    2201,     0,   816,  2202,     0,     0,     0,   370,     0,     0,
       0,  2201,     0,     0,  2202,     0,     0,     0,   667,  1762,
    2203,     0,   668,   666,   668,     0,     0,     0,  2205,     0,
       0,     0,     0,     0,  2206,     0,   668,     0,   668,  2205,
    1795,     0,     0,     0,     0,  2206,     0,     0,     0,     0,
       0,  1006,  1763,  4105,  4106,  4107,   209,   369,  2207,     0,
    1764,   369,     0,   369,     0,  2201,  1765,   816,  2202,  2207,
       0,     0,     0,  1766,  1043,  1930,     0,     0,     0,     0,
       0,  1767,     0,     0,     0,  2203,     0,   668,     0,     0,
    1768,     0,     0,  2205,     0,     0,     0,     0,  1769,  2206,
       0,     0,   667,     0,     0,   667,     0,  1043,     0,     0,
       0,     0,     0,  2995,  2995,  2995,     0,   668,     0,     0,
       0,     0,     0,  2207,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   668,     0,     0,     0,     0,   369,
       0,  2201,     0,     0,  2202,     0,     0,     0,     0,  1770,
       0,   668,     0,  2201,   668,     0,  2202,     0,     0,  2208,
       0,     0,     0,  2209,     0,     0,     0,     0,     0,  2205,
    2208,     0,     0,     0,  2209,  2206,     0,     0,     0,     0,
       0,  2205,     0,     0,  2210,  2211,     0,  2206,     0,     0,
       0,     0,     0,     0,     0,  2210,  2211,   666,     0,  2207,
       0,  2212,   667,   667,     0,     0,     0,     0,     0,   667,
       0,  2207,  2212,     0,     0,     0,     0,     0,     0,  1780,
    1006,     0,     0,     0,  2208,  1781,     0,  2213,  2209,   370,
    2214,     0,     0,     0,     0,     0,     0,     0,  1930,     0,
       0,  2214,     0,  2215,     0,     0,  2216,     0,     0,  2210,
    2211,     0,     0,     0,  2215,     0,  1932,     0,     0,     0,
       0,  4099,     0,     0,     0,  1782,  2212,     0,     0,     0,
       0,     0,  1006,  4475,     0,     0,     0,   816,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   667,     0,     0,
       0,     0,  2213,     0,     0,  2214,     0,   666,  2494,  3176,
   -2637,  3176,     0,     0,  2209,     0,     0,     0,  2215,     0,
       0,  2216, -2637,   666,  1783,     0,  2209,     0,     0,     0,
    2217,  1784,     0,     0,  1785,  2210,  2211,     0,     0,     0,
       0,  2217,     0,     0,     0,     0,  4336,  2210,  2211,     0,
       0,     0, -2637,     0,     0,     0,     0,     0,     0,     0,
     666,   666,  1006,     0, -2637,  4362,     0,  1932,     0,  1932,
       0,   666,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2214,     0,   666,   666,     0,     0,  1786,     0,  1006,
       0,  2267,  4379,  2214,  2215,  2217,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   666,  2215,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   668,     0,     0,     0,
    2218,  2219,  2220,  1932,  2221,  2222,  2223,  2224,  2225,  2226,
       0,  2218,  2219,  2220,  4746,  2221,  2222,  2223,  2224,  2225,
    2226,     0,     0,     0,  1787,     0,  1788,     0,  1932,     0,
       0,     0,     0,     0,     0,   370,  1789,     0,     0,   370,
       0,   370,     0,     0,  1790,     0,     0,     0,     0,  3176,
       0, -2637,     0,  1791,     0,     0,     0,     0,     0,     0,
       0,     0,  3176, -2637,     0,  2218,  2219,  2220,     0,  2221,
    2222,  2223,  2224,  2225,  2226,     0,     0,     0,     0,  4800,
     668,     0,     0,   668,     0,     0,  3748,     0,     0,   369,
    1793,     0,     0,     0,  1780,     0,     0,     0,     0,  1930,
    1781,     0,     0,     0,     0,     0,     0,     0,     0,   667,
       0,     0,     0,     0,     0,  3749,     0,   370,     0,     0,
       0,   667,     0,     0,     0,  1816,  1932,     0,     0,     0,
       0,     0,     0,     0,   816,     0,  4478,  4479,  4480,  4481,
    1782,     0,  3176,     0,     0,  2221,  2222,  2223,  2224,  2225,
    2226,     0,     0,  1930,     0,  1932,     0,  2221,  2222,  2223,
    2224,  2225,  2226,     0,     0,     0,     0,     0,     0,     0,
       0,  1817,     0,  1795,     0,   667,     0,     0, -2143,     0,
     668,   668,  1930,     0,     0,  2201,     0,   668,  2202,  1783,
       0,     0,     0,     0,     0,     0,  1784,  1006,     0,  1785,
    2201,     0,     0,  2202,     0,  2203,     0,     0,     0,     0,
       0,     0,     0,  2205,     0,     0,     0,     0,     0,  2206,
    2203,     0,     0,     0,     0, -2143,     0,  1932,  2205,     0,
       0,     0,     0,     0,  2206,     0,     0, -2143,     0,     0,
       0, -2143,     0,  2207,     0,     0, -2143,  1932,     0,  1818,
       0, -2143,  1786,     0, -2143,  1930, -2143,     0,  2207,     0,
       0,     0,     0,     0,     0,   668,     0,     0,     0,     0,
       0,     0,  1932,     0,  1930,     0,     0,     0,     0,     0,
       0,     0,     0, -2143,     0,     0,     0,     0,     0,     0,
       0,     0,  1930,     0,     0,     0,     0,  1819,   667,  1820,
     666,     0,     0,     0,     0, -2143,     0,     0,  1932,  1821,
       0,  1788,     0,     0,     0,     0,     0,     0,     0,     0,
    1930,  1789,     0,     0,     0,     0,     0,   666,     0,  1790,
       0,   816,   666,     0,     0,   666,     0,  1822,  1791,     0,
       0,     0, -2143,     0,  2208,     0,     0,     0,  2209,  2995,
   -2143,     0,     0,     0,     0,     0,     0,   666,     0,  2208,
       0,     0,     0,  2209,     0,     0,     0,     0,     0,  2210,
    2211,  1823,     0,     0,     0,  1793,  1824,     0,     0,     0,
       0,     0,     0,  1930,  2210,  2211,  2212,     0,     0,     0,
       0,     0,     0,   667,     0,   667,     0, -2143,   666,     0,
    1825,  2212,     0,     0,     0,     0,     0,     0,     0,  1043,
       0,  1826,  2213,     0,     0,  2214,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   666,   666,  2213,  2215,     0,
    2214,  2216,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   712,  1019,  2215,     0,     0,  2216,     0,   816,   666,
    4678,   816,     0,     0,     0,     0,     0,     0,  1795,     0,
       0,     0,     0,     0,     0,     0, -2143,   369,     0,   667,
       0,     0,  1043,     0,   666,     0,     0,   370,   666,   712,
       0,     0,     0,     0,     0,  4956,     0,     0,     0, -2143,
       0, -2143, -2143,     0,     0,     0,   666,   668,     0,     0,
     712,     0,     0,     0,  3176,  2217,   666,     0,     0,   668,
       0,     0,     0,     0,     0,     0,     0,     0,  1015,   666,
    2217,     0,     0,     0, -2143,     0,     0, -2143, -2143,   666,
   -2143,  1016,     0,     0,    85,     0,     0,     0,     0,  1024,
      89,  1780,     0,     0,    93,     0,    94,  1781,    96,    97,
       0,     0,     0,     0,     0,  1035,     0,  1015,     0,   106,
       0,  1056,     0,   668,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,     0,   119,   120,     0,  1091,
    1930,     0,     0,     0,     0,     0,     0,  1782,     0,     0,
       0,     0,   816,     0,     0,  2218,  2219,  2220,     0,  2221,
    2222,  2223,  2224,  2225,  2226,     0,     0,     0,     0,  5009,
    2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,
       0,     0,   128,     0,  5098,     0,     0,   369,     0,     0,
       0,     0,   129,     0,   130,   131,  1783,     0,     0,     0,
       0,     0,     0,  1784,     0,     0,  1785,     0,  1932,  1119,
       0,     0,     0,   666,     0,     0,     0, -2145,     0,     0,
    4798,     0,     0,     0,     0,     0,     0,     0,     0,   141,
       0,   142,   143,     0,     0,     0,     0,   146,     0,   147,
       0,     0,     0,     0,  2494,     0,   668,     0,     0,   149,
     666,   150,     0,     0,     0,     0,     0,  1582,     0,  1786,
       0,     0,     0,     0, -2145,   153,     0,   154,     0,     0,
     157,     0,     0,     0,  1922,     0, -2145,     0,     0,     0,
   -2145,     0,   158,     0,   159, -2145,     0,     0,   160,     0,
   -2145,     0,     0, -2145,   161, -2145,     0,   666,     0,     0,
       0,     0,   163,     0,   165,     0,     0,     0,     0,     0,
     167,     0,     0,     0,     0,     0,  1787,     0,  1788,     0,
       0,   666, -2145,     0,   171,     0,     0,     0,  1789,     0,
       0,     0,     0,     0,     0,     0,  1790,   667,     0,     0,
       0,   668,     0,   668, -2145,  1791,     0,     0,     0,     0,
       0,  4888,     0,     0,     0,     0,  1932,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1932,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3790,   184,
     185, -2145,  1793,     0,     0,   186,     0,     0,     0, -2145,
       0,     0,     0,     0,   187,     0,     0,     0,   667,     0,
       0,     0,     0,     0,   816,   192,     0,  3791,  2995,     0,
     816,  2201,     0,  2995,  2202,   370,     0,   668,     0,     0,
       0,     0,     0,  1930,     0,  2995,     0,     0,  1930,  1930,
       0,  2203,     0,     0,     0,     0, -2145,  1922,     0,  2205,
    1930,     0,   203,     0,     0,  2206,     0,     0,     0,     0,
       0,     0,     0,     0,   205,     0,     0,     0,     0,   206,
     207,     0,   208,     0,     0,  1795,     0,   209,     0,  2207,
       0,     0,   210,     0,     0,   212,     0,     0,     0,   214,
     369,  1019,  1932,     0,   215,   216,     0,     0,     0,     0,
       0,     0,   217,     0,     0,   219,   666,     0,     0,     0,
       0,     0,     0,   222,     0, -2145,     0,     0,     0,     0,
    1932,     0,     0,     0,     0,   224,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1932,   369, -2145,     0,
   -2145, -2145,   229,     0,   230,   369,     0,     0,     0,   712,
       0,     0,   232,     0,     0,     0,     0,     0,   233,     0,
       0,     0,     0,   234,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2145,     0,   237, -2145, -2145,     0, -2145,
    2208,   666,  1932,     0,  2209,   370,     0,     0,     0,     0,
       0,     0,     0,  1930,     0,     0,   666,   666,     0,     0,
       0,     0,     0,     0,     0,  2210,  2211,     0,     0,   247,
       0,     0,     0,  -136,     0,     0,     0,     0,     0,     0,
       0,     0,  2212,   666,     0,     0,   666,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2213,     0,
       0,  2214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2215,     0,     0,  2216,  1930,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2201,     0,     0,  2202,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4676,
       0,     0,     0,   816,   816,   816,  2203,     0,     0,     0,
       0,     0,     0,     0,  2205,     0,     0,     0,  1922,     0,
    2206,     0,   666,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   666,     0,   668,  1932,     0,     0,     0,
       0,  2217,   666,     0,  2207,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1183,  1189,  1189,   712,     0,
    1189,     0,  1197,     0,  1183,     0,  1086,  1930,     0,  1222,
       0,     0,  1922,     0,  1086,     0,  1086,     0,     0,     0,
    1189,     0,  1086,     0,     0,     0,     0,     0,     0,     0,
    1252,     0,     0,     0,     0,  1086,   668,  1183,     0,     0,
    1189,  1922,   712,     0,  1189,   666,     0,     0,     0,     0,
       0,  1222,     0,     0,  1309,     0,     0,     0,     0,     0,
       0,  1189,     0,     0,  3547,     0,     0,     0,     0,  3548,
       0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,
    2226,     0,     0,  4154,   816,  2208,     0,     0,     0,  2209,
       0,     0,  3176,  1183,     0,     0,     0,     0,   712,   666,
       0,   666,     0,  1183,     0,     0,     0,  1222,     0,     0,
    2210,  2211,     0,   666,  1922,   666,  1253,     0,   370,     0,
       0,     0,  1189,     0,     0,     0,     0,  2212,     0,     0,
       0,     0,     0,  1922,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1254,
       0,  1922,     0,  2213,     0,     0,  2214,     0,     0,     0,
       0,     0,  1255,  1256,   666,   370,     0,     0,     0,  2215,
       0,  1257,  2216,   370,     0,  1258,     0,  1086,     0,  1922,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1086,  1457,  1259,     0,   666,     0,     0,     0,     0,     0,
    3176,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   666,     0,  1260,     0,     0,     0,  1564,     0,     0,
       0,   712,  1086,  1932,  1261,     0,     0,  2201,   666,     0,
    2202,   666,  1262,     0,     0,     0,     0,     0,     0,     0,
    1086,     0,  1922,  1263,  1086,     0,  2217,  2203,  1264,     0,
       0,     0,  1564,  1932,     0,  2205,     0,     0,     0,     0,
       0,  2206,  1086,     0,     0,     0,     0,  2201,     0,  1265,
    2202,     0,     0,     0,  1086,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2207,     0,  2203,     0,     0,
       0,     0,     0,  1932,  1266,  2205,     0,  1932,  1932,     0,
       0,  2206,     0,     0,     0,     0,   816,     0,     0,     0,
       0,     0,     0,     0,     0,  1267,     0,  1930,     0,     0,
       0,     0,     0,     0,     0,  2207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2218,  2219,  2220,  1924,
    2221,  2222,  2223,  2224,  2225,  2226,  1268,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1086,     0,     0,  1930,
    1930,     0,  1930,  1086,     0,  1189,  1189,     0,     0,     0,
       0,     0,     0,  4676,   853,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2208,     0,     0,     0,
    2209,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1269,     0,     0,  5072,  1270,     0,  1271,     0,     0,
    1183,  2210,  2211,  1272,     0,     0,  1273,     0,  1930,     0,
    1930,  1183,     0,     0,     0,  1222,  2208,     0,  2212,     0,
    2209,     0,     0,     0,     0,     0,     0,     0,  1189,  1922,
       0,     0,  1274,     0,  1275,     0,     0,     0,  1276,     0,
       0,  2210,  2211,  1086,  2213,     0,  1277,  2214,     0,  1189,
    1189,  1278,     0,     0,     0,     0,     0,     0,  2212,     0,
    2215,     0,     0,  2216,  1930,  1086,  1086,  1086,     0,  1189,
       0,  1183,     0,   666,     0,  1990,  1279,     0,     0,     0,
       0,     0,  4072,     0,  2213,     0,     0,  2214,     0,  1930,
       0,     0,  1924,     0,     0,     0,     0,     0,     0,     0,
    2215,     0,     0,  2216,  1189,     0,  1189,  1189,     0,     0,
    1930,     0,   816,     0,     0,     0,   816,     0,   816,     0,
    5073,     0,     0,  1930,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2158,     0,     0,  2217,     0,     0,
    1564,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4073,     0,     0,     0,     0,     0,   666,     0,     0,
     666,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2217,  2089,  2089,
       0, -2158,     0,  1086,     0,  1015,     0,  1930,     0,     0,
       0,     0,     0, -2158,   816,     0,     0, -2158,     0,     0,
    1086,     0, -2158,  1930,     0,     0,     0, -2158,  2124,     0,
   -2158,  1086, -2158,     0,  2130,     0,  1930,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1564,  2218,  2219,  2220,
       0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0, -2158,
       0,     0,     0,   838,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1564,     0,   666,   666,     0,
       0, -2158,     0,     0,   666,     0,     0,  2218,  2219,  2220,
       0,  2221,  2222,  2223,  2224,  2225,  2226,  2201,     0,     0,
    2202,     0,     0,  1564,  1564,     0,  1564,     0,  1930,   839,
       0,     0,     0,     0,     0,     0,     0,  2203, -2158,     0,
    3510,     0,   840,  1564,     0,  2205, -2158,     0,  1930,     0,
       0,  2206,  1922,     0,     0,     0,     0,  1922,  1922,   841,
       0,     0,     0,   712,   712,   842,     0,     0,     0,  1922,
       0,     0,     0,  1930,     0,  2207,     0,     0,     0,     0,
     843,     0,   666,     0,     0,     0,     0,     0,     0,     0,
       0,   844,  1086, -2158,     0,  1564,     0,     0,     0,   845,
       0,     0,     0,  1924,     0,     0,     0,     0,     0,  1930,
     846,     0,     0,     0,     0,   847,     0,     0,     0,     0,
       0,   848,     0,     0,  1564,     0,     0,     0,  1564,  1564,
       0,     0,     0,     0,     0,     0,   849,     0,  1019,  1086,
    1086,  2341,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1924,     0,     0,
       0,   850, -2158,     0,     0,     0,     0,     0,   712,     0,
       0,     0,     0,     0,     0,     0,  2208,     0,     0,     0,
    2209,     0,   851,     0,     0, -2158,  1924, -2158, -2158,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2210,  2211,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1922,   852,     0,     0,     0,     0,  2212,     0,
   -2158,     0,     0, -2158, -2158,     0, -2158,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   853,     0,     0,  2213,     0,     0,  2214,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1924,
    2215,     0,     0,  2216,     0,     0,  1086,  2502,   854,     0,
       0,     0,   855,  1086,   856,     0,  1189,     0,  1924,     0,
     857,     0,     0,   858,     0,     0,     0,  1922,     0,     0,
       0,     0,     0,  1222,   816,     0,  1924,     0,     0,  1086,
       0,     0,  1086,     0,     0,  1930,     0,     0,     0,   859,
       0,   860,     0,     0,   666,   861,  2201,     0,     0,  2202,
       0,     0,  1086,   862,  1924,     0,   666,     0,   863,     0,
    1189,  1189,  1189,  1189,  1086,     0,  2203,  2217,     0,     0,
     864,     0,     0,     0,  2205,     0,     0,     0,  1086,     0,
    2206,     0,     0,   865,     0,     0,     0,     0,     0,     0,
    2613,     0,  1086,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1189,  1189,  2207,     0,     0,     0,  1189,     0,
     666,     0,     0,     0,     0,     0,  1922,  1924,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1189,     0,     0,     0,  2218,  2219,  2220,
       0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1930,
    1189,  1189,  1189,  1189,     0,     0,     0,     0,     0,     0,
       0,     0,  1086,     0,     0,     0,     0,     0,  1086,     0,
       0,  2613,     0,     0,     0,  2208,     0,     0,     0,  2209,
       0,     0,     0,     0,     0,  1930,  1183,     0,     0,     0,
       0,     0,     0,   712,     0,  1183,     0,     0,     0,     0,
    2210,  2211,     0,   666,     0,  1222,     0,     0,     0,     0,
    1189,     0,     0,     0,     0,     0,     0,  2212,     0,  1189,
       0,     0,     0,     0,     0,  1189,  1189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1086,
       0,     0,     0,  2213,     0,     0,  2214,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2215,
       0,     0,  2216,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2089,     0,     0,  3525,     0,     0,     0,
    1189,     0,  1183,     0,  1924,     0,  1086,  1086,     0,  1189,
       0,     0,     0,     0,     0,  1086,     0,  1930,   666,     0,
     666,     0,     0,     0,     0,     0,     0,     0,  1930,     0,
       0,     0,  1015,  1015,     0,     0,  2834,     0,     0,     0,
    1564,  1564,     0,     0,     0,     0,     0,     0,  1564,     0,
       0,  1564,     0,     0,     0,  1564,  2217,     0,     0,     0,
       0,     0,     0,  1564,  1564,     0,     0,     0,     0,     0,
       0,  1564,     0,  1222,  1564,  1564,  1564,  1564,     0,     0,
       0,     0,     0,     0,  1564,  1564,     0,  1564,     0,  1564,
    1564,     0,   816,  1564,   666,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1564,     0,     0,     0,  1189,  1564,  1922,     0,     0,  1564,
       0,     0,     0,  1564,     0,  1564,  1564,  1564,  1564,  1564,
    1564,  1564,  1564,  1564,     0,  1564,     0,     0,     0,     0,
    1086,  1564,  2201,  1930,  1564,  2202,  2218,  2219,  2220,     0,
    2221,  2222,  2223,  2224,  2225,  2226,     0,     0,  1922,  1922,
       0,  1922,  2203,     0,     0,  1086,     0,     0,     0,     0,
    2205,  1930,     0,     0,     0,     0,  2206,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1930,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2207,     0,  1086,     0,  1086,     0,  1564,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1922,     0,  1922,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1930,     0,     0,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,     0,     0,  3048,     0,  3055,
       0,     0,   816,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1922,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3560,     0,  1924,     0,     0,
       0,     0,  1924,  1924,     0,     0,     0,     0,  1922,     0,
       0,  2208,     0,     0,  1924,  2209,     0,     0,     0,     0,
       0,     0,     0,   712,     0,     0,     0,     0,  1015,  1922,
    1015,     0,     0,     0,     0,     0,  2210,  2211,     0,     0,
       0,     0,  1922,     0,     0,     0,     0,  1564,     0,     0,
       0,     0,     0,  2212,     0,     0,     0,     0,  1183,     0,
    1189,  1189,  1189,     0,     0,  1183,     0,  1222,     0,  1189,
       0,  1189,     0,  1189,  1189,     0,     0,  1086,     0,  2213,
       0,     0,  2214,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2215,     0,  1930,  2216,     0,
       0,     0,     0,     0,     0,     0,  1922,     0,     0,     0,
       0,     0,   666,     0,     0,  2502,     0,     0,     0,     0,
       0,  3184,  1922,     0,     0,     0,  3193,     0,     0,     0,
       0,     0,  1086,     0,     0,  1922,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1086,     0,     0,
       0,  3228,  3228,     0,     0,     0,     0,  1924,   712,     0,
       0,     0,     0,     0,     0,     0,     0,  2201,     0,     0,
    2202,     0,  2217,   666,     0,     0,  1189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2203,     0,     0,
    3555,     0,     0,     0,     0,  2205,     0,     0,     0,     0,
       0,  2206,  3286,     0,  3289,  3291,     0,  1922,     0,     0,
       0,     0,     0,  1930,     0,     0,     0,     0,     0,     0,
    2201,     0,     0,  2202,     0,  2207,     0,  1922,     0,     0,
       0,     0,  1924,     0,  1189,     0,     0,     0,     0,     0,
    2203,     0,  1189,  3566,     0,     0,     0,  1189,  2205,     0,
       0,     0,  1922,     0,  2206,   816,     0,     0,     0,     0,
    1564,     0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,
    2225,  2226,     0,     0,     0,     0,     0,     0,  2207,     0,
       0,     0,     0,     0,  2502,     0,     0,  3228,  1922,  1086,
       0,  3384,     0,     0,  1015,     0,     0,     0,     0,     0,
       0,     0,   816,     0,     0,     0,     0,     0,     0,     0,
     816,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3286,  1930,     0,     0,     0,     0,  2208,     0,  1189,  3409,
    2209,  1924,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1990,     0,     0,  1930,     0,     0,     0,     0,     0,
       0,  2210,  2211,     0,     0,     0,     0,     0,  1189,     0,
    1189,  3228,  1189,  3228,     0,     0,     0,     0,  2212,     0,
       0,     0,     0,     0,  1930,     0,     0,     0,     0,  2208,
       0,     0,     0,  2209,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,  2213,     0,     0,  2214,     0,     0,
       0,     0,     0,     0,  2210,  2211,  2089,     0,     0,     0,
    2215,     0,     0,  2216,  1930,     0,     0,     0,  1930,  1930,
       0,  2212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2213,     0,     0,
    2214,     0,  1183,     0,     0,     0,     0,     0,  1183,     0,
       0,     0,  2201,  2215,     0,  2202,  2216,     0,     0,  1189,
       0,     0,     0,     0,     0,  1564,  1564,     0,     0,     0,
       0,  1564,  2203,     0,  1922,     0,     0,  2217,     0,     0,
    2205,     0,     0,     0,     0,     0,  2206,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1564,  1564,     0,     0,
       0,  1564,     0,     0,     0,     0,     0,     0,     0,     0,
    2207,     0,     0,  1564,  1564,  1564,  1564,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1564,     0,     0,  1564,
    2217,  1564,  3575,     0,     0,     0,     0,     0,     0,     0,
       0,  1564,  1564,     0,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1564,     0,
    1564,     0,  1222,     0,  1564,     0,     0,  2218,  2219,  2220,
       0,  2221,  2222,  2223,  2224,  2225,  2226,     0,     0,     0,
    1564,     0,     0,     0,  1086,     0,     0,     0,     0,     0,
       0,  3621,     0,  1564,  1564,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2208,     0,     0,     0,  2209,     0,  1564,  1922,     0,
    2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,  2225,  2226,
    1564,  1924,     0,     0,     0,  1564,  2210,  2211,     0,     0,
       0,  1564,     0,     0,     0,     0,     0,     0,     0,  3621,
       0,     0,  3680,  2212,  1922,     0,  3055,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2201,  1924,  1924,  2202,  1924,     0,     0,  2213,
       0,  1780,  2214,     0,     0,     0,     0,  1781,     0,     0,
       0,     0,  2203,     0,     0,  2215,     0,     0,  2216,     0,
    2205,     0,     0,     0,     0,     0,  2206,     0,     0,  1564,
       0,  3228,  1816,     0,     0,     0,  2089,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,  1782,     0,     0,
    2207,     0,  1924,     0,  1924,     0,     0,     0,     0,     0,
       0,     0,  1189,     0,  1189,  1189,  1189,  2201,     0,     0,
    2202,     0,     0,     0,     0,     0,     0,     0,  1817,     0,
       0,     0,     0,     0,     0,     0,  1922,  2203,     0,     0,
    4079,     0,  2217,     0,     0,  2205,  1783,  1922,     0,     0,
       0,  2206,     0,  1784,     0,     0,  1785,     0,  1924,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4029,     0,
       0,     0,     0,     0,     0,  2207,     0,     0,     0,     0,
       0,     0,     0,  1924,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2208,     0,     0,  1924,  2209,  1818,     0,     0,  1786,
       0,     0,     0,     0,     0,     0,     0,  1924,     0,     0,
       0,     0,     0,     0,     0,     0,  2210,  2211,     0,     0,
       0,     0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,
    2225,  2226,     0,  2212,     0,     0,     0,     0,     0,     0,
       0,     0,  1925,     0,  1819,     0,  1820,     0,     0,     0,
       0,     0,  1922,     0,     0,     0,  1821,     0,  1788,  2213,
       0,     0,  2214,     0,     0,     0,  2208,     0,  1789,     0,
    2209,  1924,     0,     0,     0,  2215,  1790,     0,  2216,     0,
    1922,     0,  3228,  3228,  1822,  1791,     0,  1924,     0,     0,
       0,  2210,  2211,     0,     0,     0,  1922,     0,     0,     0,
    1924,     0,     0,     0,     0,  3885,     0,     0,  2212,   824,
       0,     0,     0,     0,     0,     0,     0,     0,  3249,     0,
       0,     0,  1793,  1824,     0,     0,     0,     0,     0,     0,
       0,     0,  1086,  1086,  2213,     0,     0,  2214,     0,     0,
       0,     0,  1922,     0,     0,     0,     0,  3250,  1086,     0,
    2215,     0,  2217,  2216,   824,     0,     0,     0,  1826,     0,
       0,  2089,  1086,     0,     0,     0,     0,     0,     0,     0,
    2089,  1086,  1924,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1086,     0,     0,     0,     0,
       0,     0,  1924,     0,     0,     0,     0,     0,     0,     0,
     712,  1047,     0,     0,     0,  1795,     0,     0,     0,  1047,
       0,  1047,     0,     0,     0,  1189,     0,  1924,  1189,     0,
       0,     0,     0,   824,     0,     0,     0,  2217,     0,     0,
       0,     0,     0,     0,     0,  1183,     0,     0,     0,     0,
       0,     0,  2218,  2219,  2220,     0,  2221,  2222,  2223,  2224,
    2225,  2226,     0,  1924,     0,     0,  1086,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1189,     0,     0,     0,
       0,     0,     0,     0,  1564,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1564,     0,     0,     0,     0,     0,
    1564,     0,  1564,     0,     0,     0,  1922,     0,  1564,     0,
       0,  1564,  1564,  1564,  1564,  1564,  1564,  1564,  1564,  1564,
    1564,     0,     0,  1925,  1564,  1564,     0,  2218,  2219,  2220,
       0,  2221,  2222,  2223,  2224,  2225,  2226,  1564,     0,     0,
       0,  1564,     0,     0,     0,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1564,     0,     0,  1564,     0,
    1564,     0,     0,     0,     0,     0,     0,     0,     0,  1564,
    1564,  1564,     0,     0,     0,  1564,     0,  1925,  1564,     0,
       0,     0,     0,     0,     0,  1086,  1086,  1086,  1183,  3621,
    4116,     0,     0,     0,  4116,  4130,     0,     0,     0,  1564,
       0,     0,     0,     0,     0,  4144,  1925,  1564,     0,  1564,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1922,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1564,     0,     0,     0,     0,     0,  1564,  1924,
       0,     0,  3055,     0,  1564,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4192,
    2089,  2089,     0,  2613,     0,     0,     0,     0,  1925,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1189,  1189,  1189,  1189,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1925,     0,     0,     0,     0,  4235,
       0,     0,     0,  1922,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   936,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   937,
       0,     0,     0,  1922,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     938,     0,     0,  1924,     0,     0,     0,  1925,     0,     0,
       0,     0,     0,   939,     0,     0,     0,     0,     0,     0,
       0,  4296,     0,  1922,     0,     0,   940,  1922,  1922,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1924,
       0,     0,     0,   941,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3885,     0,     0,     0,   942,     0,     0,     0,  1086,     0,
       0,     0,     0,     0,     0,   943,     0,     0,     0,  1189,
       0,  1564,     0,   944,     0,     0,     0,  1086,     0,     0,
       0,     0,     0,  4367,   945,     0,     0,     0,     0,   946,
       0,     0,  2502,     0,     0,   947,     0,     0,     0,     0,
       0,     0,     0,     0,  1086,     0,     0,     0,     0,     0,
     948,     0,     0,  3286,     0,     0,     0,     0,     0,  4396,
       0,     0,     0,  1188,  1190,     0,     0,  1193,     0,  1195,
       0,     0,     0,     0,     0,  1564,  1564,     0,     0,     0,
       0,  1924,     0,     0,     0,     0,     0,  1235,     0,     0,
       0,     0,  1924,     0,     0,     0,   949,     0,     0,     0,
    3228,     0,  3228,     0,     0,     0,     0,  1288,     0,     0,
       0,  1291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   950,  1314,     0,
       0,     0,     0,     0,  1925,     0,  1564,   951,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   853,     0,     0,     0,     0,
       0,     0,   824,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,  1564,     0,     0,     0,     0,     0,  1185,
       0,     0,   952,  1564,  1564,     0,   953,     0,   954,     0,
       0,  1564,  1564,     0,   955,     0,  1564,   956,     0,     0,
       0,     0,  1564,  1564,     0,     0,  1564,  1924,  1086,  1086,
    1086,  1086,  1185,     0,     0,  4116,  4130,  4116,     0,     0,
    4485,     0,     0,   957,  3621,   958,     0,     0,  3621,   959,
       0,     0,     0,     0,  4498,  1924,     0,   960,  1564,     0,
       0,     0,   961,  1564,     0,     0,     0,     0,     0,  4508,
       0,  1924,     0,     0,   962,  1564,     0,     0,     0,     0,
       0,     0,     0,     0,  1222,     0,     0,   963,  1185,     0,
       0,     0,  3680,     0,     0,     0,  3055,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1015,     0,     0,  1564,     0,     0,  1924,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3228,  3228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4561,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1189,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,  1189,  1047,     0,
       0,     0,  1047,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,     0,     0,
       0,     0,  1925,  1925,     0,     0,     0,  1185,     0,     0,
       0,     0,  1802,  1803,  1925,     0,  3885,  3885,  3885,  3885,
    3885,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1924,     0,     0,     0,     0,     0,     0,     0,     0,
    1564,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1183,     0,     0,     0,     0,  2502,     0,     0,     0,
       0,     0,     0,  2089,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1189,  2502,     0,     0,     0,
       0,     0,     0,     0,     0,  1892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1086,     0,  4682,     0,  1950,  1951,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1982,     0,     0,     0,
       0,     0,  1564,     0,     0,     0,     0,     0,     0,     0,
       0,  1564,     0,     0,     0,     0,     0,  1924,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,  1564,  1564,
       0,     0,  1564,  2015,  2017,  1185,     0,     0,     0,     0,
       0,  4116,     0,     0,     0,  3621,  1185,     0,     0,     0,
    3621,     0,     0,  3621,  3286,     0,  4726,     0,  1564,  1564,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1933,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4192,  1222,  1189,  1189,  1189,     0,     0,     0,     0,
       0,     0,  1925,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1924,     0,     0,     0,     0,
    1183,  1222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1924,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2089,
       0,     0,     0,  1183,     0,  1185,     0,     0,  1924,     0,
       0,     0,  1086,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4367,     0,     0,     0,     0,     0,     0,
    3228,  1925,     0,     0,  2502,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4396,     0,  1924,  1086,
       0,     0,  1924,  1924,     0,     0,     0,  1189,  4192,     0,
       0,     0,  1933,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1564,     0,     0,  1564,     0,  1564,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1564,     0,     0,     0,  3621,     0,
       0,  4726,     0,     0,     0,     0,     0,  4875,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1189,
       0,     0,     0,  1086,     0,     0,     0,     0,  1185,  1185,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1189,  1189,  1189,  1189,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,  2089,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1183,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,     0,     0,     0,     0,     0,
    1185,   824,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,  1185,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,  1564,     0,     0,     0,     0,     0,  1189,
       0,  1222,     0,     0,     0,     0,     0,     0,     0,     0,
    1564,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2517,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1189,     0,     0,     0,     0,  1183,     0,     0,     0,     0,
       0,     0,     0,  1933,     0,     0,  4192,     0,     0,   824,
       0,  1925,     0,     0,     0,  4682,  1047,  2580,  2581,  2582,
    2583,     0,     0,     0,  4875,     0,     0,  1564,  1564,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   880,
    1183,     0,     0,     0,     0,     0,     0,     0,  1189,  1047,
       0,   881,     0,  1925,  1925,     0,  1925,  1933,     0,  2621,
    2622,     0,     0,     0,     0,  2631,     0,     0,     0,     0,
       0,     0,   882,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1564,     0,     0,   883,  1933,     0,     0,     0,
       0,     0,  1564,     0,   884,     0,     0,  1189,  -738,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2655,     0,  1925,     0,  1925,   885,     0,     0,     0,     0,
       0,   886,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   887,  2690,  2691,  2692,
    2693,     0,     0,     0,     0,     0,     0,   888,     0,     0,
       0,     0,     0,     0,  1564,   889,     0,     0,     0,  1933,
       0,     0,     0,  1183,     0,     0,   890,     0,  1925,     0,
       0,     0,     0,   891,     0,     0,     0,   892,  1933,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -940,  1925,     0,     0,  1933,  2752,  1927,     0,
       0,     0,     0,     0,     0,     0,  2756,     0,     0,     0,
       0,     0,     0,  2763,  1925,     0,     0,     0,     0,   824,
       0,     0,     0,     0,  1933,     0,     0,  1925,     0,     0,
       0,   893,     0,     0,     0,     0,     0,     0,  -502,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   894,
       0,     0,   895,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,  1933,     0,     0,
    1185,  1925,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -399,  1925,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1925,     0,     0,     0,   896,     0,     0,     0,     0,     0,
     897,     0,     0,     0,     0,     0,  -399,     0,     0,   898,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,     0,     0,     0,  -399,     0,   899,   900,     0,
     901,   902,     0,     0,     0,     0,     0,  1185,     0,   903,
       0,  2936,     0,     0,   904,     0,     0,     0,     0,     0,
     905,     0,  1925,   906,     0,     0,   907,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -399,
       0,     0,  1925,     0,     0,  1185,  1185,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,  1185,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,  1925,  1185,  1185,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,  1185,
    1185,  1185,  1185,     0,     0,     0,     0,     0,     0,  1185,
    1185,     0,  1185,     0,  1185,  1185,     0,     0,  1185,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1933,  1185,   824,     0,     0,     0,
    1185,     0,     0,     4,  1185,     0,     0,     0,  1185,     0,
    1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,     0,
    1185,     0,     0,     5,     0,     0,  1185,     0,     0,  1185,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     0,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3130,  3131,  3132,
       0,     0,    46,     0,     0,     0,  3142,     0,  3144,     0,
    3146,  3147,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,  1927,     0,     0,     0,
       0,     0,    47,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
       0,     0,  1185,     0,     0,  1927,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,    49,
    1185,     0,     0,  3254,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    50,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1047,     0,     0,     0,     0,     0,  1933,     0,     0,
       0,     0,  1933,  1933,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1933,     0,     0,    51,  1927,     0,
      52,  3312,     0,     0,     0,     0,     0,     0,     0,  3321,
     824,     0,     0,   824,  3322,    53,     0,  1927,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1047,  1927,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,     0,     0,  1927,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      54,     0,     0,     0,     0,  3407,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1927,  3443,     0,  3445,
       0,     0,    55,     0,     0,  1185,     0,  1933,     0,     0,
       0,     0,     0,     0,     0,     0,    56,     0,     0,     0,
       0,     0,     0,     0,   824,     0,     0,  1045,     0,     0,
       0,    57,     0,     0,     0,  1045,     0,  1045,     0,     0,
       0,  1925,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1925,     0,     0,     0,     0,    58,     0,     0,
       0,     0,     0,    59,     0,     0,     0,    60,    61,    62,
      63,    64,     0,     0,    65,    66,  1382,  2041,     0,     0,
       0,    71,  1933,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3500,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1933,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1927,     0,  1925,     0,  1185,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,  1925,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,  1185,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,  1185,     0,     0,     0,  1185,  1925,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,  1185,
    1185,  1185,     0,     0,     0,     0,   824,     0,     0,     0,
       0,  1185,   824,     0,  1185,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,  1185,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,  1185,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,  1185,  1185,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,  3729,
    1185,  3730,  3731,  3732,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,  1925,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,  1927,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,  1933,     0,  1927,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,     0,     0,
       0,     0,     0,  1933,  1933,     0,  1933,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,   824,   824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1933,     0,  1933,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1925,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1933,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,  1925,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,  1933,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1925,  1928,
       0,     0,     0,     0,  1933,     0,     0,     0,  1181,     0,
       0,     0,  3998,     0,     0,  3999,   824,  1933,     0,     0,
       0,  1927,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1925,     0,
       0,     0,  1925,  1925,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4025,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,  1933,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1933,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1933,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,  1933,     0,     0,     0,     0,     0,  1181,  1185,
       0,     0,     0,     0,  1045,  1185,     0,  1185,  1045,     0,
       0,     0,  1933,  1185,     0,     0,  1185,  1185,  1185,  1185,
    1185,  1185,  1185,  1185,  1185,  1185,     0,     0,     0,  1185,
    1185,     0,     0,  1181,     0,     0,     0,  1933,     0,     0,
       0,     0,  1185,     0,     0,     0,  1185,     0,   824,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,  1185,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,  1933,  1185,  1185,  1185,     0,     0,     0,
    1185,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,  1185,     0,     0,     0,     0,     0,
    1929,     0,     0,     0,  1185,     0,     0,     0,  4209,  4210,
    4211,  4212,  1185,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1931,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,  1929,   824,     0,     0,     0,   824,  1933,
     824,     0,     0,     0,     0,     0,  4354,     0,     0,     0,
       0,     0,  1927,  1927,     0,  1927,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1928,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1928,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,     0,  1927,     0,     0,   824,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,  1931,     0,
       0,     0,     0,     0,     0,     0,     0,  1927,     0,  1928,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1933,     0,     0,     0,  1181,  1928,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1928,     0,     0,     0,
       0,     0,     0,  1927,     0,     0,  1181,     0,     0,  1933,
    1185,  1185,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,  1928,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,  1181,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,     0,     0,     0,  1928,     0,     0,
       0,     0,     0,     0,  1929,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,  1185,  1927,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,  1185,
       0,  1933,     0,     0,     0,     0,  1185,  1185,     0,     0,
       0,  1185,  1933,     0,     0,  1181,     0,  1185,  1185,  1181,
    1181,  1185,     0,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,  1929,  1185,     0,
       0,  1927,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,     0,     0,     0,     0,     0,     0,     0,     0,
    4586,     0,     0,     0,     0,     0,     0,     0,     0,  1931,
       0,     0,     0,     0,  4589,     0,  1927,     0,     0,  1185,
       0,     0,  1045,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1933,     0,     0,
    1929,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,  1045,   824,     0,     0,  1929,
       0,     0,     0,  1931,     0,  1933,     0,     0,     0,     0,
       0,     0,     0,     0,  1928,     0,     0,  1929,     0,     0,
       0,  1933,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1931,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,  4655,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1933,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1931,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1931,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,  1931,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1933,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4751,  4753,  4753,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,  1933,     0,     0,     0,     0,  1185,  1181,     0,     0,
       0,     0,     0,  1931,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,  1185,  1185,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,  1185,     0,     0,  1185,     0,
       0,     0,     0,  1185,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1928,     0,     0,
       0,     0,  1928,  1928,     0,  1929,  1185,     0,     0,     0,
       0,     0,     0,     0,  1928,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,  1927,     0,  4841,     0,     0,  1933,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,  1181,     0,     0,     0,     0,     0,  1927,  1181,
       0,     0,  1181,     0,   824,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,  1181,  1181,     0,     0,  1185,     0,
       0,     0,  1181,     0,     0,  1181,  1181,  1181,  1181,     0,
       0,     0,     0,     0,     0,  1181,  1181,     0,  1181,     0,
    1181,  1181,     0,     0,  1181,     0,  4885,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1931,  1181,     0,     0,     0,     0,  1181,     0,     0,  4904,
    1181,  4906,     0,  1185,  1181,  1933,  1181,  1181,  1181,  1181,
    1181,  1181,  1181,  1181,  1181,     0,  1181,  1928,     0,     0,
       0,     0,  1181,     0,     0,  1181,     0,  1185,  1933,     0,
    1185,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,  1927,     0,  1185,     0,     0,     0,     0,  1933,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,  1928,     0,   824,     0,     0,     0,  1933,     0,
       0,     0,  1933,  1933,     0,     0,  4753,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,  1929,  1929,     0,     0,  5006,  1185,     0,
       0,     0,     0,     0,     0,  1929,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1933,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1928,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
    1927,     0,     0,     0,     0,  5042,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,  1181,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,  5079,     0,     0,  1045,     0,     0,
    1185,     0,     0,  1931,     0,     0,     0,     0,  1931,  1931,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,  1185,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1045,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1929,     0,     0,     0,   824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,  1181,     0,  1931,   824,     0,     0,     0,  1185,     0,
       0,     0,   824,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1928,     0,     0,     0,     0,     0,     0,  1931,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1928,  1928,     0,  1928,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,     0,  1928,     0,     0,  1931,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,  1181,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,  1181,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,  1927,  1928,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,  1181,     0,
       0,     0,  1181,  1928,     0,     0,     0,  1927,     0,     0,
       0,     0,     0,     0,  1181,  1181,  1181,  1181,     0,     0,
       0,     0,     0,     0,  1928,     0,     0,  1181,     0,     0,
    1181,   923,  1181,     0,     0,     0,     0,  1928,     0,     0,
     923,     0,  1181,  1181,     0,     0,  1181,  1927,     0,     0,
       0,  1927,  1927,     0,     0,     0,     0,     0,     0,  1181,
       0,  1181,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     923,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,  1181,  1181,  1181,     0,     0,     0,
       0,  1928,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,  1100,     0,     0,  1928,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1928,  1181,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,     0,     0,  1929,  1929,     0,  1929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,     0,  1929,     0,  1929,     0,     0,     0,     0,
       0,     0,  1928,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1931,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1928,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1931,
    1931,     0,  1931,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1149,  1929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1931,     0,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,  1931,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1931,
       0,  1929,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1928,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1929,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1929,     0,     0,     0,  1931,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,  1931,     0,     0,     0,
       0,     0,     0,   923,   923,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1929,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,  1931,     0,
       0,     0,     0,  1928,     0,  1181,     0,     0,     0,     0,
       0,  1181,     0,  1181,     0,     0,     0,     0,  1931,  1181,
       0,     0,  1181,  1181,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1181,     0,     0,     0,  1181,  1181,     0,     0,  1928,
       0,     0,     0,  1931,     0,     0,     0,     0,  1181,     0,
       0,     0,  1181,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,  1181,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,  1931,
    1181,  1181,  1181,     0,     0,     0,  1181,     0,     0,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
    1181,     0,  1196,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,  1225,  1226,     0,  1229,     0,  1232,  1181,  1234,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1286,     0,
       0,     0,     0,     0,     0,     0,  1294,     0,     0,     0,
    1929,  1928,     0,     0,     0,  1310,  1311,     0,     0,     0,
    1313,     0,  1928,  1181,     0,     0,     0,     0,     0,  1181,
       0,     0,     0,     0,     0,  1181,     0,  1149,     0,   923,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1344,     0,     0,     0,     0,     0,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1367,     0,     0,  1369,     0,  1371,     0,  1374,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   923,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1931,     0,  1928,     0,     0,
       0,     0,     0,     0,     0,     0,  1454,     0,  1455,     0,
       0,     0,     0,     0,  1929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1928,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1149,
       0,  1928,     0,     0,     0,     0,     0,     0,     0,     0,
    1929,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1100,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1928,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1931,
       0,     0,     0,     0,     0,  1714,     0,  1716,     0,     0,
       0,  1718,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,  1747,     0,  1929,     0,  1931,  1181,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1865,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1878,     0,     0,  1181,     0,     0,
       0,  1928,     0,     0,     0,     0,     0,  1888,     0,     0,
       0,     0,     0,     0,  1890,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1939,     0,     0,  1943,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,  1181,     0,  1931,  1929,     0,
       0,     0,  1181,  1181,     0,     0,     0,  1181,  1931,     0,
       0,     0,  1986,  1181,  1181,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,  1181,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,  1181,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,  1181,  1928,     0,     0,
     716,     0,   716,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   716,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,   716,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   716,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,     0,   716,
     716,     0,     0,   716,     0,     0,     0,     0,     0,   716,
       0,     0,     0,  1007,     0,     0,     0,     0,     0,     0,
       0,  1931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1007,     0,     0,     0,  1931,     0,     0,
       0,     0,     0,     0,     0,  1928,     0,     0,     0,   716,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1928,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1928,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1928,     0,
       0,  1181,  1928,  1928,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1100,  2302,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,  1181,     0,     0,     0,  1931,     0,     0,
       0,     0,  1181,  2373,     0,     0,  2373,     0,     0,     0,
       0,     0,     0,     0,  2380,     0,     0,     0,     0,  1181,
    1181,     0,   716,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,  2389,     0,     0,     0,  1181,     0,     0,     0,
       0,  1181,     0,     0,  1181,     0,     0,     0,     0,  1181,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2459,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,     0,  1929,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,  1929,  1929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
       0,  1931,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   716,     0,
       0,     0,     0,  1181,  1931,     0,  1181,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2665,     0,  1181,     0,     0,     0,  1181,
       0,     0,     0,     0,  1931,     0,     0,     0,  2688,     0,
       0,     0,   716,   716,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1931,     0,     0,     0,  1931,  1931,
       0,     0,     0,     0,  2736,     0,     0,     0,     0,     0,
     716,     0,     0,     0,     0,     0,     0,     0,     0,  2751,
       0,  2753,     0,  2754,     0,     0,     0,     0,  2755,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1931,     0,     0,  2783,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2302,
       0,     0,     0,  2302,     0,  2302,     0,     0,  2302,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,  1181,
       0,     0,     0,     0,     0,  1332,   716,     0,   716,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2996,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1181,     0,     0,   716,     0,     0,   716,
     716,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,  1007,     0,  1007,     0,
       0,     0,     0,     0,   672,     0,     0,     0,   716,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1007,  1007,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   716,     0,
     716,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1149,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3085,  3086,     0,     0,     0,
    3089,  3090,     0,     0,  3093,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3103,     0,     0,     0,     0,     0,
       0,  3112,     0,     0,     0,  3115,  3116,   672,     0,  3119,
    3120,     0,     0,     0,     0,     0,  3125,     0,     0,     0,
       0,   672,   672,     0,     0,  1696,     0,     0,  3141,     0,
    3143,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3165,     0,     0,     0,
       0,  3167,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3185,  3186,  3189,  3191,     0,     0,     0,  3198,
    3201,     0,     0,     0,     0,     0,     0,  3212,     0,     0,
    3216,     0,     0,     0,  3220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3248,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3255,     0,  3257,
       0,     0,     0,     0,  3260,     0,     0,     0,     0,  3264,
    3265,  3266,  3267,     0,  3269,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3293,  3294,  3295,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3303,  3304,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3358,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,   716,     0,   716,     0,     0,   716,     0,   716,
       0,     0,   716,   716,   716,     0,     0,     0,  2084,     0,
       0,     0,     0,     0,     0,   716,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   716,     0,
     716,     0,     0,     0,     0,   716,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2302,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3485,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2242,     0,     0,     0,     0,     0,     0,
       0,     0,   716,   716,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,   672,
       0,     0,     0,     0,   672,   672,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     5,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     6,     7,
       0,     0,     0,     0,     8,     0,     9,    10,     0,     0,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,    36,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,     0,    45,
       0,     0,     0,     0,     0,     0,     0,   716,     0,   672,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2377,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3661,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   672,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,  3700,
    3701,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    48,     0,  2302,     0,     0,     0,
       0,     0,   672,     0,     0,   672,   672,     0,     0,     0,
       0,     0,     0,     0,    49,     0,     0,     0,     0,     0,
       0,  3723,     0,     0,     0,     0,     0,     0,     0,     0,
    3727,     0,     0,     0,     0,     0,    50,     0,     0,     0,
       0,     0,     0,     0,     0,  3738,  3740,     0,     0,     0,
    3740,     0,     0,     0,     0,  3751,  3752,  3753,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   672,
       0,     0,    51,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      53,  3774,  3775,  3776,  3777,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,  3793,  3794,  3795,  1186,     0,     0,     0,     0,     0,
       0,  3808,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    54,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3847,     0,     0,     0,     0,
       0,     0,     0,  3851,     0,     0,     0,    55,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    57,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     716,     0,   716,  1186,     0,     0,   716,  3919,   716,     0,
       0,   716,    58,     0,     0,   716,     0,     0,    59,     0,
    2242,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,    67,    68,     0,    69,    70,    71,    72,    73,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3947,
       0,     0,  3950,     0,     0,     0,     0,     0,     0,     0,
    1934,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   923,     0,     0,  3990,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4000,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2302,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,  1186,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,  2084,
       0,     0,     0,     0,     0,     0,  2997,     0,     0,     0,
       0,     0,     0,     0,     0,  2377,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,   672,
       0,  1186,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,   672,     0,     0,     0,
       0,     0,  3069,     0,  1696,     0,     0,   716,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1934,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4203,     0,  4204,     0,
       0,     0,     0,     0,     0,  4206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,     0,     0,     0,     0,
       0,  4215,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4223,     0,
       0,     0,     0,     0,  1934,     0,     0,  4234,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4266,  4267,  4268,  4269,  4270,  4271,  4272,
    4273,     0,     0,     0,     0,  4280,  4281,     0,  4283,  4284,
    4285,  4286,  4287,  4288,  4289,     0,     0,  1934,     0,   672,
       0,     0,     0,  4297,     0,  4299,  4300,   672,     0,   672,
       0,     0,     0,     0,     0,     0,  1934,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1934,  1552,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4348,  4350,  4352,     0,     0,
    4355,     0,  1934,     0,     0,     0,     0,     0,     0,     0,
    1623,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,  1934,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,  3740,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,  2302,  2302,  2302,     0,     0,     6,     7,     0,     0,
       0,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,  1186,     0,    45,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     716,  2084,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   672,     0,     0,
       0,     0,     0,  1186,  1186,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,  1186,    46,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,  1186,  1186,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,  1186,  1186,  1186,
    1186,     0,     0,     0,     0,     0,     0,  1186,  1186,     0,
    1186,     0,  1186,  1186,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1934,  1186,     0,     0,     0,     0,  1186,     0,
       0,     0,  1186,     0,     0,    47,  1186,     0,  1186,  1186,
    1186,  1186,  1186,  1186,  1186,  1186,  1186,     0,  1186,     0,
       0,     0,    48,     0,  1186,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,  4551,  4552,  4553,  4554,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,  4566,  4567,  4568,
    4569,     0,  4571,  4572,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4581,  4582,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      51,  2302,  2302,    52,  2302,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2377,    53,     0,
       0,     0,   672,     0,  2139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2163,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2188,  2189,     0,  2192,     0,     0,     0,     0,     0,
       0,     0,     0,    54,     0,     0,     0,     0,  4642,     0,
       0,  2232,     0,     0,     0,     0,     0,  4648,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,  4667,     0,
       0,  1186,     0,     0,     0,    55,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    56,
       0,     0,  4686,  2286,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    57,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,     0,     0,     0,     0,
    1934,  1934,  2309,     0,     0,     0,  2321,  2324,     0,     0,
      58,     0,  1934,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1382,
       0,     0,     0,  2302,    71,  1383,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2302,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4773,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,  1186,     0,  1934,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   672,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2228,     0,     0,     0,  3740,     0,     0,     0,
    1934,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2302,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2302,   716,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4891,     0,     0,
       0,     0,  4895,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2302,     0,     0,     0,  1934,
       0,     0,     0,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,  1186,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3740,     0,  1186,
    1186,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2302,     0,  1186,  1186,  1186,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,  1186,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,  1186,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,  1186,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,  5001,     0,     0,     0,     0,  5005,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,  1186,  1186,  1186,     0,
       0,     0,     0,     0,     0,     0,  2862,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,  3069,  2885,
       0,     0,  2887,  1186,     0,  2898,     0,     0,  1186,     0,
       0,     0,  2905,  2910,  1186,     0,     0,     0,  2916,     0,
       0,  2921,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2930,     0,
       0,     0,     0,  2937,     0,     0,     0,  2949,     0,     0,
       0,  2956,     0,  2958,  2959,  2960,  2961,  2962,  2963,  2964,
    2965,  2966,     0,  2967,     0,     0,     0,     0,     0,  1552,
       0,     0,  2992,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1934,
       0,     0,     0,     0,     0,   672,  2228,     0,     0,     0,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,  1623,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,  1934,  1934,     0,  1934,     6,     7,     0,     0,     0,
       0,     0,     0,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,  2228,     0,
    1934,     0,  1934,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2228,     0,     0,     0,     0,  2894,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,  2228,  2228,     0,
       0,  2228,     0,     0,     0,  3117,  1934,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1934,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1934,     0,     0,   672,     0,     0,     0,     0,
       0,     0,     0,     0,    47,  1934,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    48,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2228,     0,
       0,     0,     0,    50,     0,     0,     0,     0,     0,  1934,
    2228,     0,     0,  2228,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1934,    51,
       0,     0,    52,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2377,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3333,     0,
       0,     0,     0,     0,   672,     0,     0,  1186,     0,     0,
    1934,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,  1186,     0,  1186,     0,     0,     0,     0,
    1934,  1186,    54,     0,  1186,  1186,  1186,  1186,  1186,  1186,
    1186,  1186,  1186,  1186,     0,     0,     0,  1186,  1186,     0,
       0,     0,     0,     0,     0,  1934,   672,     0,     0,     0,
    1186,     0,     0,     0,  1186,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,    55,     0,     0,     0,  1186,     0,
       0,  1186,     0,  1186,     0,     0,     0,     0,    56,     0,
       0,  1934,  1186,  1186,  1186,     0,     0,     0,  1186,     0,
       0,  1186,     0,    57,     0,     0,     0,     0,     0,     0,
       0,  1186,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,  3457,     0,     0,     0,     0,     0,    58,
    1186,     0,  1186,     0,     0,    59,   672,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1382,  2764,
       0,     0,     0,    71,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,  3506,     0,     0,     0,     0,  3512,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2910,     0,  2910,  2910,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3569,     0,     0,  3572,     0,  3574,
       0,     0,     0,     0,     0,     0,     0,  1934,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3595,     0,  3597,     0,
       0,     0,  3600,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2992,  2992,  2992,     0,   716,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3658,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2309,     0,
       0,     0,     0,  3670,     0,     0,     0,     0,     0,  2324,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1934,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,     0,     0,     0,     0,  3709,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1934,  1186,  1186,
       0,     0,     0,     0,  2228,     0,  2228,     0,  2894,  2894,
    3543,     0,     0,  2894,     0,     0,     0,  2228,     0,     0,
       0,     0,     0,     0,  2228,     0,     0,     0,     0,  2228,
       0,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
    2228,     0,     0,     0,     0,     0,     0,     0,     0,  2228,
       0,     0,     0,  2894,  2894,     0,  2228,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,  2228,     0,
       0,     0,     0,     0,     0,  2228,     0,  2228,  2228,  2228,
    2228,  2228,  2228,  2228,  2228,  2228,  2228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,  1186,     0,  1934,
       0,  2228,     0,     0,  1186,  1186,     0,     0,     0,  1186,
    1934,     0,     0,     0,     0,  1186,  1186,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   672,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,  2228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1934,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1934,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,  4030,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,  4034,     0,     0,     0,     0,     0,  4035,     0,
    4036,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4054,  4055,     0,     0,     0,     0,     0,     0,
       0,     0,  1934,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2228,  2916,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4083,     0,     0,  4086,     0,  4088,     0,
       0,     0,     0,     0,     0,  1186,     0,  4092,     0,  1934,
       0,     0,     0,  4097,  1186,     0,  4100,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,  1186,     0,     0,  1186,     0,  4133,     0,     0,
       0,     0,     0,     0,     0,  4145,     0,  2992,  1186,     0,
       0,     0,     0,  1186,     0,     0,  1186,     0,     0,     0,
       0,  1186,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4162,     0,     0,     0,  1186,     0,  1552,     0,     0,     0,
       0,     0,  1623,     0,     0,     0,  2228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1934,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2228,     0,     0,     0,     0,
       0,  2228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,  3543,  3543,     0,
    2894,     0,     0,  2894,  2894,  2894,  2894,  2894,  2894,  2894,
    2894,  2894,  2894,  3543,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2228,     0,
       0,  2228,     0,  2228,     0,     0,     0,     0,  3543,  3543,
       0,  1186,     0,  1934,     0,     0,     0,     0,     0,     0,
       0,     0,  2894,  2894,  2228,     0,  2228,     0,     0,  2228,
       0,     0,     0,     0,     0,  1186,  1934,     0,  1186,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,  1186,     0,     0,     0,     0,  1934,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2228,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2228,
       0,     0,     0,     0,     0,     0,  1934,     0,     0,     0,
    1934,  1934,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2228,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4409,  4410,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1934,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,  4441,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4459,  4461,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,  4468,     0,     0,     0,     0,  1186,
    4473,  4474,     0,     0,  4476,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,  2992,     0,     0,     0,
       0,  2992,     0,  2894,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2992,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,  4532,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2228,
       0,     0,     0,  2228,  2228,  2228,     0,     0,  3543,     0,
       0,     0,     0,  3543,  3543,  3543,  3543,  3543,  3543,  3543,
    3543,  3543,  3543,  2228,  2228,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2228,  2894,  2894,  2228,     0,  2228,     0,     0,
       0,  2228,  3543,  3543,     0,     0,  2228,     0,     0,  2228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4628,     0,
       0,    86,    87,    88,     0,    90,    91,    92,     0,     0,
       0,    95,  2228,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,     0,  2228,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
       0,  2228,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
    4712,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,   145,
       0,     0,     0,     0,     0,   148,     0,  4729,     0,     0,
       0,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   155,   156,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,   166,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,  3543,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   176,
       0,   177,     0,     0,   178,   179,     0,   180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,     0,     0,     0,     0,     0,  2228,  2228,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     193,     0,     0,   194,     0,   195,     0,     0,     0,     0,
    2228,     0,     0,     0,  2894,     0,     0,     0,   196,   197,
     198,   199,   200,     0,     0,     0,     0,     0,  2228,     0,
    2228,     0,   201,  2916,   202,  3543,  3543,  2228,     0,     0,
    2894,  2894,  2228,  2228,     0,  2228,     0,   204,     0,     0,
       0,     0,  4866,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   218,     0,     0,
     220,     0,   221,     0,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,     0,     0,   223,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   225,   226,     0,
       0,     0,   227,     0,   228,     0,     0,     0,     0,     0,
       0,     0,     0,   231,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4937,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245,   246,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2228,     0,     0,
    3059,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4982,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3543,  2894,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3543,
    3543,  2228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2228,     0,
       0,     0,     0,     0,     0,  5028,  5028,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    5028,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    5076,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3543,     0,     0,     0,     0,
       0,     0,  5028,     0,     0,  2228,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2228,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,  2228,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,  2228,     0,   418,   419,   420,
     421,   422,   423,   424,   425,   733,   426,   427,   428,   734,
     735,   736,   737,   738,   739,   740,   429,   430,   741,   431,
     432,   133,   433,   434,   435,   135,   136,   137,   138,   139,
     742,   436,   437,   438,   439,   440,   743,   744,   441,   442,
     745,   140,   443,   746,   444,   445,   446,   447,   144,   747,
     145,   748,   448,   449,   450,   451,   148,   452,   749,   750,
     453,   454,   455,   456,   457,   458,   751,   151,   459,   752,
     753,   754,   755,   152,   756,   757,   758,   460,   461,   462,
     463,   695,   464,   155,   156,   465,   759,   466,   760,   467,
     468,   469,   470,   471,   761,   472,   473,   474,   762,   763,
     475,   476,   477,   478,   479,   764,   480,   481,   482,   765,
     483,   484,   485,   766,   486,   487,   488,   489,   164,   490,
     491,   492,   166,   767,   493,   768,   494,   168,   495,   769,
     496,   770,   497,   169,   771,   170,   498,   499,   500,   772,
     501,   172,   773,   502,   774,   503,   504,   697,   505,   506,
     173,   507,   508,   509,   775,   510,   511,   512,   513,   514,
     515,   776,   516,   174,   175,   777,   517,   518,   519,   778,
     176,   779,   177,   780,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,   781,   527,   528,   782,   529,   181,
     182,   530,   183,   783,   531,   532,   533,   784,   785,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,   189,   190,   545,   546,   191,   786,   547,
     548,   193,   549,   787,   194,   550,   195,   551,   552,   553,
     788,   554,   789,   790,   555,   556,   557,   791,   792,   196,
     197,   198,   199,   200,   558,   559,   560,   561,   562,   563,
     564,   793,   565,   201,   566,   202,   567,   568,   569,   794,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,   795,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,   796,   593,   594,   211,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
     797,   604,   605,   606,   607,   608,   798,   609,   218,   610,
     611,   220,   612,   221,   613,   799,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,   800,   624,   625,
     801,   626,   627,   628,   629,   630,   631,   802,   225,   226,
     803,   804,   633,   227,   634,   228,   805,   635,   636,   637,
     638,   639,   640,   641,   806,   807,   642,   643,   644,   645,
     646,   808,   809,   647,   648,   649,   650,   651,   810,   235,
     811,   652,   236,   653,   654,   655,   812,   813,   656,   814,
     815,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    85,     0,
       0,    86,    87,    88,    89,    90,    91,    92,    93,     0,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     967,   104,   105,   106,     0,     0,   107,   108,   109,   110,
       0,   111,   112,   113,   114,   115,     0,   116,   117,   118,
     119,   120,     0,     0,     0,   121,   122,     0,     0,     0,
       0,   123,     0,     0,     0,     0,     0,     0,     0,     0,
     124,     0,   125,     0,   126,   127,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,   130,   131,
       0,     0,     0,     0,     0,     0,     0,     0,   132,     0,
     133,     0,     0,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,   141,     0,   142,   143,   144,     0,   145,
       0,   146,     0,   147,     0,   148,     0,     0,     0,     0,
       0,     0,     0,   149,     0,   150,   151,     0,     0,     0,
       0,     0,   152,     0,     0,     0,     0,     0,     0,   153,
       0,   154,   155,   156,   157,     0,     0,     0,     0,     0,
   -1398,     0,     0,     0,     0,     0,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,     0,     0,   161,   162,
       0,     0,     0,     0,     0,     0,   163,   164,   165,     0,
       0,   166,     0,     0,   167,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,   171,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0, -1398,     0,     0,   176,
       0,   177,     0,     0,   178,   179,     0,   180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
       0,   183,     0,   184,   185,     0,     0,     0,     0,   186,
       0,     0,     0,     0,     0,     0,     0,     0,   187,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,   192,
     193,     0,     0,   194,     0,   195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
     198,   199,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,   202,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   204,   205,     0,
       0,     0,     0,   206,   207,     0,   208,     0,     0,     0,
       0,   209,     0,     0,     0,     0,   210,   211,     0,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,     0,     0,   217,   218,     0,   219,
     220,     0,   221,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,   223,     0,     0,     0,   224,
       0,     0,     0,     0,     0,     0,     0,   225,   226,     0,
       0,     0,   227,     0,   228,     0,   229,     0,   230,     0,
       0,     0,     0,   231,     0,     0,   232,     0,     0, -1398,
       0,     0,   233,     0,     0,     0,     0,   234,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,   237,
       0,     0,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   247,   104,   105,     0,  -136,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,     0,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,   156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,     0,   166,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   176,     0,   177,     0,     0,   178,   179,     0,
     180,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   181,   182,     0,   183,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   188,   189,   190,     0,     0,   191,
       0,     0,     0,   193,     0,     0,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,   197,   198,   199,   200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   201,     0,   202,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     218,     0,     0,   220,     0,   221,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   223,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     225,   226,     0,     0,     0,   227,     0,   228,     0,     0,
       0,     0,     0,     0,     0,     0,   231,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   235,     0,     0,   236,     0,     0,     0,     0,     0,
       0,     0,     4,     0,     0,     0,     0,     0,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,     0,     0,
       0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     6,     7,     0,     0,     0,     0,     0,     0,
       9,    10,     0,  3061,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    48,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      50,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,    52,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    55,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    56,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    58,     0,     0,     0,
       0,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1382,     0,     0,     0,     0,
      71,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1471,
    1472,  1473,    45,  1474,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,  2986,   426,   427,   428,     0,
       0,     0,     0,  1475,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,  1476,   137,  1477,  1478,
       0,   436,   437,   438,   439,   440,  1479,  1480,   441,   442,
    1481,  1482,   443,     0,   444,   445,   446,   447,  1483,     0,
    1484,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
    1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,
     463,   695,   464,  1492,  1493,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,  2987,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,  1495,   490,
     491,   492,  1496,  1497,   493,     0,   494,  1498,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,  1499,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1500,
    1501,     0,  1502,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,  1503,
     182,   530,   183,     0,   531,   532,   533,  1504,  1505,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1506,   189,  1507,   545,   546,   191,  1508,   547,
     548,   193,   549,  1509,  1510,   550,  1511,   551,   552,   553,
       0,   554,     0,     0,  1512,   556,   557,     0,     0,   196,
     197,   198,   199,  1513,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1514,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1515,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1516,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1517,   609,   218,   610,
     611,   220,   612,  1518,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1519,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1520,  1521,
       0,     0,   633,  1522,   634,  1523,  1524,   635,   636,   637,
     638,   639,   640,   641,     0,  1525,   642,   643,   644,   645,
     646,  1526,     0,   647,   648,   649,   650,   651,   701,  1527,
    2988,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  1536,  1537,  2989,     0,     0,
       0,     0,     0,     0,  1539,  2990,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1475,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,  1476,   137,  1477,  1478,     0,   436,   437,   438,   439,
     440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,   444,
     445,   446,   447,  1483,     0,  1484,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,
    1490,  1491,   460,   461,   462,   463,   695,   464,  1492,  1493,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1494,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1495,   490,   491,   492,  1496,  1497,   493,
       0,   494,  1498,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1499,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1500,  1501,     0,  1502,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1503,   182,   530,   183,     0,   531,
     532,   533,  1504,  1505,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1506,   189,  1507,
     545,   546,   191,  1508,   547,   548,   193,   549,  1509,  1510,
     550,  1511,   551,   552,   553,     0,   554,     0,     0,  1512,
     556,   557,     0,     0,   196,   197,   198,   199,  1513,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1514,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1515,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1516,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1517,   609,   218,   610,   611,   220,   612,  1518,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1519,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1520,  1521,     0,     0,   633,  1522,   634,
    1523,  1524,   635,   636,   637,   638,   639,   640,   641,     0,
    1525,   642,   643,   644,   645,   646,  1526,     0,   647,   648,
     649,   650,   651,   701,  1527,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    1536,  1537,     0,     0,     0,     0,     0,     0,     0,  1539,
    2896,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,     0,  1900,   137,  1901,  1902,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
    1903,  1904,   443,     0,   444,   445,   446,   447,     0,     0,
     145,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,   695,   464,  1905,  1906,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,     0,   490,
     491,   492,     0,     0,   493,     0,   494,  1907,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,     0,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,  2482,   510,   511,   512,   513,   514,
     515,     0,   516,   174,  2483,     0,   517,   518,   519,  1500,
    1908,     0,  1909,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,     0,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1910,   189,  1911,   545,   546,     0,     0,   547,
     548,   193,   549,     0,     0,   550,  1912,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,  2484,
     197,   198,   199,     0,   558,   559,   560,   561,   562,   563,
     564,     0,   565,     0,   566,     0,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1913,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,     0,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,  2485,   610,
     611,   220,   612,  1915,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,     0,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1916,  1917,
       0,     0,   633,     0,   634,     0,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,     0,  1918,
    2486,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   702,   662,   663,     0,     0,
       0,     0,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,  2487,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,     0,  1900,   137,  1901,
    1902,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,  1903,  1904,   443,     0,   444,   445,   446,   447,     0,
       0,   145,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,   695,   464,  1905,  1906,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1494,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,     0,
     490,   491,   492,     0,     0,   493,     0,   494,  1907,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,     0,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,  2482,   510,   511,   512,   513,
     514,   515,     0,   516,   174,  2483,     0,   517,   518,   519,
    1500,  1908,     0,  1909,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
       0,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1910,   189,  1911,   545,   546,     0,     0,
     547,   548,   193,   549,     0,     0,   550,  1912,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
    2484,   197,   198,   199,     0,   558,   559,   560,   561,   562,
     563,   564,     0,   565,     0,   566,     0,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1913,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,     0,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,  2485,
     610,   611,   220,   612,  1915,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,     0,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1916,
    1917,     0,     0,   633,     0,   634,     0,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,     0,
    1918,  2486,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   702,   662,   663,     0,
       0,     0,     0,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,  3419,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,  1475,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,  1476,   137,
    1477,  1478,  2906,   436,   437,   438,   439,   440,  1479,  1480,
     441,   442,  1481,  1482,   443,     0,   444,   445,   446,   447,
    1483,     0,  1484,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,
     461,   462,   463,   695,   464,  1492,  1493,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1494,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
    1495,   490,   491,   492,  1496,  1497,   493,     0,   494,  1498,
     495,     0,   496,     0,   497,   169,  2907,   170,   498,   499,
     500,     0,   501,  1499,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,  1500,  1501,     0,  1502,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,  2908,
     529,  1503,   182,   530,   183,     0,   531,   532,   533,  1504,
    1505,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1506,   189,  1507,   545,   546,   191,
    1508,   547,   548,   193,   549,  1509,  1510,   550,  1511,   551,
     552,   553,     0,   554,     0,     0,  1512,   556,   557,     0,
       0,   196,   197,   198,   199,  1513,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1514,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1515,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,  1516,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1517,   609,
     218,   610,   611,   220,   612,  1518,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1519,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1520,  1521,     0,  2909,   633,  1522,   634,  1523,  1524,   635,
     636,   637,   638,   639,   640,   641,     0,  1525,   642,   643,
     644,   645,   646,  1526,     0,   647,   648,   649,   650,   651,
     701,  1527,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,
       0,     0,     0,     0,     0,     0,     0,  1536,  1537,     0,
       0,     0,     0,     0,     0,     0,  1539,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1475,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,  1476,   137,  1477,  1478,     0,   436,   437,   438,
     439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,
     444,   445,   446,   447,  1483,     0,  1484,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,
    1489,  1490,  1491,   460,   461,   462,   463,   695,   464,  1492,
    1493,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1494,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,  1495,   490,   491,   492,  1496,  1497,
     493,     0,   494,  1498,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,  1499,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1500,  1501,     0,  1502,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1503,   182,   530,   183,     0,
     531,   532,   533,  1504,  1505,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1506,   189,
    1507,   545,   546,   191,  1508,   547,   548,   193,   549,  1509,
    1510,   550,  1511,   551,   552,   553,     0,   554,     0,     0,
    1512,   556,   557,     0,     0,   196,   197,   198,   199,  1513,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1514,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1515,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1516,   597,   598,
     599,   600,   601,   602,   700,   603,   216,   604,   605,   606,
     607,   608,  1517,   609,   218,   610,   611,   220,   612,  1518,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1519,     0,   624,   625,   224,   626,   627,   628,
     629,   630,   631,     0,  1520,  1521,     0,     0,   633,  1522,
     634,  1523,  1524,   635,   636,   637,   638,   639,   640,   641,
       0,  1525,   642,   643,   644,   645,   646,  1526,     0,   647,
     648,   649,   650,   651,  2190,  1527,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,   237,   657,   658,   659,
     660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
    1535,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,  1536,  1537,     0,     0,     0,     0,     0,     0,     0,
    1539,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1471,
    1472,  1473,    45,  1474,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,  1475,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,  1476,   137,  1477,  1478,
       0,   436,   437,   438,   439,   440,  1479,  1480,   441,   442,
    1481,  1482,   443,     0,   444,   445,   446,   447,  1483,     0,
    1484,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
    1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,
     463,   695,   464,  1492,  1493,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,  1495,   490,
     491,   492,  1496,  1497,   493,     0,   494,  1498,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,  1499,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1500,
    1501,     0,  1502,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,  1503,
     182,   530,   183,     0,   531,   532,   533,  1504,  1505,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1506,   189,  1507,   545,   546,   191,  1508,   547,
     548,   193,   549,  1509,  1510,   550,  1511,   551,   552,   553,
       0,   554,     0,     0,  1512,   556,   557,     0,     0,   196,
     197,   198,   199,  1513,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1514,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1515,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1516,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1517,   609,   218,   610,
     611,   220,   612,  1518,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1519,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1520,  1521,
       0,     0,   633,  1522,   634,  1523,  1524,   635,   636,   637,
     638,   639,   640,   641,     0,  1525,   642,   643,   644,   645,
     646,  1526,     0,   647,   648,   649,   650,   651,   701,  1527,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  1536,  1537,     0,     0,     0,
       0,     0,  2134,  2854,  1539,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1471,  1472,  1473,    45,  1474,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1475,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1476,   137,  1477,  1478,     0,   436,   437,   438,   439,   440,
    1479,  1480,   441,   442,  1481,  1482,   443,     0,   444,   445,
     446,   447,  1483,     0,  1484,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,   460,   461,   462,   463,   695,   464,  1492,  1493,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1494,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1495,   490,   491,   492,  1496,  1497,   493,     0,
     494,  1498,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1499,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1500,  1501,     0,  1502,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1503,   182,   530,   183,     0,   531,   532,
     533,  1504,  1505,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1506,   189,  1507,   545,
     546,   191,  1508,   547,   548,   193,   549,  1509,  1510,   550,
    1511,   551,   552,   553,     0,   554,     0,     0,  1512,   556,
     557,     0,     0,   196,   197,   198,   199,  1513,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1514,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1515,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1516,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1517,   609,   218,   610,   611,   220,   612,  1518,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1519,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1520,  1521,     0,     0,   633,  1522,   634,  1523,
    1524,   635,   636,   637,   638,   639,   640,   641,     0,  1525,
     642,   643,   644,   645,   646,  1526,     0,   647,   648,   649,
     650,   651,   701,  1527,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,  1536,
    1537,  1538,     0,     0,     0,     0,     0,     0,  1539,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1471,  1472,  1473,
      45,  1474,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,  1475,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,  1476,   137,  1477,  1478,     0,   436,
     437,   438,   439,   440,  1479,  1480,   441,   442,  1481,  1482,
     443,     0,   444,   445,   446,   447,  1483,     0,  1484,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,  1485,  1486,
    1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,   695,
     464,  1492,  1493,   465,  1622,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1494,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,  1495,   490,   491,   492,
    1496,  1497,   493,     0,   494,  1498,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,  1499,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,  1500,  1501,     0,
    1502,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,  1503,   182,   530,
     183,     0,   531,   532,   533,  1504,  1505,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1506,   189,  1507,   545,   546,   191,  1508,   547,   548,   193,
     549,  1509,  1510,   550,  1511,   551,   552,   553,     0,   554,
       0,     0,  1512,   556,   557,     0,     0,   196,   197,   198,
     199,  1513,   558,   559,   560,   561,   562,   563,   564,     0,
     565,  1514,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1515,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,  1516,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,  1517,   609,   218,   610,   611,   220,
     612,  1518,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,  1519,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1520,  1521,     0,     0,
     633,  1522,   634,  1523,  1524,   635,   636,   637,   638,   639,
     640,   641,     0,  1525,   642,   643,   644,   645,   646,  1526,
       0,   647,   648,   649,   650,   651,   701,  1527,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,  1532,
    1533,  1534,  1535,   702,   662,   663,     0,     0,     0,     0,
       0,     0,     0,  1536,  1537,     0,     0,     0,     0,     0,
       0,     0,  1539,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,  2319,   426,   427,
     428,     0,     0,     0,     0,  1475,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,  1476,   137,
    1477,  1478,     0,   436,   437,   438,   439,   440,  1479,  1480,
     441,   442,  1481,  1482,   443,     0,   444,   445,   446,   447,
    1483,     0,  1484,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,
     461,   462,   463,   695,   464,  1492,  1493,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1494,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
    1495,   490,   491,   492,  1496,  1497,   493,     0,   494,  1498,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1499,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,  1500,  1501,     0,  1502,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1503,   182,   530,   183,     0,   531,   532,   533,  1504,
    1505,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1506,   189,  1507,   545,   546,   191,
    1508,   547,   548,   193,   549,  1509,  1510,   550,  1511,   551,
     552,   553,     0,   554,     0,     0,  1512,   556,   557,     0,
       0,   196,   197,   198,   199,  1513,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1514,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1515,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,  1516,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1517,   609,
     218,   610,   611,   220,   612,  1518,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1519,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1520,  1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,
     636,   637,   638,   639,   640,   641,     0,  1525,   642,   643,
     644,   645,   646,  1526,     0,   647,   648,   649,   650,   651,
     701,  1527,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,
       0,     0,     0,     0,     0,     0,     0,  1536,  1537,     0,
       0,     0,     0,     0,     0,     0,  1539,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1475,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,  1476,   137,  1477,  1478,     0,   436,   437,   438,
     439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,
     444,   445,   446,   447,  1483,     0,  1484,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,
    1489,  1490,  1491,   460,   461,   462,   463,   695,   464,  1492,
    1493,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1494,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,  1495,   490,   491,   492,  1496,  1497,
     493,     0,   494,  1498,   495,     0,   496,     0,   497,   169,
    2907,   170,   498,   499,   500,     0,   501,  1499,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1500,  1501,     0,  1502,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1503,   182,   530,   183,     0,
     531,   532,   533,  1504,  1505,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1506,   189,
    1507,   545,   546,   191,  1508,   547,   548,   193,   549,  1509,
    1510,   550,  1511,   551,   552,   553,     0,   554,     0,     0,
    1512,   556,   557,     0,     0,   196,   197,   198,   199,  1513,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1514,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1515,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1516,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,  1517,   609,   218,   610,   611,   220,   612,  1518,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1519,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1520,  1521,     0,     0,   633,  1522,
     634,  1523,  1524,   635,   636,   637,   638,   639,   640,   641,
       0,  1525,   642,   643,   644,   645,   646,  1526,     0,   647,
     648,   649,   650,   651,   701,  1527,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
    1535,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,  1536,  1537,     0,     0,     0,     0,     0,     0,     0,
    1539,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1471,
    1472,  1473,    45,  1474,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,  1475,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,  1476,   137,  1477,  1478,
       0,   436,   437,   438,   439,   440,  1479,  1480,   441,   442,
    1481,  1482,   443,     0,   444,   445,   446,   447,  1483,     0,
    1484,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
    1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,
     463,   695,   464,  1492,  1493,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,  1495,   490,
     491,   492,  1496,  1497,   493,     0,   494,  1498,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,  1499,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1500,
    1501,     0,  1502,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,  1503,
     182,   530,   183,     0,   531,   532,   533,  1504,  1505,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1506,   189,  1507,   545,   546,   191,  1508,   547,
     548,   193,   549,  1509,  1510,   550,  1511,   551,   552,   553,
       0,   554,     0,     0,  1512,   556,   557,     0,     0,   196,
     197,   198,   199,  1513,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1514,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1515,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1516,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1517,   609,   218,   610,
     611,   220,   612,  1518,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1519,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1520,  1521,
       0,     0,   633,  1522,   634,  1523,  1524,   635,   636,   637,
     638,   639,   640,   641,     0,  1525,   642,   643,   644,   645,
     646,  1526,     0,   647,   648,   649,   650,   651,   701,  1527,
    4148,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  1536,  1537,     0,     0,     0,
       0,     0,     0,     0,  1539,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1471,  1472,  1473,    45,  1474,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1475,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1476,   137,  1477,  1478,     0,   436,   437,   438,   439,   440,
    1479,  1480,   441,   442,  1481,  1482,   443,     0,   444,   445,
     446,   447,  1483,     0,  1484,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,  4161,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,   460,   461,   462,   463,   695,   464,  1492,  1493,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1494,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1495,   490,   491,   492,  1496,  1497,   493,     0,
     494,  1498,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1499,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1500,  1501,     0,  1502,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1503,   182,   530,   183,     0,   531,   532,
     533,  1504,  1505,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1506,   189,  1507,   545,
     546,   191,  1508,   547,   548,   193,   549,  1509,  1510,   550,
    1511,   551,   552,   553,     0,   554,     0,     0,  1512,   556,
     557,     0,     0,   196,   197,   198,   199,  1513,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1514,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1515,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1516,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1517,   609,   218,   610,   611,   220,   612,  1518,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1519,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1520,  1521,     0,     0,   633,  1522,   634,  1523,
    1524,   635,   636,   637,   638,   639,   640,   641,     0,  1525,
     642,   643,   644,   645,   646,  1526,     0,   647,   648,   649,
     650,   651,   701,  1527,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,  1536,
    1537,     0,     0,     0,     0,     0,     0,     0,  1539,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1471,  1472,  1473,
      45,  1474,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,  1475,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,  5025,  1476,   137,  1477,  1478,     0,   436,
     437,   438,   439,   440,  1479,  1480,   441,   442,  1481,  1482,
     443,     0,   444,   445,   446,   447,  1483,     0,  1484,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,  5026,  1485,  1486,
    1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,   695,
     464,  1492,  1493,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1494,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,  1495,   490,   491,   492,
    1496,  1497,   493,     0,   494,  1498,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,  1499,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,  1500,  1501,     0,
    1502,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,  1503,   182,   530,
     183,     0,   531,   532,   533,  1504,  1505,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1506,   189,  1507,   545,   546,   191,  1508,   547,   548,   193,
     549,  1509,  1510,   550,  1511,   551,   552,   553,     0,   554,
       0,     0,  1512,   556,   557,     0,     0,   196,   197,   198,
     199,  1513,   558,   559,   560,   561,   562,   563,   564,     0,
     565,  1514,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1515,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,  1516,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,  1517,   609,   218,   610,   611,   220,
     612,  1518,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,  1519,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1520,  1521,     0,     0,
     633,  1522,   634,  1523,  1524,   635,   636,   637,   638,  5027,
     640,   641,     0,  1525,   642,   643,   644,   645,   646,  1526,
       0,   647,   648,   649,   650,   651,   701,  1527,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,  1532,
    1533,  1534,  1535,   702,   662,   663,     0,     0,     0,     0,
       0,     0,     0,  1536,  1537,     0,     0,     0,     0,     0,
       0,     0,  1539,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,  1475,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,  1476,   137,
    1477,  1478,     0,   436,   437,   438,   439,   440,  1479,  1480,
     441,   442,  1481,  1482,   443,     0,   444,   445,   446,   447,
    1483,     0,  1484,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,  5026,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,
     461,   462,   463,   695,   464,  1492,  1493,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1494,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
    1495,   490,   491,   492,  1496,  1497,   493,     0,   494,  1498,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1499,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,  1500,  1501,     0,  1502,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1503,   182,   530,   183,     0,   531,   532,   533,  1504,
    1505,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1506,   189,  1507,   545,   546,   191,
    1508,   547,   548,   193,   549,  1509,  1510,   550,  1511,   551,
     552,   553,     0,   554,     0,     0,  1512,   556,   557,     0,
       0,   196,   197,   198,   199,  1513,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1514,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1515,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,  1516,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1517,   609,
     218,   610,   611,   220,   612,  1518,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1519,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1520,  1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,
     636,   637,   638,  5027,   640,   641,     0,  1525,   642,   643,
     644,   645,   646,  1526,     0,   647,   648,   649,   650,   651,
     701,  1527,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,
       0,     0,     0,     0,     0,     0,     0,  1536,  1537,     0,
       0,     0,     0,     0,     0,     0,  1539,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1475,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,  1476,   137,  1477,  1478,     0,   436,   437,   438,
     439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,
     444,   445,   446,   447,  1483,     0,  1484,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,
    1489,  1490,  1491,   460,   461,   462,   463,   695,   464,  1492,
    1493,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1494,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,  1495,   490,   491,   492,  1496,  1497,
     493,     0,   494,  1498,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,  1499,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1500,  1501,     0,  1502,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1503,   182,   530,   183,     0,
     531,   532,   533,  1504,  1505,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1506,   189,
    1507,   545,   546,   191,  1508,   547,   548,   193,   549,  1509,
    1510,   550,  1511,   551,   552,   553,     0,   554,     0,     0,
    1512,   556,   557,     0,     0,   196,   197,   198,   199,  1513,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1514,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1515,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1516,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,  1517,   609,   218,   610,   611,   220,   612,  1518,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1519,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1520,  1521,     0,     0,   633,  1522,
     634,  1523,  1524,   635,   636,   637,   638,   639,   640,   641,
       0,  1525,   642,   643,   644,   645,   646,  1526,     0,   647,
     648,   649,   650,   651,   701,  1527,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
    1535,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,  1536,  1537,     0,     0,     0,     0,     0,     0,     0,
    1539,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1471,
    1472,  1473,    45,  1474,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,  1475,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,  1476,   137,  1477,  1478,
       0,   436,   437,   438,   439,   440,  1479,  1480,   441,   442,
    1481,  1482,   443,     0,   444,   445,   446,   447,  1483,     0,
    1484,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
    1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,
     463,   695,   464,  1492,  1493,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,  1495,   490,
     491,   492,  1496,  1497,   493,     0,   494,  1498,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,  1499,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1500,
    1501,     0,  1502,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,  1503,
     182,   530,   183,     0,   531,   532,   533,  1504,  1505,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1506,   189,  1507,   545,   546,   191,  1508,   547,
     548,   193,   549,  1509,  1510,   550,  1511,   551,   552,   553,
       0,   554,     0,     0,  1512,   556,   557,     0,     0,   196,
     197,   198,   199,  1513,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1514,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1515,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1516,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1517,   609,   218,   610,
     611,   220,   612,  1518,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1519,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1520,  1521,
       0,     0,   633,  1522,   634,  1523,  1524,   635,   636,   637,
     638,   639,   640,   641,     0,  1525,   642,   643,   644,   645,
     646,  1526,     0,   647,   648,   649,   650,   651,   701,  1527,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,  4451,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  1536,  1537,     0,     0,     0,
       0,     0,     0,     0,  1539,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1471,  1472,  1473,    45,  1474,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1475,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1476,   137,  1477,  1478,     0,   436,   437,   438,   439,   440,
    1479,  1480,   441,   442,  1481,  1482,   443,     0,   444,   445,
     446,   447,  1483,     0,  1484,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,   460,   461,   462,   463,   695,   464,  1492,  1493,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1494,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1495,   490,   491,   492,  1496,  1497,   493,     0,
     494,  1498,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1499,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1500,  1501,     0,  1502,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1503,   182,   530,   183,     0,   531,   532,
     533,  1504,  1505,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1506,   189,  1507,   545,
    4460,   191,  1508,   547,   548,   193,   549,  1509,  1510,   550,
    1511,   551,   552,   553,     0,   554,     0,     0,  1512,   556,
     557,     0,     0,   196,   197,   198,   199,  1513,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1514,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1515,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1516,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1517,   609,   218,   610,   611,   220,   612,  1518,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1519,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1520,  1521,     0,     0,   633,  1522,   634,  1523,
    1524,   635,   636,   637,   638,   639,   640,   641,     0,  1525,
     642,   643,   644,   645,   646,  1526,     0,   647,   648,   649,
     650,   651,   701,  1527,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,  1536,
    1537,     0,     0,     0,     0,     0,     0,     0,  1539,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1471,  1472,  1473,
      45,  1474,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,  1475,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,  1476,   137,  1477,  1478,     0,   436,
     437,   438,   439,   440,  1479,  1480,   441,   442,  1481,  1482,
     443,     0,   444,   445,   446,   447,  1483,     0,  1484,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,  1485,  1486,
    1487,  1488,  1489,  1490,  1491,   460,   461,   462,   463,   695,
     464,  1492,  1493,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1494,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,  1495,   490,   491,   492,
    1496,  1497,   493,     0,   494,  1498,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,  1499,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,  1500,  1501,     0,
    1502,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,  1503,   182,   530,
     183,     0,   531,   532,   533,  1504,  1505,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1506,   189,  1507,   545,   546,   191,     0,   547,   548,   193,
     549,  1509,  1510,   550,  1511,   551,   552,   553,     0,   554,
       0,     0,  1512,   556,   557,     0,     0,   196,   197,   198,
     199,  1513,   558,   559,   560,   561,   562,   563,   564,     0,
     565,  1514,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1515,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,  1516,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,  1517,   609,   218,   610,   611,   220,
     612,  1518,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,  1519,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1520,  1521,     0,     0,
     633,  1522,   634,  1523,  1524,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,  1526,
       0,   647,   648,   649,   650,   651,   701,  1527,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,  1528,  1529,  1530,  1531,  1532,
    1533,  1534,  1535,   702,   662,   663,     0,     0,     0,     0,
       0,     0,     0,  2889,  2890,     0,     0,     0,     0,     0,
       0,     0,  1539,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1471,  1472,  1473,    45,  1474,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,  1475,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435, -2637,  1476,   137,
    1477,  1478,     0,   436,   437,   438,   439,   440,  1479,  1480,
     441,   442,  1481,  1482,   443,     0,   444,   445,   446,   447,
    1483,     0,  1484,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,  5026,  1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,
     461,   462,   463,   695,   464,  1492,  1493,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1494,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
    1495,   490,   491,   492,  1496,  1497,   493,     0,   494,  1498,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,  1499,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,  1500,  1501,     0,  1502,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,  1503,   182,   530,     0,     0,   531,   532,   533,  1504,
    1505,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1506,   189,  1507,   545,   546,   191,
       0,   547,   548,   193,   549,  1509,  1510,   550,  1511,   551,
     552,   553,     0,   554,     0,     0,  1512,   556,   557,     0,
       0,   196,   197,   198,   199,  1513,   558,   559,   560,   561,
     562,   563,   564,     0,   565,  1514,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1515,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,  1516,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,  1517,   609,
     218,   610,   611,     0,   612,  1518,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,  1519,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1520,  1521,     0,     0,   633,  1522,   634,  1523,  1524,   635,
     636,   637,   638,  5027,   640,   641,     0,  1525,   642,   643,
     644,   645,   646,  1526,     0,   647,   648,   649,   650,   651,
     701,  1527,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,   662,   663,
       0,     0,     0,     0,     0,     0,     0,  1536,  1537,     0,
       0,     0,     0,     0,     0,     0,  1539,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1471,  1472,     0,    45,  1474,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1475,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,  1476,   137,  1477,  1478,     0,   436,   437,   438,
     439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,
     444,   445,   446,   447,  1483,     0,  1484,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,
    1489,  1490,  1491,   460,   461,   462,   463,   695,   464,  1492,
    1493,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1494,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,  1495,   490,   491,   492,  1496,  1497,
     493,     0,   494,  1498,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,  1499,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1500,  1501,     0,  1502,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1503,   182,   530,   183,     0,
     531,   532,   533,  1504,  1505,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1506,   189,
    1507,   545,   546,   191,     0,   547,   548,   193,   549,  1509,
    1510,   550,  1511,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,   197,   198,   199,  1513,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1514,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1515,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1516,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,  1517,   609,   218,   610,   611,   220,   612,  1518,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1519,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1520,  1521,     0,     0,   633,  1522,
     634,  1523,  1524,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,  1526,     0,   647,
     648,   649,   650,   651,   701,  1527,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
    1535,   702,   662,   663,     0,     0,     0,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
    1539,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1471,  1472,     0,    45,  1474,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1475,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,   135,  1476,   137,  1477,  1478,     0,  4067,   437,   438,
     439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,
     444,   445,   446,   447,  1483,     0,  1484,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,
    1489,  1490,  1491,   460,   461,   462,   463,   695,   464,  1492,
    1493,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1494,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,  1495,   490,   491,   492,  1496,  1497,
     493,     0,   494,  1498,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,  1499,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1500,  1501,     0,  1502,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1503,   182,   530,   183,     0,
     531,   532,   533,  1504,  1505,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1506,   189,
    1507,   545,   546,   191,     0,   547,   548,   193,   549,  1509,
    1510,   550,  1511,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,   197,   198,   199,  1513,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1514,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1515,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1516,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,  1517,   609,   218,   610,   611,   220,   612,  1518,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1519,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1520,  1521,     0,     0,   633,  1522,
     634,  1523,  1524,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,  1526,     0,   647,
     648,   649,   650,   651,   701,  1527,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
    1535,   702,   662,   663,     0,     0,     0,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
    1539,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1471,  1472,  1473,    45,  1474,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,  1475,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,     0,  1476,   137,  1477,  1478,     0,   436,   437,   438,
     439,   440,  1479,  1480,   441,   442,  1481,  1482,   443,     0,
     444,   445,   446,   447,  1483,     0,  1484,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,  1485,  1486,  1487,  1488,
    1489,  1490,  1491,   460,   461,   462,   463,   695,   464,  1492,
    1493,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1494,   478,
     479,     0,   480,   481,   482,     0,   483,     0,   485,     0,
     486,   487,   488,   489,  1495,   490,   491,   492,  1496,  1497,
     493,     0,   494,  1498,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,  1499,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
     175,     0,   517,   518,   519,  1500,  1501,     0,  1502,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,  1503,   182,   530,     0,     0,
     531,   532,   533,  1504,  1505,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1506,   189,
    1507,   545,   546,   191,     0,   547,   548,   193,   549,  1509,
    1510,   550,  1511,   551,   552,   553,     0,   554,     0,     0,
    1512,   556,   557,     0,     0,   196,   197,   198,   199,  1513,
     558,   559,   560,   561,   562,   563,   564,     0,   565,  1514,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1515,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,  1516,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,  1517,   609,   218,   610,   611,     0,   612,  1518,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,  1519,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1520,  1521,     0,     0,   633,  1522,
     634,  1523,  1524,   635,   636,   637,   638,   639,   640,   641,
       0,  1525,   642,   643,   644,   645,   646,  1526,     0,   647,
     648,   649,   650,   651,   701,  1527,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
    1535,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,  1536,  1537,     0,     0,     0,     0,     0,     0,     0,
    1539,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1471,
    1472,  1473,    45,  1474,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,  1475,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,     0,  1476,   137,  1477,  1478,
       0,   436,   437,   438,   439,   440,  1479,  1480,   441,   442,
    1481,  1482,   443,     0,   444,   445,   446,   447,  1483,     0,
    1484,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
    1485,  1486,  1487,  1488,  1489,  1490,  1491,   460,   461,   462,
     463,   695,   464,  1492,  1493,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,     0,   485,     0,   486,   487,   488,   489,  1495,   490,
     491,   492,  1496,  1497,   493,     0,   494,  1498,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,  1499,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,  1500,
    1501,     0,  1502,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,  1503,
     182,   530,     0,     0,   531,   532,   533,  1504,  1505,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1506,   189,  1507,   545,   546,   191,     0,   547,
     548,   193,   549,  1509,  1510,   550,  1511,   551,   552,   553,
       0,   554,     0,     0,  1512,   556,   557,     0,     0,   196,
     197,   198,   199,  1513,   558,   559,   560,   561,   562,   563,
     564,     0,   565,  1514,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1515,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,  1516,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,  1517,   609,   218,   610,
     611,     0,   612,  1518,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,  1519,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1520,  1521,
       0,     0,   633,  1522,   634,  1523,  1524,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,  1526,     0,   647,   648,   649,   650,   651,   701,  1527,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,  1535,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,  2889,  2890,     0,     0,     0,
       0,     0,     0,     0,  1539,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,  1480,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,  1483,     0,  1484,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,  1496,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1499,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,  3611,   527,
     528,     0,   529,  1503,   182,   530,   183,     0,   531,   532,
     533,  1504,  1505,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,  1510,   550,
     195,   551,   552,   553,     0,   554,     0,  1083,   555,   556,
     557,     0,     0,   196,   197,   198,   199,  1513,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1514,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,   216,   604,   605,   606,   607,   608,
    1517,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1519,     0,   624,   625,   224,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,  1522,   634,  1523,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,  1526,     0,   647,   648,   649,
     650,   651,  2190,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,   237,   657,   658,   659,   660,   661,
     238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,
     662,   663,     0,     0,     0,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  3612,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,  1480,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,  1483,     0,  1484,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,  1496,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1499,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,  3611,   527,
     528,     0,   529,  1503,   182,   530,   183,     0,   531,   532,
     533,  1504,  1505,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,  1510,   550,
     195,   551,   552,   553,     0,   554,     0,  1083,   555,   556,
     557,     0,     0,   196,   197,   198,   199,  1513,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1514,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1517,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1519,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,  1522,   634,  1523,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,  1526,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,
     662,   663,     0,     0,     0,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  3612,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,  1480,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,  1483,     0,  1484,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,  1496,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1499,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1503,   182,   530,   183,     0,   531,   532,
     533,  1504,  1505,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,  1510,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,  1513,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1514,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1517,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1519,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,  1522,   634,  1523,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,  1526,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,
     662,   663,     0,     0,     0,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,   247,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,  1480,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,  1483,     0,  1484,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1485,  1486,  1487,  1488,  1489,  1490,
    1491,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,  1496,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1499,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1503,   182,   530,   183,     0,   531,   532,
     533,  1504,  1505,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,  1510,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,  1513,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1514,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1517,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1519,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,  1522,   634,  1523,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,  1526,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1528,  1529,  1530,  1531,  1532,  1533,  1534,  1535,   702,
     662,   663,     0,     0,     0,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  4187,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,   145,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  4766,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,  4113,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0, -1490,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0, -1490,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516, -1490,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521, -1490,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181, -1490,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188, -1490,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594, -1490,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,     0,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,  1630,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,    44,     0,     0,     0,    45,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,  3882,  3883,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,     0,    44,     0,     0,     0,    45,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,  3883,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,   216,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,   224,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,  2190,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,   237,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,   247,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,   216,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,   224,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,  2190,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,   237,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,   247,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,  1605,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,  3049,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,  4142,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,  4497,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,  1207,    45,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
     733,   426,   427,   428,   734,   735,   736,   737,   738,   739,
     740,   429,   430,   741,   431,   432,   133,   433,   434,   435,
       0,  1900,   137,  1901,  1902,   742,   436,   437,   438,   439,
     440,   743,   744,   441,   442,  1903,  1904,   443,   746,   444,
     445,   446,   447,     0,   747,   145,   748,   448,   449,   450,
     451,   148,   452,   693,   750,   453,   454,   455,   456,   457,
     458,   751,   151,   459,     0,   753,   754,   755,   152,   756,
     757,   758,   460,   461,   462,   463,   695,   464,  1905,  1906,
     465,   759,   466,   760,   467,   468,   469,   470,   471,   761,
     472,   473,   474,   762,   763,   475,   476,  1494,   478,   479,
     764,   480,   481,   482,   765,   483,   484,   485,   766,   486,
     487,   488,   489,     0,   490,   491,   492,     0,   767,   493,
     768,   494,  1907,   495,   769,   496,   770,   497,   169,   771,
     170,   498,   499,   500,   772,   501,     0,   773,   502,   774,
     503,   504,   697,   505,   506,   173,   507,   508,   509,   775,
     510,   511,   512,   513,   514,   515,   776,   516,   174,     0,
       0,   517,   518,   519,  1500,  1908,   779,  1909,   780,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,   781,
     527,   528,   782,   529,     0,   182,   530,   183,   783,   531,
     532,   533,   784,   785,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1910,   189,  1911,
     545,   546,     0,   786,   547,   548,   193,   549,   787,     0,
     550,  1912,   551,   552,   553,   788,   554,   789,   790,  3869,
     556,   557,   791,   792,     0,   197,   198,   199,     0,   558,
     559,   560,   561,   562,   563,   564,   793,   565,     0,   566,
       0,   567,   568,   569,   794,   570,   571,   572,   573,   574,
     575,   576,   577,  1913,   578,   579,   580,   581,   795,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
     796,   593,   594,   211,   595,   596,     0,   597,   598,   599,
     600,   601,   602,   700,   603,   797,   604,   605,   606,   607,
     608,   798,   609,  2485,   610,   611,   220,   612,  1915,   613,
     799,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,     0,   800,   624,   625,   801,   626,   627,   628,   629,
     630,   631,   802,  1916,  1917,     0,   804,   633,     0,   634,
       0,   805,   635,   636,   637,   638,   639,   640,   641,     0,
     807,   642,   643,   644,   645,   646,   808,   809,   647,   648,
     649,   650,   651,     0,  1918,   811,   652,   236,   653,   654,
     655,   812,   813,   656,   814,   815,   657,   658,   659,   660,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     702,   662,   663,     0,     0,     0,  1210,  1211,  1212,     0,
    3870,  3871,  1215,  1216,  1217,  1218,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1207,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,  1208,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,  1209,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,  1210,  1211,  1212,     0,  1213,
    1214,  1215,  1216,  1217,  1218,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1207,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,  1302,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,  1303,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,  1210,  1211,  1212,     0,  1213,  1214,
    1215,  1216,  1217,  1218,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1207,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,  1359,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,  1360,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  1361,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
       0,     0,     0,  1210,  1211,  1212,     0,  1213,  1214,  1215,
    1216,  1217,  1218,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1207,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,  1885,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,  1886,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
       0,     0,  1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,
    1217,  1218,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1207,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,  1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,
    1218,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,  3138,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,  3139,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,     0,     0,
    1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1207,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,  4749,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,     0,     0,     0,  1210,
    1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,   733,   426,   427,   428,   734,   735,   736,
     737,   738,   739,   740,   429,   430,   741,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,   742,   436,
     437,   438,   439,   440,   743,   744,   441,   442,   745,   140,
     443,   746,   444,   445,   446,   447,   144,   747,   145,   748,
     448,   449,   450,   451,   148,   452,   749,   750,   453,   454,
     455,   456,   457,   458,   751,   151,   459,   752,   753,   754,
     755,   152,   756,   757,   758,   460,   461,   462,   463,   695,
     464,   155,   156,   465,   759,   466,   760,   467,   468,   469,
     470,   471,   761,   472,   473,   474,   762,   763,   475,   476,
     477,   478,   479,   764,   480,   481,   482,   765,   483,   484,
     485,   766,   486,   487,   488,   489,   164,   490,   491,   492,
     166,   767,   493,   768,   494,   168,   495,   769,   496,   770,
     497,   169,   771,   170,   498,   499,   500,   772,   501,   172,
     773,   502,   774,   503,   504,   697,   505,   506,   173,   507,
     508,   509,   775,   510,   511,   512,   513,   514,   515,   776,
     516,   174,   175,   777,   517,   518,   519,   778,   176,   779,
     177,   780,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,   781,   527,   528,   782,   529,   181,   182,   530,
     183,   783,   531,   532,   533,   784,   785,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,   189,   190,   545,   546,   191,   786,   547,   548,   193,
     549,   787,   194,   550,   195,   551,   552,   553,   788,   554,
     789,   790,   555,   556,   557,   791,   792,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,   793,
     565,   201,   566,   202,   567,   568,   569,   794,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,   795,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,   796,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,   797,   604,
     605,   606,   607,   608,   798,   609,   218,   610,   611,   220,
     612,   221,   613,   799,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,   800,   624,   625,   801,   626,
     627,   628,   629,   630,   631,   802,   225,   226,   803,   804,
     633,   227,   634,   228,   805,   635,   636,   637,   638,   639,
     640,   641,   806,   807,   642,   643,   644,   645,   646,   808,
     809,   647,   648,   649,   650,   651,   810,   235,   811,   652,
     236,   653,   654,   655,   812,   813,   656,   814,   815,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,   726,    86,    87,    88,
     678,    90,    91,    92,   679,  2287,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
       0,  1900,   137,  1901,  1902,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,  1903,  1904,   443,     0,   444,
     445,   446,   447,     0,     0,   145,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,     0,     0,     0,   152,     0,
       0,     0,   460,   461,   462,   463,   695,   464,  1905,  1906,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1494,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,     0,   490,   491,   492,     0,     0,   493,
       0,   494,  1907,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,     0,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,     0,
       0,   517,   518,   519,  1500,  1908,     0,  1909,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,     0,   182,   530,   183,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1910,   189,  1911,
     545,   546,     0,     0,   547,   548,   193,   549,     0,     0,
     550,  1912,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,     0,   197,   198,   199,     0,   558,
     559,   560,   561,   562,   563,   564,     0,   565,     0,   566,
       0,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1913,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,     0,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,  1914,   610,   611,   220,   612,  1915,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,     0,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1916,  1917,     0,     0,   633,     0,   634,
       0,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,     0,  1918,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     702,   662,   663,     0,    86,    87,    88,   678,    90,    91,
      92,   679,  2392,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
       0,    86,    87,    88,   678,    90,    91,    92,   679,  1090,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,    86,    87,
      88,   678,    90,    91,    92,   679,  4790,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,   418,   988,   420,   421,   422,   423,   424,
     425,   989,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   990,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   991,   168,   495,     0,   496,     0,   992,     0,
     993,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
     994,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   995,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   996,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   997,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   998,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,   999,  1000,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,   418,   988,
     420,   421,   422,   423,   424,   425,   989,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,  1021,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   991,   168,   495,
       0,   496,     0,  1022,     0,   993,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,   994,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   995,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   996,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   997,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   998,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,   999,  1000,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,  1407,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
     993,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
     994,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,     0,     0,     0,     0,     0,     0,
       0,   999,  1000,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,  1412,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,   993,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,   994,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,   999,  1000,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,   696,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,  1576,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,     0,     0,  1061,  1577,    86,    87,
      88,   678,    90,    91,    92,   679,  1062,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,  1063,   442,  1037,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,  1064,     0,  1065,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,  1066,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,  1067,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,  1068,   596,   213,   597,   598,
     599,  1069,   601,   602,   700,   603,     0,   604,   605,   606,
     607,  1070,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1071,   226,     0,     0,  1072,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,  1041,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,  1073,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,   733,   426,
     427,   428,   734,   735,   736,   737,   738,   739,   740,   429,
     430,   741,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,   742,   436,   437,   438,   439,   440,   743,
     744,   441,   442,   745,   140,   443,   746,   444,   445,   446,
     447,   144,   747,   145,   748,   448,   449,   450,   451,   148,
     452,   749,   750,   453,   454,   455,   456,   457,   458,   751,
     151,   459,   752,   753,   754,   755,   152,   756,   757,   758,
     460,   461,   462,   463,   695,   464,   155,   156,   465,   759,
     466,   760,   467,   468,   469,   470,   471,   761,   472,   473,
     474,   762,   763,   475,   476,   477,   478,   479,   764,   480,
     481,   482,   765,   483,   484,   485,   766,   486,   487,   488,
     489,   164,   490,   491,   492,   166,   767,   493,   768,   494,
     168,   495,   769,   496,   770,   497,   169,   771,   170,   498,
     499,   500,   772,   501,   172,   773,   502,   774,   503,   504,
     697,   505,   506,   173,   507,   508,   509,   775,   510,   511,
     512,   513,   514,   515,   776,   516,   174,   175,   777,   517,
     518,   519,   778,   176,   779,   177,   780,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,   781,   527,   528,
     782,   529,   181,   182,   530,   183,   783,   531,   532,   533,
     784,   785,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,   786,   547,   548,   193,   549,   787,   194,   550,   195,
     551,   552,   553,   788,   554,   789,   790,   555,   556,   557,
     791,   792,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,   793,   565,   201,   566,   202,   567,
     568,   569,   794,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,   795,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   796,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,   797,   604,   605,   606,   607,   608,   798,
     609,   218,   610,   611,   220,   612,   221,   613,   799,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
     800,   624,   625,   801,   626,   627,   628,   629,   630,   631,
     802,   225,   226,   803,   804,   633,   227,   634,   228,   805,
     635,   636,   637,   638,   639,   640,   641,   806,   807,   642,
     643,   644,   645,   646,   808,   809,   647,   648,   649,   650,
     651,   810,   235,   811,   652,   236,   653,   654,   655,   812,
     813,   656,   814,   815,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,   733,   426,   427,   428,   734,
     735,   736,   737,   738,   739,   740,   429,   430,   741,   431,
     432,   133,   433,   434,   435,   135,   136,   137,   138,   139,
     742,   436,   437,   438,   439,   440,   743,   744,   441,   442,
     745,   140,   443,   746,   444,   445,   446,   447,   144,   747,
     145,   748,   448,   449,   450,   451,   148,   452,   749,   750,
     453,   454,   455,   456,   457,   458,   751,   151,   459,   752,
     753,   754,   755,   152,   756,   757,   758,   460,   461,   462,
     463,   695,   464,   155,   156,   465,   759,   466,   760,   467,
     468,   469,   470,   471,   761,   472,   473,   474,   762,   763,
     475,   476,   477,   478,   479,   764,   480,   481,   482,   765,
     483,   484,   485,   766,   486,   487,   488,   489,   164,   490,
     491,   492,   166,   767,   493,   768,   494,   168,   495,   769,
     496,   770,   497,   169,   771,   170,   498,   499,   500,   772,
     501,   172,   773,   502,   774,   503,   504,   697,   505,   506,
     173,   507,   508,   509,   775,   510,   511,   512,   513,   514,
     515,   776,   516,   174,   175,   777,   517,   518,   519,   778,
     176,   779,   177,   780,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,   781,   527,   528,   782,   529,   181,
     182,   530,   183,   783,   531,   532,   533,   784,   785,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,   189,   190,   545,   546,   191,   786,   547,
     548,   193,   549,   787,   194,   550,   195,   551,   552,   553,
     788,   554,   789,   790,   555,   556,   557,   791,   792,   196,
     197,   198,   199,   200,   558,   559,   560,   561,   562,   563,
     564,   793,   565,   201,   566,   202,   567,   568,   569,   794,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,   795,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,   796,   593,   594,   211,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
     797,   604,   605,   606,   607,   608,   798,   609,   218,   610,
     611,   220,   612,   221,   613,   799,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,   800,   624,   625,
     801,   626,   627,   628,   629,   630,   631,   802,   225,   226,
     803,   804,   633,   227,   634,   228,   805,   635,   636,   637,
     638,   639,   640,   641,   806,   807,   642,   643,   644,   645,
     646,   808,   809,   647,   648,   649,   650,   651,   810,   235,
     811,   652,   236,   653,   654,   655,   812,   813,   656,   814,
     815,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,  3203,   423,
     424,   425,   733,   426,   427,   428,   734,   735,   736,   737,
     738,   739,   740,   429,   430,   741,   431,   432,   133,   433,
     434,   435,   135,   136,   137,   138,   139,   742,   436,   437,
     438,   439,   440,   743,   744,   441,   442,   745,   140,   443,
     746,   444,   445,   446,   447,   144,   747,   145,   748,   448,
     449,   450,   451,   148,   452,   749,   750,   453,   454,   455,
     456,   457,   458,   751,   151,   459,   752,   753,   754,   755,
     152,   756,   757,   758,   460,   461,   462,   463,   695,   464,
     155,   156,   465,   759,   466,   760,   467,   468,   469,   470,
     471,   761,   472,   473,   474,   762,   763,   475,   476,   477,
    3204,   479,   764,   480,   481,   482,   765,   483,   484,   485,
     766,   486,   487,   488,   489,   164,   490,   491,   492,   166,
     767,   493,   768,   494,   168,   495,   769,   496,   770,   497,
     169,   771,   170,   498,   499,   500,   772,   501,   172,   773,
     502,   774,   503,   504,   697,   505,   506,   173,   507,   508,
     509,   775,   510,   511,   512,   513,   514,   515,   776,   516,
     174,   175,   777,   517,   518,   519,   778,   176,   779,   177,
     780,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,   781,   527,   528,   782,   529,   181,   182,   530,   183,
     783,   531,   532,   533,   784,   785,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
     189,   190,   545,   546,   191,   786,   547,   548,   193,   549,
     787,   194,   550,   195,   551,   552,   553,   788,   554,   789,
     790,   555,   556,   557,   791,   792,   196,   197,   198,   199,
     200,   558,   559,   560,   561,   562,   563,   564,   793,   565,
     201,   566,   202,   567,   568,   569,   794,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
     795,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,   796,   593,   594,   211,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,   797,   604,   605,
     606,   607,   608,   798,  3205,   218,   610,   611,   220,   612,
     221,   613,   799,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,   800,   624,   625,   801,   626,   627,
     628,   629,   630,   631,   802,   225,   226,   803,   804,   633,
     227,   634,   228,   805,   635,   636,   637,   638,   639,   640,
     641,   806,   807,   642,   643,   644,   645,   646,   808,   809,
     647,   648,   649,   650,   651,   810,   235,   811,   652,   236,
     653,   654,   655,   812,   813,   656,   814,   815,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,   145,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,   136,   137,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,   145,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    1342,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,   189,   190,   545,   546,   191,     0,
     547,   548,   193,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,   197,   198,   199,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,   220,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,   135,   136,   137,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,   145,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  1352,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,   189,   190,   545,   546,   191,     0,   547,   548,   193,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,   197,   198,
     199,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,   220,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
       0,  1900,   137,  1901,  1902,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,  1903,  1904,   443,     0,   444,
     445,   446,   447,     0,     0,   145,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,     0,     0,     0,   152,     0,
       0,     0,   460,   461,   462,   463,   695,   464,  1905,  1906,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1494,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,     0,   490,   491,   492,     0,     0,   493,
       0,   494,  1907,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,     0,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,  2482,
     510,   511,   512,   513,   514,   515,     0,   516,   174,  2483,
       0,   517,   518,   519,  1500,  1908,     0,  1909,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,     0,   182,   530,   183,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1910,   189,  1911,
     545,   546,     0,     0,   547,   548,   193,   549,     0,     0,
     550,  1912,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,  2484,   197,   198,   199,     0,   558,
     559,   560,   561,   562,   563,   564,     0,   565,     0,   566,
       0,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1913,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,     0,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,  2485,   610,   611,   220,   612,  1915,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,     0,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1916,  1917,     0,     0,   633,     0,   634,
       0,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,     0,  1918,  2486,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     702,   662,   663,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,     0,  1900,   137,
    1901,  1902,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,  1903,  1904,   443,     0,   444,   445,   446,   447,
       0,     0,   145,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,   695,   464,  1905,  1906,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1494,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
       0,   490,   491,   492,     0,     0,   493,     0,   494,  1907,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,     0,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,     0,     0,   517,   518,
     519,  1500,  1908,     0,  1909,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,     0,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1910,   189,  1911,   545,   546,     0,
       0,   547,   548,   193,   549,  2470,     0,   550,  1912,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,     0,   197,   198,   199,     0,   558,   559,   560,   561,
     562,   563,   564,     0,   565,     0,   566,     0,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1913,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,     0,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
    2485,   610,   611,   220,   612,  1915,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,     0,     0,
     624,   625,  3973,   626,   627,   628,   629,   630,   631,     0,
    1916,  1917,     0,     0,   633,     0,   634,     0,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
       0,  1918,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   702,   662,   663,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,     0,  1900,   137,  1901,  1902,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,  1903,
    1904,   443,     0,   444,   445,   446,   447,     0,     0,   145,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
     695,   464,  1905,  1906,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1494,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,     0,   490,   491,
     492,     0,     0,   493,     0,   494,  1907,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
       0,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,     0,     0,   517,   518,   519,  1500,  1908,
       0,  1909,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,     0,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1910,   189,  1911,   545,   546,  2536,     0,   547,   548,
     193,   549,     0,     0,   550,  1912,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,     0,   197,
     198,   199,     0,   558,   559,   560,   561,   562,   563,   564,
       0,   565,     0,   566,     0,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1913,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
       0,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,  1914,   610,   611,
     220,   612,  1915,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,     0,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1916,  1917,     0,
       0,   633,     0,   634,     0,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,  1918,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   702,   662,   663,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,     0,  1900,   137,  1901,  1902,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,  1903,  1904,   443,     0,
     444,   445,   446,   447,     0,     0,   145,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,     0,     0,     0,   152,
       0,     0,     0,   460,   461,   462,   463,   695,   464,  1905,
    1906,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1494,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,     0,   490,   491,   492,     0,     0,
     493,     0,   494,  1907,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,     0,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
       0,     0,   517,   518,   519,  1500,  1908,     0,  1909,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,     0,   182,   530,   183,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1910,   189,
    1911,   545,   546,  3805,     0,   547,   548,   193,   549,     0,
       0,   550,  1912,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,     0,   197,   198,   199,     0,
     558,   559,   560,   561,   562,   563,   564,     0,   565,     0,
     566,     0,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1913,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,     0,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,  1914,   610,   611,   220,   612,  1915,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,     0,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1916,  1917,     0,     0,   633,     0,
     634,     0,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,     0,  1918,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   702,   662,   663,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,     0,  1900,
     137,  1901,  1902,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,  1903,  1904,   443,     0,   444,   445,   446,
     447,     0,     0,   145,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,   695,   464,  1905,  1906,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1494,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,     0,   490,   491,   492,     0,     0,   493,     0,   494,
    1907,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,     0,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,     0,     0,   517,
     518,   519,  1500,  1908,     0,  1909,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,     0,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1910,   189,  1911,   545,   546,
       0,     0,   547,   548,   193,   549,     0,     0,   550,  1912,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,     0,   197,   198,   199,     0,   558,   559,   560,
     561,   562,   563,   564,     0,   565,     0,   566,     0,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1913,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,     0,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,  1914,   610,   611,   220,   612,  1915,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,     0,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1916,  1917,     0,     0,   633,     0,   634,     0,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,     0,  1918,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   702,   662,
     663,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,     0,  1900,   137,  1901,  1902,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
    1903,  1904,   443,     0,   444,   445,   446,   447,     0,     0,
     145,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,   695,   464,  1905,  1906,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1494,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,     0,   490,
     491,   492,     0,     0,   493,     0,   494,  1907,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,     0,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,     0,     0,   517,   518,   519,  1500,
    1908,     0,  1909,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,     0,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1910,   189,  1911,   545,   546,     0,     0,   547,
     548,   193,   549,     0,     0,   550,  1912,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,     0,
     197,   198,   199,     0,   558,   559,   560,   561,   562,   563,
     564,     0,   565,     0,   566,     0,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1913,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,     0,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,  2485,   610,
     611,   220,   612,  1915,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,     0,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1916,  1917,
       0,     0,   633,     0,   634,     0,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,     0,  1918,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   702,   662,   663,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,     0,  1900,   137,  1901,  1902,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,  1903,  1904,   443,
       0,   444,   445,   446,   447,     0,     0,   145,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,   695,   464,
    1905,  1906,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1494,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,     0,   490,   491,   492,     0,
       0,   493,     0,   494,  1907,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,     0,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,     0,     0,   517,   518,   519,  1500,  1908,     0,  1909,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,     0,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1910,
     189,  1911,   545,   546,     0,     0,   547,   548,   193,   549,
       0,     0,   550,  1912,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,     0,   197,   198,   199,
       0,   558,   559,   560,   561,   562,   563,   564,     0,   565,
       0,   566,     0,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1913,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,     0,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,     0,   610,   611,   220,   612,
    1915,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,     0,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1916,  1917,     0,     0,   633,
       0,   634,     0,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,     0,  1918,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   702,   662,   663,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,     0,
       0,   137,     0,     0,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,     0,     0,   443,     0,   444,   445,
     446,   447,     0,     0,   145,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,   695,   464,     0,     0,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,     0,   490,   491,   492,     0,     0,   493,     0,
     494,     0,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,     0,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,     0,     0,
     517,   518,   519,     0,     0,     0,     0,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,     0,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,     0,   189,     0,   545,
     546,     0,     0,   547,   548,   193,   549,     0,     0,   550,
       0,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,     0,   197,   198,   199,     0,   558,   559,
     560,   561,   562,   563,   564,     0,   565,     0,   566,     0,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,     0,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,     0,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,     0,   610,   611,   220,   612,     0,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
       0,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,     0,     0,     0,     0,   633,     0,   634,     0,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,     0,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,   733,   426,   427,   428,   734,
     735,   736,   737,   738,   739,   740,   429,   430,   741,   431,
     432,   133,   433,   434,   435,   135,   136,   137,   138,   139,
     742,   436,   437,   438,   439,   440,   743,   744,   441,   442,
       0,   140,   443,   746,   444,   445,   446,   447,   144,   747,
     145,   748,   448,   449,   450,   451,   148,   452,   749,   750,
     453,   454,   455,   456,   457,   458,   751,   151,   459,     0,
     753,   754,   755,   152,   756,   757,   758,   460,   461,   462,
     463,     0,   464,   155,   156,   465,   759,   466,   760,   467,
     468,   469,   470,   471,   761,   472,   473,   474,   762,   763,
     475,   476,   477,   478,   479,   764,   480,   481,   482,   765,
     483,   484,   485,   766,   486,   487,   488,   489,   164,   490,
     491,   492,   166,   767,   493,   768,   494,   168,   495,   769,
     496,   770,   497,   169,   771,   170,   498,   499,   500,   772,
     501,   172,   773,   502,   774,   503,   504,     0,   505,   506,
     173,   507,   508,   509,   775,   510,   511,   512,   513,   514,
     515,   776,   516,   174,   175,     0,   517,   518,   519,     0,
     176,   779,   177,   780,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,   781,   527,   528,   782,   529,   181,
     182,   530,   183,   783,   531,   532,   533,   784,   785,   534,
     535,   536,   537,   538,   539,     0,   540,   541,     0,   542,
     543,   544,   188,   189,   190,   545,   546,   191,   786,   547,
     548,   193,   549,   787,   194,   550,   195,   551,   552,   553,
     788,   554,   789,   790,   555,   556,   557,   791,   792,   196,
     197,   198,   199,   200,   558,   559,   560,   561,   562,   563,
     564,   793,   565,   201,   566,   202,   567,   568,   569,   794,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,   795,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,   796,   593,   594,   211,   595,
     596,   213,   597,   598,   599,   600,   601,   602,     0,   603,
     797,   604,   605,   606,   607,   608,   798,   609,   218,   610,
     611,   220,   612,   221,   613,   799,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,   800,   624,   625,
     801,   626,   627,   628,   629,   630,   631,   802,   225,   226,
       0,   804,   633,   227,   634,   228,   805,   635,   636,   637,
     638,   639,   640,   641,     0,   807,   642,   643,   644,   645,
     646,   808,   809,   647,   648,   649,   650,   651,     0,   235,
     811,   652,   236,   653,   654,   655,   812,   813,   656,   814,
     815,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,     0,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,  1152,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,  2416,   444,   445,   446,   447,   144,     0,     0,  2498,
     448,   449,   450,   451,     0,   452,   693,  2417,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,  2499,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,  2419,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,  2420,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,  2421,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,  2416,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,  2417,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,  2499,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,  2419,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,  3366,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,  2420,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,  2421,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,  1050,   424,   425,  1008,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,  1009,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,  1051,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,  1010,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
    1011,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,  1008,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,  1009,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,  3100,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,  1010,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,  1011,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,  2416,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,  2417,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,  2499,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,  2419,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,  2420,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,  2421,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,   691,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,   694,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
     696,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,  1008,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,  1009,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,  1010,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
    1011,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,   920,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,   921,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   922,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,  2091,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,  2092,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,  2093,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,  2094,   497,     0,     0,     0,  2095,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,  2096,  2097,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,  2098,   601,   602,
     700,   603,     0,  2099,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,  2100,   626,  2101,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,  2102,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,  1009,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,  1010,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,  1011,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,  2080,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,  2374,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,  2975,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
    2976,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,  2977,   626,   627,  2978,   629,  2979,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,  2980,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,   718,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,   417,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,   696,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,   870,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,  1334,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,   130,   131,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,  3187,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,  3188,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,  3199,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,  3200,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
     417,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,   417,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   926,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   970,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,  1025,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,  1083,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  1230,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,  1083,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,  1579,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  1754,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,  1083,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
    1988,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,  2080,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,  2374,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,  4113,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,  4127,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
    4347,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,  4349,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,  4351,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,  4752,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,  1034,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,  1036,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
    1037,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,     0,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,  1038,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1039,   226,
       0,     0,  1040,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,  1041,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,  1077,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,  1037,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,     0,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,  1078,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1079,   226,     0,     0,  1080,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,  1041,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,  1097,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  1203,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  1227,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  1239,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1293,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  1307,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  1347,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  1366,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  1368,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1370,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  1373,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  1379,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,  1590,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,  1063,   442,  1037,   140,  1591,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,     0,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,  1067,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,  1068,   596,   213,   597,   598,   599,  1069,
     601,   602,   700,   603,     0,   604,   605,   606,   607,  1583,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1071,   226,     0,     0,  1072,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,  1041,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,  1073,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,  1717,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  1800,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  1947,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  1977,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  2012,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  2014,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  2016,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,  2129,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,  2340,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,     0,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,  2735,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  3111,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,   692,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,  3190,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,   225,   226,     0,     0,   633,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,   701,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,  3192,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,  3290,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,  1063,   442,  1037,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,     0,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,  1067,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,  1068,   596,   213,   597,   598,   599,  1069,
     601,   602,   700,   603,     0,   604,   605,   606,   607,  1583,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1071,   226,     0,     0,  1072,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,  1041,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,  1073,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,  1063,   442,
    1037,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,     0,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,  1067,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,  1068,
     596,   213,   597,   598,   599,  1069,   601,   602,   700,   603,
       0,   604,   605,   606,   607,  1583,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,  2407,   628,   629,   630,   631,     0,  1071,   226,
       0,     0,  1072,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,  1041,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,  1073,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     681,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,     0,   433,   434,
     435,   135,   136,     0,   138,   139,     0,   436,   437,   438,
     439,   440,     0,     0,  1063,   442,  1037,   140,   443,     0,
     444,   445,   446,   447,   144,     0,     0,     0,   448,   449,
     450,   451,     0,   452,     0,     0,   453,   454,   455,   456,
     457,   458,     0,     0,   459,     0,     0,     0,     0,     0,
       0,     0,     0,   460,   461,   462,   463,   695,   464,   155,
     156,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,   477,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,   164,   490,   491,   492,   166,     0,
     493,     0,   494,   168,   495,     0,   496,     0,   497,     0,
       0,     0,   498,   499,   500,     0,   501,   172,     0,   502,
       0,   503,   504,   697,   505,   506,     0,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,     0,
     175,     0,   517,   518,   519,     0,   176,     0,   177,     0,
     520,     0,     0,   521,     0,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,   181,     0,   530,     0,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,  1067,   188,     0,
     190,   545,   546,   191,     0,   547,   548,     0,   549,     0,
     194,   550,   195,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,   196,     0,     0,     0,   200,
     558,   559,   560,   561,   562,   563,   564,     0,   565,   201,
     566,   202,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,     0,  1068,   596,   213,   597,   598,
     599,  2474,   601,   602,   700,   603,     0,   604,   605,   606,
     607,  2475,     0,   609,   218,   610,   611,     0,   612,   221,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1071,   226,     0,     0,  2476,   227,
     634,   228,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,  1041,   235,     0,   652,     0,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,  1073,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
    1063,   442,  1037,   140,   443,     0,   444,   445,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
       0,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,  1067,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,  1068,   596,   213,   597,   598,   599,  1069,   601,   602,
     700,   603,     0,   604,   605,   606,   607,  2475,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1071,   226,     0,     0,  2476,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
    1041,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,  1073,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,     0,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,     0,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
       0,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115, -2391,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,    35,     0,   412,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,   145,     0,     0,     0,     0,     0,
     148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,   156,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,   166,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0,     0,     0,     0,   176,     0,   177,     0,     0,   178,
     179,     0,   180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   193,     0,     0,   194,     0,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   218,     0,     0,   220,     0,   221,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     223,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   225,   226,     0,     0,     0,   227,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,   231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   235,     0,     0,   236,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115, -2392,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,   127,    35,     0,  1147,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,   145,     0,     0,
       0,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
     152,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   162,     0,     0,
       0,     0,     0,     0,     0,   164,     0,     0,     0,   166,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0,     0,     0,     0,   176,     0,   177,
       0,     0,   178,   179,     0,   180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   181,   182,     0,   183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,   193,     0,
       0,   194,     0,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,   197,   198,   199,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   213,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   218,     0,     0,   220,     0,
     221,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   225,   226,     0,     0,     0,
     227,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,   231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   235,     0,     0,   236,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
     145,     0,     0,     0,     0,     0,   148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,   156,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     176,     0,   177,     0,     0,   178,   179,     0,   180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,     0,   183,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
       0,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   213,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   218,     0,
       0,   220,     0,   221,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   223,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   225,   226,
       0,     0,     0,   227,     0,   228,     0,     0,     0,     0,
       0,     0,     0,     0,   231,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   235,
       0,     0,   236,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   238,   239,   240,   241,
     242,   243,   244,   245,   246,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,     0,     0,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,   145,     0,     0,     0,     0,     0,   148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,   152,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   155,   156,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   162,     0,     0,     0,     0,     0,     0,
       0,   164,     0,     0,     0,   166,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   176,     0,   177,     0,     0,   178,   179,
       0,   180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,     0,   183,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   218,     0,     0,   220,     0,   221,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   223,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   225,   226,     0,     0,     0,   227,     0,   228,     0,
       0,     0,     0,     0,     0,     0,     0,   231,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   235,     0,     0,   236,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,   145,     0,     0,     0,
       0,     0,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   151,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
     156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   164,     0,     0,     0,   166,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   176,     0,   177,     0,
       0,   178,   179,     0,   180,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,     0,   183,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   188,   189,
     190,     0,     0,   191,     0,     0,     0,   193,     0,     0,
     194,     0,   195,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,   197,   198,   199,   200,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   201,
       0,   202,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   218,     0,     0,   220,     0,   221,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   223,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   225,   226,     0,     0,     0,   227,
       0,   228,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   235,     0,     0,   236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   238,   239,   240,   241,   242,   243,   244,   245,
     246,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
     136,   137,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,     0,   140,   443,     0,   444,   445,
     446,   447,   144,     0,   145,     0,   448,   449,   450,   451,
     148,   452,     0,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,     0,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,  2056,   493,     0,
     494,   168,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,     0,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,     0,
     540,   541,     0,   542,   543,   544,   188,   189,   190,   545,
     546,   191,     0,   547,   548,   193,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,  2057,     0,   555,   556,
     557,     0,     0,   196,   197,   198,   199,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,   213,   597,   598,   599,   600,
     601,   602,     0,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,   220,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
    2058,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,   235,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,    35,
     662,   663,     0,     0,     0,     0,     0,    41,    42,  1674,
    1675,  4603,     0,     0,     0,     0,     0,     0,  4604,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,   130,   131,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,     0,   140,   443,     0,   444,   445,   446,   447,
     144,     0,   145,     0,   448,   449,   450,   451,   148,   452,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,     0,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,     0,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,     0,   540,   541,
       0,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
       0,   603,   216,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,   224,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     234,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,   237,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   662,   663,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,   247,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,     0,   140,   443,     0,   444,   445,   446,
     447,   144,     0,   145,     0,   448,   449,   450,   451,   148,
     452,     0,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,     0,   464,   155,   156,   465,  2275,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,  2056,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
       0,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,     0,   540,
     541,     0,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,  2057,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,     0,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,  2058,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,     0,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,     0,   662,
     663,     0,     0,     0,     0,     0,    35,   417,  1674,  1675,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,     0,
     140,   443,     0,   444,   445,   446,   447,   144,     0,   145,
       0,   448,   449,   450,   451,   148,   452,     0,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
       0,   464,   155,   156,   465,  2280,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,  2056,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,     0,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,     0,   540,   541,     0,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,  2057,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,     0,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,  2058,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,     0,   662,   663,     0,     0,     0,
       0,     0,    35,   417,  1674,  1675,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,   136,   137,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,     0,   140,   443,     0,   444,
     445,   446,   447,   144,     0,   145,     0,   448,   449,   450,
     451,   148,   452,     0,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,     0,     0,     0,   152,     0,
       0,     0,   460,   461,   462,   463,     0,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,  2056,   493,
       0,   494,   168,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,     0,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,   182,   530,   183,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
       0,   540,   541,     0,   542,   543,   544,   188,   189,   190,
     545,   546,   191,     0,   547,   548,   193,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,  2057,     0,   555,
     556,   557,     0,     0,   196,   197,   198,   199,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,   213,   597,   598,   599,
     600,   601,   602,     0,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,   220,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,  2058,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,     0,   235,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
       0,   662,   663,     0,     0,     0,     0,     0,    35,     0,
    1674,  1675,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,   136,   137,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,     0,   140,   443,     0,   444,   445,   446,   447,   144,
       0,   145,     0,   448,   449,   450,   451,   148,   452,     0,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,     0,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,  2056,   493,     0,   494,   168,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,     0,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,     0,   540,   541,     0,
     542,   543,   544,   188,   189,   190,   545,   546,   191,     0,
     547,   548,   193,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,  2057,     0,   555,   556,   557,     0,     0,
     196,   197,   198,   199,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,   213,   597,   598,   599,   600,   601,   602,     0,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,   220,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,  2058,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,     0,
     235,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,     0,   662,   663,    35,
     417,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,     0,   140,   443,     0,   444,   445,   446,   447,
     144,     0,   145,     0,   448,   449,   450,   451,   148,   452,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,     0,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,   493,     0,   494,   168,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,     0,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,     0,   540,   541,
       0,   542,   543,   544,   188,   189,   190,   545,   546,   191,
       0,   547,   548,   193,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
       0,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,   220,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,   632,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
       0,   235,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,     0,   662,   663,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,     0,   140,   443,     0,   444,   445,   446,
     447,   144,     0,   145,     0,   448,   449,   450,   451,   148,
     452,     0,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,     0,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
       0,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,     0,   540,
     541,     0,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,     0,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,     0,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    35,   662,
     663,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,   136,   137,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,     0,   140,   443,     0,   444,   445,   446,   447,   144,
       0,   145,     0,   448,   449,   450,   451,   148,   452,     0,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,     0,   464,   155,   156,   465,  2260,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,     0,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,     0,   540,   541,     0,
     542,   543,   544,   188,   189,   190,   545,   546,   191,     0,
     547,   548,   193,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,   197,   198,   199,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,   213,   597,   598,   599,   600,   601,   602,     0,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,   220,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,     0,
     235,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    35,   662,   663,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,     0,
     140,   443,     0,   444,   445,   446,   447,   144,     0,   145,
       0,   448,   449,   450,   451,   148,   452,     0,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
       0,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,     0,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,     0,   540,   541,     0,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,     0,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    35,   662,   663,     0,    37,    38,
      39,    40,    41,    42,     0,    44,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,   136,   137,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,     0,   140,   443,
       0,   444,   445,   446,   447,   144,     0,   145,     0,   448,
     449,   450,   451,   148,   452,     0,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,     0,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,     0,   505,  2036,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,     0,   540,   541,     0,   542,   543,   544,   188,
     189,   190,   545,   546,   191,     0,   547,   548,   193,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,   197,   198,   199,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,   213,   597,
     598,   599,   600,   601,   602,     0,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,   220,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,     0,   235,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    35,   662,   663,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,   136,   137,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,     0,   140,   443,     0,   444,
     445,   446,   447,   144,     0,   145,     0,   448,   449,   450,
     451,   148,   452,     0,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,     0,     0,     0,   152,     0,
       0,  2595,   460,   461,   462,   463,     0,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,     0,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,   182,   530,   183,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
       0,   540,   541,     0,   542,   543,   544,   188,   189,   190,
     545,   546,   191,     0,   547,   548,   193,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,   197,   198,   199,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,   213,   597,   598,   599,
     600,   601,   602,     0,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,   220,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,  2596,     0,   647,   648,
     649,   650,   651,     0,   235,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      35,   662,   663,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,   130,   131,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,     0,   140,   443,     0,   444,   445,   446,
     447,   144,     0,   145,     0,   448,   449,   450,   451,   148,
     452,     0,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,     0,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
       0,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,     0,   540,
     541,     0,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,     0,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,     0,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    35,   662,
     663,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,  1223,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,   136,   137,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,     0,   140,   443,     0,   444,   445,   446,   447,   144,
       0,   145,     0,   448,   449,   450,   451,   148,   452,     0,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,     0,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,     0,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,     0,   540,   541,     0,
     542,   543,   544,   188,   189,   190,   545,   546,   191,     0,
     547,   548,   193,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,   197,   198,   199,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,   213,   597,   598,   599,   600,   601,   602,     0,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,   220,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,     0,
     235,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    35,   662,   663,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,  1236,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,     0,
     140,   443,     0,   444,   445,   446,   447,   144,     0,   145,
       0,   448,   449,   450,   451,   148,   452,     0,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
       0,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,     0,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
    1237,   537,   538,   539,     0,   540,   541,     0,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,     0,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    35,   662,   663,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,   136,   137,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,     0,   140,   443,
       0,   444,   445,   446,   447,   144,     0,   145,     0,   448,
     449,   450,   451,   148,   452,     0,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,     0,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,   172,  3471,
     502,     0,   503,   504,     0,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,     0,   540,   541,     0,   542,   543,   544,   188,
     189,   190,   545,   546,   191,     0,   547,   548,   193,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,   197,   198,   199,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,   213,   597,
     598,   599,   600,   601,   602,     0,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,   220,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,     0,   235,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,    35,   662,   663,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,   136,   137,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,     0,   140,   443,     0,   444,
     445,   446,   447,   144,     0,   145,     0,   448,   449,   450,
     451,   148,   452,     0,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,     0,     0,     0,   152,     0,
       0,     0,   460,   461,   462,   463,     0,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,     0,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,   182,   530,   183,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
       0,   540,   541,     0,   542,   543,   544,   188,   189,   190,
     545,   546,   191,     0,   547,   548,   193,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,   197,   198,   199,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,   213,   597,   598,   599,
     600,   601,   602,     0,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,   220,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,     0,   235,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
      35,   662,   663,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,     0,   140,   443,     0,   444,   445,   446,
     447,   144,     0,   145,     0,   448,   449,   450,   451,   148,
     452,     0,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,     0,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
       0,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,  1315,   537,   538,   539,     0,   540,
     541,     0,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,     0,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,     0,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,    35,   662,
     663,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,   136,   137,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,     0,   140,   443,     0,   444,   445,   446,   447,   144,
       0,   145,     0,   448,   449,   450,   451,   148,   452,     0,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,     0,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,     0,   505,
    1354,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,     0,   540,   541,     0,
     542,   543,   544,   188,   189,   190,   545,   546,   191,     0,
     547,   548,   193,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,   197,   198,   199,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,   213,   597,   598,   599,   600,   601,   602,     0,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,   220,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,     0,
     235,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    35,   662,   663,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,     0,
     140,   443,     0,   444,   445,   446,   447,   144,     0,   145,
       0,   448,   449,   450,   451,   148,   452,     0,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
       0,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,     0,   505,  1364,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,     0,   540,   541,     0,   542,   543,
     544,   188,   189,   190,   545,   546,   191,     0,   547,   548,
     193,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,     0,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
     220,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,   235,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,    35,   662,   663,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,   136,   137,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,     0,   140,   443,
       0,   444,   445,   446,   447,   144,     0,   145,     0,   448,
     449,   450,   451,   148,   452,     0,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,     0,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,     0,   505,  1375,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,  1376,   537,
     538,   539,     0,   540,   541,     0,   542,   543,   544,   188,
     189,   190,   545,   546,   191,     0,   547,   548,   193,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,   197,   198,   199,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,   213,   597,
     598,   599,   600,   601,   602,     0,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,   220,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,     0,   235,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,   662,   663
};

static const yytype_int16 yycheck[] =
{
       2,    78,   247,    78,    78,   364,    78,  1065,    78,   894,
    1009,  1010,  1011,  1113,  1353,  1362,  1015,   167,   229,  1118,
    1229,  1775,   154,  1357,  1431,   150,   153,   210,  1081,  1628,
      78,  1141,     2,   852,  1248,   932,    84,   187,  1740,   224,
    1183,  1930,  2045,  1224,  1401,  1611,  2095,  1914,  1450,  1285,
    2831,  1521,   165,  1464,  1793,  2490,  2491,  1238,  1492,  1493,
    1228,   171,  2632,  1231,   724,   950,   160,  1393,    78,   117,
    1072,   203,  1240,  1304,    84,   894,    78,  1511,  1780,   976,
     932,   380,    84,  1314,  2667,  2249,  1784,    89,   165,  1873,
    2990,  2675,  3153,  1973,   132,  1205,  3427,   380,  1932,    78,
     210,  3364,  1841,  1842,  3416,  1828,    96,  1343,  1775,  1290,
    1668,  1669,  1670,  1294,   162,   117,   106,  3203,  1299,  3205,
    1632,  2299,  2134,  3666,  2585,  1306,  3715,  3332,   117,   725,
    1160,   950,  1160,  2984,  3049,  1316,  2809,   352,  1836,  3345,
    3345,  2988,    94,  2986,  2987,   975,  3763,  2168,  3708,  3612,
    3974,   153,   142,  3953,  2034,  3963,   217,  1723,  3618,  1780,
     162,  2182,  3911,  1767,  1414,   952,  4192,   157,  1394,  2923,
    1385,  1068,   366,   162,  4397,   962,  1727,  1976,  1481,  1482,
     132,  1200,  1110,   231,  1155,  1156,  1110,  3676,  3549,    21,
     117,  3042,   167,  2347,  1663,  1664,  3617,    10,    88,    30,
    1984,   153,   154,   366,  1507,    72,   967,   209,    72,    14,
    2231,   163,   187,  1539,   117,   217,  1068,   219,   135,   108,
     209,    95,    86,  3951,   121,    72,  2535,   128,   217,   231,
     219,  4538,    37,  2387,  3962,   162,   114,  2391,   153,    86,
     112,   832,   231,  4678,    72,  3349,  3350,  3351,  3352,  3353,
    3354,   203,   156,    81,    95,   180,   102,    84,    86,   162,
     920,    75,    76,    77,    78,    99,   149,    72,    82,   114,
      75,    76,    77,    78,   143,   145,    81,    82,    83,    84,
      78,    86,   267,   153,  1283,    75,    76,    77,    78,  3878,
     229,  1401,    82,   103,   104,   372,    99,   372,   372,   237,
     372,  3055,   372,   106,   231,    99,   267,    72,   128,   128,
     228,  2200,   106,    88,   210,   117,    81,    75,    76,    77,
      78,    86,   230,   197,    82,   112,   355,   187,   231,  3883,
     228,   322,   380,    78,   228,    78,   160,    78,   113,   182,
     385,  1394,     0,    89,    78,   135,   228,   204,    75,    76,
      77,    78,   192,   145,   194,    82,   197,    99,   401,   180,
     162,  2670,   109,    90,   106,    78,   180,   415,   143,    78,
     380,   312,    75,    76,    77,    78,   387,   365,   380,    82,
     230,  1595,  4562,  1268,   223,   182,   182,    75,    76,    77,
      78,   209,    78,   372,    82,    78,    88,  1540,   509,  2448,
     511,   219,  1062,    78,    78,   415,    78,   395,   258,   233,
     145,    93,  4592,   415,   228,   149,   145,   227,   359,   229,
     328,  1564,    78,    75,    76,    77,    78,   438,   271,   231,
      82,   165,   135,  4671,   145,  2744,   424,  2746,    90,   145,
    4663,   188,   199,    75,    76,    77,    78,  1917,  4197,  1268,
      82,    75,    76,    77,    78,    95,   234,   128,    82,    75,
      76,    77,    78,   508,   416,   339,    82,   510,    38,   312,
      40,  1905,  1906,   377,    90,  3155,   102,   378,  1912,   508,
     468,  1378,   322,  1593,    75,    76,    77,    78,  1598,  1599,
    2644,    82,  4497,  2092,  4499,   173,   317,  2096,   372,  2098,
     228,   185,  2101,   360,  1401,   632,  1559,   403,    75,    76,
      77,    78,   346,   247,   228,    82,   173,   508,   361,   434,
     173,   317,   460,    90,   128,   510,  1378,   401,   210,   375,
     248,    75,    76,    77,    78,   834,   434,   179,    82,    29,
    1887,   387,   211,  1882,   676,   677,    90,  1600,  1601,   421,
     511,   834,   173,    75,    76,    77,    78,   197,   378,   378,
      82,  1157,  1158,   446,   434,    75,    76,    77,    78,   508,
     495,  1468,    82,  1403,   372,  4882,  1363,    75,    76,    77,
      78,  3787,  3787,   461,    82,   459,  1177,  1755,   415,   434,
     508,   508,   438,   427,   461,   429,   456,  4186,  3702,  4399,
    1903,  1904,    75,    76,    77,    78,   409,   511,  1911,    82,
     511,   508,  4361,   454,   504,   409,  1468,   511,  2485,   508,
     434,  3933,  1383,  5058,   456,  1834,   508,   372,  2194,   372,
     632,   372,   366,  1801,   421,   499,   500,   506,   372,   310,
    1876,   510,   434,  1824,   508,  1826,   474,  1757,   461,  4109,
    1437,   508,   499,   500,  4117,  1765,   466,  1871,  4121,   372,
    2494,   458,  4390,   372,  4413,  1452,  1897,   409,   511,   508,
     502,   499,   500,  2239,   859,   506,  4037,  2243,  1465,  2086,
     632,   495,  4171,  3363,  3947,   180,   372,  4108,   173,   372,
      88,   511,   511,  1590,   499,   500,   510,   372,   372,   434,
     372,  1598,  1599,   385,  2038,   434,  1816,   378,    14,  1819,
    1820,  4949,  1683,   470,   841,   113,   372,  4940,   508,  4724,
    4746,   403,  1650,   434,   676,   677,  1650,  3627,   434,   504,
     401,   976,   372,   511,   499,   500,  2490,  3172,  1590,  3174,
    3310,   230,   312,  3313,  3314,   143,   424,  3317,   506,   375,
     508,  2550,   510,  3323,  1113,  1774,   228,   838,   885,  2093,
    3611,  3612,   465,  2461,   979,   121,   847,   424,  2102,   259,
     454,   424,   724,  1883,   378,  4329,  4330,  4331,  4332,  4333,
     874,   508,   830,   511,  4533,  3632,   834,   475,  3892,  5012,
     922,  4540,   273,   511,   436,  3104,   322,   511,  1394,   880,
    3384,   470,   327,   424,   185,   508,   494,  2133,  2134,   501,
     502,   503,   504,   105,   941,   171,   385,  2067,  2144,    99,
     508,    25,  2148,  2073,   834,  2051,   223,  2042,   830,   310,
    2156,  2157,   834,  2531,   476,  1020,   838,  3001,   988,   328,
     990,   830,   992,  2169,  2170,   847,   848,   972,   998,    25,
    2401,   475,   854,  4661,  2180,   936,   508,  2160,  2161,   322,
    3014,  3712,   864,   976,   137,   946,   185,   137,  2889,  2890,
     494,  1021,  1022,  2894,   465,  2479,   508,  2498,   880,  2348,
     261,  2350,   173,   153,   508,   454,    75,    76,    77,    78,
     892,    88,   508,    82,   896,   267,   160,  3332,   975,   394,
     332,   137,  1087,   830,   260,   907,   267,   180,   210,  1103,
    3345,   310,   192,  2934,  2935,   141,   113,   508,    14,   211,
     387,  1806,   403,  3984,   926,   175,  3680,   830,   417,   424,
     932,   174,  1117,     8,   936,   228,    11,    12,   208,   424,
    1103,   508,   261,   160,   946,   947,   143,    22,    23,    24,
     952,    26,    27,   478,   310,   225,    31,    32,    33,    88,
     962,   325,   434,   107,   508,   967,  2720,   462,   920,   233,
     922,   438,   208,   454,   976,  4754,  4755,   374,    85,   474,
    1093,  1980,   508,   973,   326,  2708,   508,  1806,   230,   225,
    3425,   241,    75,    76,    77,    78,  2049,   967,   508,    82,
     990,   229,   992,   237,   466,  1066,  3315,  3316,   251,  1070,
     508,   207,  1002,   508,  1199,   990,   233,   992,   970,    95,
     111,  4845,   974,   495,  4484,  4488,  1064,  4835,   830,  4829,
    4493,  1021,  1022,  4496,   390,   508,   180,  4626,   510,   312,
    1088,  2099,  2100,   231,   317,   508,  1021,  1022,  2191,   299,
     228,    72,   302,   424,    75,    76,    77,    78,  1060,   263,
      81,    82,    83,    84,  1066,    86,  1068,   173,  1070,   265,
     248,   151,   269,   454,   180,  4387,   310,  1066,  1088,   511,
     353,  1070,  4413,   353,   185,   236,  1088,   263,   267,   267,
     180,   490,   237,  1095,   367,   456,   389,   267,   173,   325,
     182,   403,   848,   501,   502,   503,   504,   398,   854,   189,
    1062,    99,  1064,   341,  4541,   379,  3005,   353,   864,    71,
      72,   197,   441,    75,    76,    77,    78,    79,    80,    81,
      82,   182,   267,  2018,    86,   454,   332,   310,  4224,   511,
     269,  4941,   392,   991,   508,   387,   892,   995,   996,   997,
     896,   512,   267,  1155,  1156,   332,   247,  1005,  2055,   147,
     261,   907,   379,    25,   506,   310,   154,   129,   510,  4758,
    4618,  1141,  1253,    35,   467,   137,   449,   100,   406,   449,
     423,   424,    72,  1264,  4744,    75,    76,    77,    78,   271,
    1160,    81,    82,   181,   339,  4974,    86,   228,  2797,  2018,
     442,  4950,   162,  5011,  4631,   228,   312,  5015,   396,   237,
     474,   338,  1191,   449,   391,  4832,    99,   248,   387,  2653,
     271,   328,   312,  2010,  2054,   248,   460,   372,   180,   304,
     312,  2284,   383,  1327,  2021,  1205,   267,   425,   220,   489,
    4140,   975,   976,  1324,   267,   509,  2033,   173,   512,  5057,
    4150,  1253,   448,    72,  4169,    97,  2366,   474,  4721,   332,
     340,   312,  1264,   339,   252,   184,  4117,    86,   219,   438,
    4121,   231,   134,   232,   349,   117,  2334,   456,   456,   361,
      85,  2166,   310,    88,  3854,  1287,   456,   460,  4131,  4136,
    3860,  3861,   509,   394,  1539,   512,   372,   326,   228,   389,
    4889,  4148,   499,   500,   501,   502,   503,   504,   414,   192,
     361,   417,   299,  1369,   266,   460,   151,   332,   248,   508,
    4747,   456,  1324,  2545,  1380,   401,  1403,   309,   290,  2497,
    4757,   290,   415,   416,   512,  3169,   287,   267,   290,   262,
     119,   456,  3176,  4886,  4887,  4018,  4794,  2166,   428,   268,
    2581,   495,  3787,   454,   189,    88,  2386,   408,  2386,  4565,
    4565,  1363,   506,   184,   508,   509,   510,   511,   443,  1103,
     499,   500,   501,   502,   503,   504,  1378,   297,  2600,  4642,
    1382,  1383,  2550,  1385,   310,  4648,   151,  4976,   495,   496,
     497,  1393,   499,   500,   501,   502,   503,   504,  2737,  1401,
    2747,   263,   508,  2571,   231,   392,  1621,  2741,   365,  1155,
    1156,   360,  1382,  1383,  1713,  1385,  1406,  3171,  1408,  3468,
     262,  1411,   434,  1413,   189,   456,  1416,  1417,  1418,   417,
    1713,  1401,   460,   456,  2602,  1437,   509,   386,   511,  1429,
     374,  1635,  1636,  2553,  1638,   151,   185,   268,  1450,   151,
    1452,  2561,  1442,  2563,  1444,  2051,  2637,   161,   197,  2690,
    2691,  2692,  2693,  1465,   269,   244,  1468,  1652,   427,   248,
     429,  2702,  1635,  1636,    22,  1638,   197,  1479,   499,   500,
     274,   512,   160,   189,   512,  3946,   383,   189,  5077,   512,
     436,  5034,  3504,   452,   509,  2731,   511,  1449,   339,   511,
    3099,   179,   434,  3015,  3171,   340,  1508,   286,  4820,  3687,
    3531,   468,   180,  3534,  3535,  3536,  3537,  3538,  3539,  3540,
    3541,  3542,  3543,   328,    72,   229,   456,   394,   153,  3252,
     222,   372,  2858,   211,  1536,  1537,   269,  1539,  1576,  1577,
     474,   241,   172,  3564,   508,   269,     5,   499,   500,  5025,
    1552,   103,   104,   257,  1556,   180,  1404,   424,   455,  1407,
     401,  1609,  1410,  3261,  1412,  2450,    25,  1415,   272,   396,
     183,  1419,  3593,  3594,  3454,   340,    35,   511,    88,   511,
     284,  2907,   512,    75,    76,    77,    78,   434,  1590,  3526,
      82,  1593,    71,   428,   512,   462,  1598,  1599,   425,   299,
      79,    80,   326,   307,  4504,  4505,  1608,  1609,   160,   330,
     500,   350,  2938,  3550,  1662,  1663,  1664,   444,  4679,  4950,
    1609,  5097,   326,  1593,  1576,  1577,   405,   179,  1598,  1599,
     248,  2450,   245,   143,   340,  1637,  4948,  4488,   340,  1641,
    1642,   508,  4493,  1681,   312,  4496,   299,  2973,   495,   302,
    1835,   121,  4433,  1663,  1664,   376,   348,   228,  1752,   211,
    1662,  1663,  1664,   428,   248,  1713,   339,   508,   298,  1403,
     300,  3410,  1720,   152,  3413,   134,  4762,   248,   382,  1727,
     401,  1683,  1609,  4534,  3993,    85,  3995,   312,    88,   506,
     368,  2801,   392,   510,   499,   500,   501,   502,   503,   504,
     436,   171,  3109,  1713,  1674,  1675,  1609,    95,   229,  2496,
    1720,  1713,   456,   101,   232,   352,   394,  2716,  1720,  1721,
     339,  2381,   428,   202,   223,  1727,   428,    14,   401,  1681,
    1700,  1701,  1734,  4303,  4304,   175,   257,   196,  1727,   392,
     476,  1475,  5005,  3177,   243,  1734,   424,  4528,   511,  4530,
      37,   272,   456,   372,   372,   219,    95,   161,   376,  1662,
     183,  1495,   101,   284,   508,  1767,   499,   500,   501,   502,
     503,   504,   290,  1775,   253,   192,   183,   194,  1767,   297,
     155,  3339,   401,   401,   462,    72,  4369,  1757,   372,  4850,
     260,  1525,   376,  3140,  4378,  1765,   474,   506,   474,   436,
    1727,   241,  1804,   512,   263,  1539,  4389,  1609,   192,   197,
     194,   223,   175,   512,   219,    95,   368,   401,   223,   194,
    4671,   101,   245,   287,  1727,   229,  2723,   223,   372,  1808,
     508,   243,  1811,   217,   175,   511,  4736,   233,   245,   476,
     310,   190,   394,   335,    85,   330,  1816,    88,   248,  1819,
    1820,   200,   248,   257,   339,  1857,   474,   401,   197,   299,
     324,   382,   302,  2760,   105,   344,    97,  3466,   272,   269,
    4721,  2723,   424,   509,   456,  1877,   512,  1856,   241,  2006,
     284,  1860,   287,  3904,   209,   514,   117,   372,   339,  1937,
     474,    88,  3128,   474,  1896,   312,  3006,   456,  4207,  4208,
     241,  1635,  1636,   307,  1638,   322,  3740,   182,  2760,   427,
     462,   429,  1914,  1883,   466,   365,   113,   197,  1999,   324,
     390,   372,   474,  2108,   249,  1727,   508,  2008,   328,   376,
     511,   182,  3716,   317,   452,  1937,   299,  1683,   322,   302,
    1942,   385,  2055,  2126,  2000,   395,   143,  3156,  1937,   508,
     401,   339,   392,  2009,   401,  1957,   508,  2013,   299,    75,
      76,    77,    78,  2019,  2020,   474,    82,    41,   447,   413,
     352,  1973,   223,   456,   424,  3184,   455,  2054,   382,   458,
     255,  2037,   467,   339,   372,   381,   172,  3394,  4152,  3157,
     339,    75,    76,    77,    78,  2294,  3403,  1999,    82,  3888,
     339,  3003,   511,  2005,   255,   263,  2008,  3573,  2010,  2011,
    1937,  2294,    51,   401,  2095,  2125,   372,    81,   468,  2021,
     376,    16,    86,   372,   361,  4595,  3765,  3766,   269,   392,
      69,  2033,  2034,   372,  1937,   310,   373,   312,  2132,  2116,
    2042,  2116,  2116,  2045,  2116,   401,  2116,   355,   219,   489,
    3748,   392,   223,  2055,   436,  3223,   440,   207,   339,   310,
     397,   312,   401,  4084,  4085,    14,   450,   253,   508,   219,
    2955,   438,  2042,   223,  2064,  2045,  2066,   372,  3489,   426,
    2070,   321,  2072,  3553,  3554,  2075,   339,   328,    37,  2079,
     394,   372,  3790,  2095,   476,   495,   496,   497,  4949,   499,
     500,   501,   502,   503,   504,   323,   401,   137,   326,  3006,
     128,  1857,   298,   143,   300,   265,   287,   468,   474,   372,
     424,     2,  3688,   153,  2784,   475,   489,   474,   475,   147,
    4565,  2133,  2134,   275,   495,  1937,  2955,   287,  1808,  2141,
     339,  1811,  2144,   161,   494,   508,  2148,   391,   401,   510,
     180,  2153,   182,   324,  2156,  2157,  2204,  3496,   462,   275,
    1955,   508,  2164,  2313,   115,  2167,  2168,  2169,  2170,   509,
     474,  4174,   512,   372,   324,  2177,  2178,  3358,  2180,  1974,
    2182,  2183,   332,  2296,  2186,   136,  1856,    71,    72,  3591,
    1860,   152,  4973,  4082,   212,   232,    75,    76,    77,    78,
    2202,  2203,  2204,    82,   508,   511,  2208,  3026,    89,   515,
    2212,  1957,  4079,  3967,  2216,  2204,  2218,  2219,  2220,  2221,
    2222,  2223,  2224,  2225,  2226,   255,  2228,  1973,  2411,  3126,
    2413,   389,  2234,   317,  3560,  2237,   326,  2293,  4673,   145,
     201,   331,    75,    76,    77,    78,  2294,   153,   475,    82,
    3952,   134,   135,   290,   495,   496,   497,  3493,   499,   500,
     501,   502,   503,   504,  2339,  2011,   326,   494,   426,   126,
      34,   331,   153,     7,  3126,  2460,   506,  2204,   159,  2406,
     339,   508,   312,   513,  2294,    19,    20,   317,  2034,   389,
     511,   506,  2294,   508,   515,   510,   434,  2299,   448,   507,
    2348,  2204,  2350,   511,   185,    39,  3713,  3714,    42,  3096,
    3097,   475,   427,   372,   429,   172,   474,   475,   279,   280,
    2054,  2184,  3756,   353,  2187,   508,   426,   192,   365,   194,
     494,   507,   293,   273,  4643,   511,   438,   367,  2348,   427,
    2350,   429,   401,   207,   508,   438,  2348,   339,  2350,    71,
     508,   391,   217,  2401,   506,   219,   508,    79,    80,   223,
    2441,   374,    75,    76,    77,    78,   503,  2448,  2370,    82,
     310,   508,   297,   510,   474,   475,    85,   297,   339,    88,
     372,   157,  2116,  3382,   376,   251,  2388,  3497,  2390,   509,
     427,   511,   429,   250,    85,  2397,  2366,   511,   512,  2401,
    2402,   265,  2204,  2405,   113,  4004,  4005,  4006,   508,   401,
     119,   509,  2401,   511,  2541,   452,  2386,   513,  2388,   449,
    2390,   361,   156,   287,  4445,  2427,   474,   475,  2430,  2381,
     503,   468,   243,  4454,   143,   508,    72,   510,   317,  2441,
    3654,   298,   314,   300,  1224,   438,  2448,   312,   385,   386,
    4471,  4472,   317,   310,   150,  3242,  1236,   322,  1238,   193,
     324,   468,  3359,   403,  3361,   426,  2468,   428,   332,   125,
    2518,    71,    72,  2521,  2401,  2209,   391,  2479,  3621,    79,
      80,   338,   275,  2485,   317,   508,    86,   510,  2490,  2491,
    2479,   389,   514,  2495,  2496,   385,   386,    71,  2401,   508,
    2502,    75,    76,    77,    78,    79,    80,  3359,    82,  3361,
     501,   502,   503,  3332,   454,    86,  2518,  2519,   508,  2521,
     377,   509,   394,   511,  3624,  3625,  3345,  3424,   426,  2518,
     511,   509,  2521,   511,    75,    76,    77,    78,   326,   248,
    2542,    82,  2544,  2545,   125,    86,  2548,    75,    76,    77,
      78,  2676,   424,  2542,    82,   412,    75,    76,    77,    78,
     269,   270,   491,    82,  2566,   468,  4132,  4616,   313,   314,
     115,   509,  3424,   511,  2576,   440,   474,   475,  2906,   389,
    2908,  2909,   271,  2553,   448,   450,  3373,  2589,  3375,   510,
     462,  2561,   329,  2563,  2521,   511,   512,  2599,  2600,  2401,
    4166,   175,   474,   329,   317,  2339,   315,   509,   326,   511,
     508,   508,   434,   510,  2662,  2518,   426,   223,  2521,   328,
     509,   326,   511,  4313,  2370,  4315,   329,    85,  4517,  4319,
      88,  4321,   491,   509,  2993,   511,   508,   509,  3847,   180,
     512,  2643,   506,  2645,   115,   509,   510,   105,   509,   394,
     511,  2397,    85,   474,   475,    88,  2402,   491,  4412,  2405,
    2662,   180,   492,   493,   474,   475,  2668,   241,   509,   271,
     511,  2673,   105,  2662,  4695,  4274,  4275,   501,  4277,   424,
    2736,  2427,   511,    75,    76,    77,    78,   227,  4090,   389,
      82,    85,   508,  2938,    88,   389,  2752,  2753,   508,   125,
    2756,  3488,   509,  2705,   511,   509,  2762,    75,    76,    77,
      78,   105,   509,   509,    82,   511,  2518,   462,  2720,  2521,
     228,  2723,  2468,   474,   475,   299,   426,  1642,   302,   474,
     267,   509,   426,   511,   509,  2662,   511,  1455,  1456,   389,
    4066,    75,    76,    77,    78,  3976,   512,    71,    82,  2495,
     509,   632,   511,   501,  2835,    79,    80,   514,  2760,  2662,
    2841,   514,   509,   508,   511,   263,  2768,  2978,  2979,  2980,
     434,   203,    96,  2519,   474,   475,   426,  2833,   389,    85,
     474,   475,    88,  4434,  4435,  4436,  4437,  1107,   180,  1109,
     499,   500,   501,   502,   503,   504,    88,   434,  2544,   105,
    3045,   434,  2548,   109,   389,  2807,   508,   113,   508,   108,
     434,   269,   180,   119,   508,   426,   434,  2819,   392,   263,
    2566,   113,   125,   269,   474,   475,   434,   508,   152,  2831,
    2576,  2801,  2784,  2835,   510,   401,   269,   143,   509,  2841,
     511,   426,   477,  2589,    85,   212,   509,    88,   511,     2,
     509,   143,   511,  2599,   389,   508,  2858,  2859,   508,   427,
    2662,   429,  2864,   474,   475,   509,  2914,   511,   510,   509,
     328,   511,  2920,   248,   427,   269,   429,   509,   202,   511,
     212,   509,   188,   511,   509,   508,   511,  2889,  2890,   474,
     475,   426,  2894,   212,   509,   328,   511,   508,   326,  4009,
     509,   326,   511,  2984,  2906,  2907,  2908,  2909,   509,   223,
     511,   509,  2914,   511,   509,   489,   511,  2919,  2920,   509,
    2922,   511,  2924,   508,   248,  2914,   509,   212,   511,   253,
     512,  2920,  2934,  2935,   328,  4122,  2938,  4124,   244,   474,
     475,   285,   248,   182,   509,  3022,   511,  3022,  3022,  2951,
    3022,  2953,  3022,  4310,   509,  2957,   511,  4659,   509,   456,
     511,  3042,   326,   269,   270,   509,   508,   511,  3787,  4376,
     509,  2973,   511,   508,   438,   321,   468,   269,   270,   509,
     286,   511,  2984,   391,  2986,  2987,  2988,  2914,   499,   500,
     501,   502,   503,  2920,   875,   509,   275,   511,   509,   499,
     500,   501,   502,   503,  3006,   358,   312,   507,  3010,   315,
     509,  2914,   511,   509,   167,   511,   509,  2920,   511,   508,
     344,  3023,   328,   315,   137,   331,  3028,   509,   269,   511,
     108,   509,  3034,   511,   187,   474,  3006,   495,   496,   497,
    3042,   499,   500,   501,   502,   503,   504,  4449,   121,  4192,
     312,   932,   933,   509,   477,   511,  3112,   312,   509,   383,
     511,  2807,   495,   496,   497,   508,   499,   500,   501,   502,
     503,   504,   115,    75,    76,    77,    78,   115,   443,  3081,
      82,    75,    76,    77,    78,  2831,   967,   328,    82,   162,
     339,   509,  4846,   511,  3096,  3097,   223,   468,   422,   405,
    3102,   495,   496,   497,   150,   499,   500,   501,   502,   503,
     504,   468,  2914,   186,  4167,  4714,   513,   212,  2920,   356,
     509,  3123,   511,   447,  3126,  4724,   212,  3129,   201,   508,
     212,   455,   205,   212,   458,  3191,   509,  3193,   511,   477,
    3927,  3928,   212,   212,  1025,    75,    76,    77,    78,   511,
     456,   224,    82,   212,   227,  3203,  3204,  3205,    75,    76,
      77,    78,   509,   212,   511,    82,   239,   326,   212,  3171,
    3172,   212,  3174,  1054,   509,  4501,   511,   212,   509,  4778,
     511,   509,  1063,   511,   326,   212,  1067,  1068,  1069,   495,
     496,   497,   212,   499,   500,   501,   502,   503,   504,   424,
    4310,  3203,  3204,  3205,  2938,  4612,   508,   499,   500,   501,
     502,   503,   504,   108,  3203,  3204,  3205,   224,  2952,   509,
    3222,   511,   509,   509,   511,   511,   223,   285,  3230,  3285,
    3232,  3233,   509,   223,   511,  3291,   509,  2971,   511,   509,
    3242,   511,   326,   509,   317,   511,   509,  4604,   511,   509,
    2984,   511,   325,  2168,   495,   496,   497,   508,   499,   500,
     501,   502,   503,   504,   509,   508,   511,  2182,  4867,   509,
     508,   511,  4157,   223,  1155,  1156,   508,   508,   349,  1160,
     508,   508,   508,   336,  3286,   508,   359,   508,  3022,   508,
     508,   508,   508,   508,  4696,   508,  3344,   508,   508,   508,
    3203,  3204,  3205,  3305,  3436,   508,  3433,   508,  3042,  3311,
     508,  3045,   508,   508,   508,   508,   508,   108,   163,   267,
     511,   285,   269,   108,   223,   324,   223,   322,   501,  3331,
    3332,  3406,   263,   401,   302,  3081,   392,   511,  4157,   179,
    3415,   455,  3344,  3345,   511,   495,    14,   511,   153,   434,
     508,   508,   508,   434,   434,  3344,  3601,  3359,   389,  3361,
     434,  3436,  3332,  4362,  4766,   510,   389,  3612,  4770,  4771,
     434,  3373,   434,  3375,  4700,  3345,   153,  3123,   389,   434,
     212,  3437,  4789,   326,   393,  3441,  3442,  3468,  3444,   282,
    3446,  3447,  3603,  3604,  3605,  3606,   317,   434,   434,  3455,
    1287,  3203,  3204,  3205,   434,   455,   145,  3409,   326,   253,
     322,   508,   434,  4310,   508,   434,   153,  3344,  4599,   511,
     339,  4768,  3424,  3425,  4523,   212,   174,   232,  4767,   434,
     456,   456,   125,   434,  3490,   125,  3438,   114,   434,   330,
    4774,  3344,  4776,   434,   114,   434,   251,   434,   434,   434,
     434,   389,  3454,   434,   511,   434,   326,   326,   269,   477,
     474,   508,   465,   508,   108,   107,  3468,    97,   508,  3471,
     326,   212,   180,   312,   508,   467,  3222,   212,   456,   293,
      85,   322,   312,    88,  3436,   290,  3488,  3233,   108,  3491,
     223,   508,   108,   275,   510,   212,   390,  1378,   212,   456,
     212,  1382,  1383,   456,  1385,  3507,   212,   212,  3510,    14,
     434,   511,   321,   316,   474,  3517,   470,   228,  3566,   432,
    1401,  3523,   491,  3525,   304,   508,   331,  3497,  3530,  3531,
    3611,  3612,  3534,  3535,  3536,  3537,  3538,  3539,  3540,  3541,
    3542,  3543,  3344,   508,   304,  3547,  3548,    88,   511,   401,
    4876,   432,   508,  3555,   434,  4912,   508,   228,  3560,  3305,
     511,   495,  3564,  1450,  3566,  1446,  3568,   511,   436,   509,
     242,   508,   511,   242,   265,   403,  3578,  3566,   273,  3581,
     327,  3583,   511,   456,   509,    34,   509,  1468,    10,  3591,
    3592,  3593,  3594,   509,   389,   152,  3598,   434,   434,  3601,
     389,   508,   456,   434,  4662,   434,   273,   273,   317,  3611,
    3612,   434,   508,   317,   438,   468,   391,   275,   317,   326,
    3622,   115,   427,   333,   429,   408,   434,   325,  3630,   511,
    3632,  3712,   434,   438,   389,  4735,   372,   108,   372,  3566,
     243,   398,   434,   361,   449,   269,   434,   452,   108,   456,
    4535,   269,   269,   495,   269,   456,   127,   269,   506,  3809,
    1541,   325,   107,  3566,   269,   434,   434,   212,   506,   495,
    1551,   223,  3406,  3675,   468,   225,   322,   398,   212,  3681,
    1561,  3415,   211,   508,   474,  3687,   508,   108,   159,  4574,
     326,   326,   502,   240,   240,   223,   108,   212,   326,   326,
    5039,   398,  3436,   223,   248,   248,   248,  4604,  3454,  1590,
    3712,   511,  1593,  1594,   511,   477,  4535,  1598,  1599,    96,
     234,   301,   326,   328,   125,  3471,   321,   511,   424,   228,
     511,   509,   511,   509,  3782,   438,   468,   275,  3786,   509,
    3788,  3743,   509,   509,   215,  3491,  4565,   491,   509,   343,
     509,   509,   228,   509,   508,  4574,   509,   509,   509,   509,
     509,   491,   335,   509,  3566,   508,    90,   509,    90,   434,
     471,   454,   379,   462,   512,   246,   495,   471,   509,   495,
    3782,   287,   511,   511,  3786,  3787,  3788,   509,   508,   326,
     329,   326,   251,  3782,   212,   508,   434,  3786,   477,  3788,
     434,   434,  1683,   259,   275,   317,   330,   212,   434,   212,
     287,   282,   344,   344,   967,   434,  3864,  3787,   389,   389,
     434,   453,   295,   434,   434,  3827,   295,   295,  3830,   389,
     389,   312,   434,   434,  1721,   988,   434,   990,   434,   992,
     401,   312,   434,   434,   434,   998,   999,  1000,   212,   434,
     114,   434,   269,   269,   269,   108,   508,   506,   509,  3786,
     302,  3788,  3864,   287,   509,   443,   495,  3601,  1021,  1022,
     509,   511,   115,   374,   127,  3864,   173,  3611,  3612,  3782,
     511,   325,   108,  3786,   509,  3788,  3961,    95,   509,  4888,
     326,   496,   497,   101,   499,   500,   501,   502,   503,   504,
    3870,  3871,  3904,   237,   434,   376,   159,   456,   508,   380,
     223,   389,   511,   173,   389,   386,   456,  1804,   329,   389,
     210,   210,   393,   269,   506,  3927,  3928,   203,  4003,  3931,
     401,    88,  3934,   141,  3990,   228,   223,  3864,   135,   410,
     509,   509,  3998,  3999,   509,   509,   467,   418,   228,   511,
     508,  1832,   508,    85,   509,   236,    88,   511,   509,   327,
     508,  3864,   215,   108,   223,  3967,  3968,  3969,   495,   456,
     495,   456,   434,   509,  2889,  2890,   509,   259,   443,  2894,
    3782,   113,   190,   509,  3786,   508,  3788,   119,  1141,   197,
    1877,   443,   200,   246,   434,   434,   434,  3743,   469,  4884,
     389,  4184,   473,   474,   434,   434,   389,  1160,   223,  1896,
    4012,   143,   509,   509,  1895,  4912,   509,   143,   212,  2934,
    2935,   173,   275,   443,   269,   509,   508,  4029,  4178,   282,
     269,   273,   357,   507,   477,   398,  4117,   