.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER DATABASE" "" "2012-08-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER DATABASE \- change a database

.SH SYNOPSIS
.sp
.nf
ALTER DATABASE \fIname\fR [ [ WITH ] \fIoption\fR [ ... ] ]

where \fIoption\fR can be:

    CONNECTION LIMIT \fIconnlimit\fR

ALTER DATABASE \fIname\fR RENAME TO \fInewname\fR

ALTER DATABASE \fIname\fR OWNER TO \fInew_owner\fR

ALTER DATABASE \fIname\fR SET \fIconfiguration_parameter\fR { TO | = } { \fIvalue\fR | DEFAULT }
ALTER DATABASE \fIname\fR SET \fIconfiguration_parameter\fR FROM CURRENT
ALTER DATABASE \fIname\fR RESET \fIconfiguration_parameter\fR
ALTER DATABASE \fIname\fR RESET ALL
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER DATABASE\fR changes the attributes
of a database.
.PP
The first form changes certain per-database settings. (See below for
details.) Only the database owner or a superuser can change these settings.
.PP
The second form changes the name of the database. Only the database
owner or a superuser can rename a database; non-superuser owners must
also have the
CREATEDB privilege. The current database cannot
be renamed. (Connect to a different database if you need to do
that.)
.PP
The third form changes the owner of the database.
To alter the owner, you must own the database and also be a direct or
indirect member of the new owning role, and you must have the
CREATEDB privilege.
(Note that superusers have all these privileges automatically.)
.PP
The remaining forms change the session default for a run-time
configuration variable for a PostgreSQL
database. Whenever a new session is subsequently started in that
database, the specified value becomes the session default value.
The database-specific default overrides whatever setting is present
in \fIpostgresql.conf\fR or has been received from the
\fBpostgres\fR command line. Only the database
owner or a superuser can change the session defaults for a
database. Certain variables cannot be set this way, or can only be
set by a superuser.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the database whose attributes are to be altered.
.TP
\fB\fIconnlimit\fB\fR
How many concurrent connections can be made
to this database. -1 means no limit.
.TP
\fB\fInewname\fB\fR
The new name of the database.
.TP
\fB\fInew_owner\fB\fR
The new owner of the database.
.TP
\fB\fIconfiguration_parameter\fB\fR
.TP
\fB\fIvalue\fB\fR
Set this database's session default for the specified configuration
parameter to the given value. If
\fIvalue\fR is DEFAULT
or, equivalently, RESET is used, the
database-specific setting is removed, so the system-wide default
setting will be inherited in new sessions. Use RESET
ALL to clear all database-specific settings.
SET FROM CURRENT saves the session's current value of
the parameter as the database-specific value.

See SET [\fBset\fR(l)] and in the documentation
for more information about allowed parameter names
and values.
.SH "NOTES"
.PP
It is also possible to tie a session default to a specific role
rather than to a database; see
ALTER ROLE [\fBalter_role\fR(l)].
Role-specific settings override database-specific
ones if there is a conflict.
.SH "EXAMPLES"
.PP
To disable index scans by default in the database
test:
.sp
.nf
ALTER DATABASE test SET enable_indexscan TO off;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBALTER DATABASE\fR statement is a
PostgreSQL extension.
.SH "SEE ALSO"
CREATE DATABASE [\fBcreate_database\fR(l)], DROP DATABASE [\fBdrop_database\fR(l)], SET [\fBset\fR(l)]
