.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SET ROLE" "" "2012-02-23" "SQL - Language Statements" "SQL Commands"
.SH NAME
SET ROLE \- set the current user identifier of the current session

.SH SYNOPSIS
.sp
.nf
SET [ SESSION | LOCAL ] ROLE \fIrolename\fR
SET [ SESSION | LOCAL ] ROLE NONE
RESET ROLE
.sp
.fi
.SH "DESCRIPTION"
.PP
This command sets the current user
identifier of the current SQL session to be \fIrolename\fR. The role name can be
written as either an identifier or a string literal.
After \fBSET ROLE\fR, permissions checking for SQL commands
is carried out as though the named role were the one that had logged
in originally.
.PP
The specified \fIrolename\fR
must be a role that the current session user is a member of.
(If the session user is a superuser, any role can be selected.)
.PP
The SESSION and LOCAL modifiers act the same
as for the regular SET [\fBset\fR(l)]
command.
.PP
The NONE and RESET forms reset the current
user identifier to be the current session user identifier.
These forms can be executed by any user.
.SH "NOTES"
.PP
Using this command, it is possible to either add privileges or restrict
one's privileges. If the session user role has the INHERITS
attribute, then it automatically has all the privileges of every role that
it could \fBSET ROLE\fR to; in this case \fBSET ROLE\fR
effectively drops all the privileges assigned directly to the session user
and to the other roles it is a member of, leaving only the privileges
available to the named role. On the other hand, if the session user role
has the NOINHERITS attribute, \fBSET ROLE\fR drops the
privileges assigned directly to the session user and instead acquires the
privileges available to the named role.
.PP
In particular, when a superuser chooses to \fBSET ROLE\fR to a
non-superuser role, she loses her superuser privileges.
.PP
\fBSET ROLE\fR has effects comparable to
SET SESSION AUTHORIZATION [\fBset_session_authorization\fR(l)], but the privilege
checks involved are quite different. Also,
\fBSET SESSION AUTHORIZATION\fR determines which roles are
allowable for later \fBSET ROLE\fR commands, whereas changing
roles with \fBSET ROLE\fR does not change the set of roles
allowed to a later \fBSET ROLE\fR.
.PP
\fBSET ROLE\fR cannot be used within a
SECURITY DEFINER function.
.SH "EXAMPLES"
.sp
.nf
SELECT SESSION_USER, CURRENT_USER;

 session_user | current_user 
--------------+--------------
 peter        | peter

SET ROLE 'paul';

SELECT SESSION_USER, CURRENT_USER;

 session_user | current_user 
--------------+--------------
 peter        | paul
.sp
.fi
.SH "COMPATIBILITY"
.PP
PostgreSQL
allows identifier syntax ("rolename"), while
the SQL standard requires the role name to be written as a string
literal. SQL does not allow this command during a transaction;
PostgreSQL does not make this
restriction because there is no reason to.
The SESSION and LOCAL modifiers are a
PostgreSQL extension, as is the
RESET syntax.
.SH "SEE ALSO"
SET SESSION AUTHORIZATION [\fBset_session_authorization\fR(l)]
