.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TABLESPACE" "" "2012-02-23" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TABLESPACE \- define a new tablespace

.SH SYNOPSIS
.sp
.nf
CREATE TABLESPACE \fItablespacename\fR [ OWNER \fIusername\fR ] LOCATION '\fIdirectory\fR'
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TABLESPACE\fR registers a new cluster-wide
tablespace. The tablespace name must be distinct from the name of any
existing tablespace in the database cluster.
.PP
A tablespace allows superusers to define an alternative location on
the file system where the data files containing database objects
(such as tables and indexes) can reside.
.PP
A user with appropriate privileges can pass
\fItablespacename\fR to
\fBCREATE DATABASE\fR, \fBCREATE TABLE\fR,
\fBCREATE INDEX\fR or \fBADD CONSTRAINT\fR to have the data
files for these objects stored within the specified tablespace.
.SH "PARAMETERS"
.TP
\fB\fItablespacename\fB\fR
The name of a tablespace to be created. The name cannot
begin with pg_, as such names
are reserved for system tablespaces.
.TP
\fB\fIusername\fB\fR
The name of the user who will own the tablespace. If omitted,
defaults to the user executing the command. Only superusers
can create tablespaces, but they can assign ownership of tablespaces
to non-superusers.
.TP
\fB\fIdirectory\fB\fR
The directory that will be used for the tablespace. The directory
must be empty and must be owned by the
PostgreSQL system user. The directory must be
specified by an absolute path name.
.SH "NOTES"
.PP
Tablespaces are only supported on systems that support symbolic links.
.PP
\fBCREATE TABLESPACE\fR cannot be executed inside a transaction
block.
.SH "EXAMPLES"
.PP
Create a tablespace dbspace at /data/dbs:
.sp
.nf
CREATE TABLESPACE dbspace LOCATION '/data/dbs';
.sp
.fi
.PP
Create a tablespace indexspace at /data/indexes
owned by user genevieve:
.sp
.nf
CREATE TABLESPACE indexspace OWNER genevieve LOCATION '/data/indexes';
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE TABLESPACE\fR is a PostgreSQL
extension.
.SH "SEE ALSO"
CREATE DATABASE [\fBcreate_database\fR(l)], CREATE TABLE [\fBcreate_table\fR(l)], CREATE INDEX [\fBcreate_index\fR(l)], DROP TABLESPACE [\fBdrop_tablespace\fR(l)], ALTER TABLESPACE [\fBalter_tablespace\fR(l)]
