.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER GROUP" "" "2006-12-02" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER GROUP \- change role name or membership

.SH SYNOPSIS
.sp
.nf
ALTER GROUP \fIgroupname\fR ADD USER \fIusername\fR [, ... ]
ALTER GROUP \fIgroupname\fR DROP USER \fIusername\fR [, ... ]

ALTER GROUP \fIgroupname\fR RENAME TO \fInewname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER GROUP\fR changes the attributes of a user group.
This is an obsolete command, though still accepted for backwards
compatibility, because groups (and users too) have been superseded by the
more general concept of roles.
.PP
The first two variants add users to a group or remove them from a group.
(Any role can play the part of either a ``user'' or a
``group'' for this purpose.) These variants are effectively
equivalent to granting or revoking membership in the role named as the
``group''; so the preferred way to do this is to use
GRANT [\fBgrant\fR(l)] or
REVOKE [\fBrevoke\fR(l)].
.PP
The third variant changes the name of the group. This is exactly
equivalent to renaming the role with 
ALTER ROLE [\fBalter_role\fR(l)].
.SH "PARAMETERS"
.TP
\fB\fIgroupname\fB\fR
The name of the group (role) to modify.
.TP
\fB\fIusername\fB\fR
Users (roles) that are to be added to or removed from the group.
The users must already exist; \fBALTER GROUP\fR does not
create or drop users.
.TP
\fB\fInewname\fB\fR
The new name of the group.
.SH "EXAMPLES"
.PP
Add users to a group:
.sp
.nf
ALTER GROUP staff ADD USER karl, john;
.sp
.fi
Remove a user from a group:
.sp
.nf
ALTER GROUP workers DROP USER beth;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBALTER GROUP\fR statement in the SQL
standard.
.SH "SEE ALSO"
GRANT [\fBgrant\fR(l)], REVOKE [\fBrevoke\fR(l)], ALTER ROLE [\fBalter_role\fR(l)]
