.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE OPERATOR CLASS" "" "2007-02-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE OPERATOR CLASS \- define a new operator class

.SH SYNOPSIS
.sp
.nf
CREATE OPERATOR CLASS \fIname\fR [ DEFAULT ] FOR TYPE \fIdata_type\fR USING \fIindex_method\fR AS
  {  OPERATOR \fIstrategy_number\fR \fIoperator_name\fR [ ( \fIop_type\fR, \fIop_type\fR ) ] [ RECHECK ]
   | FUNCTION \fIsupport_number\fR \fIfuncname\fR ( \fIargument_type\fR [, ...] )
   | STORAGE \fIstorage_type\fR
  } [, ... ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE OPERATOR CLASS\fR creates a new operator class.
An operator class defines how a particular data type can be used with
an index. The operator class specifies that certain operators will fill
particular roles or ``strategies'' for this data type and this
index method. The operator class also specifies the support procedures to
be used by 
the index method when the operator class is selected for an
index column. All the operators and functions used by an operator
class must be defined before the operator class is created.
.PP
If a schema name is given then the operator class is created in the
specified schema. Otherwise it is created in the current schema.
Two operator classes in the same schema can have the same name only if they
are for different index methods.
.PP
The user who defines an operator class becomes its owner. Presently,
the creating user must be a superuser. (This restriction is made because
an erroneous operator class definition could confuse or even crash the
server.)
.PP
\fBCREATE OPERATOR CLASS\fR does not presently check
whether the operator class definition includes all the operators and functions
required by the index method. It is the user's
responsibility to define a valid operator class.
.PP
Refer to the documentation for further information.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the operator class to be created. The name may be
schema-qualified.
.TP
\fBDEFAULT\fR
If present, the operator class will become the default
operator class for its data type. At most one operator class
can be the default for a specific data type and index method.
.TP
\fB\fIdata_type\fB\fR
The column data type that this operator class is for.
.TP
\fB\fIindex_method\fB\fR
The name of the index method this operator class is for.
.TP
\fB\fIstrategy_number\fB\fR
The index method's strategy number for an operator
associated with the operator class.
.TP
\fB\fIoperator_name\fB\fR
The name (optionally schema-qualified) of an operator associated
with the operator class.
.TP
\fB\fIop_type\fB\fR
The operand data type(s) of an operator, or NONE to
signify a left-unary or right-unary operator. The operand data
types may be omitted in the normal case where they are the same
as the operator class's data type.
.TP
\fBRECHECK\fR
If present, the index is ``lossy'' for this operator, and
so the rows retrieved using the index must be rechecked to
verify that they actually satisfy the qualification clause
involving this operator.
.TP
\fB\fIsupport_number\fB\fR
The index method's support procedure number for a
function associated with the operator class.
.TP
\fB\fIfuncname\fB\fR
The name (optionally schema-qualified) of a function that is an
index method support procedure for the operator class.
.TP
\fB\fIargument_types\fB\fR
The parameter data type(s) of the function.
.TP
\fB\fIstorage_type\fB\fR
The data type actually stored in the index. Normally this is
the same as the column data type, but some index methods
(only GiST at this writing) allow it to be different. The
STORAGE clause must be omitted unless the index
method allows a different type to be used.
.PP
The OPERATOR, FUNCTION, and STORAGE
clauses may appear in any order.
.PP
.SH "NOTES"
.PP
The operators should not be defined by SQL functions. A SQL function
is likely to be inlined into the calling query, which will prevent
the optimizer from recognizing that the query matches an index.
.SH "EXAMPLES"
.PP
The following example command defines a GiST index operator class
for the data type _int4 (array of \fBint4\fR). See
\fIcontrib/intarray/\fR for the complete example.
.sp
.nf
CREATE OPERATOR CLASS gist__int_ops
    DEFAULT FOR TYPE _int4 USING gist AS
        OPERATOR        3       &&,
        OPERATOR        6       =       RECHECK,
        OPERATOR        7       @,
        OPERATOR        8       ~,
        OPERATOR        20      @@ (_int4, query_int),
        FUNCTION        1       g_int_consistent (internal, _int4, int4),
        FUNCTION        2       g_int_union (bytea, internal),
        FUNCTION        3       g_int_compress (internal),
        FUNCTION        4       g_int_decompress (internal),
        FUNCTION        5       g_int_penalty (internal, internal, internal),
        FUNCTION        6       g_int_picksplit (internal, internal),
        FUNCTION        7       g_int_same (_int4, _int4, internal);
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBCREATE OPERATOR CLASS\fR is a
PostgreSQL extension. There is no
\fBCREATE OPERATOR CLASS\fR statement in the SQL
standard.
.SH "SEE ALSO"
ALTER OPERATOR CLASS [\fBalter_operator_class\fR(l)], DROP OPERATOR CLASS [\fBdrop_operator_class\fR(l)]
