.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER INDEX" "" "2010-05-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER INDEX \- change the definition of an index

.SH SYNOPSIS
.sp
.nf
ALTER INDEX \fIname\fR 
    \fIaction\fR [, ... ]
ALTER INDEX \fIname\fR
    RENAME TO \fInew_name\fR

where \fIaction\fR is one of:

    OWNER TO \fInew_owner\fR
    SET TABLESPACE \fIindexspace_name\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER INDEX\fR changes the definition of an existing index.
There are several subforms:
.TP
\fBOWNER\fR
This form changes the owner of the index to the
specified user. This can only be done by a superuser.
.TP
\fBSET TABLESPACE\fR
This form changes the index's tablespace to the specified tablespace and
moves the data file(s) associated with the index to the new tablespace.
See also 
CREATE TABLESPACE [\fBcreate_tablespace\fR(l)].
.TP
\fBRENAME\fR
The RENAME form changes the name of the index. 
There is no effect on the stored data.
.PP
.PP
All the actions except RENAME can be combined into
a list of multiple alterations to apply in parallel.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (possibly schema-qualified) of an existing index to
alter.
.TP
\fB\fInew_name\fB\fR
New name for the index.
.TP
\fB\fInew_owner\fB\fR
The user name of the new owner of the index.
.TP
\fB\fItablespace_name\fB\fR
The tablespace name to which the index will be moved.
.SH "NOTES"
.PP
These operations are also possible using
ALTER TABLE [\fBalter_table\fR(l)].
\fBALTER INDEX\fR is in fact just an alias for the forms
of \fBALTER TABLE\fR that apply to indexes.
.PP
Changing any part of a system catalog index is not permitted.
.SH "EXAMPLES"
.PP
To rename an existing index:
.sp
.nf
ALTER INDEX distributors RENAME TO suppliers;
.sp
.fi
.PP
To move a index to a different tablespace:
.sp
.nf
ALTER INDEX distributors SET TABLESPACE fasttablespace;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBALTER INDEX\fR is a PostgreSQL
extension.
