.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER FUNCTION" "" "2007-09-16" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER FUNCTION \- change the definition of a function

.SH SYNOPSIS
.sp
.nf
ALTER FUNCTION \fIname\fR ( [ \fItype\fR [, ...] ] ) RENAME TO \fInewname\fR
ALTER FUNCTION \fIname\fR ( [ \fItype\fR [, ...] ] ) OWNER TO \fInewowner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER FUNCTION\fR changes the definition of a
function.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing function.
.TP
\fB\fItype\fB\fR
The data type of an argument of the function.
.TP
\fB\fInewname\fB\fR
The new name of the function.
.TP
\fB\fInewowner\fB\fR
The new owner of the function.
To change the owner of a function, you must be a superuser.
Note that if the function is marked
SECURITY DEFINER,
it will subsequently execute as the new owner.
.SH "EXAMPLES"
.PP
To rename the function sqrt for type
\fBinteger\fR to square_root:
.sp
.nf
ALTER FUNCTION sqrt(integer) RENAME TO square_root;
.sp
.fi
.PP
To change the owner of the function sqrt for type
\fBinteger\fR to joe:
.sp
.nf
ALTER FUNCTION sqrt(integer) OWNER TO joe;
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is an \fBALTER FUNCTION\fR statement in the SQL
standard, but it does not provide the option to rename the
function or change the owner.
.SH "SEE ALSO"
CREATE FUNCTION [\fBcreate_function\fR(l)], DROP FUNCTION [\fBdrop_function\fR(l)]
