.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP TYPE" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TYPE \- remove a user-defined data type
.SH SYNOPSIS
.sp
.nf
DROP TYPE \fItypename\fR [, ...] [ CASCADE | RESTRICT ]

  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItypename\fB\fR
The name (optionally schema-qualified) of an existing type.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the type
(such as table columns, functions, operators, etc).
.TP
\fBRESTRICT\fR
Refuse to drop the type if there are any dependent objects.
This is the default.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP TYPE\fR
The message returned if the command is successful.
.TP
\fBERROR: RemoveType: type '\fItypename\fB' does not exist\fR
This message occurs if the specified type is not found.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP TYPE\fR will remove a user type from the
system catalogs.
.PP
Only the owner of a type can remove it.
.SH "EXAMPLES"
.PP
To remove the \fBbox\fR type:
.sp
.nf
DROP TYPE box;
.sp
.fi
.SH "COMPATIBILITY"
.PP
Note that the \fBCREATE TYPE\fR command and the data
type extension mechanisms in PostgreSQL
differ from SQL99.
.SH "SEE ALSO"
CREATE TYPE [\fBcreate_type\fR(l)]

