/* $Id: type.h,v 1.12 2005/12/28 23:54:26 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * Postgres metatype interface
 */
#ifndef PyPg_type_H
#define PyPg_type_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgTypeID(base) PyPg_##base##_Type
#define PyPg_TPFLAGS_DEFAULT Py_TPFLAGS_DEFAULT | Py_TPFLAGS_CHECKTYPES

#define PyPgType_INFO \
	TypeCacheEntry *typ_cache; \
	FmgrInfo typ_input, typ_output, typ_receive, typ_send; \
	PyObj typ_td; \
	PyObj typ_element; /* Not NULL in Array subtypes */

typedef struct PyPgTypeInfo {
	PyPgType_INFO
} * PyPgTypeInfo;

typedef struct PyPgTypeObject {
	PyTypeObject type;
	struct PyPgTypeInfo info;
} PyPgTypeObject;

typedef struct PyPgHeapTypeObject {
	PyHeapTypeObject type;
	struct PyPgTypeInfo info;
} PyPgHeapTypeObject;

#ifndef PyPg_ci_H
extern PyTypeObject PyPgType_Type;
extern char *PyPgType_SourceKWL[];
extern char *PyPgType_SourceModKWL[];

int PyPgType_Initialize(void);
int PyPgType_Ready(PyPgTypeObject *, Oid);
int _PyPgType_Ready(PyPgTypeObject *, Oid);

char * PgTypeName_FromOid(Oid);
Oid TypeOidMod_FromPyObject(PyObj, int32 *);
Oid TypeOid_FromPyObject(PyObj);

PyObj PyPgType_LookupBuiltin(Oid);
PyObj PyPgType_FromOid(Oid);
PyObj PyPgType_FromPyObject(PyObj);

/*
 * Grab a single "source" argument from the args and kw.
 */
#define PyPgArg_ParseTypeSource(args, kw, ob) \
	PyArg_ParseTupleAndKeywords(args, kw, "O", PyPgType_SourceKWL, (ob))
/*
 * Grab a single "source" argument and an optional "mod" from the args and kw.
 */
#define PyPgArg_ParseTypeSourceMod(args, kw, ob, mod) \
	PyArg_ParseTupleAndKeywords(args, kw, "O|i", \
			PyPgType_SourceModKWL, (ob), (mod))
#else
#	define PyPgType_Type (*(PyPgCI._PyPgType_Type))
#	define PyPgType_Ready(...) (PyPgCI._PyPgType_Ready(__VARARGS__))
#	define PyPgType_LookupBuiltin(...) \
		(PyPgCI._PyPgType_LookupBuiltin(__VARARGS__)
#endif

#define PyPgType(SELF) ((PyPgTypeObject *) SELF)
#define PyPgHeapType(SELF) ((PyPgHeapTypeObject *) SELF)

#define PyPgType_Check(SELF) (PyObject_TypeCheck(SELF, &PyPgType_Type))
#define PyPgType_CheckExact(SELF) (((SELF)->ob_type) == &PyPgType_Type)

#define PyPgType_IsHeapType(SELF) \
	PyType_HasFeature(((PyTypeObject *) SELF), Py_TPFLAGS_HEAPTYPE)	
#define PyPgTypeInfo(SELF) \
	((PyPgType_IsHeapType(SELF))  ? \
		(PyPgHeapType(SELF)->info) : \
	 	(PyPgType(SELF)->info))

#define PyPgTypeInfoPointer(SELF) \
	((PyPgType_IsHeapType(SELF))  ? \
		(&PyPgHeapType(SELF)->info) : \
	 	(&PyPgType(SELF)->info))

#define PyPgType_FetchPyPgTupleDesc(SELF) (PyPgTypeInfoPointer(SELF)->typ_td)
#define PyPgType_FetchTupleDesc(SELF) \
	PyPgTupleDesc_FetchTupleDesc(PyPgType_FetchPyPgTupleDesc(SELF))
#define PyPgType_FetchTypeCache(SELF) (PyPgTypeInfo(SELF).typ_cache)
#define PyPgType_FetchOid(SELF) (PyPgType_FetchTypeCache(SELF)->type_id)
#define PyPgType_FetchTypeInput(SELF) (PyPgTypeInfoPointer(SELF)->typ_input)
#define PyPgType_FetchTypeOutput(SELF) (PyPgTypeInfoPointer(SELF)->typ_output)
#define PyPgType_FetchTypeReceive(SELF) (PyPgTypeInfoPointer(SELF)->typ_receive)
#define PyPgType_FetchTypeSend(SELF) (PyPgTypeInfoPointer(SELF)->typ_send)
#define PyPgType_FetchElementType(SELF) (PyPgTypeInfo(SELF).typ_element)

#define PyPgType_IsComposite(SELF) \
	(PyObject_IsSubclass(SELF, (PyObj) &PyPg_record_Type))
#define PyPgType_IsArray(SELF) \
	(PyObject_IsSubclass(SELF, PyPg_anyarray_Type))
#define PyPgType_IsByValue(SELF) \
	(PyPgType_FetchTypeCache(SELF)->typbyval)

#define PyPgType_FixInfo(SELF, EN, VAL) do { \
	if (PyPgType_IsHeapType(SELF)) { \
		PyPgHeapType(SELF)->info.EN = VAL; } else { \
		PyPgType(SELF)->info.EN = VAL; } \
	} while(0)

#define PyPgType_FixTypeCache(SELF, TC) \
	PyPgType_FixInfo(SELF, typ_cache, TC)
#define PyPgType_FixTypeInput(SELF, TI) \
	PyPgType_FixInfo(SELF, typ_input, TI)
#define PyPgType_FixTypeOutput(SELF, TO) \
	PyPgType_FixInfo(SELF, typ_output, TO)
#define PyPgType_FixTypeReceive(SELF, TR) \
	PyPgType_FixInfo(SELF, typ_receive, TR)
#define PyPgType_FixTypeSend(SELF, TS) \
	PyPgType_FixInfo(SELF, typ_send, TS)
#define PyPgType_FixPyPgTupleDesc(SELF, TD) \
	PyPgType_FixInfo(SELF, typ_td, TD)
#define PyPgType_FixElementType(SELF, TP) \
	PyPgType_FixInfo(SELF, typ_element, TP)

/*
 * A CPP list of of builtin PyPgType instances.
 * Define the ACTION macro, and place PyPgType_Builtins where appropriate.
 *
 *  The effect of the ACTION macro will only
 *  impress the compiler if IF_PGTYPE_x allows it.
 */
#define PyPgType_Builtins() \
	IF_PGTYPE_OID(ACTION(oid, OIDOID)) \
	IF_PGTYPE_XID(ACTION(xid, XIDOID)) \
	IF_PGTYPE_CID(ACTION(cid, CIDOID)) \
	IF_PGTYPE_TID(ACTION(tid, TIDOID)) \
\
	IF_PGTYPE_RECORD(ACTION(record, RECORDOID)) \
	IF_PGTYPE_BOOL(ACTION(bool, BOOLOID)) \
\
	IF_PGTYPE_REFCURSOR(ACTION(refcursor, REFCURSOROID)) \
	IF_PGTYPE_REGPROCEDURE(ACTION(regprocedure, REGPROCEDUREOID)) \
	IF_PGTYPE_REGPROC(ACTION(regproc, REGPROCOID)) \
	IF_PGTYPE_REGOPER(ACTION(regoper, REGOPEROID)) \
	IF_PGTYPE_REGOPERATOR(ACTION(regoperator, REGOPERATOROID)) \
	IF_PGTYPE_REGCLASS(ACTION(regclass, REGCLASSOID)) \
	IF_PGTYPE_REGTYPE(ACTION(regtype, REGTYPEOID)) \
\
	IF_PGTYPE_BIT(ACTION(bit, BITOID)) \
	IF_PGTYPE_VARBIT(ACTION(varbit, VARBITOID)) \
\
	IF_PGTYPE_ACLITEM(ACTION(aclitem, ACLITEMOID)) \
\
	IF_PGTYPE_INT2(ACTION(int2, INT2OID)) \
	IF_PGTYPE_INT4(ACTION(int4, INT4OID)) \
	IF_PGTYPE_INT8(ACTION(int8, INT8OID)) \
	IF_PGTYPE_NUMERIC(ACTION(numeric, NUMERICOID)) \
	IF_PGTYPE_CASH(ACTION(cash, CASHOID)) \
\
	IF_PGTYPE_OIDVECTOR(ACTION(oidvector, OIDVECTOROID)) \
	IF_PGTYPE_INT2VECTOR(ACTION(int2vector, INT2VECTOROID)) \
\
	IF_PGTYPE_FLOAT4(ACTION(float4, FLOAT4OID)) \
	IF_PGTYPE_FLOAT8(ACTION(float8, FLOAT8OID)) \
	IF_PGTYPE_POINT(ACTION(point, POINTOID)) \
	IF_PGTYPE_LSEG(ACTION(lseg, LSEGOID)) \
	IF_PGTYPE_PATH(ACTION(path, PATHOID)) \
	IF_PGTYPE_BOX(ACTION(box, BOXOID)) \
	IF_PGTYPE_LINE(ACTION(line, LINEOID)) \
	IF_PGTYPE_CIRCLE(ACTION(circle, CIRCLEOID)) \
\
	IF_PGTYPE_ABSTIME(ACTION(abstime, ABSTIMEOID)) \
	IF_PGTYPE_RELTIME(ACTION(reltime, RELTIMEOID)) \
	IF_PGTYPE_TINTERVAL(ACTION(tinterval, TINTERVALOID)) \
	IF_PGTYPE_DATE(ACTION(date, DATEOID)) \
	IF_PGTYPE_TIME(ACTION(time, TIMEOID)) \
	IF_PGTYPE_TIMETZ(ACTION(timetz, TIMETZOID)) \
	IF_PGTYPE_TIMESTAMP(ACTION(timestamp, TIMESTAMPOID)) \
	IF_PGTYPE_TIMESTAMPTZ(ACTION(timestamptz, TIMESTAMPTZOID)) \
	IF_PGTYPE_INTERVAL(ACTION(interval, INTERVALOID)) \
\
	IF_PGTYPE_BYTEA(ACTION(bytea, BYTEAOID)) \
	IF_PGTYPE_CHAR(ACTION(char, CHAROID)) \
	IF_PGTYPE_NAME(ACTION(name, NAMEOID)) \
	IF_PGTYPE_BPCHAR(ACTION(bpchar, BPCHAROID)) \
	IF_PGTYPE_VARCHAR(ACTION(varchar, VARCHAROID)) \
	IF_PGTYPE_TEXT(ACTION(text, TEXTOID)) \
	IF_PGTYPE_UNKNOWN(ACTION(unknown, UNKNOWNOID)) \
	IF_PGTYPE_CSTRING(ACTION(cstring, CSTRINGOID)) \
\
	IF_PGTYPE_MACADDR(ACTION(macaddr, MACADDROID)) \
	IF_PGTYPE_INET(ACTION(inet, INETOID)) \
	IF_PGTYPE_CIDR(ACTION(cidr, CIDROID)) \
\
	IF_PGTYPE_ATTRIBUTE(ACTION(attribute, PG_ATTRIBUTE_RELTYPE_OID))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_type_H */
/*
 * vim: ts=3:sw=3:noet:
 */
