#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py,v 1.17 2005/07/16 21:04:59 jwp Exp $
##
# Copyright 2005, PostgresPy Project.
# http://python.projects.postgresql.org
##
# imp/setup.py,v 1.6 2004/12/15 04:48:53 flaw
# if/setup.py,v 1.31 2004/09/28 16:01:57 flaw
##
import sys, os
if '' not in sys.path: sys.path.insert(0, '')
DIR = os.path.dirname(os.path.abspath(__file__))
sys.path.append(os.path.join(DIR, 'lib'))
import ldistutils

CODENAME = 'teop'
STATE = 'dev'
PATH = ('postgresql', 'backend', 'interface', CODENAME)

def configure(self):
	import postgresql.utility.config
	from postgresql.utility.version import parse as vp
	from distutils.core import Extension
	from distutils.sysconfig import get_python_inc, get_python_lib

	PKGROOT = os.path.join(get_python_lib(), *PATH)
	PACKAGE_SPACE = '.'.join(PATH)

	dist = self.distribution
	CFG = self.configuration

	pgc = postgresql.utility.config.instance(self.postgresql)
	pg_include = self.postgresql_headers or pgc.includedir_server
	pg_pkglib = self.postgresql_pkglibdir or pgc.pkglibdir
	pgv = vp(self.postgresql_version or pgc.version.split(' ', 1)[1])

	PGV_MM = str(pgv.major) + str(pgv.minor)
	PGV_TAG = PGV_MM + pgv.state + str(pgv.level or '')
	CFG['DEFINES'] += [
		('PL_STATE', '"%s"' %(STATE)),
		('PGV_MM', PGV_MM,),
		('PGV_TAG', '"%s"'%(PGV_TAG,)),
		('PG_VERSION_MAJOR', str(pgv.major)),
		('PG_VERSION_MINOR', str(pgv.minor)),
		('PG_VERSION_PATCH', str(pgv.patch)),
		('PG_VERSION_STATE', '"%s"'%(pgv.state,)),
		('PG_VERSION_LEVEL', str(pgv.level)),
	]
	CFG['PGV_TAG'] = PGV_TAG
	CFG['PGV_MM'] = PGV_MM
	vs = CFG['VS'] = STATE+'-v'+PGV_TAG
	package = PACKAGE_SPACE + '.' + vs

	# Construct all the file lists
	CFG['I'] = ['include', pg_include]

	if not self.without_extension:
		SRCS = [
			'error',
			'encoding',
			'conv',
			'utils',
			'tupledesc',
			'heaptuple',
			'type',
			'object',
			'tif',
			'call',
			'function',
			'namespace',
			'relation',
			'query',
			'transaction',
			'savepoint',
		]
		CALLS = [os.path.join('call', src) for src in (
			'function', 'pl', 'trigger', 'portal'
		)]
		CFG['XSOURCES'] = [os.path.join('src', src+'.c') for src in SRCS+CALLS+[
			'globals', 'module',
		]]

		HEADER_D = os.path.join(get_python_inc(), *(PATH + (vs, 'pypg',)))

		CFG['DATA_FILES'] = [
			(
				HEADER_D,
				[os.path.join('include', 'pypg', src + '.h')
					for src in SRCS
				],
			),
			(
				os.path.join(HEADER_D, 'call'),
				[os.path.join('include', 'pypg', src + '.h')
					for src in CALLS
				],
			),
			(
				PKGROOT,
				[os.path.join('src', '__init__.py')],
			),
		]

		CFG['PACKAGE_DIR'] = {package : 'src'}
		CFG['PACKAGES'] = [package]

		CFG['EXTENSIONS'] = [
			Extension(
				package + '._prime',
				CFG['XSOURCES'],
				include_dirs = CFG['I'],
			)
		]

	if sys.platform == 'win32':
		dll = 'python%d%d.dll' %(sys.version_info[0], sys.version_info[1])
		OBJS = []
		LIBS = [dll]
	elif sys.platform == 'darwin':
		from distutils.sysconfig import get_config_vars
		dll = 'python%d.%d' %(sys.version_info[0], sys.version_info[1])
		OBJS = []
		LIBS = [dll]
		(LIBDIR,) = get_config_vars('LIBDIR')
	else:
		from distutils.sysconfig import get_config_vars
		(LIBDIR, LDFLAGS, LIBPL, LIBRARY) = get_config_vars(
			'LIBDIR', 'LDFLAGS', 'LIBPL', 'LIBRARY'
		)
		soname = LIBRARY[:-1] + 'so'
		sopath = os.path.join(LIBDIR, soname)
		if os.path.exists(sopath):
			OBJS = []
			LIBS = [soname[3:-3]]
		else:
			OBJS = [os.path.join(LIBPL, LIBRARY)]
			LIBS = []

	pys = sys.version_info[3]
	if pys == 'final':
		pys = ''
	elif sys.version_info[4] > 0:
		pys = pys + str(sys.version_info[4])

	PLFILENAME = 'python%s%s%s-%s' %(
		str(sys.version_info[0]),
		str(sys.version_info[1]),
		pys, STATE,
	)
	CFG['LIBRARIES'] = [
		(PLFILENAME,
			{
				'sources' : ['src/pl.c',],
				'objects' : OBJS,
				'macros' : CFG['DEFINES'] + [
					('IF_PATH', '"%s"'%(PACKAGE_SPACE,)),
					('EX_IFM', '"prime"'),
				],
				'include_dirs' : CFG['I'] + [get_python_inc()],
				'library_dirs' : [LIBDIR],
				'libraries' : LIBS,
				'ddir' : os.path.join(pg_pkglib, 'pl'),
			}
		),
	]
# configure

options = {
	'postgresql' : (
		'pg_config', (
			'postgresql=', 'P',
			'PostgreSQL installation to depend on'
		)
	),
	'postgresql_headers' : (
		None, (
			'postgresql-headers=', None,
			'PostgreSQL server headers path'
		)
	),
	'postgresql_pkglibdir' : (
		None, (
			'postgresql-pkglibdir=', None,
			'PostgreSQL package directory path'
		)
	),
	'postgresql_version' : (
		None, (
			'postgresql-version=', None,
			'PostgreSQL version'
		)
	),
	'without_extension' : (
		False, (
			'without-extension', None,
			'Compile and install PL without extension module'
		)
	),
}

CLASSIFIERS = [
	'Development Status :: 3 - Alpha',
	'Intended Audience :: Developers',
	'License :: OSI Approved :: BSD License',
	'License :: OSI Approved :: MIT License',
	'License :: OSI Approved :: Attribution Assurance License',
	'License :: OSI Approved :: Python Software Foundation License',
	'Natural Language :: English',
	'Operating System :: OS Independent',
	'Programming Language :: Python',
	'Programming Language :: C',
	'Topic :: Database',
]

defaults = dict(
	distclass = ldistutils.Distribution,
	name = 'backend',
	version = '0.2',
	description =
		'PostgreSQL interface extension module and procedural language',
	author = 'James William Pye',
	author_email = 'x@jwp.name',
	contact = 'PostgresPy Project',
	contact_email = 'python-general@pgfoundry.org',
	url = 'http://python.projects.postgresql.org',
	configure = configure,
	configure_options = options,
	classifiers = CLASSIFIERS,
	download_url = 'http://pgfoundry.org/frs/?group_id=1000094',
)

def setup(kw):
	import distutils.core
	OLDCWD = os.getcwd()
	try:
		os.chdir(DIR)
		d = distutils.core.setup(**kw)
	finally:
		os.chdir(OLDCWD)
	return d
	return setup(**args)

if __name__ == '__main__':
	setup(defaults)
##
# vim: ts=3:sw=3:noet:
