/* $Id: object.h,v 1.5 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/obj.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/obj.h,v 1.4 2004/10/17 12:54:51 flaw
 * if/src/obj.h,v 1.25 2004/09/28 15:56:37 flaw
 *//*
 * Postgres object interface for Python
 */
#ifndef PyPg_object_H
#define PyPg_object_H 0
#ifdef __cplusplus
extern "C" {
#endif

PyObj PyPgObject_FromPyPgTypeAndDatum(PyObj, Datum);
PyObj PyPgObject_FromTypeOidAndDatum(Oid, Datum);
PyObj PyPgObject_FromPyPgTypeAndHeapTuple(PyObj, HeapTuple);

#define PyPgObject_HEAD	\
	PyObject_HEAD			\
	Datum pgo_datum;		\
	PyObj pgo_type;

typedef struct PyPgObject {
	PyPgObject_HEAD
} * PyPgObject;

extern PyTypeObject PyPgObject_Type;
PyObj PyPgObject_Initialize(PyObj, PyObj, Datum);

#define PyPgObject_NEW() \
	((PyObj) PyPgObject_Type.tp_alloc(&PyPgObject_Type, 0))
#define PyPgObject_New(T, D) \
	(PyPgObject_Initialize(PyPgObject_NEW(), T, D))

#define PyPgObject(SELF) ((PyPgObject) SELF)

#define PyPgObject_Check(SELF) (PyObject_TypeCheck((SELF), &PyPgObject_Type))
#define PyPgObject_CheckExact(SELF) ((SELF)->ob_type == &PyPgObject_Type)

#define PyPgObject_ShouldFree(SELF) \
	(!PyPgObject_FetchTypeStruct(SELF)->typbyval)

#define PyPgObject_FromPyPgTypeAndPyObject(TYPE, SELF) \
	(PyObject_CallFunctionObjArgs(TYPE, SELF, NULL))

#define PyPgObject_FetchDatum(SELF)	(PyPgObject(SELF)->pgo_datum)
#define PyPgObject_FetchType(SELF)	(PyPgObject(SELF)->pgo_type)

#define PyPgObject_FetchHeapTupleHeader(SELF) \
	((HeapTupleHeader) PyPgObject_FetchDatum(SELF))
#define PyPgObject_FetchStructure(SELF) \
	(HeapTupleHeaderStructure(PyPgObject_FetchHeapTupleHeader(SELF)))
#define PyPgObject_FetchTypeHeapTupleHeader(SELF) \
	PyPgObject_FetchHeapTupleHeader(PyPgObject_FetchType(SELF))
#define PyPgObject_FetchTypeOid(SELF) \
	(PyPgObject_FetchOid(PyPgObject_FetchType(SELF)))
#define PyPgObject_FetchOid(SELF) \
	(HeapTupleHeaderGetOid(PyPgObject_FetchHeapTupleHeader(SELF)))
#define PyPgObject_FetchTypeStruct(SELF) \
	(PyPgType_FetchTypeStruct(PyPgObject_FetchType(SELF)))
#define PyPgObject_FetchTypeLength(SELF) \
	(PyPgObject_FetchTypeStruct(SELF)->typlen)
#define PyPgObject_FetchTypeByValue(SELF) \
	(PyPgObject_FetchTypeStruct(SELF)->typbyval)
#define PyPgObject_FetchPyPgTupleDesc(SELF) \
	(PyPgType_FetchPyPgTupleDesc(PyPgObject_FetchType(SELF)))
#define PyPgObject_FetchTupleDesc(SELF) \
	(PyPgTupleDesc_FetchTupleDesc(PyPgObject_FetchPyPgTupleDesc(SELF)))
#define PyPgObject_FetchNULL(SELF) \
	(PyPgType_FetchNULL(PyPgObject_FetchType(SELF)))

#define PyPgObject_FetchVARSIZE(SELF) \
	(VARSIZE(PyPgObject_FetchDatum(SELF)))
#define PyPgObject_FetchStringLength(SELF) \
	(strlen((char *) PyPgObject_FetchDatum(SELF)))
#define PyPgObject_FetchLength(SELF) (				\
	(PyPgObject_FetchTypeByValue(SELF))			?(	\
	(PyPgObject_FetchTypeLength(SELF))			:	\
		(PyPgObject_FetchTypeLength(SELF) == -2)	?(	\
		(PyPgObject_FetchStringLength(SELF))		:	\
			(PyPgObject_FetchTypeLength(SELF) == -1)	?(	\
				(PyPgObject_FetchVARSIZE(SELF))				:	\
				(PyPgObject_FetchTypeLength(SELF))				\
			)																\
		)																	\
	)																\
)

#define PyPgObject_FixDatum(SELF, D) (PyPgObject(SELF)->pgo_datum = D)
#define PyPgObject_FixType(SELF, OB) (PyPgObject(SELF)->pgo_type = OB)

#define PyPgObject_IsNULL(SELF) \
	(PyObj(SELF) == PyPgObject_FetchNULL(SELF))
#define PyPgObject_IsComposite(SELF) \
	(PyPgType_IsComposite(PyPgObject_FetchType(SELF)))

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_object_H */
/*
 * vim: ts=3:sw=3:noet:
 */
