/* $Id: pl.h,v 1.6 2005/06/19 20:13:10 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/plcall.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/plcall.h,v 1.2 2004/11/09 20:21:21 flaw
 *//*
 * Procedural call interface
 */
#ifndef PyPg_call_pl_H
#define PyPg_call_pl_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgProceduralCall_HEAD	\
	PyPgCall_HEAD						\
	FunctionCallInfo		plc_fcinfo;

typedef struct PyPgProceduralCall {
	PyPgProceduralCall_HEAD
} * PyPgProceduralCall;

extern PyTypeObject PyPgProceduralCall_Type;
PyObject * PyPgProceduralCall_Initialize(PyObject *, FunctionCallInfo);
int PyPgProceduralCall_InitializeParameters(PyObject *);

#define PyPgProceduralCall_NEW() \
	(PyObj) PyPgProceduralCall_Type.tp_alloc(&PyPgProceduralCall_Type, 0)
#define PyPgProceduralCall_New(FCI) \
	PyPgProceduralCall_Initialize(PyPgProceduralCall_NEW(), FCI)

#define PyPgProceduralCall(SELF) ((PyPgProceduralCall) SELF)

#define PyPgProceduralCall_Check(SELF) \
	(PyObject_TypeCheck((SELF), &PyPgProceduralCall_Type))
#define PyPgProceduralCall_CheckExact(SELF) \
	((SELF)->ob_type == &PyPgProceduralCall_Type)

#define PyPgProceduralCall_FetchFCInfo(SELF) \
	(PyPgProceduralCall(SELF)->plc_fcinfo)
#define PyPgProceduralCall_FetchResultInfo(SELF) \
	(PyPgProceduralCall_FetchFCInfo(SELF)->resultinfo)
#define PyPgProceduralCall_FetchRSI(SELF) \
	((ReturnSetInfo *) (PyPgProceduralCall_FetchResultInfo(SELF)))

#define PyPgProceduralCall_ReturnsSet(SELF) \
	(PyPgProceduralCall_FetchRSI(SELF) != NULL && \
	 nodeTag(PyPgProceduralCall_FetchRSI(SELF)) == T_ReturnSetInfo)

#define PyPgProceduralCall_FixFCInfo(SELF, OB) \
	(PyPgProceduralCall(SELF)->plc_fcinfo = OB)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_call_pl_H */
/*
 * vim: ts=3:sw=3:noet:
 */
