/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class SocketHubAppender
extends AppenderSkeleton {
    static final int DEFAULT_PORT = 4560;
    private int port = 4560;
    private Vector oosList = new Vector();
    private ServerMonitor serverMonitor = null;
    private boolean locationInfo = false;

    public SocketHubAppender() {
    }

    public SocketHubAppender(int _port) {
        this.port = _port;
        this.startServer();
    }

    public void activateOptions() {
        this.startServer();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        LogLog.debug("closing SocketHubAppender " + this.getName());
        this.closed = true;
        this.cleanUp();
        LogLog.debug("SocketHubAppender " + this.getName() + " closed");
    }

    public void cleanUp() {
        LogLog.debug("stopping ServerSocket");
        this.serverMonitor.stopMonitor();
        this.serverMonitor = null;
        LogLog.debug("closing client connections");
        while (this.oosList.size() != 0) {
            ObjectOutputStream oos = (ObjectOutputStream)this.oosList.get(0);
            if (oos == null) continue;
            try {
                oos.close();
            }
            catch (IOException e) {
                LogLog.error("could not close oos.", e);
            }
            this.oosList.remove(0);
        }
    }

    public void append(LoggingEvent event) {
        if (event == null || this.oosList.size() == 0) {
            return;
        }
        if (this.locationInfo) {
            event.getLocationInformation();
        }
        int streamCount = 0;
        while (streamCount < this.oosList.size()) {
            ObjectOutputStream oos = null;
            try {
                oos = (ObjectOutputStream)this.oosList.get(streamCount);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (oos == null) break;
            try {
                oos.writeObject(event);
                oos.flush();
                oos.reset();
            }
            catch (IOException e) {
                this.oosList.remove(streamCount);
                LogLog.debug("dropped connection");
                --streamCount;
            }
            ++streamCount;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setPort(int _port) {
        this.port = _port;
    }

    public int getPort() {
        return this.port;
    }

    public void setLocationInfo(boolean _locationInfo) {
        this.locationInfo = _locationInfo;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    private void startServer() {
        this.serverMonitor = new ServerMonitor(this.port, this.oosList);
    }

    private class ServerMonitor
    implements Runnable {
        private int port;
        private Vector oosList;
        private boolean keepRunning;
        private Thread monitorThread;

        public ServerMonitor(int _port, Vector _oosList) {
            this.port = _port;
            this.oosList = _oosList;
            this.keepRunning = true;
            this.monitorThread = new Thread(this);
            this.monitorThread.setDaemon(true);
            this.monitorThread.start();
        }

        public synchronized void stopMonitor() {
            if (this.keepRunning) {
                LogLog.debug("server monitor thread shutting down");
                this.keepRunning = false;
                try {
                    this.monitorThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.monitorThread = null;
                LogLog.debug("server monitor thread shut down");
            }
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            serverSocket = null;
            try {
                serverSocket = new ServerSocket(this.port);
                serverSocket.setSoTimeout(1000);
            }
            catch (Exception e) {
                LogLog.error("exception setting timeout, shutting down server socket.", e);
                this.keepRunning = false;
                return;
            }
            try {
                try {
                    serverSocket.setSoTimeout(1000);
                    if (true) ** GOTO lbl48
                }
                catch (SocketException e) {
                    LogLog.error("exception setting timeout, shutting down server socket.", e);
                    var7_5 = null;
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    return;
                }
                do {
                    socket = null;
                    try {
                        socket = serverSocket.accept();
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (SocketException e) {
                        LogLog.error("exception accepting socket, shutting down server socket.", e);
                        this.keepRunning = false;
                    }
                    catch (IOException e) {
                        LogLog.error("exception accepting socket.", e);
                    }
                    if (socket == null) continue;
                    try {
                        remoteAddress = socket.getInetAddress();
                        LogLog.debug("accepting connection from " + remoteAddress.getHostName() + " (" + remoteAddress.getHostAddress() + ")");
                        oos = new ObjectOutputStream(socket.getOutputStream());
                        this.oosList.add(oos);
                    }
                    catch (IOException e) {
                        LogLog.error("exception creating output stream on socket.", e);
                    }
lbl48:
                    // 4 sources

                } while (this.keepRunning);
                var7_6 = null;
            }
            catch (Throwable var6_17) {
                var7_7 = null;
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw var6_17;
            }
            try {
                serverSocket.close();
            }
            catch (IOException e) {}
        }
    }
}

