'
'	Frank Lupo (Wolf) !! 
'	frank_lupo@email.it
'
'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	Export Ascii
'	Export Into ascii file
'
Option Explicit

Class ClsExport
	Private szFileExport
	Private szDelimiter
	Private iTypeDelimiter
	Private iTypeQuoting
	Private szQuoting
	Private bTrailing

	Private Sub Class_Initialize
	Dim szTemp,bExit,szTypeVal,Fso,vData,bOptionFromFile

		Set fso = CreateObject("Scripting.FileSystemObject")

		'File option
		bOptionFromFile=False
		WScript.StdOut.Write "Do you have option file? Y/N : "
		if ucase(WScript.StdIn.ReadLine)="Y" then
			bExit=True
			While bExit
				WScript.StdOut.Write "File Name option: "
				szTemp = WScript.StdIn.ReadLine
				if len(trim(szTemp))>0 then
					'Verify directory
					if fso.FileExists(szTemp) then
						vData=split(App.Data.Utility.FileSystem.ReadFile(szTemp,0),vbcrlf)
						if ubound(vData) <> 6 then
							Wscript.Echo "File not valid !!"
						else
							szFileExport=cstr(vData(0))
							szDelimiter=cstr(vData(1))
							iTypeDelimiter=cint(vData(2))
							iTypeQuoting=cint(vData(3))
							szQuoting=cstr(vData(4))
							bTrailing=cbool(vData(5))

							wscript.echo "File Name to export: " & szFileExport
							szTypeVal=array("Character","Ascii Value")
							wscript.echo "Type Delimitator : " & szTypeVal(iTypeDelimiter)
							wscript.echo "Delimitator: " & szDelimiter
							szTypeVal=array("None","Character","Ascii Value")
							wscript.echo "Type Quoting: " & szTypeVal(iTypeQuoting)
							if iTypeQuoting <> 0 then wscript.echo "Quoting: " & szQuoting
							wscript.echo "Trailing: " & bTrailing
							bOptionFromFile=True
							bExit=False
						end if 
					else
						Wscript.Echo App.Data.Message.NoSuchFD(szTemp)
					end if
				else
					bExit=False
				end if
			Wend
		end if

		if not bOptionFromFile then
			'File Name
			bExit=True
			While bExit
				WScript.StdOut.Write "File Name to export: "
				szTemp = WScript.StdIn.ReadLine
				if len(trim(szTemp))>0 then
					'Verify directory
					if fso.FolderExists(fso.GetParentFolderName(szTemp)) then
						szFileExport=szTemp
						bExit=False
					else
						Wscript.Echo App.Data.Message.NoSuchFD(szTemp)
					end if
				end if
			Wend
	
			'Type Delimiter
			bExit=True
			While bExit
				WScript.StdOut.Write "Type Delimiter (0 = Character, 1 = Ascii Value): "
				szTemp=WScript.StdIn.ReadLine
				if IsNumeric(szTemp) then
					if szTemp <> 0 and szTemp <> 1 then 
					else
						bExit=False
						iTypeDelimiter=szTemp
					end if
				end if
			wend
	
			'Delimiter
			szTypeVal=array("Character","Ascii Value")
			bExit=True
			While bExit
				WScript.StdOut.Write "Delimiter (" &  szTypeVal(iTypeDelimiter) & ") : "
				szTemp = WScript.StdIn.ReadLine
				if iTypeDelimiter =1 then
					if IsNumeric(szTemp) then
						bExit=False
						szDelimiter=chr(szTemp)
					end if
				else
					bExit=False
					szDelimiter=szTemp
				end if
			Wend
	
			'Type Quoting
			bExit=True
			While bExit
				WScript.StdOut.Write "Type Delimiter (0 = None , 1 = Character, 2 = Ascii Value): "
				szTemp = WScript.StdIn.ReadLine
				if IsNumeric(szTemp) then
					if szTemp <> 0 and szTemp <> 1 and szTemp <> 2 then 
					else
						bExit=False
						iTypeQuoting = szTemp
					end if
				end if
			Wend
	
			'Quoting
			szQuoting=""
			if iTypeQuoting <> 0 then
				szTypeVal=array("","Character","Ascii Value")
				bExit=True
				While bExit
					WScript.StdOut.Write "Quoting (" &  szTypeVal(iTypeQuoting) & ") : "
					szTemp=WScript.StdIn.ReadLine
					if iTypeQuoting =2 then
						if IsNumeric(szTemp) then
							bExit=False
							szQuoting=chr(szTemp)
						end if
					else
						bExit=False
						szQuoting=szTemp
					end if
				wend
			end if

			'trailing delimiter
			bExit=True
			While bExit
				WScript.StdOut.Write "Add trailing delimiter? Y/N : "
				szTemp=WScript.StdIn.ReadLine
				if ucase(szTemp)="N" then
					bExit=False
					bTrailing=False
				Elseif ucase(szTemp)="Y" then
					bExit=False
					bTrailing=True
				End if
			Wend

			'Save file option
			WScript.StdOut.Write "Do you want save option to file? Y/N : "
			if ucase(WScript.StdIn.ReadLine)="Y" then
				bExit=True
				While bExit
					WScript.StdOut.Write "File Name option: "
					szTemp = WScript.StdIn.ReadLine
					if len(trim(szTemp))>0 then
						'Verify directory
						if fso.FolderExists(fso.GetParentFolderName(szTemp)) then
							App.Data.Utility.FileSystem.WriteFile szTemp,cstr(szFileExport) & vbcrlf ,ForWriting
							App.Data.Utility.FileSystem.WriteFile szTemp,cstr(szDelimiter) & vbcrlf ,ForAppending
							App.Data.Utility.FileSystem.WriteFile szTemp,cstr(iTypeDelimiter) & vbcrlf ,ForAppending
							App.Data.Utility.FileSystem.WriteFile szTemp,cstr(iTypeQuoting) & vbcrlf ,ForAppending
							App.Data.Utility.FileSystem.WriteFile szTemp,cstr(szQuoting) & vbcrlf ,ForAppending
							App.Data.Utility.FileSystem.WriteFile szTemp,cstr(bTrailing) & vbcrlf ,ForAppending
							bExit=False
						else
							Wscript.Echo App.Data.Message.NoSuchFD(szTemp)
						end if
					end if
				Wend
			End if
		End if
  	End Sub

	'This code is retrive from PgAdmin II export
	Public Sub Export(ResultSet)
	Dim szData,szBuffer,szField,X
  
		szBuffer=""
  		While Not ResultSet.EOF
			szData=""
    		For X = 0 To ResultSet.Fields.Count - 1
          		szField = ResultSet.Fields(X).Value & ""
      			szData = szData & szQuoting & Replace(szField, szQuoting, szQuoting & szQuoting) & szQuoting & szDelimiter
    		Next
    		If bTrailing Then szData = Mid(szData, 1, Len(szData) - Len(szDelimiter))
			szBuffer=szBuffer & szData & vbcrlf
    		ResultSet.MoveNext
  		Wend
		App.Data.Utility.FileSystem.WriteFile szFileExport,szBuffer,ForWriting
	End Sub
End Class
