
/* Module:          drvconn.c
 *
 * Description:     This module contains only routines related to 
 *                  implementing SQLDriverConnect.
 *
 * Classes:         n/a
 *
 * API functions:   None
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

/* prototypes */
void dconn_get_connect_attributes(UCHAR FAR *connect_string, ConnInfo *ci);

#ifdef WIN32
BOOL FAR PASCAL dconn_FDriverConnectProc(HWND hdlg, UINT wMsg, WPARAM wParam, LPARAM lParam);
RETCODE dconn_DoDialog(HWND hwnd, ConnInfo *ci);

extern HINSTANCE NEAR s_hModule;               /* Saved module handle. */


RETCODE dconn_DoDialog(HWND hwnd, ConnInfo *ci)
{
	int dialog_result;
	
	mylog("dconn_DoDialog: ci = %u\n", ci);

	if(hwnd)
	{
		dialog_result = DialogBoxParam(s_hModule, MAKEINTRESOURCE(DLG_CONFIG),
									hwnd, dconn_FDriverConnectProc, (LPARAM) ci);
		if(!dialog_result || (dialog_result == -1))
		{
			return SQL_NO_DATA_FOUND;
		} 
		else 
		{
			return SQL_SUCCESS;
		}
	}

	return SQL_ERROR;
}


BOOL FAR PASCAL dconn_FDriverConnectProc(
                                         HWND    hdlg,
                                         UINT    wMsg,
                                         WPARAM  wParam,
                                         LPARAM  lParam)
{
	ConnInfo *ci;

	switch (wMsg)
	{
	case WM_INITDIALOG:
		ci = (ConnInfo *) lParam;		

		/*	Change the caption for the setup dialog */
		SetWindowText(hdlg, "PostgreSQL Connection");

		SetWindowText(GetDlgItem(hdlg, IDC_DATASOURCE), "Connection");

		/*	Hide the DSN and description fields */
		ShowWindow(GetDlgItem(hdlg, IDC_DSNAMETEXT), SW_HIDE);
		ShowWindow(GetDlgItem(hdlg, IDC_DSNAME), SW_HIDE);
		ShowWindow(GetDlgItem(hdlg, IDC_DESCTEXT), SW_HIDE);
		ShowWindow(GetDlgItem(hdlg, IDC_DESC), SW_HIDE);

		SetWindowLong(hdlg, DWL_USER, lParam);/* Save the ConnInfo for the "OK" */

		SetDlgStuff(hdlg, ci);

		if (ci->database[0] == '\0')		
			;	/* default focus */
		else if (ci->server[0] == '\0')
			SetFocus(GetDlgItem(hdlg, IDC_SERVER));
		else if (ci->port[0] == '\0')
			SetFocus(GetDlgItem(hdlg, IDC_PORT));
		else if (ci->username[0] == '\0')
			SetFocus(GetDlgItem(hdlg, IDC_USER));
		else if (ci->focus_password)
			SetFocus(GetDlgItem(hdlg, IDC_PASSWORD));


		break; 

	case WM_COMMAND:
		switch (GET_WM_COMMAND_ID(wParam, lParam)) 
		{
		case IDOK:

			ci = (ConnInfo *) GetWindowLong(hdlg, DWL_USER);

			GetDlgStuff(hdlg, ci);


		case IDCANCEL:
			EndDialog(hdlg, GET_WM_COMMAND_ID(wParam, lParam) == IDOK);
			return TRUE;

		case IDC_DRIVER:

			DialogBoxParam(s_hModule, MAKEINTRESOURCE(DLG_OPTIONS_DRV),
									hdlg, driver_optionsProc, (LPARAM) NULL);


			break;

		case IDC_DATASOURCE:

			ci = (ConnInfo *) GetWindowLong(hdlg, DWL_USER);
			DialogBoxParam(s_hModule, MAKEINTRESOURCE(DLG_OPTIONS_DS),
									hdlg, ds_optionsProc, (LPARAM) ci);

			break;
		}
	}

	return FALSE;
}

#endif	/* WIN32 */

void dconn_get_connect_attributes(UCHAR FAR *connect_string, ConnInfo *ci)
{
	char *our_connect_string;
	char *pair, *attribute, *value, *equals;
	char *strtok_arg;

	memset(ci, 0, sizeof(ConnInfo));

	our_connect_string = strdup(connect_string);
	strtok_arg = our_connect_string;

	mylog("our_connect_string = '%s'\n", our_connect_string);

	while(1)
	{
		pair = strtok(strtok_arg, ";");
		if(strtok_arg)
		{
			strtok_arg = 0;
		}
		if(!pair)
		{
			break;
		}

		equals = strchr(pair, '=');
		if ( ! equals)
			continue;

		*equals = '\0';
		attribute = pair;		/*	ex. DSN */
		value = equals + 1;		/*	ex. 'CEO co1' */

		mylog("attribute = '%s', value = '%s'\n", attribute, value);

		if( !attribute || !value)
			continue;          

		/*	Copy the appropriate value to the conninfo  */
		copyAttributes(ci, attribute, value);

	}


	free(our_connect_string);
}

