
/* Module:          bind.c
 *
 * Description:     This module contains routines related to binding 
 *                  columns and parameters.
 *
 * Classes:         BindInfoClass, ParameterInfoClass
 *
 * API functions:   None
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */


#include "driver.h"
/********************************************************************
 *   Bindings Implementation
 */
BindInfoClass *create_empty_bindings(int num_columns)
{
	BindInfoClass *new_bindings;
	int i;

	new_bindings = (BindInfoClass *)malloc(num_columns * sizeof(BindInfoClass));
	if(!new_bindings)
	{
		return 0;
	}

	for(i=0; i < num_columns; i++)
	{
		new_bindings[i].buflen = 0;
		new_bindings[i].buffer = NULL;
		new_bindings[i].used = NULL;
		new_bindings[i].data_left = -1;
	}

	return new_bindings;
}

void extend_bindings(StatementClass *stmt, int num_columns)
{
	static char *func="extend_bindings";
	BindInfoClass *new_bindings;
	int i;

	mylog("%s: entering ... stmt=%u, bindings_allocated=%d, num_columns=%d\n", func, stmt, stmt->bindings_allocated, num_columns);

	/* if we have too few, allocate room for more, and copy the old */
	/* entries into the new structure */
	if(stmt->bindings_allocated < num_columns)
	{
		new_bindings = create_empty_bindings(num_columns);
		if ( ! new_bindings)
		{
			mylog("%s: unable to create %d new bindings from %d old bindings\n", func, num_columns, stmt->bindings_allocated);

			if (stmt->bindings)
			{
				free(stmt->bindings);
				stmt->bindings = NULL;
			}
			stmt->bindings_allocated = 0;
			return;
		}

		if(stmt->bindings)
		{
			for(i=0; i<stmt->bindings_allocated; i++)
			{
				new_bindings[i] = stmt->bindings[i];
			}
			
			free(stmt->bindings);
		}

		stmt->bindings = new_bindings;
		stmt->bindings_allocated = num_columns;

    } 
	/*	There is no reason to zero out extra bindings if there are */
	/*	more than needed.  If an app has allocated extra bindings,  */
	/*	let it worry about it by unbinding those columns. */

	/*	SQLBindCol(1..) ... SQLBindCol(10...)	# got 10 bindings */
	/*	SQLExecDirect(...)  # returns 5 cols */
	/*	SQLExecDirect(...)	# returns 10 cols  (now OK) */

	mylog("exit extend_bindings\n");
}
