/* Module:          SQLNumParams.c
 *
 * Description:     Returns the number of parameters in an SQL statement.
 *
 * Classes:         
 *
 * API functions:   SQLNumParams
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLNumParams(
					   SQLHSTMT			hDrvStmt,
					   SQLSMALLINT		*pnParamCount
					   )
{
	StatementClass *stmt = (StatementClass *) hDrvStmt;
	char in_quote = FALSE;
	unsigned int i;
	static char *func = "SQLNumParams";
	mylog( "%s: entering...\n", func);

	if(!stmt)
	{
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	if (pnParamCount)
	{
		*pnParamCount = 0;
	}

	else
	{
		SC_log_error(func, "pnParamCount was null", stmt);
		return SQL_ERROR;
	}


	if(!stmt->statement)
	{
		/* no statement has been allocated */
		stmt->errormsg = "SQLNumParams called with no statement ready.";
		stmt->errornumber = STMT_SEQUENCE_ERROR;
		SC_log_error(func, "", stmt);
		return SQL_ERROR;
	} 
	else
	{
		for(i=0; i < strlen(stmt->statement); i++)
		{
			if(stmt->statement[i] == '?' && !in_quote)
			{
				(*pnParamCount)++;
			}

			else
			{
				if (stmt->statement[i] == '\'')
				{
					in_quote = (in_quote ? FALSE : TRUE);
				}
			}
		}

		return SQL_SUCCESS;
	}
}

