/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.postgresql.pljava.Session;

public class SessionManager {
    private static Method s_getSession;

    public static Session current() throws SQLException {
        try {
            if (s_getSession == null) {
                String string = System.getProperty("org.postgresql.pljava.sessionprovider", "org.postgresql.pljava.internal.Backend");
                Class<?> clazz = Class.forName(string);
                s_getSession = clazz.getMethod("getSession", null);
            }
            return (Session)s_getSession.invoke(null, null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                throw (SQLException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new SQLException(throwable.getMessage());
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }
}

