<?php
/**************************************************
Program name:	get_table_def.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of columns on table and the column info
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

// Builds array called $table_def_array[$i][$j]
// $i is row number:  0,1,2,3
// $j is column name: attnum | field | type | length | lengthvar | notnull | rowdefault

# Get the columns (name, type, length, null, default) of a table.
/*
0 - attnum
1 - Name
2 - Type
3 - length
4 - lengthvar
5 - notnull
6 - rowdefault
7 - description
Added Manually
8 - insert_default
9 - display_default
*/

//SUB-SELECTS
$ysnUniqueSQL = "
		SELECT 
			count(i.indisunique)
		FROM 
			pg_index i,
			pg_attribute ta,
			pg_class pc
		WHERE 
			ta.attrelid = i.indexrelid
			AND i.indrelid = pc.oid
			AND ta.attname = a.attname
			AND i.indisunique = 't'
			AND pc.relname = '$table'
		";

$ysnIndexedSQL = "
		SELECT 
			count(i.indisunique)
		FROM 
			pg_index i,
			pg_attribute ta,
			pg_class pc
		WHERE 
			ta.attrelid = i.indexrelid
			AND i.indrelid = pc.oid
			AND ta.attname = a.attname
			AND pc.relname = '$table'
		";

$ysnPrimarySQL = "
		SELECT 
			count(i.indisprimary)
		FROM 
			pg_index i,
			pg_attribute ta,
			pg_class pc
		WHERE 
			ta.attrelid = i.indexrelid
			AND i.indrelid = pc.oid
			AND ta.attname = a.attname
			AND i.indisprimary = 't'
			AND pc.relname = '$table'
		";
// # of FK relationships
$ysnForeignSQL = "
		SELECT   
			count(ptf.tgrelid) 
		FROM 
			pg_trigger ptf, 
			pg_class pcf				
		WHERE 
			ptf.tgtype = 21 
			AND pcf.oid = ptf.tgrelid
			AND pcf.relname = '$table'
		";

// # of PK relationships
$ysnPKRelSQL = "
		SELECT   
			count(ptf.tgrelid) 
		FROM 
			pg_trigger ptf, 
			pg_class pcf				
		WHERE 
			ptf.tgtype = 9 
			AND pcf.oid = ptf.tgrelid
			AND pcf.relname = '$table'
		";

$ysnConstraintsSQL = "
		SELECT 
			count(chk.rcname) 
		FROM 
			pg_relcheck chk,
			pg_class bcc
		WHERE 
			chk.rcrelid = bcc.oid 
			and bcc.relname = '$table'
			and not exists  
			(select * from pg_relcheck as c, pg_inherits as i 
			where i.inhrelid = pg_relcheck.rcrelid 
			and c.rcname = pg_relcheck.rcname 
			and c.rcsrc = pg_relcheck.rcsrc 
			and c.rcrelid = i.inhparent) 
	";
$ysnIndexesSQL = "
		SELECT 
			count(i.oid)
		FROM 
			pg_index i,
			pg_attribute ta,
			pg_class pc
		WHERE 
			ta.attrelid = i.indexrelid
			AND i.indrelid = pc.oid
			AND pc.relname = '$table'
		";

$ysnRulesSQL = "
		SELECT 
			count(rulename)
		FROM 
			pg_rules
		WHERE 
			tablename = '$table'
		";

$ysnTriggersSQL = "
	SELECT  
	 	count(ptr.tgrelid)
	FROM 
		(pg_trigger ptr LEFT JOIN pg_proc pp ON pp.oid = ptr.tgfoid) 
		LEFT JOIN pg_class pc ON ptr.tgrelid = pc.oid
	WHERE 
		pc.relname = '$table'
		AND ptr.tgname !~ '^RI_Const' 
	";


$sql_get = "
	SELECT 
		a.attnum,
		a.attname AS ".dquotes($strField).", 
		t.typname AS ".dquotes($strType).", 
		a.attlen AS ".dquotes($strLengthSet).",
		a.atttypmod AS lengthvar,
		a.attnotnull AS ".dquotes($strNotNull).", 
		(SELECT 
			d.adsrc AS rowdefault
		FROM 
			pg_attrdef d, 
			pg_class c 
		WHERE 
			c.relname = '$table' AND 
			c.oid = d.adrelid AND
			d.adnum = a.attnum
		) as ".dquotes($strDefault).",
		obj_description(a.oid) as ".dquotes($strComment).",
		1 as insert_default,
		2 as display_default,
		(".$ysnIndexedSQL.") as ".dquotes($strIndexed).",
		(".$ysnUniqueSQL.") as ".dquotes($strUnique).",
		(".$ysnPrimarySQL.") as ".dquotes($strPrimaryKey).",
		(".$ysnForeignSQL.") as ".dquotes($strForeignKey).",
		(".$ysnConstraintsSQL.") as ".dquotes($strConstraints).",    
		(".$ysnIndexesSQL.") as ".dquotes($strIndexes).", 
		(".$ysnPKRelSQL.") as pkrelations, 
		(".$ysnTriggersSQL.") as trig, 
		(".$ysnRulesSQL.") as ".dquotes($strRule)."  
	FROM 
		pg_class c, 
		pg_attribute a, 
		pg_type t
	WHERE 
		c.relname = '$table'
		and a.attnum > 0
		and a.attrelid = c.oid
		and a.atttypid = t.oid";
# add where statment for field for tbl_alter when modifying selected column
If (webpage($PHP_SELF) == "tbl_alterpage.php") {
		$sql_get .= "
		and a.attname = '$field'
		";
}

$sql_get .= "
	ORDER BY a.attnum
	";


// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// Modifications to Array
for ($i = 0; $i < $num_rows; $i++) {

		# Field Name
		// create single array
		$field_name[$i] = $sql_array[$i][1];

		# Assign bpchar to char 
		if ($sql_array[$i][2] == "bpchar") {
			$sql_array[$i][2] = "char";
		}
		// create single array
		$field_type[$i] = $sql_array[$i][2];

		# Length 
		if (trim($sql_array[$i][2]) == "numeric") {
			$sql_array[$i][3] = ($sql_array[$i][4] >> 16) & 0xffff . ($sql_array[$i][4] - 4) & 0xffff ; 
		} else {
			if ($sql_array[$i][3] > 0) {
				# do nothing 
			} else if($sql_array[$i][3] > 0) {
				$sql_array[$i][3] = $sql_array[$i][lengthvar] - 4;
			} else {
				$sql_array[$i][3] = "var";
			}
		}

		# Null/Not Null 
		$sql_array[$i][5] = bool_YesNo($sql_array[$i][5]);

		# Default 


	// for inssertpage.
		// if conditions below are false, [insert_default] is [rowdefault]
		$sql_array[$i][8] = $sql_array[$i][6];
		$sql_array[$i][9] = $sql_array[$i][6];

		// Modify Default value if it's not empty
		if (!empty($sql_array[$i][6])) {
		
			// If Default Value has function in it (e.g. nextval('"asdf"'::text) then separate
			// function name and argument 
			// $vals[1] is function name, $vals[2] is argument of function
			if (eregi("([[:alnum:]_]+)\(([[:alnum:][:punct:][:cntrl:][:space:]]*)\)$", $sql_array[$i][6], $vals)) { 
					// Function Name of default   //single dim array for select_box()
					$selected_func[$i] = $vals[1];
			
					// Argument of Function (insert_default)
					$sql_array[$i][8] = $vals[2];

					// 
					#$sql_array[$i][8] = ereg_replace("'$", "$cfgQuotes'", $sql_array[$i][8]);
					
			}
			
			
		} else {
			unset($sql_def_array[$i][8]);
		}

		// Strip out leading and trailing single quotes on insert_default (arguement only)
		$sql_array[$i][8] = strip_sq($sql_array[$i][8]);

		// Strip out leading and trailing single quotes on display_default (function and arguement)
		$sql_array[$i][9] = strip_sq($sql_array[$i][6]);

		$Extra_Column_Value[$i][0] = $selected_func[$i];
		$Extra_Column_Value[$i][1] = $sql_array[$i][8];

		# has index
		if ($sql_array[$i][$strIndexed] > 0) {
			$sql_array[$i][10] = $strYes;
		} else {
			$sql_array[$i][10] = $strNo;
		}

		# is unique;
		if ($sql_array[$i][$strUnique] > 0) {
			$sql_array[$i][11] = $strYes;
		} else {
			$sql_array[$i][11] = $strNo;
		}

		# is primary Key
		if ($sql_array[$i][$strPrimaryKey] > 0) {
			$sql_array[$i][12] = $strYes;
		} else {
			$sql_array[$i][12] = $strNo;
		}

		# num foreign Key Relationships
		if ($sql_array[$i][$strForeignKey] > 0) {
			$numFK = $sql_array[$i][$strForeignKey];
		} else {
			$numFK = 0;
		}

		# num Primary Key Relationships
		if ($sql_array[$i][pkrelations] > 0) {
			$numPK = $sql_array[$i][pkrelations];
		} else {
			$numPK = 0;
		}

		# Constraints
		if ($sql_array[$i][$strConstraints] > 0) {
			$numConstraints = $sql_array[$i][$strConstraints];
		} else {
			$numConstraints = 0 ;
		}

		# Rules
		if ($sql_array[$i][$strRule] > 0) {
			$numRules = $sql_array[$i][$strRule];
		} else {
			$numRules = 0 ;
		}

		# Indexes
		$numIndexes = $sql_array[$i][$strIndexes];

		# Triggers
		$numTriggers = $sql_array[$i][trig];
}

$SQL_Column_Show[8] = false;
$SQL_Column_Show[9] = false;  
$SQL_Column_Show[10] = false;  
$SQL_Column_Show[11] = false;
$SQL_Column_Show[12] = false;  
$SQL_Column_Show[13] = false;  
$SQL_Column_Show[14] = false;  
$SQL_Column_Show[15] = false;  
$SQL_Column_Show[16] = false;  
$SQL_Column_Show[17] = false;  
$SQL_Column_Show[18] = false;  


?>
