<?php

/**************************************************
Program name:	get_array_functions.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of table names, owner, comments.
			
Create Date:	6/29/01 

Modified Date(s): CHANGE $max
**************************************************/


// SQL string to get list of tables
$max = $builtin_max;

$sql_get = "
				SELECT 
					pc.oid,
					pc.proname as ".dquotes($strFunc).",  
					oidvectortypes(pc.proargtypes) AS ".dquotes($strArgs).",
					pt.typname as ".dquotes($strRetType).",
					pc.prorettype,
					pu.usename as ".dquotes($strOwner).",
					pl.lanname as ".dquotes($strLang).",
					pc.prosrc as ".dquotes($strSrc).", 
					obj_description(pc.oid) as ".dquotes($strDescription)."
				FROM 
					(pg_proc pc LEFT JOIN pg_user pu ON pc.proowner = pu.usesysid) 
					LEFT JOIN pg_language pl ON pc.prolang = pl.oid, 
					pg_type pt
				WHERE
					pc.prorettype = pt.oid
				";

		If ( (webpage($PHP_SELF) == "funclistpage.php") or (webpage($PHP_SELF) == "trig_changefunctionpage.php") or (webpage($PHP_SELF) == "trig_createpage.php")) {
				$sql_get .= "
					AND pc.oid > '$max'::oid";
		} else {
				$sql_get .= "
					AND pc.oid = '$foid'::oid";
		}
$sql_get .= "
				UNION
				SELECT 
					pc.oid,
					pc.proname  as ".dquotes($strFunc).", 
					oidvectortypes(pc.proargtypes) AS ".dquotes($strArgs).",
					'OPAQUE' AS ".dquotes($strRetType).",
					pc.prorettype,
					pu.usename as ".dquotes($strOwner).",
					pl.lanname as ".dquotes($strLang).",
					pc.prosrc as ".dquotes($strSrc).",
					obj_description(pc.oid) as ".dquotes($strDescription)."
				FROM 
					(pg_proc pc LEFT JOIN pg_user pu ON pc.proowner = pu.usesysid) 
					 LEFT JOIN pg_language pl ON pc.prolang = pl.oid, 
					pg_type pt
				WHERE
					pc.prorettype = 0
				";

		If ( (webpage($PHP_SELF) == "funclistpage.php") or (webpage($PHP_SELF) == "trig_changefunctionpage.php") or (webpage($PHP_SELF) == "trig_createpage.php")) {
				$sql_get .= "
					AND pc.oid > '$max'::oid";
		} else {
				$sql_get .= "
					AND pc.oid = '$foid'::oid";
		}


// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// Modify Array
for ($i = 0; $i < $num_rows; $i++) {

	// Make array table names
	$aryFunctions[$i] = $sql_array[$i][1]."(".$sql_array[$i][2].")";
	
	// Make array opaque functions
	if ($sql_array[$i][prorettype] == 0) {
		$aryOpaqueFunctions[$i] = $sql_array[$i][1]."(".$sql_array[$i][2].")";
	}

	// Change Function name into a link
	$sql_array[$i][1] = "<a class=link href=func_properties.php?nfoid=".$sql_array[$i][0].">".$sql_array[$i][1]."</a>";

}

// Comments
$SQL_Column_Show[8] = $cfgShowComments;


// Remove plpgsql_call_handler() from Opaque function array.
 
$key_plpgsql = @array_keys($aryOpaqueFunctions, "plpgsql_call_handler()");
if (isset($key_plpgsql)) {
	array_splice($aryOpaqueFunctions, $key_plpgsql[0], 1); 
	sort($aryOpaqueFunctions); 
}

?>
