VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form frmSQL 
   Caption         =   "SQL"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6585
   Icon            =   "frmSQL.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3195
   ScaleWidth      =   6585
   Begin VB.CommandButton cmdSQLWizard 
      Caption         =   "S&QL Wizard"
      Height          =   330
      Left            =   4140
      TabIndex        =   4
      ToolTipText     =   "Execute the SQL query"
      Top             =   2835
      Width           =   1170
   End
   Begin VB.CommandButton cmdLoad 
      Caption         =   "&Load Query"
      Height          =   330
      Left            =   0
      TabIndex        =   3
      ToolTipText     =   "Execute the SQL query"
      Top             =   2835
      Width           =   1170
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "&Save Query"
      Height          =   330
      Left            =   1260
      TabIndex        =   2
      ToolTipText     =   "Execute the SQL query"
      Top             =   2835
      Width           =   1170
   End
   Begin VB.CommandButton cmdExecute 
      Caption         =   "&Execute"
      Height          =   330
      Left            =   5400
      TabIndex        =   1
      ToolTipText     =   "Execute the SQL query"
      Top             =   2835
      Width           =   1170
   End
   Begin VB.TextBox txtSQL 
      Height          =   2745
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      ToolTipText     =   "Enter an SQL query to execute"
      Top             =   0
      Width           =   6525
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   0
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      DialogTitle     =   "Select SQL File"
      Filter          =   "All Files (*.*)|*.*"
   End
End
Attribute VB_Name = "frmSQL"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' pgAdmin - PostgreSQL db Administration/Management for Win32
' Copyright (C) 1998 - 2000, Dave Page

' This program is free software; you can redistribute it and/or
' modify it under the terms of the GNU General Public License
' as published by the Free Software Foundation; either version 2
' of the License, or (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Option Explicit
Dim bDirty As Boolean
Public szTitle As String
Dim szFilename As String

Private Sub cmdExecute_Click()
On Error GoTo Err_Handler
  If Len(txtSQL.Text) < 5 Then Exit Sub
  If UCase(Mid(txtSQL.Text, 1, 6)) = "SELECT" Then
    SQLQuery = txtSQL.Text
    Dim DataForm As New frmSQLOutput
    Load DataForm
    If DataForm.Tag = "ERROR" Then
      Unload DataForm
      Exit Sub
    End If
    DataForm.Show
    Exit Sub
  End If
  If UCase(Mid(txtSQL.Text, 1, 7)) = "EXPLAIN" Then
    Dim rs As New Recordset
    rs.Open txtSQL.Text, gConnection
    MsgBox Err.Description
    Exit Sub
  End If
  LogMsg "Executing: " & txtSQL.Text
  gConnection.Execute txtSQL.Text
  LogQuery txtSQL.Text
  MsgBox "Query Executed OK!", vbInformation
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmSQL, cmdExecute_Click"
End Sub

Private Sub cmdLoad_Click()
On Error GoTo Err_Handler
Dim DataLine As String
Dim fNum As Integer
  If bDirty = True Then
    If MsgBox("This query has been edited - do you wish to save it?", vbQuestion + vbYesNo, "Save Query") = vbYes Then cmdSave_Click
  End If
  With CommonDialog1
    .DialogTitle = "Load SQL Query"
    .Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly
    .Filter = "SQL Scripts (*.sql)|*.sql|All Files (*.*)|*.*"
    .FileName = ""
    .CancelError = True
    .ShowOpen
  End With
  If CommonDialog1.FileName = "" Then Exit Sub
  txtSQL.Text = ""
  fNum = FreeFile
  LogMsg "Loading " & CommonDialog1.FileName
  Open CommonDialog1.FileName For Input As #fNum
  While Not EOF(fNum)
    Line Input #fNum, DataLine
    txtSQL.Text = txtSQL.Text & DataLine & vbCrLf
  Wend
  Close #fNum
  Get_Filename
  Me.Caption = szTitle & " (" & szFilename & ")"
  bDirty = False
  Exit Sub
Err_Handler: If Err.Number <> 0 And Err.Number <> 32755 Then LogError Err, "frmSQL, cmdLoad_Click"
End Sub

Private Sub cmdSave_Click()
On Error GoTo Err_Handler
Dim DataLine As String
Dim fNum As Integer
  With CommonDialog1
    .DialogTitle = "Save SQL Query"
    .Filter = "SQL Scripts (*.sql)|*.sql"
    .CancelError = True
    .ShowSave
  End With
  If CommonDialog1.FileName = "" Then
    MsgBox "No filename specified - SQL query not saved.", vbExclamation, "Warning"
    Exit Sub
  End If
  If Dir(CommonDialog1.FileName) <> "" Then
    If MsgBox("File exists - overwrite?", vbYesNo + vbQuestion, "Overwrite File") = vbNo Then cmdSave_Click
  End If
  fNum = FreeFile
  LogMsg "Writing " & CommonDialog1.FileName
  Open CommonDialog1.FileName For Output As #fNum
  Print #fNum, txtSQL.Text
  Close #fNum
  Get_Filename
  Me.Caption = szTitle & " (" & szFilename & ")"
  bDirty = False
  Exit Sub
Err_Handler: If Err.Number <> 0 And Err.Number <> 32755 Then LogError Err, "frmSQL, cmdSave_Click"
End Sub

Private Sub cmdSQLWizard_Click()
On Error GoTo Err_Handler
Dim SQLWizard As New frmSQLWizard
  Load SQLWizard
  SQLWizard.Tag = Me.hwnd
  SQLWizard.Caption = SQLWizard.Caption & " (" & Me.Caption & ")"
  SQLWizard.Show
  SQLWizard.WindowState = WinState
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmSQL, cmdSQLWizard_Click"
End Sub

Private Sub Form_Load()
On Error GoTo Err_Handler
  LogMsg "Loading Form: " & Me.Name
  bDirty = False
  Me.Height = 3600
  Me.Width = 6705
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmSQL, Form_Load"
End Sub

Private Sub Form_Resize()
On Error GoTo Err_Handler
  If Me.WindowState <> 1 Then
    If Me.WindowState = 0 Then
      If Me.Width < 6705 Then Me.Width = 6705
      If Me.Height < 3600 Then Me.Height = 3600
    End If
    txtSQL.Width = Me.ScaleWidth
    txtSQL.Height = Me.ScaleHeight - cmdExecute.Height - 50
    cmdExecute.Top = Me.ScaleHeight - cmdExecute.Height
    cmdLoad.Top = cmdExecute.Top
    cmdSave.Top = cmdExecute.Top
    cmdSQLWizard.Top = cmdExecute.Top
    cmdSQLWizard.Left = cmdExecute.Left - cmdSQLWizard.Width - 100
    cmdExecute.Left = Me.ScaleWidth - cmdExecute.Width
  End If
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmSQL, Form_Resize"
End Sub

Private Sub Form_Unload(Cancel As Integer)
On Error GoTo Err_Handler
  If bDirty = True Then
    If MsgBox("This query has been edited - do you wish to save it?", vbQuestion + vbYesNo, "Save Query") = vbYes Then cmdSave_Click
  End If
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmSQL, Form_Unload"
End Sub

Private Sub txtSQL_Change()
On Error GoTo Err_Handler
  If CommonDialog1.FileName = "" Then
    Me.Caption = szTitle & " (Edited)"
  Else
    Me.Caption = szTitle & " (" & szFilename & ") (Edited)"
  End If
  bDirty = True
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmSQL, txtSQL_Change"
End Sub

Private Sub Get_Filename()
On Error GoTo Err_Handler
Dim iSlashes As Integer
Dim iLastPos As Integer
Dim iCount As Integer
  iSlashes = CountChar(CommonDialog1.FileName, Asc("\"))
  If iSlashes = 0 Then
    szFilename = CommonDialog1.FileName
  Else
    For iCount = 1 To Len(CommonDialog1.FileName)
      If Mid(CommonDialog1.FileName, iCount, 1) = "\" Then iLastPos = iCount
    Next
    szFilename = Mid(CommonDialog1.FileName, iLastPos + 1)
  End If
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmSQL, Get_Filename"
End Sub


