/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.3
 *
 * Copyright (c) 2023 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtNetwork.h"

#line 147 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtNetwork/qhostaddress.sip"
#include <qhostaddress.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.10/build/QtNetwork/sipQtNetworkQ_IPV6ADDR.cpp"



extern "C" {static void assign_Q_IPV6ADDR(void *, Py_ssize_t, void *);}
static void assign_Q_IPV6ADDR(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::Q_IPV6ADDR *>(sipDst)[sipDstIdx] = *reinterpret_cast<::Q_IPV6ADDR *>(sipSrc);
}


extern "C" {static void *array_Q_IPV6ADDR(Py_ssize_t);}
static void *array_Q_IPV6ADDR(Py_ssize_t sipNrElem)
{
    return new ::Q_IPV6ADDR[sipNrElem];
}


extern "C" {static void *copy_Q_IPV6ADDR(const void *, Py_ssize_t);}
static void *copy_Q_IPV6ADDR(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::Q_IPV6ADDR(reinterpret_cast<const ::Q_IPV6ADDR *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_Q_IPV6ADDR(void *, int);}
static void release_Q_IPV6ADDR(void *sipCppV, int)
{
    ::Q_IPV6ADDR *sipCpp = reinterpret_cast<::Q_IPV6ADDR *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_Q_IPV6ADDR(PyObject *, void **, int *, PyObject *);}
static int convertTo_Q_IPV6ADDR(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::Q_IPV6ADDR **sipCppPtr = reinterpret_cast<::Q_IPV6ADDR **>(sipCppPtrV);

#line 176 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtNetwork/qhostaddress.sip"
    // Check the type if that is all that is required.
    if (sipIsErr == NULL)
        return (PySequence_Check(sipPy) && PySequence_Size(sipPy) == 16);

    Q_IPV6ADDR *qa = new Q_IPV6ADDR;
 
    for (Py_ssize_t i = 0; i < 16; ++i)
    {
        PyObject *itm = PySequence_GetItem(sipPy, i);

        if (!itm)
        {
            delete qa;
            *sipIsErr = 1;

            return 0;
        }

        (*qa)[i] = SIPLong_AsLong(itm);

        Py_DECREF(itm);
    }
 
    *sipCppPtr = qa;
 
    return sipGetState(sipTransferObj);
#line 96 "/build/pyqt5/src/PyQt5-5.15.10/build/QtNetwork/sipQtNetworkQ_IPV6ADDR.cpp"
}


extern "C" {static PyObject *convertFrom_Q_IPV6ADDR(void *, PyObject *);}
static PyObject *convertFrom_Q_IPV6ADDR(void *sipCppV, PyObject *)
{
    ::Q_IPV6ADDR *sipCpp = reinterpret_cast<::Q_IPV6ADDR *>(sipCppV);

#line 151 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtNetwork/qhostaddress.sip"
    // Create the tuple.
    PyObject *t;

    if ((t = PyTuple_New(16)) == NULL)
        return NULL;

    // Set the tuple elements.
    for (int i = 0; i < 16; ++i)
    {
        PyObject *pobj;

        if ((pobj = SIPLong_FromLong((*sipCpp)[i])) == NULL)
        {
            Py_DECREF(t);

            return NULL;
        }

        PyTuple_SetItem(t, i, pobj);
    }

    return t;
#line 128 "/build/pyqt5/src/PyQt5-5.15.10/build/QtNetwork/sipQtNetworkQ_IPV6ADDR.cpp"
}


sipMappedTypeDef sipTypeDef_QtNetwork_Q_IPV6ADDR = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_Q_IPV6ADDR,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_Q_IPV6ADDR,
    array_Q_IPV6ADDR,
    copy_Q_IPV6ADDR,
    release_Q_IPV6ADDR,
    convertTo_Q_IPV6ADDR,
    convertFrom_Q_IPV6ADDR
};
