/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.3
 *
 * Copyright (c) 2023 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 329 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
#include <qpolygon.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"

#line 28 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"
#line 98 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"
#line 164 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
#include <qpolygon.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"
#line 30 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qtransform.sip"
#include <qtransform.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"


PyDoc_STRVAR(doc_QPolygonF_translate, "translate(self, offset: Union[QPointF, QPoint])\n"
"translate(self, dx: float, dy: float)");

extern "C" {static PyObject *meth_QPolygonF_translate(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_translate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State))
        {
            sipCpp->translate(*a0);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::qreal a0;
        ::qreal a1;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdd", &sipSelf, sipType_QPolygonF, &sipCpp, &a0, &a1))
        {
            sipCpp->translate(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_translate, doc_QPolygonF_translate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_toPolygon, "toPolygon(self) -> QPolygon");

extern "C" {static PyObject *meth_QPolygonF_toPolygon(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_toPolygon(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            ::QPolygon*sipRes;

            sipRes = new ::QPolygon(sipCpp->toPolygon());

            return sipConvertFromNewType(sipRes, sipType_QPolygon, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_toPolygon, doc_QPolygonF_toPolygon);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_isClosed, "isClosed(self) -> bool");

extern "C" {static PyObject *meth_QPolygonF_isClosed(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_isClosed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isClosed();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_isClosed, doc_QPolygonF_isClosed);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_boundingRect, "boundingRect(self) -> QRectF");

extern "C" {static PyObject *meth_QPolygonF_boundingRect(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_boundingRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            ::QRectF*sipRes;

            sipRes = new ::QRectF(sipCpp->boundingRect());

            return sipConvertFromNewType(sipRes, sipType_QRectF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_boundingRect, doc_QPolygonF_boundingRect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_containsPoint, "containsPoint(self, pt: Union[QPointF, QPoint], fillRule: Qt.FillRule) -> bool");

extern "C" {static PyObject *meth_QPolygonF_containsPoint(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_containsPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        ::Qt::FillRule a1;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1E", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State, sipType_Qt_FillRule, &a1))
        {
            bool sipRes;

            sipRes = sipCpp->containsPoint(*a0, a1);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_containsPoint, doc_QPolygonF_containsPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_united, "united(self, r: QPolygonF) -> QPolygonF");

extern "C" {static PyObject *meth_QPolygonF_united(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_united(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPolygonF, &a0))
        {
            ::QPolygonF*sipRes;

            sipRes = new ::QPolygonF(sipCpp->united(*a0));

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_united, doc_QPolygonF_united);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_intersected, "intersected(self, r: QPolygonF) -> QPolygonF");

extern "C" {static PyObject *meth_QPolygonF_intersected(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_intersected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPolygonF, &a0))
        {
            ::QPolygonF*sipRes;

            sipRes = new ::QPolygonF(sipCpp->intersected(*a0));

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_intersected, doc_QPolygonF_intersected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_subtracted, "subtracted(self, r: QPolygonF) -> QPolygonF");

extern "C" {static PyObject *meth_QPolygonF_subtracted(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_subtracted(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPolygonF, &a0))
        {
            ::QPolygonF*sipRes;

            sipRes = new ::QPolygonF(sipCpp->subtracted(*a0));

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_subtracted, doc_QPolygonF_subtracted);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_translated, "translated(self, offset: Union[QPointF, QPoint]) -> QPolygonF\n"
"translated(self, dx: float, dy: float) -> QPolygonF");

extern "C" {static PyObject *meth_QPolygonF_translated(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_translated(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State))
        {
            ::QPolygonF*sipRes;

            sipRes = new ::QPolygonF(sipCpp->translated(*a0));
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    {
        ::qreal a0;
        ::qreal a1;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bdd", &sipSelf, sipType_QPolygonF, &sipCpp, &a0, &a1))
        {
            ::QPolygonF*sipRes;

            sipRes = new ::QPolygonF(sipCpp->translated(a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_translated, doc_QPolygonF_translated);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_append, "append(self, value: Union[QPointF, QPoint])");

extern "C" {static PyObject *meth_QPolygonF_append(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_append(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State))
        {
            sipCpp->append(*a0);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_append, doc_QPolygonF_append);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_at, "at(self, i: int) -> QPointF");

extern "C" {static PyObject *meth_QPolygonF_at(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_at(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QPolygonF, &sipCpp, &a0))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->at(a0));

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_at, doc_QPolygonF_at);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_clear, "clear(self)");

extern "C" {static PyObject *meth_QPolygonF_clear(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            sipCpp->clear();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_clear, doc_QPolygonF_clear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_contains, "contains(self, value: Union[QPointF, QPoint]) -> bool");

extern "C" {static PyObject *meth_QPolygonF_contains(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_contains(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State))
        {
            bool sipRes;

            sipRes = sipCpp->contains(*a0);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_contains, doc_QPolygonF_contains);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_count, "count(self, value: Union[QPointF, QPoint]) -> int\n"
"count(self) -> int");

extern "C" {static PyObject *meth_QPolygonF_count(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_count(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State))
        {
            int sipRes;

            sipRes = sipCpp->count(*a0);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    {
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->count();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_count, doc_QPolygonF_count);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_data, "data(self) -> Optional[PyQt5.sip.voidptr]");

extern "C" {static PyObject *meth_QPolygonF_data(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            void*sipRes;

            sipRes = sipCpp->data();

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_data, doc_QPolygonF_data);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_fill, "fill(self, value: Union[QPointF, QPoint], size: int = -1)");

extern "C" {static PyObject *meth_QPolygonF_fill(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_fill(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        int a1 = -1;
        ::QPolygonF *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State, &a1))
        {
            sipCpp->fill(*a0, a1);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_fill, doc_QPolygonF_fill);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_first, "first(self) -> QPointF");

extern "C" {static PyObject *meth_QPolygonF_first(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_first(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = &sipCpp->first();

            return sipConvertFromType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_first, doc_QPolygonF_first);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_indexOf, "indexOf(self, value: Union[QPointF, QPoint], from_: int = 0) -> int");

extern "C" {static PyObject *meth_QPolygonF_indexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_indexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        int a1 = 0;
        const ::QPolygonF *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State, &a1))
        {
            int sipRes;

            sipRes = sipCpp->indexOf(*a0, a1);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_indexOf, doc_QPolygonF_indexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_insert, "insert(self, i: int, value: Union[QPointF, QPoint])");

extern "C" {static PyObject *meth_QPolygonF_insert(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_insert(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QPointF* a1;
        int a1State = 0;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ1", &sipSelf, sipType_QPolygonF, &sipCpp, &a0, sipType_QPointF, &a1, &a1State))
        {
            sipCpp->insert(a0, *a1);
            sipReleaseType(const_cast<::QPointF *>(a1), sipType_QPointF, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_insert, doc_QPolygonF_insert);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_isEmpty, "isEmpty(self) -> bool");

extern "C" {static PyObject *meth_QPolygonF_isEmpty(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_isEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isEmpty();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_isEmpty, doc_QPolygonF_isEmpty);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_last, "last(self) -> QPointF");

extern "C" {static PyObject *meth_QPolygonF_last(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_last(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = &sipCpp->last();

            return sipConvertFromType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_last, doc_QPolygonF_last);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_lastIndexOf, "lastIndexOf(self, value: Union[QPointF, QPoint], from_: int = -1) -> int");

extern "C" {static PyObject *meth_QPolygonF_lastIndexOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_lastIndexOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        int a1 = -1;
        const ::QPolygonF *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_from,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State, &a1))
        {
            int sipRes;

            sipRes = sipCpp->lastIndexOf(*a0, a1);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_lastIndexOf, doc_QPolygonF_lastIndexOf);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_mid, "mid(self, pos: int, length: int = -1) -> QPolygonF");

extern "C" {static PyObject *meth_QPolygonF_mid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_mid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1 = -1;
        const ::QPolygonF *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_length,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|i", &sipSelf, sipType_QPolygonF, &sipCpp, &a0, &a1))
        {
            ::QPolygonF*sipRes;

            sipRes = new ::QPolygonF(sipCpp->mid(a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_mid, doc_QPolygonF_mid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_prepend, "prepend(self, value: Union[QPointF, QPoint])");

extern "C" {static PyObject *meth_QPolygonF_prepend(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_prepend(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPointF, &a0, &a0State))
        {
            sipCpp->prepend(*a0);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_prepend, doc_QPolygonF_prepend);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_remove, "remove(self, i: int)\n"
"remove(self, i: int, count: int)");

extern "C" {static PyObject *meth_QPolygonF_remove(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_remove(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QPolygonF, &sipCpp, &a0))
        {
            sipCpp->remove(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        int a0;
        int a1;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bii", &sipSelf, sipType_QPolygonF, &sipCpp, &a0, &a1))
        {
            sipCpp->remove(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_remove, doc_QPolygonF_remove);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_replace, "replace(self, i: int, value: Union[QPointF, QPoint])");

extern "C" {static PyObject *meth_QPolygonF_replace(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_replace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QPointF* a1;
        int a1State = 0;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ1", &sipSelf, sipType_QPolygonF, &sipCpp, &a0, sipType_QPointF, &a1, &a1State))
        {
            sipCpp->replace(a0, *a1);
            sipReleaseType(const_cast<::QPointF *>(a1), sipType_QPointF, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_replace, doc_QPolygonF_replace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_size, "size(self) -> int");

extern "C" {static PyObject *meth_QPolygonF_size(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QPolygonF, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->size();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_size, doc_QPolygonF_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_value, "value(self, i: int) -> QPointF\n"
"value(self, i: int, defaultValue: Union[QPointF, QPoint]) -> QPointF");

extern "C" {static PyObject *meth_QPolygonF_value(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_value(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QPolygonF, &sipCpp, &a0))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->value(a0));

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    {
        int a0;
        const ::QPointF* a1;
        int a1State = 0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BiJ1", &sipSelf, sipType_QPolygonF, &sipCpp, &a0, sipType_QPointF, &a1, &a1State))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->value(a0, *a1));
            sipReleaseType(const_cast<::QPointF *>(a1), sipType_QPointF, a1State);

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_value, doc_QPolygonF_value);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_swap, "swap(self, other: QPolygonF)");

extern "C" {static PyObject *meth_QPolygonF_swap(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPolygonF* a0;
        ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPolygonF, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_swap, doc_QPolygonF_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QPolygonF_intersects, "intersects(self, r: QPolygonF) -> bool");

extern "C" {static PyObject *meth_QPolygonF_intersects(PyObject *, PyObject *);}
static PyObject *meth_QPolygonF_intersects(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;
        const ::QPolygonF *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QPolygonF, &sipCpp, sipType_QPolygonF, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->intersects(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName_intersects, doc_QPolygonF_intersects);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPolygonF___mul__(PyObject *, PyObject *);}
static PyObject *slot_QPolygonF___mul__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;
        const ::QTransform* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QPolygonF, &a0, sipType_QTransform, &a1))
        {
            ::QPolygonF*sipRes;

            sipRes = new ::QPolygonF((*a0 * *a1));

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static int slot_QPolygonF___contains__(PyObject *, PyObject *);}
static int slot_QPolygonF___contains__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPointF* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QPointF, &a0, &a0State))
        {
            int sipRes = 0;

#line 503 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
// It looks like you can't assign QBool to int.
sipRes = bool(sipCpp->contains(*a0));
#line 1021 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName___contains__, SIP_NULLPTR);

    return -1;
}


extern "C" {static int slot_QPolygonF___delitem__(PyObject *, PyObject *);}
static int slot_QPolygonF___delitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            int sipIsErr = 0;

#line 457 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
if ((a0 = (int)sipConvertFromSequenceIndex(a0, sipCpp->count())) < 0)
    sipIsErr = 1;
else
    sipCpp->remove(a0);
#line 1056 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            int sipIsErr = 0;

#line 465 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
Py_ssize_t start, stop, step, slicelength;

if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
{
    sipIsErr = 1;
}
else
{
    for (Py_ssize_t i = 0; i < slicelength; ++i)
    {
        sipCpp->remove(start);
        start += step - 1;
    }
}
#line 1087 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName___delitem__, SIP_NULLPTR);

    return -1;
}


extern "C" {static int slot_QPolygonF___setitem__(PyObject *, PyObject *);}
static int slot_QPolygonF___setitem__(PyObject *sipSelf, PyObject *sipArgs)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return -1;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QPointF* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "iJ1", &a0, sipType_QPointF, &a1, &a1State))
        {
            int sipIsErr = 0;

#line 414 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
int len;

len = sipCpp->count();

if ((a0 = (int)sipConvertFromSequenceIndex(a0, len)) < 0)
    sipIsErr = 1;
else
    (*sipCpp)[a0] = *a1;
#line 1130 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"
            sipReleaseType(const_cast<::QPointF *>(a1), sipType_QPointF, a1State);

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    {
        PyObject * a0;
        const ::QPolygonF* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "TJ9", &PySlice_Type, &a0, sipType_QPolygonF, &a1))
        {
            int sipIsErr = 0;

#line 426 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
Py_ssize_t start, stop, step, slicelength;

if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
{
    sipIsErr = 1;
}
else
{
    int vlen = a1->count();

    if (vlen != slicelength)
    {
        sipBadLengthForSlice(vlen, slicelength);
        sipIsErr = 1;
    }
    else
    {
        QVector<QPointF>::const_iterator it = a1->begin();

        for (Py_ssize_t i = 0; i < slicelength; ++i)
        {
            (*sipCpp)[start] = *it;
            start += step;
            ++it;
        }
    }
}
#line 1176 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"

            if (sipIsErr)
                return -1;

            return 0;
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName___setitem__, SIP_NULLPTR);

    return -1;
}


extern "C" {static PyObject *slot_QPolygonF___getitem__(PyObject *, PyObject *);}
static PyObject *slot_QPolygonF___getitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            ::QPointF*sipRes = 0;
            int sipIsErr = 0;

#line 402 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
Py_ssize_t idx = sipConvertFromSequenceIndex(a0, sipCpp->count());

if (idx < 0)
    sipIsErr = 1;
else
    sipRes = &sipCpp->operator[]((int)idx);
#line 1216 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    {
        PyObject * a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1T", &PySlice_Type, &a0))
        {
            ::QPolygonF*sipRes = 0;
            int sipIsErr = 0;

#line 483 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
Py_ssize_t start, stop, step, slicelength;

if (sipConvertFromSliceObject(a0, sipCpp->count(), &start, &stop, &step, &slicelength) < 0)
{
    sipIsErr = 1;
}
else
{
    sipRes = new QPolygonF();

    for (Py_ssize_t i = 0; i < slicelength; ++i)
    {
        (*sipRes) += (*sipCpp)[start];
        start += step;
    }
}
#line 1250 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"

            if (sipIsErr)
                return 0;

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QPolygonF, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPolygonF___lshift__(PyObject *, PyObject *);}
static PyObject *slot_QPolygonF___lshift__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPolygonF* a0;
        const ::QPointF* a1;
        int a1State = 0;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J1", sipType_QPolygonF, &a0, sipType_QPointF, &a1, &a1State))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 394 "/build/pyqt5/src/PyQt5-5.15.10/sip/QtGui/qpolygon.sip"
    *a0 << *a1;

    sipRes = sipArg0;
    Py_INCREF(sipRes);
#line 1284 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"
            sipReleaseType(const_cast<::QPointF *>(a1), sipType_QPointF, a1State);

            return sipRes;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, lshift_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QPolygonF___eq__(PyObject *, PyObject *);}
static PyObject *slot_QPolygonF___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygonF, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QPolygonF::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QPolygonF, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QPolygonF___iadd__(PyObject *, PyObject *);}
static PyObject *slot_QPolygonF___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygonF, &a0))
        {
            sipCpp->::QPolygonF::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        const ::QPointF* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QPointF, &a0, &a0State))
        {
            sipCpp->::QPolygonF::operator+=(*a0);
            sipReleaseType(const_cast<::QPointF *>(a0), sipType_QPointF, a0State);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf, sipArg, iconcat_slot);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPolygonF___add__(PyObject *, PyObject *);}
static PyObject *slot_QPolygonF___add__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygonF, &a0))
        {
            ::QPolygonF*sipRes;

            sipRes = new ::QPolygonF(sipCpp->::QPolygonF::operator+(*a0));

            return sipConvertFromNewType(sipRes, sipType_QPolygonF, SIP_NULLPTR);
        }
    }

    /* Raise an exception if the argument couldn't be parsed. */
    sipBadOperatorArg(sipSelf, sipArg, concat_slot);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QPolygonF___ne__(PyObject *, PyObject *);}
static PyObject *slot_QPolygonF___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QPolygonF* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QPolygonF, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QPolygonF::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QPolygonF, sipSelf, sipArg);
}


extern "C" {static Py_ssize_t slot_QPolygonF___len__(PyObject *);}
static Py_ssize_t slot_QPolygonF___len__(PyObject *sipSelf)
{
    ::QPolygonF *sipCpp = reinterpret_cast<::QPolygonF *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QPolygonF));

    if (!sipCpp)
        return 0;


    {
        {
            Py_ssize_t sipRes = 0;

#line 1 "Auto-generated"
            sipRes = (Py_ssize_t)sipCpp->count();
#line 1446 "/build/pyqt5/src/PyQt5-5.15.10/build/QtGui/sipQtGuiQPolygonF.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QPolygonF(void *, int);}
static void release_QPolygonF(void *sipCppV, int)
{
    delete reinterpret_cast<::QPolygonF *>(sipCppV);
}


extern "C" {static void *array_QPolygonF(Py_ssize_t);}
static void *array_QPolygonF(Py_ssize_t sipNrElem)
{
    return new ::QPolygonF[sipNrElem];
}


extern "C" {static void array_delete_QPolygonF(void *);}
static void array_delete_QPolygonF(void *sipCpp)
{
    delete[] reinterpret_cast<::QPolygonF *>(sipCpp);
}


extern "C" {static void assign_QPolygonF(void *, Py_ssize_t, void *);}
static void assign_QPolygonF(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::QPolygonF *>(sipDst)[sipDstIdx] = *reinterpret_cast<::QPolygonF *>(sipSrc);
}


extern "C" {static void *copy_QPolygonF(const void *, Py_ssize_t);}
static void *copy_QPolygonF(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QPolygonF(reinterpret_cast<const ::QPolygonF *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QPolygonF(sipSimpleWrapper *);}
static void dealloc_QPolygonF(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QPolygonF(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QPolygonF(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QPolygonF(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QPolygonF *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QPolygonF();

            return sipCpp;
        }
    }

    {
        const ::QPolygonF* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPolygonF, &a0))
        {
            sipCpp = new ::QPolygonF(*a0);

            return sipCpp;
        }
    }

    {
        const QVector<::QPointF>* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QVector_0100QPointF, &a0, &a0State))
        {
            sipCpp = new ::QPolygonF(*a0);
            sipReleaseType(const_cast<QVector<::QPointF> *>(a0), sipType_QVector_0100QPointF, a0State);

            return sipCpp;
        }
    }

    {
        const ::QRectF* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QRectF, &a0))
        {
            sipCpp = new ::QPolygonF(*a0);

            return sipCpp;
        }
    }

    {
        const ::QPolygon* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPolygon, &a0))
        {
            sipCpp = new ::QPolygonF(*a0);

            return sipCpp;
        }
    }

    {
        int a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "i", &a0))
        {
            sipCpp = new ::QPolygonF(a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QPolygonF[] = {
    {(void *)slot_QPolygonF___mul__, mul_slot},
    {(void *)slot_QPolygonF___contains__, contains_slot},
    {(void *)slot_QPolygonF___delitem__, delitem_slot},
    {(void *)slot_QPolygonF___setitem__, setitem_slot},
    {(void *)slot_QPolygonF___getitem__, getitem_slot},
    {(void *)slot_QPolygonF___lshift__, lshift_slot},
    {(void *)slot_QPolygonF___eq__, eq_slot},
    {(void *)slot_QPolygonF___iadd__, iconcat_slot},
    {(void *)slot_QPolygonF___add__, concat_slot},
    {(void *)slot_QPolygonF___ne__, ne_slot},
    {(void *)slot_QPolygonF___len__, len_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QPolygonF[] = {
    {sipName_append, meth_QPolygonF_append, METH_VARARGS, doc_QPolygonF_append},
    {sipName_at, meth_QPolygonF_at, METH_VARARGS, doc_QPolygonF_at},
    {sipName_boundingRect, meth_QPolygonF_boundingRect, METH_VARARGS, doc_QPolygonF_boundingRect},
    {sipName_clear, meth_QPolygonF_clear, METH_VARARGS, doc_QPolygonF_clear},
    {sipName_contains, meth_QPolygonF_contains, METH_VARARGS, doc_QPolygonF_contains},
    {sipName_containsPoint, meth_QPolygonF_containsPoint, METH_VARARGS, doc_QPolygonF_containsPoint},
    {sipName_count, meth_QPolygonF_count, METH_VARARGS, doc_QPolygonF_count},
    {sipName_data, meth_QPolygonF_data, METH_VARARGS, doc_QPolygonF_data},
    {sipName_fill, SIP_MLMETH_CAST(meth_QPolygonF_fill), METH_VARARGS|METH_KEYWORDS, doc_QPolygonF_fill},
    {sipName_first, meth_QPolygonF_first, METH_VARARGS, doc_QPolygonF_first},
    {sipName_indexOf, SIP_MLMETH_CAST(meth_QPolygonF_indexOf), METH_VARARGS|METH_KEYWORDS, doc_QPolygonF_indexOf},
    {sipName_insert, meth_QPolygonF_insert, METH_VARARGS, doc_QPolygonF_insert},
    {sipName_intersected, meth_QPolygonF_intersected, METH_VARARGS, doc_QPolygonF_intersected},
    {sipName_intersects, meth_QPolygonF_intersects, METH_VARARGS, doc_QPolygonF_intersects},
    {sipName_isClosed, meth_QPolygonF_isClosed, METH_VARARGS, doc_QPolygonF_isClosed},
    {sipName_isEmpty, meth_QPolygonF_isEmpty, METH_VARARGS, doc_QPolygonF_isEmpty},
    {sipName_last, meth_QPolygonF_last, METH_VARARGS, doc_QPolygonF_last},
    {sipName_lastIndexOf, SIP_MLMETH_CAST(meth_QPolygonF_lastIndexOf), METH_VARARGS|METH_KEYWORDS, doc_QPolygonF_lastIndexOf},
    {sipName_mid, SIP_MLMETH_CAST(meth_QPolygonF_mid), METH_VARARGS|METH_KEYWORDS, doc_QPolygonF_mid},
    {sipName_prepend, meth_QPolygonF_prepend, METH_VARARGS, doc_QPolygonF_prepend},
    {sipName_remove, meth_QPolygonF_remove, METH_VARARGS, doc_QPolygonF_remove},
    {sipName_replace, meth_QPolygonF_replace, METH_VARARGS, doc_QPolygonF_replace},
    {sipName_size, meth_QPolygonF_size, METH_VARARGS, doc_QPolygonF_size},
    {sipName_subtracted, meth_QPolygonF_subtracted, METH_VARARGS, doc_QPolygonF_subtracted},
    {sipName_swap, meth_QPolygonF_swap, METH_VARARGS, doc_QPolygonF_swap},
    {sipName_toPolygon, meth_QPolygonF_toPolygon, METH_VARARGS, doc_QPolygonF_toPolygon},
    {sipName_translate, meth_QPolygonF_translate, METH_VARARGS, doc_QPolygonF_translate},
    {sipName_translated, meth_QPolygonF_translated, METH_VARARGS, doc_QPolygonF_translated},
    {sipName_united, meth_QPolygonF_united, METH_VARARGS, doc_QPolygonF_united},
    {sipName_value, meth_QPolygonF_value, METH_VARARGS, doc_QPolygonF_value}
};

PyDoc_STRVAR(doc_QPolygonF, "\1QPolygonF()\n"
"QPolygonF(a: QPolygonF)\n"
"QPolygonF(v: Iterable[Union[QPointF, QPoint]])\n"
"QPolygonF(r: QRectF)\n"
"QPolygonF(a: QPolygon)\n"
"QPolygonF(asize: int)");


static pyqt5ClassPluginDef plugin_QPolygonF = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtGui_QPolygonF = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QPolygonF,
        SIP_NULLPTR,
        &plugin_QPolygonF,
    },
    {
        sipNameNr_QPolygonF,
        {0, 0, 1},
        30, methods_QPolygonF,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QPolygonF,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QPolygonF,
    init_type_QPolygonF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QPolygonF,
    assign_QPolygonF,
    array_QPolygonF,
    copy_QPolygonF,
    release_QPolygonF,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QPolygonF,
    sizeof (::QPolygonF),
};
