(function() {
    var type_impls = Object.fromEntries([["kernel",[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Box%3CMaybeUninit%3CT%3E,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#177-205\">Source</a><a href=\"#impl-Box%3CMaybeUninit%3CT%3E,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.assume_init\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#189-196\">Source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.assume_init\" class=\"fn\">assume_init</a>(self) -&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h4></section></summary><div class=\"docblock\"><p>Converts a <code>Box&lt;MaybeUninit&lt;T&gt;, A&gt;</code> to a <code>Box&lt;T, A&gt;</code>.</p>\n<p>It is undefined behavior to call this function while the value inside of <code>b</code> is not yet\nfully initialized.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>Callers must ensure that the value inside of <code>b</code> is in an initialized state.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#199-204\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.write\" class=\"fn\">write</a>(self, value: T) -&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h4></section></summary><div class=\"docblock\"><p>Writes the value and converts to <code>Box&lt;T, A&gt;</code>.</p>\n</div></details></div></details>",0,"kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#123-175\">Source</a><a href=\"#impl-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_raw\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#138-142\">Source</a><h4 class=\"code-header\">pub const unsafe fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.from_raw\" class=\"fn\">from_raw</a>(raw: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Creates a new <code>Box&lt;T, A&gt;</code> from a raw pointer.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<p>For non-ZSTs, <code>raw</code> must point at an allocation allocated with <code>A</code> that is sufficiently\naligned for and holds a valid <code>T</code>. The caller passes ownership of the allocation to the\n<code>Box</code>.</p>\n<p>For ZSTs, <code>raw</code> must be a dangling, well aligned pointer.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_raw\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#162-164\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.into_raw\" class=\"fn\">into_raw</a>(b: Self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Consumes the <code>Box&lt;T, A&gt;</code> and returns a raw pointer.</p>\n<p>This will not run the destructor of <code>T</code> and for non-ZSTs the allocation will stay alive\nindefinitely. Use <a href=\"kernel/alloc/kbox/struct.Box.html#method.from_raw\" title=\"associated function kernel::alloc::kbox::Box::from_raw\"><code>Box::from_raw</code></a> to recover the <a href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\"><code>Box</code></a>, drop the value and free the\nallocation, if any.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>x = KBox::new(<span class=\"number\">24</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>ptr = KBox::into_raw(x);\n<span class=\"comment\">// SAFETY: `ptr` comes from a previous call to `KBox::into_raw`.\n</span><span class=\"kw\">let </span>x = <span class=\"kw\">unsafe </span>{ KBox::from_raw(ptr) };\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>x, <span class=\"number\">24</span>);</code></pre></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.leak\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#170-174\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.leak\" class=\"fn\">leak</a>&lt;'a&gt;(b: Self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a mut T</a></h4></section></summary><div class=\"docblock\"><p>Consumes and leaks the <code>Box&lt;T, A&gt;</code> and returns a mutable reference.</p>\n<p>See <a href=\"kernel/alloc/kbox/struct.Box.html#method.into_raw\" title=\"associated function kernel::alloc::kbox::Box::into_raw\"><code>Box::into_raw</code></a> for more details.</p>\n</div></details></div></details>",0,"kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#207-297\">Source</a><a href=\"#impl-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#215-218\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.new\" class=\"fn\">new</a>(x: T, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Creates a new <code>Box&lt;T, A&gt;</code> and initializes its contents with <code>x</code>.</p>\n<p>New memory is allocated with <code>A</code>. The allocation may fail, in which case an error is\nreturned. For ZSTs no memory is allocated.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.new_uninit\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#234-241\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.new_uninit\" class=\"fn\">new_uninit</a>(flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;, A&gt;, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Creates a new <code>Box&lt;T, A&gt;</code> with uninitialized contents.</p>\n<p>New memory is allocated with <code>A</code>. The allocation may fail, in which case an error is\nreturned. For ZSTs no memory is allocated.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>b = KBox::&lt;u64&gt;::new_uninit(GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>b = KBox::write(b, <span class=\"number\">24</span>);\n\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>b, <span class=\"number\">24_u64</span>);</code></pre></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.pin\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#246-251\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.pin\" class=\"fn\">pin</a>(x: T, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;&gt;, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;<div class=\"where\">where\n    A: 'static,</div></h4></section></summary><div class=\"docblock\"><p>Constructs a new <code>Pin&lt;Box&lt;T, A&gt;&gt;</code>. If <code>T</code> does not implement <a href=\"core/marker/trait.Unpin.html\" title=\"trait core::marker::Unpin\"><code>Unpin</code></a>, then <code>x</code> will be\npinned in memory and can’t be moved.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_pin\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#255-257\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.into_pin\" class=\"fn\">into_pin</a>(this: Self) -&gt; <a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;Self&gt;</h4></section></summary><div class=\"docblock\"><p>Convert a <a href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\"><code>Box&lt;T,A&gt;</code></a> to a <a href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\"><code>Pin&lt;Box&lt;T,A&gt;&gt;</code></a>. If <code>T</code> does not implement\n<a href=\"core/marker/trait.Unpin.html\" title=\"trait core::marker::Unpin\"><code>Unpin</code></a>, then <code>x</code> will be pinned in memory and can’t be moved.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop_contents\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#280-288\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.drop_contents\" class=\"fn\">drop_contents</a>(this: Self) -&gt; <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;, A&gt;</h4></section></summary><div class=\"docblock\"><p>Drops the contents, but keeps the allocation.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>value = KBox::new([<span class=\"number\">0</span>; <span class=\"number\">32</span>], GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>value, [<span class=\"number\">0</span>; <span class=\"number\">32</span>]);\n<span class=\"kw\">let </span>value = KBox::drop_contents(value);\n<span class=\"comment\">// Now we can re-use `value`:\n</span><span class=\"kw\">let </span>value = KBox::write(value, [<span class=\"number\">1</span>; <span class=\"number\">32</span>]);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">*</span>value, [<span class=\"number\">1</span>; <span class=\"number\">32</span>]);</code></pre></div>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_inner\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#291-296\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kbox/struct.Box.html#tymethod.into_inner\" class=\"fn\">into_inner</a>(b: Self) -&gt; T</h4></section></summary><div class=\"docblock\"><p>Moves the <code>Box</code>’s value out of the <code>Box</code> and consumes the <code>Box</code>.</p>\n</div></details></div></details>",0,"kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#472-480\">Source</a><a href=\"#impl-Debug-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/fmt/trait.Debug.html\" title=\"trait core::fmt::Debug\">Debug</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#477-479\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Deref-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#436-448\">Source</a><a href=\"#impl-Deref-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/deref/trait.Deref.html\" title=\"trait core::ops::deref::Deref\">Deref</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Target\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#441\">Source</a><a href=\"#associatedtype.Target\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/deref/trait.Deref.html#associatedtype.Target\" class=\"associatedtype\">Target</a> = T</h4></section></summary><div class='docblock'>The resulting type after dereferencing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#443-447\">Source</a><a href=\"#method.deref\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/deref/trait.Deref.html#tymethod.deref\" class=\"fn\">deref</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;T</a></h4></section></summary><div class='docblock'>Dereferences the value.</div></details></div></details>","Deref","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DerefMut-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#450-460\">Source</a><a href=\"#impl-DerefMut-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/deref/trait.DerefMut.html\" title=\"trait core::ops::deref::DerefMut\">DerefMut</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#455-459\">Source</a><a href=\"#method.deref_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/deref/trait.DerefMut.html#tymethod.deref_mut\" class=\"fn\">deref_mut</a>(&amp;mut self) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut T</a></h4></section></summary><div class='docblock'>Mutably dereferences the value.</div></details></div></details>","DerefMut","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Display-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#462-470\">Source</a><a href=\"#impl-Display-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/fmt/trait.Display.html\" title=\"trait core::fmt::Display\">Display</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a> + <a class=\"trait\" href=\"core/fmt/trait.Display.html\" title=\"trait core::fmt::Display\">Display</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#467-469\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/fmt/trait.Display.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"core/fmt/struct.Formatter.html\" title=\"struct core::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"core/fmt/type.Result.html\" title=\"type core::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"core/fmt/trait.Display.html#tymethod.fmt\">Read more</a></div></details></div></details>","Display","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Drop-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#482-498\">Source</a><a href=\"#impl-Drop-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/drop/trait.Drop.html\" title=\"trait core::ops::drop::Drop\">Drop</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#487-497\">Source</a><a href=\"#method.drop\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/drop/trait.Drop.html#tymethod.drop\" class=\"fn\">drop</a>(&amp;mut self)</h4></section></summary><div class='docblock'>Executes the destructor for this type. <a href=\"core/ops/drop/trait.Drop.html#tymethod.drop\">Read more</a></div></details></div></details>","Drop","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-ForeignOwnable-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#363-392\">Source</a><a href=\"#impl-ForeignOwnable-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: 'static, A&gt; <a class=\"trait\" href=\"kernel/types/trait.ForeignOwnable.html\" title=\"trait kernel::types::ForeignOwnable\">ForeignOwnable</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Borrowed\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#367\">Source</a><a href=\"#associatedtype.Borrowed\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"kernel/types/trait.ForeignOwnable.html#associatedtype.Borrowed\" class=\"associatedtype\">Borrowed</a>&lt;'a&gt; = <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a T</a></h4></section></summary><div class='docblock'>Type used to immutably borrow a value that is currently foreign-owned.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.BorrowedMut\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#368\">Source</a><a href=\"#associatedtype.BorrowedMut\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"kernel/types/trait.ForeignOwnable.html#associatedtype.BorrowedMut\" class=\"associatedtype\">BorrowedMut</a>&lt;'a&gt; = <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a mut T</a></h4></section></summary><div class='docblock'>Type used to mutably borrow a value that is currently foreign-owned.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_foreign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#370-372\">Source</a><a href=\"#method.into_foreign\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.into_foreign\" class=\"fn\">into_foreign</a>(self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"core/ffi/enum.c_void.html\" title=\"enum core::ffi::c_void\">c_void</a></h4></section></summary><div class='docblock'>Converts a Rust-owned object to a foreign-owned one. <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.into_foreign\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_foreign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#374-378\">Source</a><a href=\"#method.from_foreign\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.from_foreign\" class=\"fn\">from_foreign</a>(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"core/ffi/enum.c_void.html\" title=\"enum core::ffi::c_void\">c_void</a>) -&gt; Self</h4></section></summary><div class='docblock'>Converts a foreign-owned object back to a Rust-owned one. <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.from_foreign\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#380-384\">Source</a><a href=\"#method.borrow\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.borrow\" class=\"fn\">borrow</a>&lt;'a&gt;(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"core/ffi/enum.c_void.html\" title=\"enum core::ffi::c_void\">c_void</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a T</a></h4></section></summary><div class='docblock'>Borrows a foreign-owned object immutably. <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.borrow\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#386-391\">Source</a><a href=\"#method.borrow_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.borrow_mut\" class=\"fn\">borrow_mut</a>&lt;'a&gt;(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"core/ffi/enum.c_void.html\" title=\"enum core::ffi::c_void\">c_void</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;'a mut T</a></h4></section></summary><div class='docblock'>Borrows a foreign-owned object mutably. <a href=\"kernel/types/trait.ForeignOwnable.html#tymethod.borrow_mut\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_from_foreign\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/types.rs.html#61-69\">Source</a><a href=\"#method.try_from_foreign\" class=\"anchor\">§</a><h4 class=\"code-header\">unsafe fn <a href=\"kernel/types/trait.ForeignOwnable.html#method.try_from_foreign\" class=\"fn\">try_from_foreign</a>(ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut </a><a class=\"enum\" href=\"core/ffi/enum.c_void.html\" title=\"enum core::ffi::c_void\">c_void</a>) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;Self&gt;</h4></section></summary><div class='docblock'>Tries to convert a foreign-owned object back to a Rust-owned one. <a href=\"kernel/types/trait.ForeignOwnable.html#method.try_from_foreign\">Read more</a></div></details></div></details>","ForeignOwnable","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-InPlaceInit%3CT%3E-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#340-361\">Source</a><a href=\"#impl-InPlaceInit%3CT%3E-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"kernel/init/trait.InPlaceInit.html\" title=\"trait kernel::init::InPlaceInit\">InPlaceInit</a>&lt;T&gt; for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a> + 'static,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.PinnedSelf\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#344\">Source</a><a href=\"#associatedtype.PinnedSelf\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"kernel/init/trait.InPlaceInit.html#associatedtype.PinnedSelf\" class=\"associatedtype\">PinnedSelf</a> = <a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;&gt;</h4></section></summary><div class='docblock'>Pinned version of <code>Self</code>. <a href=\"kernel/init/trait.InPlaceInit.html#associatedtype.PinnedSelf\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_pin_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#347-352\">Source</a><a href=\"#method.try_pin_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/init/trait.InPlaceInit.html#tymethod.try_pin_init\" class=\"fn\">try_pin_init</a>&lt;E&gt;(\n    init: impl <a class=\"trait\" href=\"kernel/prelude/trait.PinInit.html\" title=\"trait kernel::prelude::PinInit\">PinInit</a>&lt;T, E&gt;,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;Self&gt;, E&gt;<div class=\"where\">where\n    E: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;,</div></h4></section></summary><div class='docblock'>Use the given pin-initializer to pin-initialize a <code>T</code> inside of a new smart pointer of this\ntype. <a href=\"kernel/init/trait.InPlaceInit.html#tymethod.try_pin_init\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.try_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#355-360\">Source</a><a href=\"#method.try_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/init/trait.InPlaceInit.html#tymethod.try_init\" class=\"fn\">try_init</a>&lt;E&gt;(init: impl <a class=\"trait\" href=\"kernel/prelude/trait.Init.html\" title=\"trait kernel::prelude::Init\">Init</a>&lt;T, E&gt;, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, E&gt;<div class=\"where\">where\n    E: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;,</div></h4></section></summary><div class='docblock'>Use the given initializer to in-place initialize a <code>T</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.pin_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/init.rs.html#163-172\">Source</a><a href=\"#method.pin_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/init/trait.InPlaceInit.html#method.pin_init\" class=\"fn\">pin_init</a>&lt;E&gt;(\n    init: impl <a class=\"trait\" href=\"kernel/prelude/trait.PinInit.html\" title=\"trait kernel::prelude::PinInit\">PinInit</a>&lt;T, E&gt;,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"type\" href=\"kernel/error/type.Result.html\" title=\"type kernel::error::Result\">Result</a>&lt;Self::<a class=\"associatedtype\" href=\"kernel/init/trait.InPlaceInit.html#associatedtype.PinnedSelf\" title=\"type kernel::init::InPlaceInit::PinnedSelf\">PinnedSelf</a>&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"kernel/error/struct.Error.html\" title=\"struct kernel::error::Error\">Error</a>: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;E&gt;,</div></h4></section></summary><div class='docblock'>Use the given pin-initializer to pin-initialize a <code>T</code> inside of a new smart pointer of this\ntype. <a href=\"kernel/init/trait.InPlaceInit.html#method.pin_init\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/init.rs.html#180-189\">Source</a><a href=\"#method.init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/init/trait.InPlaceInit.html#method.init\" class=\"fn\">init</a>&lt;E&gt;(init: impl <a class=\"trait\" href=\"kernel/prelude/trait.Init.html\" title=\"trait kernel::prelude::Init\">Init</a>&lt;T, E&gt;, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"type\" href=\"kernel/error/type.Result.html\" title=\"type kernel::error::Result\">Result</a>&lt;Self&gt;<div class=\"where\">where\n    <a class=\"struct\" href=\"kernel/error/struct.Error.html\" title=\"struct kernel::error::Error\">Error</a>: <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;E&gt;,</div></h4></section></summary><div class='docblock'>Use the given initializer to in-place initialize a <code>T</code>.</div></details></div></details>","InPlaceInit<T>","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-InPlaceWrite%3CT%3E-for-Box%3CMaybeUninit%3CT%3E,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#315-338\">Source</a><a href=\"#impl-InPlaceWrite%3CT%3E-for-Box%3CMaybeUninit%3CT%3E,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"kernel/prelude/trait.InPlaceWrite.html\" title=\"trait kernel::prelude::InPlaceWrite\">InPlaceWrite</a>&lt;T&gt; for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a> + 'static,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Initialized\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#319\">Source</a><a href=\"#associatedtype.Initialized\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"kernel/prelude/trait.InPlaceWrite.html#associatedtype.Initialized\" class=\"associatedtype\">Initialized</a> = <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h4></section></summary><div class='docblock'>The type <code>Self</code> turns into when the contents are initialized.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#321-328\">Source</a><a href=\"#method.write_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/prelude/trait.InPlaceWrite.html#tymethod.write_init\" class=\"fn\">write_init</a>&lt;E&gt;(self, init: impl <a class=\"trait\" href=\"kernel/prelude/trait.Init.html\" title=\"trait kernel::prelude::Init\">Init</a>&lt;T, E&gt;) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self::<a class=\"associatedtype\" href=\"kernel/prelude/trait.InPlaceWrite.html#associatedtype.Initialized\" title=\"type kernel::prelude::InPlaceWrite::Initialized\">Initialized</a>, E&gt;</h4></section></summary><div class='docblock'>Use the given initializer to write a value into <code>self</code>. <a href=\"kernel/prelude/trait.InPlaceWrite.html#tymethod.write_init\">Read more</a></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.write_pin_init\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#330-337\">Source</a><a href=\"#method.write_pin_init\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/prelude/trait.InPlaceWrite.html#tymethod.write_pin_init\" class=\"fn\">write_pin_init</a>&lt;E&gt;(\n    self,\n    init: impl <a class=\"trait\" href=\"kernel/prelude/trait.PinInit.html\" title=\"trait kernel::prelude::PinInit\">PinInit</a>&lt;T, E&gt;,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"struct\" href=\"core/pin/struct.Pin.html\" title=\"struct core::pin::Pin\">Pin</a>&lt;Self::<a class=\"associatedtype\" href=\"kernel/prelude/trait.InPlaceWrite.html#associatedtype.Initialized\" title=\"type kernel::prelude::InPlaceWrite::Initialized\">Initialized</a>&gt;, E&gt;</h4></section></summary><div class='docblock'>Use the given pin-initializer to write a value into <code>self</code>. <a href=\"kernel/prelude/trait.InPlaceWrite.html#tymethod.write_pin_init\">Read more</a></div></details></div></details>","InPlaceWrite<T>","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<section id=\"impl-Send-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#108-113\">Source</a><a href=\"#impl-Send-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a> + ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section>","Send","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<section id=\"impl-Sync-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#116-121\">Source</a><a href=\"#impl-Sync-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> + ?<a class=\"trait\" href=\"core/marker/trait.Sized.html\" title=\"trait core::marker::Sized\">Sized</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section>","Sync","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"],["<section id=\"impl-ZeroableOption-for-Box%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kbox.rs.html#105\">Source</a><a href=\"#impl-ZeroableOption-for-Box%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"pin_init/trait.ZeroableOption.html\" title=\"trait pin_init::ZeroableOption\">ZeroableOption</a> for <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;T, A&gt;</h3></section>","ZeroableOption","kernel::alloc::kbox::KBox","kernel::alloc::kbox::VBox","kernel::alloc::kbox::KVBox"]]]]);
    if (window.register_type_impls) {
        window.register_type_impls(type_impls);
    } else {
        window.pending_type_impls = type_impls;
    }
})()
//{"start":55,"fragment_lengths":[43124]}