
/* Automatically generated struct definitions for the Data API.
 * Do not edit manually, changes will be overwritten.           */

#define RNA_RUNTIME

#include <float.h>
#include <stdio.h>
#include <limits.h>
#include <limits>
#include <string.h>

#include <stddef.h>

#include <algorithm>

#include "MEM_guardedalloc.h"

#include "DNA_ID.h"
#include "DNA_scene_types.h"
#include "DNA_node_types.h"
#include "BLI_fileops.h"

#include "BLI_listbase.h"

#include "BLI_path_utils.hh"

#include "BLI_rect.h"

#include "BLI_string.h"

#include "BLI_string_utf8.h"

#include "BLI_utildefines.h"

#include "BKE_context.hh"
#include "BKE_lib_id.hh"
#include "BKE_main.hh"
#include "BKE_report.hh"
#include "RNA_define.hh"
#include "RNA_types.hh"
#include "rna_internal.hh"

#include "rna_prototypes_gen.hh"

#include "rna_lattice.cc"
#include "rna_lattice_api.cc"

#pragma GCC diagnostic ignored "-Wunused-parameter"

/* Auto-generated Functions. */


extern PropertyRNA &rna_ID_rna_properties;
extern PropertyRNA &rna_ID_rna_type;
extern PropertyRNA &rna_ID_name;
extern PropertyRNA &rna_ID_name_full;
extern PropertyRNA &rna_ID_id_type;
extern PropertyRNA &rna_ID_session_uid;
extern PropertyRNA &rna_ID_is_evaluated;
extern PropertyRNA &rna_ID_original;
extern PropertyRNA &rna_ID_users;
extern PropertyRNA &rna_ID_use_fake_user;
extern PropertyRNA &rna_ID_use_extra_user;
extern PropertyRNA &rna_ID_is_embedded_data;
extern PropertyRNA &rna_ID_is_missing;
extern PropertyRNA &rna_ID_is_runtime_data;
extern PropertyRNA &rna_ID_is_editable;
extern PropertyRNA &rna_ID_tag;
extern PropertyRNA &rna_ID_is_library_indirect;
extern PropertyRNA &rna_ID_library;
extern PropertyRNA &rna_ID_library_weak_reference;
extern PropertyRNA &rna_ID_asset_data;
extern PropertyRNA &rna_ID_override_library;
extern PropertyRNA &rna_ID_preview;

extern PropertyRNA &rna_Lattice_points_u;
extern PropertyRNA &rna_Lattice_points_v;
extern PropertyRNA &rna_Lattice_points_w;
extern PropertyRNA &rna_Lattice_interpolation_type_u;
extern PropertyRNA &rna_Lattice_interpolation_type_v;
extern PropertyRNA &rna_Lattice_interpolation_type_w;
extern PropertyRNA &rna_Lattice_use_outside;
extern PropertyRNA &rna_Lattice_vertex_group;
extern PropertyRNA &rna_Lattice_shape_keys;
extern PropertyRNA &rna_Lattice_points;
extern PropertyRNA &rna_Lattice_is_editmode;
extern PropertyRNA &rna_Lattice_animation_data;

extern FunctionRNA rna_ID_rename_func;
extern PropertyRNA &rna_ID_rename_name;
extern PropertyRNA &rna_ID_rename_mode;
extern PropertyRNA &rna_ID_rename_id_rename_result;

extern FunctionRNA rna_ID_evaluated_get_func;
extern PropertyRNA &rna_ID_evaluated_get_depsgraph;
extern PropertyRNA &rna_ID_evaluated_get_id;

extern FunctionRNA rna_ID_copy_func;
extern PropertyRNA &rna_ID_copy_id;

extern FunctionRNA rna_ID_asset_mark_func;
extern FunctionRNA rna_ID_asset_clear_func;
extern FunctionRNA rna_ID_asset_generate_preview_func;
extern FunctionRNA rna_ID_override_create_func;
extern PropertyRNA &rna_ID_override_create_id;
extern PropertyRNA &rna_ID_override_create_remap_local_usages;

extern FunctionRNA rna_ID_override_hierarchy_create_func;
extern PropertyRNA &rna_ID_override_hierarchy_create_id;
extern PropertyRNA &rna_ID_override_hierarchy_create_scene;
extern PropertyRNA &rna_ID_override_hierarchy_create_view_layer;
extern PropertyRNA &rna_ID_override_hierarchy_create_reference;
extern PropertyRNA &rna_ID_override_hierarchy_create_do_fully_editable;

extern FunctionRNA rna_ID_user_clear_func;
extern FunctionRNA rna_ID_user_remap_func;
extern PropertyRNA &rna_ID_user_remap_new_id;

extern FunctionRNA rna_ID_make_local_func;
extern PropertyRNA &rna_ID_make_local_clear_proxy;
extern PropertyRNA &rna_ID_make_local_clear_liboverride;
extern PropertyRNA &rna_ID_make_local_clear_asset_data;
extern PropertyRNA &rna_ID_make_local_id;

extern FunctionRNA rna_ID_user_of_id_func;
extern PropertyRNA &rna_ID_user_of_id_id;
extern PropertyRNA &rna_ID_user_of_id_count;

extern FunctionRNA rna_ID_animation_data_create_func;
extern PropertyRNA &rna_ID_animation_data_create_anim_data;

extern FunctionRNA rna_ID_animation_data_clear_func;
extern FunctionRNA rna_ID_update_tag_func;
extern PropertyRNA &rna_ID_update_tag_refresh;

extern FunctionRNA rna_ID_preview_ensure_func;
extern PropertyRNA &rna_ID_preview_ensure_preview_image;


extern FunctionRNA rna_Lattice_transform_func;
extern PropertyRNA &rna_Lattice_transform_matrix;
extern PropertyRNA &rna_Lattice_transform_shape_keys;

extern FunctionRNA rna_Lattice_update_gpu_tag_func;


extern PropertyRNA &rna_LatticePoint_rna_properties;
extern PropertyRNA &rna_LatticePoint_rna_type;
extern PropertyRNA &rna_LatticePoint_select;
extern PropertyRNA &rna_LatticePoint_co;
extern PropertyRNA &rna_LatticePoint_co_deform;
extern PropertyRNA &rna_LatticePoint_weight_softbody;
extern PropertyRNA &rna_LatticePoint_groups;

extern int Lattice_points_u_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return (int)(data->pntsu);
}

extern void Lattice_points_u_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_Lattice_points_u_set;
    fn(ptr, value);
}

extern int Lattice_points_v_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return (int)(data->pntsv);
}

extern void Lattice_points_v_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_Lattice_points_v_set;
    fn(ptr, value);
}

extern int Lattice_points_w_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return (int)(data->pntsw);
}

extern void Lattice_points_w_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_Lattice_points_w_set;
    fn(ptr, value);
}

extern int Lattice_interpolation_type_u_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return (int)(data->typeu);
}

extern void Lattice_interpolation_type_u_set(PointerRNA *ptr, int value)
{
    Lattice *data = (Lattice *)(ptr->data);
#ifdef __cplusplus
    data->typeu = (std::remove_reference_t<decltype(data->typeu)>)value;
#else
    data->typeu = value;
#endif
}

extern int Lattice_interpolation_type_v_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return (int)(data->typev);
}

extern void Lattice_interpolation_type_v_set(PointerRNA *ptr, int value)
{
    Lattice *data = (Lattice *)(ptr->data);
#ifdef __cplusplus
    data->typev = (std::remove_reference_t<decltype(data->typev)>)value;
#else
    data->typev = value;
#endif
}

extern int Lattice_interpolation_type_w_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return (int)(data->typew);
}

extern void Lattice_interpolation_type_w_set(PointerRNA *ptr, int value)
{
    Lattice *data = (Lattice *)(ptr->data);
#ifdef __cplusplus
    data->typew = (std::remove_reference_t<decltype(data->typew)>)value;
#else
    data->typew = value;
#endif
}

extern bool Lattice_use_outside_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return (((data->flag) & 2) != 0);
}

extern void Lattice_use_outside_set(PointerRNA *ptr, bool value)
{
    PropBooleanSetFunc fn = rna_Lattice_use_outside_set;
    fn(ptr, value);
}

extern void Lattice_vertex_group_get(PointerRNA *ptr, char *value)
{
    Lattice *data = (Lattice *)(ptr->data);
    strcpy(value, data->vgroup);
}

extern int Lattice_vertex_group_length(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return strlen(data->vgroup);
}

extern void Lattice_vertex_group_set(PointerRNA *ptr, const char *value)
{
    PropStringSetFunc fn = rna_Lattice_vg_name_set;
    fn(ptr, value);
}

extern PointerRNA Lattice_shape_keys_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_Key, data->key);
}

static PointerRNA Lattice_points_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_LatticePoint, rna_iterator_array_get(iter));
}

extern void Lattice_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_Lattice_points;

    PropCollectionBeginFunc fn = rna_Lattice_points_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = Lattice_points_get(iter);
    }
}

extern void Lattice_points_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_array_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = Lattice_points_get(iter);
    }
}

extern void Lattice_points_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_array_end;
    fn(iter);
}

extern bool Lattice_is_editmode_get(PointerRNA *ptr)
{
    PropBooleanGetFunc fn = rna_Lattice_is_editmode_get;
    return fn(ptr);
}

extern PointerRNA Lattice_animation_data_get(PointerRNA *ptr)
{
    Lattice *data = (Lattice *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_AnimData, data->adt);
}

static PointerRNA LatticePoint_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void LatticePoint_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_LatticePoint_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = LatticePoint_rna_properties_get(iter);
    }
}

extern void LatticePoint_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = LatticePoint_rna_properties_get(iter);
    }
}

extern void LatticePoint_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool LatticePoint_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA LatticePoint_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern bool LatticePoint_select_get(PointerRNA *ptr)
{
    BPoint *data = (BPoint *)(ptr->data);
    return (((data->f1) & 1) != 0);
}

extern void LatticePoint_select_set(PointerRNA *ptr, bool value)
{
    BPoint *data = (BPoint *)(ptr->data);
    if (value) { data->f1 |= 1; }
    else { data->f1 &= ~1; }
}

extern void LatticePoint_co_get(PointerRNA *ptr, float values[3])
{
    PropFloatArrayGetFunc fn = rna_LatticePoint_co_get;
    fn(ptr, values);
}

extern void LatticePoint_co_deform_get(PointerRNA *ptr, float values[3])
{
    BPoint *data = (BPoint *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->vec)[i]);
    }
}

extern void LatticePoint_co_deform_set(PointerRNA *ptr, const float values[3])
{
    BPoint *data = (BPoint *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->vec)[i] = values[i];
    }
}

extern float LatticePoint_weight_softbody_get(PointerRNA *ptr)
{
    BPoint *data = (BPoint *)(ptr->data);
    return (float)(data->weight);
}

extern void LatticePoint_weight_softbody_set(PointerRNA *ptr, float value)
{
    BPoint *data = (BPoint *)(ptr->data);
#ifdef __cplusplus
    data->weight = (std::remove_reference_t<decltype(data->weight)>)std::clamp(value, 0.0099999998f, 100.0f);
#else
    data->weight = std::clamp(value, 0.0099999998f, 100.0f);
#endif
}

static PointerRNA LatticePoint_groups_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_VertexGroupElement, rna_iterator_array_get(iter));
}

extern void LatticePoint_groups_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_LatticePoint_groups;

    PropCollectionBeginFunc fn = rna_LatticePoint_groups_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = LatticePoint_groups_get(iter);
    }
}

extern void LatticePoint_groups_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_array_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = LatticePoint_groups_get(iter);
    }
}

extern void LatticePoint_groups_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_array_end;
    fn(iter);
}

extern void Lattice_transform_func(struct Lattice *_self, float matrix[16], bool shape_keys)
{
	rna_Lattice_transform(_self, matrix, shape_keys);
}

static void Lattice_transform_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct Lattice *_self;
	const float *matrix;
	bool shape_keys;
	char *_data;
	
	_self = (struct Lattice *)_ptr->data;
	_data = (char *)_parms->data;
	matrix = ((const float *)_data);
	_data += 64;
	shape_keys = *((bool *)_data);
	
	rna_Lattice_transform(_self, matrix, shape_keys);
}

extern void Lattice_update_gpu_tag_func(struct Lattice *_self)
{
	rna_Lattice_update_gpu_tag(_self);
}

static void Lattice_update_gpu_tag_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct Lattice *_self;
	_self = (struct Lattice *)_ptr->data;
	
	rna_Lattice_update_gpu_tag(_self);
}

/* Repeated prototypes to detect errors */

void rna_Lattice_transform(struct Lattice *_self, float matrix[16], bool shape_keys);
void rna_Lattice_update_gpu_tag(struct Lattice *_self);


/* Lattice */
static IntPropertyRNA rna_Lattice_points_u_ = {
	{&rna_Lattice_points_v, nullptr,
	-1, "points_u", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "U",
	"Points in U direction (cannot be changed when there are shape keys)",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Lattice_update_size, 0, rna_Lattice_size_editable, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_points_u_get, Lattice_points_u_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 64, 1, 64, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Lattice_points_u = reinterpret_cast<PropertyRNA &>(rna_Lattice_points_u_);

static IntPropertyRNA rna_Lattice_points_v_ = {
	{&rna_Lattice_points_w, &rna_Lattice_points_u,
	-1, "points_v", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "V",
	"Points in V direction (cannot be changed when there are shape keys)",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Lattice_update_size, 0, rna_Lattice_size_editable, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_points_v_get, Lattice_points_v_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 64, 1, 64, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Lattice_points_v = reinterpret_cast<PropertyRNA &>(rna_Lattice_points_v_);

static IntPropertyRNA rna_Lattice_points_w_ = {
	{&rna_Lattice_interpolation_type_u, &rna_Lattice_points_v,
	-1, "points_w", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "W",
	"Points in W direction (cannot be changed when there are shape keys)",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Lattice_update_size, 0, rna_Lattice_size_editable, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_points_w_get, Lattice_points_w_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 64, 1, 64, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Lattice_points_w = reinterpret_cast<PropertyRNA &>(rna_Lattice_points_w_);

static const EnumPropertyItem rna_Lattice_interpolation_type_u_items[5] = {
	{0, "KEY_LINEAR", 0, "Linear", ""},
	{1, "KEY_CARDINAL", 0, "Cardinal", ""},
	{3, "KEY_CATMULL_ROM", 0, "Catmull-Rom", ""},
	{2, "KEY_BSPLINE", 0, "BSpline", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_Lattice_interpolation_type_u_ = {
	{&rna_Lattice_interpolation_type_v, &rna_Lattice_points_w,
	-1, "interpolation_type_u", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Interpolation Type U",
	"",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Lattice_update_data_editlatt, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Lattice, typeu), RawPropertyType(2), nullptr},
	Lattice_interpolation_type_u_get, Lattice_interpolation_type_u_set, nullptr, nullptr, nullptr, nullptr, rna_Lattice_interpolation_type_u_items, 4, 2
};
PropertyRNA &rna_Lattice_interpolation_type_u = reinterpret_cast<PropertyRNA &>(rna_Lattice_interpolation_type_u_);

static const EnumPropertyItem rna_Lattice_interpolation_type_v_items[5] = {
	{0, "KEY_LINEAR", 0, "Linear", ""},
	{1, "KEY_CARDINAL", 0, "Cardinal", ""},
	{3, "KEY_CATMULL_ROM", 0, "Catmull-Rom", ""},
	{2, "KEY_BSPLINE", 0, "BSpline", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_Lattice_interpolation_type_v_ = {
	{&rna_Lattice_interpolation_type_w, &rna_Lattice_interpolation_type_u,
	-1, "interpolation_type_v", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Interpolation Type V",
	"",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Lattice_update_data_editlatt, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Lattice, typev), RawPropertyType(2), nullptr},
	Lattice_interpolation_type_v_get, Lattice_interpolation_type_v_set, nullptr, nullptr, nullptr, nullptr, rna_Lattice_interpolation_type_v_items, 4, 2
};
PropertyRNA &rna_Lattice_interpolation_type_v = reinterpret_cast<PropertyRNA &>(rna_Lattice_interpolation_type_v_);

static const EnumPropertyItem rna_Lattice_interpolation_type_w_items[5] = {
	{0, "KEY_LINEAR", 0, "Linear", ""},
	{1, "KEY_CARDINAL", 0, "Cardinal", ""},
	{3, "KEY_CATMULL_ROM", 0, "Catmull-Rom", ""},
	{2, "KEY_BSPLINE", 0, "BSpline", ""},
	{0, nullptr, 0, nullptr, nullptr}
};

static EnumPropertyRNA rna_Lattice_interpolation_type_w_ = {
	{&rna_Lattice_use_outside, &rna_Lattice_interpolation_type_v,
	-1, "interpolation_type_w", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Interpolation Type W",
	"",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Lattice_update_data_editlatt, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(Lattice, typew), RawPropertyType(2), nullptr},
	Lattice_interpolation_type_w_get, Lattice_interpolation_type_w_set, nullptr, nullptr, nullptr, nullptr, rna_Lattice_interpolation_type_w_items, 4, 2
};
PropertyRNA &rna_Lattice_interpolation_type_w = reinterpret_cast<PropertyRNA &>(rna_Lattice_interpolation_type_w_);

static BoolPropertyRNA rna_Lattice_use_outside_ = {
	{&rna_Lattice_vertex_group, &rna_Lattice_interpolation_type_w,
	-1, "use_outside", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Outside",
	"Only display and take into account the outer vertices",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Lattice_update_data_editlatt, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_use_outside_get, Lattice_use_outside_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Lattice_use_outside = reinterpret_cast<PropertyRNA &>(rna_Lattice_use_outside_);

static StringPropertyRNA rna_Lattice_vertex_group_ = {
	{&rna_Lattice_shape_keys, &rna_Lattice_use_outside,
	-1, "vertex_group", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Vertex Group",
	"Vertex group to apply the influence of the lattice",
	0, "*",
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {64, 0, 0}, 0,
	rna_Lattice_update_data_editlatt, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_vertex_group_get, Lattice_vertex_group_length, Lattice_vertex_group_set, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, ""
};
PropertyRNA &rna_Lattice_vertex_group = reinterpret_cast<PropertyRNA &>(rna_Lattice_vertex_group_);

static PointerPropertyRNA rna_Lattice_shape_keys_ = {
	{&rna_Lattice_points, &rna_Lattice_vertex_group,
	-1, "shape_keys", 8388672, 1, 0, 32, 0, PropertyPathTemplateType(0), "Shape Keys",
	"",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_shape_keys_get, nullptr, nullptr, nullptr,&RNA_Key
};
PropertyRNA &rna_Lattice_shape_keys = reinterpret_cast<PropertyRNA &>(rna_Lattice_shape_keys_);

static CollectionPropertyRNA rna_Lattice_points_ = {
	{&rna_Lattice_is_editmode, &rna_Lattice_shape_keys,
	-1, "points", 0, 0, 0, 8, 0, PropertyPathTemplateType(0), "Points",
	"Points of the lattice",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_points_begin, Lattice_points_next, Lattice_points_end, Lattice_points_get, nullptr, nullptr, nullptr, nullptr, &RNA_LatticePoint
};
PropertyRNA &rna_Lattice_points = reinterpret_cast<PropertyRNA &>(rna_Lattice_points_);

static BoolPropertyRNA rna_Lattice_is_editmode_ = {
	{&rna_Lattice_animation_data, &rna_Lattice_points,
	-1, "is_editmode", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Is Editmode",
	"True when used in editmode",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_is_editmode_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Lattice_is_editmode = reinterpret_cast<PropertyRNA &>(rna_Lattice_is_editmode_);

static PointerPropertyRNA rna_Lattice_animation_data_ = {
	{nullptr, &rna_Lattice_is_editmode,
	-1, "animation_data", 8388608, 1, 0, 0, 0, PropertyPathTemplateType(0), "Animation Data",
	"Animation data for this data-block",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, rna_AnimaData_override_apply,
	0, PROP_RAW_UNSET, nullptr},
	Lattice_animation_data_get, nullptr, nullptr, nullptr,&RNA_AnimData
};
PropertyRNA &rna_Lattice_animation_data = reinterpret_cast<PropertyRNA &>(rna_Lattice_animation_data_);

static float rna_Lattice_transform_matrix_default[16] = {
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_Lattice_transform_matrix_ = {
	{&rna_Lattice_transform_shape_keys, nullptr,
	-1, "matrix", 3, 0, 1, 0, 0, PropertyPathTemplateType(0), "",
	"Matrix",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_MATRIX) | int(PROP_UNIT_NONE)), nullptr, 2, {4, 4, 0}, 16,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 0.0f, -FLT_MAX, FLT_MAX, 1.0f, 3, nullptr, nullptr, 0.0f, rna_Lattice_transform_matrix_default
};
PropertyRNA &rna_Lattice_transform_matrix = reinterpret_cast<PropertyRNA &>(rna_Lattice_transform_matrix_);

static BoolPropertyRNA rna_Lattice_transform_shape_keys_ = {
	{nullptr, &rna_Lattice_transform_matrix,
	-1, "shape_keys", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "",
	"Transform Shape Keys",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_Lattice_transform_shape_keys = reinterpret_cast<PropertyRNA &>(rna_Lattice_transform_shape_keys_);

FunctionRNA rna_Lattice_transform_func = {
	{(FunctionRNA *)&rna_Lattice_update_gpu_tag_func, nullptr,
	nullptr,
	{&rna_Lattice_transform_matrix, &rna_Lattice_transform_shape_keys}},
	"transform", 0, "Transform lattice by a matrix",
	Lattice_transform_call,
	nullptr
};

FunctionRNA rna_Lattice_update_gpu_tag_func = {
	{nullptr, (FunctionRNA *)&rna_Lattice_transform_func,
	nullptr,
	{nullptr, nullptr}},
	"update_gpu_tag", 0, "update_gpu_tag",
	Lattice_update_gpu_tag_call,
	nullptr
};

StructRNA RNA_Lattice = {
	{(ContainerRNA *)&RNA_LatticePoint, (ContainerRNA *)&RNA_SunLight,
	nullptr,
	{&rna_Lattice_points_u, &rna_Lattice_animation_data}},
	"Lattice", nullptr, nullptr, 519, nullptr, "Lattice",
	"Lattice data-block defining a grid for deforming other objects",
	"*", 181,
	&rna_ID_name, &rna_ID_rna_properties,
	&RNA_ID,
	nullptr,
	rna_ID_refine,
	nullptr,
	nullptr,
	nullptr,
	rna_ID_instance,
	rna_ID_idprops,
	{(FunctionRNA *)&rna_Lattice_transform_func, (FunctionRNA *)&rna_Lattice_update_gpu_tag_func}
};

/* LatticePoint */
static CollectionPropertyRNA rna_LatticePoint_rna_properties_ = {
	{&rna_LatticePoint_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	LatticePoint_rna_properties_begin, LatticePoint_rna_properties_next, LatticePoint_rna_properties_end, LatticePoint_rna_properties_get, nullptr, nullptr, LatticePoint_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_LatticePoint_rna_properties = reinterpret_cast<PropertyRNA &>(rna_LatticePoint_rna_properties_);

static PointerPropertyRNA rna_LatticePoint_rna_type_ = {
	{&rna_LatticePoint_select, &rna_LatticePoint_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	LatticePoint_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_LatticePoint_rna_type = reinterpret_cast<PropertyRNA &>(rna_LatticePoint_rna_type_);

static BoolPropertyRNA rna_LatticePoint_select_ = {
	{&rna_LatticePoint_co, &rna_LatticePoint_rna_type,
	-1, "select", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Point selected",
	"Selection status",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	LatticePoint_select_get, LatticePoint_select_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_LatticePoint_select = reinterpret_cast<PropertyRNA &>(rna_LatticePoint_select_);

static float rna_LatticePoint_co_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_LatticePoint_co_ = {
	{&rna_LatticePoint_co_deform, &rna_LatticePoint_select,
	-1, "co", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Location",
	"Original undeformed location used to calculate the strength of the deform effect (edit/animate the Deformed Location instead)",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_TRANSLATION) | int(PROP_UNIT_LENGTH)), nullptr, 1, {3, 0, 0}, 3,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, LatticePoint_co_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -10000.0f, 10000.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_LatticePoint_co_default
};
PropertyRNA &rna_LatticePoint_co = reinterpret_cast<PropertyRNA &>(rna_LatticePoint_co_);

static float rna_LatticePoint_co_deform_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_LatticePoint_co_deform_ = {
	{&rna_LatticePoint_weight_softbody, &rna_LatticePoint_co,
	-1, "co_deform", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Deformed Location",
	"",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_TRANSLATION) | int(PROP_UNIT_LENGTH)), nullptr, 1, {3, 0, 0}, 3,
	rna_Lattice_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(BPoint, vec), RawPropertyType(5), nullptr},
	nullptr, nullptr, LatticePoint_co_deform_get, LatticePoint_co_deform_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -10000.0f, 10000.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_LatticePoint_co_deform_default
};
PropertyRNA &rna_LatticePoint_co_deform = reinterpret_cast<PropertyRNA &>(rna_LatticePoint_co_deform_);

static FloatPropertyRNA rna_LatticePoint_weight_softbody_ = {
	{&rna_LatticePoint_groups, &rna_LatticePoint_co_deform,
	-1, "weight_softbody", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Weight",
	"Softbody goal weight",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_Lattice_update_data, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(BPoint, weight), RawPropertyType(5), nullptr},
	LatticePoint_weight_softbody_get, LatticePoint_weight_softbody_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0099999998f, 100.0f, 0.0099999998f, 100.0f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_LatticePoint_weight_softbody = reinterpret_cast<PropertyRNA &>(rna_LatticePoint_weight_softbody_);

static CollectionPropertyRNA rna_LatticePoint_groups_ = {
	{nullptr, &rna_LatticePoint_weight_softbody,
	-1, "groups", 0, 0, 0, 8, 0, PropertyPathTemplateType(0), "Groups",
	"Weights for the vertex groups this point is member of",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	LatticePoint_groups_begin, LatticePoint_groups_next, LatticePoint_groups_end, LatticePoint_groups_get, nullptr, nullptr, nullptr, nullptr, &RNA_VertexGroupElement
};
PropertyRNA &rna_LatticePoint_groups = reinterpret_cast<PropertyRNA &>(rna_LatticePoint_groups_);

StructRNA RNA_LatticePoint = {
	{(ContainerRNA *)&RNA_ViewLayer, (ContainerRNA *)&RNA_Lattice,
	nullptr,
	{&rna_LatticePoint_rna_properties, &rna_LatticePoint_groups}},
	"LatticePoint", nullptr, nullptr, 516, nullptr, "LatticePoint",
	"Point in the lattice grid",
	"*", 61,
	nullptr, &rna_LatticePoint_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_LatticePoint_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

