\name{ExpandImageFilter}
\alias{ExpandImageFilter}
\title{ExpandImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Expand the size of an image by an integer factor in each dimension.
ExpandImageFilter}
\details{
ExpandImageFilter increases the size of an image by an integer factor in each dimension
using a interpolation method. The output image size in each dimension
is given by:
OutputSize[j] = InputSize[j] * ExpandFactors[j]
The output values are obtained by interpolating the input image. The
default interpolation type used is the LinearInterpolateImageFunction . The user can specify a particular interpolation function via SetInterpolator() . Note that the input interpolator must derive from base class InterpolateImageFunction .
This filter will produce an output with different pixel spacing that
its input image such that:
OutputSpacing[j] = InputSpacing[j] / ExpandFactors[j]
The filter is templated over the input image type and the output image
type.
This filter is implemented as a multithreaded filter and supports
streaming.
This filter assumes that the input and output image has the same
number of dimensions.
See:
InterpolateImageFunction
LinearInterpolationImageFunction
Expand for the procedural interface
itk::ExpandImageFilter for the Doxygen on the original ITK class.
ExpandImageFilter}
%C++ includes: sitkExpandImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ ExpandImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::vector< unsigned int > GetExpandFactors() const:}{
Get the expand factors.
}
\item{InterpolatorEnum GetInterpolator() const:}{
Get/Set the interpolator function.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetExpandFactor(unsigned int e):}{
Custom public declarations
}
\item{Self SetExpandFactors(std::vector< unsigned int > ExpandFactors):}{
Set the expand factors. Values are clamped to a minimum value of 1.
Default is 1 for all dimensions.
}
\item{Self SetExpandFactors(unsigned int value):}{
Set the values of the ExpandFactors vector all to value
}
\item{Self SetInterpolator(InterpolatorEnum Interpolator):}{
Get/Set the interpolator function.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ExpandImageFilter():}{
Destructor
}
}
}
