from cycler import cycler

PLOTHIST = {
    # General Settings
    "figure.figsize": (6, 4),
    "figure.facecolor": "white",
    # "text.color"          : .1,
    # Fonts
    "font.size": 15,
    "xtick.labelsize": 15,
    "ytick.labelsize": 15,
    "axes.labelsize": 18,
    "legend.fontsize": 12,
    # "axes.labelcolor"     : .1,
    "text.usetex": False,
    "font.family": ["serif", "sans-serif"],
    "font.serif": ["Latin Modern Math", "Latin Modern Roman"],
    "font.sans-serif": ["Latin Modern Sans"],
    # Text in math mode
    "mathtext.fontset": "cm",
    "mathtext.default": "regular",
    "legend.frameon": False,
    "legend.framealpha": 0.5,
    # Ticks
    "xtick.direction": "in",
    "ytick.direction": "in",
    # "xtick.color"         : .1,
    # "ytick.color"         : .1,
    "xtick.minor.visible": True,
    "ytick.minor.visible": True,
    "ytick.left": True,
    "ytick.right": False,
    "xtick.top": False,
    "xtick.bottom": True,
    "xtick.major.size": 6,
    "ytick.major.size": 6,
    "xtick.minor.size": 3,
    "ytick.minor.size": 3,
    "xtick.major.pad": 8.0,
    "ytick.major.pad": 5.0,
    "axes.axisbelow": False,
    "image.cmap": "viridis",
    "grid.linestyle": "-",
    "lines.solid_capstyle": "round",
    "axes.grid": False,
    "axes.facecolor": "white",
    # "axes.edgecolor"       : .0,
    "axes.linewidth": 1,
    "axes.formatter.limits": (-4, 4),
    "axes.prop_cycle": cycler(
        "color",
        ["#348ABD", "#E24A33", "#988ED5", "#777777", "#FBC15E", "#8EBA42", "#FFB5B8"],
    ),
    "axes.formatter.use_mathtext": True,
    "axes.formatter.useoffset": False,
    "axes.labelpad": 6,
    # "grid.color"          : .8,
    "errorbar.capsize": 0,
    # "svg.hashsalt"        : 8311311
}
