/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.Flushable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.Client;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.ClientResponse;
import org.apache.hadoop.shaded.com.sun.jersey.api.client.WebResource;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class TimelineWriter
implements Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineWriter.class);
    private UserGroupInformation authUgi;
    private Client client;
    private URI resURI;

    public TimelineWriter(UserGroupInformation authUgi, Client client, URI resURI) {
        this.authUgi = authUgi;
        this.client = client;
        this.resURI = resURI;
    }

    public void close() throws Exception {
    }

    @Override
    public void flush() throws IOException {
    }

    public String toString() {
        return "Timeline writer posting to " + this.resURI;
    }

    public TimelinePutResponse putEntities(TimelineEntity ... entities) throws IOException, YarnException {
        TimelineEntities entitiesContainer = new TimelineEntities();
        for (TimelineEntity entity : entities) {
            if (entity.getEntityId() == null || entity.getEntityType() == null) {
                throw new YarnException("Incomplete entity without entity id/type");
            }
            entitiesContainer.addEntity(entity);
        }
        ClientResponse resp = this.doPosting(entitiesContainer, null);
        return (TimelinePutResponse)resp.getEntity(TimelinePutResponse.class);
    }

    public void putDomain(TimelineDomain domain) throws IOException, YarnException {
        this.doPosting(domain, "domain");
    }

    public abstract TimelinePutResponse putEntities(ApplicationAttemptId var1, TimelineEntityGroupId var2, TimelineEntity ... var3) throws IOException, YarnException;

    public abstract void putDomain(ApplicationAttemptId var1, TimelineDomain var2) throws IOException, YarnException;

    private ClientResponse doPosting(final Object obj, final String path) throws IOException, YarnException {
        ClientResponse resp;
        try {
            resp = this.authUgi.doAs(new PrivilegedExceptionAction<ClientResponse>(){

                @Override
                public ClientResponse run() throws Exception {
                    return TimelineWriter.this.doPostingObject(obj, path);
                }
            });
        }
        catch (UndeclaredThrowableException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (InterruptedException ie) {
            throw (IOException)new InterruptedIOException().initCause(ie);
        }
        if (resp == null || resp.getStatusInfo().getStatusCode() != ClientResponse.Status.OK.getStatusCode()) {
            String msg = "Failed to get the response from the timeline server.";
            LOG.error(msg);
            if (resp != null) {
                msg = msg + " HTTP error code: " + resp.getStatus();
                LOG.debug("HTTP error code: {} Server response : \n{}", (Object)resp.getStatus(), resp.getEntity(String.class));
            }
            throw new YarnException(msg);
        }
        return resp;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public ClientResponse doPostingObject(Object object, String path) {
        WebResource webResource = this.client.resource(this.resURI);
        if (path == null) {
            LOG.debug("POST to {}", (Object)this.resURI);
            ClientResponse r = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, object);
            r.bufferEntity();
            return r;
        }
        if (path.equals("domain")) {
            LOG.debug("PUT to {}/{}", (Object)this.resURI, (Object)path);
            ClientResponse r = (ClientResponse)((WebResource.Builder)webResource.path(path).accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, object);
            r.bufferEntity();
            return r;
        }
        throw new YarnRuntimeException("Unknown resource type");
    }
}

