/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.profile.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import org.opensearch.knn.profile.LongMetric;
import org.opensearch.knn.profile.query.KNNQueryTimingType;
import org.opensearch.search.profile.ProfileMetric;
import org.opensearch.search.profile.Timer;

public class KNNMetrics {
    public static final String NUM_NESTED_DOCS = "num_nested_docs";
    public static final String CARDINALITY = "cardinality";

    public static Collection<Supplier<ProfileMetric>> getKNNQueryMetrics() {
        ArrayList<Supplier<ProfileMetric>> metrics = new ArrayList<Supplier<ProfileMetric>>();
        for (KNNQueryTimingType type : KNNQueryTimingType.values()) {
            metrics.add(() -> new Timer(type.toString()));
        }
        metrics.add(() -> new LongMetric(CARDINALITY));
        return metrics;
    }

    public static Collection<Supplier<ProfileMetric>> getNativeMetrics() {
        Collection<Supplier<ProfileMetric>> metrics = KNNMetrics.getKNNQueryMetrics();
        metrics.add(() -> new LongMetric(NUM_NESTED_DOCS));
        return metrics;
    }
}

