"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityUISettings = void 0;
var _configSchema = require("@osd/config-schema");
var _i18n = require("@osd/i18n");
var _trace_analytics = require("../../common/constants/trace_analytics");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const registerObservabilityUISettings = uiSettings => {
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SPAN_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomSpanIndices.name', {
        defaultMessage: 'Trace analytics span indices'
      }),
      value: _trace_analytics.DATA_PREPPER_INDEX_NAME,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomSpanIndices.description', {
        defaultMessage: 'Configure span indices that adhere to Data Prepper schema, to be used by the trace analytics plugin'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SERVICE_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomServiceIndices.name', {
        defaultMessage: 'Trace analytics service indices'
      }),
      value: _trace_analytics.DATA_PREPPER_SERVICE_INDEX_NAME,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomServiceIndices.description', {
        defaultMessage: 'Configure service indices that adhere to Data Prepper schema, to be used by the trace analytics plugin'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_MODE_DEFAULT_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomModeDefault.name', {
        defaultMessage: 'Trace analytics default mode'
      }),
      value: false,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomModeDefault.description', {
        defaultMessage: 'Enable this to default to Data Prepper mode in the trace analytics plugin'
      }),
      schema: _configSchema.schema.boolean()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CORRELATED_LOGS_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsIndices.name', {
        defaultMessage: 'Trace analytics correlated logs indices'
      }),
      value: _trace_analytics.DEFAULT_SS4O_LOGS_INDEX,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsIndices.description', {
        defaultMessage: 'Configure correlated logs indices, to be used by the trace analytics plugin to correlate spans and services to logs'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_LOGS_FIELD_MAPPNIGS_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsFieldMappings.name', {
        defaultMessage: 'Trace analytics correlated logs fields'
      }),
      value: _trace_analytics.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsFieldMappings.description', {
        defaultMessage: 'Configure correlated logs fields, to be used by the trace analytics plugin for correlate spans and services to logs'
      }),
      schema: _configSchema.schema.object({
        serviceName: _configSchema.schema.string(),
        spanId: _configSchema.schema.string(),
        timestamp: _configSchema.schema.string(),
        traceId: _configSchema.schema.string()
      })
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_SERVICE_MAP_MAX_NODES]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsServiceMapMaxNodes.name', {
        defaultMessage: 'Trace analytics service map maximum nodes'
      }),
      value: _trace_analytics.DEFAULT_SERVICE_MAP_MAX_NODES,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsServiceMapMaxNodes.description', {
        defaultMessage: 'Set the maximum number of nodes that the trace analytics plugin should request for rendering of service maps'
      }),
      schema: _configSchema.schema.number({
        min: 1
      })
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_SERVICE_MAP_MAX_EDGES]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsServiceMapMaxEdges.name', {
        defaultMessage: 'Trace analytics service map maximum edges'
      }),
      value: _trace_analytics.DEFAULT_SERVICE_MAP_MAX_EDGES,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsServiceMapMaxEdges.description', {
        defaultMessage: 'Set the maximum number of edges that the trace analytics plugin should request for rendering of service maps'
      }),
      schema: _configSchema.schema.number({
        min: 1
      })
    }
  });
};
exports.registerObservabilityUISettings = registerObservabilityUISettings;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfY29uZmlnU2NoZW1hIiwicmVxdWlyZSIsIl9pMThuIiwiX3RyYWNlX2FuYWx5dGljcyIsInJlZ2lzdGVyT2JzZXJ2YWJpbGl0eVVJU2V0dGluZ3MiLCJ1aVNldHRpbmdzIiwicmVnaXN0ZXIiLCJUUkFDRV9DVVNUT01fU1BBTl9JTkRFWF9TRVRUSU5HIiwibmFtZSIsImkxOG4iLCJ0cmFuc2xhdGUiLCJkZWZhdWx0TWVzc2FnZSIsInZhbHVlIiwiREFUQV9QUkVQUEVSX0lOREVYX05BTUUiLCJjYXRlZ29yeSIsImRlc2NyaXB0aW9uIiwic2NoZW1hIiwic3RyaW5nIiwiVFJBQ0VfQ1VTVE9NX1NFUlZJQ0VfSU5ERVhfU0VUVElORyIsIkRBVEFfUFJFUFBFUl9TRVJWSUNFX0lOREVYX05BTUUiLCJUUkFDRV9DVVNUT01fTU9ERV9ERUZBVUxUX1NFVFRJTkciLCJib29sZWFuIiwiVFJBQ0VfQ09SUkVMQVRFRF9MT0dTX0lOREVYX1NFVFRJTkciLCJERUZBVUxUX1NTNE9fTE9HU19JTkRFWCIsIlRSQUNFX0xPR1NfRklFTERfTUFQUE5JR1NfU0VUVElORyIsIkRFRkFVTFRfQ09SUkVMQVRFRF9MT0dTX0ZJRUxEX01BUFBJTkdTIiwib2JqZWN0Iiwic2VydmljZU5hbWUiLCJzcGFuSWQiLCJ0aW1lc3RhbXAiLCJ0cmFjZUlkIiwiVFJBQ0VfU0VSVklDRV9NQVBfTUFYX05PREVTIiwiREVGQVVMVF9TRVJWSUNFX01BUF9NQVhfTk9ERVMiLCJudW1iZXIiLCJtaW4iLCJUUkFDRV9TRVJWSUNFX01BUF9NQVhfRURHRVMiLCJERUZBVUxUX1NFUlZJQ0VfTUFQX01BWF9FREdFUyIsImV4cG9ydHMiXSwic291cmNlcyI6WyJyZWdpc3Rlcl9zZXR0aW5ncy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IHNjaGVtYSB9IGZyb20gJ0Bvc2QvY29uZmlnLXNjaGVtYSc7XG5pbXBvcnQgeyBpMThuIH0gZnJvbSAnQG9zZC9pMThuJztcbmltcG9ydCB7IFVpU2V0dGluZ3NTZXJ2aWNlU2V0dXAgfSBmcm9tICcuLi8uLi8uLi8uLi9zcmMvY29yZS9zZXJ2ZXIvdWlfc2V0dGluZ3MnO1xuaW1wb3J0IHtcbiAgREFUQV9QUkVQUEVSX0lOREVYX05BTUUsXG4gIERBVEFfUFJFUFBFUl9TRVJWSUNFX0lOREVYX05BTUUsXG4gIERFRkFVTFRfQ09SUkVMQVRFRF9MT0dTX0ZJRUxEX01BUFBJTkdTLFxuICBERUZBVUxUX1NTNE9fTE9HU19JTkRFWCxcbiAgREVGQVVMVF9TRVJWSUNFX01BUF9NQVhfTk9ERVMsXG4gIERFRkFVTFRfU0VSVklDRV9NQVBfTUFYX0VER0VTLFxuICBUUkFDRV9DT1JSRUxBVEVEX0xPR1NfSU5ERVhfU0VUVElORyxcbiAgVFJBQ0VfQ1VTVE9NX01PREVfREVGQVVMVF9TRVRUSU5HLFxuICBUUkFDRV9DVVNUT01fU0VSVklDRV9JTkRFWF9TRVRUSU5HLFxuICBUUkFDRV9DVVNUT01fU1BBTl9JTkRFWF9TRVRUSU5HLFxuICBUUkFDRV9MT0dTX0ZJRUxEX01BUFBOSUdTX1NFVFRJTkcsXG4gIFRSQUNFX1NFUlZJQ0VfTUFQX01BWF9OT0RFUyxcbiAgVFJBQ0VfU0VSVklDRV9NQVBfTUFYX0VER0VTLFxufSBmcm9tICcuLi8uLi9jb21tb24vY29uc3RhbnRzL3RyYWNlX2FuYWx5dGljcyc7XG5cbmV4cG9ydCBjb25zdCByZWdpc3Rlck9ic2VydmFiaWxpdHlVSVNldHRpbmdzID0gKHVpU2V0dGluZ3M6IFVpU2V0dGluZ3NTZXJ2aWNlU2V0dXApID0+IHtcbiAgdWlTZXR0aW5ncy5yZWdpc3Rlcih7XG4gICAgW1RSQUNFX0NVU1RPTV9TUEFOX0lOREVYX1NFVFRJTkddOiB7XG4gICAgICBuYW1lOiBpMThuLnRyYW5zbGF0ZSgnb2JzZXJ2YWJpbGl0eS50cmFjZUFuYWx5dGljc0N1c3RvbVNwYW5JbmRpY2VzLm5hbWUnLCB7XG4gICAgICAgIGRlZmF1bHRNZXNzYWdlOiAnVHJhY2UgYW5hbHl0aWNzIHNwYW4gaW5kaWNlcycsXG4gICAgICB9KSxcbiAgICAgIHZhbHVlOiBEQVRBX1BSRVBQRVJfSU5ERVhfTkFNRSxcbiAgICAgIGNhdGVnb3J5OiBbJ09ic2VydmFiaWxpdHknXSxcbiAgICAgIGRlc2NyaXB0aW9uOiBpMThuLnRyYW5zbGF0ZSgnb2JzZXJ2YWJpbGl0eS50cmFjZUFuYWx5dGljc0N1c3RvbVNwYW5JbmRpY2VzLmRlc2NyaXB0aW9uJywge1xuICAgICAgICBkZWZhdWx0TWVzc2FnZTpcbiAgICAgICAgICAnQ29uZmlndXJlIHNwYW4gaW5kaWNlcyB0aGF0IGFkaGVyZSB0byBEYXRhIFByZXBwZXIgc2NoZW1hLCB0byBiZSB1c2VkIGJ5IHRoZSB0cmFjZSBhbmFseXRpY3MgcGx1Z2luJyxcbiAgICAgIH0pLFxuICAgICAgc2NoZW1hOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgfSxcbiAgfSk7XG5cbiAgdWlTZXR0aW5ncy5yZWdpc3Rlcih7XG4gICAgW1RSQUNFX0NVU1RPTV9TRVJWSUNFX0lOREVYX1NFVFRJTkddOiB7XG4gICAgICBuYW1lOiBpMThuLnRyYW5zbGF0ZSgnb2JzZXJ2YWJpbGl0eS50cmFjZUFuYWx5dGljc0N1c3RvbVNlcnZpY2VJbmRpY2VzLm5hbWUnLCB7XG4gICAgICAgIGRlZmF1bHRNZXNzYWdlOiAnVHJhY2UgYW5hbHl0aWNzIHNlcnZpY2UgaW5kaWNlcycsXG4gICAgICB9KSxcbiAgICAgIHZhbHVlOiBEQVRBX1BSRVBQRVJfU0VSVklDRV9JTkRFWF9OQU1FLFxuICAgICAgY2F0ZWdvcnk6IFsnT2JzZXJ2YWJpbGl0eSddLFxuICAgICAgZGVzY3JpcHRpb246IGkxOG4udHJhbnNsYXRlKCdvYnNlcnZhYmlsaXR5LnRyYWNlQW5hbHl0aWNzQ3VzdG9tU2VydmljZUluZGljZXMuZGVzY3JpcHRpb24nLCB7XG4gICAgICAgIGRlZmF1bHRNZXNzYWdlOlxuICAgICAgICAgICdDb25maWd1cmUgc2VydmljZSBpbmRpY2VzIHRoYXQgYWRoZXJlIHRvIERhdGEgUHJlcHBlciBzY2hlbWEsIHRvIGJlIHVzZWQgYnkgdGhlIHRyYWNlIGFuYWx5dGljcyBwbHVnaW4nLFxuICAgICAgfSksXG4gICAgICBzY2hlbWE6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICB9LFxuICB9KTtcblxuICB1aVNldHRpbmdzLnJlZ2lzdGVyKHtcbiAgICBbVFJBQ0VfQ1VTVE9NX01PREVfREVGQVVMVF9TRVRUSU5HXToge1xuICAgICAgbmFtZTogaTE4bi50cmFuc2xhdGUoJ29ic2VydmFiaWxpdHkudHJhY2VBbmFseXRpY3NDdXN0b21Nb2RlRGVmYXVsdC5uYW1lJywge1xuICAgICAgICBkZWZhdWx0TWVzc2FnZTogJ1RyYWNlIGFuYWx5dGljcyBkZWZhdWx0IG1vZGUnLFxuICAgICAgfSksXG4gICAgICB2YWx1ZTogZmFsc2UsXG4gICAgICBjYXRlZ29yeTogWydPYnNlcnZhYmlsaXR5J10sXG4gICAgICBkZXNjcmlwdGlvbjogaTE4bi50cmFuc2xhdGUoJ29ic2VydmFiaWxpdHkudHJhY2VBbmFseXRpY3NDdXN0b21Nb2RlRGVmYXVsdC5kZXNjcmlwdGlvbicsIHtcbiAgICAgICAgZGVmYXVsdE1lc3NhZ2U6ICdFbmFibGUgdGhpcyB0byBkZWZhdWx0IHRvIERhdGEgUHJlcHBlciBtb2RlIGluIHRoZSB0cmFjZSBhbmFseXRpY3MgcGx1Z2luJyxcbiAgICAgIH0pLFxuICAgICAgc2NoZW1hOiBzY2hlbWEuYm9vbGVhbigpLFxuICAgIH0sXG4gIH0pO1xuXG4gIHVpU2V0dGluZ3MucmVnaXN0ZXIoe1xuICAgIFtUUkFDRV9DT1JSRUxBVEVEX0xPR1NfSU5ERVhfU0VUVElOR106IHtcbiAgICAgIG5hbWU6IGkxOG4udHJhbnNsYXRlKCdvYnNlcnZhYmlsaXR5LnRyYWNlQW5hbHl0aWNzQ29ycmVsYXRlZExvZ3NJbmRpY2VzLm5hbWUnLCB7XG4gICAgICAgIGRlZmF1bHRNZXNzYWdlOiAnVHJhY2UgYW5hbHl0aWNzIGNvcnJlbGF0ZWQgbG9ncyBpbmRpY2VzJyxcbiAgICAgIH0pLFxuICAgICAgdmFsdWU6IERFRkFVTFRfU1M0T19MT0dTX0lOREVYLFxuICAgICAgY2F0ZWdvcnk6IFsnT2JzZXJ2YWJpbGl0eSddLFxuICAgICAgZGVzY3JpcHRpb246IGkxOG4udHJhbnNsYXRlKCdvYnNlcnZhYmlsaXR5LnRyYWNlQW5hbHl0aWNzQ29ycmVsYXRlZExvZ3NJbmRpY2VzLmRlc2NyaXB0aW9uJywge1xuICAgICAgICBkZWZhdWx0TWVzc2FnZTpcbiAgICAgICAgICAnQ29uZmlndXJlIGNvcnJlbGF0ZWQgbG9ncyBpbmRpY2VzLCB0byBiZSB1c2VkIGJ5IHRoZSB0cmFjZSBhbmFseXRpY3MgcGx1Z2luIHRvIGNvcnJlbGF0ZSBzcGFucyBhbmQgc2VydmljZXMgdG8gbG9ncycsXG4gICAgICB9KSxcbiAgICAgIHNjaGVtYTogc2NoZW1hLnN0cmluZygpLFxuICAgIH0sXG4gIH0pO1xuXG4gIHVpU2V0dGluZ3MucmVnaXN0ZXIoe1xuICAgIFtUUkFDRV9MT0dTX0ZJRUxEX01BUFBOSUdTX1NFVFRJTkddOiB7XG4gICAgICBuYW1lOiBpMThuLnRyYW5zbGF0ZSgnb2JzZXJ2YWJpbGl0eS50cmFjZUFuYWx5dGljc0NvcnJlbGF0ZWRMb2dzRmllbGRNYXBwaW5ncy5uYW1lJywge1xuICAgICAgICBkZWZhdWx0TWVzc2FnZTogJ1RyYWNlIGFuYWx5dGljcyBjb3JyZWxhdGVkIGxvZ3MgZmllbGRzJyxcbiAgICAgIH0pLFxuICAgICAgdmFsdWU6IERFRkFVTFRfQ09SUkVMQVRFRF9MT0dTX0ZJRUxEX01BUFBJTkdTLFxuICAgICAgY2F0ZWdvcnk6IFsnT2JzZXJ2YWJpbGl0eSddLFxuICAgICAgZGVzY3JpcHRpb246IGkxOG4udHJhbnNsYXRlKFxuICAgICAgICAnb2JzZXJ2YWJpbGl0eS50cmFjZUFuYWx5dGljc0NvcnJlbGF0ZWRMb2dzRmllbGRNYXBwaW5ncy5kZXNjcmlwdGlvbicsXG4gICAgICAgIHtcbiAgICAgICAgICBkZWZhdWx0TWVzc2FnZTpcbiAgICAgICAgICAgICdDb25maWd1cmUgY29ycmVsYXRlZCBsb2dzIGZpZWxkcywgdG8gYmUgdXNlZCBieSB0aGUgdHJhY2UgYW5hbHl0aWNzIHBsdWdpbiBmb3IgY29ycmVsYXRlIHNwYW5zIGFuZCBzZXJ2aWNlcyB0byBsb2dzJyxcbiAgICAgICAgfVxuICAgICAgKSxcbiAgICAgIHNjaGVtYTogc2NoZW1hLm9iamVjdCh7XG4gICAgICAgIHNlcnZpY2VOYW1lOiBzY2hlbWEuc3RyaW5nKCksXG4gICAgICAgIHNwYW5JZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgICB0aW1lc3RhbXA6IHNjaGVtYS5zdHJpbmcoKSxcbiAgICAgICAgdHJhY2VJZDogc2NoZW1hLnN0cmluZygpLFxuICAgICAgfSksXG4gICAgfSxcbiAgfSk7XG5cbiAgdWlTZXR0aW5ncy5yZWdpc3Rlcih7XG4gICAgW1RSQUNFX1NFUlZJQ0VfTUFQX01BWF9OT0RFU106IHtcbiAgICAgIG5hbWU6IGkxOG4udHJhbnNsYXRlKCdvYnNlcnZhYmlsaXR5LnRyYWNlQW5hbHl0aWNzU2VydmljZU1hcE1heE5vZGVzLm5hbWUnLCB7XG4gICAgICAgIGRlZmF1bHRNZXNzYWdlOiAnVHJhY2UgYW5hbHl0aWNzIHNlcnZpY2UgbWFwIG1heGltdW0gbm9kZXMnLFxuICAgICAgfSksXG4gICAgICB2YWx1ZTogREVGQVVMVF9TRVJWSUNFX01BUF9NQVhfTk9ERVMsXG4gICAgICBjYXRlZ29yeTogWydPYnNlcnZhYmlsaXR5J10sXG4gICAgICBkZXNjcmlwdGlvbjogaTE4bi50cmFuc2xhdGUoJ29ic2VydmFiaWxpdHkudHJhY2VBbmFseXRpY3NTZXJ2aWNlTWFwTWF4Tm9kZXMuZGVzY3JpcHRpb24nLCB7XG4gICAgICAgIGRlZmF1bHRNZXNzYWdlOlxuICAgICAgICAgICdTZXQgdGhlIG1heGltdW0gbnVtYmVyIG9mIG5vZGVzIHRoYXQgdGhlIHRyYWNlIGFuYWx5dGljcyBwbHVnaW4gc2hvdWxkIHJlcXVlc3QgZm9yIHJlbmRlcmluZyBvZiBzZXJ2aWNlIG1hcHMnLFxuICAgICAgfSksXG4gICAgICBzY2hlbWE6IHNjaGVtYS5udW1iZXIoe1xuICAgICAgICBtaW46IDEsXG4gICAgICB9KSxcbiAgICB9LFxuICB9KTtcblxuICB1aVNldHRpbmdzLnJlZ2lzdGVyKHtcbiAgICBbVFJBQ0VfU0VSVklDRV9NQVBfTUFYX0VER0VTXToge1xuICAgICAgbmFtZTogaTE4bi50cmFuc2xhdGUoJ29ic2VydmFiaWxpdHkudHJhY2VBbmFseXRpY3NTZXJ2aWNlTWFwTWF4RWRnZXMubmFtZScsIHtcbiAgICAgICAgZGVmYXVsdE1lc3NhZ2U6ICdUcmFjZSBhbmFseXRpY3Mgc2VydmljZSBtYXAgbWF4aW11bSBlZGdlcycsXG4gICAgICB9KSxcbiAgICAgIHZhbHVlOiBERUZBVUxUX1NFUlZJQ0VfTUFQX01BWF9FREdFUyxcbiAgICAgIGNhdGVnb3J5OiBbJ09ic2VydmFiaWxpdHknXSxcbiAgICAgIGRlc2NyaXB0aW9uOiBpMThuLnRyYW5zbGF0ZSgnb2JzZXJ2YWJpbGl0eS50cmFjZUFuYWx5dGljc1NlcnZpY2VNYXBNYXhFZGdlcy5kZXNjcmlwdGlvbicsIHtcbiAgICAgICAgZGVmYXVsdE1lc3NhZ2U6XG4gICAgICAgICAgJ1NldCB0aGUgbWF4aW11bSBudW1iZXIgb2YgZWRnZXMgdGhhdCB0aGUgdHJhY2UgYW5hbHl0aWNzIHBsdWdpbiBzaG91bGQgcmVxdWVzdCBmb3IgcmVuZGVyaW5nIG9mIHNlcnZpY2UgbWFwcycsXG4gICAgICB9KSxcbiAgICAgIHNjaGVtYTogc2NoZW1hLm51bWJlcih7XG4gICAgICAgIG1pbjogMSxcbiAgICAgIH0pLFxuICAgIH0sXG4gIH0pO1xufTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBS0EsSUFBQUEsYUFBQSxHQUFBQyxPQUFBO0FBQ0EsSUFBQUMsS0FBQSxHQUFBRCxPQUFBO0FBRUEsSUFBQUUsZ0JBQUEsR0FBQUYsT0FBQTtBQVJBO0FBQ0E7QUFDQTtBQUNBOztBQXFCTyxNQUFNRywrQkFBK0IsR0FBSUMsVUFBa0MsSUFBSztFQUNyRkEsVUFBVSxDQUFDQyxRQUFRLENBQUM7SUFDbEIsQ0FBQ0MsZ0RBQStCLEdBQUc7TUFDakNDLElBQUksRUFBRUMsVUFBSSxDQUFDQyxTQUFTLENBQUMsb0RBQW9ELEVBQUU7UUFDekVDLGNBQWMsRUFBRTtNQUNsQixDQUFDLENBQUM7TUFDRkMsS0FBSyxFQUFFQyx3Q0FBdUI7TUFDOUJDLFFBQVEsRUFBRSxDQUFDLGVBQWUsQ0FBQztNQUMzQkMsV0FBVyxFQUFFTixVQUFJLENBQUNDLFNBQVMsQ0FBQywyREFBMkQsRUFBRTtRQUN2RkMsY0FBYyxFQUNaO01BQ0osQ0FBQyxDQUFDO01BQ0ZLLE1BQU0sRUFBRUEsb0JBQU0sQ0FBQ0MsTUFBTSxDQUFDO0lBQ3hCO0VBQ0YsQ0FBQyxDQUFDO0VBRUZaLFVBQVUsQ0FBQ0MsUUFBUSxDQUFDO0lBQ2xCLENBQUNZLG1EQUFrQyxHQUFHO01BQ3BDVixJQUFJLEVBQUVDLFVBQUksQ0FBQ0MsU0FBUyxDQUFDLHVEQUF1RCxFQUFFO1FBQzVFQyxjQUFjLEVBQUU7TUFDbEIsQ0FBQyxDQUFDO01BQ0ZDLEtBQUssRUFBRU8sZ0RBQStCO01BQ3RDTCxRQUFRLEVBQUUsQ0FBQyxlQUFlLENBQUM7TUFDM0JDLFdBQVcsRUFBRU4sVUFBSSxDQUFDQyxTQUFTLENBQUMsOERBQThELEVBQUU7UUFDMUZDLGNBQWMsRUFDWjtNQUNKLENBQUMsQ0FBQztNQUNGSyxNQUFNLEVBQUVBLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztJQUN4QjtFQUNGLENBQUMsQ0FBQztFQUVGWixVQUFVLENBQUNDLFFBQVEsQ0FBQztJQUNsQixDQUFDYyxrREFBaUMsR0FBRztNQUNuQ1osSUFBSSxFQUFFQyxVQUFJLENBQUNDLFNBQVMsQ0FBQyxvREFBb0QsRUFBRTtRQUN6RUMsY0FBYyxFQUFFO01BQ2xCLENBQUMsQ0FBQztNQUNGQyxLQUFLLEVBQUUsS0FBSztNQUNaRSxRQUFRLEVBQUUsQ0FBQyxlQUFlLENBQUM7TUFDM0JDLFdBQVcsRUFBRU4sVUFBSSxDQUFDQyxTQUFTLENBQUMsMkRBQTJELEVBQUU7UUFDdkZDLGNBQWMsRUFBRTtNQUNsQixDQUFDLENBQUM7TUFDRkssTUFBTSxFQUFFQSxvQkFBTSxDQUFDSyxPQUFPLENBQUM7SUFDekI7RUFDRixDQUFDLENBQUM7RUFFRmhCLFVBQVUsQ0FBQ0MsUUFBUSxDQUFDO0lBQ2xCLENBQUNnQixvREFBbUMsR0FBRztNQUNyQ2QsSUFBSSxFQUFFQyxVQUFJLENBQUNDLFNBQVMsQ0FBQyx3REFBd0QsRUFBRTtRQUM3RUMsY0FBYyxFQUFFO01BQ2xCLENBQUMsQ0FBQztNQUNGQyxLQUFLLEVBQUVXLHdDQUF1QjtNQUM5QlQsUUFBUSxFQUFFLENBQUMsZUFBZSxDQUFDO01BQzNCQyxXQUFXLEVBQUVOLFVBQUksQ0FBQ0MsU0FBUyxDQUFDLCtEQUErRCxFQUFFO1FBQzNGQyxjQUFjLEVBQ1o7TUFDSixDQUFDLENBQUM7TUFDRkssTUFBTSxFQUFFQSxvQkFBTSxDQUFDQyxNQUFNLENBQUM7SUFDeEI7RUFDRixDQUFDLENBQUM7RUFFRlosVUFBVSxDQUFDQyxRQUFRLENBQUM7SUFDbEIsQ0FBQ2tCLGtEQUFpQyxHQUFHO01BQ25DaEIsSUFBSSxFQUFFQyxVQUFJLENBQUNDLFNBQVMsQ0FBQyw4REFBOEQsRUFBRTtRQUNuRkMsY0FBYyxFQUFFO01BQ2xCLENBQUMsQ0FBQztNQUNGQyxLQUFLLEVBQUVhLHVEQUFzQztNQUM3Q1gsUUFBUSxFQUFFLENBQUMsZUFBZSxDQUFDO01BQzNCQyxXQUFXLEVBQUVOLFVBQUksQ0FBQ0MsU0FBUyxDQUN6QixxRUFBcUUsRUFDckU7UUFDRUMsY0FBYyxFQUNaO01BQ0osQ0FDRixDQUFDO01BQ0RLLE1BQU0sRUFBRUEsb0JBQU0sQ0FBQ1UsTUFBTSxDQUFDO1FBQ3BCQyxXQUFXLEVBQUVYLG9CQUFNLENBQUNDLE1BQU0sQ0FBQyxDQUFDO1FBQzVCVyxNQUFNLEVBQUVaLG9CQUFNLENBQUNDLE1BQU0sQ0FBQyxDQUFDO1FBQ3ZCWSxTQUFTLEVBQUViLG9CQUFNLENBQUNDLE1BQU0sQ0FBQyxDQUFDO1FBQzFCYSxPQUFPLEVBQUVkLG9CQUFNLENBQUNDLE1BQU0sQ0FBQztNQUN6QixDQUFDO0lBQ0g7RUFDRixDQUFDLENBQUM7RUFFRlosVUFBVSxDQUFDQyxRQUFRLENBQUM7SUFDbEIsQ0FBQ3lCLDRDQUEyQixHQUFHO01BQzdCdkIsSUFBSSxFQUFFQyxVQUFJLENBQUNDLFNBQVMsQ0FBQyxxREFBcUQsRUFBRTtRQUMxRUMsY0FBYyxFQUFFO01BQ2xCLENBQUMsQ0FBQztNQUNGQyxLQUFLLEVBQUVvQiw4Q0FBNkI7TUFDcENsQixRQUFRLEVBQUUsQ0FBQyxlQUFlLENBQUM7TUFDM0JDLFdBQVcsRUFBRU4sVUFBSSxDQUFDQyxTQUFTLENBQUMsNERBQTRELEVBQUU7UUFDeEZDLGNBQWMsRUFDWjtNQUNKLENBQUMsQ0FBQztNQUNGSyxNQUFNLEVBQUVBLG9CQUFNLENBQUNpQixNQUFNLENBQUM7UUFDcEJDLEdBQUcsRUFBRTtNQUNQLENBQUM7SUFDSDtFQUNGLENBQUMsQ0FBQztFQUVGN0IsVUFBVSxDQUFDQyxRQUFRLENBQUM7SUFDbEIsQ0FBQzZCLDRDQUEyQixHQUFHO01BQzdCM0IsSUFBSSxFQUFFQyxVQUFJLENBQUNDLFNBQVMsQ0FBQyxxREFBcUQsRUFBRTtRQUMxRUMsY0FBYyxFQUFFO01BQ2xCLENBQUMsQ0FBQztNQUNGQyxLQUFLLEVBQUV3Qiw4Q0FBNkI7TUFDcEN0QixRQUFRLEVBQUUsQ0FBQyxlQUFlLENBQUM7TUFDM0JDLFdBQVcsRUFBRU4sVUFBSSxDQUFDQyxTQUFTLENBQUMsNERBQTRELEVBQUU7UUFDeEZDLGNBQWMsRUFDWjtNQUNKLENBQUMsQ0FBQztNQUNGSyxNQUFNLEVBQUVBLG9CQUFNLENBQUNpQixNQUFNLENBQUM7UUFDcEJDLEdBQUcsRUFBRTtNQUNQLENBQUM7SUFDSDtFQUNGLENBQUMsQ0FBQztBQUNKLENBQUM7QUFBQ0csT0FBQSxDQUFBakMsK0JBQUEsR0FBQUEsK0JBQUEifQ==