/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.search.internal.ReaderContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.transport.TransportRequest;

@PublicApi(since="1.0.0")
public interface SearchOperationListener {
    default public void onPreQueryPhase(SearchContext searchContext) {
    }

    default public void onFailedQueryPhase(SearchContext searchContext) {
    }

    default public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
    }

    default public void onPreSliceExecution(SearchContext searchContext) {
    }

    default public void onFailedSliceExecution(SearchContext searchContext) {
    }

    default public void onSliceExecution(SearchContext searchContext) {
    }

    default public void onPreFetchPhase(SearchContext searchContext) {
    }

    default public void onFailedFetchPhase(SearchContext searchContext) {
    }

    default public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
    }

    default public void onNewReaderContext(ReaderContext readerContext) {
    }

    default public void onFreeReaderContext(ReaderContext readerContext) {
    }

    default public void onNewScrollContext(ReaderContext readerContext) {
    }

    default public void onFreeScrollContext(ReaderContext readerContext) {
    }

    default public void validateReaderContext(ReaderContext readerContext, TransportRequest transportRequest) {
    }

    default public void onNewPitContext(ReaderContext readerContext) {
    }

    default public void onFreePitContext(ReaderContext readerContext) {
    }

    default public void onSearchIdleReactivation() {
    }

    public static final class CompositeListener
    implements SearchOperationListener {
        private final List<SearchOperationListener> listeners;
        private final Logger logger;

        CompositeListener(List<SearchOperationListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        public void onPreQueryPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onPreQueryPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPreQueryPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFailedQueryPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFailedQueryPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFailedQueryPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onQueryPhase(searchContext, tookInNanos);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onQueryPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onPreSliceExecution(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onPreSliceExecution(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPreSliceExecution listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFailedSliceExecution(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFailedSliceExecution(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFailedSliceExecution listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onSliceExecution(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onSliceExecution(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onSliceExecution listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onPreFetchPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onPreFetchPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPreFetchPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFailedFetchPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFailedFetchPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFailedFetchPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFetchPhase(searchContext, tookInNanos);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFetchPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onNewReaderContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onNewReaderContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onNewContext listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFreeReaderContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFreeReaderContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFreeContext listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onNewScrollContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onNewScrollContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onNewScrollContext listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFreeScrollContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFreeScrollContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFreeScrollContext listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void validateReaderContext(ReaderContext readerContext, TransportRequest request) {
            Exception exception = null;
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.validateReaderContext(readerContext, request);
                }
                catch (Exception e) {
                    exception = (Exception)ExceptionsHelper.useOrSuppress(exception, (Throwable)e);
                }
            }
            ExceptionsHelper.reThrowIfNotNull(exception);
        }

        @Override
        public void onNewPitContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onNewPitContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn("onNewPitContext listener failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onFreePitContext(ReaderContext readerContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFreePitContext(readerContext);
                }
                catch (Exception e) {
                    this.logger.warn("onFreePitContext listener failed", (Throwable)e);
                }
            }
        }

        @Override
        public void onSearchIdleReactivation() {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onSearchIdleReactivation();
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onNewSearchIdleReactivation listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }
    }
}

