/*
 * Decompiled with CFR 0.152.
 */
package io.setl.rdf.normalization;

import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfValue;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class IdentifierIssuer {
    private final LinkedHashMap<RdfResource, RdfResource> existing = new LinkedHashMap();
    private final String prefix;
    private int counter = 0;

    public IdentifierIssuer(String prefix) {
        this.prefix = prefix;
    }

    public void assign(IdentifierIssuer other) {
        this.existing.forEach((k, v) -> other.getId((RdfResource)k));
    }

    public IdentifierIssuer copy() {
        IdentifierIssuer newIssuer = new IdentifierIssuer(this.prefix);
        newIssuer.existing.putAll(this.existing);
        newIssuer.counter = this.counter;
        return newIssuer;
    }

    private RdfResource getForBlank(RdfResource value, AtomicBoolean flag) {
        if (this.hasId(value)) {
            flag.set(true);
            return this.getId(value);
        }
        return value;
    }

    public RdfResource getId(RdfResource id) {
        return this.existing.computeIfAbsent(id, k -> Rdf.createBlankNode((String)(this.prefix + this.counter++)));
    }

    public RdfResource getIfExists(RdfResource value, AtomicBoolean flag) {
        return value != null && value.isBlankNode() ? this.getForBlank(value, flag) : value;
    }

    RdfValue getIfExists(RdfValue value, AtomicBoolean flag) {
        return value != null && value.isBlankNode() ? this.getForBlank((RdfResource)value, flag) : value;
    }

    public boolean hasId(RdfResource id) {
        return this.existing.containsKey(id);
    }
}

